// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkAbstractPointLocator.h"

#include "vtkDataSet.h"
#include "vtkIdList.h"

//------------------------------------------------------------------------------
VTK_ABI_NAMESPACE_BEGIN
vtkAbstractPointLocator::vtkAbstractPointLocator()
{
  for (int i = 0; i < 6; i++)
  {
    this->Bounds[i] = 0;
  }
  this->NumberOfBuckets = 0;
}

//------------------------------------------------------------------------------
vtkAbstractPointLocator::~vtkAbstractPointLocator() = default;

//------------------------------------------------------------------------------
// Given a position x-y-z, return the id of the point closest to it.
vtkIdType vtkAbstractPointLocator::FindClosestPoint(double x, double y, double z)
{
  double xyz[3];

  xyz[0] = x;
  xyz[1] = y;
  xyz[2] = z;
  return this->FindClosestPoint(xyz);
}

//------------------------------------------------------------------------------
void vtkAbstractPointLocator::FindClosestNPoints(
  int N, double x, double y, double z, vtkIdList* result)
{
  double p[3];
  p[0] = x;
  p[1] = y;
  p[2] = z;
  this->FindClosestNPoints(N, p, result);
}

//------------------------------------------------------------------------------
void vtkAbstractPointLocator::FindPointsWithinRadius(
  double R, double x, double y, double z, vtkIdList* result)
{
  double p[3];
  p[0] = x;
  p[1] = y;
  p[2] = z;
  this->FindPointsWithinRadius(R, p, result);
}

//------------------------------------------------------------------------------
void vtkAbstractPointLocator::GetBounds(double* bnds)
{
  for (int i = 0; i < 6; i++)
  {
    bnds[i] = this->Bounds[i];
  }
}

//------------------------------------------------------------------------------
void vtkAbstractPointLocator::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);

  for (int i = 0; i < 6; i++)
  {
    os << indent << "Bounds[" << i << "]: " << this->Bounds[i] << "\n";
  }

  os << indent << "Number of Buckets: " << this->NumberOfBuckets << "\n";
}
VTK_ABI_NAMESPACE_END
