# !

> Reuse and expand the shell history in `sh`, Bash, Zsh, `rbash`, and `ksh`.
> See also: `^`.
> More information: <https://gnu.org/software/bash/manual/bash.html#Event-Designators>.

- Substitute with the previous command and run it with `sudo`:

`sudo !!`

- Substitute with a command based on its line number found with `history`:

`!{{number}}`

- Substitute with a command that was used a specified number of lines back:

`!-{{number}}`

- Substitute with the most recent command that starts with a string:

`!{{string}}`

- Substitute with all of the arguments of the latest command:

`{{command}} !*`

- Substitute with the last argument of the latest command:

`{{command}} !$`

- Substitute with the last command but without the last argument:

`!:-`

- Print last command that starts with a string without executing it:

`!{{string}}:p`
