# 2to3

> Conversão automática de código Python 2 para Python 3.
> Esse módulo foi descontinuado no Python 3.11 e foi removido na versão 3.13.
> Referência: <https://github.com/python/cpython/blob/8d42e2d915c3096e7eac1c649751d1da567bb7c3/Doc/whatsnew/3.13.rst?plain=1#L188>.
> Mais informações: <https://manned.org/2to3>.

- Mostra as alterações que seriam feitas sem faze-las de fato (simulação):

`2to3 {{caminho/para/arquivo.py}}`

- Converte um arquivo feito em Python 2 para Python 3:

`2to3 {{[-w|--write]}} {{caminho/para/arquivo.py}}`

- Converte recurso específico de Python 2 para Python 3:

`2to3 {{[-w|--write]}} {{caminho/para/arquivo.py}} {{[-f|--fix]}} {{raw_input}} {{[-f|--fix]}} {{print}}`

- Converte todos os recursos de Python 2 para Python 3, exceto as que específicadas:

`2to3 {{[-w|--write]}} {{caminho/para/arquivo.py}} {{[-x|--nofix]}} {{has_key}} {{[-x|--nofix]}} {{isinstance}}`

- Mostra a lista de todas os recursos disponíveis que podem ser convertidas de Python 2 para Python 3:

`2to3 {{[-l|--list-fixes]}}`

- Converte todos os arquivos feitos em Python 2 em um diretório para Python 3:

`2to3 {{[-o|--output-dir]}} {{caminho/para/arquivos_python3}} {{[-W|--write-unchanged-files]}} {{[-n|--nobackups]}} {{caminho/para/arquivos_python2}}`

- Executa 2to3 com múltiplas threads:

`2to3 {{[-j|--processes]}} {{4}} {{[-o|--output-dir]}} {{caminho/para/arquivos_python3}} {{[-w|--write]}} {{[-n|--nobackups]}} --no-diffs {{caminho/para/arquivos_python2}}`
