## 6.0.12.20250809 (2025-08-09)

Mark stub-only private symbols as `@type_check_only` in third-party stubs (#14545)

## 6.0.12.20250516 (2025-05-16)

Replace `Incomplete | None = None` in third party stubs (#14063)

## 6.0.12.20250402 (2025-04-02)

Bump ruff to 0.11.2 (#13757)

## 6.0.12.20250326 (2025-03-26)

Add `__all__` (#13704)

## 6.0.12.20241230 (2024-12-30)

fix(yaml): SafeConstructor.construct_scalar accept `MappingNode` (#13340)

## 6.0.12.20241221 (2024-12-21)

Update to mypy 1.14 (#13272)

## 6.0.12.20240917 (2024-09-17)

PyYAML: correct return type of `construct_scalar()` (#12664)

## 6.0.12.20240808 (2024-08-08)

[PyYAML] stubtest: Ignore auto-generated methods (#12497)

## 6.0.12.20240724 (2024-07-24)

Improve `yaml/constructor.pyi` types (#12404)

## 6.0.12.20240311 (2024-03-11)

Use PEP 570 syntax in third party stubs (#11554)

## 6.0.12.12 (2023-09-23)

[PyYAML] type the whole Emitter class (#10750)

## 6.0.12.11 (2023-07-20)

Add an upstream_repository field to METADATA.toml (#10487)

Closes: #10478

## 6.0.12.10 (2023-05-22)

[PyYAML] Improve dump/serialize types (#10196)

* Add overloads to return `str` or `bytes`, instead of `Any`.
* Mark some arguments as keyword-only.
* Add missing default values.

## 6.0.12.9 (2023-03-27)

Add default values for third-party stubs beginning with 'P' (#9957)

## 6.0.12.8 (2023-02-21)

Stubtest settings: change `ignore_missing_stub` default to `false` (#9779)

If you're reading about this commit from an autogenerated changelog entry, this should have no user-visible impact on how the stubs are interpreted by a type checker; it's just an internal change to how typeshed's tests work.

## 6.0.12.7 (2023-02-19)

Type `Loader` parameter in `PyYAML/yaml` (#9752)

## 6.0.12.6 (2023-02-13)

[PyYAML] Accept all iterables for dump_all functions (#9725)

## 6.0.12.5 (2023-02-09)

yaml: allow ReadableBuffer in represent_binary (#9701)

## 6.0.12.4 (2023-02-02)

Manual changes of `Any` union to `Incomplete` in stubs folder (#9566)

- ClassVar[Any | None]
- Missed previous changes due to alias
- Manual review of leftover Any unions (`| Any` and `Any |`)

## 6.0.12.3 (2023-01-18)

Replace `Any` with `Incomplete` in many places (#9558)

## 6.0.12.2 (2022-11-09)

PyYAML: Permit `width: float` for pure-Python `dump(...)` (#8973)

* PyYAML: Permit `width: float` for pure-Python `dump(...)`

To prevent `PyYAML` from wrapping *any* lines, it's possible to pass
`width=float("inf")`, but the current type hints don't like that.  This
works at runtime:

    >>> s = yaml.dump({"foo": "bar" * 1000}, width=float("inf"))
    >>> print(s)
    foo: barbarbarbarbarbarbarbarbarbarbarbarbarbarbarbarbarbar...

but `mypy` says

    floatwidth.py:2: error: No overload variant of "dump" matches argument types "Dict[str, str]", "float"
    floatwidth.py:2: note: Possible overload variants:
    floatwidth.py:2: note:     def dump(data: Any, stream: _WriteStream[Any], Dumper: Any = ..., *, default_style: Optional[str] = ..., default_flow_style: Optional[bool] = ..., canonical: Optional[bool] = ..., indent: Optional[int] = ..., width: Optional[int] = ..., allow_unicode: Optional[bool] = ..., line_break: Optional[str] = ..., encoding: Optional[str] = ..., explicit_start: Optional[bool] = ..., explicit_end: Optional[bool] = ..., version: Optional[Tuple[int, int]] = ..., tags: Optional[Mapping[str, str]] = ..., sort_keys: bool = ...) -> None
    floatwidth.py:2: note:     def dump(data: Any, stream: None = ..., Dumper: Any = ..., *, default_style: Optional[str] = ..., default_flow_style: Optional[bool] = ..., canonical: Optional[bool] = ..., indent: Optional[int] = ..., width: Optional[int] = ..., allow_unicode: Optional[bool] = ..., line_break: Optional[str] = ..., encoding: Optional[str] = ..., explicit_start: Optional[bool] = ..., explicit_end: Optional[bool] = ..., version: Optional[Tuple[int, int]] = ..., tags: Optional[Mapping[str, str]] = ..., sort_keys: bool = ...) -> Any
    Found 1 error in 1 file (checked 1 source file)

Poking through the `PyYAML` source, it looks the `width` parameter
could probably be anything "comparable", as it's only compared via
the `<` operator[1].

For the LibYAML implementation, however, we have to use `int`s:

    >>> stream = StringIO()
    >>> dumper = yaml.CDumper(stream, width=float("inf"))
    Traceback (most recent call last):
      File "<stdin>", line 1, in <module>
      File "/usr/lib/python3/dist-packages/yaml/cyaml.py", line 81, in __init__
        version=version, tags=tags)
      File "ext/_yaml.pyx", line 973, in _yaml.CEmitter.__init__ (ext/_yaml.c:14797)
    OverflowError: cannot convert float infinity to integer

## 6.0.12.1 (2022-10-26)

Add a couple of missing type hints in pyyaml.constructor (#8965)

## 6.0.12 (2022-09-27)

Bump mypy to 0.981 (#8796)

## 6.0.11 (2022-07-24)

`PyYaml`’s Serializer: annotate `open`, `close`, `serialize` (#8383)

As seen here:
https://github.com/yaml/pyyaml/blob/master/lib/yaml/serializer.py#L27-L41

Neither `open` nor `close` methods return, so `None` added as the return type.

Finally, serialize accepts a Node and does not return as seen here:
https://github.com/yaml/pyyaml/blob/master/lib/yaml/serializer.py#L46-L58

## 6.0.10 (2022-07-12)

Import `Match` and `Pattern` from `re`, not `typing` (#8277)

## 6.0.9 (2022-06-25)

PyYAML: check missing defs (#8159)

## 6.0.8 (2022-06-01)

PyYAML: Add types to `add_constructor` (#7989)

## 6.0.7 (2022-04-20)

Use `TypeAlias` for type aliases where possible, part II (#7667)

## 6.0.6 (2022-04-16)

Use `TypeAlias` where possible for type aliases (#7630)

## 6.0.5 (2022-03-16)

Use PEP 604 syntax wherever possible (#7493)

## 6.0.4 (2022-01-31)

Replace IO with protocols (#7092)

## 6.0.3 (2022-01-08)

Use lowercase `type` everywhere (#6853)

## 6.0.1 (2021-11-12)

Add more type hints for pyyaml (#6265)

## 6.0.0 (2021-10-22)

Upgrade PyYAML to version 6 (#6183)

* Fix load_all() argument
* Remove Python 2 remnants
  + Replace Text with str
  + Replace alias "_Str" with str
  + Import from collections.abc and re where applicable
  + Remove Python 2 branches
* Fix PyYaml allowlist entries
  + Add yaml._yaml and move CParser and CEmitter there.
  + Add missing functions, classes, and arguments.
* Use relative imports in some modules.
* Add __all__ to yaml.cyaml.
* Remove unnecessary noqa markers.

## 5.4.12 (2021-10-15)

Use lowercase tuple where possible (#6170)

## 5.4.11 (2021-10-12)

Add star to all non-0.1 versions (#6146)

## 5.4.10 (2021-09-01)

Delete yaml.CDangerLoader and yaml.CDangerDumper (#5990)

These no longer exist in PyYAML 4.2.

## 5.4.9 (2021-09-01)

Add C{Full,Unsafe}Loader and UnsafeConstructor (#5988)

