/* Copyright 2022 - 2025 R. Thomas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_ASM_POWERPC_REGISTER_H
#define LIEF_ASM_POWERPC_REGISTER_H
namespace LIEF {
namespace assembly {
namespace powerpc {
enum class REG;
const char* get_register_name(REG r);

enum class REG {
  NoRegister = 0,
  BP = 1,
  CARRY = 2,
  CTR = 3,
  FP = 4,
  LR = 5,
  RM = 6,
  SPEFSCR = 7,
  VRSAVE = 8,
  XER = 9,
  ZERO = 10,
  ACC0 = 11,
  ACC1 = 12,
  ACC2 = 13,
  ACC3 = 14,
  ACC4 = 15,
  ACC5 = 16,
  ACC6 = 17,
  ACC7 = 18,
  BP8 = 19,
  CR0 = 20,
  CR1 = 21,
  CR2 = 22,
  CR3 = 23,
  CR4 = 24,
  CR5 = 25,
  CR6 = 26,
  CR7 = 27,
  CTR8 = 28,
  DMR0 = 29,
  DMR1 = 30,
  DMR2 = 31,
  DMR3 = 32,
  DMR4 = 33,
  DMR5 = 34,
  DMR6 = 35,
  DMR7 = 36,
  DMRROW0 = 37,
  DMRROW1 = 38,
  DMRROW2 = 39,
  DMRROW3 = 40,
  DMRROW4 = 41,
  DMRROW5 = 42,
  DMRROW6 = 43,
  DMRROW7 = 44,
  DMRROW8 = 45,
  DMRROW9 = 46,
  DMRROW10 = 47,
  DMRROW11 = 48,
  DMRROW12 = 49,
  DMRROW13 = 50,
  DMRROW14 = 51,
  DMRROW15 = 52,
  DMRROW16 = 53,
  DMRROW17 = 54,
  DMRROW18 = 55,
  DMRROW19 = 56,
  DMRROW20 = 57,
  DMRROW21 = 58,
  DMRROW22 = 59,
  DMRROW23 = 60,
  DMRROW24 = 61,
  DMRROW25 = 62,
  DMRROW26 = 63,
  DMRROW27 = 64,
  DMRROW28 = 65,
  DMRROW29 = 66,
  DMRROW30 = 67,
  DMRROW31 = 68,
  DMRROW32 = 69,
  DMRROW33 = 70,
  DMRROW34 = 71,
  DMRROW35 = 72,
  DMRROW36 = 73,
  DMRROW37 = 74,
  DMRROW38 = 75,
  DMRROW39 = 76,
  DMRROW40 = 77,
  DMRROW41 = 78,
  DMRROW42 = 79,
  DMRROW43 = 80,
  DMRROW44 = 81,
  DMRROW45 = 82,
  DMRROW46 = 83,
  DMRROW47 = 84,
  DMRROW48 = 85,
  DMRROW49 = 86,
  DMRROW50 = 87,
  DMRROW51 = 88,
  DMRROW52 = 89,
  DMRROW53 = 90,
  DMRROW54 = 91,
  DMRROW55 = 92,
  DMRROW56 = 93,
  DMRROW57 = 94,
  DMRROW58 = 95,
  DMRROW59 = 96,
  DMRROW60 = 97,
  DMRROW61 = 98,
  DMRROW62 = 99,
  DMRROW63 = 100,
  DMRROWp0 = 101,
  DMRROWp1 = 102,
  DMRROWp2 = 103,
  DMRROWp3 = 104,
  DMRROWp4 = 105,
  DMRROWp5 = 106,
  DMRROWp6 = 107,
  DMRROWp7 = 108,
  DMRROWp8 = 109,
  DMRROWp9 = 110,
  DMRROWp10 = 111,
  DMRROWp11 = 112,
  DMRROWp12 = 113,
  DMRROWp13 = 114,
  DMRROWp14 = 115,
  DMRROWp15 = 116,
  DMRROWp16 = 117,
  DMRROWp17 = 118,
  DMRROWp18 = 119,
  DMRROWp19 = 120,
  DMRROWp20 = 121,
  DMRROWp21 = 122,
  DMRROWp22 = 123,
  DMRROWp23 = 124,
  DMRROWp24 = 125,
  DMRROWp25 = 126,
  DMRROWp26 = 127,
  DMRROWp27 = 128,
  DMRROWp28 = 129,
  DMRROWp29 = 130,
  DMRROWp30 = 131,
  DMRROWp31 = 132,
  DMRp0 = 133,
  DMRp1 = 134,
  DMRp2 = 135,
  DMRp3 = 136,
  F0 = 137,
  F1 = 138,
  F2 = 139,
  F3 = 140,
  F4 = 141,
  F5 = 142,
  F6 = 143,
  F7 = 144,
  F8 = 145,
  F9 = 146,
  F10 = 147,
  F11 = 148,
  F12 = 149,
  F13 = 150,
  F14 = 151,
  F15 = 152,
  F16 = 153,
  F17 = 154,
  F18 = 155,
  F19 = 156,
  F20 = 157,
  F21 = 158,
  F22 = 159,
  F23 = 160,
  F24 = 161,
  F25 = 162,
  F26 = 163,
  F27 = 164,
  F28 = 165,
  F29 = 166,
  F30 = 167,
  F31 = 168,
  FH0 = 169,
  FH1 = 170,
  FH2 = 171,
  FH3 = 172,
  FH4 = 173,
  FH5 = 174,
  FH6 = 175,
  FH7 = 176,
  FH8 = 177,
  FH9 = 178,
  FH10 = 179,
  FH11 = 180,
  FH12 = 181,
  FH13 = 182,
  FH14 = 183,
  FH15 = 184,
  FH16 = 185,
  FH17 = 186,
  FH18 = 187,
  FH19 = 188,
  FH20 = 189,
  FH21 = 190,
  FH22 = 191,
  FH23 = 192,
  FH24 = 193,
  FH25 = 194,
  FH26 = 195,
  FH27 = 196,
  FH28 = 197,
  FH29 = 198,
  FH30 = 199,
  FH31 = 200,
  FP8 = 201,
  Fpair0 = 202,
  Fpair2 = 203,
  Fpair4 = 204,
  Fpair6 = 205,
  Fpair8 = 206,
  Fpair10 = 207,
  Fpair12 = 208,
  Fpair14 = 209,
  Fpair16 = 210,
  Fpair18 = 211,
  Fpair20 = 212,
  Fpair22 = 213,
  Fpair24 = 214,
  Fpair26 = 215,
  Fpair28 = 216,
  Fpair30 = 217,
  H0 = 218,
  H1 = 219,
  H2 = 220,
  H3 = 221,
  H4 = 222,
  H5 = 223,
  H6 = 224,
  H7 = 225,
  H8 = 226,
  H9 = 227,
  H10 = 228,
  H11 = 229,
  H12 = 230,
  H13 = 231,
  H14 = 232,
  H15 = 233,
  H16 = 234,
  H17 = 235,
  H18 = 236,
  H19 = 237,
  H20 = 238,
  H21 = 239,
  H22 = 240,
  H23 = 241,
  H24 = 242,
  H25 = 243,
  H26 = 244,
  H27 = 245,
  H28 = 246,
  H29 = 247,
  H30 = 248,
  H31 = 249,
  LR8 = 250,
  R0 = 251,
  R1 = 252,
  R2 = 253,
  R3 = 254,
  R4 = 255,
  R5 = 256,
  R6 = 257,
  R7 = 258,
  R8 = 259,
  R9 = 260,
  R10 = 261,
  R11 = 262,
  R12 = 263,
  R13 = 264,
  R14 = 265,
  R15 = 266,
  R16 = 267,
  R17 = 268,
  R18 = 269,
  R19 = 270,
  R20 = 271,
  R21 = 272,
  R22 = 273,
  R23 = 274,
  R24 = 275,
  R25 = 276,
  R26 = 277,
  R27 = 278,
  R28 = 279,
  R29 = 280,
  R30 = 281,
  R31 = 282,
  S0 = 283,
  S1 = 284,
  S2 = 285,
  S3 = 286,
  S4 = 287,
  S5 = 288,
  S6 = 289,
  S7 = 290,
  S8 = 291,
  S9 = 292,
  S10 = 293,
  S11 = 294,
  S12 = 295,
  S13 = 296,
  S14 = 297,
  S15 = 298,
  S16 = 299,
  S17 = 300,
  S18 = 301,
  S19 = 302,
  S20 = 303,
  S21 = 304,
  S22 = 305,
  S23 = 306,
  S24 = 307,
  S25 = 308,
  S26 = 309,
  S27 = 310,
  S28 = 311,
  S29 = 312,
  S30 = 313,
  S31 = 314,
  UACC0 = 315,
  UACC1 = 316,
  UACC2 = 317,
  UACC3 = 318,
  UACC4 = 319,
  UACC5 = 320,
  UACC6 = 321,
  UACC7 = 322,
  V0 = 323,
  V1 = 324,
  V2 = 325,
  V3 = 326,
  V4 = 327,
  V5 = 328,
  V6 = 329,
  V7 = 330,
  V8 = 331,
  V9 = 332,
  V10 = 333,
  V11 = 334,
  V12 = 335,
  V13 = 336,
  V14 = 337,
  V15 = 338,
  V16 = 339,
  V17 = 340,
  V18 = 341,
  V19 = 342,
  V20 = 343,
  V21 = 344,
  V22 = 345,
  V23 = 346,
  V24 = 347,
  V25 = 348,
  V26 = 349,
  V27 = 350,
  V28 = 351,
  V29 = 352,
  V30 = 353,
  V31 = 354,
  VF0 = 355,
  VF1 = 356,
  VF2 = 357,
  VF3 = 358,
  VF4 = 359,
  VF5 = 360,
  VF6 = 361,
  VF7 = 362,
  VF8 = 363,
  VF9 = 364,
  VF10 = 365,
  VF11 = 366,
  VF12 = 367,
  VF13 = 368,
  VF14 = 369,
  VF15 = 370,
  VF16 = 371,
  VF17 = 372,
  VF18 = 373,
  VF19 = 374,
  VF20 = 375,
  VF21 = 376,
  VF22 = 377,
  VF23 = 378,
  VF24 = 379,
  VF25 = 380,
  VF26 = 381,
  VF27 = 382,
  VF28 = 383,
  VF29 = 384,
  VF30 = 385,
  VF31 = 386,
  VFH0 = 387,
  VFH1 = 388,
  VFH2 = 389,
  VFH3 = 390,
  VFH4 = 391,
  VFH5 = 392,
  VFH6 = 393,
  VFH7 = 394,
  VFH8 = 395,
  VFH9 = 396,
  VFH10 = 397,
  VFH11 = 398,
  VFH12 = 399,
  VFH13 = 400,
  VFH14 = 401,
  VFH15 = 402,
  VFH16 = 403,
  VFH17 = 404,
  VFH18 = 405,
  VFH19 = 406,
  VFH20 = 407,
  VFH21 = 408,
  VFH22 = 409,
  VFH23 = 410,
  VFH24 = 411,
  VFH25 = 412,
  VFH26 = 413,
  VFH27 = 414,
  VFH28 = 415,
  VFH29 = 416,
  VFH30 = 417,
  VFH31 = 418,
  VSL0 = 419,
  VSL1 = 420,
  VSL2 = 421,
  VSL3 = 422,
  VSL4 = 423,
  VSL5 = 424,
  VSL6 = 425,
  VSL7 = 426,
  VSL8 = 427,
  VSL9 = 428,
  VSL10 = 429,
  VSL11 = 430,
  VSL12 = 431,
  VSL13 = 432,
  VSL14 = 433,
  VSL15 = 434,
  VSL16 = 435,
  VSL17 = 436,
  VSL18 = 437,
  VSL19 = 438,
  VSL20 = 439,
  VSL21 = 440,
  VSL22 = 441,
  VSL23 = 442,
  VSL24 = 443,
  VSL25 = 444,
  VSL26 = 445,
  VSL27 = 446,
  VSL28 = 447,
  VSL29 = 448,
  VSL30 = 449,
  VSL31 = 450,
  VSRp0 = 451,
  VSRp1 = 452,
  VSRp2 = 453,
  VSRp3 = 454,
  VSRp4 = 455,
  VSRp5 = 456,
  VSRp6 = 457,
  VSRp7 = 458,
  VSRp8 = 459,
  VSRp9 = 460,
  VSRp10 = 461,
  VSRp11 = 462,
  VSRp12 = 463,
  VSRp13 = 464,
  VSRp14 = 465,
  VSRp15 = 466,
  VSRp16 = 467,
  VSRp17 = 468,
  VSRp18 = 469,
  VSRp19 = 470,
  VSRp20 = 471,
  VSRp21 = 472,
  VSRp22 = 473,
  VSRp23 = 474,
  VSRp24 = 475,
  VSRp25 = 476,
  VSRp26 = 477,
  VSRp27 = 478,
  VSRp28 = 479,
  VSRp29 = 480,
  VSRp30 = 481,
  VSRp31 = 482,
  VSX32 = 483,
  VSX33 = 484,
  VSX34 = 485,
  VSX35 = 486,
  VSX36 = 487,
  VSX37 = 488,
  VSX38 = 489,
  VSX39 = 490,
  VSX40 = 491,
  VSX41 = 492,
  VSX42 = 493,
  VSX43 = 494,
  VSX44 = 495,
  VSX45 = 496,
  VSX46 = 497,
  VSX47 = 498,
  VSX48 = 499,
  VSX49 = 500,
  VSX50 = 501,
  VSX51 = 502,
  VSX52 = 503,
  VSX53 = 504,
  VSX54 = 505,
  VSX55 = 506,
  VSX56 = 507,
  VSX57 = 508,
  VSX58 = 509,
  VSX59 = 510,
  VSX60 = 511,
  VSX61 = 512,
  VSX62 = 513,
  VSX63 = 514,
  WACC0 = 515,
  WACC1 = 516,
  WACC2 = 517,
  WACC3 = 518,
  WACC4 = 519,
  WACC5 = 520,
  WACC6 = 521,
  WACC7 = 522,
  WACC_HI0 = 523,
  WACC_HI1 = 524,
  WACC_HI2 = 525,
  WACC_HI3 = 526,
  WACC_HI4 = 527,
  WACC_HI5 = 528,
  WACC_HI6 = 529,
  WACC_HI7 = 530,
  X0 = 531,
  X1 = 532,
  X2 = 533,
  X3 = 534,
  X4 = 535,
  X5 = 536,
  X6 = 537,
  X7 = 538,
  X8 = 539,
  X9 = 540,
  X10 = 541,
  X11 = 542,
  X12 = 543,
  X13 = 544,
  X14 = 545,
  X15 = 546,
  X16 = 547,
  X17 = 548,
  X18 = 549,
  X19 = 550,
  X20 = 551,
  X21 = 552,
  X22 = 553,
  X23 = 554,
  X24 = 555,
  X25 = 556,
  X26 = 557,
  X27 = 558,
  X28 = 559,
  X29 = 560,
  X30 = 561,
  X31 = 562,
  ZERO8 = 563,
  CR0EQ = 564,
  CR1EQ = 565,
  CR2EQ = 566,
  CR3EQ = 567,
  CR4EQ = 568,
  CR5EQ = 569,
  CR6EQ = 570,
  CR7EQ = 571,
  CR0GT = 572,
  CR1GT = 573,
  CR2GT = 574,
  CR3GT = 575,
  CR4GT = 576,
  CR5GT = 577,
  CR6GT = 578,
  CR7GT = 579,
  CR0LT = 580,
  CR1LT = 581,
  CR2LT = 582,
  CR3LT = 583,
  CR4LT = 584,
  CR5LT = 585,
  CR6LT = 586,
  CR7LT = 587,
  CR0UN = 588,
  CR1UN = 589,
  CR2UN = 590,
  CR3UN = 591,
  CR4UN = 592,
  CR5UN = 593,
  CR6UN = 594,
  CR7UN = 595,
  G8p0 = 596,
  G8p1 = 597,
  G8p2 = 598,
  G8p3 = 599,
  G8p4 = 600,
  G8p5 = 601,
  G8p6 = 602,
  G8p7 = 603,
  G8p8 = 604,
  G8p9 = 605,
  G8p10 = 606,
  G8p11 = 607,
  G8p12 = 608,
  G8p13 = 609,
  G8p14 = 610,
  G8p15 = 611,
  NUM_TARGET_REGS = 612,
};

}
}
}
#endif
