# Path Параметри та валідація числових даних

Так само як Ви можете оголошувати додаткові перевірки та метадані для query параметрів за допомогою `Query`, Ви можете оголошувати той самий тип перевірок і метаданих для параметрів шляху за допомогою `Path`.

## Імпорт Path

Спочатку імпортуйте `Path` з `fastapi` і імпортуйте `Annotated`:

{* ../../docs_src/path_params_numeric_validations/tutorial001_an_py310.py hl[1,3] *}

/// info | Інформація

FastAPI додав підтримку `Annotated`  (і почав рекомендувати його використання) у версії 0.95.0.

Якщо у Вас стара версія, при спробі використати `Annotated` можуть виникати помилки.

Переконайтеся, що Ви [оновили версію FastAPI](../deployment/versions.md#upgrading-the-fastapi-versions){.internal-link target=_blank} принаймні до версії 0.95.1 перед використанням `Annotated`.

///

## Оголошення метаданих

Ви можете оголошувати всі ті ж параметри, що і для `Query`.

Наприклад, щоб оголосити значення метаданих `title` для параметра шляху `item_id`, Ви можете написати:

{* ../../docs_src/path_params_numeric_validations/tutorial001_an_py310.py hl[10] *}

/// note | Примітка

Параметр шляху завжди є обов’язковим, оскільки він має бути частиною шляху. Навіть якщо Ви оголосите його зі значенням `None` або встановите значення за замовчуванням — він все одно залишатиметься обов’язковим.

///

## Упорядковуйте параметри, як Вам потрібно

/// tip | Підказка

Це, мабуть, не настільки важливо або необхідно, якщо Ви використовуєте `Annotated`.

///

Припустимо, Ви хочете оголосити параметр запиту `q`  як обов’язковий `str`.

І Вам не потрібно оголошувати нічого іншого для цього параметра, тому немає потреби використовувати `Query`.

Але Вам все одно потрібно використовувати `Path` для параметра шляху `item_id`. І з певних причин Ви не хочете використовувати `Annotated`.

Python видасть помилку, якщо розмістити значення з "default" перед значенням, яке не має "default".

Але Ви можете змінити порядок і розмістити значення без значення за замовчуванням (параметр запиту `q`) першим.


Для **FastAPI** порядок не має значення. Він визначає параметри за їх іменами, типами та значеннями за замовчуванням (`Query`, `Path` тощо) і не звертає уваги на порядок.

Тому Ви можете оголосити Вашу функцію так:

//// tab | Python 3.8 non-Annotated

/// tip | Підказка

За можливості віддавайте перевагу версії з використанням `Annotated`.

///

{* ../../docs_src/path_params_numeric_validations/tutorial002.py hl[7] *}

////

Але майте на увазі, що якщо Ви використовуєте `Annotated`, ця проблема не виникне, оскільки Ви не використовуєте значення за замовчуванням для параметрів `Query()` або `Path()`.

{* ../../docs_src/path_params_numeric_validations/tutorial002_an_py39.py *}

## Упорядковуйте параметри за потребою, хитрощі

/// tip | Підказка

Це, мабуть, не настільки важливо або необхідно, якщо Ви використовуєте `Annotated`.

///

Ось **невелика хитрість**, яка може стати в пригоді, хоча вона рідко знадобиться.

Якщо Ви хочете:

* оголосити параметр запиту `q`  без використання `Query` або значення за замовчуванням
* оголосити параметр шляху `item_id`, використовуючи `Path`
* розмістити їх у різному порядку
* не використовувати `Annotated`

...у Python є спеціальний синтаксис для цього.

Передайте `*` як перший параметр функції.

Python нічого не зробить із цією `*`, але розпізнає, що всі наступні параметри слід викликати як аргументи за ключовим словом (пари ключ-значення), також відомі як <abbr title="From: K-ey W-ord Arg-uments"><code>kwargs</code></abbr>. Навіть якщо вони не мають значення за замовчуванням.

{* ../../docs_src/path_params_numeric_validations/tutorial003.py hl[7] *}

### Краще з `Annotated`

Майте на увазі, якщо Ви використовуєте `Annotated`, оскільки Ви не використовуєте значення за замовчуванням для параметрів функції, цієї проблеми не виникне, і, швидше за все, Вам не потрібно буде використовувати `*`.

{* ../../docs_src/path_params_numeric_validations/tutorial003_an_py39.py hl[10] *}

## Валідація числових даних: більше або дорівнює

За допомогою `Query` і `Path` (та інших, які Ви побачите пізніше) можна оголошувати числові обмеження.

Тут, завдяки `ge=1`, `item_id` має бути цілим числом, яке "`g`reater than or `e`qual" (більше або дорівнює) `1`.

{* ../../docs_src/path_params_numeric_validations/tutorial004_an_py39.py hl[10] *}

## Валідація числових даних: більше ніж і менше або дорівнює

Те саме застосовується до:

* `gt`: `g`reater `t`han (більше ніж)
* `le`: `l`ess than or `e`qual (менше або дорівнює)

{* ../../docs_src/path_params_numeric_validations/tutorial005_an_py39.py hl[10] *}

## Валідація числових даних: float, більше ніж і менше ніж

Валідація чисел також працює для значень типу `float`.

Ось де стає важливо мати можливість оголошувати <abbr title="greater than (більше ніж)"><code>gt</code></abbr>, а не тільки <abbr title="greater than or equal (більше або дорівнює)"><code>ge</code></abbr>. Це дозволяє, наприклад, вимагати, щоб значення було більше `0`, навіть якщо воно менше `1`.

Таким чином, значення `0.5` буде допустимим. Але `0.0` або `0` — ні.

Те саме стосується <abbr title="less than (менше ніж)"><code>lt</code></abbr>.

{* ../../docs_src/path_params_numeric_validations/tutorial006_an_py39.py hl[13] *}

## Підсумок

За допомогою `Query`, `Path` (і інших параметрів, які Ви ще не бачили) можна оголошувати метадані та перевірки рядків, так само як у [Query параметри та валідація рядків](query-params-str-validations.md){.internal-link target=_blank}.

Також можна оголошувати числові перевірки:

* `gt`: `g`reater `t`han (більше ніж)
* `ge`: `g`reater than or `e`qual (більше або дорівнює)
* `lt`: `l`ess `t`han (менше ніж)
* `le`: `l`ess than or `e`qual (менше або дорівнює)

/// info | Інформація

`Query`, `Path` та інші класи, які Ви побачите пізніше, є підкласами спільного класу `Param`.

Всі вони мають однакові параметри для додаткових перевірок і метаданих, які Ви вже бачили.

///

/// note | Технічні деталі

Коли Ви імпортуєте `Query`, `Path` та інші з `fastapi`, насправді це функції.

При виклику вони повертають екземпляри класів з такими ж іменами.

Тобто Ви імпортуєте `Query`, яка є функцією. А коли Ви її викликаєте, вона повертає екземпляр класу, який теж називається `Query`.

Ці функції створені таким чином (замість використання класів напряму), щоб Ваш редактор не відзначав їхні типи як помилки.

Таким чином, Ви можете користуватися своїм звичайним редактором і інструментами для програмування без додаткових налаштувань для ігнорування таких помилок.

///
