/*
 * This file is part of libsh4lt.
 *
 * libsh4lt is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef SH4LT_SAFE_BOOL_LOG_H_
#define SH4LT_SAFE_BOOL_LOG_H_

#include "./safe-bool-idiom.hpp"
#include <string>
#include <vector>

namespace sh4lt {

/*!
 * Add logs to the SafeboolIdiom.
 */

class SafeBoolLog : public SafeBoolIdiom {
 public:
  /**
   * Get messages from the logs.
   *
   * \return The logs lines
   **/
  [[nodiscard]] auto msgs() const -> std::vector<std::string>;

  /**
   * Get all lines into a single string
   *
   * \return The string with all messages, separated with a newline character.
   **/
  [[nodiscard]] auto msg() const -> std::string;

  /**
   * Add a message to the embedded log.
   *
   * \param msg The message to add.
   **/
  void add_log(const std::string& msg) const;

  /**
   * Test is message is present.
   *
   * \return true is a message is available.
   **/
  [[nodiscard]] auto has_msg() const -> bool;

private:
  mutable std::vector<std::string> msgs_{};
};

}  // namespace sh4lt

#endif
