/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/Oranges.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 127, 39, 4, 255, 166, 54, 3, 255, 217, 72, 1, 255, 241, 105, 19, 255, 253, 141, 60, 255, 253, 174, 107, 255, 253, 208, 162, 255, 254, 230, 206, 255, 255, 245, 235, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Oranges_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 126, 39, 3, 0, 127, 39, 4, 7, 127, 39, 4, 14, 127, 39, 4, 22, 128, 39, 4, 29, 128, 39, 4, 37, 128, 39, 4, 44, 129, 39, 4, 52, 129, 39, 4, 59, 129, 40, 4, 67, 129, 40, 4, 74, 130, 40, 4, 82, 130, 40, 4, 89, 130, 40, 4, 97, 131, 40, 4, 104, 131, 40, 4, 112, 131, 40, 4, 119, 132, 40, 4, 127, 132, 41, 4, 134, 132, 41, 4, 141, 132, 41, 4, 149, 133, 41, 4, 156, 133, 41, 4, 164, 133, 41, 4, 171, 134, 41, 4, 179, 134, 41, 4, 186, 134, 41, 4, 194, 135, 42, 4, 201, 135, 42, 4, 209, 135, 42, 4, 216, 135, 42, 4, 224, 136, 42, 4, 231, 136, 42, 4, 239, 136, 42, 4, 246, 137, 42, 4, 254, 137, 42, 4, 255, 137, 43, 4, 255, 138, 43, 4, 255, 138, 43, 4, 255, 138, 43, 4, 255, 139, 43, 4, 255, 139, 43, 4, 255, 139, 43, 4, 255, 139, 43, 4, 255, 140, 44, 4, 255, 140, 44, 4, 255, 140, 44, 4, 255, 141, 44, 4, 255, 141, 44, 4, 255, 141, 44, 4, 255, 142, 44, 4, 255, 142, 44, 4, 255, 142, 44, 4, 255, 142, 45, 4, 255, 143, 45, 4, 255, 143, 45, 4, 255, 143, 45, 4, 255, 144, 45, 4, 255, 144, 45, 4, 255, 144, 45, 4, 255, 145, 45, 4, 255, 145, 45, 4, 255, 145, 46, 4, 255, 145, 46, 4, 255, 146, 46, 4, 255, 146, 46, 4, 255, 146, 46, 4, 255, 147, 46, 4, 255, 147, 46, 4, 255, 147, 46, 4, 255, 148, 47, 3, 255, 148, 47, 3, 255, 148, 47, 3, 255, 149, 47, 3, 255, 149, 47, 3, 255, 149, 47, 3, 255, 149, 47, 3, 255, 150, 47, 3, 255, 150, 47, 3, 255, 150, 48, 3, 255, 151, 48, 3, 255, 151, 48, 3, 255, 151, 48, 3, 255, 152, 48, 3, 255, 152, 48, 3, 255, 152, 48, 3, 255, 153, 48, 3, 255, 153, 49, 3, 255, 153, 49, 3, 255, 153, 49, 3, 255, 154, 49, 3, 255, 154, 49, 3, 255, 154, 49, 3, 255, 155, 49, 3, 255, 155, 49, 3, 255, 155, 50, 3, 255, 156, 50, 3, 255, 156, 50, 3, 255, 156, 50, 3, 255, 157, 50, 3, 255, 157, 50, 3, 255, 157, 50, 3, 255, 157, 50, 3, 255, 158, 50, 3, 255, 158, 51, 3, 255, 158, 51, 3, 255, 159, 51, 3, 255, 159, 51, 3, 255, 159, 51, 3, 255, 160, 51, 3, 255, 160, 51, 3, 255, 160, 51, 3, 255, 161, 52, 3, 255, 161, 52, 3, 255, 161, 52, 3, 255, 161, 52, 3, 255, 162, 52, 3, 255, 162, 52, 3, 255, 162, 52, 3, 255, 163, 52, 3, 255, 163, 53, 3, 255, 163, 53, 3, 255, 164, 53, 3, 255, 164, 53, 3, 255, 164, 53, 3, 255, 165, 53, 3, 255, 165, 53, 3, 255, 165, 53, 3, 255, 165, 54, 2, 255, 166, 54, 2, 255, 166, 54, 2, 255, 167, 54, 2, 255, 167, 54, 2, 255, 167, 54, 2, 255, 168, 54, 2, 255, 168, 54, 2, 255, 169, 55, 2, 255, 169, 55, 2, 255, 169, 55, 2, 255, 170, 55, 2, 255, 170, 55, 2, 255, 171, 55, 2, 255, 171, 55, 2, 255, 171, 56, 2, 255, 172, 56, 2, 255, 172, 56, 2, 255, 173, 56, 2, 255, 173, 56, 2, 255, 173, 56, 2, 255, 174, 56, 2, 255, 174, 57, 2, 255, 174, 57, 2, 255, 175, 57, 2, 255, 175, 57, 2, 255, 176, 57, 2, 255, 176, 57, 2, 255, 176, 57, 2, 255, 177, 57, 2, 255, 177, 58, 2, 255, 178, 58, 2, 255, 178, 58, 2, 255, 178, 58, 2, 255, 179, 58, 2, 255, 179, 58, 2, 255, 180, 58, 2, 255, 180, 59, 2, 255, 180, 59, 2, 255, 181, 59, 2, 255, 181, 59, 2, 255, 182, 59, 2, 255, 182, 59, 2, 255, 182, 59, 2, 255, 183, 60, 2, 255, 183, 60, 2, 255, 184, 60, 2, 255, 184, 60, 2, 255, 184, 60, 2, 255, 185, 60, 2, 255, 185, 60, 2, 255, 186, 61, 2, 255, 186, 61, 2, 255, 186, 61, 2, 255, 187, 61, 2, 255, 187, 61, 2, 255, 188, 61, 2, 255, 188, 61, 2, 255, 188, 62, 2, 255, 189, 62, 2, 255, 189, 62, 2, 255, 189, 62, 2, 255, 190, 62, 2, 255, 190, 62, 2, 255, 191, 62, 2, 255, 191, 63, 2, 255, 191, 63, 2, 255, 192, 63, 2, 255, 192, 63, 2, 255, 193, 63, 2, 255, 193, 63, 2, 255, 193, 63, 2, 255, 194, 64, 2, 255, 194, 64, 2, 255, 195, 64, 2, 255, 195, 64, 2, 255, 195, 64, 2, 255, 196, 64, 2, 255, 196, 64, 2, 255, 197, 64, 2, 255, 197, 65, 2, 255, 197, 65, 1, 255, 198, 65, 1, 255, 198, 65, 1, 255, 199, 65, 1, 255, 199, 65, 1, 255, 199, 65, 1, 255, 200, 66, 1, 255, 200, 66, 1, 255, 201, 66, 1, 255, 201, 66, 1, 255, 202, 66, 1, 255, 202, 66, 1, 255, 202, 66, 1, 255, 203, 67, 1, 255, 203, 67, 1, 255, 204, 67, 1, 255, 204, 67, 1, 255, 204, 67, 1, 255, 205, 67, 1, 255, 205, 67, 1, 255, 206, 68, 1, 255, 206, 68, 1, 255, 206, 68, 1, 255, 207, 68, 1, 255, 207, 68, 1, 255, 208, 68, 1, 255, 208, 68, 1, 255, 208, 69, 1, 255, 209, 69, 1, 255, 209, 69, 1, 255, 210, 69, 1, 255, 210, 69, 1, 255, 210, 69, 1, 255, 211, 69, 1, 255, 211, 70, 1, 255, 212, 70, 1, 255, 212, 70, 1, 255, 212, 70, 1, 255, 213, 70, 1, 255, 213, 70, 1, 255, 214, 70, 1, 255, 214, 71, 1, 255, 214, 71, 1, 255, 215, 71, 1, 255, 215, 71, 1, 255, 216, 71, 1, 255, 216, 71, 1, 255, 216, 72, 0, 255, 217, 72, 1, 255, 217, 72, 1, 255, 217, 72, 1, 255, 217, 73, 1, 255, 217, 73, 1, 255, 218, 73, 1, 255, 218, 73, 1, 255, 218, 74, 1, 255, 218, 74, 1, 255, 218, 74, 2, 255, 219, 74, 2, 255, 219, 75, 2, 255, 219, 75, 2, 255, 219, 75, 2, 255, 219, 76, 2, 255, 220, 76, 2, 255, 220, 76, 2, 255, 220, 76, 2, 255, 220, 77, 3, 255, 220, 77, 3, 255, 220, 77, 3, 255, 221, 77, 3, 255, 221, 78, 3, 255, 221, 78, 3, 255, 221, 78, 3, 255, 221, 78, 3, 255, 222, 79, 4, 255, 222, 79, 4, 255, 222, 79, 4, 255, 222, 80, 4, 255, 222, 80, 4, 255, 223, 80, 4, 255, 223, 80, 4, 255, 223, 81, 4, 255, 223, 81, 5, 255, 223, 81, 5, 255, 224, 81, 5, 255, 224, 82, 5, 255, 224, 82, 5, 255, 224, 82, 5, 255, 224, 82, 5, 255, 224, 83, 5, 255, 225, 83, 6, 255, 225, 83, 6, 255, 225, 83, 6, 255, 225, 84, 6, 255, 225, 84, 6, 255, 226, 84, 6, 255, 226, 84, 6, 255, 226, 85, 7, 255, 226, 85, 7, 255, 226, 85, 7, 255, 227, 85, 7, 255, 227, 86, 7, 255, 227, 86, 7, 255, 227, 86, 7, 255, 227, 87, 8, 255, 227, 87, 8, 255, 228, 87, 8, 255, 228, 87, 8, 255, 228, 88, 8, 255, 228, 88, 8, 255, 228, 88, 9, 255, 229, 88, 9, 255, 229, 89, 9, 255, 229, 89, 9, 255, 229, 89, 9, 255, 229, 89, 9, 255, 230, 90, 9, 255, 230, 90, 10, 255, 230, 90, 10, 255, 230, 90, 10, 255, 230, 91, 10, 255, 230, 91, 10, 255, 231, 91, 10, 255, 231, 91, 11, 255, 231, 92, 11, 255, 231, 92, 11, 255, 231, 92, 11, 255, 232, 92, 11, 255, 232, 93, 11, 255, 232, 93, 12, 255, 232, 93, 12, 255, 232, 93, 12, 255, 233, 94, 12, 255, 233, 94, 12, 255, 233, 94, 12, 255, 233, 94, 13, 255, 233, 95, 13, 255, 233, 95, 13, 255, 234, 95, 13, 255, 234, 95, 13, 255, 234, 96, 13, 255, 234, 96, 13, 255, 234, 96, 14, 255, 235, 96, 14, 255, 235, 97, 14, 255, 235, 97, 14, 255, 235, 97, 14, 255, 235, 97, 14, 255, 235, 98, 14, 255, 236, 98, 15, 255, 236, 98, 15, 255, 236, 98, 15, 255, 236, 99, 15, 255, 236, 99, 15, 255, 237, 99, 15, 255, 237, 99, 16, 255, 237, 100, 16, 255, 237, 100, 16, 255, 237, 100, 16, 255, 238, 100, 16, 255, 238, 101, 16, 255, 238, 101, 16, 255, 238, 101, 17, 255, 238, 101, 17, 255, 238, 102, 17, 255, 239, 102, 17, 255, 239, 102, 17, 255, 239, 103, 17, 255, 239, 103, 17, 255, 239, 103, 18, 255, 240, 103, 18, 255, 240, 104, 18, 255, 240, 104, 18, 255, 240, 104, 18, 255, 240, 104, 18, 255, 240, 105, 18, 255, 241, 105, 19, 255, 241, 105, 19, 255, 241, 105, 20, 255, 241, 106, 20, 255, 241, 106, 20, 255, 241, 106, 21, 255, 241, 107, 21, 255, 241, 107, 22, 255, 241, 107, 22, 255, 241, 107, 22, 255, 242, 108, 23, 255, 242, 108, 23, 255, 242, 108, 23, 255, 242, 109, 24, 255, 242, 109, 24, 255, 242, 109, 24, 255, 242, 110, 25, 255, 242, 110, 25, 255, 242, 110, 26, 255, 242, 110, 26, 255, 243, 111, 26, 255, 243, 111, 27, 255, 243, 111, 27, 255, 243, 112, 27, 255, 243, 112, 28, 255, 243, 112, 28, 255, 243, 112, 28, 255, 243, 113, 29, 255, 243, 113, 29, 255, 243, 113, 29, 255, 243, 114, 30, 255, 244, 114, 30, 255, 244, 114, 30, 255, 244, 114, 31, 255, 244, 115, 31, 255, 244, 115, 31, 255, 244, 115, 32, 255, 244, 116, 32, 255, 244, 116, 32, 255, 244, 116, 33, 255, 244, 117, 33, 255, 245, 117, 33, 255, 245, 117, 34, 255, 245, 117, 34, 255, 245, 118, 34, 255, 245, 118, 35, 255, 245, 118, 35, 255, 245, 118, 35, 255, 245, 119, 36, 255, 245, 119, 36, 255, 245, 119, 36, 255, 245, 120, 36, 255, 246, 120, 37, 255, 246, 120, 37, 255, 246, 120, 37, 255, 246, 121, 38, 255, 246, 121, 38, 255, 246, 121, 38, 255, 246, 122, 39, 255, 246, 122, 39, 255, 246, 122, 39, 255, 246, 122, 40, 255, 246, 123, 40, 255, 247, 123, 40, 255, 247, 123, 41, 255, 247, 124, 41, 255, 247, 124, 41, 255, 247, 124, 41, 255, 247, 124, 42, 255, 247, 125, 42, 255, 247, 125, 42, 255, 247, 125, 43, 255, 247, 126, 43, 255, 248, 126, 43, 255, 248, 126, 44, 255, 248, 126, 44, 255, 248, 127, 44, 255, 248, 127, 45, 255, 248, 127, 45, 255, 248, 127, 45, 255, 248, 128, 45, 255, 248, 128, 46, 255, 248, 128, 46, 255, 248, 129, 46, 255, 249, 129, 47, 255, 249, 129, 47, 255, 249, 129, 47, 255, 249, 130, 48, 255, 249, 130, 48, 255, 249, 130, 48, 255, 249, 130, 48, 255, 249, 131, 49, 255, 249, 131, 49, 255, 249, 131, 49, 255, 249, 132, 50, 255, 250, 132, 50, 255, 250, 132, 50, 255, 250, 132, 51, 255, 250, 133, 51, 255, 250, 133, 51, 255, 250, 133, 51, 255, 250, 133, 52, 255, 250, 134, 52, 255, 250, 134, 52, 255, 250, 134, 53, 255, 250, 135, 53, 255, 251, 135, 53, 255, 251, 135, 54, 255, 251, 135, 54, 255, 251, 136, 54, 255, 251, 136, 54, 255, 251, 136, 55, 255, 251, 136, 55, 255, 251, 137, 55, 255, 251, 137, 56, 255, 251, 137, 56, 255, 251, 138, 56, 255, 252, 138, 57, 255, 252, 138, 57, 255, 252, 138, 57, 255, 252, 139, 57, 255, 252, 139, 58, 255, 252, 139, 58, 255, 252, 139, 58, 255, 252, 140, 59, 255, 252, 140, 59, 255, 252, 140, 59, 255, 252, 141, 59, 255, 253, 141, 60, 255, 253, 141, 60, 255, 253, 141, 61, 255, 253, 142, 61, 255, 253, 142, 61, 255, 253, 142, 62, 255, 253, 142, 62, 255, 253, 143, 62, 255, 253, 143, 63, 255, 253, 143, 63, 255, 253, 144, 64, 255, 253, 144, 64, 255, 253, 144, 64, 255, 253, 144, 65, 255, 253, 145, 65, 255, 253, 145, 65, 255, 253, 145, 66, 255, 253, 145, 66, 255, 253, 146, 66, 255, 253, 146, 67, 255, 253, 146, 67, 255, 253, 146, 67, 255, 253, 147, 68, 255, 253, 147, 68, 255, 253, 147, 69, 255, 253, 148, 69, 255, 253, 148, 69, 255, 253, 148, 70, 255, 253, 148, 70, 255, 253, 149, 70, 255, 253, 149, 71, 255, 253, 149, 71, 255, 253, 149, 71, 255, 253, 150, 72, 255, 253, 150, 72, 255, 253, 150, 73, 255, 253, 150, 73, 255, 253, 151, 73, 255, 253, 151, 74, 255, 253, 151, 74, 255, 253, 152, 74, 255, 253, 152, 75, 255, 253, 152, 75, 255, 253, 152, 75, 255, 253, 153, 76, 255, 253, 153, 76, 255, 253, 153, 77, 255, 253, 153, 77, 255, 253, 154, 77, 255, 253, 154, 78, 255, 253, 154, 78, 255, 253, 154, 78, 255, 253, 155, 79, 255, 253, 155, 79, 255, 253, 155, 79, 255, 253, 155, 80, 255, 253, 156, 80, 255, 253, 156, 81, 255, 253, 156, 81, 255, 253, 156, 81, 255, 253, 157, 82, 255, 253, 157, 82, 255, 253, 157, 82, 255, 253, 157, 83, 255, 253, 158, 83, 255, 253, 158, 84, 255, 253, 158, 84, 255, 253, 159, 84, 255, 253, 159, 85, 255, 253, 159, 85, 255, 253, 159, 85, 255, 253, 160, 86, 255, 253, 160, 86, 255, 253, 160, 86, 255, 253, 160, 87, 255, 253, 161, 87, 255, 253, 161, 88, 255, 253, 161, 88, 255, 253, 161, 88, 255, 253, 162, 89, 255, 253, 162, 89, 255, 253, 162, 89, 255, 253, 162, 90, 255, 253, 163, 90, 255, 253, 163, 90, 255, 253, 163, 91, 255, 253, 163, 91, 255, 253, 164, 92, 255, 253, 164, 92, 255, 253, 164, 92, 255, 253, 164, 93, 255, 253, 165, 93, 255, 253, 165, 93, 255, 253, 165, 94, 255, 253, 165, 94, 255, 253, 166, 95, 255, 253, 166, 95, 255, 253, 166, 95, 255, 253, 166, 96, 255, 253, 167, 96, 255, 253, 167, 96, 255, 253, 167, 97, 255, 253, 167, 97, 255, 253, 168, 98, 255, 253, 168, 98, 255, 253, 168, 98, 255, 253, 168, 99, 255, 253, 169, 99, 255, 253, 169, 99, 255, 253, 169, 100, 255, 253, 169, 100, 255, 253, 170, 100, 255, 253, 170, 101, 255, 253, 170, 101, 255, 253, 170, 102, 255, 253, 171, 102, 255, 253, 171, 102, 255, 253, 171, 103, 255, 253, 171, 103, 255, 253, 172, 103, 255, 253, 172, 104, 255, 253, 172, 104, 255, 253, 172, 105, 255, 253, 173, 105, 255, 253, 173, 105, 255, 253, 173, 106, 255, 253, 173, 106, 255, 252, 174, 106, 255, 253, 174, 107, 255, 253, 174, 107, 255, 253, 174, 108, 255, 253, 175, 108, 255, 253, 175, 109, 255, 253, 175, 109, 255, 253, 175, 109, 255, 253, 176, 110, 255, 253, 176, 110, 255, 253, 176, 111, 255, 253, 177, 111, 255, 253, 177, 111, 255, 253, 177, 112, 255, 253, 177, 112, 255, 253, 178, 113, 255, 253, 178, 113, 255, 253, 178, 113, 255, 253, 178, 114, 255, 253, 179, 114, 255, 253, 179, 115, 255, 253, 179, 115, 255, 253, 180, 116, 255, 253, 180, 116, 255, 253, 180, 116, 255, 253, 180, 117, 255, 253, 181, 117, 255, 253, 181, 118, 255, 253, 181, 118, 255, 253, 181, 118, 255, 253, 182, 119, 255, 253, 182, 119, 255, 253, 182, 120, 255, 253, 183, 120, 255, 253, 183, 121, 255, 253, 183, 121, 255, 253, 183, 121, 255, 253, 184, 122, 255, 253, 184, 122, 255, 253, 184, 123, 255, 253, 184, 123, 255, 253, 185, 123, 255, 253, 185, 124, 255, 253, 185, 124, 255, 253, 186, 125, 255, 253, 186, 125, 255, 253, 186, 126, 255, 253, 186, 126, 255, 253, 187, 126, 255, 253, 187, 127, 255, 253, 187, 127, 255, 253, 187, 128, 255, 253, 188, 128, 255, 253, 188, 129, 255, 253, 188, 129, 255, 253, 189, 129, 255, 253, 189, 130, 255, 253, 189, 130, 255, 253, 189, 131, 255, 253, 190, 131, 255, 253, 190, 132, 255, 253, 190, 132, 255, 253, 190, 132, 255, 253, 191, 133, 255, 253, 191, 133, 255, 253, 191, 134, 255, 253, 191, 134, 255, 253, 192, 135, 255, 253, 192, 135, 255, 253, 192, 135, 255, 253, 192, 136, 255, 253, 193, 136, 255, 253, 193, 137, 255, 253, 193, 137, 255, 253, 194, 138, 255, 253, 194, 138, 255, 253, 194, 138, 255, 253, 194, 139, 255, 253, 195, 139, 255, 253, 195, 140, 255, 253, 195, 140, 255, 253, 195, 141, 255, 253, 196, 141, 255, 253, 196, 142, 255, 253, 196, 142, 255, 253, 196, 142, 255, 253, 197, 143, 255, 253, 197, 143, 255, 253, 197, 144, 255, 253, 197, 144, 255, 253, 198, 145, 255, 253, 198, 145, 255, 253, 198, 145, 255, 253, 199, 146, 255, 253, 199, 146, 255, 253, 199, 147, 255, 253, 199, 147, 255, 253, 200, 148, 255, 253, 200, 148, 255, 253, 200, 149, 255, 253, 200, 149, 255, 253, 201, 149, 255, 253, 201, 150, 255, 253, 201, 150, 255, 253, 201, 151, 255, 253, 202, 151, 255, 253, 202, 152, 255, 253, 202, 152, 255, 253, 202, 153, 255, 253, 203, 153, 255, 253, 203, 153, 255, 253, 203, 154, 255, 253, 203, 154, 255, 253, 204, 155, 255, 253, 204, 155, 255, 253, 204, 156, 255, 253, 204, 156, 255, 253, 205, 157, 255, 253, 205, 157, 255, 253, 205, 157, 255, 253, 205, 158, 255, 253, 206, 158, 255, 253, 206, 159, 255, 253, 206, 159, 255, 253, 206, 160, 255, 253, 207, 160, 255, 253, 207, 161, 255, 253, 207, 161, 255, 252, 208, 161, 255, 253, 208, 162, 255, 253, 208, 162, 255, 253, 208, 163, 255, 253, 208, 163, 255, 253, 208, 163, 255, 253, 209, 164, 255, 253, 209, 164, 255, 253, 209, 164, 255, 253, 209, 165, 255, 253, 209, 165, 255, 253, 209, 165, 255, 253, 210, 166, 255, 253, 210, 166, 255, 253, 210, 166, 255, 253, 210, 167, 255, 253, 210, 167, 255, 253, 210, 167, 255, 253, 211, 168, 255, 253, 211, 168, 255, 253, 211, 168, 255, 253, 211, 169, 255, 253, 211, 169, 255, 253, 211, 169, 255, 253, 212, 170, 255, 253, 212, 170, 255, 253, 212, 170, 255, 253, 212, 171, 255, 253, 212, 171, 255, 253, 212, 171, 255, 253, 213, 172, 255, 253, 213, 172, 255, 253, 213, 172, 255, 253, 213, 173, 255, 253, 213, 173, 255, 253, 214, 173, 255, 253, 214, 174, 255, 253, 214, 174, 255, 253, 214, 174, 255, 253, 214, 175, 255, 253, 214, 175, 255, 253, 215, 175, 255, 253, 215, 176, 255, 253, 215, 176, 255, 253, 215, 176, 255, 253, 215, 177, 255, 253, 215, 177, 255, 253, 216, 178, 255, 253, 216, 178, 255, 253, 216, 178, 255, 253, 216, 179, 255, 253, 216, 179, 255, 253, 216, 179, 255, 253, 217, 180, 255, 253, 217, 180, 255, 253, 217, 180, 255, 253, 217, 181, 255, 253, 217, 181, 255, 253, 217, 181, 255, 253, 218, 182, 255, 253, 218, 182, 255, 253, 218, 182, 255, 253, 218, 183, 255, 253, 218, 183, 255, 253, 219, 183, 255, 253, 219, 184, 255, 253, 219, 184, 255, 253, 219, 184, 255, 253, 219, 185, 255, 253, 219, 185, 255, 253, 220, 185, 255, 253, 220, 186, 255, 253, 220, 186, 255, 253, 220, 186, 255, 253, 220, 187, 255, 253, 220, 187, 255, 253, 221, 187, 255, 253, 221, 188, 255, 253, 221, 188, 255, 253, 221, 188, 255, 253, 221, 189, 255, 253, 221, 189, 255, 253, 222, 190, 255, 253, 222, 190, 255, 253, 222, 190, 255, 253, 222, 191, 255, 253, 222, 191, 255, 253, 222, 191, 255, 253, 223, 192, 255, 253, 223, 192, 255, 253, 223, 192, 255, 253, 223, 193, 255, 253, 223, 193, 255, 253, 223, 193, 255, 253, 224, 194, 255, 253, 224, 194, 255, 253, 224, 194, 255, 253, 224, 195, 255, 253, 224, 195, 255, 253, 225, 195, 255, 253, 225, 196, 255, 253, 225, 196, 255, 253, 225, 196, 255, 253, 225, 197, 255, 253, 225, 197, 255, 254, 226, 197, 255, 254, 226, 198, 255, 254, 226, 198, 255, 254, 226, 199, 255, 254, 226, 199, 255, 254, 226, 199, 255, 254, 227, 200, 255, 254, 227, 200, 255, 254, 227, 200, 255, 254, 227, 201, 255, 254, 227, 201, 255, 254, 227, 201, 255, 254, 228, 202, 255, 254, 228, 202, 255, 254, 228, 202, 255, 254, 228, 203, 255, 254, 228, 203, 255, 254, 228, 203, 255, 254, 229, 204, 255, 254, 229, 204, 255, 254, 229, 204, 255, 254, 229, 205, 255, 254, 229, 205, 255, 253, 230, 205, 255, 254, 230, 206, 255, 254, 230, 206, 255, 254, 230, 206, 255, 254, 230, 206, 255, 254, 230, 207, 255, 254, 230, 207, 255, 254, 230, 207, 255, 254, 230, 207, 255, 254, 231, 208, 255, 254, 231, 208, 255, 254, 231, 208, 255, 254, 231, 208, 255, 254, 231, 208, 255, 254, 231, 209, 255, 254, 231, 209, 255, 254, 231, 209, 255, 254, 231, 209, 255, 254, 232, 210, 255, 254, 232, 210, 255, 254, 232, 210, 255, 254, 232, 210, 255, 254, 232, 210, 255, 254, 232, 211, 255, 254, 232, 211, 255, 254, 232, 211, 255, 254, 233, 211, 255, 254, 233, 212, 255, 254, 233, 212, 255, 254, 233, 212, 255, 254, 233, 212, 255, 254, 233, 212, 255, 254, 233, 213, 255, 254, 233, 213, 255, 254, 233, 213, 255, 254, 234, 213, 255, 254, 234, 214, 255, 254, 234, 214, 255, 254, 234, 214, 255, 254, 234, 214, 255, 254, 234, 214, 255, 254, 234, 215, 255, 254, 234, 215, 255, 254, 235, 215, 255, 254, 235, 215, 255, 254, 235, 216, 255, 254, 235, 216, 255, 254, 235, 216, 255, 254, 235, 216, 255, 254, 235, 217, 255, 254, 235, 217, 255, 254, 235, 217, 255, 254, 236, 217, 255, 254, 236, 217, 255, 254, 236, 218, 255, 254, 236, 218, 255, 254, 236, 218, 255, 254, 236, 218, 255, 254, 236, 219, 255, 254, 236, 219, 255, 254, 237, 219, 255, 254, 237, 219, 255, 254, 237, 219, 255, 254, 237, 220, 255, 254, 237, 220, 255, 254, 237, 220, 255, 254, 237, 220, 255, 254, 237, 221, 255, 254, 237, 221, 255, 254, 238, 221, 255, 254, 238, 221, 255, 254, 238, 222, 255, 254, 238, 222, 255, 254, 238, 222, 255, 254, 238, 222, 255, 254, 238, 222, 255, 254, 238, 223, 255, 254, 239, 223, 255, 254, 239, 223, 255, 254, 239, 223, 255, 254, 239, 224, 255, 254, 239, 224, 255, 254, 239, 224, 255, 254, 239, 224, 255, 254, 239, 224, 255, 254, 239, 225, 255, 254, 240, 225, 255, 254, 240, 225, 255, 254, 240, 225, 255, 254, 240, 226, 255, 254, 240, 226, 255, 254, 240, 226, 255, 254, 240, 226, 255, 254, 240, 227, 255, 254, 241, 227, 255, 254, 241, 227, 255, 254, 241, 227, 255, 254, 241, 227, 255, 254, 241, 228, 255, 254, 241, 228, 255, 254, 241, 228, 255, 254, 241, 228, 255, 254, 241, 229, 255, 254, 242, 229, 255, 254, 242, 229, 255, 254, 242, 229, 255, 254, 242, 229, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Oranges_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 126, 39, 3, 0, 127, 39, 4, 7, 127, 39, 4, 14, 127, 39, 4, 22, 127, 39, 4, 29, 128, 39, 4, 37, 128, 39, 4, 44, 128, 39, 4, 52, 128, 39, 4, 59, 129, 39, 4, 67, 129, 39, 4, 74, 129, 39, 4, 82, 129, 40, 4, 89, 130, 40, 4, 97, 130, 40, 4, 104, 130, 40, 4, 112, 130, 40, 4, 119, 131, 40, 4, 127, 131, 40, 4, 134, 131, 40, 4, 141, 131, 40, 4, 149, 132, 40, 4, 156, 132, 40, 4, 164, 132, 41, 4, 171, 132, 41, 4, 179, 132, 41, 4, 186, 133, 41, 4, 194, 133, 41, 4, 201, 133, 41, 4, 209, 133, 41, 4, 216, 134, 41, 4, 224, 134, 41, 4, 231, 134, 41, 4, 239, 134, 42, 4, 246, 135, 42, 4, 254, 135, 42, 4, 255, 135, 42, 4, 255, 135, 42, 4, 255, 136, 42, 4, 255, 136, 42, 4, 255, 136, 42, 4, 255, 136, 42, 4, 255, 137, 42, 4, 255, 137, 42, 4, 255, 137, 43, 4, 255, 137, 43, 4, 255, 138, 43, 4, 255, 138, 43, 4, 255, 138, 43, 4, 255, 138, 43, 4, 255, 139, 43, 4, 255, 139, 43, 4, 255, 139, 43, 4, 255, 139, 43, 4, 255, 140, 43, 4, 255, 140, 44, 4, 255, 140, 44, 4, 255, 140, 44, 4, 255, 140, 44, 4, 255, 141, 44, 4, 255, 141, 44, 4, 255, 141, 44, 4, 255, 141, 44, 4, 255, 142, 44, 4, 255, 150, 47, 3, 255, 150, 47, 3, 255, 150, 48, 3, 255, 150, 48, 3, 255, 151, 48, 3, 255, 151, 48, 3, 255, 151, 48, 3, 255, 151, 48, 3, 255, 152, 48, 3, 255, 152, 48, 3, 255, 152, 48, 3, 255, 152, 48, 3, 255, 153, 49, 3, 255, 153, 49, 3, 255, 153, 49, 3, 255, 153, 49, 3, 255, 154, 49, 3, 255, 154, 49, 3, 255, 154, 49, 3, 255, 154, 49, 3, 255, 155, 49, 3, 255, 155, 49, 3, 255, 155, 49, 3, 255, 155, 50, 3, 255, 156, 50, 3, 255, 156, 50, 3, 255, 156, 50, 3, 255, 156, 50, 3, 255, 157, 50, 3, 255, 157, 50, 3, 255, 157, 50, 3, 255, 157, 50, 3, 255, 158, 50, 3, 255, 158, 51, 3, 255, 158, 51, 3, 255, 158, 51, 3, 255, 159, 51, 3, 255, 159, 51, 3, 255, 159, 51, 3, 255, 159, 51, 3, 255, 160, 51, 3, 255, 160, 51, 3, 255, 160, 51, 3, 255, 160, 51, 3, 255, 161, 52, 3, 255, 161, 52, 3, 255, 161, 52, 3, 255, 161, 52, 3, 255, 162, 52, 3, 255, 162, 52, 3, 255, 162, 52, 3, 255, 162, 52, 3, 255, 163, 52, 3, 255, 163, 52, 3, 255, 163, 53, 3, 255, 163, 53, 3, 255, 164, 53, 3, 255, 164, 53, 3, 255, 164, 53, 3, 255, 164, 53, 3, 255, 165, 53, 3, 255, 165, 53, 3, 255, 165, 53, 3, 255, 165, 53, 3, 255, 165, 54, 2, 255, 166, 54, 2, 255, 166, 54, 2, 255, 166, 54, 2, 255, 167, 54, 2, 255, 167, 54, 2, 255, 167, 54, 2, 255, 168, 54, 2, 255, 168, 54, 2, 255, 168, 54, 2, 255, 169, 55, 2, 255, 169, 55, 2, 255, 169, 55, 2, 255, 170, 55, 2, 255, 170, 55, 2, 255, 170, 55, 2, 255, 170, 55, 2, 255, 171, 55, 2, 255, 171, 55, 2, 255, 171, 56, 2, 255, 172, 56, 2, 255, 172, 56, 2, 255, 172, 56, 2, 255, 173, 56, 2, 255, 173, 56, 2, 255, 173, 56, 2, 255, 174, 56, 2, 255, 174, 56, 2, 255, 174, 57, 2, 255, 175, 57, 2, 255, 175, 57, 2, 255, 175, 57, 2, 255, 176, 57, 2, 255, 176, 57, 2, 255, 176, 57, 2, 255, 176, 57, 2, 255, 177, 57, 2, 255, 177, 58, 2, 255, 177, 58, 2, 255, 178, 58, 2, 255, 178, 58, 2, 255, 178, 58, 2, 255, 179, 58, 2, 255, 179, 58, 2, 255, 179, 58, 2, 255, 180, 58, 2, 255, 180, 59, 2, 255, 180, 59, 2, 255, 181, 59, 2, 255, 181, 59, 2, 255, 181, 59, 2, 255, 182, 59, 2, 255, 182, 59, 2, 255, 182, 59, 2, 255, 182, 59, 2, 255, 183, 60, 2, 255, 183, 60, 2, 255, 183, 60, 2, 255, 184, 60, 2, 255, 184, 60, 2, 255, 184, 60, 2, 255, 185, 60, 2, 255, 185, 60, 2, 255, 185, 60, 2, 255, 196, 64, 2, 255, 196, 64, 2, 255, 196, 64, 1, 255, 197, 65, 1, 255, 197, 65, 1, 255, 197, 65, 1, 255, 198, 65, 1, 255, 198, 65, 1, 255, 198, 65, 1, 255, 199, 65, 1, 255, 199, 65, 1, 255, 199, 65, 1, 255, 200, 66, 1, 255, 200, 66, 1, 255, 200, 66, 1, 255, 201, 66, 1, 255, 201, 66, 1, 255, 201, 66, 1, 255, 202, 66, 1, 255, 202, 66, 1, 255, 202, 66, 1, 255, 203, 67, 1, 255, 203, 67, 1, 255, 203, 67, 1, 255, 204, 67, 1, 255, 204, 67, 1, 255, 204, 67, 1, 255, 205, 67, 1, 255, 205, 67, 1, 255, 205, 67, 1, 255, 205, 68, 1, 255, 206, 68, 1, 255, 206, 68, 1, 255, 206, 68, 1, 255, 207, 68, 1, 255, 207, 68, 1, 255, 207, 68, 1, 255, 208, 68, 1, 255, 208, 69, 1, 255, 208, 69, 1, 255, 209, 69, 1, 255, 209, 69, 1, 255, 209, 69, 1, 255, 210, 69, 1, 255, 210, 69, 1, 255, 210, 69, 1, 255, 211, 69, 1, 255, 211, 70, 1, 255, 211, 70, 1, 255, 212, 70, 1, 255, 212, 70, 1, 255, 212, 70, 1, 255, 213, 70, 1, 255, 213, 70, 1, 255, 213, 70, 1, 255, 214, 70, 1, 255, 214, 71, 1, 255, 214, 71, 1, 255, 215, 71, 1, 255, 215, 71, 1, 255, 215, 71, 1, 255, 216, 71, 1, 255, 216, 71, 1, 255, 216, 71, 1, 255, 216, 72, 0, 255, 217, 72, 1, 255, 217, 72, 1, 255, 217, 72, 1, 255, 217, 72, 1, 255, 217, 73, 1, 255, 217, 73, 1, 255, 218, 73, 1, 255, 218, 73, 1, 255, 218, 73, 1, 255, 218, 74, 1, 255, 218, 74, 1, 255, 218, 74, 2, 255, 218, 74, 2, 255, 219, 75, 2, 255, 219, 75, 2, 255, 219, 75, 2, 255, 219, 75, 2, 255, 219, 75, 2, 255, 219, 76, 2, 255, 220, 76, 2, 255, 220, 76, 2, 255, 220, 76, 2, 255, 220, 76, 3, 255, 220, 77, 3, 255, 220, 77, 3, 255, 220, 77, 3, 255, 221, 77, 3, 255, 221, 77, 3, 255, 221, 78, 3, 255, 221, 78, 3, 255, 221, 78, 3, 255, 221, 78, 3, 255, 221, 79, 4, 255, 222, 79, 4, 255, 222, 79, 4, 255, 222, 79, 4, 255, 222, 79, 4, 255, 222, 80, 4, 255, 222, 80, 4, 255, 223, 80, 4, 255, 223, 80, 4, 255, 223, 80, 4, 255, 223, 81, 5, 255, 223, 81, 5, 255, 223, 81, 5, 255, 223, 81, 5, 255, 224, 81, 5, 255, 224, 82, 5, 255, 224, 82, 5, 255, 224, 82, 5, 255, 224, 82, 5, 255, 224, 82, 6, 255, 225, 83, 6, 255, 225, 83, 6, 255, 225, 83, 6, 255, 225, 83, 6, 255, 225, 84, 6, 255, 225, 84, 6, 255, 225, 84, 6, 255, 226, 84, 7, 255, 226, 84, 7, 255, 226, 85, 7, 255, 226, 85, 7, 255, 231, 92, 11, 255, 231, 92, 11, 255, 231, 92, 11, 255, 231, 92, 11, 255, 232, 92, 11, 255, 232, 93, 11, 255, 232, 93, 11, 255, 232, 93, 12, 255, 232, 93, 12, 255, 232, 93, 12, 255, 232, 94, 12, 255, 233, 94, 12, 255, 233, 94, 12, 255, 233, 94, 12, 255, 233, 94, 12, 255, 233, 95, 13, 255, 233, 95, 13, 255, 234, 95, 13, 255, 234, 95, 13, 255, 234, 95, 13, 255, 234, 96, 13, 255, 234, 96, 13, 255, 234, 96, 13, 255, 234, 96, 14, 255, 235, 96, 14, 255, 235, 97, 14, 255, 235, 97, 14, 255, 235, 97, 14, 255, 235, 97, 14, 255, 235, 97, 14, 255, 235, 98, 14, 255, 236, 98, 15, 255, 236, 98, 15, 255, 236, 98, 15, 255, 236, 98, 15, 255, 236, 99, 15, 255, 236, 99, 15, 255, 236, 99, 15, 255, 237, 99, 15, 255, 237, 99, 16, 255, 237, 100, 16, 255, 237, 100, 16, 255, 237, 100, 16, 255, 237, 100, 16, 255, 238, 100, 16, 255, 238, 101, 16, 255, 238, 101, 16, 255, 238, 101, 16, 255, 238, 101, 17, 255, 238, 101, 17, 255, 238, 102, 17, 255, 239, 102, 17, 255, 239, 102, 17, 255, 239, 102, 17, 255, 239, 103, 17, 255, 239, 103, 17, 255, 239, 103, 18, 255, 239, 103, 18, 255, 240, 103, 18, 255, 240, 104, 18, 255, 240, 104, 18, 255, 240, 104, 18, 255, 240, 104, 18, 255, 240, 104, 18, 255, 240, 105, 18, 255, 241, 105, 19, 255, 241, 105, 19, 255, 241, 105, 19, 255, 241, 105, 20, 255, 241, 106, 20, 255, 241, 106, 20, 255, 241, 106, 21, 255, 241, 106, 21, 255, 241, 107, 21, 255, 241, 107, 22, 255, 241, 107, 22, 255, 241, 107, 22, 255, 241, 108, 22, 255, 242, 108, 23, 255, 242, 108, 23, 255, 242, 108, 23, 255, 242, 109, 24, 255, 242, 109, 24, 255, 242, 109, 24, 255, 242, 109, 24, 255, 242, 109, 25, 255, 242, 110, 25, 255, 242, 110, 25, 255, 242, 110, 26, 255, 242, 110, 26, 255, 242, 111, 26, 255, 243, 111, 26, 255, 243, 111, 27, 255, 243, 111, 27, 255, 243, 112, 27, 255, 243, 112, 27, 255, 243, 112, 28, 255, 243, 112, 28, 255, 243, 112, 28, 255, 243, 113, 28, 255, 243, 113, 29, 255, 243, 113, 29, 255, 243, 113, 29, 255, 243, 114, 30, 255, 244, 114, 30, 255, 244, 114, 30, 255, 244, 114, 30, 255, 244, 115, 31, 255, 244, 115, 31, 255, 244, 115, 31, 255, 244, 115, 31, 255, 244, 115, 32, 255, 244, 116, 32, 255, 244, 116, 32, 255, 244, 116, 32, 255, 244, 116, 33, 255, 244, 117, 33, 255, 245, 117, 33, 255, 245, 117, 33, 255, 245, 117, 34, 255, 245, 118, 34, 255, 245, 118, 34, 255, 245, 118, 34, 255, 245, 118, 35, 255, 245, 118, 35, 255, 245, 119, 35, 255, 245, 119, 35, 255, 245, 119, 36, 255, 248, 127, 44, 255, 248, 127, 44, 255, 248, 127, 45, 255, 248, 127, 45, 255, 248, 127, 45, 255, 248, 128, 45, 255, 248, 128, 46, 255, 248, 128, 46, 255, 248, 128, 46, 255, 248, 129, 46, 255, 249, 129, 47, 255, 249, 129, 47, 255, 249, 129, 47, 255, 249, 129, 47, 255, 249, 130, 48, 255, 249, 130, 48, 255, 249, 130, 48, 255, 249, 130, 48, 255, 249, 131, 48, 255, 249, 131, 49, 255, 249, 131, 49, 255, 249, 131, 49, 255, 249, 131, 49, 255, 249, 132, 50, 255, 250, 132, 50, 255, 250, 132, 50, 255, 250, 132, 50, 255, 250, 132, 51, 255, 250, 133, 51, 255, 250, 133, 51, 255, 250, 133, 51, 255, 250, 133, 52, 255, 250, 134, 52, 255, 250, 134, 52, 255, 250, 134, 52, 255, 250, 134, 53, 255, 250, 134, 53, 255, 251, 135, 53, 255, 251, 135, 53, 255, 251, 135, 54, 255, 251, 135, 54, 255, 251, 136, 54, 255, 251, 136, 54, 255, 251, 136, 54, 255, 251, 136, 55, 255, 251, 136, 55, 255, 251, 137, 55, 255, 251, 137, 55, 255, 251, 137, 56, 255, 251, 137, 56, 255, 251, 137, 56, 255, 252, 138, 56, 255, 252, 138, 57, 255, 252, 138, 57, 255, 252, 138, 57, 255, 252, 139, 57, 255, 252, 139, 58, 255, 252, 139, 58, 255, 252, 139, 58, 255, 252, 139, 58, 255, 252, 140, 59, 255, 252, 140, 59, 255, 252, 140, 59, 255, 252, 140, 59, 255, 252, 141, 59, 255, 253, 141, 60, 255, 253, 141, 60, 255, 253, 141, 60, 255, 253, 141, 61, 255, 253, 142, 61, 255, 253, 142, 61, 255, 253, 142, 62, 255, 253, 142, 62, 255, 253, 142, 62, 255, 253, 143, 62, 255, 253, 143, 63, 255, 253, 143, 63, 255, 253, 143, 63, 255, 253, 144, 64, 255, 253, 144, 64, 255, 253, 144, 64, 255, 253, 144, 64, 255, 253, 144, 65, 255, 253, 145, 65, 255, 253, 145, 65, 255, 253, 145, 66, 255, 253, 145, 66, 255, 253, 145, 66, 255, 253, 146, 66, 255, 253, 146, 67, 255, 253, 146, 67, 255, 253, 146, 67, 255, 253, 147, 68, 255, 253, 147, 68, 255, 253, 147, 68, 255, 253, 147, 69, 255, 253, 147, 69, 255, 253, 148, 69, 255, 253, 148, 69, 255, 253, 148, 70, 255, 253, 148, 70, 255, 253, 148, 70, 255, 253, 149, 71, 255, 253, 149, 71, 255, 253, 149, 71, 255, 253, 149, 71, 255, 253, 150, 72, 255, 253, 150, 72, 255, 253, 150, 72, 255, 253, 150, 73, 255, 253, 150, 73, 255, 253, 151, 73, 255, 253, 151, 73, 255, 253, 151, 74, 255, 253, 151, 74, 255, 253, 151, 74, 255, 253, 152, 75, 255, 253, 152, 75, 255, 253, 152, 75, 255, 253, 152, 75, 255, 253, 152, 76, 255, 253, 153, 76, 255, 253, 153, 76, 255, 253, 153, 77, 255, 253, 153, 77, 255, 253, 153, 77, 255, 253, 154, 78, 255, 253, 154, 78, 255, 253, 161, 88, 255, 253, 161, 88, 255, 253, 161, 88, 255, 253, 161, 88, 255, 253, 162, 89, 255, 253, 162, 89, 255, 253, 162, 89, 255, 253, 162, 90, 255, 253, 162, 90, 255, 253, 163, 90, 255, 253, 163, 90, 255, 253, 163, 91, 255, 253, 163, 91, 255, 253, 163, 91, 255, 253, 164, 92, 255, 253, 164, 92, 255, 253, 164, 92, 255, 253, 164, 93, 255, 253, 164, 93, 255, 253, 165, 93, 255, 253, 165, 93, 255, 253, 165, 94, 255, 253, 165, 94, 255, 253, 165, 94, 255, 253, 166, 95, 255, 253, 166, 95, 255, 253, 166, 95, 255, 253, 166, 95, 255, 253, 166, 96, 255, 253, 167, 96, 255, 253, 167, 96, 255, 253, 167, 97, 255, 253, 167, 97, 255, 253, 167, 97, 255, 253, 168, 98, 255, 253, 168, 98, 255, 253, 168, 98, 255, 253, 168, 98, 255, 253, 168, 99, 255, 253, 169, 99, 255, 253, 169, 99, 255, 253, 169, 100, 255, 253, 169, 100, 255, 253, 169, 100, 255, 253, 170, 101, 255, 253, 170, 101, 255, 253, 170, 101, 255, 253, 170, 101, 255, 253, 170, 102, 255, 253, 171, 102, 255, 253, 171, 102, 255, 253, 171, 103, 255, 253, 171, 103, 255, 253, 171, 103, 255, 253, 172, 103, 255, 253, 172, 104, 255, 253, 172, 104, 255, 253, 172, 104, 255, 253, 172, 105, 255, 253, 173, 105, 255, 253, 173, 105, 255, 253, 173, 106, 255, 253, 173, 106, 255, 253, 173, 106, 255, 252, 174, 106, 255, 253, 174, 107, 255, 253, 174, 107, 255, 253, 174, 107, 255, 253, 174, 108, 255, 253, 175, 108, 255, 253, 175, 108, 255, 253, 175, 109, 255, 253, 175, 109, 255, 253, 176, 109, 255, 253, 176, 110, 255, 253, 176, 110, 255, 253, 176, 110, 255, 253, 176, 111, 255, 253, 177, 111, 255, 253, 177, 111, 255, 253, 177, 112, 255, 253, 177, 112, 255, 253, 177, 112, 255, 253, 178, 113, 255, 253, 178, 113, 255, 253, 178, 113, 255, 253, 178, 114, 255, 253, 179, 114, 255, 253, 179, 114, 255, 253, 179, 115, 255, 253, 179, 115, 255, 253, 179, 115, 255, 253, 180, 116, 255, 253, 180, 116, 255, 253, 180, 116, 255, 253, 180, 117, 255, 253, 181, 117, 255, 253, 181, 117, 255, 253, 181, 118, 255, 253, 181, 118, 255, 253, 181, 118, 255, 253, 182, 119, 255, 253, 182, 119, 255, 253, 182, 119, 255, 253, 182, 120, 255, 253, 182, 120, 255, 253, 183, 120, 255, 253, 183, 121, 255, 253, 183, 121, 255, 253, 183, 121, 255, 253, 184, 122, 255, 253, 184, 122, 255, 253, 184, 122, 255, 253, 184, 123, 255, 253, 184, 123, 255, 253, 185, 123, 255, 253, 185, 124, 255, 253, 185, 124, 255, 253, 185, 125, 255, 253, 186, 125, 255, 253, 186, 125, 255, 253, 186, 126, 255, 253, 186, 126, 255, 253, 186, 126, 255, 253, 187, 127, 255, 253, 187, 127, 255, 253, 187, 127, 255, 253, 187, 128, 255, 253, 194, 139, 255, 253, 194, 139, 255, 253, 195, 140, 255, 253, 195, 140, 255, 253, 195, 140, 255, 253, 195, 141, 255, 253, 195, 141, 255, 253, 196, 141, 255, 253, 196, 142, 255, 253, 196, 142, 255, 253, 196, 142, 255, 253, 197, 143, 255, 253, 197, 143, 255, 253, 197, 143, 255, 253, 197, 144, 255, 253, 197, 144, 255, 253, 198, 144, 255, 253, 198, 145, 255, 253, 198, 145, 255, 253, 198, 146, 255, 253, 198, 146, 255, 253, 199, 146, 255, 253, 199, 147, 255, 253, 199, 147, 255, 253, 199, 147, 255, 253, 199, 148, 255, 253, 200, 148, 255, 253, 200, 148, 255, 253, 200, 149, 255, 253, 200, 149, 255, 253, 201, 149, 255, 253, 201, 150, 255, 253, 201, 150, 255, 253, 201, 150, 255, 253, 201, 151, 255, 253, 202, 151, 255, 253, 202, 151, 255, 253, 202, 152, 255, 253, 202, 152, 255, 253, 202, 153, 255, 253, 203, 153, 255, 253, 203, 153, 255, 253, 203, 154, 255, 253, 203, 154, 255, 253, 203, 154, 255, 253, 204, 155, 255, 253, 204, 155, 255, 253, 204, 155, 255, 253, 204, 156, 255, 253, 204, 156, 255, 253, 205, 156, 255, 253, 205, 157, 255, 253, 205, 157, 255, 253, 205, 158, 255, 253, 205, 158, 255, 253, 206, 158, 255, 253, 206, 159, 255, 253, 206, 159, 255, 253, 206, 159, 255, 253, 206, 160, 255, 253, 207, 160, 255, 253, 207, 160, 255, 253, 207, 161, 255, 253, 207, 161, 255, 252, 208, 161, 255, 253, 208, 162, 255, 253, 208, 162, 255, 253, 208, 162, 255, 253, 208, 163, 255, 253, 208, 163, 255, 253, 208, 163, 255, 253, 208, 163, 255, 253, 209, 164, 255, 253, 209, 164, 255, 253, 209, 164, 255, 253, 209, 164, 255, 253, 209, 165, 255, 253, 209, 165, 255, 253, 209, 165, 255, 253, 210, 166, 255, 253, 210, 166, 255, 253, 210, 166, 255, 253, 210, 166, 255, 253, 210, 167, 255, 253, 210, 167, 255, 253, 210, 167, 255, 253, 211, 167, 255, 253, 211, 168, 255, 253, 211, 168, 255, 253, 211, 168, 255, 253, 211, 169, 255, 253, 211, 169, 255, 253, 211, 169, 255, 253, 211, 169, 255, 253, 212, 170, 255, 253, 212, 170, 255, 253, 212, 170, 255, 253, 212, 170, 255, 253, 212, 171, 255, 253, 212, 171, 255, 253, 212, 171, 255, 253, 213, 172, 255, 253, 213, 172, 255, 253, 213, 172, 255, 253, 213, 172, 255, 253, 213, 173, 255, 253, 213, 173, 255, 253, 213, 173, 255, 253, 214, 173, 255, 253, 214, 174, 255, 253, 214, 174, 255, 253, 214, 174, 255, 253, 214, 175, 255, 253, 214, 175, 255, 253, 214, 175, 255, 253, 215, 175, 255, 253, 215, 176, 255, 253, 215, 176, 255, 253, 215, 176, 255, 253, 215, 176, 255, 253, 215, 177, 255, 253, 215, 177, 255, 253, 215, 177, 255, 253, 216, 178, 255, 253, 216, 178, 255, 253, 216, 178, 255, 253, 216, 178, 255, 253, 216, 179, 255, 253, 221, 188, 255, 253, 221, 188, 255, 253, 221, 188, 255, 253, 221, 189, 255, 253, 221, 189, 255, 253, 221, 189, 255, 253, 222, 189, 255, 253, 222, 190, 255, 253, 222, 190, 255, 253, 222, 190, 255, 253, 222, 191, 255, 253, 222, 191, 255, 253, 222, 191, 255, 253, 223, 191, 255, 253, 223, 192, 255, 253, 223, 192, 255, 253, 223, 192, 255, 253, 223, 192, 255, 253, 223, 193, 255, 253, 223, 193, 255, 253, 223, 193, 255, 253, 224, 194, 255, 253, 224, 194, 255, 253, 224, 194, 255, 253, 224, 194, 255, 253, 224, 195, 255, 253, 224, 195, 255, 253, 224, 195, 255, 253, 225, 195, 255, 253, 225, 196, 255, 253, 225, 196, 255, 253, 225, 196, 255, 253, 225, 197, 255, 253, 225, 197, 255, 253, 225, 197, 255, 253, 226, 197, 255, 253, 226, 198, 255, 253, 226, 198, 255, 253, 226, 198, 255, 253, 226, 199, 255, 253, 226, 199, 255, 254, 226, 199, 255, 254, 226, 199, 255, 254, 227, 200, 255, 254, 227, 200, 255, 254, 227, 200, 255, 254, 227, 200, 255, 254, 227, 201, 255, 254, 227, 201, 255, 254, 227, 201, 255, 254, 228, 202, 255, 254, 228, 202, 255, 254, 228, 202, 255, 254, 228, 202, 255, 254, 228, 203, 255, 254, 228, 203, 255, 254, 228, 203, 255, 254, 229, 204, 255, 254, 229, 204, 255, 254, 229, 204, 255, 254, 229, 204, 255, 254, 229, 205, 255, 254, 229, 205, 255, 254, 229, 205, 255, 253, 230, 205, 255, 254, 230, 206, 255, 254, 230, 206, 255, 254, 230, 206, 255, 254, 230, 206, 255, 254, 230, 206, 255, 254, 230, 207, 255, 254, 230, 207, 255, 254, 230, 207, 255, 254, 230, 207, 255, 254, 230, 207, 255, 254, 231, 207, 255, 254, 231, 208, 255, 254, 231, 208, 255, 254, 231, 208, 255, 254, 231, 208, 255, 254, 231, 208, 255, 254, 231, 209, 255, 254, 231, 209, 255, 254, 231, 209, 255, 254, 231, 209, 255, 254, 231, 209, 255, 254, 232, 209, 255, 254, 232, 210, 255, 254, 232, 210, 255, 254, 232, 210, 255, 254, 232, 210, 255, 254, 232, 210, 255, 254, 232, 211, 255, 254, 232, 211, 255, 254, 232, 211, 255, 254, 232, 211, 255, 254, 233, 211, 255, 254, 233, 211, 255, 254, 233, 212, 255, 254, 233, 212, 255, 254, 233, 212, 255, 254, 233, 212, 255, 254, 233, 212, 255, 254, 233, 213, 255, 254, 233, 213, 255, 254, 233, 213, 255, 254, 233, 213, 255, 254, 234, 213, 255, 254, 234, 213, 255, 254, 234, 214, 255, 254, 234, 214, 255, 254, 234, 214, 255, 254, 234, 214, 255, 254, 234, 214, 255, 254, 234, 214, 255, 254, 234, 215, 255, 254, 234, 215, 255, 254, 234, 215, 255, 254, 235, 215, 255, 254, 235, 215, 255, 254, 235, 216, 255, 254, 235, 216, 255, 254, 235, 216, 255, 254, 235, 216, 255, 254, 235, 216, 255, 254, 235, 216, 255, 254, 235, 217, 255, 254, 235, 217, 255, 254, 239, 223, 255, 254, 239, 223, 255, 254, 239, 223, 255, 254, 239, 223, 255, 254, 239, 224, 255, 254, 239, 224, 255, 254, 239, 224, 255, 254, 239, 224, 255, 254, 239, 224, 255, 254, 239, 224, 255, 254, 239, 225, 255, 254, 240, 225, 255, 254, 240, 225, 255, 254, 240, 225, 255, 254, 240, 225, 255, 254, 240, 226, 255, 254, 240, 226, 255, 254, 240, 226, 255, 254, 240, 226, 255, 254, 240, 226, 255, 254, 240, 226, 255, 254, 240, 227, 255, 254, 241, 227, 255, 254, 241, 227, 255, 254, 241, 227, 255, 254, 241, 227, 255, 254, 241, 228, 255, 254, 241, 228, 255, 254, 241, 228, 255, 254, 241, 228, 255, 254, 241, 228, 255, 254, 241, 228, 255, 254, 242, 229, 255, 254, 242, 229, 255, 254, 242, 229, 255, 254, 242, 229, 255, 254, 242, 229, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Oranges_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 126, 39, 3, 0, 129, 39, 4, 24, 131, 40, 4, 49, 134, 41, 4, 74, 136, 42, 4, 99, 138, 43, 4, 124, 141, 44, 4, 149, 151, 48, 3, 174, 153, 49, 3, 199, 155, 50, 3, 224, 158, 50, 3, 249, 160, 51, 3, 255, 162, 52, 3, 255, 164, 53, 3, 255, 167, 54, 2, 255, 169, 55, 2, 255, 172, 56, 2, 255, 175, 57, 2, 255, 178, 58, 2, 255, 180, 59, 2, 255, 183, 60, 2, 255, 186, 61, 2, 255, 198, 65, 1, 255, 201, 66, 1, 255, 204, 67, 1, 255, 206, 68, 1, 255, 209, 69, 1, 255, 211, 70, 1, 255, 214, 71, 1, 255, 216, 71, 1, 255, 218, 73, 1, 255, 219, 75, 2, 255, 220, 76, 2, 255, 221, 78, 3, 255, 222, 79, 4, 255, 223, 81, 5, 255, 224, 83, 6, 255, 225, 84, 6, 255, 231, 92, 11, 255, 232, 94, 12, 255, 233, 95, 13, 255, 234, 96, 14, 255, 236, 98, 14, 255, 237, 99, 15, 255, 238, 100, 16, 255, 239, 102, 17, 255, 240, 103, 18, 255, 240, 104, 18, 255, 241, 106, 20, 255, 241, 108, 22, 255, 242, 109, 24, 255, 242, 111, 26, 255, 243, 112, 28, 255, 243, 113, 29, 255, 244, 115, 31, 255, 244, 116, 32, 255, 245, 118, 34, 255, 245, 119, 35, 255, 248, 127, 45, 255, 249, 129, 47, 255, 249, 130, 48, 255, 249, 131, 49, 255, 250, 133, 51, 255, 250, 134, 52, 255, 251, 135, 54, 255, 251, 136, 55, 255, 251, 137, 56, 255, 252, 139, 57, 255, 252, 140, 59, 255, 253, 141, 60, 255, 253, 142, 62, 255, 253, 143, 63, 255, 253, 144, 65, 255, 253, 146, 66, 255, 253, 147, 68, 255, 253, 148, 69, 255, 253, 149, 71, 255, 253, 150, 72, 255, 253, 151, 74, 255, 253, 152, 75, 255, 253, 153, 76, 255, 253, 154, 78, 255, 253, 161, 89, 255, 253, 162, 90, 255, 253, 163, 91, 255, 253, 164, 93, 255, 253, 165, 94, 255, 253, 166, 95, 255, 253, 167, 97, 255, 253, 168, 98, 255, 253, 169, 99, 255, 253, 170, 101, 255, 253, 170, 102, 255, 253, 171, 103, 255, 253, 172, 104, 255, 253, 173, 106, 255, 253, 174, 107, 255, 253, 175, 108, 255, 253, 176, 110, 255, 253, 177, 111, 255, 253, 177, 112, 255, 253, 178, 114, 255, 253, 179, 115, 255, 253, 180, 116, 255, 253, 181, 117, 255, 253, 182, 119, 255, 253, 182, 120, 255, 253, 183, 121, 255, 253, 184, 122, 255, 253, 185, 124, 255, 253, 186, 125, 255, 253, 186, 126, 255, 253, 187, 127, 255, 253, 195, 140, 255, 253, 195, 141, 255, 253, 196, 142, 255, 253, 197, 143, 255, 253, 198, 144, 255, 253, 198, 146, 255, 253, 199, 147, 255, 253, 200, 148, 255, 253, 200, 149, 255, 253, 201, 150, 255, 253, 202, 151, 255, 253, 202, 152, 255, 253, 203, 153, 255, 253, 204, 155, 255, 253, 204, 156, 255, 253, 205, 157, 255, 253, 205, 158, 255, 253, 206, 159, 255, 253, 207, 160, 255, 253, 207, 161, 255, 253, 208, 162, 255, 253, 208, 163, 255, 253, 208, 163, 255, 253, 209, 164, 255, 253, 209, 165, 255, 253, 210, 166, 255, 253, 210, 166, 255, 253, 210, 167, 255, 253, 211, 168, 255, 253, 211, 169, 255, 253, 211, 169, 255, 253, 212, 170, 255, 253, 212, 171, 255, 253, 212, 171, 255, 253, 213, 172, 255, 253, 213, 173, 255, 253, 213, 173, 255, 253, 214, 174, 255, 253, 214, 175, 255, 253, 214, 175, 255, 253, 215, 176, 255, 253, 215, 177, 255, 253, 215, 177, 255, 253, 216, 178, 255, 253, 216, 178, 255, 253, 221, 188, 255, 253, 221, 188, 255, 253, 221, 189, 255, 253, 222, 190, 255, 253, 222, 190, 255, 253, 222, 191, 255, 253, 223, 191, 255, 253, 223, 192, 255, 253, 223, 193, 255, 253, 223, 193, 255, 253, 224, 194, 255, 253, 224, 194, 255, 253, 224, 195, 255, 253, 224, 195, 255, 253, 225, 196, 255, 253, 225, 196, 255, 253, 225, 197, 255, 253, 225, 197, 255, 253, 226, 198, 255, 253, 226, 198, 255, 254, 226, 199, 255, 254, 226, 199, 255, 254, 227, 200, 255, 254, 227, 200, 255, 254, 227, 201, 255, 254, 227, 201, 255, 254, 228, 202, 255, 254, 228, 202, 255, 254, 228, 203, 255, 254, 228, 203, 255, 254, 229, 204, 255, 254, 229, 204, 255, 254, 229, 205, 255, 254, 229, 205, 255, 254, 229, 205, 255, 254, 230, 206, 255, 254, 230, 206, 255, 254, 230, 206, 255, 254, 230, 207, 255, 254, 230, 207, 255, 254, 230, 207, 255, 254, 230, 207, 255, 254, 231, 208, 255, 254, 231, 208, 255, 254, 231, 208, 255, 254, 231, 208, 255, 254, 231, 209, 255, 254, 231, 209, 255, 254, 231, 209, 255, 254, 231, 209, 255, 254, 232, 209, 255, 254, 232, 210, 255, 254, 232, 210, 255, 254, 232, 210, 255, 254, 232, 210, 255, 254, 232, 211, 255, 254, 232, 211, 255, 254, 232, 211, 255, 254, 233, 211, 255, 254, 233, 211, 255, 254, 233, 212, 255, 254, 233, 212, 255, 254, 233, 212, 255, 254, 233, 212, 255, 254, 233, 213, 255, 254, 233, 213, 255, 254, 233, 213, 255, 254, 233, 213, 255, 254, 234, 213, 255, 254, 234, 213, 255, 254, 234, 214, 255, 254, 234, 214, 255, 254, 234, 214, 255, 254, 234, 214, 255, 254, 234, 214, 255, 254, 234, 215, 255, 254, 234, 215, 255, 254, 234, 215, 255, 254, 235, 215, 255, 254, 235, 215, 255, 254, 235, 215, 255, 254, 235, 216, 255, 254, 235, 216, 255, 254, 235, 216, 255, 254, 235, 216, 255, 254, 235, 216, 255, 254, 235, 216, 255, 254, 235, 217, 255, 254, 235, 217, 255, 254, 235, 217, 255, 254, 239, 223, 255, 254, 239, 223, 255, 254, 239, 223, 255, 254, 239, 223, 255, 254, 239, 223, 255, 254, 239, 224, 255, 254, 239, 224, 255, 254, 239, 224, 255, 254, 239, 224, 255, 254, 239, 224, 255, 254, 239, 224, 255, 254, 239, 224, 255, 254, 239, 225, 255, 254, 239, 225, 255, 254, 240, 225, 255, 254, 240, 225, 255, 254, 240, 225, 255, 254, 240, 225, 255, 254, 240, 225, 255, 254, 240, 225, 255, 254, 240, 226, 255, 254, 240, 226, 255, 254, 240, 226, 255, 254, 240, 226, 255, 254, 240, 226, 255, 254, 240, 226, 255, 254, 240, 226, 255, 254, 240, 226, 255, 254, 240, 226, 255, 254, 240, 227, 255, 254, 240, 227, 255, 254, 241, 227, 255, 254, 241, 227, 255, 254, 241, 227, 255, 254, 241, 227, 255, 254, 241, 227, 255, 254, 241, 227, 255, 254, 241, 227, 255, 254, 241, 227, 255, 254, 241, 228, 255, 254, 241, 228, 255, 254, 241, 228, 255, 254, 241, 228, 255, 254, 241, 228, 255, 254, 241, 228, 255, 254, 241, 228, 255, 254, 241, 228, 255, 254, 241, 228, 255, 254, 241, 228, 255, 254, 241, 228, 255, 254, 241, 228, 255, 254, 241, 229, 255, 254, 242, 229, 255, 254, 242, 229, 255, 254, 242, 229, 255, 254, 242, 229, 255, 254, 242, 229, 255, 254, 242, 229, 255, 254, 242, 229, 255, 254, 242, 229, 255, 254, 242, 229, 255, 254, 242, 229, 255, 254, 242, 229, 255, 254, 242, 229, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 242, 230, 255, 254, 242, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 231, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 232, 255, 254, 243, 233, 255, 254, 243, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 233, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 244, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255, 254, 245, 234, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Oranges_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
