/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/GnBu.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 8, 64, 129, 255, 8, 104, 172, 255, 43, 140, 190, 255, 78, 179, 211, 255, 123, 204, 196, 255, 168, 221, 181, 255, 204, 235, 197, 255, 224, 243, 219, 255, 247, 252, 240, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_GnBu_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 8, 63, 129, 0, 8, 64, 129, 7, 8, 64, 129, 14, 8, 64, 130, 22, 8, 65, 130, 29, 8, 65, 130, 37, 8, 65, 131, 44, 8, 66, 131, 52, 8, 66, 131, 59, 8, 66, 132, 67, 8, 67, 132, 74, 8, 67, 132, 82, 8, 67, 133, 89, 8, 67, 133, 97, 8, 68, 133, 104, 8, 68, 134, 112, 8, 68, 134, 119, 8, 69, 134, 127, 8, 69, 135, 134, 8, 69, 135, 141, 7, 70, 135, 149, 7, 70, 136, 156, 7, 70, 136, 164, 7, 70, 136, 171, 7, 71, 137, 179, 7, 71, 137, 186, 7, 71, 137, 194, 7, 72, 138, 201, 7, 72, 138, 209, 7, 72, 138, 216, 7, 73, 139, 224, 7, 73, 139, 231, 7, 73, 139, 239, 7, 74, 140, 246, 7, 74, 140, 254, 7, 74, 140, 255, 7, 74, 141, 255, 7, 75, 141, 255, 7, 75, 141, 255, 7, 75, 142, 255, 7, 76, 142, 255, 7, 76, 142, 255, 7, 76, 143, 255, 7, 77, 143, 255, 7, 77, 143, 255, 7, 77, 144, 255, 7, 78, 144, 255, 7, 78, 144, 255, 7, 78, 145, 255, 7, 78, 145, 255, 7, 79, 145, 255, 7, 79, 146, 255, 7, 79, 146, 255, 7, 80, 146, 255, 7, 80, 147, 255, 7, 80, 147, 255, 7, 81, 147, 255, 7, 81, 148, 255, 7, 81, 148, 255, 7, 82, 148, 255, 7, 82, 149, 255, 7, 82, 149, 255, 7, 83, 149, 255, 7, 83, 150, 255, 7, 83, 150, 255, 7, 83, 150, 255, 7, 84, 151, 255, 7, 84, 151, 255, 7, 84, 151, 255, 7, 85, 152, 255, 7, 85, 152, 255, 7, 85, 152, 255, 7, 86, 153, 255, 7, 86, 153, 255, 7, 86, 153, 255, 7, 87, 154, 255, 7, 87, 154, 255, 7, 87, 154, 255, 7, 88, 155, 255, 7, 88, 155, 255, 7, 88, 155, 255, 7, 88, 156, 255, 7, 89, 156, 255, 7, 89, 156, 255, 7, 89, 157, 255, 7, 90, 157, 255, 7, 90, 157, 255, 7, 90, 158, 255, 7, 91, 158, 255, 7, 91, 158, 255, 7, 91, 159, 255, 7, 92, 159, 255, 7, 92, 159, 255, 7, 92, 160, 255, 7, 93, 160, 255, 7, 93, 161, 255, 7, 93, 161, 255, 7, 94, 161, 255, 7, 94, 162, 255, 7, 94, 162, 255, 7, 95, 162, 255, 7, 95, 163, 255, 7, 95, 163, 255, 7, 95, 163, 255, 7, 96, 164, 255, 7, 96, 164, 255, 7, 96, 164, 255, 7, 97, 165, 255, 7, 97, 165, 255, 7, 97, 165, 255, 7, 98, 166, 255, 7, 98, 166, 255, 7, 98, 166, 255, 7, 99, 167, 255, 7, 99, 167, 255, 7, 99, 167, 255, 7, 100, 168, 255, 7, 100, 168, 255, 7, 100, 168, 255, 7, 101, 169, 255, 7, 101, 169, 255, 7, 101, 169, 255, 7, 102, 170, 255, 7, 102, 170, 255, 7, 102, 170, 255, 7, 103, 171, 255, 7, 103, 171, 255, 7, 103, 171, 255, 8, 103, 172, 255, 7, 104, 172, 255, 7, 104, 172, 255, 7, 104, 172, 255, 7, 105, 172, 255, 7, 105, 172, 255, 7, 105, 172, 255, 8, 106, 173, 255, 8, 106, 173, 255, 8, 106, 173, 255, 8, 106, 173, 255, 8, 107, 173, 255, 8, 107, 173, 255, 8, 107, 174, 255, 8, 108, 174, 255, 8, 108, 174, 255, 8, 108, 174, 255, 8, 108, 174, 255, 8, 109, 174, 255, 8, 109, 175, 255, 9, 109, 175, 255, 9, 110, 175, 255, 9, 110, 175, 255, 9, 110, 175, 255, 9, 110, 175, 255, 9, 111, 176, 255, 9, 111, 176, 255, 10, 111, 176, 255, 10, 111, 176, 255, 10, 112, 176, 255, 10, 112, 176, 255, 10, 112, 176, 255, 11, 113, 177, 255, 11, 113, 177, 255, 11, 113, 177, 255, 11, 113, 177, 255, 12, 114, 177, 255, 12, 114, 177, 255, 12, 114, 178, 255, 12, 115, 178, 255, 12, 115, 178, 255, 13, 115, 178, 255, 13, 115, 178, 255, 13, 116, 178, 255, 14, 116, 178, 255, 14, 116, 179, 255, 14, 117, 179, 255, 14, 117, 179, 255, 15, 117, 179, 255, 15, 117, 179, 255, 15, 118, 179, 255, 16, 118, 179, 255, 16, 118, 180, 255, 16, 119, 180, 255, 16, 119, 180, 255, 17, 119, 180, 255, 17, 119, 180, 255, 17, 120, 180, 255, 18, 120, 180, 255, 18, 120, 181, 255, 18, 121, 181, 255, 19, 121, 181, 255, 19, 121, 181, 255, 19, 121, 181, 255, 20, 122, 181, 255, 20, 122, 181, 255, 20, 122, 182, 255, 21, 123, 182, 255, 21, 123, 182, 255, 21, 123, 182, 255, 22, 123, 182, 255, 22, 124, 182, 255, 22, 124, 182, 255, 23, 124, 183, 255, 23, 124, 183, 255, 23, 125, 183, 255, 24, 125, 183, 255, 24, 125, 183, 255, 24, 126, 183, 255, 25, 126, 183, 255, 25, 126, 183, 255, 25, 126, 184, 255, 26, 127, 184, 255, 26, 127, 184, 255, 26, 127, 184, 255, 27, 128, 184, 255, 27, 128, 184, 255, 27, 128, 184, 255, 28, 128, 185, 255, 28, 129, 185, 255, 28, 129, 185, 255, 29, 129, 185, 255, 29, 130, 185, 255, 30, 130, 185, 255, 30, 130, 185, 255, 30, 130, 185, 255, 31, 131, 186, 255, 31, 131, 186, 255, 31, 131, 186, 255, 32, 131, 186, 255, 32, 132, 186, 255, 32, 132, 186, 255, 33, 132, 186, 255, 33, 133, 186, 255, 34, 133, 187, 255, 34, 133, 187, 255, 34, 133, 187, 255, 35, 134, 187, 255, 35, 134, 187, 255, 35, 134, 187, 255, 36, 135, 187, 255, 36, 135, 187, 255, 37, 135, 188, 255, 37, 135, 188, 255, 37, 136, 188, 255, 38, 136, 188, 255, 38, 136, 188, 255, 38, 136, 188, 255, 39, 137, 188, 255, 39, 137, 188, 255, 39, 137, 189, 255, 40, 138, 189, 255, 40, 138, 189, 255, 41, 138, 189, 255, 41, 138, 189, 255, 41, 139, 189, 255, 42, 139, 189, 255, 42, 139, 189, 255, 43, 140, 190, 255, 43, 140, 190, 255, 43, 140, 190, 255, 43, 140, 190, 255, 43, 141, 190, 255, 43, 141, 190, 255, 44, 141, 191, 255, 44, 142, 191, 255, 44, 142, 191, 255, 44, 142, 191, 255, 44, 143, 191, 255, 45, 143, 192, 255, 45, 143, 192, 255, 45, 143, 192, 255, 45, 144, 192, 255, 45, 144, 192, 255, 46, 144, 192, 255, 46, 145, 193, 255, 46, 145, 193, 255, 46, 145, 193, 255, 46, 146, 193, 255, 47, 146, 193, 255, 47, 146, 193, 255, 47, 147, 194, 255, 47, 147, 194, 255, 47, 147, 194, 255, 48, 147, 194, 255, 48, 148, 194, 255, 48, 148, 195, 255, 48, 148, 195, 255, 49, 149, 195, 255, 49, 149, 195, 255, 49, 149, 195, 255, 49, 150, 195, 255, 49, 150, 196, 255, 50, 150, 196, 255, 50, 151, 196, 255, 50, 151, 196, 255, 50, 151, 196, 255, 51, 151, 196, 255, 51, 152, 197, 255, 51, 152, 197, 255, 51, 152, 197, 255, 52, 153, 197, 255, 52, 153, 197, 255, 52, 153, 197, 255, 52, 154, 198, 255, 53, 154, 198, 255, 53, 154, 198, 255, 53, 154, 198, 255, 53, 155, 198, 255, 54, 155, 198, 255, 54, 155, 199, 255, 54, 156, 199, 255, 55, 156, 199, 255, 55, 156, 199, 255, 55, 157, 199, 255, 55, 157, 199, 255, 56, 157, 200, 255, 56, 158, 200, 255, 56, 158, 200, 255, 56, 158, 200, 255, 57, 158, 200, 255, 57, 159, 200, 255, 57, 159, 201, 255, 58, 159, 201, 255, 58, 160, 201, 255, 58, 160, 201, 255, 58, 160, 201, 255, 59, 161, 201, 255, 59, 161, 202, 255, 59, 161, 202, 255, 60, 162, 202, 255, 60, 162, 202, 255, 60, 162, 202, 255, 60, 162, 202, 255, 61, 163, 203, 255, 61, 163, 203, 255, 61, 163, 203, 255, 62, 164, 203, 255, 62, 164, 203, 255, 62, 164, 203, 255, 63, 165, 203, 255, 63, 165, 204, 255, 63, 165, 204, 255, 63, 165, 204, 255, 64, 166, 204, 255, 64, 166, 204, 255, 64, 166, 204, 255, 65, 167, 205, 255, 65, 167, 205, 255, 65, 167, 205, 255, 66, 168, 205, 255, 66, 168, 205, 255, 66, 168, 205, 255, 67, 169, 206, 255, 67, 169, 206, 255, 67, 169, 206, 255, 68, 169, 206, 255, 68, 170, 206, 255, 68, 170, 206, 255, 68, 170, 206, 255, 69, 171, 207, 255, 69, 171, 207, 255, 69, 171, 207, 255, 70, 172, 207, 255, 70, 172, 207, 255, 70, 172, 207, 255, 71, 172, 208, 255, 71, 173, 208, 255, 71, 173, 208, 255, 72, 173, 208, 255, 72, 174, 208, 255, 72, 174, 208, 255, 73, 174, 208, 255, 73, 175, 209, 255, 73, 175, 209, 255, 74, 175, 209, 255, 74, 175, 209, 255, 74, 176, 209, 255, 75, 176, 209, 255, 75, 176, 209, 255, 75, 177, 210, 255, 76, 177, 210, 255, 76, 177, 210, 255, 76, 178, 210, 255, 77, 178, 210, 255, 77, 178, 210, 255, 78, 179, 211, 255, 78, 179, 210, 255, 78, 179, 210, 255, 78, 179, 210, 255, 78, 179, 210, 255, 78, 180, 210, 255, 78, 180, 210, 255, 78, 180, 210, 255, 79, 180, 210, 255, 79, 181, 210, 255, 79, 181, 210, 255, 79, 181, 210, 255, 79, 181, 209, 255, 79, 181, 209, 255, 80, 182, 209, 255, 80, 182, 209, 255, 80, 182, 209, 255, 80, 182, 209, 255, 80, 182, 209, 255, 80, 183, 209, 255, 81, 183, 209, 255, 81, 183, 209, 255, 81, 183, 208, 255, 81, 184, 208, 255, 82, 184, 208, 255, 82, 184, 208, 255, 82, 184, 208, 255, 82, 184, 208, 255, 83, 185, 208, 255, 83, 185, 208, 255, 83, 185, 208, 255, 83, 185, 208, 255, 84, 185, 207, 255, 84, 186, 207, 255, 84, 186, 207, 255, 84, 186, 207, 255, 85, 186, 207, 255, 85, 187, 207, 255, 85, 187, 207, 255, 86, 187, 207, 255, 86, 187, 206, 255, 86, 187, 206, 255, 86, 188, 206, 255, 87, 188, 206, 255, 87, 188, 206, 255, 87, 188, 206, 255, 88, 188, 206, 255, 88, 189, 206, 255, 88, 189, 206, 255, 89, 189, 205, 255, 89, 189, 205, 255, 89, 189, 205, 255, 90, 190, 205, 255, 90, 190, 205, 255, 90, 190, 205, 255, 91, 190, 205, 255, 91, 190, 205, 255, 92, 191, 204, 255, 92, 191, 204, 255, 92, 191, 204, 255, 93, 191, 204, 255, 93, 191, 204, 255, 93, 192, 204, 255, 94, 192, 204, 255, 94, 192, 204, 255, 95, 192, 203, 255, 95, 192, 203, 255, 95, 193, 203, 255, 96, 193, 203, 255, 96, 193, 203, 255, 96, 193, 203, 255, 97, 193, 203, 255, 97, 193, 203, 255, 98, 194, 202, 255, 98, 194, 202, 255, 98, 194, 202, 255, 99, 194, 202, 255, 99, 194, 202, 255, 100, 195, 202, 255, 100, 195, 202, 255, 101, 195, 202, 255, 101, 195, 201, 255, 101, 195, 201, 255, 102, 196, 201, 255, 102, 196, 201, 255, 103, 196, 201, 255, 103, 196, 201, 255, 104, 196, 201, 255, 104, 196, 200, 255, 104, 197, 200, 255, 105, 197, 200, 255, 105, 197, 200, 255, 106, 197, 200, 255, 106, 197, 200, 255, 107, 198, 200, 255, 107, 198, 200, 255, 108, 198, 199, 255, 108, 198, 199, 255, 108, 198, 199, 255, 109, 198, 199, 255, 109, 199, 199, 255, 110, 199, 199, 255, 110, 199, 199, 255, 111, 199, 199, 255, 111, 199, 198, 255, 112, 200, 198, 255, 112, 200, 198, 255, 113, 200, 198, 255, 113, 200, 198, 255, 113, 200, 198, 255, 114, 200, 198, 255, 114, 201, 198, 255, 115, 201, 197, 255, 115, 201, 197, 255, 116, 201, 197, 255, 116, 201, 197, 255, 117, 201, 197, 255, 117, 202, 197, 255, 118, 202, 197, 255, 118, 202, 197, 255, 119, 202, 196, 255, 119, 202, 196, 255, 120, 202, 196, 255, 120, 203, 196, 255, 121, 203, 196, 255, 121, 203, 196, 255, 122, 203, 196, 255, 122, 203, 196, 255, 123, 204, 195, 255, 123, 204, 195, 255, 123, 204, 195, 255, 123, 204, 195, 255, 124, 204, 195, 255, 124, 204, 195, 255, 124, 204, 195, 255, 124, 205, 195, 255, 125, 205, 195, 255, 125, 205, 195, 255, 125, 205, 194, 255, 125, 205, 194, 255, 126, 205, 194, 255, 126, 205, 194, 255, 126, 206, 194, 255, 127, 206, 194, 255, 127, 206, 194, 255, 127, 206, 194, 255, 127, 206, 194, 255, 128, 206, 193, 255, 128, 207, 193, 255, 128, 207, 193, 255, 129, 207, 193, 255, 129, 207, 193, 255, 129, 207, 193, 255, 130, 207, 193, 255, 130, 207, 193, 255, 130, 208, 193, 255, 130, 208, 192, 255, 131, 208, 192, 255, 131, 208, 192, 255, 131, 208, 192, 255, 132, 208, 192, 255, 132, 208, 192, 255, 132, 209, 192, 255, 133, 209, 192, 255, 133, 209, 191, 255, 133, 209, 191, 255, 134, 209, 191, 255, 134, 209, 191, 255, 134, 209, 191, 255, 135, 210, 191, 255, 135, 210, 191, 255, 135, 210, 191, 255, 136, 210, 191, 255, 136, 210, 190, 255, 136, 210, 190, 255, 137, 210, 190, 255, 137, 211, 190, 255, 137, 211, 190, 255, 138, 211, 190, 255, 138, 211, 190, 255, 138, 211, 190, 255, 139, 211, 189, 255, 139, 211, 189, 255, 139, 211, 189, 255, 140, 212, 189, 255, 140, 212, 189, 255, 140, 212, 189, 255, 141, 212, 189, 255, 141, 212, 189, 255, 141, 212, 188, 255, 142, 212, 188, 255, 142, 213, 188, 255, 142, 213, 188, 255, 143, 213, 188, 255, 143, 213, 188, 255, 144, 213, 188, 255, 144, 213, 188, 255, 144, 213, 187, 255, 145, 213, 187, 255, 145, 214, 187, 255, 145, 214, 187, 255, 146, 214, 187, 255, 146, 214, 187, 255, 146, 214, 187, 255, 147, 214, 187, 255, 147, 214, 186, 255, 148, 215, 186, 255, 148, 215, 186, 255, 148, 215, 186, 255, 149, 215, 186, 255, 149, 215, 186, 255, 149, 215, 186, 255, 150, 215, 186, 255, 150, 215, 186, 255, 151, 216, 185, 255, 151, 216, 185, 255, 151, 216, 185, 255, 152, 216, 185, 255, 152, 216, 185, 255, 153, 216, 185, 255, 153, 216, 185, 255, 153, 216, 185, 255, 154, 217, 184, 255, 154, 217, 184, 255, 154, 217, 184, 255, 155, 217, 184, 255, 155, 217, 184, 255, 156, 217, 184, 255, 156, 217, 184, 255, 156, 217, 184, 255, 157, 217, 183, 255, 157, 218, 183, 255, 158, 218, 183, 255, 158, 218, 183, 255, 158, 218, 183, 255, 159, 218, 183, 255, 159, 218, 183, 255, 160, 218, 183, 255, 160, 218, 183, 255, 160, 219, 182, 255, 161, 219, 182, 255, 161, 219, 182, 255, 162, 219, 182, 255, 162, 219, 182, 255, 163, 219, 182, 255, 163, 219, 182, 255, 163, 219, 182, 255, 164, 219, 182, 255, 164, 220, 181, 255, 165, 220, 181, 255, 165, 220, 181, 255, 165, 220, 181, 255, 166, 220, 181, 255, 166, 220, 181, 255, 167, 220, 181, 255, 167, 220, 181, 255, 167, 221, 180, 255, 168, 221, 181, 255, 168, 221, 181, 255, 168, 221, 181, 255, 169, 221, 181, 255, 169, 221, 181, 255, 169, 221, 181, 255, 170, 221, 181, 255, 170, 221, 181, 255, 170, 221, 181, 255, 170, 222, 182, 255, 171, 222, 182, 255, 171, 222, 182, 255, 171, 222, 182, 255, 172, 222, 182, 255, 172, 222, 182, 255, 172, 222, 182, 255, 173, 222, 182, 255, 173, 222, 182, 255, 173, 223, 183, 255, 173, 223, 183, 255, 174, 223, 183, 255, 174, 223, 183, 255, 174, 223, 183, 255, 175, 223, 183, 255, 175, 223, 183, 255, 175, 223, 183, 255, 175, 223, 183, 255, 176, 224, 184, 255, 176, 224, 184, 255, 176, 224, 184, 255, 177, 224, 184, 255, 177, 224, 184, 255, 177, 224, 184, 255, 178, 224, 184, 255, 178, 224, 184, 255, 178, 224, 184, 255, 178, 225, 185, 255, 179, 225, 185, 255, 179, 225, 185, 255, 179, 225, 185, 255, 180, 225, 185, 255, 180, 225, 185, 255, 180, 225, 185, 255, 180, 225, 185, 255, 181, 225, 186, 255, 181, 226, 186, 255, 181, 226, 186, 255, 182, 226, 186, 255, 182, 226, 186, 255, 182, 226, 186, 255, 182, 226, 186, 255, 183, 226, 186, 255, 183, 226, 186, 255, 183, 226, 187, 255, 184, 226, 187, 255, 184, 227, 187, 255, 184, 227, 187, 255, 184, 227, 187, 255, 185, 227, 187, 255, 185, 227, 187, 255, 185, 227, 187, 255, 186, 227, 188, 255, 186, 227, 188, 255, 186, 227, 188, 255, 186, 228, 188, 255, 187, 228, 188, 255, 187, 228, 188, 255, 187, 228, 188, 255, 187, 228, 188, 255, 188, 228, 189, 255, 188, 228, 189, 255, 188, 228, 189, 255, 189, 228, 189, 255, 189, 229, 189, 255, 189, 229, 189, 255, 189, 229, 189, 255, 190, 229, 189, 255, 190, 229, 190, 255, 190, 229, 190, 255, 191, 229, 190, 255, 191, 229, 190, 255, 191, 229, 190, 255, 191, 230, 190, 255, 192, 230, 190, 255, 192, 230, 191, 255, 192, 230, 191, 255, 192, 230, 191, 255, 193, 230, 191, 255, 193, 230, 191, 255, 193, 230, 191, 255, 194, 230, 191, 255, 194, 231, 191, 255, 194, 231, 192, 255, 194, 231, 192, 255, 195, 231, 192, 255, 195, 231, 192, 255, 195, 231, 192, 255, 195, 231, 192, 255, 196, 231, 192, 255, 196, 231, 193, 255, 196, 232, 193, 255, 197, 232, 193, 255, 197, 232, 193, 255, 197, 232, 193, 255, 197, 232, 193, 255, 198, 232, 193, 255, 198, 232, 194, 255, 198, 232, 194, 255, 198, 232, 194, 255, 199, 233, 194, 255, 199, 233, 194, 255, 199, 233, 194, 255, 200, 233, 194, 255, 200, 233, 194, 255, 200, 233, 195, 255, 200, 233, 195, 255, 201, 233, 195, 255, 201, 233, 195, 255, 201, 234, 195, 255, 201, 234, 195, 255, 202, 234, 195, 255, 202, 234, 196, 255, 202, 234, 196, 255, 202, 234, 196, 255, 203, 234, 196, 255, 203, 234, 196, 255, 203, 234, 196, 255, 203, 235, 196, 255, 204, 235, 197, 255, 204, 235, 197, 255, 204, 235, 197, 255, 204, 235, 197, 255, 204, 235, 197, 255, 204, 235, 198, 255, 205, 235, 198, 255, 205, 235, 198, 255, 205, 235, 198, 255, 205, 235, 198, 255, 205, 235, 198, 255, 205, 235, 199, 255, 206, 235, 199, 255, 206, 235, 199, 255, 206, 235, 199, 255, 206, 236, 199, 255, 206, 236, 199, 255, 206, 236, 200, 255, 206, 236, 200, 255, 207, 236, 200, 255, 207, 236, 200, 255, 207, 236, 200, 255, 207, 236, 200, 255, 207, 236, 201, 255, 207, 236, 201, 255, 208, 236, 201, 255, 208, 236, 201, 255, 208, 236, 201, 255, 208, 236, 201, 255, 208, 236, 202, 255, 208, 236, 202, 255, 209, 237, 202, 255, 209, 237, 202, 255, 209, 237, 202, 255, 209, 237, 202, 255, 209, 237, 203, 255, 209, 237, 203, 255, 209, 237, 203, 255, 210, 237, 203, 255, 210, 237, 203, 255, 210, 237, 204, 255, 210, 237, 204, 255, 210, 237, 204, 255, 210, 237, 204, 255, 211, 237, 204, 255, 211, 237, 204, 255, 211, 237, 205, 255, 211, 238, 205, 255, 211, 238, 205, 255, 211, 238, 205, 255, 212, 238, 205, 255, 212, 238, 205, 255, 212, 238, 206, 255, 212, 238, 206, 255, 212, 238, 206, 255, 212, 238, 206, 255, 212, 238, 206, 255, 213, 238, 206, 255, 213, 238, 207, 255, 213, 238, 207, 255, 213, 238, 207, 255, 213, 238, 207, 255, 213, 238, 207, 255, 214, 239, 207, 255, 214, 239, 208, 255, 214, 239, 208, 255, 214, 239, 208, 255, 214, 239, 208, 255, 214, 239, 208, 255, 214, 239, 208, 255, 215, 239, 209, 255, 215, 239, 209, 255, 215, 239, 209, 255, 215, 239, 209, 255, 215, 239, 209, 255, 215, 239, 210, 255, 216, 239, 210, 255, 216, 239, 210, 255, 216, 239, 210, 255, 216, 240, 210, 255, 216, 240, 210, 255, 216, 240, 211, 255, 217, 240, 211, 255, 217, 240, 211, 255, 217, 240, 211, 255, 217, 240, 211, 255, 217, 240, 211, 255, 217, 240, 212, 255, 217, 240, 212, 255, 218, 240, 212, 255, 218, 240, 212, 255, 218, 240, 212, 255, 218, 240, 212, 255, 218, 240, 213, 255, 218, 240, 213, 255, 219, 241, 213, 255, 219, 241, 213, 255, 219, 241, 213, 255, 219, 241, 213, 255, 219, 241, 214, 255, 219, 241, 214, 255, 219, 241, 214, 255, 220, 241, 214, 255, 220, 241, 214, 255, 220, 241, 215, 255, 220, 241, 215, 255, 220, 241, 215, 255, 220, 241, 215, 255, 221, 241, 215, 255, 221, 241, 215, 255, 221, 241, 216, 255, 221, 242, 216, 255, 221, 242, 216, 255, 221, 242, 216, 255, 221, 242, 216, 255, 222, 242, 216, 255, 222, 242, 217, 255, 222, 242, 217, 255, 222, 242, 217, 255, 222, 242, 217, 255, 222, 242, 217, 255, 223, 242, 217, 255, 223, 242, 218, 255, 223, 242, 218, 255, 223, 242, 218, 255, 223, 242, 218, 255, 223, 242, 218, 255, 223, 243, 218, 255, 224, 243, 219, 255, 224, 243, 219, 255, 224, 243, 219, 255, 224, 243, 219, 255, 225, 243, 219, 255, 225, 243, 219, 255, 225, 243, 220, 255, 225, 243, 220, 255, 225, 243, 220, 255, 226, 243, 220, 255, 226, 243, 220, 255, 226, 243, 220, 255, 226, 243, 220, 255, 226, 243, 221, 255, 227, 243, 221, 255, 227, 244, 221, 255, 227, 244, 221, 255, 227, 244, 221, 255, 227, 244, 221, 255, 228, 244, 221, 255, 228, 244, 222, 255, 228, 244, 222, 255, 228, 244, 222, 255, 228, 244, 222, 255, 229, 244, 222, 255, 229, 244, 222, 255, 229, 244, 222, 255, 229, 244, 223, 255, 229, 244, 223, 255, 229, 244, 223, 255, 230, 245, 223, 255, 230, 245, 223, 255, 230, 245, 223, 255, 230, 245, 224, 255, 230, 245, 224, 255, 231, 245, 224, 255, 231, 245, 224, 255, 231, 245, 224, 255, 231, 245, 224, 255, 231, 245, 225, 255, 232, 245, 225, 255, 232, 245, 225, 255, 232, 245, 225, 255, 232, 245, 225, 255, 232, 246, 225, 255, 233, 246, 225, 255, 233, 246, 226, 255, 233, 246, 226, 255, 233, 246, 226, 255, 233, 246, 226, 255, 233, 246, 226, 255, 234, 246, 226, 255, 234, 246, 227, 255, 234, 246, 227, 255, 234, 246, 227, 255, 234, 246, 227, 255, 235, 246, 227, 255, 235, 246, 227, 255, 235, 246, 228, 255, 235, 247, 228, 255, 235, 247, 228, 255, 235, 247, 228, 255, 236, 247, 228, 255, 236, 247, 228, 255, 236, 247, 229, 255, 236, 247, 229, 255, 236, 247, 229, 255, 237, 247, 229, 255, 237, 247, 229, 255, 237, 247, 229, 255, 237, 247, 230, 255, 237, 247, 230, 255, 237, 247, 230, 255, 238, 248, 230, 255, 238, 248, 230, 255, 238, 248, 230, 255, 238, 248, 231, 255, 238, 248, 231, 255, 239, 248, 231, 255, 239, 248, 231, 255, 239, 248, 231, 255, 239, 248, 231, 255, 239, 248, 232, 255, 239, 248, 232, 255, 240, 248, 232, 255, 240, 248, 232, 255, 240, 248, 232, 255, 240, 249, 232, 255, 240, 249, 233, 255, 240, 249, 233, 255, 241, 249, 233, 255, 241, 249, 233, 255, 241, 249, 233, 255, 241, 249, 233, 255, 241, 249, 234, 255, 241, 249, 234, 255, 242, 249, 234, 255, 242, 249, 234, 255, 242, 249, 234, 255, 242, 249, 234, 255, 242, 249, 235, 255, 242, 250, 235, 255, 243, 250, 235, 255, 243, 250, 235, 255, 243, 250, 235, 255, 243, 250, 236, 255, 243, 250, 236, 255, 243, 250, 236, 255, 244, 250, 236, 255, 244, 250, 236, 255, 244, 250, 236, 255, 244, 250, 237, 255, 244, 250, 237, 255, 244, 250, 237, 255, 244, 251, 237, 255, 245, 251, 237, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 246, 251, 238, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_GnBu_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 8, 63, 129, 0, 8, 64, 129, 7, 8, 64, 129, 14, 8, 64, 129, 22, 8, 64, 130, 29, 8, 65, 130, 37, 8, 65, 130, 44, 8, 65, 130, 52, 8, 65, 131, 59, 8, 66, 131, 67, 8, 66, 131, 74, 8, 66, 131, 82, 8, 66, 132, 89, 8, 67, 132, 97, 8, 67, 132, 104, 8, 67, 133, 112, 8, 67, 133, 119, 8, 68, 133, 127, 8, 68, 133, 134, 8, 68, 134, 141, 7, 68, 134, 149, 7, 69, 134, 156, 7, 69, 134, 164, 7, 69, 135, 171, 7, 69, 135, 179, 7, 70, 135, 186, 7, 70, 136, 194, 7, 70, 136, 201, 7, 70, 136, 209, 7, 71, 136, 216, 7, 71, 137, 224, 7, 71, 137, 231, 7, 71, 137, 239, 7, 72, 137, 246, 7, 72, 138, 254, 7, 72, 138, 255, 7, 72, 138, 255, 7, 73, 139, 255, 7, 73, 139, 255, 7, 73, 139, 255, 7, 73, 139, 255, 7, 74, 140, 255, 7, 74, 140, 255, 7, 74, 140, 255, 7, 74, 140, 255, 7, 74, 141, 255, 7, 75, 141, 255, 7, 75, 141, 255, 7, 75, 141, 255, 7, 75, 142, 255, 7, 76, 142, 255, 7, 76, 142, 255, 7, 76, 143, 255, 7, 76, 143, 255, 7, 77, 143, 255, 7, 77, 143, 255, 7, 77, 144, 255, 7, 77, 144, 255, 7, 78, 144, 255, 7, 78, 144, 255, 7, 78, 145, 255, 7, 78, 145, 255, 7, 79, 145, 255, 7, 79, 146, 255, 7, 87, 154, 255, 7, 87, 155, 255, 7, 88, 155, 255, 7, 88, 155, 255, 7, 88, 155, 255, 7, 88, 156, 255, 7, 89, 156, 255, 7, 89, 156, 255, 7, 89, 157, 255, 7, 89, 157, 255, 7, 90, 157, 255, 7, 90, 157, 255, 7, 90, 158, 255, 7, 90, 158, 255, 7, 91, 158, 255, 7, 91, 158, 255, 7, 91, 159, 255, 7, 91, 159, 255, 7, 92, 159, 255, 7, 92, 159, 255, 7, 92, 160, 255, 7, 93, 160, 255, 7, 93, 160, 255, 7, 93, 161, 255, 7, 93, 161, 255, 7, 94, 161, 255, 7, 94, 161, 255, 7, 94, 162, 255, 7, 94, 162, 255, 7, 95, 162, 255, 7, 95, 162, 255, 7, 95, 163, 255, 7, 95, 163, 255, 7, 96, 163, 255, 7, 96, 164, 255, 7, 96, 164, 255, 7, 96, 164, 255, 7, 97, 164, 255, 7, 97, 165, 255, 7, 97, 165, 255, 7, 97, 165, 255, 7, 98, 165, 255, 7, 98, 166, 255, 7, 98, 166, 255, 7, 98, 166, 255, 7, 99, 166, 255, 7, 99, 167, 255, 7, 99, 167, 255, 7, 99, 167, 255, 7, 100, 168, 255, 7, 100, 168, 255, 7, 100, 168, 255, 7, 100, 168, 255, 7, 101, 169, 255, 7, 101, 169, 255, 7, 101, 169, 255, 7, 101, 169, 255, 7, 102, 170, 255, 7, 102, 170, 255, 7, 102, 170, 255, 7, 102, 170, 255, 7, 103, 171, 255, 7, 103, 171, 255, 7, 103, 171, 255, 8, 103, 172, 255, 7, 104, 172, 255, 7, 104, 172, 255, 7, 104, 172, 255, 7, 104, 172, 255, 7, 105, 172, 255, 7, 105, 172, 255, 8, 105, 172, 255, 8, 105, 173, 255, 8, 106, 173, 255, 8, 106, 173, 255, 8, 106, 173, 255, 8, 106, 173, 255, 8, 106, 173, 255, 8, 107, 173, 255, 8, 107, 173, 255, 8, 107, 174, 255, 8, 107, 174, 255, 8, 108, 174, 255, 8, 108, 174, 255, 8, 108, 174, 255, 8, 108, 174, 255, 9, 109, 174, 255, 9, 109, 174, 255, 9, 109, 175, 255, 9, 109, 175, 255, 9, 109, 175, 255, 9, 110, 175, 255, 9, 110, 175, 255, 9, 110, 175, 255, 10, 110, 175, 255, 10, 111, 175, 255, 10, 111, 176, 255, 10, 111, 176, 255, 10, 111, 176, 255, 11, 111, 176, 255, 11, 112, 176, 255, 11, 112, 176, 255, 11, 112, 176, 255, 11, 112, 176, 255, 11, 113, 177, 255, 12, 113, 177, 255, 12, 113, 177, 255, 12, 113, 177, 255, 12, 114, 177, 255, 13, 114, 177, 255, 13, 114, 177, 255, 13, 114, 177, 255, 13, 114, 178, 255, 13, 115, 178, 255, 14, 115, 178, 255, 14, 115, 178, 255, 14, 115, 178, 255, 14, 116, 178, 255, 15, 116, 178, 255, 15, 116, 178, 255, 15, 116, 178, 255, 15, 116, 179, 255, 16, 117, 179, 255, 16, 117, 179, 255, 16, 117, 179, 255, 16, 117, 179, 255, 17, 118, 179, 255, 17, 118, 179, 255, 24, 125, 183, 255, 24, 125, 183, 255, 25, 126, 183, 255, 25, 126, 183, 255, 25, 126, 183, 255, 25, 126, 183, 255, 26, 127, 184, 255, 26, 127, 184, 255, 26, 127, 184, 255, 27, 127, 184, 255, 27, 127, 184, 255, 27, 128, 184, 255, 27, 128, 184, 255, 28, 128, 184, 255, 28, 128, 184, 255, 28, 129, 185, 255, 28, 129, 185, 255, 29, 129, 185, 255, 29, 129, 185, 255, 29, 130, 185, 255, 30, 130, 185, 255, 30, 130, 185, 255, 30, 130, 185, 255, 30, 130, 185, 255, 31, 131, 186, 255, 31, 131, 186, 255, 31, 131, 186, 255, 32, 131, 186, 255, 32, 132, 186, 255, 32, 132, 186, 255, 32, 132, 186, 255, 33, 132, 186, 255, 33, 132, 186, 255, 33, 133, 186, 255, 34, 133, 187, 255, 34, 133, 187, 255, 34, 133, 187, 255, 34, 134, 187, 255, 35, 134, 187, 255, 35, 134, 187, 255, 35, 134, 187, 255, 36, 134, 187, 255, 36, 135, 187, 255, 36, 135, 187, 255, 37, 135, 188, 255, 37, 135, 188, 255, 37, 136, 188, 255, 37, 136, 188, 255, 38, 136, 188, 255, 38, 136, 188, 255, 38, 136, 188, 255, 39, 137, 188, 255, 39, 137, 188, 255, 39, 137, 188, 255, 39, 137, 189, 255, 40, 138, 189, 255, 40, 138, 189, 255, 40, 138, 189, 255, 41, 138, 189, 255, 41, 138, 189, 255, 41, 139, 189, 255, 42, 139, 189, 255, 42, 139, 189, 255, 42, 139, 189, 255, 43, 140, 190, 255, 43, 140, 190, 255, 43, 140, 190, 255, 43, 140, 190, 255, 43, 140, 190, 255, 43, 141, 190, 255, 43, 141, 190, 255, 43, 141, 191, 255, 44, 141, 191, 255, 44, 142, 191, 255, 44, 142, 191, 255, 44, 142, 191, 255, 44, 142, 191, 255, 44, 143, 191, 255, 45, 143, 192, 255, 45, 143, 192, 255, 45, 143, 192, 255, 45, 144, 192, 255, 45, 144, 192, 255, 45, 144, 192, 255, 46, 144, 192, 255, 46, 145, 193, 255, 46, 145, 193, 255, 46, 145, 193, 255, 46, 145, 193, 255, 46, 146, 193, 255, 47, 146, 193, 255, 47, 146, 193, 255, 47, 146, 194, 255, 47, 147, 194, 255, 47, 147, 194, 255, 48, 147, 194, 255, 48, 147, 194, 255, 48, 148, 194, 255, 48, 148, 194, 255, 48, 148, 194, 255, 48, 148, 195, 255, 49, 149, 195, 255, 49, 149, 195, 255, 49, 149, 195, 255, 49, 149, 195, 255, 49, 150, 195, 255, 50, 150, 195, 255, 50, 150, 196, 255, 50, 150, 196, 255, 50, 151, 196, 255, 50, 151, 196, 255, 51, 151, 196, 255, 51, 151, 196, 255, 51, 151, 196, 255, 51, 152, 197, 255, 51, 152, 197, 255, 52, 152, 197, 255, 52, 152, 197, 255, 52, 153, 197, 255, 52, 153, 197, 255, 53, 153, 197, 255, 53, 153, 197, 255, 53, 154, 198, 255, 53, 154, 198, 255, 53, 154, 198, 255, 54, 154, 198, 255, 54, 155, 198, 255, 54, 155, 198, 255, 61, 163, 203, 255, 62, 163, 203, 255, 62, 163, 203, 255, 62, 164, 203, 255, 62, 164, 203, 255, 62, 164, 203, 255, 63, 164, 203, 255, 63, 165, 203, 255, 63, 165, 204, 255, 63, 165, 204, 255, 64, 165, 204, 255, 64, 166, 204, 255, 64, 166, 204, 255, 64, 166, 204, 255, 65, 166, 204, 255, 65, 167, 205, 255, 65, 167, 205, 255, 65, 167, 205, 255, 66, 167, 205, 255, 66, 168, 205, 255, 66, 168, 205, 255, 66, 168, 205, 255, 67, 168, 205, 255, 67, 169, 206, 255, 67, 169, 206, 255, 67, 169, 206, 255, 68, 169, 206, 255, 68, 170, 206, 255, 68, 170, 206, 255, 68, 170, 206, 255, 69, 170, 206, 255, 69, 171, 207, 255, 69, 171, 207, 255, 69, 171, 207, 255, 70, 171, 207, 255, 70, 171, 207, 255, 70, 172, 207, 255, 70, 172, 207, 255, 71, 172, 207, 255, 71, 172, 207, 255, 71, 173, 208, 255, 71, 173, 208, 255, 72, 173, 208, 255, 72, 173, 208, 255, 72, 174, 208, 255, 72, 174, 208, 255, 73, 174, 208, 255, 73, 174, 208, 255, 73, 175, 209, 255, 73, 175, 209, 255, 74, 175, 209, 255, 74, 175, 209, 255, 74, 176, 209, 255, 75, 176, 209, 255, 75, 176, 209, 255, 75, 176, 209, 255, 75, 177, 210, 255, 76, 177, 210, 255, 76, 177, 210, 255, 76, 177, 210, 255, 76, 178, 210, 255, 77, 178, 210, 255, 77, 178, 210, 255, 77, 178, 210, 255, 78, 179, 211, 255, 78, 179, 210, 255, 78, 179, 210, 255, 78, 179, 210, 255, 78, 179, 210, 255, 78, 179, 210, 255, 78, 180, 210, 255, 78, 180, 210, 255, 78, 180, 210, 255, 78, 180, 210, 255, 79, 180, 210, 255, 79, 180, 210, 255, 79, 181, 210, 255, 79, 181, 210, 255, 79, 181, 210, 255, 79, 181, 209, 255, 79, 181, 209, 255, 80, 182, 209, 255, 80, 182, 209, 255, 80, 182, 209, 255, 80, 182, 209, 255, 80, 182, 209, 255, 80, 182, 209, 255, 81, 183, 209, 255, 81, 183, 209, 255, 81, 183, 209, 255, 81, 183, 209, 255, 81, 183, 208, 255, 82, 183, 208, 255, 82, 184, 208, 255, 82, 184, 208, 255, 82, 184, 208, 255, 82, 184, 208, 255, 83, 184, 208, 255, 83, 184, 208, 255, 83, 185, 208, 255, 83, 185, 208, 255, 83, 185, 208, 255, 84, 185, 207, 255, 84, 185, 207, 255, 84, 185, 207, 255, 84, 186, 207, 255, 85, 186, 207, 255, 85, 186, 207, 255, 85, 186, 207, 255, 85, 186, 207, 255, 86, 186, 207, 255, 86, 187, 207, 255, 86, 187, 207, 255, 86, 187, 206, 255, 87, 187, 206, 255, 87, 187, 206, 255, 87, 187, 206, 255, 88, 188, 206, 255, 88, 188, 206, 255, 88, 188, 206, 255, 88, 188, 206, 255, 89, 188, 206, 255, 89, 188, 206, 255, 89, 188, 205, 255, 90, 189, 205, 255, 90, 189, 205, 255, 90, 189, 205, 255, 90, 189, 205, 255, 100, 194, 202, 255, 100, 194, 202, 255, 100, 195, 202, 255, 101, 195, 202, 255, 101, 195, 202, 255, 101, 195, 201, 255, 102, 195, 201, 255, 102, 195, 201, 255, 102, 195, 201, 255, 103, 196, 201, 255, 103, 196, 201, 255, 103, 196, 201, 255, 104, 196, 201, 255, 104, 196, 201, 255, 104, 196, 201, 255, 105, 197, 200, 255, 105, 197, 200, 255, 105, 197, 200, 255, 106, 197, 200, 255, 106, 197, 200, 255, 106, 197, 200, 255, 107, 197, 200, 255, 107, 198, 200, 255, 107, 198, 200, 255, 108, 198, 199, 255, 108, 198, 199, 255, 108, 198, 199, 255, 109, 198, 199, 255, 109, 198, 199, 255, 109, 199, 199, 255, 110, 199, 199, 255, 110, 199, 199, 255, 111, 199, 199, 255, 111, 199, 199, 255, 111, 199, 198, 255, 112, 199, 198, 255, 112, 200, 198, 255, 112, 200, 198, 255, 113, 200, 198, 255, 113, 200, 198, 255, 113, 200, 198, 255, 114, 200, 198, 255, 114, 200, 198, 255, 115, 201, 198, 255, 115, 201, 197, 255, 115, 201, 197, 255, 116, 201, 197, 255, 116, 201, 197, 255, 116, 201, 197, 255, 117, 201, 197, 255, 117, 202, 197, 255, 118, 202, 197, 255, 118, 202, 197, 255, 118, 202, 197, 255, 119, 202, 196, 255, 119, 202, 196, 255, 119, 202, 196, 255, 120, 203, 196, 255, 120, 203, 196, 255, 121, 203, 196, 255, 121, 203, 196, 255, 121, 203, 196, 255, 122, 203, 196, 255, 122, 203, 196, 255, 123, 204, 195, 255, 123, 204, 195, 255, 123, 204, 195, 255, 123, 204, 195, 255, 123, 204, 195, 255, 124, 204, 195, 255, 124, 204, 195, 255, 124, 204, 195, 255, 124, 204, 195, 255, 124, 205, 195, 255, 125, 205, 195, 255, 125, 205, 195, 255, 125, 205, 194, 255, 125, 205, 194, 255, 126, 205, 194, 255, 126, 205, 194, 255, 126, 205, 194, 255, 126, 206, 194, 255, 126, 206, 194, 255, 127, 206, 194, 255, 127, 206, 194, 255, 127, 206, 194, 255, 127, 206, 194, 255, 128, 206, 193, 255, 128, 206, 193, 255, 128, 206, 193, 255, 128, 207, 193, 255, 129, 207, 193, 255, 129, 207, 193, 255, 129, 207, 193, 255, 129, 207, 193, 255, 130, 207, 193, 255, 130, 207, 193, 255, 130, 207, 193, 255, 130, 208, 192, 255, 131, 208, 192, 255, 131, 208, 192, 255, 131, 208, 192, 255, 131, 208, 192, 255, 132, 208, 192, 255, 132, 208, 192, 255, 132, 208, 192, 255, 132, 208, 192, 255, 133, 209, 192, 255, 133, 209, 192, 255, 133, 209, 191, 255, 133, 209, 191, 255, 134, 209, 191, 255, 134, 209, 191, 255, 134, 209, 191, 255, 135, 209, 191, 255, 135, 209, 191, 255, 135, 210, 191, 255, 135, 210, 191, 255, 136, 210, 191, 255, 136, 210, 190, 255, 136, 210, 190, 255, 137, 210, 190, 255, 137, 210, 190, 255, 137, 210, 190, 255, 137, 210, 190, 255, 138, 211, 190, 255, 138, 211, 190, 255, 138, 211, 190, 255, 147, 214, 187, 255, 148, 214, 186, 255, 148, 214, 186, 255, 148, 215, 186, 255, 149, 215, 186, 255, 149, 215, 186, 255, 149, 215, 186, 255, 150, 215, 186, 255, 150, 215, 186, 255, 150, 215, 186, 255, 150, 215, 186, 255, 151, 215, 185, 255, 151, 215, 185, 255, 151, 216, 185, 255, 152, 216, 185, 255, 152, 216, 185, 255, 152, 216, 185, 255, 152, 216, 185, 255, 153, 216, 185, 255, 153, 216, 185, 255, 153, 216, 185, 255, 154, 216, 185, 255, 154, 217, 184, 255, 154, 217, 184, 255, 155, 217, 184, 255, 155, 217, 184, 255, 155, 217, 184, 255, 156, 217, 184, 255, 156, 217, 184, 255, 156, 217, 184, 255, 156, 217, 184, 255, 157, 217, 184, 255, 157, 218, 183, 255, 157, 218, 183, 255, 158, 218, 183, 255, 158, 218, 183, 255, 158, 218, 183, 255, 159, 218, 183, 255, 159, 218, 183, 255, 159, 218, 183, 255, 160, 218, 183, 255, 160, 218, 183, 255, 160, 218, 183, 255, 161, 219, 182, 255, 161, 219, 182, 255, 161, 219, 182, 255, 162, 219, 182, 255, 162, 219, 182, 255, 162, 219, 182, 255, 163, 219, 182, 255, 163, 219, 182, 255, 163, 219, 182, 255, 164, 219, 182, 255, 164, 220, 181, 255, 164, 220, 181, 255, 165, 220, 181, 255, 165, 220, 181, 255, 165, 220, 181, 255, 165, 220, 181, 255, 166, 220, 181, 255, 166, 220, 181, 255, 166, 220, 181, 255, 167, 220, 181, 255, 167, 220, 181, 255, 167, 221, 180, 255, 168, 221, 181, 255, 168, 221, 181, 255, 168, 221, 181, 255, 168, 221, 181, 255, 169, 221, 181, 255, 169, 221, 181, 255, 169, 221, 181, 255, 169, 221, 181, 255, 170, 221, 181, 255, 170, 221, 181, 255, 170, 221, 181, 255, 170, 222, 182, 255, 171, 222, 182, 255, 171, 222, 182, 255, 171, 222, 182, 255, 171, 222, 182, 255, 172, 222, 182, 255, 172, 222, 182, 255, 172, 222, 182, 255, 172, 222, 182, 255, 172, 222, 182, 255, 173, 222, 182, 255, 173, 223, 182, 255, 173, 223, 183, 255, 173, 223, 183, 255, 174, 223, 183, 255, 174, 223, 183, 255, 174, 223, 183, 255, 174, 223, 183, 255, 175, 223, 183, 255, 175, 223, 183, 255, 175, 223, 183, 255, 175, 223, 183, 255, 176, 223, 183, 255, 176, 224, 184, 255, 176, 224, 184, 255, 176, 224, 184, 255, 176, 224, 184, 255, 177, 224, 184, 255, 177, 224, 184, 255, 177, 224, 184, 255, 177, 224, 184, 255, 178, 224, 184, 255, 178, 224, 184, 255, 178, 224, 185, 255, 178, 225, 185, 255, 179, 225, 185, 255, 179, 225, 185, 255, 179, 225, 185, 255, 179, 225, 185, 255, 179, 225, 185, 255, 180, 225, 185, 255, 180, 225, 185, 255, 180, 225, 185, 255, 180, 225, 185, 255, 181, 225, 186, 255, 181, 225, 186, 255, 181, 226, 186, 255, 181, 226, 186, 255, 181, 226, 186, 255, 182, 226, 186, 255, 182, 226, 186, 255, 182, 226, 186, 255, 190, 229, 190, 255, 190, 229, 190, 255, 190, 229, 190, 255, 190, 229, 190, 255, 190, 229, 190, 255, 191, 229, 190, 255, 191, 229, 190, 255, 191, 229, 190, 255, 191, 230, 190, 255, 192, 230, 190, 255, 192, 230, 191, 255, 192, 230, 191, 255, 192, 230, 191, 255, 192, 230, 191, 255, 193, 230, 191, 255, 193, 230, 191, 255, 193, 230, 191, 255, 193, 230, 191, 255, 194, 230, 191, 255, 194, 231, 192, 255, 194, 231, 192, 255, 194, 231, 192, 255, 194, 231, 192, 255, 195, 231, 192, 255, 195, 231, 192, 255, 195, 231, 192, 255, 195, 231, 192, 255, 196, 231, 192, 255, 196, 231, 192, 255, 196, 231, 193, 255, 196, 232, 193, 255, 196, 232, 193, 255, 197, 232, 193, 255, 197, 232, 193, 255, 197, 232, 193, 255, 197, 232, 193, 255, 198, 232, 193, 255, 198, 232, 193, 255, 198, 232, 194, 255, 198, 232, 194, 255, 198, 232, 194, 255, 199, 232, 194, 255, 199, 233, 194, 255, 199, 233, 194, 255, 199, 233, 194, 255, 199, 233, 194, 255, 200, 233, 194, 255, 200, 233, 195, 255, 200, 233, 195, 255, 200, 233, 195, 255, 201, 233, 195, 255, 201, 233, 195, 255, 201, 233, 195, 255, 201, 234, 195, 255, 201, 234, 195, 255, 202, 234, 195, 255, 202, 234, 196, 255, 202, 234, 196, 255, 202, 234, 196, 255, 202, 234, 196, 255, 203, 234, 196, 255, 203, 234, 196, 255, 203, 234, 196, 255, 203, 234, 196, 255, 203, 235, 196, 255, 204, 235, 197, 255, 204, 235, 197, 255, 204, 235, 197, 255, 204, 235, 197, 255, 204, 235, 197, 255, 204, 235, 197, 255, 204, 235, 197, 255, 205, 235, 198, 255, 205, 235, 198, 255, 205, 235, 198, 255, 205, 235, 198, 255, 205, 235, 198, 255, 205, 235, 198, 255, 205, 235, 198, 255, 205, 235, 199, 255, 206, 235, 199, 255, 206, 235, 199, 255, 206, 235, 199, 255, 206, 235, 199, 255, 206, 236, 199, 255, 206, 236, 199, 255, 206, 236, 200, 255, 206, 236, 200, 255, 207, 236, 200, 255, 207, 236, 200, 255, 207, 236, 200, 255, 207, 236, 200, 255, 207, 236, 200, 255, 207, 236, 200, 255, 207, 236, 201, 255, 207, 236, 201, 255, 208, 236, 201, 255, 208, 236, 201, 255, 208, 236, 201, 255, 208, 236, 201, 255, 208, 236, 201, 255, 208, 236, 202, 255, 208, 236, 202, 255, 208, 236, 202, 255, 209, 237, 202, 255, 209, 237, 202, 255, 209, 237, 202, 255, 209, 237, 202, 255, 209, 237, 203, 255, 209, 237, 203, 255, 209, 237, 203, 255, 209, 237, 203, 255, 210, 237, 203, 255, 210, 237, 203, 255, 210, 237, 203, 255, 210, 237, 203, 255, 210, 237, 204, 255, 210, 237, 204, 255, 210, 237, 204, 255, 210, 237, 204, 255, 211, 237, 204, 255, 211, 237, 204, 255, 211, 237, 204, 255, 211, 237, 205, 255, 211, 238, 205, 255, 211, 238, 205, 255, 211, 238, 205, 255, 211, 238, 205, 255, 216, 239, 210, 255, 216, 239, 210, 255, 216, 239, 210, 255, 216, 239, 210, 255, 216, 240, 210, 255, 216, 240, 210, 255, 216, 240, 210, 255, 216, 240, 211, 255, 217, 240, 211, 255, 217, 240, 211, 255, 217, 240, 211, 255, 217, 240, 211, 255, 217, 240, 211, 255, 217, 240, 211, 255, 217, 240, 212, 255, 217, 240, 212, 255, 218, 240, 212, 255, 218, 240, 212, 255, 218, 240, 212, 255, 218, 240, 212, 255, 218, 240, 212, 255, 218, 240, 213, 255, 218, 240, 213, 255, 218, 240, 213, 255, 219, 241, 213, 255, 219, 241, 213, 255, 219, 241, 213, 255, 219, 241, 213, 255, 219, 241, 214, 255, 219, 241, 214, 255, 219, 241, 214, 255, 219, 241, 214, 255, 220, 241, 214, 255, 220, 241, 214, 255, 220, 241, 214, 255, 220, 241, 214, 255, 220, 241, 215, 255, 220, 241, 215, 255, 220, 241, 215, 255, 220, 241, 215, 255, 221, 241, 215, 255, 221, 241, 215, 255, 221, 241, 215, 255, 221, 241, 216, 255, 221, 242, 216, 255, 221, 242, 216, 255, 221, 242, 216, 255, 221, 242, 216, 255, 222, 242, 216, 255, 222, 242, 216, 255, 222, 242, 217, 255, 222, 242, 217, 255, 222, 242, 217, 255, 222, 242, 217, 255, 222, 242, 217, 255, 222, 242, 217, 255, 223, 242, 217, 255, 223, 242, 218, 255, 223, 242, 218, 255, 223, 242, 218, 255, 223, 242, 218, 255, 223, 242, 218, 255, 223, 242, 218, 255, 223, 242, 218, 255, 223, 243, 218, 255, 224, 243, 219, 255, 224, 243, 219, 255, 224, 243, 219, 255, 224, 243, 219, 255, 224, 243, 219, 255, 224, 243, 219, 255, 225, 243, 219, 255, 225, 243, 219, 255, 225, 243, 220, 255, 225, 243, 220, 255, 225, 243, 220, 255, 225, 243, 220, 255, 226, 243, 220, 255, 226, 243, 220, 255, 226, 243, 220, 255, 226, 243, 220, 255, 226, 243, 220, 255, 226, 243, 221, 255, 227, 244, 221, 255, 227, 244, 221, 255, 227, 244, 221, 255, 227, 244, 221, 255, 227, 244, 221, 255, 227, 244, 221, 255, 228, 244, 221, 255, 228, 244, 222, 255, 228, 244, 222, 255, 228, 244, 222, 255, 228, 244, 222, 255, 228, 244, 222, 255, 228, 244, 222, 255, 229, 244, 222, 255, 229, 244, 222, 255, 229, 244, 223, 255, 229, 244, 223, 255, 229, 244, 223, 255, 229, 244, 223, 255, 230, 245, 223, 255, 230, 245, 223, 255, 230, 245, 223, 255, 230, 245, 223, 255, 230, 245, 224, 255, 230, 245, 224, 255, 230, 245, 224, 255, 231, 245, 224, 255, 231, 245, 224, 255, 231, 245, 224, 255, 231, 245, 224, 255, 231, 245, 224, 255, 231, 245, 225, 255, 231, 245, 225, 255, 232, 245, 225, 255, 232, 245, 225, 255, 232, 245, 225, 255, 232, 245, 225, 255, 232, 246, 225, 255, 232, 246, 225, 255, 233, 246, 226, 255, 233, 246, 226, 255, 233, 246, 226, 255, 233, 246, 226, 255, 233, 246, 226, 255, 233, 246, 226, 255, 238, 248, 231, 255, 238, 248, 231, 255, 238, 248, 231, 255, 238, 248, 231, 255, 239, 248, 231, 255, 239, 248, 231, 255, 239, 248, 231, 255, 239, 248, 232, 255, 239, 248, 232, 255, 239, 248, 232, 255, 239, 248, 232, 255, 240, 248, 232, 255, 240, 248, 232, 255, 240, 249, 232, 255, 240, 249, 232, 255, 240, 249, 233, 255, 240, 249, 233, 255, 240, 249, 233, 255, 241, 249, 233, 255, 241, 249, 233, 255, 241, 249, 233, 255, 241, 249, 233, 255, 241, 249, 234, 255, 241, 249, 234, 255, 241, 249, 234, 255, 241, 249, 234, 255, 242, 249, 234, 255, 242, 249, 234, 255, 242, 249, 234, 255, 242, 249, 235, 255, 242, 249, 235, 255, 242, 250, 235, 255, 242, 250, 235, 255, 243, 250, 235, 255, 243, 250, 235, 255, 243, 250, 235, 255, 243, 250, 235, 255, 243, 250, 236, 255, 243, 250, 236, 255, 243, 250, 236, 255, 243, 250, 236, 255, 244, 250, 236, 255, 244, 250, 236, 255, 244, 250, 236, 255, 244, 250, 237, 255, 244, 250, 237, 255, 244, 250, 237, 255, 244, 250, 237, 255, 245, 251, 237, 255, 245, 251, 237, 255, 245, 251, 237, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 246, 251, 238, 255, 246, 251, 238, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_GnBu_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 8, 63, 129, 0, 8, 66, 131, 24, 7, 68, 134, 49, 7, 71, 137, 74, 7, 73, 139, 99, 7, 75, 142, 124, 7, 78, 144, 149, 7, 88, 155, 174, 7, 91, 158, 199, 7, 93, 160, 224, 7, 95, 163, 249, 7, 98, 165, 255, 7, 100, 168, 255, 7, 102, 170, 255, 7, 104, 172, 255, 8, 106, 173, 255, 8, 108, 174, 255, 10, 110, 175, 255, 11, 112, 176, 255, 13, 114, 177, 255, 15, 116, 178, 255, 17, 118, 179, 255, 26, 127, 184, 255, 28, 129, 185, 255, 31, 131, 186, 255, 33, 132, 186, 255, 35, 134, 187, 255, 38, 136, 188, 255, 40, 138, 189, 255, 42, 139, 189, 255, 44, 141, 191, 255, 45, 143, 192, 255, 46, 145, 193, 255, 47, 147, 194, 255, 49, 149, 195, 255, 50, 150, 196, 255, 52, 152, 197, 255, 53, 154, 198, 255, 62, 164, 203, 255, 64, 165, 204, 255, 65, 167, 205, 255, 67, 169, 206, 255, 69, 170, 206, 255, 70, 172, 207, 255, 72, 174, 208, 255, 74, 175, 209, 255, 76, 177, 210, 255, 77, 178, 210, 255, 78, 180, 210, 255, 79, 181, 210, 255, 80, 182, 209, 255, 81, 183, 209, 255, 82, 184, 208, 255, 84, 185, 207, 255, 85, 186, 207, 255, 87, 187, 206, 255, 89, 188, 206, 255, 90, 189, 205, 255, 101, 195, 202, 255, 103, 196, 201, 255, 105, 197, 200, 255, 107, 198, 200, 255, 109, 198, 199, 255, 111, 199, 199, 255, 113, 200, 198, 255, 115, 201, 197, 255, 117, 202, 197, 255, 119, 202, 196, 255, 121, 203, 196, 255, 123, 204, 195, 255, 124, 204, 195, 255, 125, 205, 194, 255, 126, 206, 194, 255, 128, 206, 193, 255, 129, 207, 193, 255, 130, 207, 193, 255, 132, 208, 192, 255, 133, 209, 192, 255, 134, 209, 191, 255, 135, 210, 191, 255, 137, 210, 190, 255, 138, 211, 190, 255, 149, 215, 186, 255, 150, 215, 186, 255, 151, 216, 185, 255, 153, 216, 185, 255, 154, 217, 184, 255, 155, 217, 184, 255, 157, 217, 184, 255, 158, 218, 183, 255, 160, 218, 183, 255, 161, 219, 182, 255, 162, 219, 182, 255, 164, 219, 182, 255, 165, 220, 181, 255, 167, 220, 181, 255, 168, 221, 181, 255, 169, 221, 181, 255, 170, 221, 181, 255, 171, 222, 182, 255, 172, 222, 182, 255, 173, 222, 182, 255, 174, 223, 183, 255, 174, 223, 183, 255, 175, 223, 183, 255, 176, 224, 184, 255, 177, 224, 184, 255, 178, 224, 184, 255, 179, 225, 185, 255, 180, 225, 185, 255, 180, 225, 186, 255, 181, 226, 186, 255, 182, 226, 186, 255, 190, 229, 190, 255, 191, 229, 190, 255, 192, 230, 190, 255, 192, 230, 191, 255, 193, 230, 191, 255, 194, 231, 192, 255, 195, 231, 192, 255, 195, 231, 192, 255, 196, 231, 193, 255, 197, 232, 193, 255, 197, 232, 193, 255, 198, 232, 194, 255, 199, 233, 194, 255, 199, 233, 194, 255, 200, 233, 195, 255, 201, 233, 195, 255, 201, 234, 195, 255, 202, 234, 196, 255, 203, 234, 196, 255, 203, 234, 196, 255, 204, 235, 197, 255, 204, 235, 197, 255, 204, 235, 197, 255, 205, 235, 198, 255, 205, 235, 198, 255, 205, 235, 199, 255, 206, 235, 199, 255, 206, 236, 199, 255, 206, 236, 200, 255, 207, 236, 200, 255, 207, 236, 200, 255, 207, 236, 201, 255, 208, 236, 201, 255, 208, 236, 201, 255, 208, 236, 202, 255, 209, 237, 202, 255, 209, 237, 202, 255, 209, 237, 203, 255, 210, 237, 203, 255, 210, 237, 203, 255, 210, 237, 204, 255, 210, 237, 204, 255, 211, 237, 204, 255, 211, 238, 205, 255, 211, 238, 205, 255, 216, 239, 210, 255, 216, 239, 210, 255, 216, 240, 210, 255, 216, 240, 211, 255, 217, 240, 211, 255, 217, 240, 211, 255, 217, 240, 211, 255, 217, 240, 212, 255, 218, 240, 212, 255, 218, 240, 212, 255, 218, 240, 213, 255, 218, 240, 213, 255, 219, 241, 213, 255, 219, 241, 213, 255, 219, 241, 214, 255, 219, 241, 214, 255, 220, 241, 214, 255, 220, 241, 214, 255, 220, 241, 215, 255, 220, 241, 215, 255, 221, 241, 215, 255, 221, 241, 215, 255, 221, 241, 216, 255, 221, 242, 216, 255, 221, 242, 216, 255, 222, 242, 216, 255, 222, 242, 217, 255, 222, 242, 217, 255, 222, 242, 217, 255, 222, 242, 217, 255, 223, 242, 218, 255, 223, 242, 218, 255, 223, 242, 218, 255, 223, 242, 218, 255, 223, 242, 218, 255, 224, 243, 219, 255, 224, 243, 219, 255, 224, 243, 219, 255, 224, 243, 219, 255, 225, 243, 219, 255, 225, 243, 219, 255, 225, 243, 220, 255, 225, 243, 220, 255, 226, 243, 220, 255, 226, 243, 220, 255, 226, 243, 220, 255, 226, 243, 220, 255, 226, 243, 221, 255, 227, 244, 221, 255, 227, 244, 221, 255, 227, 244, 221, 255, 227, 244, 221, 255, 227, 244, 221, 255, 228, 244, 222, 255, 228, 244, 222, 255, 228, 244, 222, 255, 228, 244, 222, 255, 228, 244, 222, 255, 229, 244, 222, 255, 229, 244, 222, 255, 229, 244, 223, 255, 229, 244, 223, 255, 229, 244, 223, 255, 230, 245, 223, 255, 230, 245, 223, 255, 230, 245, 223, 255, 230, 245, 223, 255, 230, 245, 224, 255, 230, 245, 224, 255, 231, 245, 224, 255, 231, 245, 224, 255, 231, 245, 224, 255, 231, 245, 224, 255, 231, 245, 224, 255, 231, 245, 225, 255, 231, 245, 225, 255, 232, 245, 225, 255, 232, 245, 225, 255, 232, 245, 225, 255, 232, 245, 225, 255, 232, 245, 225, 255, 232, 246, 225, 255, 232, 246, 225, 255, 233, 246, 226, 255, 233, 246, 226, 255, 233, 246, 226, 255, 233, 246, 226, 255, 233, 246, 226, 255, 233, 246, 226, 255, 233, 246, 226, 255, 238, 248, 231, 255, 238, 248, 231, 255, 238, 248, 231, 255, 238, 248, 231, 255, 238, 248, 231, 255, 239, 248, 231, 255, 239, 248, 231, 255, 239, 248, 231, 255, 239, 248, 231, 255, 239, 248, 232, 255, 239, 248, 232, 255, 239, 248, 232, 255, 239, 248, 232, 255, 239, 248, 232, 255, 239, 248, 232, 255, 240, 248, 232, 255, 240, 248, 232, 255, 240, 248, 232, 255, 240, 249, 232, 255, 240, 249, 232, 255, 240, 249, 233, 255, 240, 249, 233, 255, 240, 249, 233, 255, 240, 249, 233, 255, 240, 249, 233, 255, 241, 249, 233, 255, 241, 249, 233, 255, 241, 249, 233, 255, 241, 249, 233, 255, 241, 249, 233, 255, 241, 249, 233, 255, 241, 249, 233, 255, 241, 249, 234, 255, 241, 249, 234, 255, 241, 249, 234, 255, 241, 249, 234, 255, 241, 249, 234, 255, 241, 249, 234, 255, 242, 249, 234, 255, 242, 249, 234, 255, 242, 249, 234, 255, 242, 249, 234, 255, 242, 249, 234, 255, 242, 249, 234, 255, 242, 249, 234, 255, 242, 249, 234, 255, 242, 249, 235, 255, 242, 249, 235, 255, 242, 249, 235, 255, 242, 250, 235, 255, 242, 250, 235, 255, 242, 250, 235, 255, 242, 250, 235, 255, 242, 250, 235, 255, 243, 250, 235, 255, 243, 250, 235, 255, 243, 250, 235, 255, 243, 250, 235, 255, 243, 250, 235, 255, 243, 250, 235, 255, 243, 250, 235, 255, 243, 250, 235, 255, 243, 250, 236, 255, 243, 250, 236, 255, 243, 250, 236, 255, 243, 250, 236, 255, 243, 250, 236, 255, 243, 250, 236, 255, 243, 250, 236, 255, 243, 250, 236, 255, 243, 250, 236, 255, 243, 250, 236, 255, 243, 250, 236, 255, 243, 250, 236, 255, 244, 250, 236, 255, 244, 250, 236, 255, 244, 250, 236, 255, 244, 250, 236, 255, 244, 250, 236, 255, 244, 250, 236, 255, 244, 250, 236, 255, 244, 250, 236, 255, 244, 250, 236, 255, 244, 250, 237, 255, 244, 250, 237, 255, 244, 250, 237, 255, 244, 250, 237, 255, 244, 250, 237, 255, 244, 250, 237, 255, 244, 250, 237, 255, 244, 250, 237, 255, 244, 250, 237, 255, 244, 250, 237, 255, 244, 250, 237, 255, 244, 250, 237, 255, 244, 250, 237, 255, 244, 250, 237, 255, 244, 250, 237, 255, 244, 251, 237, 255, 244, 251, 237, 255, 244, 251, 237, 255, 245, 251, 237, 255, 245, 251, 237, 255, 245, 251, 237, 255, 245, 251, 237, 255, 245, 251, 237, 255, 245, 251, 237, 255, 245, 251, 237, 255, 245, 251, 237, 255, 245, 251, 237, 255, 245, 251, 237, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 245, 251, 238, 255, 246, 251, 238, 255, 246, 251, 238, 255, 246, 251, 238, 255, 246, 251, 238, 255, 246, 251, 238, 255, 246, 251, 238, 255, 246, 251, 238, 255, 246, 251, 238, 255, 246, 251, 238, 255, 246, 251, 238, 255, 246, 251, 238, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 251, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255, 246, 252, 239, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_GnBu_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
