/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/YlGnBu.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 8, 29, 88, 255, 37, 52, 148, 255, 34, 94, 168, 255, 29, 145, 192, 255, 65, 182, 196, 255, 127, 205, 187, 255, 199, 233, 180, 255, 237, 248, 177, 255, 255, 255, 217, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_YlGnBu_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 8, 28, 88, 0, 8, 29, 88, 7, 8, 29, 88, 14, 8, 29, 89, 22, 8, 29, 89, 29, 8, 29, 90, 37, 9, 30, 90, 44, 9, 30, 91, 52, 9, 30, 91, 59, 9, 30, 92, 67, 9, 30, 92, 74, 9, 30, 92, 82, 10, 31, 93, 89, 10, 31, 93, 97, 10, 31, 94, 104, 10, 31, 94, 112, 10, 31, 95, 119, 11, 32, 95, 127, 11, 32, 96, 134, 11, 32, 96, 141, 11, 32, 97, 149, 11, 32, 97, 156, 12, 32, 98, 164, 12, 33, 98, 171, 12, 33, 98, 179, 12, 33, 99, 186, 13, 33, 99, 194, 13, 33, 100, 201, 13, 33, 100, 209, 13, 34, 101, 216, 13, 34, 101, 224, 14, 34, 102, 231, 14, 34, 102, 239, 14, 34, 103, 246, 14, 35, 103, 254, 14, 35, 103, 255, 15, 35, 104, 255, 15, 35, 104, 255, 15, 35, 105, 255, 15, 35, 105, 255, 15, 36, 106, 255, 16, 36, 106, 255, 16, 36, 107, 255, 16, 36, 107, 255, 16, 36, 108, 255, 17, 37, 108, 255, 17, 37, 109, 255, 17, 37, 109, 255, 17, 37, 110, 255, 17, 37, 110, 255, 18, 37, 110, 255, 18, 38, 111, 255, 18, 38, 111, 255, 18, 38, 112, 255, 19, 38, 112, 255, 19, 38, 113, 255, 19, 39, 113, 255, 19, 39, 114, 255, 19, 39, 114, 255, 20, 39, 115, 255, 20, 39, 115, 255, 20, 39, 116, 255, 20, 40, 116, 255, 21, 40, 117, 255, 21, 40, 117, 255, 21, 40, 117, 255, 21, 40, 118, 255, 21, 40, 118, 255, 22, 41, 119, 255, 22, 41, 119, 255, 22, 41, 120, 255, 22, 41, 120, 255, 23, 41, 121, 255, 23, 42, 121, 255, 23, 42, 122, 255, 23, 42, 122, 255, 24, 42, 123, 255, 24, 42, 123, 255, 24, 42, 124, 255, 24, 43, 124, 255, 24, 43, 125, 255, 25, 43, 125, 255, 25, 43, 125, 255, 25, 43, 126, 255, 25, 44, 126, 255, 26, 44, 127, 255, 26, 44, 127, 255, 26, 44, 128, 255, 26, 44, 128, 255, 27, 44, 129, 255, 27, 45, 129, 255, 27, 45, 130, 255, 27, 45, 130, 255, 28, 45, 131, 255, 28, 45, 131, 255, 28, 46, 132, 255, 28, 46, 132, 255, 29, 46, 133, 255, 29, 46, 133, 255, 29, 46, 134, 255, 29, 46, 134, 255, 30, 47, 135, 255, 30, 47, 135, 255, 30, 47, 135, 255, 30, 47, 136, 255, 31, 47, 136, 255, 31, 48, 137, 255, 31, 48, 137, 255, 31, 48, 138, 255, 32, 48, 138, 255, 32, 48, 139, 255, 32, 48, 139, 255, 32, 49, 140, 255, 33, 49, 140, 255, 33, 49, 141, 255, 33, 49, 141, 255, 33, 49, 142, 255, 34, 50, 142, 255, 34, 50, 143, 255, 34, 50, 143, 255, 34, 50, 144, 255, 35, 50, 144, 255, 35, 50, 145, 255, 35, 51, 145, 255, 35, 51, 146, 255, 36, 51, 146, 255, 36, 51, 147, 255, 36, 51, 147, 255, 37, 51, 148, 255, 36, 52, 148, 255, 36, 52, 148, 255, 36, 53, 148, 255, 36, 53, 148, 255, 36, 53, 149, 255, 35, 54, 149, 255, 35, 54, 149, 255, 35, 54, 149, 255, 35, 55, 149, 255, 35, 55, 150, 255, 34, 55, 150, 255, 34, 56, 150, 255, 34, 56, 150, 255, 34, 57, 150, 255, 34, 57, 151, 255, 34, 57, 151, 255, 33, 58, 151, 255, 33, 58, 151, 255, 33, 58, 151, 255, 33, 59, 152, 255, 33, 59, 152, 255, 33, 59, 152, 255, 32, 60, 152, 255, 32, 60, 152, 255, 32, 60, 152, 255, 32, 61, 153, 255, 32, 61, 153, 255, 32, 61, 153, 255, 31, 62, 153, 255, 31, 62, 153, 255, 31, 62, 154, 255, 31, 63, 154, 255, 31, 63, 154, 255, 31, 64, 154, 255, 31, 64, 154, 255, 31, 64, 154, 255, 30, 65, 155, 255, 30, 65, 155, 255, 30, 65, 155, 255, 30, 66, 155, 255, 30, 66, 155, 255, 30, 66, 156, 255, 30, 67, 156, 255, 30, 67, 156, 255, 29, 67, 156, 255, 29, 68, 156, 255, 29, 68, 156, 255, 29, 68, 157, 255, 29, 69, 157, 255, 29, 69, 157, 255, 29, 69, 157, 255, 29, 70, 157, 255, 29, 70, 157, 255, 29, 70, 158, 255, 28, 71, 158, 255, 28, 71, 158, 255, 28, 71, 158, 255, 28, 71, 158, 255, 28, 72, 158, 255, 28, 72, 159, 255, 28, 72, 159, 255, 28, 73, 159, 255, 28, 73, 159, 255, 28, 73, 159, 255, 28, 74, 159, 255, 28, 74, 159, 255, 28, 74, 160, 255, 28, 75, 160, 255, 28, 75, 160, 255, 28, 75, 160, 255, 28, 76, 160, 255, 28, 76, 160, 255, 28, 76, 161, 255, 28, 77, 161, 255, 28, 77, 161, 255, 28, 77, 161, 255, 28, 78, 161, 255, 28, 78, 161, 255, 28, 78, 161, 255, 28, 79, 162, 255, 28, 79, 162, 255, 28, 79, 162, 255, 28, 80, 162, 255, 28, 80, 162, 255, 28, 80, 162, 255, 28, 80, 162, 255, 28, 81, 162, 255, 28, 81, 163, 255, 28, 81, 163, 255, 28, 82, 163, 255, 28, 82, 163, 255, 28, 82, 163, 255, 28, 83, 163, 255, 28, 83, 163, 255, 28, 83, 164, 255, 29, 84, 164, 255, 29, 84, 164, 255, 29, 84, 164, 255, 29, 85, 164, 255, 29, 85, 164, 255, 29, 85, 164, 255, 29, 86, 164, 255, 29, 86, 165, 255, 29, 86, 165, 255, 30, 86, 165, 255, 30, 87, 165, 255, 30, 87, 165, 255, 30, 87, 165, 255, 30, 88, 165, 255, 30, 88, 165, 255, 30, 88, 166, 255, 31, 89, 166, 255, 31, 89, 166, 255, 31, 89, 166, 255, 31, 90, 166, 255, 31, 90, 166, 255, 31, 90, 166, 255, 32, 90, 166, 255, 32, 91, 167, 255, 32, 91, 167, 255, 32, 91, 167, 255, 32, 92, 167, 255, 32, 92, 167, 255, 33, 92, 167, 255, 33, 93, 167, 255, 33, 93, 167, 255, 33, 93, 167, 255, 34, 93, 168, 255, 33, 94, 168, 255, 33, 94, 168, 255, 32, 95, 168, 255, 32, 95, 169, 255, 31, 96, 169, 255, 31, 96, 169, 255, 30, 96, 169, 255, 30, 97, 170, 255, 29, 97, 170, 255, 29, 98, 170, 255, 28, 98, 170, 255, 28, 99, 171, 255, 27, 99, 171, 255, 27, 99, 171, 255, 26, 100, 171, 255, 26, 100, 172, 255, 25, 101, 172, 255, 25, 101, 172, 255, 24, 101, 172, 255, 24, 102, 173, 255, 23, 102, 173, 255, 22, 103, 173, 255, 22, 103, 173, 255, 21, 104, 174, 255, 21, 104, 174, 255, 20, 104, 174, 255, 20, 105, 174, 255, 19, 105, 175, 255, 19, 106, 175, 255, 18, 106, 175, 255, 18, 106, 175, 255, 17, 107, 176, 255, 17, 107, 176, 255, 16, 108, 176, 255, 15, 108, 176, 255, 15, 108, 176, 255, 14, 109, 177, 255, 14, 109, 177, 255, 13, 110, 177, 255, 13, 110, 177, 255, 12, 110, 178, 255, 12, 111, 178, 255, 11, 111, 178, 255, 10, 112, 178, 255, 10, 112, 178, 255, 9, 112, 179, 255, 9, 113, 179, 255, 8, 113, 179, 255, 8, 114, 179, 255, 7, 114, 179, 255, 7, 114, 180, 255, 6, 115, 180, 255, 6, 115, 180, 255, 6, 116, 180, 255, 5, 116, 180, 255, 5, 117, 181, 255, 4, 117, 181, 255, 4, 117, 181, 255, 4, 118, 181, 255, 4, 118, 181, 255, 3, 119, 182, 255, 3, 119, 182, 255, 3, 119, 182, 255, 3, 120, 182, 255, 2, 120, 182, 255, 2, 120, 182, 255, 2, 121, 183, 255, 2, 121, 183, 255, 2, 122, 183, 255, 2, 122, 183, 255, 2, 122, 183, 255, 2, 123, 184, 255, 2, 123, 184, 255, 2, 124, 184, 255, 2, 124, 184, 255, 2, 124, 184, 255, 2, 125, 184, 255, 2, 125, 185, 255, 2, 126, 185, 255, 2, 126, 185, 255, 3, 126, 185, 255, 3, 127, 185, 255, 3, 127, 185, 255, 3, 128, 186, 255, 4, 128, 186, 255, 4, 128, 186, 255, 4, 129, 186, 255, 5, 129, 186, 255, 5, 130, 186, 255, 5, 130, 186, 255, 6, 130, 187, 255, 6, 131, 187, 255, 7, 131, 187, 255, 7, 131, 187, 255, 8, 132, 187, 255, 8, 132, 187, 255, 9, 133, 187, 255, 9, 133, 188, 255, 10, 133, 188, 255, 11, 134, 188, 255, 11, 134, 188, 255, 12, 135, 188, 255, 12, 135, 188, 255, 13, 135, 188, 255, 14, 136, 189, 255, 14, 136, 189, 255, 15, 136, 189, 255, 16, 137, 189, 255, 16, 137, 189, 255, 17, 138, 189, 255, 18, 138, 189, 255, 18, 138, 190, 255, 19, 139, 190, 255, 20, 139, 190, 255, 20, 140, 190, 255, 21, 140, 190, 255, 21, 140, 190, 255, 22, 141, 190, 255, 23, 141, 190, 255, 23, 141, 191, 255, 24, 142, 191, 255, 25, 142, 191, 255, 25, 143, 191, 255, 26, 143, 191, 255, 27, 143, 191, 255, 27, 144, 191, 255, 28, 144, 191, 255, 29, 145, 192, 255, 28, 145, 192, 255, 28, 145, 192, 255, 28, 145, 192, 255, 28, 146, 192, 255, 28, 146, 192, 255, 27, 146, 192, 255, 27, 147, 192, 255, 27, 147, 192, 255, 27, 147, 192, 255, 27, 148, 192, 255, 27, 148, 192, 255, 27, 148, 193, 255, 26, 148, 193, 255, 26, 149, 193, 255, 26, 149, 193, 255, 26, 149, 193, 255, 26, 150, 193, 255, 26, 150, 193, 255, 26, 150, 193, 255, 26, 151, 193, 255, 26, 151, 193, 255, 26, 151, 193, 255, 26, 151, 193, 255, 26, 152, 193, 255, 26, 152, 193, 255, 26, 152, 194, 255, 26, 153, 194, 255, 26, 153, 194, 255, 26, 153, 194, 255, 26, 154, 194, 255, 26, 154, 194, 255, 26, 154, 194, 255, 27, 154, 194, 255, 27, 155, 194, 255, 27, 155, 194, 255, 27, 155, 194, 255, 27, 156, 194, 255, 27, 156, 194, 255, 27, 156, 194, 255, 28, 157, 194, 255, 28, 157, 194, 255, 28, 157, 194, 255, 28, 157, 194, 255, 28, 158, 195, 255, 29, 158, 195, 255, 29, 158, 195, 255, 29, 159, 195, 255, 29, 159, 195, 255, 30, 159, 195, 255, 30, 159, 195, 255, 30, 160, 195, 255, 30, 160, 195, 255, 31, 160, 195, 255, 31, 161, 195, 255, 31, 161, 195, 255, 32, 161, 195, 255, 32, 162, 195, 255, 32, 162, 195, 255, 33, 162, 195, 255, 33, 162, 195, 255, 33, 163, 195, 255, 34, 163, 195, 255, 34, 163, 195, 255, 34, 164, 195, 255, 35, 164, 195, 255, 35, 164, 195, 255, 36, 164, 195, 255, 36, 165, 195, 255, 36, 165, 195, 255, 37, 165, 195, 255, 37, 166, 195, 255, 38, 166, 195, 255, 38, 166, 195, 255, 38, 166, 195, 255, 39, 167, 195, 255, 39, 167, 195, 255, 40, 167, 196, 255, 40, 168, 196, 255, 40, 168, 196, 255, 41, 168, 196, 255, 41, 168, 196, 255, 42, 169, 196, 255, 42, 169, 196, 255, 43, 169, 196, 255, 43, 170, 196, 255, 44, 170, 196, 255, 44, 170, 196, 255, 44, 170, 196, 255, 45, 171, 196, 255, 45, 171, 196, 255, 46, 171, 196, 255, 46, 172, 196, 255, 47, 172, 196, 255, 47, 172, 196, 255, 48, 172, 196, 255, 48, 173, 196, 255, 49, 173, 196, 255, 49, 173, 196, 255, 50, 173, 196, 255, 50, 174, 196, 255, 51, 174, 196, 255, 51, 174, 196, 255, 52, 175, 196, 255, 52, 175, 196, 255, 53, 175, 196, 255, 53, 175, 196, 255, 54, 176, 196, 255, 54, 176, 196, 255, 55, 176, 196, 255, 55, 177, 196, 255, 56, 177, 196, 255, 56, 177, 196, 255, 57, 177, 196, 255, 57, 178, 196, 255, 58, 178, 196, 255, 58, 178, 196, 255, 59, 178, 196, 255, 59, 179, 196, 255, 60, 179, 196, 255, 60, 179, 196, 255, 61, 180, 196, 255, 61, 180, 196, 255, 62, 180, 196, 255, 62, 180, 196, 255, 63, 181, 196, 255, 63, 181, 196, 255, 64, 181, 196, 255, 65, 182, 195, 255, 65, 182, 195, 255, 65, 182, 195, 255, 66, 182, 195, 255, 66, 182, 195, 255, 67, 182, 195, 255, 67, 183, 195, 255, 68, 183, 195, 255, 68, 183, 195, 255, 69, 183, 195, 255, 69, 183, 195, 255, 70, 184, 195, 255, 70, 184, 195, 255, 71, 184, 195, 255, 71, 184, 194, 255, 72, 184, 194, 255, 72, 185, 194, 255, 73, 185, 194, 255, 73, 185, 194, 255, 74, 185, 194, 255, 74, 185, 194, 255, 75, 186, 194, 255, 75, 186, 194, 255, 76, 186, 194, 255, 76, 186, 194, 255, 77, 186, 194, 255, 77, 187, 194, 255, 77, 187, 193, 255, 78, 187, 193, 255, 78, 187, 193, 255, 79, 187, 193, 255, 79, 187, 193, 255, 80, 188, 193, 255, 80, 188, 193, 255, 81, 188, 193, 255, 81, 188, 193, 255, 82, 188, 193, 255, 82, 189, 193, 255, 83, 189, 193, 255, 83, 189, 192, 255, 84, 189, 192, 255, 84, 189, 192, 255, 85, 190, 192, 255, 85, 190, 192, 255, 86, 190, 192, 255, 86, 190, 192, 255, 87, 190, 192, 255, 87, 190, 192, 255, 88, 191, 192, 255, 88, 191, 192, 255, 89, 191, 192, 255, 89, 191, 192, 255, 90, 191, 191, 255, 90, 192, 191, 255, 91, 192, 191, 255, 91, 192, 191, 255, 92, 192, 191, 255, 92, 192, 191, 255, 93, 192, 191, 255, 93, 193, 191, 255, 94, 193, 191, 255, 94, 193, 191, 255, 94, 193, 191, 255, 95, 193, 191, 255, 95, 194, 191, 255, 96, 194, 191, 255, 96, 194, 190, 255, 97, 194, 190, 255, 97, 194, 190, 255, 98, 194, 190, 255, 98, 195, 190, 255, 99, 195, 190, 255, 99, 195, 190, 255, 100, 195, 190, 255, 100, 195, 190, 255, 101, 195, 190, 255, 101, 196, 190, 255, 102, 196, 190, 255, 102, 196, 190, 255, 103, 196, 189, 255, 103, 196, 189, 255, 104, 197, 189, 255, 104, 197, 189, 255, 105, 197, 189, 255, 105, 197, 189, 255, 106, 197, 189, 255, 106, 197, 189, 255, 107, 198, 189, 255, 107, 198, 189, 255, 108, 198, 189, 255, 108, 198, 189, 255, 109, 198, 189, 255, 109, 198, 189, 255, 110, 199, 189, 255, 110, 199, 188, 255, 111, 199, 188, 255, 111, 199, 188, 255, 112, 199, 188, 255, 112, 199, 188, 255, 112, 200, 188, 255, 113, 200, 188, 255, 113, 200, 188, 255, 114, 200, 188, 255, 114, 200, 188, 255, 115, 200, 188, 255, 115, 201, 188, 255, 116, 201, 188, 255, 116, 201, 188, 255, 117, 201, 188, 255, 117, 201, 188, 255, 118, 202, 187, 255, 118, 202, 187, 255, 119, 202, 187, 255, 119, 202, 187, 255, 120, 202, 187, 255, 120, 202, 187, 255, 121, 203, 187, 255, 121, 203, 187, 255, 122, 203, 187, 255, 122, 203, 187, 255, 123, 203, 187, 255, 123, 203, 187, 255, 124, 204, 187, 255, 124, 204, 187, 255, 125, 204, 187, 255, 125, 204, 187, 255, 126, 204, 187, 255, 126, 204, 187, 255, 127, 205, 186, 255, 127, 205, 186, 255, 127, 205, 186, 255, 128, 205, 186, 255, 128, 205, 186, 255, 129, 206, 186, 255, 129, 206, 186, 255, 130, 206, 186, 255, 130, 206, 186, 255, 131, 207, 186, 255, 131, 207, 186, 255, 132, 207, 186, 255, 132, 207, 186, 255, 133, 208, 186, 255, 133, 208, 186, 255, 134, 208, 185, 255, 134, 208, 185, 255, 135, 209, 185, 255, 135, 209, 185, 255, 136, 209, 185, 255, 136, 209, 185, 255, 137, 210, 185, 255, 137, 210, 185, 255, 138, 210, 185, 255, 138, 210, 185, 255, 139, 211, 185, 255, 139, 211, 185, 255, 140, 211, 185, 255, 140, 211, 185, 255, 141, 211, 184, 255, 141, 212, 184, 255, 142, 212, 184, 255, 143, 212, 184, 255, 143, 212, 184, 255, 144, 213, 184, 255, 144, 213, 184, 255, 145, 213, 184, 255, 145, 213, 184, 255, 146, 214, 184, 255, 146, 214, 184, 255, 147, 214, 184, 255, 147, 214, 184, 255, 148, 215, 184, 255, 148, 215, 183, 255, 149, 215, 183, 255, 149, 215, 183, 255, 150, 215, 183, 255, 151, 216, 183, 255, 151, 216, 183, 255, 152, 216, 183, 255, 152, 216, 183, 255, 153, 217, 183, 255, 153, 217, 183, 255, 154, 217, 183, 255, 154, 217, 183, 255, 155, 217, 183, 255, 156, 218, 183, 255, 156, 218, 183, 255, 157, 218, 182, 255, 157, 218, 182, 255, 158, 219, 182, 255, 158, 219, 182, 255, 159, 219, 182, 255, 160, 219, 182, 255, 160, 219, 182, 255, 161, 220, 182, 255, 161, 220, 182, 255, 162, 220, 182, 255, 162, 220, 182, 255, 163, 221, 182, 255, 164, 221, 182, 255, 164, 221, 182, 255, 165, 221, 182, 255, 165, 221, 182, 255, 166, 222, 181, 255, 166, 222, 181, 255, 167, 222, 181, 255, 168, 222, 181, 255, 168, 222, 181, 255, 169, 223, 181, 255, 169, 223, 181, 255, 170, 223, 181, 255, 171, 223, 181, 255, 171, 224, 181, 255, 172, 224, 181, 255, 172, 224, 181, 255, 173, 224, 181, 255, 173, 224, 181, 255, 174, 225, 181, 255, 175, 225, 181, 255, 175, 225, 181, 255, 176, 225, 181, 255, 176, 225, 181, 255, 177, 226, 180, 255, 178, 226, 180, 255, 178, 226, 180, 255, 179, 226, 180, 255, 179, 226, 180, 255, 180, 227, 180, 255, 181, 227, 180, 255, 181, 227, 180, 255, 182, 227, 180, 255, 182, 227, 180, 255, 183, 228, 180, 255, 184, 228, 180, 255, 184, 228, 180, 255, 185, 228, 180, 255, 186, 228, 180, 255, 186, 229, 180, 255, 187, 229, 180, 255, 187, 229, 180, 255, 188, 229, 180, 255, 189, 229, 180, 255, 189, 230, 180, 255, 190, 230, 180, 255, 190, 230, 180, 255, 191, 230, 180, 255, 192, 230, 180, 255, 192, 231, 180, 255, 193, 231, 180, 255, 194, 231, 180, 255, 194, 231, 180, 255, 195, 231, 180, 255, 195, 232, 180, 255, 196, 232, 180, 255, 197, 232, 180, 255, 197, 232, 180, 255, 198, 232, 180, 255, 198, 233, 179, 255, 199, 233, 179, 255, 199, 233, 179, 255, 199, 233, 179, 255, 200, 233, 179, 255, 200, 233, 179, 255, 200, 233, 179, 255, 200, 233, 179, 255, 201, 234, 179, 255, 201, 234, 179, 255, 201, 234, 179, 255, 201, 234, 179, 255, 202, 234, 179, 255, 202, 234, 179, 255, 202, 234, 179, 255, 203, 234, 179, 255, 203, 235, 179, 255, 203, 235, 179, 255, 203, 235, 179, 255, 204, 235, 179, 255, 204, 235, 179, 255, 204, 235, 179, 255, 204, 235, 179, 255, 205, 235, 179, 255, 205, 236, 179, 255, 205, 236, 179, 255, 206, 236, 179, 255, 206, 236, 179, 255, 206, 236, 179, 255, 206, 236, 179, 255, 207, 236, 179, 255, 207, 236, 179, 255, 207, 237, 179, 255, 208, 237, 179, 255, 208, 237, 179, 255, 208, 237, 179, 255, 208, 237, 179, 255, 209, 237, 179, 255, 209, 237, 178, 255, 209, 237, 178, 255, 210, 237, 178, 255, 210, 238, 178, 255, 210, 238, 178, 255, 210, 238, 178, 255, 211, 238, 178, 255, 211, 238, 178, 255, 211, 238, 178, 255, 212, 238, 178, 255, 212, 238, 178, 255, 212, 239, 178, 255, 212, 239, 178, 255, 213, 239, 178, 255, 213, 239, 178, 255, 213, 239, 178, 255, 214, 239, 178, 255, 214, 239, 178, 255, 214, 239, 178, 255, 214, 240, 178, 255, 215, 240, 178, 255, 215, 240, 178, 255, 215, 240, 178, 255, 216, 240, 178, 255, 216, 240, 178, 255, 216, 240, 178, 255, 217, 240, 178, 255, 217, 240, 178, 255, 217, 241, 178, 255, 217, 241, 178, 255, 218, 241, 178, 255, 218, 241, 178, 255, 218, 241, 178, 255, 219, 241, 178, 255, 219, 241, 178, 255, 219, 241, 178, 255, 220, 242, 178, 255, 220, 242, 178, 255, 220, 242, 178, 255, 220, 242, 178, 255, 221, 242, 177, 255, 221, 242, 177, 255, 221, 242, 177, 255, 222, 242, 177, 255, 222, 242, 177, 255, 222, 243, 177, 255, 223, 243, 177, 255, 223, 243, 177, 255, 223, 243, 177, 255, 223, 243, 177, 255, 224, 243, 177, 255, 224, 243, 177, 255, 224, 243, 177, 255, 225, 243, 177, 255, 225, 244, 177, 255, 225, 244, 177, 255, 226, 244, 177, 255, 226, 244, 177, 255, 226, 244, 177, 255, 227, 244, 177, 255, 227, 244, 177, 255, 227, 244, 177, 255, 228, 244, 177, 255, 228, 245, 177, 255, 228, 245, 177, 255, 228, 245, 177, 255, 229, 245, 177, 255, 229, 245, 177, 255, 229, 245, 177, 255, 230, 245, 177, 255, 230, 245, 177, 255, 230, 245, 177, 255, 231, 246, 177, 255, 231, 246, 177, 255, 231, 246, 177, 255, 232, 246, 177, 255, 232, 246, 177, 255, 232, 246, 177, 255, 233, 246, 177, 255, 233, 246, 177, 255, 233, 246, 177, 255, 234, 247, 177, 255, 234, 247, 177, 255, 234, 247, 177, 255, 235, 247, 177, 255, 235, 247, 177, 255, 235, 247, 177, 255, 236, 247, 177, 255, 236, 247, 177, 255, 236, 247, 177, 255, 236, 248, 176, 255, 237, 248, 177, 255, 237, 248, 177, 255, 237, 248, 177, 255, 237, 248, 178, 255, 237, 248, 178, 255, 238, 248, 178, 255, 238, 248, 179, 255, 238, 248, 179, 255, 238, 248, 179, 255, 238, 248, 180, 255, 238, 248, 180, 255, 239, 248, 180, 255, 239, 248, 180, 255, 239, 248, 181, 255, 239, 248, 181, 255, 239, 248, 181, 255, 239, 248, 182, 255, 240, 248, 182, 255, 240, 248, 182, 255, 240, 248, 183, 255, 240, 249, 183, 255, 240, 249, 183, 255, 240, 249, 184, 255, 240, 249, 184, 255, 241, 249, 184, 255, 241, 249, 184, 255, 241, 249, 185, 255, 241, 249, 185, 255, 241, 249, 185, 255, 241, 249, 186, 255, 242, 249, 186, 255, 242, 249, 186, 255, 242, 249, 187, 255, 242, 249, 187, 255, 242, 249, 187, 255, 242, 249, 188, 255, 243, 249, 188, 255, 243, 249, 188, 255, 243, 249, 188, 255, 243, 250, 189, 255, 243, 250, 189, 255, 243, 250, 189, 255, 243, 250, 190, 255, 244, 250, 190, 255, 244, 250, 190, 255, 244, 250, 191, 255, 244, 250, 191, 255, 244, 250, 191, 255, 244, 250, 192, 255, 244, 250, 192, 255, 245, 250, 192, 255, 245, 250, 192, 255, 245, 250, 193, 255, 245, 250, 193, 255, 245, 250, 193, 255, 245, 250, 194, 255, 246, 250, 194, 255, 246, 250, 194, 255, 246, 251, 195, 255, 246, 251, 195, 255, 246, 251, 195, 255, 246, 251, 196, 255, 246, 251, 196, 255, 246, 251, 196, 255, 247, 251, 197, 255, 247, 251, 197, 255, 247, 251, 197, 255, 247, 251, 197, 255, 247, 251, 198, 255, 247, 251, 198, 255, 247, 251, 198, 255, 248, 251, 199, 255, 248, 251, 199, 255, 248, 251, 199, 255, 248, 251, 200, 255, 248, 251, 200, 255, 248, 252, 200, 255, 248, 252, 201, 255, 249, 252, 201, 255, 249, 252, 201, 255, 249, 252, 202, 255, 249, 252, 202, 255, 249, 252, 202, 255, 249, 252, 202, 255, 249, 252, 203, 255, 249, 252, 203, 255, 250, 252, 203, 255, 250, 252, 204, 255, 250, 252, 204, 255, 250, 252, 204, 255, 250, 252, 205, 255, 250, 252, 205, 255, 250, 252, 205, 255, 251, 252, 206, 255, 251, 253, 206, 255, 251, 253, 206, 255, 251, 253, 207, 255, 251, 253, 207, 255, 251, 253, 207, 255, 251, 253, 208, 255, 251, 253, 208, 255, 251, 253, 208, 255, 252, 253, 208, 255, 252, 253, 209, 255, 252, 253, 209, 255, 252, 253, 209, 255, 252, 253, 210, 255, 252, 253, 210, 255, 252, 253, 210, 255, 252, 253, 211, 255, 253, 253, 211, 255, 253, 254, 211, 255, 253, 254, 212, 255, 253, 254, 212, 255, 253, 254, 212, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_YlGnBu_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 8, 28, 88, 0, 8, 29, 88, 7, 8, 29, 88, 14, 8, 29, 89, 22, 8, 29, 89, 29, 8, 29, 89, 37, 8, 29, 90, 44, 8, 29, 90, 52, 9, 30, 90, 59, 9, 30, 91, 67, 9, 30, 91, 74, 9, 30, 91, 82, 9, 30, 92, 89, 9, 30, 92, 97, 10, 30, 93, 104, 10, 31, 93, 112, 10, 31, 93, 119, 10, 31, 94, 127, 10, 31, 94, 134, 10, 31, 94, 141, 11, 31, 95, 149, 11, 31, 95, 156, 11, 32, 96, 164, 11, 32, 96, 171, 11, 32, 96, 179, 11, 32, 97, 186, 12, 32, 97, 194, 12, 32, 97, 201, 12, 32, 98, 209, 12, 33, 98, 216, 12, 33, 98, 224, 12, 33, 99, 231, 13, 33, 99, 239, 13, 33, 100, 246, 13, 33, 100, 254, 13, 33, 100, 255, 13, 34, 101, 255, 13, 34, 101, 255, 14, 34, 101, 255, 14, 34, 102, 255, 14, 34, 102, 255, 14, 34, 103, 255, 14, 34, 103, 255, 14, 35, 103, 255, 15, 35, 104, 255, 15, 35, 104, 255, 15, 35, 104, 255, 15, 35, 105, 255, 15, 35, 105, 255, 15, 36, 105, 255, 16, 36, 106, 255, 16, 36, 106, 255, 16, 36, 107, 255, 16, 36, 107, 255, 16, 36, 107, 255, 16, 36, 108, 255, 17, 37, 108, 255, 17, 37, 108, 255, 17, 37, 109, 255, 17, 37, 109, 255, 17, 37, 110, 255, 18, 37, 110, 255, 18, 37, 110, 255, 18, 38, 111, 255, 24, 42, 123, 255, 24, 42, 123, 255, 24, 43, 124, 255, 24, 43, 124, 255, 25, 43, 125, 255, 25, 43, 125, 255, 25, 43, 125, 255, 25, 43, 126, 255, 25, 43, 126, 255, 26, 44, 126, 255, 26, 44, 127, 255, 26, 44, 127, 255, 26, 44, 128, 255, 26, 44, 128, 255, 27, 44, 128, 255, 27, 44, 129, 255, 27, 45, 129, 255, 27, 45, 130, 255, 27, 45, 130, 255, 27, 45, 130, 255, 28, 45, 131, 255, 28, 45, 131, 255, 28, 45, 131, 255, 28, 46, 132, 255, 28, 46, 132, 255, 29, 46, 133, 255, 29, 46, 133, 255, 29, 46, 133, 255, 29, 46, 134, 255, 29, 46, 134, 255, 30, 47, 134, 255, 30, 47, 135, 255, 30, 47, 135, 255, 30, 47, 136, 255, 30, 47, 136, 255, 31, 47, 136, 255, 31, 47, 137, 255, 31, 48, 137, 255, 31, 48, 137, 255, 31, 48, 138, 255, 32, 48, 138, 255, 32, 48, 139, 255, 32, 48, 139, 255, 32, 48, 139, 255, 32, 49, 140, 255, 33, 49, 140, 255, 33, 49, 141, 255, 33, 49, 141, 255, 33, 49, 141, 255, 33, 49, 142, 255, 34, 49, 142, 255, 34, 50, 142, 255, 34, 50, 143, 255, 34, 50, 143, 255, 34, 50, 144, 255, 35, 50, 144, 255, 35, 50, 144, 255, 35, 50, 145, 255, 35, 51, 145, 255, 35, 51, 146, 255, 36, 51, 146, 255, 36, 51, 146, 255, 36, 51, 147, 255, 36, 51, 147, 255, 37, 51, 148, 255, 36, 52, 148, 255, 36, 52, 148, 255, 36, 52, 148, 255, 36, 53, 148, 255, 36, 53, 148, 255, 36, 53, 148, 255, 35, 54, 149, 255, 35, 54, 149, 255, 35, 54, 149, 255, 35, 54, 149, 255, 35, 55, 149, 255, 35, 55, 149, 255, 35, 55, 150, 255, 34, 56, 150, 255, 34, 56, 150, 255, 34, 56, 150, 255, 34, 56, 150, 255, 34, 57, 150, 255, 34, 57, 151, 255, 34, 57, 151, 255, 34, 58, 151, 255, 33, 58, 151, 255, 33, 58, 151, 255, 33, 58, 151, 255, 33, 59, 151, 255, 33, 59, 152, 255, 33, 59, 152, 255, 33, 59, 152, 255, 32, 60, 152, 255, 32, 60, 152, 255, 32, 60, 152, 255, 32, 61, 153, 255, 32, 61, 153, 255, 32, 61, 153, 255, 32, 61, 153, 255, 32, 62, 153, 255, 32, 62, 153, 255, 31, 62, 153, 255, 31, 62, 154, 255, 31, 63, 154, 255, 31, 63, 154, 255, 31, 63, 154, 255, 31, 64, 154, 255, 31, 64, 154, 255, 31, 64, 154, 255, 31, 64, 154, 255, 31, 65, 155, 255, 31, 65, 155, 255, 30, 65, 155, 255, 30, 65, 155, 255, 30, 66, 155, 255, 30, 66, 155, 255, 30, 66, 155, 255, 30, 66, 156, 255, 30, 67, 156, 255, 30, 67, 156, 255, 30, 67, 156, 255, 30, 67, 156, 255, 30, 68, 156, 255, 30, 68, 156, 255, 30, 68, 156, 255, 30, 69, 157, 255, 30, 69, 157, 255, 29, 77, 161, 255, 29, 78, 161, 255, 29, 78, 161, 255, 29, 78, 161, 255, 29, 78, 161, 255, 29, 79, 161, 255, 29, 79, 162, 255, 29, 79, 162, 255, 29, 80, 162, 255, 29, 80, 162, 255, 29, 80, 162, 255, 29, 80, 162, 255, 29, 81, 162, 255, 29, 81, 162, 255, 29, 81, 162, 255, 29, 81, 163, 255, 29, 82, 163, 255, 29, 82, 163, 255, 29, 82, 163, 255, 29, 82, 163, 255, 29, 83, 163, 255, 29, 83, 163, 255, 29, 83, 163, 255, 29, 83, 163, 255, 29, 84, 164, 255, 29, 84, 164, 255, 29, 84, 164, 255, 29, 84, 164, 255, 29, 85, 164, 255, 29, 85, 164, 255, 29, 85, 164, 255, 29, 85, 164, 255, 30, 86, 164, 255, 30, 86, 165, 255, 30, 86, 165, 255, 30, 86, 165, 255, 30, 87, 165, 255, 30, 87, 165, 255, 30, 87, 165, 255, 30, 87, 165, 255, 30, 88, 165, 255, 30, 88, 165, 255, 30, 88, 165, 255, 31, 88, 166, 255, 31, 89, 166, 255, 31, 89, 166, 255, 31, 89, 166, 255, 31, 89, 166, 255, 31, 90, 166, 255, 31, 90, 166, 255, 31, 90, 166, 255, 32, 90, 166, 255, 32, 91, 166, 255, 32, 91, 167, 255, 32, 91, 167, 255, 32, 91, 167, 255, 32, 92, 167, 255, 32, 92, 167, 255, 33, 92, 167, 255, 33, 92, 167, 255, 33, 93, 167, 255, 33, 93, 167, 255, 33, 93, 167, 255, 33, 93, 167, 255, 34, 93, 168, 255, 33, 94, 168, 255, 33, 94, 168, 255, 32, 95, 168, 255, 32, 95, 168, 255, 32, 95, 169, 255, 31, 96, 169, 255, 31, 96, 169, 255, 30, 96, 169, 255, 30, 97, 169, 255, 30, 97, 170, 255, 29, 97, 170, 255, 29, 98, 170, 255, 28, 98, 170, 255, 28, 98, 170, 255, 28, 99, 171, 255, 27, 99, 171, 255, 27, 99, 171, 255, 26, 100, 171, 255, 26, 100, 171, 255, 26, 100, 172, 255, 25, 101, 172, 255, 25, 101, 172, 255, 24, 101, 172, 255, 24, 102, 172, 255, 23, 102, 173, 255, 23, 102, 173, 255, 23, 102, 173, 255, 22, 103, 173, 255, 22, 103, 173, 255, 21, 103, 174, 255, 21, 104, 174, 255, 20, 104, 174, 255, 20, 104, 174, 255, 20, 105, 174, 255, 19, 105, 175, 255, 19, 105, 175, 255, 18, 106, 175, 255, 18, 106, 175, 255, 17, 106, 175, 255, 17, 107, 175, 255, 16, 107, 176, 255, 16, 107, 176, 255, 16, 108, 176, 255, 15, 108, 176, 255, 15, 108, 176, 255, 14, 109, 176, 255, 14, 109, 177, 255, 13, 109, 177, 255, 13, 110, 177, 255, 13, 110, 177, 255, 12, 110, 177, 255, 12, 111, 177, 255, 11, 111, 178, 255, 11, 111, 178, 255, 11, 112, 178, 255, 11, 112, 178, 255, 10, 112, 178, 255, 10, 113, 178, 255, 10, 113, 178, 255, 10, 113, 179, 255, 9, 114, 179, 255, 9, 114, 179, 255, 9, 114, 179, 255, 8, 125, 184, 255, 8, 125, 184, 255, 8, 125, 184, 255, 7, 126, 184, 255, 7, 126, 185, 255, 7, 126, 185, 255, 7, 127, 185, 255, 7, 127, 185, 255, 7, 127, 185, 255, 7, 128, 185, 255, 7, 128, 185, 255, 7, 128, 186, 255, 7, 128, 186, 255, 7, 129, 186, 255, 7, 129, 186, 255, 7, 129, 186, 255, 8, 130, 186, 255, 8, 130, 186, 255, 8, 130, 186, 255, 8, 131, 187, 255, 8, 131, 187, 255, 9, 131, 187, 255, 9, 132, 187, 255, 9, 132, 187, 255, 9, 132, 187, 255, 10, 133, 187, 255, 10, 133, 187, 255, 10, 133, 188, 255, 11, 133, 188, 255, 11, 134, 188, 255, 11, 134, 188, 255, 12, 134, 188, 255, 12, 135, 188, 255, 13, 135, 188, 255, 13, 135, 188, 255, 14, 136, 189, 255, 14, 136, 189, 255, 15, 136, 189, 255, 15, 137, 189, 255, 16, 137, 189, 255, 16, 137, 189, 255, 17, 137, 189, 255, 17, 138, 189, 255, 18, 138, 189, 255, 18, 138, 190, 255, 19, 139, 190, 255, 19, 139, 190, 255, 20, 139, 190, 255, 20, 140, 190, 255, 21, 140, 190, 255, 21, 140, 190, 255, 22, 141, 190, 255, 22, 141, 190, 255, 23, 141, 190, 255, 23, 141, 191, 255, 24, 142, 191, 255, 24, 142, 191, 255, 25, 142, 191, 255, 25, 143, 191, 255, 26, 143, 191, 255, 26, 143, 191, 255, 27, 144, 191, 255, 27, 144, 191, 255, 28, 144, 191, 255, 29, 145, 192, 255, 28, 145, 192, 255, 28, 145, 192, 255, 28, 145, 192, 255, 28, 145, 192, 255, 28, 146, 192, 255, 28, 146, 192, 255, 27, 146, 192, 255, 27, 146, 192, 255, 27, 147, 192, 255, 27, 147, 192, 255, 27, 147, 192, 255, 27, 147, 192, 255, 27, 148, 192, 255, 27, 148, 192, 255, 27, 148, 193, 255, 27, 148, 193, 255, 27, 149, 193, 255, 27, 149, 193, 255, 27, 149, 193, 255, 27, 149, 193, 255, 27, 150, 193, 255, 27, 150, 193, 255, 27, 150, 193, 255, 27, 150, 193, 255, 27, 151, 193, 255, 27, 151, 193, 255, 27, 151, 193, 255, 27, 151, 193, 255, 27, 152, 193, 255, 27, 152, 193, 255, 27, 152, 193, 255, 27, 152, 193, 255, 27, 152, 193, 255, 27, 153, 194, 255, 27, 153, 194, 255, 27, 153, 194, 255, 27, 153, 194, 255, 28, 154, 194, 255, 28, 154, 194, 255, 28, 154, 194, 255, 28, 154, 194, 255, 28, 155, 194, 255, 28, 155, 194, 255, 28, 155, 194, 255, 29, 155, 194, 255, 29, 156, 194, 255, 29, 156, 194, 255, 29, 156, 194, 255, 29, 156, 194, 255, 30, 156, 194, 255, 30, 157, 194, 255, 30, 157, 194, 255, 30, 157, 194, 255, 31, 157, 194, 255, 31, 158, 194, 255, 31, 158, 194, 255, 31, 158, 194, 255, 32, 158, 194, 255, 32, 159, 194, 255, 32, 159, 194, 255, 32, 159, 194, 255, 33, 159, 194, 255, 33, 160, 194, 255, 40, 167, 195, 255, 41, 167, 195, 255, 41, 168, 195, 255, 41, 168, 195, 255, 42, 168, 195, 255, 42, 168, 195, 255, 42, 169, 195, 255, 43, 169, 195, 255, 43, 169, 195, 255, 43, 169, 195, 255, 44, 169, 195, 255, 44, 170, 195, 255, 44, 170, 195, 255, 45, 170, 196, 255, 45, 170, 196, 255, 45, 171, 196, 255, 46, 171, 196, 255, 46, 171, 196, 255, 46, 171, 196, 255, 47, 171, 196, 255, 47, 172, 196, 255, 47, 172, 196, 255, 48, 172, 196, 255, 48, 172, 196, 255, 48, 173, 196, 255, 49, 173, 196, 255, 49, 173, 196, 255, 50, 173, 196, 255, 50, 174, 196, 255, 50, 174, 196, 255, 51, 174, 196, 255, 51, 174, 196, 255, 52, 174, 196, 255, 52, 175, 196, 255, 52, 175, 196, 255, 53, 175, 196, 255, 53, 175, 196, 255, 53, 176, 196, 255, 54, 176, 196, 255, 54, 176, 196, 255, 55, 176, 196, 255, 55, 176, 196, 255, 55, 177, 196, 255, 56, 177, 196, 255, 56, 177, 196, 255, 57, 177, 196, 255, 57, 178, 196, 255, 57, 178, 196, 255, 58, 178, 196, 255, 58, 178, 196, 255, 59, 178, 196, 255, 59, 179, 196, 255, 60, 179, 196, 255, 60, 179, 196, 255, 60, 179, 196, 255, 61, 180, 196, 255, 61, 180, 196, 255, 62, 180, 196, 255, 62, 180, 196, 255, 62, 180, 196, 255, 63, 181, 196, 255, 63, 181, 196, 255, 64, 181, 196, 255, 64, 181, 196, 255, 65, 182, 195, 255, 65, 182, 195, 255, 65, 182, 195, 255, 66, 182, 195, 255, 66, 182, 195, 255, 66, 182, 195, 255, 67, 182, 195, 255, 67, 183, 195, 255, 68, 183, 195, 255, 68, 183, 195, 255, 68, 183, 195, 255, 69, 183, 195, 255, 69, 183, 195, 255, 69, 184, 195, 255, 70, 184, 195, 255, 70, 184, 195, 255, 71, 184, 195, 255, 71, 184, 194, 255, 71, 184, 194, 255, 72, 184, 194, 255, 72, 185, 194, 255, 73, 185, 194, 255, 73, 185, 194, 255, 73, 185, 194, 255, 74, 185, 194, 255, 74, 185, 194, 255, 74, 186, 194, 255, 75, 186, 194, 255, 75, 186, 194, 255, 76, 186, 194, 255, 76, 186, 194, 255, 76, 186, 194, 255, 77, 186, 194, 255, 77, 187, 193, 255, 78, 187, 193, 255, 78, 187, 193, 255, 78, 187, 193, 255, 79, 187, 193, 255, 79, 187, 193, 255, 80, 187, 193, 255, 80, 188, 193, 255, 80, 188, 193, 255, 81, 188, 193, 255, 81, 188, 193, 255, 81, 188, 193, 255, 82, 188, 193, 255, 82, 188, 193, 255, 83, 189, 193, 255, 83, 189, 193, 255, 83, 189, 192, 255, 84, 189, 192, 255, 84, 189, 192, 255, 85, 189, 192, 255, 85, 190, 192, 255, 85, 190, 192, 255, 86, 190, 192, 255, 86, 190, 192, 255, 87, 190, 192, 255, 87, 190, 192, 255, 87, 190, 192, 255, 88, 191, 192, 255, 88, 191, 192, 255, 88, 191, 192, 255, 89, 191, 192, 255, 102, 196, 190, 255, 102, 196, 190, 255, 102, 196, 190, 255, 103, 196, 190, 255, 103, 196, 190, 255, 104, 196, 189, 255, 104, 197, 189, 255, 104, 197, 189, 255, 105, 197, 189, 255, 105, 197, 189, 255, 106, 197, 189, 255, 106, 197, 189, 255, 106, 197, 189, 255, 107, 198, 189, 255, 107, 198, 189, 255, 108, 198, 189, 255, 108, 198, 189, 255, 108, 198, 189, 255, 109, 198, 189, 255, 109, 198, 189, 255, 109, 199, 189, 255, 110, 199, 189, 255, 110, 199, 188, 255, 111, 199, 188, 255, 111, 199, 188, 255, 111, 199, 188, 255, 112, 199, 188, 255, 112, 200, 188, 255, 113, 200, 188, 255, 113, 200, 188, 255, 113, 200, 188, 255, 114, 200, 188, 255, 114, 200, 188, 255, 115, 200, 188, 255, 115, 200, 188, 255, 115, 201, 188, 255, 116, 201, 188, 255, 116, 201, 188, 255, 116, 201, 188, 255, 117, 201, 188, 255, 117, 201, 188, 255, 118, 201, 188, 255, 118, 202, 187, 255, 118, 202, 187, 255, 119, 202, 187, 255, 119, 202, 187, 255, 120, 202, 187, 255, 120, 202, 187, 255, 120, 202, 187, 255, 121, 203, 187, 255, 121, 203, 187, 255, 121, 203, 187, 255, 122, 203, 187, 255, 122, 203, 187, 255, 123, 203, 187, 255, 123, 203, 187, 255, 123, 203, 187, 255, 124, 204, 187, 255, 124, 204, 187, 255, 125, 204, 187, 255, 125, 204, 187, 255, 125, 204, 187, 255, 126, 204, 187, 255, 126, 204, 187, 255, 127, 205, 186, 255, 127, 205, 186, 255, 127, 205, 186, 255, 128, 205, 186, 255, 128, 205, 186, 255, 128, 205, 186, 255, 129, 206, 186, 255, 129, 206, 186, 255, 130, 206, 186, 255, 130, 206, 186, 255, 130, 206, 186, 255, 131, 207, 186, 255, 131, 207, 186, 255, 132, 207, 186, 255, 132, 207, 186, 255, 132, 207, 186, 255, 133, 208, 186, 255, 133, 208, 186, 255, 134, 208, 186, 255, 134, 208, 185, 255, 134, 208, 185, 255, 135, 209, 185, 255, 135, 209, 185, 255, 136, 209, 185, 255, 136, 209, 185, 255, 136, 209, 185, 255, 137, 210, 185, 255, 137, 210, 185, 255, 138, 210, 185, 255, 138, 210, 185, 255, 138, 210, 185, 255, 139, 210, 185, 255, 139, 211, 185, 255, 140, 211, 185, 255, 140, 211, 185, 255, 141, 211, 185, 255, 141, 211, 184, 255, 141, 212, 184, 255, 142, 212, 184, 255, 142, 212, 184, 255, 143, 212, 184, 255, 143, 212, 184, 255, 144, 213, 184, 255, 144, 213, 184, 255, 144, 213, 184, 255, 145, 213, 184, 255, 145, 213, 184, 255, 146, 213, 184, 255, 146, 214, 184, 255, 147, 214, 184, 255, 147, 214, 184, 255, 148, 214, 184, 255, 148, 214, 184, 255, 148, 215, 184, 255, 149, 215, 183, 255, 149, 215, 183, 255, 150, 215, 183, 255, 150, 215, 183, 255, 151, 215, 183, 255, 151, 216, 183, 255, 152, 216, 183, 255, 152, 216, 183, 255, 152, 216, 183, 255, 153, 216, 183, 255, 168, 222, 182, 255, 168, 222, 181, 255, 169, 222, 181, 255, 169, 223, 181, 255, 170, 223, 181, 255, 170, 223, 181, 255, 171, 223, 181, 255, 171, 223, 181, 255, 171, 223, 181, 255, 172, 224, 181, 255, 172, 224, 181, 255, 173, 224, 181, 255, 173, 224, 181, 255, 174, 224, 181, 255, 174, 224, 181, 255, 175, 225, 181, 255, 175, 225, 181, 255, 176, 225, 181, 255, 176, 225, 181, 255, 177, 225, 181, 255, 177, 225, 181, 255, 178, 226, 181, 255, 178, 226, 181, 255, 178, 226, 180, 255, 179, 226, 180, 255, 179, 226, 180, 255, 180, 226, 180, 255, 180, 227, 180, 255, 181, 227, 180, 255, 181, 227, 180, 255, 182, 227, 180, 255, 182, 227, 180, 255, 183, 227, 180, 255, 183, 228, 180, 255, 184, 228, 180, 255, 184, 228, 180, 255, 185, 228, 180, 255, 185, 228, 180, 255, 186, 228, 180, 255, 186, 229, 180, 255, 187, 229, 180, 255, 187, 229, 180, 255, 188, 229, 180, 255, 188, 229, 180, 255, 189, 229, 180, 255, 189, 230, 180, 255, 190, 230, 180, 255, 190, 230, 180, 255, 191, 230, 180, 255, 191, 230, 180, 255, 192, 230, 180, 255, 192, 231, 180, 255, 193, 231, 180, 255, 193, 231, 180, 255, 194, 231, 180, 255, 194, 231, 180, 255, 195, 231, 180, 255, 195, 231, 180, 255, 196, 232, 180, 255, 196, 232, 180, 255, 197, 232, 180, 255, 197, 232, 180, 255, 198, 232, 180, 255, 198, 232, 180, 255, 198, 233, 179, 255, 199, 233, 179, 255, 199, 233, 179, 255, 199, 233, 179, 255, 199, 233, 179, 255, 200, 233, 179, 255, 200, 233, 179, 255, 200, 233, 179, 255, 200, 233, 179, 255, 200, 233, 179, 255, 201, 234, 179, 255, 201, 234, 179, 255, 201, 234, 179, 255, 201, 234, 179, 255, 202, 234, 179, 255, 202, 234, 179, 255, 202, 234, 179, 255, 202, 234, 179, 255, 202, 234, 179, 255, 203, 234, 179, 255, 203, 235, 179, 255, 203, 235, 179, 255, 203, 235, 179, 255, 203, 235, 179, 255, 204, 235, 179, 255, 204, 235, 179, 255, 204, 235, 179, 255, 204, 235, 179, 255, 205, 235, 179, 255, 205, 235, 179, 255, 205, 236, 179, 255, 205, 236, 179, 255, 205, 236, 179, 255, 206, 236, 179, 255, 206, 236, 179, 255, 206, 236, 179, 255, 206, 236, 179, 255, 207, 236, 179, 255, 207, 236, 179, 255, 207, 236, 179, 255, 207, 236, 179, 255, 208, 237, 179, 255, 208, 237, 179, 255, 208, 237, 179, 255, 208, 237, 179, 255, 208, 237, 179, 255, 209, 237, 179, 255, 209, 237, 179, 255, 209, 237, 178, 255, 209, 237, 178, 255, 210, 237, 178, 255, 210, 238, 178, 255, 210, 238, 178, 255, 210, 238, 178, 255, 211, 238, 178, 255, 211, 238, 178, 255, 211, 238, 178, 255, 211, 238, 178, 255, 211, 238, 178, 255, 212, 238, 178, 255, 212, 238, 178, 255, 212, 238, 178, 255, 212, 239, 178, 255, 213, 239, 178, 255, 221, 242, 178, 255, 221, 242, 178, 255, 221, 242, 178, 255, 221, 242, 178, 255, 221, 242, 177, 255, 222, 242, 177, 255, 222, 242, 177, 255, 222, 242, 177, 255, 222, 243, 177, 255, 223, 243, 177, 255, 223, 243, 177, 255, 223, 243, 177, 255, 223, 243, 177, 255, 224, 243, 177, 255, 224, 243, 177, 255, 224, 243, 177, 255, 224, 243, 177, 255, 225, 243, 177, 255, 225, 243, 177, 255, 225, 244, 177, 255, 225, 244, 177, 255, 226, 244, 177, 255, 226, 244, 177, 255, 226, 244, 177, 255, 226, 244, 177, 255, 227, 244, 177, 255, 227, 244, 177, 255, 227, 244, 177, 255, 227, 244, 177, 255, 228, 244, 177, 255, 228, 245, 177, 255, 228, 245, 177, 255, 228, 245, 177, 255, 229, 245, 177, 255, 229, 245, 177, 255, 229, 245, 177, 255, 229, 245, 177, 255, 230, 245, 177, 255, 230, 245, 177, 255, 230, 245, 177, 255, 230, 245, 177, 255, 231, 246, 177, 255, 231, 246, 177, 255, 231, 246, 177, 255, 231, 246, 177, 255, 232, 246, 177, 255, 232, 246, 177, 255, 232, 246, 177, 255, 232, 246, 177, 255, 233, 246, 177, 255, 233, 246, 177, 255, 233, 246, 177, 255, 233, 246, 177, 255, 234, 247, 177, 255, 234, 247, 177, 255, 234, 247, 177, 255, 234, 247, 177, 255, 235, 247, 177, 255, 235, 247, 177, 255, 235, 247, 177, 255, 235, 247, 177, 255, 236, 247, 177, 255, 236, 247, 177, 255, 236, 247, 177, 255, 236, 248, 176, 255, 237, 248, 177, 255, 237, 248, 177, 255, 237, 248, 177, 255, 237, 248, 177, 255, 237, 248, 178, 255, 237, 248, 178, 255, 237, 248, 178, 255, 238, 248, 178, 255, 238, 248, 179, 255, 238, 248, 179, 255, 238, 248, 179, 255, 238, 248, 179, 255, 238, 248, 180, 255, 238, 248, 180, 255, 239, 248, 180, 255, 239, 248, 180, 255, 239, 248, 181, 255, 239, 248, 181, 255, 239, 248, 181, 255, 239, 248, 181, 255, 239, 248, 182, 255, 239, 248, 182, 255, 240, 248, 182, 255, 240, 248, 182, 255, 240, 248, 183, 255, 240, 249, 183, 255, 240, 249, 183, 255, 240, 249, 183, 255, 240, 249, 184, 255, 240, 249, 184, 255, 241, 249, 184, 255, 241, 249, 184, 255, 241, 249, 185, 255, 241, 249, 185, 255, 241, 249, 185, 255, 241, 249, 185, 255, 241, 249, 186, 255, 241, 249, 186, 255, 242, 249, 186, 255, 242, 249, 186, 255, 242, 249, 187, 255, 242, 249, 187, 255, 242, 249, 187, 255, 242, 249, 187, 255, 242, 249, 188, 255, 242, 249, 188, 255, 243, 249, 188, 255, 243, 249, 188, 255, 243, 249, 189, 255, 243, 250, 189, 255, 243, 250, 189, 255, 243, 250, 189, 255, 243, 250, 190, 255, 243, 250, 190, 255, 243, 250, 190, 255, 244, 250, 190, 255, 244, 250, 191, 255, 244, 250, 191, 255, 244, 250, 191, 255, 244, 250, 191, 255, 244, 250, 192, 255, 244, 250, 192, 255, 244, 250, 192, 255, 248, 252, 200, 255, 248, 252, 201, 255, 248, 252, 201, 255, 248, 252, 201, 255, 249, 252, 201, 255, 249, 252, 202, 255, 249, 252, 202, 255, 249, 252, 202, 255, 249, 252, 202, 255, 249, 252, 203, 255, 249, 252, 203, 255, 249, 252, 203, 255, 249, 252, 203, 255, 250, 252, 204, 255, 250, 252, 204, 255, 250, 252, 204, 255, 250, 252, 204, 255, 250, 252, 205, 255, 250, 252, 205, 255, 250, 252, 205, 255, 250, 252, 205, 255, 250, 252, 206, 255, 250, 253, 206, 255, 251, 253, 206, 255, 251, 253, 206, 255, 251, 253, 207, 255, 251, 253, 207, 255, 251, 253, 207, 255, 251, 253, 207, 255, 251, 253, 208, 255, 251, 253, 208, 255, 251, 253, 208, 255, 252, 253, 208, 255, 252, 253, 209, 255, 252, 253, 209, 255, 252, 253, 209, 255, 252, 253, 209, 255, 252, 253, 210, 255, 252, 253, 210, 255, 252, 253, 210, 255, 252, 253, 210, 255, 252, 253, 211, 255, 252, 253, 211, 255, 253, 253, 211, 255, 253, 254, 211, 255, 253, 254, 212, 255, 253, 254, 212, 255, 253, 254, 212, 255, 253, 254, 212, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 213, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_YlGnBu_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 8, 28, 88, 0, 9, 30, 91, 24, 11, 31, 95, 49, 12, 33, 98, 74, 14, 34, 102, 99, 15, 35, 105, 124, 17, 37, 109, 149, 25, 43, 125, 174, 26, 44, 128, 199, 28, 46, 132, 224, 30, 47, 135, 249, 32, 48, 139, 255, 34, 49, 142, 255, 35, 51, 145, 255, 36, 53, 148, 255, 35, 55, 150, 255, 33, 58, 151, 255, 32, 60, 152, 255, 31, 62, 153, 255, 31, 65, 155, 255, 30, 67, 156, 255, 30, 69, 157, 255, 29, 80, 162, 255, 29, 82, 163, 255, 29, 84, 164, 255, 30, 86, 164, 255, 30, 88, 165, 255, 31, 90, 166, 255, 32, 92, 167, 255, 33, 93, 167, 255, 31, 96, 169, 255, 28, 99, 171, 255, 24, 101, 172, 255, 21, 103, 174, 255, 18, 106, 175, 255, 15, 108, 176, 255, 12, 111, 177, 255, 10, 113, 178, 255, 7, 125, 184, 255, 7, 128, 185, 255, 8, 130, 186, 255, 9, 132, 187, 255, 12, 134, 188, 255, 15, 136, 189, 255, 18, 138, 189, 255, 22, 140, 190, 255, 25, 142, 191, 255, 28, 144, 191, 255, 28, 146, 192, 255, 27, 148, 192, 255, 27, 149, 193, 255, 27, 151, 193, 255, 27, 152, 193, 255, 28, 154, 194, 255, 29, 155, 194, 255, 30, 157, 194, 255, 31, 158, 194, 255, 33, 159, 194, 255, 42, 168, 195, 255, 44, 170, 195, 255, 46, 171, 196, 255, 48, 172, 196, 255, 50, 173, 196, 255, 52, 175, 196, 255, 54, 176, 196, 255, 56, 177, 196, 255, 59, 178, 196, 255, 61, 180, 196, 255, 63, 181, 196, 255, 65, 182, 195, 255, 67, 183, 195, 255, 69, 183, 195, 255, 71, 184, 194, 255, 73, 185, 194, 255, 75, 186, 194, 255, 77, 187, 193, 255, 79, 187, 193, 255, 81, 188, 193, 255, 83, 189, 193, 255, 85, 190, 192, 255, 87, 190, 192, 255, 89, 191, 192, 255, 103, 196, 190, 255, 105, 197, 189, 255, 107, 198, 189, 255, 108, 198, 189, 255, 110, 199, 188, 255, 112, 199, 188, 255, 114, 200, 188, 255, 115, 201, 188, 255, 117, 201, 188, 255, 119, 202, 187, 255, 121, 202, 187, 255, 122, 203, 187, 255, 124, 204, 187, 255, 125, 204, 187, 255, 127, 205, 186, 255, 129, 206, 186, 255, 130, 206, 186, 255, 132, 207, 186, 255, 133, 208, 186, 255, 135, 209, 185, 255, 137, 209, 185, 255, 138, 210, 185, 255, 140, 211, 185, 255, 141, 212, 184, 255, 143, 212, 184, 255, 145, 213, 184, 255, 146, 214, 184, 255, 148, 214, 184, 255, 149, 215, 183, 255, 151, 216, 183, 255, 153, 216, 183, 255, 169, 222, 181, 255, 170, 223, 181, 255, 172, 224, 181, 255, 173, 224, 181, 255, 175, 225, 181, 255, 177, 225, 181, 255, 178, 226, 181, 255, 180, 226, 180, 255, 181, 227, 180, 255, 183, 227, 180, 255, 184, 228, 180, 255, 186, 229, 180, 255, 187, 229, 180, 255, 189, 229, 180, 255, 190, 230, 180, 255, 192, 230, 180, 255, 193, 231, 180, 255, 195, 231, 180, 255, 196, 232, 180, 255, 198, 232, 180, 255, 199, 233, 179, 255, 199, 233, 179, 255, 200, 233, 179, 255, 201, 233, 179, 255, 201, 234, 179, 255, 202, 234, 179, 255, 202, 234, 179, 255, 203, 235, 179, 255, 204, 235, 179, 255, 204, 235, 179, 255, 205, 235, 179, 255, 205, 236, 179, 255, 206, 236, 179, 255, 206, 236, 179, 255, 207, 236, 179, 255, 208, 237, 179, 255, 208, 237, 179, 255, 209, 237, 179, 255, 209, 237, 178, 255, 210, 238, 178, 255, 210, 238, 178, 255, 211, 238, 178, 255, 211, 238, 178, 255, 212, 238, 178, 255, 212, 239, 178, 255, 221, 242, 178, 255, 221, 242, 178, 255, 222, 242, 177, 255, 222, 242, 177, 255, 223, 243, 177, 255, 223, 243, 177, 255, 224, 243, 177, 255, 224, 243, 177, 255, 225, 243, 177, 255, 225, 244, 177, 255, 226, 244, 177, 255, 226, 244, 177, 255, 227, 244, 177, 255, 227, 244, 177, 255, 228, 244, 177, 255, 228, 245, 177, 255, 229, 245, 177, 255, 229, 245, 177, 255, 229, 245, 177, 255, 230, 245, 177, 255, 230, 245, 177, 255, 231, 246, 177, 255, 231, 246, 177, 255, 232, 246, 177, 255, 232, 246, 177, 255, 233, 246, 177, 255, 233, 246, 177, 255, 233, 247, 177, 255, 234, 247, 177, 255, 234, 247, 177, 255, 235, 247, 177, 255, 235, 247, 177, 255, 236, 247, 177, 255, 236, 247, 177, 255, 236, 247, 177, 255, 237, 248, 177, 255, 237, 248, 177, 255, 237, 248, 178, 255, 237, 248, 178, 255, 237, 248, 178, 255, 238, 248, 179, 255, 238, 248, 179, 255, 238, 248, 179, 255, 238, 248, 180, 255, 238, 248, 180, 255, 239, 248, 180, 255, 239, 248, 181, 255, 239, 248, 181, 255, 239, 248, 181, 255, 239, 248, 182, 255, 239, 248, 182, 255, 240, 248, 182, 255, 240, 248, 183, 255, 240, 249, 183, 255, 240, 249, 183, 255, 240, 249, 183, 255, 240, 249, 184, 255, 241, 249, 184, 255, 241, 249, 184, 255, 241, 249, 185, 255, 241, 249, 185, 255, 241, 249, 185, 255, 241, 249, 186, 255, 241, 249, 186, 255, 242, 249, 186, 255, 242, 249, 186, 255, 242, 249, 187, 255, 242, 249, 187, 255, 242, 249, 187, 255, 242, 249, 187, 255, 242, 249, 188, 255, 242, 249, 188, 255, 243, 249, 188, 255, 243, 249, 188, 255, 243, 250, 189, 255, 243, 250, 189, 255, 243, 250, 189, 255, 243, 250, 189, 255, 243, 250, 190, 255, 243, 250, 190, 255, 244, 250, 190, 255, 244, 250, 190, 255, 244, 250, 191, 255, 244, 250, 191, 255, 244, 250, 191, 255, 244, 250, 191, 255, 244, 250, 191, 255, 244, 250, 192, 255, 244, 250, 192, 255, 244, 250, 192, 255, 248, 252, 200, 255, 248, 252, 200, 255, 248, 252, 201, 255, 248, 252, 201, 255, 248, 252, 201, 255, 249, 252, 201, 255, 249, 252, 201, 255, 249, 252, 202, 255, 249, 252, 202, 255, 249, 252, 202, 255, 249, 252, 202, 255, 249, 252, 202, 255, 249, 252, 203, 255, 249, 252, 203, 255, 249, 252, 203, 255, 249, 252, 203, 255, 249, 252, 203, 255, 250, 252, 203, 255, 250, 252, 204, 255, 250, 252, 204, 255, 250, 252, 204, 255, 250, 252, 204, 255, 250, 252, 204, 255, 250, 252, 204, 255, 250, 252, 205, 255, 250, 252, 205, 255, 250, 252, 205, 255, 250, 252, 205, 255, 250, 252, 205, 255, 250, 252, 205, 255, 250, 252, 206, 255, 250, 252, 206, 255, 250, 253, 206, 255, 251, 253, 206, 255, 251, 253, 206, 255, 251, 253, 206, 255, 251, 253, 206, 255, 251, 253, 206, 255, 251, 253, 207, 255, 251, 253, 207, 255, 251, 253, 207, 255, 251, 253, 207, 255, 251, 253, 207, 255, 251, 253, 207, 255, 251, 253, 207, 255, 251, 253, 208, 255, 251, 253, 208, 255, 251, 253, 208, 255, 251, 253, 208, 255, 251, 253, 208, 255, 251, 253, 208, 255, 251, 253, 208, 255, 252, 253, 208, 255, 252, 253, 208, 255, 252, 253, 209, 255, 252, 253, 209, 255, 252, 253, 209, 255, 252, 253, 209, 255, 252, 253, 209, 255, 252, 253, 209, 255, 252, 253, 209, 255, 252, 253, 209, 255, 252, 253, 209, 255, 252, 253, 209, 255, 252, 253, 210, 255, 252, 253, 210, 255, 252, 253, 210, 255, 252, 253, 210, 255, 252, 253, 210, 255, 252, 253, 210, 255, 252, 253, 210, 255, 252, 253, 210, 255, 252, 253, 210, 255, 252, 253, 210, 255, 252, 253, 210, 255, 252, 253, 211, 255, 252, 253, 211, 255, 252, 253, 211, 255, 252, 253, 211, 255, 252, 253, 211, 255, 253, 253, 211, 255, 253, 253, 211, 255, 253, 253, 211, 255, 253, 254, 211, 255, 253, 254, 211, 255, 253, 254, 211, 255, 253, 254, 211, 255, 253, 254, 212, 255, 253, 254, 212, 255, 253, 254, 212, 255, 253, 254, 212, 255, 253, 254, 212, 255, 253, 254, 212, 255, 253, 254, 212, 255, 253, 254, 212, 255, 253, 254, 212, 255, 253, 254, 212, 255, 253, 254, 212, 255, 253, 254, 212, 255, 253, 254, 212, 255, 253, 254, 212, 255, 253, 254, 212, 255, 253, 254, 212, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 213, 255, 253, 254, 214, 255, 253, 254, 214, 255, 253, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 214, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 215, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 254, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255, 254, 255, 216, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_YlGnBu_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
