/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/Purples.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 63, 0, 125, 255, 84, 39, 143, 255, 106, 81, 163, 255, 128, 125, 186, 255, 158, 154, 200, 255, 188, 189, 220, 255, 218, 218, 235, 255, 239, 237, 245, 255, 252, 251, 253, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Purples_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 63, 0, 125, 0, 63, 0, 125, 7, 63, 0, 125, 14, 63, 1, 125, 22, 63, 1, 125, 29, 63, 1, 125, 37, 64, 2, 125, 44, 64, 2, 125, 52, 64, 2, 126, 59, 64, 3, 126, 67, 64, 3, 126, 74, 64, 3, 126, 82, 65, 4, 126, 89, 65, 4, 126, 97, 65, 5, 126, 104, 65, 5, 127, 112, 65, 5, 127, 119, 65, 6, 127, 127, 66, 6, 127, 134, 66, 7, 127, 141, 66, 7, 127, 149, 66, 7, 127, 156, 66, 8, 128, 164, 66, 8, 128, 171, 67, 9, 128, 179, 67, 9, 128, 186, 67, 9, 128, 194, 67, 10, 128, 201, 67, 10, 128, 209, 67, 11, 129, 216, 68, 11, 129, 224, 68, 11, 129, 231, 68, 12, 129, 239, 68, 12, 129, 246, 68, 12, 129, 254, 68, 13, 129, 255, 68, 13, 130, 255, 69, 14, 130, 255, 69, 14, 130, 255, 69, 14, 130, 255, 69, 15, 130, 255, 69, 15, 130, 255, 69, 15, 130, 255, 70, 16, 131, 255, 70, 16, 131, 255, 70, 16, 131, 255, 70, 17, 131, 255, 70, 17, 131, 255, 70, 17, 131, 255, 71, 18, 131, 255, 71, 18, 132, 255, 71, 18, 132, 255, 71, 18, 132, 255, 71, 19, 132, 255, 71, 19, 132, 255, 72, 19, 132, 255, 72, 20, 132, 255, 72, 20, 133, 255, 72, 20, 133, 255, 72, 21, 133, 255, 72, 21, 133, 255, 73, 21, 133, 255, 73, 21, 133, 255, 73, 22, 133, 255, 73, 22, 134, 255, 73, 22, 134, 255, 73, 23, 134, 255, 74, 23, 134, 255, 74, 23, 134, 255, 74, 23, 134, 255, 74, 24, 134, 255, 74, 24, 135, 255, 74, 24, 135, 255, 75, 25, 135, 255, 75, 25, 135, 255, 75, 25, 135, 255, 75, 25, 135, 255, 75, 26, 135, 255, 75, 26, 136, 255, 76, 26, 136, 255, 76, 27, 136, 255, 76, 27, 136, 255, 76, 27, 136, 255, 76, 27, 136, 255, 76, 28, 136, 255, 77, 28, 136, 255, 77, 28, 137, 255, 77, 28, 137, 255, 77, 29, 137, 255, 77, 29, 137, 255, 77, 29, 137, 255, 78, 29, 137, 255, 78, 30, 137, 255, 78, 30, 138, 255, 78, 30, 138, 255, 78, 30, 138, 255, 78, 31, 138, 255, 78, 31, 138, 255, 79, 31, 138, 255, 79, 31, 138, 255, 79, 32, 139, 255, 79, 32, 139, 255, 79, 32, 139, 255, 79, 32, 139, 255, 80, 33, 139, 255, 80, 33, 139, 255, 80, 33, 139, 255, 80, 33, 140, 255, 80, 34, 140, 255, 80, 34, 140, 255, 81, 34, 140, 255, 81, 34, 140, 255, 81, 35, 140, 255, 81, 35, 140, 255, 81, 35, 141, 255, 81, 35, 141, 255, 82, 36, 141, 255, 82, 36, 141, 255, 82, 36, 141, 255, 82, 36, 141, 255, 82, 37, 141, 255, 82, 37, 142, 255, 83, 37, 142, 255, 83, 37, 142, 255, 83, 38, 142, 255, 83, 38, 142, 255, 83, 38, 142, 255, 83, 38, 142, 255, 83, 39, 143, 255, 84, 39, 143, 255, 84, 39, 143, 255, 84, 40, 143, 255, 84, 40, 143, 255, 84, 40, 143, 255, 84, 41, 144, 255, 85, 41, 144, 255, 85, 41, 144, 255, 85, 42, 144, 255, 85, 42, 144, 255, 85, 43, 144, 255, 85, 43, 145, 255, 86, 43, 145, 255, 86, 44, 145, 255, 86, 44, 145, 255, 86, 44, 145, 255, 86, 45, 145, 255, 86, 45, 146, 255, 87, 45, 146, 255, 87, 46, 146, 255, 87, 46, 146, 255, 87, 46, 146, 255, 87, 47, 146, 255, 87, 47, 146, 255, 88, 47, 147, 255, 88, 48, 147, 255, 88, 48, 147, 255, 88, 48, 147, 255, 88, 49, 147, 255, 88, 49, 147, 255, 89, 49, 148, 255, 89, 50, 148, 255, 89, 50, 148, 255, 89, 51, 148, 255, 89, 51, 148, 255, 89, 51, 148, 255, 90, 52, 149, 255, 90, 52, 149, 255, 90, 52, 149, 255, 90, 53, 149, 255, 90, 53, 149, 255, 90, 53, 149, 255, 91, 54, 150, 255, 91, 54, 150, 255, 91, 54, 150, 255, 91, 55, 150, 255, 91, 55, 150, 255, 91, 55, 150, 255, 92, 56, 151, 255, 92, 56, 151, 255, 92, 56, 151, 255, 92, 56, 151, 255, 92, 57, 151, 255, 92, 57, 151, 255, 93, 57, 151, 255, 93, 58, 152, 255, 93, 58, 152, 255, 93, 58, 152, 255, 93, 59, 152, 255, 93, 59, 152, 255, 94, 59, 152, 255, 94, 60, 153, 255, 94, 60, 153, 255, 94, 60, 153, 255, 94, 61, 153, 255, 94, 61, 153, 255, 95, 61, 153, 255, 95, 62, 154, 255, 95, 62, 154, 255, 95, 62, 154, 255, 95, 63, 154, 255, 96, 63, 154, 255, 96, 63, 154, 255, 96, 64, 154, 255, 96, 64, 155, 255, 96, 64, 155, 255, 96, 65, 155, 255, 97, 65, 155, 255, 97, 65, 155, 255, 97, 66, 155, 255, 97, 66, 156, 255, 97, 66, 156, 255, 97, 66, 156, 255, 98, 67, 156, 255, 98, 67, 156, 255, 98, 67, 156, 255, 98, 68, 156, 255, 98, 68, 157, 255, 98, 68, 157, 255, 99, 69, 157, 255, 99, 69, 157, 255, 99, 69, 157, 255, 99, 70, 157, 255, 99, 70, 158, 255, 100, 70, 158, 255, 100, 71, 158, 255, 100, 71, 158, 255, 100, 71, 158, 255, 100, 72, 158, 255, 100, 72, 158, 255, 101, 72, 159, 255, 101, 72, 159, 255, 101, 73, 159, 255, 101, 73, 159, 255, 101, 73, 159, 255, 101, 74, 159, 255, 102, 74, 159, 255, 102, 74, 160, 255, 102, 75, 160, 255, 102, 75, 160, 255, 102, 75, 160, 255, 103, 76, 160, 255, 103, 76, 160, 255, 103, 76, 160, 255, 103, 76, 161, 255, 103, 77, 161, 255, 103, 77, 161, 255, 104, 77, 161, 255, 104, 78, 161, 255, 104, 78, 161, 255, 104, 78, 161, 255, 104, 79, 162, 255, 105, 79, 162, 255, 105, 79, 162, 255, 105, 80, 162, 255, 105, 80, 162, 255, 105, 80, 162, 255, 105, 81, 163, 255, 106, 81, 163, 255, 106, 81, 163, 255, 106, 82, 163, 255, 106, 82, 163, 255, 106, 82, 164, 255, 106, 83, 164, 255, 106, 83, 164, 255, 107, 83, 164, 255, 107, 84, 164, 255, 107, 84, 165, 255, 107, 84, 165, 255, 107, 85, 165, 255, 107, 85, 165, 255, 107, 85, 165, 255, 108, 86, 166, 255, 108, 86, 166, 255, 108, 87, 166, 255, 108, 87, 166, 255, 108, 87, 166, 255, 108, 88, 167, 255, 108, 88, 167, 255, 109, 88, 167, 255, 109, 89, 167, 255, 109, 89, 167, 255, 109, 89, 167, 255, 109, 90, 168, 255, 109, 90, 168, 255, 109, 90, 168, 255, 110, 91, 168, 255, 110, 91, 168, 255, 110, 91, 169, 255, 110, 92, 169, 255, 110, 92, 169, 255, 110, 92, 169, 255, 111, 93, 169, 255, 111, 93, 170, 255, 111, 94, 170, 255, 111, 94, 170, 255, 111, 94, 170, 255, 111, 95, 170, 255, 111, 95, 171, 255, 112, 95, 171, 255, 112, 96, 171, 255, 112, 96, 171, 255, 112, 96, 171, 255, 112, 97, 171, 255, 112, 97, 172, 255, 113, 97, 172, 255, 113, 98, 172, 255, 113, 98, 172, 255, 113, 98, 172, 255, 113, 99, 173, 255, 113, 99, 173, 255, 114, 99, 173, 255, 114, 100, 173, 255, 114, 100, 173, 255, 114, 100, 174, 255, 114, 101, 174, 255, 114, 101, 174, 255, 115, 101, 174, 255, 115, 102, 174, 255, 115, 102, 174, 255, 115, 103, 175, 255, 115, 103, 175, 255, 115, 103, 175, 255, 116, 104, 175, 255, 116, 104, 175, 255, 116, 104, 175, 255, 116, 105, 176, 255, 116, 105, 176, 255, 116, 105, 176, 255, 117, 106, 176, 255, 117, 106, 176, 255, 117, 106, 177, 255, 117, 107, 177, 255, 117, 107, 177, 255, 118, 107, 177, 255, 118, 108, 177, 255, 118, 108, 177, 255, 118, 108, 178, 255, 118, 109, 178, 255, 118, 109, 178, 255, 119, 109, 178, 255, 119, 110, 178, 255, 119, 110, 178, 255, 119, 110, 179, 255, 119, 111, 179, 255, 120, 111, 179, 255, 120, 111, 179, 255, 120, 112, 179, 255, 120, 112, 179, 255, 120, 112, 180, 255, 120, 113, 180, 255, 121, 113, 180, 255, 121, 113, 180, 255, 121, 114, 180, 255, 121, 114, 180, 255, 121, 114, 181, 255, 122, 115, 181, 255, 122, 115, 181, 255, 122, 115, 181, 255, 122, 116, 181, 255, 122, 116, 181, 255, 123, 116, 182, 255, 123, 117, 182, 255, 123, 117, 182, 255, 123, 117, 182, 255, 123, 118, 182, 255, 124, 118, 182, 255, 124, 118, 183, 255, 124, 119, 183, 255, 124, 119, 183, 255, 124, 119, 183, 255, 125, 120, 183, 255, 125, 120, 183, 255, 125, 120, 184, 255, 125, 121, 184, 255, 125, 121, 184, 255, 126, 121, 184, 255, 126, 122, 184, 255, 126, 122, 184, 255, 126, 122, 185, 255, 126, 123, 185, 255, 127, 123, 185, 255, 127, 123, 185, 255, 127, 124, 185, 255, 127, 124, 185, 255, 127, 125, 186, 255, 128, 125, 186, 255, 128, 125, 186, 255, 128, 125, 186, 255, 128, 125, 186, 255, 129, 126, 186, 255, 129, 126, 186, 255, 129, 126, 186, 255, 129, 126, 186, 255, 130, 127, 186, 255, 130, 127, 187, 255, 130, 127, 187, 255, 130, 127, 187, 255, 131, 127, 187, 255, 131, 128, 187, 255, 131, 128, 187, 255, 131, 128, 187, 255, 132, 128, 187, 255, 132, 129, 187, 255, 132, 129, 188, 255, 132, 129, 188, 255, 132, 129, 188, 255, 133, 129, 188, 255, 133, 130, 188, 255, 133, 130, 188, 255, 133, 130, 188, 255, 134, 130, 188, 255, 134, 131, 188, 255, 134, 131, 189, 255, 134, 131, 189, 255, 135, 131, 189, 255, 135, 131, 189, 255, 135, 132, 189, 255, 135, 132, 189, 255, 136, 132, 189, 255, 136, 132, 189, 255, 136, 133, 189, 255, 136, 133, 190, 255, 137, 133, 190, 255, 137, 133, 190, 255, 137, 133, 190, 255, 137, 134, 190, 255, 137, 134, 190, 255, 138, 134, 190, 255, 138, 134, 190, 255, 138, 135, 190, 255, 138, 135, 191, 255, 139, 135, 191, 255, 139, 135, 191, 255, 139, 135, 191, 255, 139, 136, 191, 255, 140, 136, 191, 255, 140, 136, 191, 255, 140, 136, 191, 255, 140, 137, 191, 255, 140, 137, 192, 255, 141, 137, 192, 255, 141, 137, 192, 255, 141, 138, 192, 255, 141, 138, 192, 255, 142, 138, 192, 255, 142, 138, 192, 255, 142, 138, 192, 255, 142, 139, 192, 255, 143, 139, 193, 255, 143, 139, 193, 255, 143, 139, 193, 255, 143, 140, 193, 255, 144, 140, 193, 255, 144, 140, 193, 255, 144, 140, 193, 255, 144, 140, 193, 255, 144, 141, 193, 255, 145, 141, 193, 255, 145, 141, 194, 255, 145, 141, 194, 255, 145, 142, 194, 255, 146, 142, 194, 255, 146, 142, 194, 255, 146, 142, 194, 255, 146, 142, 194, 255, 147, 143, 194, 255, 147, 143, 194, 255, 147, 143, 195, 255, 147, 143, 195, 255, 148, 144, 195, 255, 148, 144, 195, 255, 148, 144, 195, 255, 148, 144, 195, 255, 148, 145, 195, 255, 149, 145, 195, 255, 149, 145, 195, 255, 149, 145, 196, 255, 149, 145, 196, 255, 150, 146, 196, 255, 150, 146, 196, 255, 150, 146, 196, 255, 150, 146, 196, 255, 151, 147, 196, 255, 151, 147, 196, 255, 151, 147, 196, 255, 151, 147, 197, 255, 151, 148, 197, 255, 152, 148, 197, 255, 152, 148, 197, 255, 152, 148, 197, 255, 152, 148, 197, 255, 153, 149, 197, 255, 153, 149, 197, 255, 153, 149, 197, 255, 153, 149, 198, 255, 154, 150, 198, 255, 154, 150, 198, 255, 154, 150, 198, 255, 154, 150, 198, 255, 154, 151, 198, 255, 155, 151, 198, 255, 155, 151, 198, 255, 155, 151, 198, 255, 155, 151, 199, 255, 156, 152, 199, 255, 156, 152, 199, 255, 156, 152, 199, 255, 156, 152, 199, 255, 157, 153, 199, 255, 157, 153, 199, 255, 157, 153, 199, 255, 157, 153, 199, 255, 157, 154, 199, 255, 158, 154, 200, 255, 158, 154, 200, 255, 158, 154, 200, 255, 158, 155, 200, 255, 159, 155, 200, 255, 159, 155, 200, 255, 159, 155, 201, 255, 159, 156, 201, 255, 159, 156, 201, 255, 160, 156, 201, 255, 160, 156, 201, 255, 160, 157, 201, 255, 160, 157, 202, 255, 161, 157, 202, 255, 161, 158, 202, 255, 161, 158, 202, 255, 161, 158, 202, 255, 161, 158, 202, 255, 162, 159, 203, 255, 162, 159, 203, 255, 162, 159, 203, 255, 162, 159, 203, 255, 163, 160, 203, 255, 163, 160, 203, 255, 163, 160, 204, 255, 163, 161, 204, 255, 163, 161, 204, 255, 164, 161, 204, 255, 164, 161, 204, 255, 164, 162, 204, 255, 164, 162, 204, 255, 165, 162, 205, 255, 165, 163, 205, 255, 165, 163, 205, 255, 165, 163, 205, 255, 166, 163, 205, 255, 166, 164, 205, 255, 166, 164, 206, 255, 166, 164, 206, 255, 166, 164, 206, 255, 167, 165, 206, 255, 167, 165, 206, 255, 167, 165, 206, 255, 167, 166, 207, 255, 168, 166, 207, 255, 168, 166, 207, 255, 168, 166, 207, 255, 168, 167, 207, 255, 169, 167, 207, 255, 169, 167, 207, 255, 169, 167, 208, 255, 169, 168, 208, 255, 169, 168, 208, 255, 170, 168, 208, 255, 170, 169, 208, 255, 170, 169, 208, 255, 170, 169, 209, 255, 171, 169, 209, 255, 171, 170, 209, 255, 171, 170, 209, 255, 171, 170, 209, 255, 172, 170, 209, 255, 172, 171, 210, 255, 172, 171, 210, 255, 172, 171, 210, 255, 172, 172, 210, 255, 173, 172, 210, 255, 173, 172, 210, 255, 173, 172, 210, 255, 173, 173, 211, 255, 174, 173, 211, 255, 174, 173, 211, 255, 174, 173, 211, 255, 174, 174, 211, 255, 175, 174, 211, 255, 175, 174, 212, 255, 175, 175, 212, 255, 175, 175, 212, 255, 176, 175, 212, 255, 176, 175, 212, 255, 176, 176, 212, 255, 176, 176, 212, 255, 177, 176, 213, 255, 177, 176, 213, 255, 177, 177, 213, 255, 177, 177, 213, 255, 177, 177, 213, 255, 178, 178, 213, 255, 178, 178, 214, 255, 178, 178, 214, 255, 178, 178, 214, 255, 179, 179, 214, 255, 179, 179, 214, 255, 179, 179, 214, 255, 179, 179, 214, 255, 180, 180, 215, 255, 180, 180, 215, 255, 180, 180, 215, 255, 180, 181, 215, 255, 181, 181, 215, 255, 181, 181, 215, 255, 181, 181, 216, 255, 181, 182, 216, 255, 182, 182, 216, 255, 182, 182, 216, 255, 182, 182, 216, 255, 182, 183, 216, 255, 183, 183, 216, 255, 183, 183, 217, 255, 183, 184, 217, 255, 183, 184, 217, 255, 184, 184, 217, 255, 184, 184, 217, 255, 184, 185, 217, 255, 184, 185, 218, 255, 185, 185, 218, 255, 185, 185, 218, 255, 185, 186, 218, 255, 185, 186, 218, 255, 186, 186, 218, 255, 186, 187, 218, 255, 186, 187, 219, 255, 186, 187, 219, 255, 187, 187, 219, 255, 187, 188, 219, 255, 187, 188, 219, 255, 187, 188, 219, 255, 187, 189, 219, 255, 188, 189, 220, 255, 188, 189, 220, 255, 188, 189, 220, 255, 188, 189, 220, 255, 189, 190, 220, 255, 189, 190, 220, 255, 189, 190, 220, 255, 189, 190, 220, 255, 190, 191, 221, 255, 190, 191, 221, 255, 190, 191, 221, 255, 190, 191, 221, 255, 191, 191, 221, 255, 191, 192, 221, 255, 191, 192, 221, 255, 191, 192, 221, 255, 191, 192, 221, 255, 192, 193, 222, 255, 192, 193, 222, 255, 192, 193, 222, 255, 192, 193, 222, 255, 193, 193, 222, 255, 193, 194, 222, 255, 193, 194, 222, 255, 193, 194, 222, 255, 194, 194, 223, 255, 194, 195, 223, 255, 194, 195, 223, 255, 194, 195, 223, 255, 195, 195, 223, 255, 195, 195, 223, 255, 195, 196, 223, 255, 195, 196, 223, 255, 195, 196, 223, 255, 196, 196, 224, 255, 196, 197, 224, 255, 196, 197, 224, 255, 196, 197, 224, 255, 197, 197, 224, 255, 197, 197, 224, 255, 197, 198, 224, 255, 197, 198, 224, 255, 198, 198, 225, 255, 198, 198, 225, 255, 198, 199, 225, 255, 198, 199, 225, 255, 199, 199, 225, 255, 199, 199, 225, 255, 199, 199, 225, 255, 199, 200, 225, 255, 199, 200, 225, 255, 200, 200, 226, 255, 200, 200, 226, 255, 200, 201, 226, 255, 200, 201, 226, 255, 201, 201, 226, 255, 201, 201, 226, 255, 201, 202, 226, 255, 201, 202, 226, 255, 202, 202, 227, 255, 202, 202, 227, 255, 202, 202, 227, 255, 202, 203, 227, 255, 203, 203, 227, 255, 203, 203, 227, 255, 203, 203, 227, 255, 203, 204, 227, 255, 203, 204, 227, 255, 204, 204, 228, 255, 204, 204, 228, 255, 204, 204, 228, 255, 204, 205, 228, 255, 205, 205, 228, 255, 205, 205, 228, 255, 205, 205, 228, 255, 205, 206, 228, 255, 206, 206, 229, 255, 206, 206, 229, 255, 206, 206, 229, 255, 206, 207, 229, 255, 207, 207, 229, 255, 207, 207, 229, 255, 207, 207, 229, 255, 207, 207, 229, 255, 207, 208, 229, 255, 208, 208, 230, 255, 208, 208, 230, 255, 208, 208, 230, 255, 208, 209, 230, 255, 209, 209, 230, 255, 209, 209, 230, 255, 209, 209, 230, 255, 209, 209, 230, 255, 210, 210, 231, 255, 210, 210, 231, 255, 210, 210, 231, 255, 210, 210, 231, 255, 210, 211, 231, 255, 211, 211, 231, 255, 211, 211, 231, 255, 211, 211, 231, 255, 211, 212, 231, 255, 212, 212, 232, 255, 212, 212, 232, 255, 212, 212, 232, 255, 212, 212, 232, 255, 213, 213, 232, 255, 213, 213, 232, 255, 213, 213, 232, 255, 213, 213, 232, 255, 214, 214, 233, 255, 214, 214, 233, 255, 214, 214, 233, 255, 214, 214, 233, 255, 214, 215, 233, 255, 215, 215, 233, 255, 215, 215, 233, 255, 215, 215, 233, 255, 215, 215, 233, 255, 216, 216, 234, 255, 216, 216, 234, 255, 216, 216, 234, 255, 216, 216, 234, 255, 217, 217, 234, 255, 217, 217, 234, 255, 217, 217, 234, 255, 217, 217, 234, 255, 217, 218, 234, 255, 218, 218, 235, 255, 218, 218, 235, 255, 218, 218, 235, 255, 218, 218, 235, 255, 218, 218, 235, 255, 219, 218, 235, 255, 219, 219, 235, 255, 219, 219, 235, 255, 219, 219, 235, 255, 219, 219, 235, 255, 219, 219, 235, 255, 220, 219, 235, 255, 220, 219, 235, 255, 220, 220, 236, 255, 220, 220, 236, 255, 220, 220, 236, 255, 220, 220, 236, 255, 221, 220, 236, 255, 221, 220, 236, 255, 221, 220, 236, 255, 221, 221, 236, 255, 221, 221, 236, 255, 222, 221, 236, 255, 222, 221, 236, 255, 222, 221, 236, 255, 222, 221, 236, 255, 222, 221, 237, 255, 222, 222, 237, 255, 223, 222, 237, 255, 223, 222, 237, 255, 223, 222, 237, 255, 223, 222, 237, 255, 223, 222, 237, 255, 223, 222, 237, 255, 224, 223, 237, 255, 224, 223, 237, 255, 224, 223, 237, 255, 224, 223, 237, 255, 224, 223, 237, 255, 224, 223, 238, 255, 225, 223, 238, 255, 225, 224, 238, 255, 225, 224, 238, 255, 225, 224, 238, 255, 225, 224, 238, 255, 225, 224, 238, 255, 226, 224, 238, 255, 226, 224, 238, 255, 226, 225, 238, 255, 226, 225, 238, 255, 226, 225, 238, 255, 226, 225, 238, 255, 227, 225, 239, 255, 227, 225, 239, 255, 227, 226, 239, 255, 227, 226, 239, 255, 227, 226, 239, 255, 227, 226, 239, 255, 228, 226, 239, 255, 228, 226, 239, 255, 228, 226, 239, 255, 228, 227, 239, 255, 228, 227, 239, 255, 228, 227, 239, 255, 229, 227, 239, 255, 229, 227, 240, 255, 229, 227, 240, 255, 229, 227, 240, 255, 229, 228, 240, 255, 229, 228, 240, 255, 230, 228, 240, 255, 230, 228, 240, 255, 230, 228, 240, 255, 230, 228, 240, 255, 230, 228, 240, 255, 230, 229, 240, 255, 231, 229, 240, 255, 231, 229, 240, 255, 231, 229, 241, 255, 231, 229, 241, 255, 231, 229, 241, 255, 231, 230, 241, 255, 231, 230, 241, 255, 232, 230, 241, 255, 232, 230, 241, 255, 232, 230, 241, 255, 232, 230, 241, 255, 232, 230, 241, 255, 232, 231, 241, 255, 233, 231, 241, 255, 233, 231, 242, 255, 233, 231, 242, 255, 233, 231, 242, 255, 233, 231, 242, 255, 233, 231, 242, 255, 234, 232, 242, 255, 234, 232, 242, 255, 234, 232, 242, 255, 234, 232, 242, 255, 234, 232, 242, 255, 234, 232, 242, 255, 235, 233, 242, 255, 235, 233, 242, 255, 235, 233, 243, 255, 235, 233, 243, 255, 235, 233, 243, 255, 235, 233, 243, 255, 235, 233, 243, 255, 236, 234, 243, 255, 236, 234, 243, 255, 236, 234, 243, 255, 236, 234, 243, 255, 236, 234, 243, 255, 236, 234, 243, 255, 237, 235, 243, 255, 237, 235, 244, 255, 237, 235, 244, 255, 237, 235, 244, 255, 237, 235, 244, 255, 237, 235, 244, 255, 237, 235, 244, 255, 238, 236, 244, 255, 238, 236, 244, 255, 238, 236, 244, 255, 238, 236, 244, 255, 238, 236, 244, 255, 238, 236, 244, 255, 238, 237, 244, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 240, 238, 245, 255, 240, 238, 245, 255, 240, 238, 245, 255, 240, 238, 245, 255, 240, 238, 245, 255, 240, 238, 245, 255, 240, 238, 245, 255, 240, 238, 246, 255, 240, 238, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 242, 240, 246, 255, 242, 240, 246, 255, 242, 240, 246, 255, 242, 240, 246, 255, 242, 240, 246, 255, 242, 240, 246, 255, 242, 240, 247, 255, 242, 240, 247, 255, 242, 240, 247, 255, 242, 240, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 244, 242, 247, 255, 244, 242, 247, 255, 244, 242, 247, 255, 244, 242, 248, 255, 244, 242, 248, 255, 244, 242, 248, 255, 244, 242, 248, 255, 244, 242, 248, 255, 244, 242, 248, 255, 244, 243, 248, 255, 245, 243, 248, 255, 245, 243, 248, 255, 245, 243, 248, 255, 245, 243, 248, 255, 245, 243, 248, 255, 245, 243, 248, 255, 245, 243, 248, 255, 245, 243, 248, 255, 245, 244, 248, 255, 245, 244, 249, 255, 246, 244, 249, 255, 246, 244, 249, 255, 246, 244, 249, 255, 246, 244, 249, 255, 246, 244, 249, 255, 246, 244, 249, 255, 246, 244, 249, 255, 246, 245, 249, 255, 246, 245, 249, 255, 246, 245, 249, 255, 247, 245, 249, 255, 247, 245, 249, 255, 247, 245, 249, 255, 247, 245, 249, 255, 247, 245, 249, 255, 247, 245, 250, 255, 247, 245, 250, 255, 247, 246, 250, 255, 247, 246, 250, 255, 247, 246, 250, 255, 248, 246, 250, 255, 248, 246, 250, 255, 248, 246, 250, 255, 248, 246, 250, 255, 248, 246, 250, 255, 248, 246, 250, 255, 248, 247, 250, 255, 248, 247, 250, 255, 248, 247, 250, 255, 248, 247, 250, 255, 249, 247, 250, 255, 249, 247, 251, 255, 249, 247, 251, 255, 249, 247, 251, 255, 249, 247, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 250, 248, 251, 255, 250, 248, 251, 255, 250, 248, 251, 255, 250, 248, 251, 255, 250, 249, 251, 255, 250, 249, 251, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 251, 249, 252, 255, 251, 249, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Purples_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 63, 0, 125, 0, 63, 0, 125, 7, 63, 0, 125, 14, 63, 0, 125, 22, 63, 1, 125, 29, 63, 1, 125, 37, 63, 1, 125, 44, 63, 1, 125, 52, 64, 2, 125, 59, 64, 2, 126, 67, 64, 2, 126, 74, 64, 3, 126, 82, 64, 3, 126, 89, 64, 3, 126, 97, 64, 4, 126, 104, 65, 4, 126, 112, 65, 4, 126, 119, 65, 4, 126, 127, 65, 5, 127, 134, 65, 5, 127, 141, 65, 5, 127, 149, 65, 6, 127, 156, 65, 6, 127, 164, 66, 6, 127, 171, 66, 7, 127, 179, 66, 7, 127, 186, 66, 7, 127, 194, 66, 8, 128, 201, 66, 8, 128, 209, 66, 8, 128, 216, 67, 9, 128, 224, 67, 9, 128, 231, 67, 9, 128, 239, 67, 10, 128, 246, 67, 10, 128, 254, 67, 10, 128, 255, 67, 10, 129, 255, 67, 11, 129, 255, 68, 11, 129, 255, 68, 11, 129, 255, 68, 12, 129, 255, 68, 12, 129, 255, 68, 12, 129, 255, 68, 12, 129, 255, 68, 13, 129, 255, 68, 13, 130, 255, 69, 13, 130, 255, 69, 13, 130, 255, 69, 14, 130, 255, 69, 14, 130, 255, 69, 14, 130, 255, 69, 14, 130, 255, 69, 15, 130, 255, 70, 15, 130, 255, 70, 15, 131, 255, 70, 15, 131, 255, 70, 16, 131, 255, 70, 16, 131, 255, 70, 16, 131, 255, 70, 16, 131, 255, 70, 17, 131, 255, 71, 17, 131, 255, 71, 17, 132, 255, 71, 17, 132, 255, 75, 25, 135, 255, 75, 26, 135, 255, 75, 26, 136, 255, 76, 26, 136, 255, 76, 26, 136, 255, 76, 26, 136, 255, 76, 27, 136, 255, 76, 27, 136, 255, 76, 27, 136, 255, 76, 27, 136, 255, 76, 28, 136, 255, 77, 28, 137, 255, 77, 28, 137, 255, 77, 28, 137, 255, 77, 28, 137, 255, 77, 29, 137, 255, 77, 29, 137, 255, 77, 29, 137, 255, 78, 29, 137, 255, 78, 30, 137, 255, 78, 30, 138, 255, 78, 30, 138, 255, 78, 30, 138, 255, 78, 30, 138, 255, 78, 31, 138, 255, 78, 31, 138, 255, 79, 31, 138, 255, 79, 31, 138, 255, 79, 31, 138, 255, 79, 32, 139, 255, 79, 32, 139, 255, 79, 32, 139, 255, 79, 32, 139, 255, 79, 32, 139, 255, 80, 33, 139, 255, 80, 33, 139, 255, 80, 33, 139, 255, 80, 33, 139, 255, 80, 33, 140, 255, 80, 34, 140, 255, 80, 34, 140, 255, 81, 34, 140, 255, 81, 34, 140, 255, 81, 34, 140, 255, 81, 35, 140, 255, 81, 35, 140, 255, 81, 35, 140, 255, 81, 35, 141, 255, 81, 35, 141, 255, 82, 36, 141, 255, 82, 36, 141, 255, 82, 36, 141, 255, 82, 36, 141, 255, 82, 36, 141, 255, 82, 37, 141, 255, 82, 37, 141, 255, 82, 37, 142, 255, 83, 37, 142, 255, 83, 37, 142, 255, 83, 38, 142, 255, 83, 38, 142, 255, 83, 38, 142, 255, 83, 38, 142, 255, 83, 38, 142, 255, 83, 39, 143, 255, 84, 39, 143, 255, 84, 39, 143, 255, 84, 39, 143, 255, 84, 40, 143, 255, 84, 40, 143, 255, 84, 40, 143, 255, 84, 41, 143, 255, 85, 41, 144, 255, 85, 41, 144, 255, 85, 41, 144, 255, 85, 42, 144, 255, 85, 42, 144, 255, 85, 42, 144, 255, 85, 43, 144, 255, 85, 43, 145, 255, 86, 43, 145, 255, 86, 43, 145, 255, 86, 44, 145, 255, 86, 44, 145, 255, 86, 44, 145, 255, 86, 45, 145, 255, 86, 45, 145, 255, 86, 45, 146, 255, 87, 45, 146, 255, 87, 46, 146, 255, 87, 46, 146, 255, 87, 46, 146, 255, 87, 46, 146, 255, 87, 47, 146, 255, 87, 47, 146, 255, 88, 47, 147, 255, 88, 48, 147, 255, 88, 48, 147, 255, 88, 48, 147, 255, 88, 48, 147, 255, 88, 49, 147, 255, 88, 49, 147, 255, 88, 49, 148, 255, 89, 49, 148, 255, 89, 50, 148, 255, 89, 50, 148, 255, 89, 50, 148, 255, 89, 51, 148, 255, 89, 51, 148, 255, 89, 51, 148, 255, 90, 51, 149, 255, 90, 52, 149, 255, 90, 52, 149, 255, 90, 52, 149, 255, 90, 52, 149, 255, 90, 53, 149, 255, 90, 53, 149, 255, 90, 53, 149, 255, 91, 53, 150, 255, 91, 54, 150, 255, 91, 54, 150, 255, 91, 54, 150, 255, 91, 54, 150, 255, 91, 55, 150, 255, 91, 55, 150, 255, 92, 55, 150, 255, 92, 56, 151, 255, 92, 56, 151, 255, 96, 64, 155, 255, 97, 65, 155, 255, 97, 65, 155, 255, 97, 65, 155, 255, 97, 65, 155, 255, 97, 66, 155, 255, 97, 66, 156, 255, 97, 66, 156, 255, 98, 66, 156, 255, 98, 67, 156, 255, 98, 67, 156, 255, 98, 67, 156, 255, 98, 68, 156, 255, 98, 68, 156, 255, 98, 68, 157, 255, 98, 68, 157, 255, 99, 69, 157, 255, 99, 69, 157, 255, 99, 69, 157, 255, 99, 69, 157, 255, 99, 70, 157, 255, 99, 70, 157, 255, 99, 70, 158, 255, 100, 70, 158, 255, 100, 71, 158, 255, 100, 71, 158, 255, 100, 71, 158, 255, 100, 71, 158, 255, 100, 72, 158, 255, 100, 72, 158, 255, 101, 72, 159, 255, 101, 72, 159, 255, 101, 73, 159, 255, 101, 73, 159, 255, 101, 73, 159, 255, 101, 73, 159, 255, 101, 74, 159, 255, 102, 74, 159, 255, 102, 74, 159, 255, 102, 74, 160, 255, 102, 75, 160, 255, 102, 75, 160, 255, 102, 75, 160, 255, 102, 75, 160, 255, 103, 76, 160, 255, 103, 76, 160, 255, 103, 76, 160, 255, 103, 76, 161, 255, 103, 77, 161, 255, 103, 77, 161, 255, 103, 77, 161, 255, 104, 77, 161, 255, 104, 78, 161, 255, 104, 78, 161, 255, 104, 78, 161, 255, 104, 78, 161, 255, 104, 79, 162, 255, 104, 79, 162, 255, 105, 79, 162, 255, 105, 79, 162, 255, 105, 80, 162, 255, 105, 80, 162, 255, 105, 80, 162, 255, 105, 80, 162, 255, 105, 81, 163, 255, 106, 81, 163, 255, 106, 81, 163, 255, 106, 81, 163, 255, 106, 82, 163, 255, 106, 82, 163, 255, 106, 82, 163, 255, 106, 82, 164, 255, 106, 83, 164, 255, 106, 83, 164, 255, 107, 83, 164, 255, 107, 84, 164, 255, 107, 84, 164, 255, 107, 84, 165, 255, 107, 84, 165, 255, 107, 85, 165, 255, 107, 85, 165, 255, 107, 85, 165, 255, 108, 86, 165, 255, 108, 86, 166, 255, 108, 86, 166, 255, 108, 86, 166, 255, 108, 87, 166, 255, 108, 87, 166, 255, 108, 87, 166, 255, 108, 88, 166, 255, 108, 88, 167, 255, 109, 88, 167, 255, 109, 88, 167, 255, 109, 89, 167, 255, 109, 89, 167, 255, 109, 89, 167, 255, 109, 90, 168, 255, 109, 90, 168, 255, 109, 90, 168, 255, 110, 90, 168, 255, 110, 91, 168, 255, 110, 91, 168, 255, 110, 91, 168, 255, 110, 91, 169, 255, 110, 92, 169, 255, 110, 92, 169, 255, 110, 92, 169, 255, 111, 93, 169, 255, 111, 93, 169, 255, 111, 93, 170, 255, 111, 93, 170, 255, 111, 94, 170, 255, 111, 94, 170, 255, 111, 94, 170, 255, 111, 95, 170, 255, 112, 95, 170, 255, 112, 95, 171, 255, 112, 95, 171, 255, 112, 96, 171, 255, 112, 96, 171, 255, 112, 96, 171, 255, 112, 96, 171, 255, 112, 97, 171, 255, 113, 97, 172, 255, 113, 97, 172, 255, 113, 98, 172, 255, 113, 98, 172, 255, 113, 98, 172, 255, 118, 107, 177, 255, 118, 107, 177, 255, 118, 108, 177, 255, 118, 108, 177, 255, 118, 108, 177, 255, 118, 109, 178, 255, 119, 109, 178, 255, 119, 109, 178, 255, 119, 109, 178, 255, 119, 110, 178, 255, 119, 110, 178, 255, 119, 110, 178, 255, 119, 110, 179, 255, 120, 111, 179, 255, 120, 111, 179, 255, 120, 111, 179, 255, 120, 112, 179, 255, 120, 112, 179, 255, 120, 112, 179, 255, 120, 112, 180, 255, 121, 113, 180, 255, 121, 113, 180, 255, 121, 113, 180, 255, 121, 113, 180, 255, 121, 114, 180, 255, 121, 114, 180, 255, 121, 114, 181, 255, 122, 115, 181, 255, 122, 115, 181, 255, 122, 115, 181, 255, 122, 115, 181, 255, 122, 116, 181, 255, 122, 116, 181, 255, 122, 116, 181, 255, 123, 116, 182, 255, 123, 117, 182, 255, 123, 117, 182, 255, 123, 117, 182, 255, 123, 118, 182, 255, 123, 118, 182, 255, 124, 118, 182, 255, 124, 118, 183, 255, 124, 119, 183, 255, 124, 119, 183, 255, 124, 119, 183, 255, 124, 119, 183, 255, 125, 120, 183, 255, 125, 120, 183, 255, 125, 120, 183, 255, 125, 120, 184, 255, 125, 121, 184, 255, 125, 121, 184, 255, 125, 121, 184, 255, 126, 122, 184, 255, 126, 122, 184, 255, 126, 122, 184, 255, 126, 122, 184, 255, 126, 123, 185, 255, 126, 123, 185, 255, 127, 123, 185, 255, 127, 123, 185, 255, 127, 124, 185, 255, 127, 124, 185, 255, 127, 124, 185, 255, 127, 125, 186, 255, 128, 125, 186, 255, 128, 125, 186, 255, 128, 125, 186, 255, 128, 125, 186, 255, 128, 125, 186, 255, 129, 126, 186, 255, 129, 126, 186, 255, 129, 126, 186, 255, 129, 126, 186, 255, 129, 126, 186, 255, 130, 126, 186, 255, 130, 127, 187, 255, 130, 127, 187, 255, 130, 127, 187, 255, 130, 127, 187, 255, 131, 127, 187, 255, 131, 128, 187, 255, 131, 128, 187, 255, 131, 128, 187, 255, 131, 128, 187, 255, 131, 128, 187, 255, 132, 128, 187, 255, 132, 129, 188, 255, 132, 129, 188, 255, 132, 129, 188, 255, 132, 129, 188, 255, 133, 129, 188, 255, 133, 129, 188, 255, 133, 130, 188, 255, 133, 130, 188, 255, 133, 130, 188, 255, 134, 130, 188, 255, 134, 130, 188, 255, 134, 131, 188, 255, 134, 131, 189, 255, 134, 131, 189, 255, 135, 131, 189, 255, 135, 131, 189, 255, 135, 131, 189, 255, 135, 132, 189, 255, 135, 132, 189, 255, 135, 132, 189, 255, 136, 132, 189, 255, 136, 132, 189, 255, 136, 133, 189, 255, 136, 133, 190, 255, 136, 133, 190, 255, 137, 133, 190, 255, 137, 133, 190, 255, 137, 133, 190, 255, 137, 134, 190, 255, 137, 134, 190, 255, 138, 134, 190, 255, 138, 134, 190, 255, 138, 134, 190, 255, 138, 135, 190, 255, 138, 135, 190, 255, 138, 135, 191, 255, 139, 135, 191, 255, 139, 135, 191, 255, 139, 135, 191, 255, 139, 136, 191, 255, 139, 136, 191, 255, 146, 142, 194, 255, 146, 142, 194, 255, 146, 142, 194, 255, 146, 142, 194, 255, 146, 143, 194, 255, 147, 143, 194, 255, 147, 143, 194, 255, 147, 143, 195, 255, 147, 143, 195, 255, 147, 143, 195, 255, 147, 144, 195, 255, 148, 144, 195, 255, 148, 144, 195, 255, 148, 144, 195, 255, 148, 144, 195, 255, 148, 145, 195, 255, 149, 145, 195, 255, 149, 145, 195, 255, 149, 145, 195, 255, 149, 145, 196, 255, 149, 145, 196, 255, 150, 146, 196, 255, 150, 146, 196, 255, 150, 146, 196, 255, 150, 146, 196, 255, 150, 146, 196, 255, 150, 147, 196, 255, 151, 147, 196, 255, 151, 147, 196, 255, 151, 147, 196, 255, 151, 147, 197, 255, 151, 147, 197, 255, 152, 148, 197, 255, 152, 148, 197, 255, 152, 148, 197, 255, 152, 148, 197, 255, 152, 148, 197, 255, 152, 149, 197, 255, 153, 149, 197, 255, 153, 149, 197, 255, 153, 149, 197, 255, 153, 149, 197, 255, 153, 149, 198, 255, 154, 150, 198, 255, 154, 150, 198, 255, 154, 150, 198, 255, 154, 150, 198, 255, 154, 150, 198, 255, 155, 151, 198, 255, 155, 151, 198, 255, 155, 151, 198, 255, 155, 151, 198, 255, 155, 151, 198, 255, 155, 151, 199, 255, 156, 152, 199, 255, 156, 152, 199, 255, 156, 152, 199, 255, 156, 152, 199, 255, 156, 152, 199, 255, 157, 153, 199, 255, 157, 153, 199, 255, 157, 153, 199, 255, 157, 153, 199, 255, 157, 153, 199, 255, 157, 154, 199, 255, 158, 154, 200, 255, 158, 154, 200, 255, 158, 154, 200, 255, 158, 154, 200, 255, 158, 155, 200, 255, 159, 155, 200, 255, 159, 155, 200, 255, 159, 155, 201, 255, 159, 155, 201, 255, 159, 156, 201, 255, 159, 156, 201, 255, 160, 156, 201, 255, 160, 156, 201, 255, 160, 157, 201, 255, 160, 157, 201, 255, 160, 157, 202, 255, 161, 157, 202, 255, 161, 157, 202, 255, 161, 158, 202, 255, 161, 158, 202, 255, 161, 158, 202, 255, 161, 158, 202, 255, 162, 159, 202, 255, 162, 159, 203, 255, 162, 159, 203, 255, 162, 159, 203, 255, 162, 159, 203, 255, 162, 160, 203, 255, 163, 160, 203, 255, 163, 160, 203, 255, 163, 160, 203, 255, 163, 160, 204, 255, 163, 161, 204, 255, 164, 161, 204, 255, 164, 161, 204, 255, 164, 161, 204, 255, 164, 162, 204, 255, 164, 162, 204, 255, 164, 162, 204, 255, 165, 162, 205, 255, 165, 162, 205, 255, 165, 163, 205, 255, 165, 163, 205, 255, 165, 163, 205, 255, 166, 163, 205, 255, 166, 164, 205, 255, 166, 164, 206, 255, 166, 164, 206, 255, 166, 164, 206, 255, 166, 164, 206, 255, 167, 165, 206, 255, 167, 165, 206, 255, 167, 165, 206, 255, 167, 165, 206, 255, 167, 166, 207, 255, 168, 166, 207, 255, 168, 166, 207, 255, 168, 166, 207, 255, 168, 166, 207, 255, 168, 167, 207, 255, 169, 167, 207, 255, 169, 167, 207, 255, 169, 167, 208, 255, 175, 174, 212, 255, 175, 175, 212, 255, 175, 175, 212, 255, 176, 175, 212, 255, 176, 175, 212, 255, 176, 176, 212, 255, 176, 176, 212, 255, 176, 176, 213, 255, 177, 176, 213, 255, 177, 176, 213, 255, 177, 177, 213, 255, 177, 177, 213, 255, 177, 177, 213, 255, 178, 177, 213, 255, 178, 178, 213, 255, 178, 178, 214, 255, 178, 178, 214, 255, 178, 178, 214, 255, 179, 178, 214, 255, 179, 179, 214, 255, 179, 179, 214, 255, 179, 179, 214, 255, 179, 179, 214, 255, 179, 180, 214, 255, 180, 180, 215, 255, 180, 180, 215, 255, 180, 180, 215, 255, 180, 180, 215, 255, 180, 181, 215, 255, 181, 181, 215, 255, 181, 181, 215, 255, 181, 181, 215, 255, 181, 181, 216, 255, 181, 182, 216, 255, 182, 182, 216, 255, 182, 182, 216, 255, 182, 182, 216, 255, 182, 183, 216, 255, 182, 183, 216, 255, 183, 183, 216, 255, 183, 183, 217, 255, 183, 183, 217, 255, 183, 184, 217, 255, 183, 184, 217, 255, 184, 184, 217, 255, 184, 184, 217, 255, 184, 185, 217, 255, 184, 185, 217, 255, 184, 185, 218, 255, 185, 185, 218, 255, 185, 185, 218, 255, 185, 186, 218, 255, 185, 186, 218, 255, 185, 186, 218, 255, 186, 186, 218, 255, 186, 187, 218, 255, 186, 187, 219, 255, 186, 187, 219, 255, 186, 187, 219, 255, 187, 187, 219, 255, 187, 188, 219, 255, 187, 188, 219, 255, 187, 188, 219, 255, 187, 188, 219, 255, 187, 189, 219, 255, 188, 189, 220, 255, 188, 189, 220, 255, 188, 189, 220, 255, 188, 189, 220, 255, 188, 189, 220, 255, 189, 190, 220, 255, 189, 190, 220, 255, 189, 190, 220, 255, 189, 190, 220, 255, 189, 190, 220, 255, 190, 190, 221, 255, 190, 191, 221, 255, 190, 191, 221, 255, 190, 191, 221, 255, 190, 191, 221, 255, 191, 191, 221, 255, 191, 192, 221, 255, 191, 192, 221, 255, 191, 192, 221, 255, 191, 192, 221, 255, 191, 192, 221, 255, 192, 192, 222, 255, 192, 193, 222, 255, 192, 193, 222, 255, 192, 193, 222, 255, 192, 193, 222, 255, 193, 193, 222, 255, 193, 194, 222, 255, 193, 194, 222, 255, 193, 194, 222, 255, 193, 194, 222, 255, 194, 194, 222, 255, 194, 194, 223, 255, 194, 195, 223, 255, 194, 195, 223, 255, 194, 195, 223, 255, 194, 195, 223, 255, 195, 195, 223, 255, 195, 195, 223, 255, 195, 196, 223, 255, 195, 196, 223, 255, 195, 196, 223, 255, 196, 196, 224, 255, 196, 196, 224, 255, 196, 197, 224, 255, 196, 197, 224, 255, 196, 197, 224, 255, 197, 197, 224, 255, 197, 197, 224, 255, 197, 197, 224, 255, 197, 198, 224, 255, 197, 198, 224, 255, 197, 198, 224, 255, 198, 198, 225, 255, 198, 198, 225, 255, 198, 199, 225, 255, 198, 199, 225, 255, 198, 199, 225, 255, 199, 199, 225, 255, 199, 199, 225, 255, 199, 199, 225, 255, 199, 200, 225, 255, 199, 200, 225, 255, 206, 206, 228, 255, 206, 206, 229, 255, 206, 206, 229, 255, 206, 206, 229, 255, 206, 207, 229, 255, 206, 207, 229, 255, 207, 207, 229, 255, 207, 207, 229, 255, 207, 207, 229, 255, 207, 207, 229, 255, 207, 208, 229, 255, 208, 208, 230, 255, 208, 208, 230, 255, 208, 208, 230, 255, 208, 208, 230, 255, 208, 209, 230, 255, 209, 209, 230, 255, 209, 209, 230, 255, 209, 209, 230, 255, 209, 209, 230, 255, 209, 209, 230, 255, 209, 210, 230, 255, 210, 210, 231, 255, 210, 210, 231, 255, 210, 210, 231, 255, 210, 210, 231, 255, 210, 211, 231, 255, 211, 211, 231, 255, 211, 211, 231, 255, 211, 211, 231, 255, 211, 211, 231, 255, 211, 211, 231, 255, 212, 212, 231, 255, 212, 212, 232, 255, 212, 212, 232, 255, 212, 212, 232, 255, 212, 212, 232, 255, 212, 213, 232, 255, 213, 213, 232, 255, 213, 213, 232, 255, 213, 213, 232, 255, 213, 213, 232, 255, 213, 213, 232, 255, 214, 214, 233, 255, 214, 214, 233, 255, 214, 214, 233, 255, 214, 214, 233, 255, 214, 214, 233, 255, 215, 215, 233, 255, 215, 215, 233, 255, 215, 215, 233, 255, 215, 215, 233, 255, 215, 215, 233, 255, 215, 215, 233, 255, 216, 216, 234, 255, 216, 216, 234, 255, 216, 216, 234, 255, 216, 216, 234, 255, 216, 216, 234, 255, 217, 217, 234, 255, 217, 217, 234, 255, 217, 217, 234, 255, 217, 217, 234, 255, 217, 217, 234, 255, 217, 218, 234, 255, 218, 218, 235, 255, 218, 218, 235, 255, 218, 218, 235, 255, 218, 218, 235, 255, 218, 218, 235, 255, 218, 218, 235, 255, 218, 218, 235, 255, 219, 218, 235, 255, 219, 219, 235, 255, 219, 219, 235, 255, 219, 219, 235, 255, 219, 219, 235, 255, 219, 219, 235, 255, 219, 219, 235, 255, 220, 219, 235, 255, 220, 219, 235, 255, 220, 219, 236, 255, 220, 220, 236, 255, 220, 220, 236, 255, 220, 220, 236, 255, 220, 220, 236, 255, 221, 220, 236, 255, 221, 220, 236, 255, 221, 220, 236, 255, 221, 220, 236, 255, 221, 221, 236, 255, 221, 221, 236, 255, 221, 221, 236, 255, 222, 221, 236, 255, 222, 221, 236, 255, 222, 221, 236, 255, 222, 221, 236, 255, 222, 221, 236, 255, 222, 221, 237, 255, 222, 222, 237, 255, 222, 222, 237, 255, 223, 222, 237, 255, 223, 222, 237, 255, 223, 222, 237, 255, 223, 222, 237, 255, 223, 222, 237, 255, 223, 222, 237, 255, 223, 222, 237, 255, 224, 223, 237, 255, 224, 223, 237, 255, 224, 223, 237, 255, 224, 223, 237, 255, 224, 223, 237, 255, 224, 223, 237, 255, 224, 223, 238, 255, 225, 223, 238, 255, 225, 224, 238, 255, 225, 224, 238, 255, 225, 224, 238, 255, 225, 224, 238, 255, 225, 224, 238, 255, 225, 224, 238, 255, 225, 224, 238, 255, 226, 224, 238, 255, 226, 225, 238, 255, 226, 225, 238, 255, 226, 225, 238, 255, 226, 225, 238, 255, 230, 229, 240, 255, 231, 229, 240, 255, 231, 229, 241, 255, 231, 229, 241, 255, 231, 229, 241, 255, 231, 229, 241, 255, 231, 229, 241, 255, 231, 230, 241, 255, 231, 230, 241, 255, 232, 230, 241, 255, 232, 230, 241, 255, 232, 230, 241, 255, 232, 230, 241, 255, 232, 230, 241, 255, 232, 230, 241, 255, 232, 231, 241, 255, 233, 231, 241, 255, 233, 231, 241, 255, 233, 231, 242, 255, 233, 231, 242, 255, 233, 231, 242, 255, 233, 231, 242, 255, 233, 231, 242, 255, 233, 232, 242, 255, 234, 232, 242, 255, 234, 232, 242, 255, 234, 232, 242, 255, 234, 232, 242, 255, 234, 232, 242, 255, 234, 232, 242, 255, 234, 232, 242, 255, 234, 232, 242, 255, 235, 233, 242, 255, 235, 233, 242, 255, 235, 233, 243, 255, 235, 233, 243, 255, 235, 233, 243, 255, 235, 233, 243, 255, 235, 233, 243, 255, 235, 233, 243, 255, 236, 234, 243, 255, 236, 234, 243, 255, 236, 234, 243, 255, 236, 234, 243, 255, 236, 234, 243, 255, 236, 234, 243, 255, 236, 234, 243, 255, 236, 234, 243, 255, 237, 235, 243, 255, 237, 235, 244, 255, 237, 235, 244, 255, 237, 235, 244, 255, 237, 235, 244, 255, 237, 235, 244, 255, 237, 235, 244, 255, 237, 235, 244, 255, 238, 236, 244, 255, 238, 236, 244, 255, 238, 236, 244, 255, 238, 236, 244, 255, 238, 236, 244, 255, 238, 236, 244, 255, 238, 236, 244, 255, 238, 236, 244, 255, 238, 237, 244, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 240, 238, 245, 255, 240, 238, 245, 255, 240, 238, 245, 255, 240, 238, 245, 255, 240, 238, 245, 255, 240, 238, 245, 255, 240, 238, 245, 255, 240, 238, 245, 255, 240, 238, 245, 255, 240, 238, 246, 255, 240, 238, 246, 255, 240, 238, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 242, 240, 246, 255, 242, 240, 246, 255, 242, 240, 246, 255, 242, 240, 246, 255, 242, 240, 246, 255, 242, 240, 246, 255, 242, 240, 246, 255, 242, 240, 247, 255, 242, 240, 247, 255, 242, 240, 247, 255, 242, 240, 247, 255, 242, 240, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 242, 247, 255, 244, 242, 247, 255, 244, 242, 247, 255, 244, 242, 247, 255, 244, 242, 248, 255, 244, 242, 248, 255, 247, 245, 249, 255, 247, 245, 249, 255, 247, 245, 249, 255, 247, 245, 249, 255, 247, 245, 249, 255, 247, 245, 249, 255, 247, 245, 250, 255, 247, 245, 250, 255, 247, 246, 250, 255, 247, 246, 250, 255, 247, 246, 250, 255, 247, 246, 250, 255, 247, 246, 250, 255, 248, 246, 250, 255, 248, 246, 250, 255, 248, 246, 250, 255, 248, 246, 250, 255, 248, 246, 250, 255, 248, 246, 250, 255, 248, 246, 250, 255, 248, 247, 250, 255, 248, 247, 250, 255, 248, 247, 250, 255, 248, 247, 250, 255, 248, 247, 250, 255, 249, 247, 250, 255, 249, 247, 251, 255, 249, 247, 251, 255, 249, 247, 251, 255, 249, 247, 251, 255, 249, 247, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 250, 248, 251, 255, 250, 248, 251, 255, 250, 248, 251, 255, 250, 248, 251, 255, 250, 249, 251, 255, 250, 249, 251, 255, 250, 249, 251, 255, 250, 249, 251, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 251, 249, 252, 255, 251, 249, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Purples_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 63, 0, 125, 0, 64, 2, 126, 24, 65, 5, 127, 49, 66, 9, 128, 74, 68, 11, 129, 99, 69, 14, 130, 124, 70, 16, 131, 149, 76, 26, 136, 174, 77, 28, 137, 199, 78, 30, 138, 224, 79, 32, 139, 249, 80, 34, 140, 255, 82, 36, 141, 255, 83, 38, 142, 255, 84, 40, 143, 255, 85, 42, 144, 255, 86, 45, 145, 255, 87, 47, 146, 255, 89, 49, 148, 255, 90, 52, 149, 255, 91, 54, 150, 255, 92, 56, 151, 255, 97, 66, 156, 255, 99, 69, 157, 255, 100, 71, 158, 255, 101, 73, 159, 255, 102, 75, 160, 255, 103, 77, 161, 255, 104, 79, 162, 255, 105, 80, 162, 255, 106, 83, 164, 255, 107, 85, 165, 255, 108, 87, 166, 255, 109, 89, 167, 255, 110, 91, 168, 255, 111, 93, 170, 255, 112, 95, 171, 255, 113, 97, 172, 255, 118, 108, 177, 255, 119, 110, 178, 255, 120, 112, 179, 255, 121, 114, 180, 255, 122, 115, 181, 255, 123, 117, 182, 255, 124, 119, 183, 255, 125, 121, 184, 255, 126, 123, 185, 255, 127, 124, 185, 255, 129, 126, 186, 255, 130, 127, 187, 255, 131, 128, 187, 255, 132, 129, 188, 255, 134, 130, 188, 255, 135, 131, 189, 255, 136, 132, 189, 255, 137, 134, 190, 255, 138, 135, 190, 255, 139, 136, 191, 255, 146, 143, 194, 255, 148, 144, 195, 255, 149, 145, 195, 255, 150, 146, 196, 255, 151, 147, 196, 255, 152, 148, 197, 255, 153, 149, 197, 255, 154, 150, 198, 255, 155, 151, 198, 255, 156, 152, 199, 255, 157, 153, 199, 255, 158, 154, 200, 255, 159, 155, 200, 255, 160, 156, 201, 255, 161, 157, 202, 255, 162, 159, 202, 255, 163, 160, 203, 255, 163, 161, 204, 255, 164, 162, 204, 255, 165, 163, 205, 255, 166, 164, 206, 255, 167, 165, 206, 255, 168, 166, 207, 255, 169, 167, 207, 255, 176, 175, 212, 255, 177, 176, 213, 255, 178, 177, 213, 255, 178, 178, 214, 255, 179, 179, 214, 255, 180, 180, 215, 255, 181, 181, 215, 255, 182, 182, 216, 255, 183, 183, 217, 255, 184, 184, 217, 255, 184, 185, 218, 255, 185, 186, 218, 255, 186, 187, 219, 255, 187, 188, 219, 255, 188, 189, 220, 255, 189, 189, 220, 255, 189, 190, 220, 255, 190, 191, 221, 255, 191, 192, 221, 255, 192, 192, 222, 255, 192, 193, 222, 255, 193, 194, 222, 255, 194, 194, 223, 255, 194, 195, 223, 255, 195, 196, 223, 255, 196, 196, 224, 255, 197, 197, 224, 255, 197, 198, 224, 255, 198, 198, 225, 255, 199, 199, 225, 255, 199, 200, 225, 255, 206, 206, 229, 255, 207, 207, 229, 255, 207, 207, 229, 255, 208, 208, 230, 255, 208, 209, 230, 255, 209, 209, 230, 255, 210, 210, 231, 255, 210, 210, 231, 255, 211, 211, 231, 255, 212, 212, 231, 255, 212, 212, 232, 255, 213, 213, 232, 255, 213, 213, 232, 255, 214, 214, 233, 255, 214, 214, 233, 255, 215, 215, 233, 255, 216, 216, 234, 255, 216, 216, 234, 255, 217, 217, 234, 255, 217, 217, 234, 255, 218, 218, 235, 255, 218, 218, 235, 255, 218, 218, 235, 255, 219, 219, 235, 255, 219, 219, 235, 255, 220, 219, 235, 255, 220, 220, 236, 255, 220, 220, 236, 255, 221, 220, 236, 255, 221, 220, 236, 255, 221, 221, 236, 255, 222, 221, 236, 255, 222, 221, 237, 255, 223, 222, 237, 255, 223, 222, 237, 255, 223, 222, 237, 255, 224, 223, 237, 255, 224, 223, 237, 255, 224, 223, 237, 255, 224, 223, 238, 255, 225, 224, 238, 255, 225, 224, 238, 255, 225, 224, 238, 255, 226, 224, 238, 255, 226, 225, 238, 255, 230, 229, 240, 255, 231, 229, 241, 255, 231, 229, 241, 255, 231, 230, 241, 255, 232, 230, 241, 255, 232, 230, 241, 255, 232, 230, 241, 255, 232, 231, 241, 255, 233, 231, 241, 255, 233, 231, 242, 255, 233, 231, 242, 255, 233, 232, 242, 255, 234, 232, 242, 255, 234, 232, 242, 255, 234, 232, 242, 255, 234, 232, 242, 255, 235, 233, 242, 255, 235, 233, 243, 255, 235, 233, 243, 255, 235, 233, 243, 255, 236, 234, 243, 255, 236, 234, 243, 255, 236, 234, 243, 255, 236, 234, 243, 255, 236, 234, 243, 255, 237, 235, 244, 255, 237, 235, 244, 255, 237, 235, 244, 255, 237, 235, 244, 255, 237, 235, 244, 255, 238, 236, 244, 255, 238, 236, 244, 255, 238, 236, 244, 255, 238, 236, 244, 255, 238, 236, 244, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 239, 237, 245, 255, 240, 238, 245, 255, 240, 238, 245, 255, 240, 238, 245, 255, 240, 238, 245, 255, 240, 238, 245, 255, 240, 238, 245, 255, 240, 238, 245, 255, 240, 238, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 241, 239, 246, 255, 242, 240, 246, 255, 242, 240, 246, 255, 242, 240, 246, 255, 242, 240, 246, 255, 242, 240, 246, 255, 242, 240, 246, 255, 242, 240, 247, 255, 242, 240, 247, 255, 242, 240, 247, 255, 242, 240, 247, 255, 242, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 241, 247, 255, 243, 242, 247, 255, 243, 242, 247, 255, 244, 242, 247, 255, 244, 242, 247, 255, 244, 242, 247, 255, 244, 242, 248, 255, 244, 242, 248, 255, 247, 245, 249, 255, 247, 245, 249, 255, 247, 245, 249, 255, 247, 245, 249, 255, 247, 245, 249, 255, 247, 245, 249, 255, 247, 245, 249, 255, 247, 245, 249, 255, 247, 245, 250, 255, 247, 245, 250, 255, 247, 246, 250, 255, 247, 246, 250, 255, 247, 246, 250, 255, 247, 246, 250, 255, 247, 246, 250, 255, 247, 246, 250, 255, 247, 246, 250, 255, 248, 246, 250, 255, 248, 246, 250, 255, 248, 246, 250, 255, 248, 246, 250, 255, 248, 246, 250, 255, 248, 246, 250, 255, 248, 246, 250, 255, 248, 246, 250, 255, 248, 246, 250, 255, 248, 246, 250, 255, 248, 247, 250, 255, 248, 247, 250, 255, 248, 247, 250, 255, 248, 247, 250, 255, 248, 247, 250, 255, 248, 247, 250, 255, 248, 247, 250, 255, 248, 247, 250, 255, 248, 247, 250, 255, 248, 247, 250, 255, 248, 247, 250, 255, 249, 247, 250, 255, 249, 247, 251, 255, 249, 247, 251, 255, 249, 247, 251, 255, 249, 247, 251, 255, 249, 247, 251, 255, 249, 247, 251, 255, 249, 247, 251, 255, 249, 247, 251, 255, 249, 247, 251, 255, 249, 247, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 249, 248, 251, 255, 250, 248, 251, 255, 250, 248, 251, 255, 250, 248, 251, 255, 250, 248, 251, 255, 250, 248, 251, 255, 250, 248, 251, 255, 250, 248, 251, 255, 250, 248, 251, 255, 250, 248, 251, 255, 250, 248, 251, 255, 250, 248, 251, 255, 250, 248, 251, 255, 250, 249, 251, 255, 250, 249, 251, 255, 250, 249, 251, 255, 250, 249, 251, 255, 250, 249, 251, 255, 250, 249, 251, 255, 250, 249, 251, 255, 250, 249, 251, 255, 250, 249, 251, 255, 250, 249, 251, 255, 250, 249, 251, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 250, 249, 252, 255, 251, 249, 252, 255, 251, 249, 252, 255, 251, 249, 252, 255, 251, 249, 252, 255, 251, 249, 252, 255, 251, 249, 252, 255, 251, 249, 252, 255, 251, 249, 252, 255, 251, 249, 252, 255, 251, 249, 252, 255, 251, 249, 252, 255, 251, 249, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 250, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255, 251, 251, 252, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Purples_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
