/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/BuGn.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 0, 68, 27, 255, 0, 109, 44, 255, 35, 139, 69, 255, 65, 174, 118, 255, 102, 194, 164, 255, 153, 216, 201, 255, 204, 236, 230, 255, 229, 245, 249, 255, 247, 252, 253, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_BuGn_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 0, 68, 26, 0, 0, 68, 27, 7, 0, 68, 27, 14, 0, 68, 27, 22, 0, 69, 27, 29, 0, 69, 27, 37, 0, 69, 27, 44, 0, 70, 27, 52, 0, 70, 28, 59, 0, 70, 28, 67, 0, 71, 28, 74, 0, 71, 28, 82, 0, 71, 28, 89, 0, 72, 28, 97, 0, 72, 28, 104, 0, 72, 28, 112, 0, 72, 29, 119, 0, 73, 29, 127, 0, 73, 29, 134, 0, 73, 29, 141, 0, 74, 29, 149, 0, 74, 29, 156, 0, 74, 29, 164, 0, 75, 30, 171, 0, 75, 30, 179, 0, 75, 30, 186, 0, 76, 30, 194, 0, 76, 30, 201, 0, 76, 30, 209, 0, 77, 30, 216, 0, 77, 30, 224, 0, 77, 31, 231, 0, 77, 31, 239, 0, 78, 31, 246, 0, 78, 31, 254, 0, 78, 31, 255, 0, 79, 31, 255, 0, 79, 31, 255, 0, 79, 32, 255, 0, 80, 32, 255, 0, 80, 32, 255, 0, 80, 32, 255, 0, 81, 32, 255, 0, 81, 32, 255, 0, 81, 32, 255, 0, 82, 32, 255, 0, 82, 33, 255, 0, 82, 33, 255, 0, 82, 33, 255, 0, 83, 33, 255, 0, 83, 33, 255, 0, 83, 33, 255, 0, 84, 33, 255, 0, 84, 34, 255, 0, 84, 34, 255, 0, 85, 34, 255, 0, 85, 34, 255, 0, 85, 34, 255, 0, 86, 34, 255, 0, 86, 34, 255, 0, 86, 34, 255, 0, 87, 35, 255, 0, 87, 35, 255, 0, 87, 35, 255, 0, 88, 35, 255, 0, 88, 35, 255, 0, 88, 35, 255, 0, 89, 35, 255, 0, 89, 36, 255, 0, 89, 36, 255, 0, 90, 36, 255, 0, 90, 36, 255, 0, 90, 36, 255, 0, 90, 36, 255, 0, 91, 36, 255, 0, 91, 36, 255, 0, 91, 37, 255, 0, 92, 37, 255, 0, 92, 37, 255, 0, 92, 37, 255, 0, 93, 37, 255, 0, 93, 37, 255, 0, 93, 37, 255, 0, 94, 38, 255, 0, 94, 38, 255, 0, 94, 38, 255, 0, 95, 38, 255, 0, 95, 38, 255, 0, 95, 38, 255, 0, 96, 38, 255, 0, 96, 38, 255, 0, 96, 39, 255, 0, 97, 39, 255, 0, 97, 39, 255, 0, 97, 39, 255, 0, 98, 39, 255, 0, 98, 39, 255, 0, 98, 39, 255, 0, 99, 40, 255, 0, 99, 40, 255, 0, 99, 40, 255, 0, 100, 40, 255, 0, 100, 40, 255, 0, 100, 40, 255, 0, 101, 40, 255, 0, 101, 40, 255, 0, 101, 41, 255, 0, 102, 41, 255, 0, 102, 41, 255, 0, 102, 41, 255, 0, 103, 41, 255, 0, 103, 41, 255, 0, 103, 41, 255, 0, 104, 42, 255, 0, 104, 42, 255, 0, 104, 42, 255, 0, 105, 42, 255, 0, 105, 42, 255, 0, 105, 42, 255, 0, 106, 42, 255, 0, 106, 42, 255, 0, 106, 43, 255, 0, 107, 43, 255, 0, 107, 43, 255, 0, 107, 43, 255, 0, 108, 43, 255, 0, 108, 43, 255, 0, 108, 43, 255, 0, 109, 43, 255, 0, 109, 44, 255, 0, 109, 44, 255, 0, 109, 44, 255, 1, 109, 44, 255, 1, 110, 44, 255, 1, 110, 45, 255, 2, 110, 45, 255, 2, 110, 45, 255, 2, 111, 45, 255, 3, 111, 45, 255, 3, 111, 46, 255, 3, 111, 46, 255, 4, 111, 46, 255, 4, 112, 46, 255, 4, 112, 46, 255, 5, 112, 47, 255, 5, 112, 47, 255, 5, 113, 47, 255, 6, 113, 47, 255, 6, 113, 47, 255, 6, 113, 48, 255, 7, 114, 48, 255, 7, 114, 48, 255, 7, 114, 48, 255, 8, 114, 48, 255, 8, 114, 48, 255, 8, 115, 49, 255, 9, 115, 49, 255, 9, 115, 49, 255, 9, 115, 49, 255, 10, 116, 49, 255, 10, 116, 50, 255, 10, 116, 50, 255, 11, 116, 50, 255, 11, 117, 50, 255, 11, 117, 50, 255, 12, 117, 51, 255, 12, 117, 51, 255, 12, 118, 51, 255, 13, 118, 51, 255, 13, 118, 51, 255, 13, 118, 52, 255, 14, 118, 52, 255, 14, 119, 52, 255, 14, 119, 52, 255, 15, 119, 52, 255, 15, 119, 53, 255, 15, 120, 53, 255, 16, 120, 53, 255, 16, 120, 53, 255, 16, 120, 53, 255, 16, 121, 54, 255, 17, 121, 54, 255, 17, 121, 54, 255, 17, 121, 54, 255, 17, 121, 54, 255, 18, 122, 54, 255, 18, 122, 55, 255, 18, 122, 55, 255, 19, 122, 55, 255, 19, 123, 55, 255, 19, 123, 55, 255, 19, 123, 56, 255, 20, 123, 56, 255, 20, 124, 56, 255, 20, 124, 56, 255, 20, 124, 56, 255, 21, 124, 57, 255, 21, 125, 57, 255, 21, 125, 57, 255, 21, 125, 57, 255, 22, 125, 57, 255, 22, 125, 58, 255, 22, 126, 58, 255, 22, 126, 58, 255, 23, 126, 58, 255, 23, 126, 58, 255, 23, 127, 59, 255, 23, 127, 59, 255, 24, 127, 59, 255, 24, 127, 59, 255, 24, 128, 59, 255, 24, 128, 60, 255, 25, 128, 60, 255, 25, 128, 60, 255, 25, 129, 60, 255, 25, 129, 60, 255, 26, 129, 61, 255, 26, 129, 61, 255, 26, 129, 61, 255, 26, 130, 61, 255, 27, 130, 61, 255, 27, 130, 62, 255, 27, 130, 62, 255, 27, 131, 62, 255, 27, 131, 62, 255, 28, 131, 62, 255, 28, 131, 63, 255, 28, 132, 63, 255, 28, 132, 63, 255, 29, 132, 63, 255, 29, 132, 63, 255, 29, 133, 64, 255, 29, 133, 64, 255, 29, 133, 64, 255, 30, 133, 64, 255, 30, 133, 64, 255, 30, 134, 65, 255, 30, 134, 65, 255, 31, 134, 65, 255, 31, 134, 65, 255, 31, 135, 65, 255, 31, 135, 66, 255, 31, 135, 66, 255, 32, 135, 66, 255, 32, 136, 66, 255, 32, 136, 66, 255, 32, 136, 67, 255, 33, 136, 67, 255, 33, 137, 67, 255, 33, 137, 67, 255, 33, 137, 67, 255, 33, 137, 68, 255, 34, 138, 68, 255, 34, 138, 68, 255, 34, 138, 68, 255, 34, 138, 68, 255, 35, 139, 68, 255, 35, 139, 69, 255, 35, 139, 69, 255, 35, 139, 70, 255, 35, 140, 70, 255, 36, 140, 70, 255, 36, 140, 71, 255, 36, 140, 71, 255, 36, 141, 72, 255, 37, 141, 72, 255, 37, 141, 72, 255, 37, 141, 73, 255, 37, 142, 73, 255, 37, 142, 73, 255, 38, 142, 74, 255, 38, 143, 74, 255, 38, 143, 75, 255, 38, 143, 75, 255, 39, 143, 75, 255, 39, 144, 76, 255, 39, 144, 76, 255, 39, 144, 77, 255, 40, 144, 77, 255, 40, 145, 77, 255, 40, 145, 78, 255, 40, 145, 78, 255, 40, 146, 78, 255, 41, 146, 79, 255, 41, 146, 79, 255, 41, 146, 80, 255, 41, 147, 80, 255, 42, 147, 80, 255, 42, 147, 81, 255, 42, 147, 81, 255, 42, 148, 82, 255, 43, 148, 82, 255, 43, 148, 82, 255, 43, 149, 83, 255, 43, 149, 83, 255, 43, 149, 83, 255, 44, 149, 84, 255, 44, 150, 84, 255, 44, 150, 85, 255, 44, 150, 85, 255, 45, 150, 85, 255, 45, 151, 86, 255, 45, 151, 86, 255, 45, 151, 86, 255, 46, 152, 87, 255, 46, 152, 87, 255, 46, 152, 88, 255, 46, 152, 88, 255, 46, 153, 88, 255, 47, 153, 89, 255, 47, 153, 89, 255, 47, 153, 90, 255, 47, 154, 90, 255, 48, 154, 90, 255, 48, 154, 91, 255, 48, 155, 91, 255, 48, 155, 91, 255, 49, 155, 92, 255, 49, 155, 92, 255, 49, 156, 93, 255, 49, 156, 93, 255, 49, 156, 93, 255, 50, 156, 94, 255, 50, 157, 94, 255, 50, 157, 95, 255, 50, 157, 95, 255, 51, 158, 95, 255, 51, 158, 96, 255, 51, 158, 96, 255, 51, 158, 96, 255, 52, 159, 97, 255, 52, 159, 97, 255, 52, 159, 98, 255, 52, 159, 98, 255, 52, 160, 98, 255, 53, 160, 99, 255, 53, 160, 99, 255, 53, 161, 99, 255, 53, 161, 100, 255, 54, 161, 100, 255, 54, 161, 101, 255, 54, 162, 101, 255, 54, 162, 101, 255, 55, 162, 102, 255, 55, 162, 102, 255, 55, 163, 103, 255, 55, 163, 103, 255, 56, 163, 103, 255, 56, 164, 104, 255, 56, 164, 104, 255, 56, 164, 104, 255, 57, 164, 105, 255, 57, 165, 105, 255, 57, 165, 106, 255, 57, 165, 106, 255, 57, 166, 106, 255, 58, 166, 107, 255, 58, 166, 107, 255, 58, 166, 108, 255, 58, 167, 108, 255, 59, 167, 108, 255, 59, 167, 109, 255, 59, 167, 109, 255, 59, 168, 109, 255, 60, 168, 110, 255, 60, 168, 110, 255, 60, 169, 111, 255, 60, 169, 111, 255, 61, 169, 111, 255, 61, 169, 112, 255, 61, 170, 112, 255, 61, 170, 113, 255, 62, 170, 113, 255, 62, 170, 113, 255, 62, 171, 114, 255, 62, 171, 114, 255, 63, 171, 114, 255, 63, 172, 115, 255, 63, 172, 115, 255, 63, 172, 116, 255, 64, 172, 116, 255, 64, 173, 116, 255, 64, 173, 117, 255, 64, 173, 117, 255, 65, 174, 117, 255, 65, 174, 118, 255, 65, 174, 118, 255, 65, 174, 119, 255, 65, 174, 119, 255, 66, 174, 119, 255, 66, 174, 120, 255, 66, 175, 120, 255, 66, 175, 121, 255, 67, 175, 121, 255, 67, 175, 121, 255, 67, 175, 122, 255, 67, 175, 122, 255, 68, 176, 123, 255, 68, 176, 123, 255, 68, 176, 123, 255, 68, 176, 124, 255, 69, 176, 124, 255, 69, 176, 124, 255, 69, 177, 125, 255, 69, 177, 125, 255, 70, 177, 126, 255, 70, 177, 126, 255, 70, 177, 126, 255, 70, 177, 127, 255, 71, 178, 127, 255, 71, 178, 127, 255, 71, 178, 128, 255, 71, 178, 128, 255, 72, 178, 129, 255, 72, 178, 129, 255, 72, 179, 129, 255, 72, 179, 130, 255, 73, 179, 130, 255, 73, 179, 130, 255, 73, 179, 131, 255, 73, 179, 131, 255, 74, 179, 132, 255, 74, 180, 132, 255, 74, 180, 132, 255, 74, 180, 133, 255, 75, 180, 133, 255, 75, 180, 133, 255, 75, 180, 134, 255, 76, 181, 134, 255, 76, 181, 135, 255, 76, 181, 135, 255, 76, 181, 135, 255, 77, 181, 136, 255, 77, 181, 136, 255, 77, 182, 136, 255, 78, 182, 137, 255, 78, 182, 137, 255, 78, 182, 138, 255, 78, 182, 138, 255, 79, 182, 138, 255, 79, 182, 139, 255, 79, 183, 139, 255, 79, 183, 139, 255, 80, 183, 140, 255, 80, 183, 140, 255, 80, 183, 140, 255, 81, 183, 141, 255, 81, 184, 141, 255, 81, 184, 142, 255, 82, 184, 142, 255, 82, 184, 142, 255, 82, 184, 143, 255, 82, 184, 143, 255, 83, 185, 143, 255, 83, 185, 144, 255, 83, 185, 144, 255, 84, 185, 144, 255, 84, 185, 145, 255, 84, 185, 145, 255, 84, 185, 145, 255, 85, 186, 146, 255, 85, 186, 146, 255, 85, 186, 146, 255, 86, 186, 147, 255, 86, 186, 147, 255, 86, 186, 148, 255, 87, 187, 148, 255, 87, 187, 148, 255, 87, 187, 149, 255, 88, 187, 149, 255, 88, 187, 149, 255, 88, 187, 150, 255, 88, 187, 150, 255, 89, 188, 150, 255, 89, 188, 151, 255, 89, 188, 151, 255, 90, 188, 151, 255, 90, 188, 152, 255, 90, 188, 152, 255, 91, 189, 152, 255, 91, 189, 153, 255, 91, 189, 153, 255, 92, 189, 153, 255, 92, 189, 154, 255, 92, 189, 154, 255, 93, 189, 154, 255, 93, 190, 155, 255, 93, 190, 155, 255, 94, 190, 156, 255, 94, 190, 156, 255, 94, 190, 156, 255, 95, 190, 157, 255, 95, 190, 157, 255, 95, 191, 157, 255, 95, 191, 158, 255, 96, 191, 158, 255, 96, 191, 158, 255, 96, 191, 159, 255, 97, 191, 159, 255, 97, 192, 159, 255, 97, 192, 160, 255, 98, 192, 160, 255, 98, 192, 160, 255, 98, 192, 161, 255, 99, 192, 161, 255, 99, 192, 161, 255, 99, 193, 162, 255, 100, 193, 162, 255, 100, 193, 162, 255, 100, 193, 163, 255, 101, 193, 163, 255, 101, 193, 163, 255, 102, 194, 163, 255, 102, 194, 164, 255, 102, 194, 164, 255, 103, 194, 164, 255, 103, 194, 165, 255, 103, 194, 165, 255, 104, 195, 165, 255, 104, 195, 166, 255, 105, 195, 166, 255, 105, 195, 166, 255, 105, 195, 167, 255, 106, 195, 167, 255, 106, 196, 167, 255, 107, 196, 167, 255, 107, 196, 168, 255, 107, 196, 168, 255, 108, 196, 168, 255, 108, 196, 169, 255, 109, 197, 169, 255, 109, 197, 169, 255, 109, 197, 170, 255, 110, 197, 170, 255, 110, 197, 170, 255, 111, 198, 171, 255, 111, 198, 171, 255, 111, 198, 171, 255, 112, 198, 171, 255, 112, 198, 172, 255, 113, 198, 172, 255, 113, 199, 172, 255, 113, 199, 173, 255, 114, 199, 173, 255, 114, 199, 173, 255, 114, 199, 174, 255, 115, 199, 174, 255, 115, 200, 174, 255, 116, 200, 174, 255, 116, 200, 175, 255, 116, 200, 175, 255, 117, 200, 175, 255, 117, 200, 176, 255, 118, 201, 176, 255, 118, 201, 176, 255, 118, 201, 177, 255, 119, 201, 177, 255, 119, 201, 177, 255, 120, 202, 177, 255, 120, 202, 178, 255, 120, 202, 178, 255, 121, 202, 178, 255, 121, 202, 179, 255, 122, 202, 179, 255, 122, 203, 179, 255, 122, 203, 179, 255, 123, 203, 180, 255, 123, 203, 180, 255, 124, 203, 180, 255, 124, 203, 181, 255, 124, 204, 181, 255, 125, 204, 181, 255, 125, 204, 181, 255, 126, 204, 182, 255, 126, 204, 182, 255, 126, 204, 182, 255, 127, 205, 183, 255, 127, 205, 183, 255, 128, 205, 183, 255, 128, 205, 184, 255, 128, 205, 184, 255, 129, 205, 184, 255, 129, 206, 184, 255, 130, 206, 185, 255, 130, 206, 185, 255, 130, 206, 185, 255, 131, 206, 186, 255, 131, 207, 186, 255, 132, 207, 186, 255, 132, 207, 186, 255, 132, 207, 187, 255, 133, 207, 187, 255, 133, 207, 187, 255, 134, 208, 188, 255, 134, 208, 188, 255, 134, 208, 188, 255, 135, 208, 188, 255, 135, 208, 189, 255, 136, 208, 189, 255, 136, 209, 189, 255, 136, 209, 190, 255, 137, 209, 190, 255, 137, 209, 190, 255, 138, 209, 190, 255, 138, 209, 191, 255, 138, 210, 191, 255, 139, 210, 191, 255, 139, 210, 191, 255, 140, 210, 192, 255, 140, 210, 192, 255, 140, 210, 192, 255, 141, 211, 193, 255, 141, 211, 193, 255, 142, 211, 193, 255, 142, 211, 193, 255, 142, 211, 194, 255, 143, 211, 194, 255, 143, 212, 194, 255, 144, 212, 195, 255, 144, 212, 195, 255, 144, 212, 195, 255, 145, 212, 195, 255, 145, 212, 196, 255, 146, 213, 196, 255, 146, 213, 196, 255, 146, 213, 196, 255, 147, 213, 197, 255, 147, 213, 197, 255, 148, 213, 197, 255, 148, 214, 198, 255, 148, 214, 198, 255, 149, 214, 198, 255, 149, 214, 198, 255, 150, 214, 199, 255, 150, 214, 199, 255, 150, 215, 199, 255, 151, 215, 199, 255, 151, 215, 200, 255, 152, 215, 200, 255, 152, 215, 200, 255, 152, 216, 200, 255, 153, 216, 201, 255, 153, 216, 201, 255, 154, 216, 201, 255, 154, 216, 201, 255, 154, 216, 202, 255, 155, 216, 202, 255, 155, 217, 202, 255, 156, 217, 202, 255, 156, 217, 203, 255, 156, 217, 203, 255, 157, 217, 203, 255, 157, 217, 203, 255, 158, 218, 204, 255, 158, 218, 204, 255, 158, 218, 204, 255, 159, 218, 204, 255, 159, 218, 205, 255, 160, 218, 205, 255, 160, 219, 205, 255, 160, 219, 205, 255, 161, 219, 205, 255, 161, 219, 206, 255, 162, 219, 206, 255, 162, 219, 206, 255, 162, 219, 206, 255, 163, 220, 207, 255, 163, 220, 207, 255, 164, 220, 207, 255, 164, 220, 207, 255, 164, 220, 208, 255, 165, 220, 208, 255, 165, 221, 208, 255, 166, 221, 208, 255, 166, 221, 209, 255, 166, 221, 209, 255, 167, 221, 209, 255, 167, 221, 209, 255, 168, 222, 209, 255, 168, 222, 210, 255, 168, 222, 210, 255, 169, 222, 210, 255, 169, 222, 210, 255, 170, 222, 211, 255, 170, 222, 211, 255, 170, 223, 211, 255, 171, 223, 211, 255, 171, 223, 212, 255, 172, 223, 212, 255, 172, 223, 212, 255, 172, 223, 212, 255, 173, 224, 212, 255, 173, 224, 213, 255, 174, 224, 213, 255, 174, 224, 213, 255, 174, 224, 213, 255, 175, 224, 214, 255, 175, 224, 214, 255, 176, 225, 214, 255, 176, 225, 214, 255, 176, 225, 215, 255, 177, 225, 215, 255, 177, 225, 215, 255, 178, 225, 215, 255, 178, 226, 215, 255, 178, 226, 216, 255, 179, 226, 216, 255, 179, 226, 216, 255, 180, 226, 216, 255, 180, 226, 217, 255, 180, 227, 217, 255, 181, 227, 217, 255, 181, 227, 217, 255, 182, 227, 217, 255, 182, 227, 218, 255, 182, 227, 218, 255, 183, 227, 218, 255, 183, 228, 218, 255, 184, 228, 219, 255, 184, 228, 219, 255, 184, 228, 219, 255, 185, 228, 219, 255, 185, 228, 219, 255, 186, 229, 220, 255, 186, 229, 220, 255, 186, 229, 220, 255, 187, 229, 220, 255, 187, 229, 221, 255, 188, 229, 221, 255, 188, 229, 221, 255, 188, 230, 221, 255, 189, 230, 221, 255, 189, 230, 222, 255, 190, 230, 222, 255, 190, 230, 222, 255, 190, 230, 222, 255, 191, 231, 223, 255, 191, 231, 223, 255, 192, 231, 223, 255, 192, 231, 223, 255, 192, 231, 223, 255, 193, 231, 224, 255, 193, 231, 224, 255, 194, 232, 224, 255, 194, 232, 224, 255, 194, 232, 225, 255, 195, 232, 225, 255, 195, 232, 225, 255, 196, 232, 225, 255, 196, 233, 225, 255, 196, 233, 226, 255, 197, 233, 226, 255, 197, 233, 226, 255, 198, 233, 226, 255, 198, 233, 226, 255, 198, 233, 227, 255, 199, 234, 227, 255, 199, 234, 227, 255, 200, 234, 227, 255, 200, 234, 228, 255, 200, 234, 228, 255, 201, 234, 228, 255, 201, 235, 228, 255, 202, 235, 228, 255, 202, 235, 229, 255, 202, 235, 229, 255, 203, 235, 229, 255, 203, 235, 229, 255, 203, 236, 229, 255, 204, 236, 230, 255, 204, 236, 230, 255, 204, 236, 230, 255, 204, 236, 230, 255, 204, 236, 231, 255, 204, 236, 231, 255, 205, 236, 231, 255, 205, 236, 231, 255, 205, 236, 231, 255, 205, 236, 232, 255, 205, 236, 232, 255, 205, 236, 232, 255, 205, 236, 232, 255, 206, 237, 232, 255, 206, 237, 232, 255, 206, 237, 233, 255, 206, 237, 233, 255, 206, 237, 233, 255, 206, 237, 233, 255, 207, 237, 233, 255, 207, 237, 234, 255, 207, 237, 234, 255, 207, 237, 234, 255, 207, 237, 234, 255, 207, 237, 234, 255, 208, 237, 235, 255, 208, 238, 235, 255, 208, 238, 235, 255, 208, 238, 235, 255, 208, 238, 235, 255, 209, 238, 235, 255, 209, 238, 236, 255, 209, 238, 236, 255, 209, 238, 236, 255, 209, 238, 236, 255, 209, 238, 236, 255, 210, 238, 237, 255, 210, 238, 237, 255, 210, 238, 237, 255, 210, 238, 237, 255, 210, 239, 237, 255, 211, 239, 237, 255, 211, 239, 238, 255, 211, 239, 238, 255, 211, 239, 238, 255, 211, 239, 238, 255, 211, 239, 238, 255, 212, 239, 238, 255, 212, 239, 239, 255, 212, 239, 239, 255, 212, 239, 239, 255, 212, 239, 239, 255, 213, 239, 239, 255, 213, 239, 239, 255, 213, 240, 240, 255, 213, 240, 240, 255, 213, 240, 240, 255, 214, 240, 240, 255, 214, 240, 240, 255, 214, 240, 240, 255, 214, 240, 240, 255, 214, 240, 241, 255, 215, 240, 241, 255, 215, 240, 241, 255, 215, 240, 241, 255, 215, 240, 241, 255, 215, 240, 241, 255, 216, 240, 241, 255, 216, 240, 242, 255, 216, 241, 242, 255, 216, 241, 242, 255, 216, 241, 242, 255, 217, 241, 242, 255, 217, 241, 242, 255, 217, 241, 242, 255, 217, 241, 243, 255, 217, 241, 243, 255, 218, 241, 243, 255, 218, 241, 243, 255, 218, 241, 243, 255, 218, 241, 243, 255, 219, 241, 243, 255, 219, 241, 244, 255, 219, 242, 244, 255, 219, 242, 244, 255, 219, 242, 244, 255, 220, 242, 244, 255, 220, 242, 244, 255, 220, 242, 244, 255, 220, 242, 244, 255, 220, 242, 245, 255, 221, 242, 245, 255, 221, 242, 245, 255, 221, 242, 245, 255, 221, 242, 245, 255, 221, 242, 245, 255, 222, 242, 245, 255, 222, 242, 245, 255, 222, 243, 246, 255, 222, 243, 246, 255, 223, 243, 246, 255, 223, 243, 246, 255, 223, 243, 246, 255, 223, 243, 246, 255, 223, 243, 246, 255, 224, 243, 246, 255, 224, 243, 246, 255, 224, 243, 247, 255, 224, 243, 247, 255, 225, 243, 247, 255, 225, 243, 247, 255, 225, 243, 247, 255, 225, 243, 247, 255, 225, 244, 247, 255, 226, 244, 247, 255, 226, 244, 247, 255, 226, 244, 247, 255, 226, 244, 248, 255, 227, 244, 248, 255, 227, 244, 248, 255, 227, 244, 248, 255, 227, 244, 248, 255, 227, 244, 248, 255, 228, 244, 248, 255, 228, 244, 248, 255, 228, 244, 248, 255, 228, 244, 248, 255, 228, 245, 248, 255, 229, 245, 249, 255, 229, 245, 249, 255, 229, 245, 249, 255, 229, 245, 249, 255, 229, 245, 249, 255, 229, 245, 249, 255, 229, 245, 249, 255, 230, 245, 249, 255, 230, 245, 249, 255, 230, 245, 249, 255, 230, 245, 249, 255, 230, 245, 249, 255, 230, 245, 249, 255, 230, 245, 249, 255, 231, 245, 249, 255, 231, 245, 249, 255, 231, 245, 249, 255, 231, 245, 249, 255, 231, 246, 249, 255, 231, 246, 249, 255, 231, 246, 249, 255, 232, 246, 249, 255, 232, 246, 249, 255, 232, 246, 249, 255, 232, 246, 249, 255, 232, 246, 249, 255, 232, 246, 249, 255, 232, 246, 249, 255, 233, 246, 249, 255, 233, 246, 249, 255, 233, 246, 249, 255, 233, 246, 249, 255, 233, 246, 249, 255, 233, 246, 249, 255, 233, 246, 250, 255, 234, 246, 250, 255, 234, 247, 250, 255, 234, 247, 250, 255, 234, 247, 250, 255, 234, 247, 250, 255, 234, 247, 250, 255, 234, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 236, 247, 250, 255, 236, 247, 250, 255, 236, 247, 250, 255, 236, 247, 250, 255, 236, 247, 250, 255, 236, 248, 250, 255, 236, 248, 250, 255, 237, 248, 250, 255, 237, 248, 250, 255, 237, 248, 250, 255, 237, 248, 250, 255, 237, 248, 250, 255, 237, 248, 250, 255, 237, 248, 250, 255, 237, 248, 250, 255, 238, 248, 250, 255, 238, 248, 250, 255, 238, 248, 250, 255, 238, 248, 251, 255, 238, 248, 251, 255, 238, 248, 251, 255, 238, 248, 251, 255, 239, 248, 251, 255, 239, 249, 251, 255, 239, 249, 251, 255, 239, 249, 251, 255, 239, 249, 251, 255, 239, 249, 251, 255, 239, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 241, 249, 251, 255, 241, 249, 251, 255, 241, 249, 251, 255, 241, 249, 251, 255, 241, 249, 251, 255, 241, 249, 251, 255, 241, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 244, 250, 252, 255, 244, 250, 252, 255, 244, 250, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_BuGn_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 0, 68, 26, 0, 0, 68, 27, 7, 0, 68, 27, 14, 0, 68, 27, 22, 0, 68, 27, 29, 0, 69, 27, 37, 0, 69, 27, 44, 0, 69, 27, 52, 0, 69, 27, 59, 0, 70, 27, 67, 0, 70, 28, 74, 0, 70, 28, 82, 0, 70, 28, 89, 0, 71, 28, 97, 0, 71, 28, 104, 0, 71, 28, 112, 0, 71, 28, 119, 0, 72, 28, 127, 0, 72, 28, 134, 0, 72, 29, 141, 0, 72, 29, 149, 0, 73, 29, 156, 0, 73, 29, 164, 0, 73, 29, 171, 0, 73, 29, 179, 0, 74, 29, 186, 0, 74, 29, 194, 0, 74, 29, 201, 0, 74, 29, 209, 0, 75, 30, 216, 0, 75, 30, 224, 0, 75, 30, 231, 0, 75, 30, 239, 0, 76, 30, 246, 0, 76, 30, 254, 0, 76, 30, 255, 0, 76, 30, 255, 0, 77, 30, 255, 0, 77, 31, 255, 0, 77, 31, 255, 0, 77, 31, 255, 0, 78, 31, 255, 0, 78, 31, 255, 0, 78, 31, 255, 0, 78, 31, 255, 0, 79, 31, 255, 0, 79, 31, 255, 0, 79, 31, 255, 0, 79, 32, 255, 0, 80, 32, 255, 0, 80, 32, 255, 0, 80, 32, 255, 0, 81, 32, 255, 0, 81, 32, 255, 0, 81, 32, 255, 0, 81, 32, 255, 0, 82, 32, 255, 0, 82, 33, 255, 0, 82, 33, 255, 0, 82, 33, 255, 0, 83, 33, 255, 0, 83, 33, 255, 0, 83, 33, 255, 0, 83, 33, 255, 0, 92, 37, 255, 0, 92, 37, 255, 0, 92, 37, 255, 0, 93, 37, 255, 0, 93, 37, 255, 0, 93, 37, 255, 0, 93, 37, 255, 0, 94, 37, 255, 0, 94, 38, 255, 0, 94, 38, 255, 0, 94, 38, 255, 0, 95, 38, 255, 0, 95, 38, 255, 0, 95, 38, 255, 0, 95, 38, 255, 0, 96, 38, 255, 0, 96, 38, 255, 0, 96, 39, 255, 0, 96, 39, 255, 0, 97, 39, 255, 0, 97, 39, 255, 0, 97, 39, 255, 0, 97, 39, 255, 0, 98, 39, 255, 0, 98, 39, 255, 0, 98, 39, 255, 0, 99, 39, 255, 0, 99, 40, 255, 0, 99, 40, 255, 0, 99, 40, 255, 0, 100, 40, 255, 0, 100, 40, 255, 0, 100, 40, 255, 0, 100, 40, 255, 0, 101, 40, 255, 0, 101, 40, 255, 0, 101, 41, 255, 0, 101, 41, 255, 0, 102, 41, 255, 0, 102, 41, 255, 0, 102, 41, 255, 0, 102, 41, 255, 0, 103, 41, 255, 0, 103, 41, 255, 0, 103, 41, 255, 0, 103, 41, 255, 0, 104, 42, 255, 0, 104, 42, 255, 0, 104, 42, 255, 0, 105, 42, 255, 0, 105, 42, 255, 0, 105, 42, 255, 0, 105, 42, 255, 0, 106, 42, 255, 0, 106, 42, 255, 0, 106, 43, 255, 0, 106, 43, 255, 0, 107, 43, 255, 0, 107, 43, 255, 0, 107, 43, 255, 0, 107, 43, 255, 0, 108, 43, 255, 0, 108, 43, 255, 0, 108, 43, 255, 0, 109, 43, 255, 0, 109, 44, 255, 0, 109, 44, 255, 0, 109, 44, 255, 0, 109, 44, 255, 1, 109, 44, 255, 1, 110, 44, 255, 1, 110, 45, 255, 1, 110, 45, 255, 2, 110, 45, 255, 2, 110, 45, 255, 2, 111, 45, 255, 2, 111, 45, 255, 3, 111, 45, 255, 3, 111, 46, 255, 3, 111, 46, 255, 4, 111, 46, 255, 4, 112, 46, 255, 4, 112, 46, 255, 4, 112, 46, 255, 5, 112, 47, 255, 5, 112, 47, 255, 5, 113, 47, 255, 5, 113, 47, 255, 6, 113, 47, 255, 6, 113, 47, 255, 6, 113, 47, 255, 7, 113, 48, 255, 7, 114, 48, 255, 7, 114, 48, 255, 7, 114, 48, 255, 8, 114, 48, 255, 8, 114, 48, 255, 8, 115, 49, 255, 9, 115, 49, 255, 9, 115, 49, 255, 9, 115, 49, 255, 9, 115, 49, 255, 10, 116, 49, 255, 10, 116, 49, 255, 10, 116, 50, 255, 10, 116, 50, 255, 11, 116, 50, 255, 11, 116, 50, 255, 11, 117, 50, 255, 11, 117, 50, 255, 12, 117, 51, 255, 12, 117, 51, 255, 12, 117, 51, 255, 12, 118, 51, 255, 13, 118, 51, 255, 13, 118, 51, 255, 13, 118, 52, 255, 13, 118, 52, 255, 13, 119, 52, 255, 14, 119, 52, 255, 14, 119, 52, 255, 14, 119, 52, 255, 14, 119, 52, 255, 15, 119, 53, 255, 15, 120, 53, 255, 15, 120, 53, 255, 15, 120, 53, 255, 15, 120, 53, 255, 23, 126, 58, 255, 23, 127, 59, 255, 23, 127, 59, 255, 23, 127, 59, 255, 23, 127, 59, 255, 24, 127, 59, 255, 24, 128, 59, 255, 24, 128, 59, 255, 24, 128, 60, 255, 24, 128, 60, 255, 25, 128, 60, 255, 25, 128, 60, 255, 25, 129, 60, 255, 25, 129, 60, 255, 25, 129, 61, 255, 26, 129, 61, 255, 26, 129, 61, 255, 26, 130, 61, 255, 26, 130, 61, 255, 26, 130, 61, 255, 27, 130, 62, 255, 27, 130, 62, 255, 27, 131, 62, 255, 27, 131, 62, 255, 27, 131, 62, 255, 28, 131, 62, 255, 28, 131, 62, 255, 28, 131, 63, 255, 28, 132, 63, 255, 28, 132, 63, 255, 28, 132, 63, 255, 29, 132, 63, 255, 29, 132, 63, 255, 29, 133, 64, 255, 29, 133, 64, 255, 29, 133, 64, 255, 30, 133, 64, 255, 30, 133, 64, 255, 30, 134, 64, 255, 30, 134, 65, 255, 30, 134, 65, 255, 30, 134, 65, 255, 31, 134, 65, 255, 31, 134, 65, 255, 31, 135, 65, 255, 31, 135, 65, 255, 31, 135, 66, 255, 32, 135, 66, 255, 32, 135, 66, 255, 32, 136, 66, 255, 32, 136, 66, 255, 32, 136, 66, 255, 32, 136, 67, 255, 33, 136, 67, 255, 33, 137, 67, 255, 33, 137, 67, 255, 33, 137, 67, 255, 33, 137, 67, 255, 33, 137, 68, 255, 34, 138, 68, 255, 34, 138, 68, 255, 34, 138, 68, 255, 34, 138, 68, 255, 34, 138, 68, 255, 35, 139, 68, 255, 35, 139, 69, 255, 35, 139, 69, 255, 35, 139, 69, 255, 35, 139, 70, 255, 35, 140, 70, 255, 36, 140, 70, 255, 36, 140, 71, 255, 36, 140, 71, 255, 36, 140, 71, 255, 36, 141, 72, 255, 37, 141, 72, 255, 37, 141, 72, 255, 37, 141, 72, 255, 37, 142, 73, 255, 37, 142, 73, 255, 37, 142, 73, 255, 38, 142, 74, 255, 38, 142, 74, 255, 38, 143, 74, 255, 38, 143, 75, 255, 38, 143, 75, 255, 39, 143, 75, 255, 39, 143, 76, 255, 39, 144, 76, 255, 39, 144, 76, 255, 39, 144, 76, 255, 39, 144, 77, 255, 40, 145, 77, 255, 40, 145, 77, 255, 40, 145, 78, 255, 40, 145, 78, 255, 40, 145, 78, 255, 41, 146, 79, 255, 41, 146, 79, 255, 41, 146, 79, 255, 41, 146, 80, 255, 41, 147, 80, 255, 41, 147, 80, 255, 42, 147, 80, 255, 42, 147, 81, 255, 42, 147, 81, 255, 42, 148, 81, 255, 42, 148, 82, 255, 43, 148, 82, 255, 43, 148, 82, 255, 43, 148, 83, 255, 43, 149, 83, 255, 43, 149, 83, 255, 43, 149, 84, 255, 44, 149, 84, 255, 44, 150, 84, 255, 44, 150, 84, 255, 44, 150, 85, 255, 44, 150, 85, 255, 45, 150, 85, 255, 45, 151, 86, 255, 45, 151, 86, 255, 45, 151, 86, 255, 45, 151, 87, 255, 46, 152, 87, 255, 46, 152, 87, 255, 46, 152, 87, 255, 46, 152, 88, 255, 52, 159, 98, 255, 52, 160, 98, 255, 53, 160, 99, 255, 53, 160, 99, 255, 53, 160, 99, 255, 53, 161, 99, 255, 53, 161, 100, 255, 54, 161, 100, 255, 54, 161, 100, 255, 54, 161, 101, 255, 54, 162, 101, 255, 54, 162, 101, 255, 55, 162, 102, 255, 55, 162, 102, 255, 55, 163, 102, 255, 55, 163, 102, 255, 55, 163, 103, 255, 55, 163, 103, 255, 56, 163, 103, 255, 56, 164, 104, 255, 56, 164, 104, 255, 56, 164, 104, 255, 56, 164, 105, 255, 57, 164, 105, 255, 57, 165, 105, 255, 57, 165, 106, 255, 57, 165, 106, 255, 57, 165, 106, 255, 58, 166, 106, 255, 58, 166, 107, 255, 58, 166, 107, 255, 58, 166, 107, 255, 58, 166, 108, 255, 58, 167, 108, 255, 59, 167, 108, 255, 59, 167, 109, 255, 59, 167, 109, 255, 59, 168, 109, 255, 59, 168, 110, 255, 60, 168, 110, 255, 60, 168, 110, 255, 60, 168, 110, 255, 60, 169, 111, 255, 60, 169, 111, 255, 61, 169, 111, 255, 61, 169, 112, 255, 61, 170, 112, 255, 61, 170, 112, 255, 61, 170, 113, 255, 62, 170, 113, 255, 62, 170, 113, 255, 62, 171, 114, 255, 62, 171, 114, 255, 62, 171, 114, 255, 63, 171, 114, 255, 63, 172, 115, 255, 63, 172, 115, 255, 63, 172, 115, 255, 63, 172, 116, 255, 64, 172, 116, 255, 64, 173, 116, 255, 64, 173, 117, 255, 64, 173, 117, 255, 64, 173, 117, 255, 65, 174, 117, 255, 65, 174, 118, 255, 65, 174, 118, 255, 65, 174, 118, 255, 65, 174, 119, 255, 65, 174, 119, 255, 66, 174, 119, 255, 66, 174, 120, 255, 66, 175, 120, 255, 66, 175, 120, 255, 66, 175, 121, 255, 67, 175, 121, 255, 67, 175, 121, 255, 67, 175, 122, 255, 67, 175, 122, 255, 67, 175, 122, 255, 68, 176, 122, 255, 68, 176, 123, 255, 68, 176, 123, 255, 68, 176, 123, 255, 68, 176, 124, 255, 69, 176, 124, 255, 69, 176, 124, 255, 69, 176, 125, 255, 69, 177, 125, 255, 69, 177, 125, 255, 70, 177, 125, 255, 70, 177, 126, 255, 70, 177, 126, 255, 70, 177, 126, 255, 70, 177, 127, 255, 71, 178, 127, 255, 71, 178, 127, 255, 71, 178, 128, 255, 71, 178, 128, 255, 71, 178, 128, 255, 72, 178, 128, 255, 72, 178, 129, 255, 72, 178, 129, 255, 72, 179, 129, 255, 72, 179, 130, 255, 73, 179, 130, 255, 73, 179, 130, 255, 73, 179, 131, 255, 73, 179, 131, 255, 74, 179, 131, 255, 74, 179, 131, 255, 74, 180, 132, 255, 74, 180, 132, 255, 74, 180, 132, 255, 75, 180, 133, 255, 75, 180, 133, 255, 75, 180, 133, 255, 75, 180, 134, 255, 76, 180, 134, 255, 76, 181, 134, 255, 76, 181, 134, 255, 76, 181, 135, 255, 76, 181, 135, 255, 77, 181, 135, 255, 77, 181, 136, 255, 77, 181, 136, 255, 77, 181, 136, 255, 78, 182, 136, 255, 85, 186, 146, 255, 86, 186, 146, 255, 86, 186, 146, 255, 86, 186, 147, 255, 86, 186, 147, 255, 86, 186, 147, 255, 87, 186, 148, 255, 87, 187, 148, 255, 87, 187, 148, 255, 87, 187, 148, 255, 88, 187, 149, 255, 88, 187, 149, 255, 88, 187, 149, 255, 88, 187, 150, 255, 89, 187, 150, 255, 89, 188, 150, 255, 89, 188, 150, 255, 89, 188, 151, 255, 90, 188, 151, 255, 90, 188, 151, 255, 90, 188, 152, 255, 90, 188, 152, 255, 91, 188, 152, 255, 91, 189, 152, 255, 91, 189, 153, 255, 91, 189, 153, 255, 92, 189, 153, 255, 92, 189, 154, 255, 92, 189, 154, 255, 92, 189, 154, 255, 93, 189, 154, 255, 93, 190, 155, 255, 93, 190, 155, 255, 93, 190, 155, 255, 94, 190, 155, 255, 94, 190, 156, 255, 94, 190, 156, 255, 94, 190, 156, 255, 95, 190, 157, 255, 95, 190, 157, 255, 95, 191, 157, 255, 95, 191, 157, 255, 96, 191, 158, 255, 96, 191, 158, 255, 96, 191, 158, 255, 96, 191, 158, 255, 97, 191, 159, 255, 97, 191, 159, 255, 97, 192, 159, 255, 97, 192, 160, 255, 98, 192, 160, 255, 98, 192, 160, 255, 98, 192, 160, 255, 99, 192, 161, 255, 99, 192, 161, 255, 99, 192, 161, 255, 99, 193, 161, 255, 100, 193, 162, 255, 100, 193, 162, 255, 100, 193, 162, 255, 100, 193, 162, 255, 101, 193, 163, 255, 101, 193, 163, 255, 101, 193, 163, 255, 102, 194, 163, 255, 102, 194, 164, 255, 102, 194, 164, 255, 102, 194, 164, 255, 103, 194, 164, 255, 103, 194, 165, 255, 103, 194, 165, 255, 104, 194, 165, 255, 104, 195, 165, 255, 104, 195, 166, 255, 105, 195, 166, 255, 105, 195, 166, 255, 105, 195, 166, 255, 106, 195, 167, 255, 106, 195, 167, 255, 106, 196, 167, 255, 107, 196, 167, 255, 107, 196, 168, 255, 107, 196, 168, 255, 107, 196, 168, 255, 108, 196, 168, 255, 108, 196, 169, 255, 108, 197, 169, 255, 109, 197, 169, 255, 109, 197, 169, 255, 109, 197, 170, 255, 110, 197, 170, 255, 110, 197, 170, 255, 110, 197, 170, 255, 111, 198, 171, 255, 111, 198, 171, 255, 111, 198, 171, 255, 112, 198, 171, 255, 112, 198, 172, 255, 112, 198, 172, 255, 113, 198, 172, 255, 113, 199, 172, 255, 113, 199, 172, 255, 113, 199, 173, 255, 114, 199, 173, 255, 114, 199, 173, 255, 114, 199, 173, 255, 115, 199, 174, 255, 115, 200, 174, 255, 115, 200, 174, 255, 116, 200, 174, 255, 116, 200, 175, 255, 116, 200, 175, 255, 117, 200, 175, 255, 117, 200, 175, 255, 117, 200, 176, 255, 118, 201, 176, 255, 118, 201, 176, 255, 118, 201, 176, 255, 119, 201, 176, 255, 119, 201, 177, 255, 119, 201, 177, 255, 119, 201, 177, 255, 120, 202, 177, 255, 120, 202, 178, 255, 120, 202, 178, 255, 121, 202, 178, 255, 121, 202, 178, 255, 121, 202, 179, 255, 132, 207, 186, 255, 132, 207, 186, 255, 133, 207, 187, 255, 133, 207, 187, 255, 133, 207, 187, 255, 134, 207, 187, 255, 134, 208, 188, 255, 134, 208, 188, 255, 134, 208, 188, 255, 135, 208, 188, 255, 135, 208, 189, 255, 135, 208, 189, 255, 136, 208, 189, 255, 136, 209, 189, 255, 136, 209, 189, 255, 137, 209, 190, 255, 137, 209, 190, 255, 137, 209, 190, 255, 138, 209, 190, 255, 138, 209, 191, 255, 138, 210, 191, 255, 139, 210, 191, 255, 139, 210, 191, 255, 139, 210, 191, 255, 140, 210, 192, 255, 140, 210, 192, 255, 140, 210, 192, 255, 141, 210, 192, 255, 141, 211, 193, 255, 141, 211, 193, 255, 142, 211, 193, 255, 142, 211, 193, 255, 142, 211, 193, 255, 142, 211, 194, 255, 143, 211, 194, 255, 143, 212, 194, 255, 143, 212, 194, 255, 144, 212, 195, 255, 144, 212, 195, 255, 144, 212, 195, 255, 145, 212, 195, 255, 145, 212, 195, 255, 145, 213, 196, 255, 146, 213, 196, 255, 146, 213, 196, 255, 146, 213, 196, 255, 147, 213, 197, 255, 147, 213, 197, 255, 147, 213, 197, 255, 148, 213, 197, 255, 148, 214, 197, 255, 148, 214, 198, 255, 149, 214, 198, 255, 149, 214, 198, 255, 149, 214, 198, 255, 150, 214, 199, 255, 150, 214, 199, 255, 150, 215, 199, 255, 151, 215, 199, 255, 151, 215, 199, 255, 151, 215, 200, 255, 152, 215, 200, 255, 152, 215, 200, 255, 152, 215, 200, 255, 152, 216, 200, 255, 153, 216, 201, 255, 153, 216, 201, 255, 153, 216, 201, 255, 154, 216, 201, 255, 154, 216, 201, 255, 154, 216, 202, 255, 155, 216, 202, 255, 155, 217, 202, 255, 155, 217, 202, 255, 156, 217, 202, 255, 156, 217, 203, 255, 156, 217, 203, 255, 157, 217, 203, 255, 157, 217, 203, 255, 157, 217, 203, 255, 158, 218, 204, 255, 158, 218, 204, 255, 158, 218, 204, 255, 159, 218, 204, 255, 159, 218, 204, 255, 159, 218, 204, 255, 160, 218, 205, 255, 160, 218, 205, 255, 160, 219, 205, 255, 160, 219, 205, 255, 161, 219, 205, 255, 161, 219, 206, 255, 161, 219, 206, 255, 162, 219, 206, 255, 162, 219, 206, 255, 162, 219, 206, 255, 163, 220, 207, 255, 163, 220, 207, 255, 163, 220, 207, 255, 164, 220, 207, 255, 164, 220, 207, 255, 164, 220, 207, 255, 165, 220, 208, 255, 165, 220, 208, 255, 165, 221, 208, 255, 166, 221, 208, 255, 166, 221, 208, 255, 166, 221, 209, 255, 167, 221, 209, 255, 167, 221, 209, 255, 167, 221, 209, 255, 167, 221, 209, 255, 168, 222, 210, 255, 168, 222, 210, 255, 168, 222, 210, 255, 169, 222, 210, 255, 169, 222, 210, 255, 169, 222, 210, 255, 170, 222, 211, 255, 170, 222, 211, 255, 170, 223, 211, 255, 171, 223, 211, 255, 171, 223, 211, 255, 171, 223, 212, 255, 172, 223, 212, 255, 172, 223, 212, 255, 172, 223, 212, 255, 173, 223, 212, 255, 183, 228, 218, 255, 183, 228, 218, 255, 184, 228, 219, 255, 184, 228, 219, 255, 184, 228, 219, 255, 185, 228, 219, 255, 185, 228, 219, 255, 185, 228, 220, 255, 186, 229, 220, 255, 186, 229, 220, 255, 186, 229, 220, 255, 187, 229, 220, 255, 187, 229, 220, 255, 187, 229, 221, 255, 188, 229, 221, 255, 188, 229, 221, 255, 188, 230, 221, 255, 188, 230, 221, 255, 189, 230, 221, 255, 189, 230, 222, 255, 189, 230, 222, 255, 190, 230, 222, 255, 190, 230, 222, 255, 190, 230, 222, 255, 191, 231, 223, 255, 191, 231, 223, 255, 191, 231, 223, 255, 192, 231, 223, 255, 192, 231, 223, 255, 192, 231, 223, 255, 193, 231, 224, 255, 193, 231, 224, 255, 193, 232, 224, 255, 194, 232, 224, 255, 194, 232, 224, 255, 194, 232, 224, 255, 195, 232, 225, 255, 195, 232, 225, 255, 195, 232, 225, 255, 196, 232, 225, 255, 196, 233, 225, 255, 196, 233, 226, 255, 196, 233, 226, 255, 197, 233, 226, 255, 197, 233, 226, 255, 197, 233, 226, 255, 198, 233, 226, 255, 198, 233, 227, 255, 198, 234, 227, 255, 199, 234, 227, 255, 199, 234, 227, 255, 199, 234, 227, 255, 200, 234, 227, 255, 200, 234, 228, 255, 200, 234, 228, 255, 201, 234, 228, 255, 201, 235, 228, 255, 201, 235, 228, 255, 202, 235, 228, 255, 202, 235, 229, 255, 202, 235, 229, 255, 203, 235, 229, 255, 203, 235, 229, 255, 203, 235, 229, 255, 203, 236, 229, 255, 204, 236, 230, 255, 204, 236, 230, 255, 204, 236, 230, 255, 204, 236, 230, 255, 204, 236, 230, 255, 204, 236, 230, 255, 204, 236, 231, 255, 204, 236, 231, 255, 205, 236, 231, 255, 205, 236, 231, 255, 205, 236, 231, 255, 205, 236, 231, 255, 205, 236, 232, 255, 205, 236, 232, 255, 205, 236, 232, 255, 205, 236, 232, 255, 206, 237, 232, 255, 206, 237, 232, 255, 206, 237, 233, 255, 206, 237, 233, 255, 206, 237, 233, 255, 206, 237, 233, 255, 206, 237, 233, 255, 207, 237, 233, 255, 207, 237, 233, 255, 207, 237, 234, 255, 207, 237, 234, 255, 207, 237, 234, 255, 207, 237, 234, 255, 207, 237, 234, 255, 208, 237, 234, 255, 208, 237, 234, 255, 208, 237, 235, 255, 208, 238, 235, 255, 208, 238, 235, 255, 208, 238, 235, 255, 208, 238, 235, 255, 209, 238, 235, 255, 209, 238, 235, 255, 209, 238, 236, 255, 209, 238, 236, 255, 209, 238, 236, 255, 209, 238, 236, 255, 209, 238, 236, 255, 210, 238, 236, 255, 210, 238, 236, 255, 210, 238, 236, 255, 210, 238, 237, 255, 210, 238, 237, 255, 210, 238, 237, 255, 210, 238, 237, 255, 211, 239, 237, 255, 211, 239, 237, 255, 211, 239, 237, 255, 211, 239, 238, 255, 211, 239, 238, 255, 211, 239, 238, 255, 212, 239, 238, 255, 212, 239, 238, 255, 212, 239, 238, 255, 212, 239, 238, 255, 212, 239, 238, 255, 212, 239, 238, 255, 218, 241, 242, 255, 218, 241, 243, 255, 218, 241, 243, 255, 218, 241, 243, 255, 218, 241, 243, 255, 218, 241, 243, 255, 219, 241, 243, 255, 219, 241, 243, 255, 219, 241, 243, 255, 219, 242, 243, 255, 219, 242, 244, 255, 219, 242, 244, 255, 220, 242, 244, 255, 220, 242, 244, 255, 220, 242, 244, 255, 220, 242, 244, 255, 220, 242, 244, 255, 220, 242, 244, 255, 221, 242, 244, 255, 221, 242, 245, 255, 221, 242, 245, 255, 221, 242, 245, 255, 221, 242, 245, 255, 221, 242, 245, 255, 222, 242, 245, 255, 222, 242, 245, 255, 222, 242, 245, 255, 222, 242, 245, 255, 222, 243, 245, 255, 222, 243, 246, 255, 223, 243, 246, 255, 223, 243, 246, 255, 223, 243, 246, 255, 223, 243, 246, 255, 223, 243, 246, 255, 223, 243, 246, 255, 224, 243, 246, 255, 224, 243, 246, 255, 224, 243, 246, 255, 224, 243, 246, 255, 224, 243, 247, 255, 224, 243, 247, 255, 225, 243, 247, 255, 225, 243, 247, 255, 225, 243, 247, 255, 225, 243, 247, 255, 225, 244, 247, 255, 226, 244, 247, 255, 226, 244, 247, 255, 226, 244, 247, 255, 226, 244, 247, 255, 226, 244, 247, 255, 226, 244, 248, 255, 227, 244, 248, 255, 227, 244, 248, 255, 227, 244, 248, 255, 227, 244, 248, 255, 227, 244, 248, 255, 227, 244, 248, 255, 228, 244, 248, 255, 228, 244, 248, 255, 228, 244, 248, 255, 228, 244, 248, 255, 228, 244, 248, 255, 228, 245, 248, 255, 229, 245, 249, 255, 229, 245, 249, 255, 229, 245, 249, 255, 229, 245, 249, 255, 229, 245, 249, 255, 229, 245, 249, 255, 229, 245, 249, 255, 229, 245, 249, 255, 230, 245, 249, 255, 230, 245, 249, 255, 230, 245, 249, 255, 230, 245, 249, 255, 230, 245, 249, 255, 230, 245, 249, 255, 230, 245, 249, 255, 230, 245, 249, 255, 230, 245, 249, 255, 231, 245, 249, 255, 231, 245, 249, 255, 231, 245, 249, 255, 231, 245, 249, 255, 231, 245, 249, 255, 231, 246, 249, 255, 231, 246, 249, 255, 231, 246, 249, 255, 231, 246, 249, 255, 232, 246, 249, 255, 232, 246, 249, 255, 232, 246, 249, 255, 232, 246, 249, 255, 232, 246, 249, 255, 232, 246, 249, 255, 232, 246, 249, 255, 232, 246, 249, 255, 232, 246, 249, 255, 233, 246, 249, 255, 233, 246, 249, 255, 233, 246, 249, 255, 233, 246, 249, 255, 233, 246, 249, 255, 233, 246, 249, 255, 233, 246, 249, 255, 233, 246, 250, 255, 233, 246, 250, 255, 234, 246, 250, 255, 234, 247, 250, 255, 234, 247, 250, 255, 234, 247, 250, 255, 234, 247, 250, 255, 234, 247, 250, 255, 234, 247, 250, 255, 234, 247, 250, 255, 234, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 236, 247, 250, 255, 239, 249, 251, 255, 239, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 241, 249, 251, 255, 241, 249, 251, 255, 241, 249, 251, 255, 241, 249, 251, 255, 241, 249, 251, 255, 241, 249, 251, 255, 241, 249, 251, 255, 241, 250, 251, 255, 241, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 252, 255, 242, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 244, 250, 252, 255, 244, 250, 252, 255, 244, 250, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_BuGn_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 0, 68, 26, 0, 0, 70, 28, 24, 0, 72, 29, 49, 0, 75, 30, 74, 0, 77, 31, 99, 0, 80, 32, 124, 0, 82, 33, 149, 0, 93, 37, 174, 0, 95, 38, 199, 0, 98, 39, 224, 0, 100, 40, 249, 0, 102, 41, 255, 0, 105, 42, 255, 0, 107, 43, 255, 0, 109, 44, 255, 3, 111, 45, 255, 5, 112, 47, 255, 7, 114, 48, 255, 10, 116, 49, 255, 12, 117, 51, 255, 14, 119, 52, 255, 16, 120, 53, 255, 24, 128, 60, 255, 26, 129, 61, 255, 27, 131, 62, 255, 29, 132, 63, 255, 30, 134, 65, 255, 32, 135, 66, 255, 33, 137, 67, 255, 34, 138, 68, 255, 36, 140, 71, 255, 37, 142, 73, 255, 39, 143, 75, 255, 40, 145, 78, 255, 41, 147, 80, 255, 43, 148, 82, 255, 44, 150, 84, 255, 45, 151, 87, 255, 53, 160, 99, 255, 54, 162, 101, 255, 55, 163, 103, 255, 57, 165, 105, 255, 58, 166, 107, 255, 59, 168, 109, 255, 61, 169, 111, 255, 62, 171, 113, 255, 63, 172, 115, 255, 64, 173, 117, 255, 66, 174, 119, 255, 67, 175, 121, 255, 68, 176, 123, 255, 69, 177, 125, 255, 71, 178, 127, 255, 72, 178, 129, 255, 73, 179, 131, 255, 75, 180, 133, 255, 76, 181, 135, 255, 78, 181, 136, 255, 86, 186, 147, 255, 88, 187, 149, 255, 89, 188, 151, 255, 91, 188, 152, 255, 92, 189, 154, 255, 93, 190, 155, 255, 95, 190, 157, 255, 96, 191, 158, 255, 98, 192, 160, 255, 99, 192, 161, 255, 101, 193, 163, 255, 102, 194, 164, 255, 104, 195, 165, 255, 106, 195, 167, 255, 107, 196, 168, 255, 109, 197, 169, 255, 110, 197, 170, 255, 112, 198, 172, 255, 114, 199, 173, 255, 115, 200, 174, 255, 117, 200, 175, 255, 118, 201, 176, 255, 120, 202, 177, 255, 121, 202, 179, 255, 133, 207, 187, 255, 135, 208, 188, 255, 136, 209, 189, 255, 138, 209, 190, 255, 139, 210, 191, 255, 140, 210, 192, 255, 142, 211, 193, 255, 143, 212, 194, 255, 145, 212, 195, 255, 146, 213, 196, 255, 147, 213, 197, 255, 149, 214, 198, 255, 150, 215, 199, 255, 152, 215, 200, 255, 153, 216, 201, 255, 154, 216, 202, 255, 156, 217, 202, 255, 157, 217, 203, 255, 158, 218, 204, 255, 159, 218, 205, 255, 161, 219, 205, 255, 162, 219, 206, 255, 163, 220, 207, 255, 164, 220, 207, 255, 165, 221, 208, 255, 167, 221, 209, 255, 168, 222, 210, 255, 169, 222, 210, 255, 170, 222, 211, 255, 171, 223, 212, 255, 172, 223, 212, 255, 184, 228, 219, 255, 185, 228, 219, 255, 186, 229, 220, 255, 187, 229, 220, 255, 188, 230, 221, 255, 189, 230, 222, 255, 190, 230, 222, 255, 191, 231, 223, 255, 192, 231, 223, 255, 193, 232, 224, 255, 194, 232, 225, 255, 195, 232, 225, 255, 196, 233, 226, 255, 197, 233, 226, 255, 198, 233, 227, 255, 199, 234, 227, 255, 200, 234, 228, 255, 201, 235, 228, 255, 202, 235, 229, 255, 203, 235, 229, 255, 204, 236, 230, 255, 204, 236, 230, 255, 204, 236, 231, 255, 205, 236, 231, 255, 205, 236, 232, 255, 205, 236, 232, 255, 206, 237, 232, 255, 206, 237, 233, 255, 206, 237, 233, 255, 207, 237, 234, 255, 207, 237, 234, 255, 208, 237, 234, 255, 208, 238, 235, 255, 208, 238, 235, 255, 209, 238, 235, 255, 209, 238, 236, 255, 209, 238, 236, 255, 210, 238, 236, 255, 210, 238, 237, 255, 210, 238, 237, 255, 211, 239, 237, 255, 211, 239, 238, 255, 212, 239, 238, 255, 212, 239, 238, 255, 212, 239, 238, 255, 218, 241, 242, 255, 218, 241, 243, 255, 218, 241, 243, 255, 219, 241, 243, 255, 219, 242, 243, 255, 219, 242, 244, 255, 220, 242, 244, 255, 220, 242, 244, 255, 220, 242, 244, 255, 221, 242, 245, 255, 221, 242, 245, 255, 221, 242, 245, 255, 222, 242, 245, 255, 222, 243, 245, 255, 222, 243, 246, 255, 223, 243, 246, 255, 223, 243, 246, 255, 223, 243, 246, 255, 224, 243, 246, 255, 224, 243, 246, 255, 224, 243, 247, 255, 225, 243, 247, 255, 225, 243, 247, 255, 225, 243, 247, 255, 226, 244, 247, 255, 226, 244, 247, 255, 226, 244, 247, 255, 226, 244, 248, 255, 227, 244, 248, 255, 227, 244, 248, 255, 227, 244, 248, 255, 228, 244, 248, 255, 228, 244, 248, 255, 228, 244, 248, 255, 228, 244, 248, 255, 229, 245, 249, 255, 229, 245, 249, 255, 229, 245, 249, 255, 229, 245, 249, 255, 229, 245, 249, 255, 229, 245, 249, 255, 230, 245, 249, 255, 230, 245, 249, 255, 230, 245, 249, 255, 230, 245, 249, 255, 230, 245, 249, 255, 230, 245, 249, 255, 231, 245, 249, 255, 231, 245, 249, 255, 231, 245, 249, 255, 231, 245, 249, 255, 231, 246, 249, 255, 231, 246, 249, 255, 231, 246, 249, 255, 232, 246, 249, 255, 232, 246, 249, 255, 232, 246, 249, 255, 232, 246, 249, 255, 232, 246, 249, 255, 232, 246, 249, 255, 232, 246, 249, 255, 233, 246, 249, 255, 233, 246, 249, 255, 233, 246, 249, 255, 233, 246, 249, 255, 233, 246, 249, 255, 233, 246, 249, 255, 233, 246, 249, 255, 233, 246, 250, 255, 233, 246, 250, 255, 234, 247, 250, 255, 234, 247, 250, 255, 234, 247, 250, 255, 234, 247, 250, 255, 234, 247, 250, 255, 234, 247, 250, 255, 234, 247, 250, 255, 234, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 235, 247, 250, 255, 236, 247, 250, 255, 236, 247, 250, 255, 239, 249, 251, 255, 239, 249, 251, 255, 239, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 240, 249, 251, 255, 241, 249, 251, 255, 241, 249, 251, 255, 241, 249, 251, 255, 241, 249, 251, 255, 241, 249, 251, 255, 241, 249, 251, 255, 241, 249, 251, 255, 241, 249, 251, 255, 241, 249, 251, 255, 241, 249, 251, 255, 241, 250, 251, 255, 241, 250, 251, 255, 241, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 251, 255, 242, 250, 252, 255, 242, 250, 252, 255, 242, 250, 252, 255, 242, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 243, 250, 252, 255, 244, 250, 252, 255, 244, 250, 252, 255, 244, 250, 252, 255, 244, 250, 252, 255, 244, 250, 252, 255, 244, 250, 252, 255, 244, 250, 252, 255, 244, 250, 252, 255, 244, 250, 252, 255, 244, 250, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 244, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_BuGn_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
