/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/BrBG.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 0, 60, 48, 255, 1, 102, 94, 255, 53, 151, 143, 255, 128, 205, 193, 255, 199, 234, 229, 255, 245, 245, 245, 255, 246, 232, 195, 255, 223, 194, 125, 255, 191, 194, 45, 255, 140, 81, 10, 255, 84, 48, 5, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_BrBG_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 0, 60, 47, 0, 0, 60, 48, 7, 0, 60, 48, 14, 0, 61, 49, 22, 0, 61, 49, 29, 0, 61, 50, 37, 0, 62, 50, 44, 0, 62, 50, 52, 0, 63, 51, 59, 0, 63, 51, 67, 0, 63, 52, 74, 0, 64, 52, 82, 0, 64, 52, 89, 0, 65, 53, 97, 0, 65, 53, 104, 0, 65, 54, 112, 0, 66, 54, 119, 0, 66, 55, 127, 0, 67, 55, 134, 0, 67, 55, 141, 0, 67, 56, 149, 0, 68, 56, 156, 0, 68, 57, 164, 0, 69, 57, 171, 0, 69, 57, 179, 0, 69, 58, 186, 0, 70, 58, 194, 0, 70, 59, 201, 0, 71, 59, 209, 0, 71, 60, 216, 0, 71, 60, 224, 0, 72, 61, 231, 0, 72, 61, 239, 0, 73, 61, 246, 0, 73, 62, 254, 0, 73, 62, 255, 0, 74, 63, 255, 0, 74, 63, 255, 0, 75, 64, 255, 0, 75, 64, 255, 0, 75, 64, 255, 0, 76, 65, 255, 0, 76, 65, 255, 0, 77, 66, 255, 0, 77, 66, 255, 0, 78, 67, 255, 0, 78, 67, 255, 0, 78, 68, 255, 0, 79, 68, 255, 0, 79, 68, 255, 0, 80, 69, 255, 0, 80, 69, 255, 0, 80, 70, 255, 0, 81, 70, 255, 0, 81, 71, 255, 0, 82, 71, 255, 0, 82, 72, 255, 0, 82, 72, 255, 0, 83, 72, 255, 0, 83, 73, 255, 1, 84, 73, 255, 1, 84, 74, 255, 1, 85, 74, 255, 1, 85, 75, 255, 1, 85, 75, 255, 1, 86, 76, 255, 1, 86, 76, 255, 1, 87, 77, 255, 1, 87, 77, 255, 1, 87, 78, 255, 1, 88, 78, 255, 1, 88, 78, 255, 1, 89, 79, 255, 1, 89, 79, 255, 1, 90, 80, 255, 1, 90, 80, 255, 1, 90, 81, 255, 1, 91, 81, 255, 1, 91, 82, 255, 1, 92, 82, 255, 1, 92, 83, 255, 1, 92, 83, 255, 1, 93, 84, 255, 1, 93, 84, 255, 1, 94, 85, 255, 1, 94, 85, 255, 1, 95, 86, 255, 1, 95, 86, 255, 1, 95, 87, 255, 1, 96, 87, 255, 1, 96, 87, 255, 1, 97, 88, 255, 1, 97, 88, 255, 1, 98, 89, 255, 1, 98, 89, 255, 1, 98, 90, 255, 1, 99, 90, 255, 1, 99, 91, 255, 1, 100, 91, 255, 1, 100, 92, 255, 1, 100, 92, 255, 1, 101, 93, 255, 1, 101, 93, 255, 1, 102, 94, 255, 2, 102, 94, 255, 2, 103, 95, 255, 3, 103, 95, 255, 3, 104, 96, 255, 4, 104, 96, 255, 5, 105, 97, 255, 5, 105, 97, 255, 6, 105, 97, 255, 7, 106, 98, 255, 8, 106, 98, 255, 8, 107, 99, 255, 9, 107, 99, 255, 10, 108, 100, 255, 11, 108, 100, 255, 11, 109, 101, 255, 12, 109, 101, 255, 13, 110, 102, 255, 13, 110, 102, 255, 14, 111, 103, 255, 14, 111, 103, 255, 15, 112, 103, 255, 16, 112, 104, 255, 16, 112, 104, 255, 17, 113, 105, 255, 17, 113, 105, 255, 18, 114, 106, 255, 19, 114, 106, 255, 19, 115, 107, 255, 20, 115, 107, 255, 20, 116, 108, 255, 21, 116, 108, 255, 21, 117, 109, 255, 22, 117, 109, 255, 22, 118, 110, 255, 23, 118, 110, 255, 23, 119, 111, 255, 24, 119, 111, 255, 24, 120, 111, 255, 25, 120, 112, 255, 25, 121, 112, 255, 26, 121, 113, 255, 26, 121, 113, 255, 27, 122, 114, 255, 27, 122, 114, 255, 28, 123, 115, 255, 28, 123, 115, 255, 29, 124, 116, 255, 29, 124, 116, 255, 30, 125, 117, 255, 30, 125, 117, 255, 31, 126, 118, 255, 31, 126, 118, 255, 32, 127, 119, 255, 32, 127, 119, 255, 32, 128, 120, 255, 33, 128, 120, 255, 33, 129, 121, 255, 34, 129, 121, 255, 34, 130, 122, 255, 35, 130, 122, 255, 35, 131, 122, 255, 36, 131, 123, 255, 36, 132, 123, 255, 37, 132, 124, 255, 37, 133, 124, 255, 37, 133, 125, 255, 38, 133, 125, 255, 38, 134, 126, 255, 39, 134, 126, 255, 39, 135, 127, 255, 40, 135, 127, 255, 40, 136, 128, 255, 40, 136, 128, 255, 41, 137, 129, 255, 41, 137, 129, 255, 42, 138, 130, 255, 42, 138, 130, 255, 43, 139, 131, 255, 43, 139, 131, 255, 43, 140, 132, 255, 44, 140, 132, 255, 44, 141, 133, 255, 45, 141, 133, 255, 45, 142, 134, 255, 46, 142, 134, 255, 46, 143, 135, 255, 46, 143, 135, 255, 47, 144, 136, 255, 47, 144, 136, 255, 48, 145, 137, 255, 48, 145, 137, 255, 48, 146, 138, 255, 49, 146, 138, 255, 49, 147, 139, 255, 50, 147, 139, 255, 50, 148, 140, 255, 51, 148, 140, 255, 51, 149, 141, 255, 51, 149, 141, 255, 52, 150, 142, 255, 52, 150, 142, 255, 53, 151, 143, 255, 54, 151, 143, 255, 54, 152, 144, 255, 55, 152, 144, 255, 56, 153, 144, 255, 57, 153, 145, 255, 58, 154, 145, 255, 59, 154, 146, 255, 59, 155, 146, 255, 60, 155, 147, 255, 61, 156, 147, 255, 62, 156, 148, 255, 63, 157, 148, 255, 64, 157, 149, 255, 64, 158, 149, 255, 65, 158, 150, 255, 66, 159, 150, 255, 67, 159, 151, 255, 67, 160, 151, 255, 68, 160, 152, 255, 69, 161, 152, 255, 70, 161, 153, 255, 71, 162, 153, 255, 71, 163, 153, 255, 72, 163, 154, 255, 73, 164, 154, 255, 74, 164, 155, 255, 74, 165, 155, 255, 75, 165, 156, 255, 76, 166, 156, 255, 77, 166, 157, 255, 77, 167, 157, 255, 78, 167, 158, 255, 79, 168, 158, 255, 80, 168, 159, 255, 80, 169, 159, 255, 81, 169, 160, 255, 82, 170, 160, 255, 83, 170, 161, 255, 83, 171, 161, 255, 84, 171, 162, 255, 85, 172, 162, 255, 86, 172, 163, 255, 86, 173, 163, 255, 87, 173, 164, 255, 88, 174, 164, 255, 88, 175, 165, 255, 89, 175, 165, 255, 90, 176, 166, 255, 91, 176, 166, 255, 91, 177, 167, 255, 92, 177, 167, 255, 93, 178, 168, 255, 93, 178, 168, 255, 94, 179, 168, 255, 95, 179, 169, 255, 96, 180, 169, 255, 96, 180, 170, 255, 97, 181, 170, 255, 98, 181, 171, 255, 98, 182, 171, 255, 99, 182, 172, 255, 100, 183, 172, 255, 100, 184, 173, 255, 101, 184, 173, 255, 102, 185, 174, 255, 103, 185, 174, 255, 103, 186, 175, 255, 104, 186, 175, 255, 105, 187, 176, 255, 105, 187, 176, 255, 106, 188, 177, 255, 107, 188, 177, 255, 107, 189, 178, 255, 108, 189, 178, 255, 109, 190, 179, 255, 110, 190, 179, 255, 110, 191, 180, 255, 111, 192, 180, 255, 112, 192, 181, 255, 112, 193, 181, 255, 113, 193, 182, 255, 114, 194, 182, 255, 114, 194, 183, 255, 115, 195, 183, 255, 116, 195, 184, 255, 116, 196, 184, 255, 117, 196, 185, 255, 118, 197, 185, 255, 118, 197, 186, 255, 119, 198, 186, 255, 120, 198, 187, 255, 121, 199, 187, 255, 121, 200, 188, 255, 122, 200, 188, 255, 123, 201, 189, 255, 123, 201, 189, 255, 124, 202, 190, 255, 125, 202, 190, 255, 125, 203, 191, 255, 126, 203, 191, 255, 127, 204, 192, 255, 127, 204, 192, 255, 128, 205, 193, 255, 129, 205, 193, 255, 130, 205, 194, 255, 130, 206, 194, 255, 131, 206, 194, 255, 132, 206, 195, 255, 132, 206, 195, 255, 133, 207, 195, 255, 134, 207, 196, 255, 135, 207, 196, 255, 135, 208, 196, 255, 136, 208, 197, 255, 137, 208, 197, 255, 137, 208, 197, 255, 138, 209, 198, 255, 139, 209, 198, 255, 140, 209, 199, 255, 140, 210, 199, 255, 141, 210, 199, 255, 142, 210, 200, 255, 142, 210, 200, 255, 143, 211, 200, 255, 144, 211, 201, 255, 145, 211, 201, 255, 145, 212, 201, 255, 146, 212, 202, 255, 147, 212, 202, 255, 147, 212, 202, 255, 148, 213, 203, 255, 149, 213, 203, 255, 150, 213, 204, 255, 150, 214, 204, 255, 151, 214, 204, 255, 152, 214, 205, 255, 152, 214, 205, 255, 153, 215, 205, 255, 154, 215, 206, 255, 154, 215, 206, 255, 155, 216, 206, 255, 156, 216, 207, 255, 156, 216, 207, 255, 157, 216, 207, 255, 158, 217, 208, 255, 159, 217, 208, 255, 159, 217, 208, 255, 160, 218, 209, 255, 161, 218, 209, 255, 161, 218, 210, 255, 162, 218, 210, 255, 163, 219, 210, 255, 163, 219, 211, 255, 164, 219, 211, 255, 165, 220, 211, 255, 165, 220, 212, 255, 166, 220, 212, 255, 167, 220, 212, 255, 168, 221, 213, 255, 168, 221, 213, 255, 169, 221, 213, 255, 170, 222, 214, 255, 170, 222, 214, 255, 171, 222, 214, 255, 172, 222, 215, 255, 172, 223, 215, 255, 173, 223, 215, 255, 174, 223, 216, 255, 174, 223, 216, 255, 175, 224, 217, 255, 176, 224, 217, 255, 176, 224, 217, 255, 177, 225, 218, 255, 178, 225, 218, 255, 178, 225, 218, 255, 179, 225, 219, 255, 180, 226, 219, 255, 181, 226, 219, 255, 181, 226, 220, 255, 182, 227, 220, 255, 183, 227, 220, 255, 183, 227, 221, 255, 184, 227, 221, 255, 185, 228, 221, 255, 185, 228, 222, 255, 186, 228, 222, 255, 187, 229, 222, 255, 187, 229, 223, 255, 188, 229, 223, 255, 189, 229, 223, 255, 189, 230, 224, 255, 190, 230, 224, 255, 191, 230, 225, 255, 191, 231, 225, 255, 192, 231, 225, 255, 193, 231, 226, 255, 193, 231, 226, 255, 194, 232, 226, 255, 195, 232, 227, 255, 195, 232, 227, 255, 196, 232, 227, 255, 197, 233, 228, 255, 197, 233, 228, 255, 198, 233, 228, 255, 250, 218, 227, 255, 250, 219, 228, 255, 250, 219, 229, 255, 249, 219, 230, 255, 249, 220, 230, 255, 248, 220, 231, 255, 248, 220, 232, 255, 248, 221, 233, 255, 247, 221, 233, 255, 247, 221, 234, 255, 246, 222, 235, 255, 246, 222, 236, 255, 245, 222, 236, 255, 245, 223, 237, 255, 244, 223, 238, 255, 244, 223, 238, 255, 243, 224, 239, 255, 243, 224, 239, 255, 242, 224, 240, 255, 242, 225, 240, 255, 241, 225, 241, 255, 241, 226, 241, 255, 240, 226, 242, 255, 240, 226, 242, 255, 239, 227, 243, 255, 239, 227, 243, 255, 238, 227, 243, 255, 238, 228, 244, 255, 237, 228, 244, 255, 237, 228, 245, 255, 236, 229, 245, 255, 236, 229, 245, 255, 236, 230, 245, 255, 235, 230, 246, 255, 235, 230, 246, 255, 234, 231, 246, 255, 234, 231, 246, 255, 234, 231, 246, 255, 233, 232, 247, 255, 233, 232, 247, 255, 233, 232, 247, 255, 232, 233, 247, 255, 232, 233, 247, 255, 232, 233, 247, 255, 231, 234, 247, 255, 231, 234, 247, 255, 231, 234, 247, 255, 231, 235, 247, 255, 231, 235, 247, 255, 230, 235, 247, 255, 230, 235, 247, 255, 230, 236, 247, 255, 230, 236, 247, 255, 230, 236, 247, 255, 230, 237, 247, 255, 230, 237, 247, 255, 230, 237, 247, 255, 230, 237, 247, 255, 230, 238, 247, 255, 230, 238, 247, 255, 230, 238, 246, 255, 230, 238, 246, 255, 230, 239, 246, 255, 230, 239, 246, 255, 230, 239, 246, 255, 231, 239, 246, 255, 231, 239, 246, 255, 231, 240, 246, 255, 231, 240, 245, 255, 231, 240, 245, 255, 232, 240, 245, 255, 232, 240, 245, 255, 232, 241, 245, 255, 232, 241, 245, 255, 233, 241, 245, 255, 233, 241, 245, 255, 233, 241, 244, 255, 234, 241, 244, 255, 234, 242, 244, 255, 234, 242, 244, 255, 235, 242, 244, 255, 235, 242, 244, 255, 236, 242, 244, 255, 236, 242, 244, 255, 236, 242, 244, 255, 237, 243, 244, 255, 237, 243, 244, 255, 238, 243, 244, 255, 238, 243, 244, 255, 239, 243, 244, 255, 239, 243, 244, 255, 240, 243, 244, 255, 240, 243, 244, 255, 240, 244, 244, 255, 241, 244, 244, 255, 241, 244, 244, 255, 242, 244, 244, 255, 242, 244, 244, 255, 243, 244, 244, 255, 243, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 245, 245, 255, 245, 244, 244, 255, 245, 244, 244, 255, 245, 244, 244, 255, 246, 244, 244, 255, 246, 243, 244, 255, 246, 243, 244, 255, 247, 243, 243, 255, 247, 243, 243, 255, 247, 242, 243, 255, 247, 242, 243, 255, 248, 242, 243, 255, 248, 242, 242, 255, 248, 241, 242, 255, 249, 241, 242, 255, 249, 241, 241, 255, 249, 241, 241, 255, 250, 240, 241, 255, 250, 240, 241, 255, 250, 240, 240, 255, 251, 240, 240, 255, 251, 239, 240, 255, 251, 239, 239, 255, 251, 239, 239, 255, 252, 239, 238, 255, 252, 239, 238, 255, 252, 238, 238, 255, 253, 238, 237, 255, 253, 238, 237, 255, 253, 238, 236, 255, 253, 237, 236, 255, 254, 237, 236, 255, 254, 237, 235, 255, 254, 237, 235, 255, 255, 237, 234, 255, 255, 236, 234, 255, 255, 236, 233, 255, 255, 236, 233, 255, 255, 236, 232, 255, 255, 236, 232, 255, 255, 235, 231, 255, 255, 235, 231, 255, 255, 235, 230, 255, 255, 235, 230, 255, 255, 235, 229, 255, 255, 235, 228, 255, 255, 234, 228, 255, 255, 234, 227, 255, 255, 234, 227, 255, 255, 234, 226, 255, 255, 234, 226, 255, 255, 234, 225, 255, 255, 233, 224, 255, 255, 233, 224, 255, 255, 233, 223, 255, 255, 233, 223, 255, 255, 233, 222, 255, 255, 233, 221, 255, 255, 233, 221, 255, 255, 232, 220, 255, 255, 232, 220, 255, 255, 232, 219, 255, 255, 232, 218, 255, 255, 232, 218, 255, 255, 232, 217, 255, 255, 232, 216, 255, 255, 232, 216, 255, 255, 232, 215, 255, 255, 232, 214, 255, 255, 232, 214, 255, 255, 231, 213, 255, 255, 231, 213, 255, 255, 231, 212, 255, 255, 231, 211, 255, 255, 231, 211, 255, 255, 231, 210, 255, 255, 231, 209, 255, 255, 231, 209, 255, 255, 231, 208, 255, 255, 231, 208, 255, 255, 231, 207, 255, 255, 231, 206, 255, 255, 231, 206, 255, 255, 231, 205, 255, 254, 231, 204, 255, 254, 231, 204, 255, 253, 231, 203, 255, 253, 231, 203, 255, 253, 231, 202, 255, 252, 231, 202, 255, 252, 231, 201, 255, 251, 231, 200, 255, 251, 231, 200, 255, 251, 231, 199, 255, 250, 231, 199, 255, 250, 231, 198, 255, 249, 231, 198, 255, 249, 231, 197, 255, 248, 231, 197, 255, 247, 231, 196, 255, 247, 231, 196, 255, 246, 231, 195, 255, 246, 231, 195, 255, 245, 231, 194, 255, 245, 231, 193, 255, 245, 231, 193, 255, 245, 230, 192, 255, 244, 230, 191, 255, 244, 229, 191, 255, 244, 229, 190, 255, 244, 229, 189, 255, 244, 228, 189, 255, 243, 228, 188, 255, 243, 228, 187, 255, 243, 227, 186, 255, 243, 227, 186, 255, 242, 226, 185, 255, 242, 226, 184, 255, 242, 226, 184, 255, 242, 225, 183, 255, 242, 225, 182, 255, 241, 225, 182, 255, 241, 224, 181, 255, 241, 224, 180, 255, 241, 224, 180, 255, 240, 223, 179, 255, 240, 223, 178, 255, 240, 222, 177, 255, 240, 222, 177, 255, 239, 222, 176, 255, 239, 221, 175, 255, 239, 221, 175, 255, 239, 221, 174, 255, 239, 220, 173, 255, 238, 220, 173, 255, 238, 219, 172, 255, 238, 219, 171, 255, 238, 219, 171, 255, 237, 218, 170, 255, 237, 218, 169, 255, 237, 218, 169, 255, 237, 217, 168, 255, 237, 217, 167, 255, 236, 216, 166, 255, 236, 216, 166, 255, 236, 216, 165, 255, 236, 215, 164, 255, 235, 215, 164, 255, 235, 215, 163, 255, 235, 214, 162, 255, 235, 214, 162, 255, 235, 213, 161, 255, 234, 213, 160, 255, 234, 213, 160, 255, 234, 212, 159, 255, 234, 212, 158, 255, 233, 212, 158, 255, 233, 211, 157, 255, 233, 211, 156, 255, 233, 211, 156, 255, 233, 210, 155, 255, 232, 210, 154, 255, 232, 209, 153, 255, 232, 209, 153, 255, 232, 209, 152, 255, 231, 208, 151, 255, 231, 208, 151, 255, 231, 208, 150, 255, 231, 207, 149, 255, 231, 207, 149, 255, 230, 206, 148, 255, 230, 206, 147, 255, 230, 206, 147, 255, 230, 205, 146, 255, 229, 205, 145, 255, 229, 205, 145, 255, 229, 204, 144, 255, 229, 204, 143, 255, 228, 203, 143, 255, 228, 203, 142, 255, 228, 203, 141, 255, 228, 202, 141, 255, 228, 202, 140, 255, 227, 202, 139, 255, 227, 201, 139, 255, 227, 201, 138, 255, 227, 200, 137, 255, 226, 200, 137, 255, 226, 200, 136, 255, 226, 199, 135, 255, 226, 199, 134, 255, 226, 199, 134, 255, 225, 198, 133, 255, 225, 198, 132, 255, 225, 198, 132, 255, 225, 197, 131, 255, 224, 197, 130, 255, 224, 196, 130, 255, 224, 196, 129, 255, 224, 196, 128, 255, 224, 195, 128, 255, 223, 195, 127, 255, 223, 195, 126, 255, 223, 194, 126, 255, 223, 194, 125, 255, 222, 193, 124, 255, 222, 193, 124, 255, 222, 193, 123, 255, 222, 193, 122, 255, 222, 193, 121, 255, 222, 193, 121, 255, 222, 193, 120, 255, 222, 193, 119, 255, 221, 193, 119, 255, 221, 193, 118, 255, 221, 193, 117, 255, 221, 193, 116, 255, 221, 193, 116, 255, 221, 193, 115, 255, 220, 193, 114, 255, 220, 193, 114, 255, 220, 193, 113, 255, 220, 193, 112, 255, 220, 193, 111, 255, 219, 193, 111, 255, 219, 193, 110, 255, 219, 193, 109, 255, 219, 193, 109, 255, 219, 193, 108, 255, 218, 193, 107, 255, 218, 193, 106, 255, 218, 193, 106, 255, 218, 193, 105, 255, 217, 193, 104, 255, 217, 193, 103, 255, 217, 193, 103, 255, 217, 193, 102, 255, 217, 192, 101, 255, 216, 192, 101, 255, 216, 192, 100, 255, 216, 192, 99, 255, 216, 192, 98, 255, 215, 192, 98, 255, 215, 192, 97, 255, 215, 192, 96, 255, 214, 192, 95, 255, 214, 192, 95, 255, 214, 192, 94, 255, 214, 192, 93, 255, 213, 192, 92, 255, 213, 192, 92, 255, 213, 192, 91, 255, 212, 192, 90, 255, 212, 192, 89, 255, 212, 192, 89, 255, 212, 192, 88, 255, 211, 192, 87, 255, 211, 192, 86, 255, 211, 192, 86, 255, 210, 192, 85, 255, 210, 192, 84, 255, 210, 192, 83, 255, 209, 192, 83, 255, 209, 192, 82, 255, 209, 192, 81, 255, 208, 192, 80, 255, 208, 192, 80, 255, 208, 192, 79, 255, 207, 192, 78, 255, 207, 192, 77, 255, 207, 192, 76, 255, 206, 193, 76, 255, 206, 193, 75, 255, 205, 193, 74, 255, 205, 193, 73, 255, 205, 193, 73, 255, 204, 193, 72, 255, 204, 193, 71, 255, 204, 193, 70, 255, 203, 193, 69, 255, 203, 193, 69, 255, 202, 193, 68, 255, 202, 193, 67, 255, 202, 193, 66, 255, 201, 193, 65, 255, 201, 193, 64, 255, 200, 193, 64, 255, 200, 193, 63, 255, 199, 193, 62, 255, 199, 193, 61, 255, 199, 193, 60, 255, 198, 193, 59, 255, 198, 193, 59, 255, 197, 193, 58, 255, 197, 193, 57, 255, 196, 193, 56, 255, 196, 193, 55, 255, 195, 193, 54, 255, 195, 193, 53, 255, 194, 193, 52, 255, 194, 193, 51, 255, 194, 193, 50, 255, 193, 193, 50, 255, 193, 193, 49, 255, 192, 193, 48, 255, 192, 193, 47, 255, 191, 193, 46, 255, 191, 193, 45, 255, 190, 193, 44, 255, 190, 191, 43, 255, 190, 190, 42, 255, 190, 189, 42, 255, 190, 188, 41, 255, 189, 187, 40, 255, 189, 185, 39, 255, 189, 184, 38, 255, 189, 183, 38, 255, 188, 182, 37, 255, 188, 181, 36, 255, 188, 179, 36, 255, 188, 178, 35, 255, 187, 177, 34, 255, 187, 176, 34, 255, 187, 175, 33, 255, 186, 174, 32, 255, 186, 172, 32, 255, 186, 171, 31, 255, 185, 170, 30, 255, 185, 169, 30, 255, 185, 168, 29, 255, 184, 167, 28, 255, 184, 165, 28, 255, 184, 164, 27, 255, 183, 163, 27, 255, 183, 162, 26, 255, 183, 161, 25, 255, 182, 160, 25, 255, 182, 158, 24, 255, 182, 157, 24, 255, 181, 156, 23, 255, 181, 155, 23, 255, 180, 154, 22, 255, 180, 153, 22, 255, 180, 152, 21, 255, 179, 150, 21, 255, 179, 149, 20, 255, 178, 148, 20, 255, 178, 147, 20, 255, 177, 146, 19, 255, 177, 145, 19, 255, 176, 144, 18, 255, 176, 142, 18, 255, 176, 141, 17, 255, 175, 140, 17, 255, 175, 139, 17, 255, 174, 138, 16, 255, 174, 137, 16, 255, 173, 136, 16, 255, 173, 135, 15, 255, 172, 134, 15, 255, 172, 132, 15, 255, 171, 131, 14, 255, 170, 130, 14, 255, 170, 129, 14, 255, 169, 128, 14, 255, 169, 127, 13, 255, 168, 126, 13, 255, 168, 125, 13, 255, 167, 124, 13, 255, 167, 123, 12, 255, 166, 121, 12, 255, 165, 120, 12, 255, 165, 119, 12, 255, 164, 118, 12, 255, 164, 117, 11, 255, 163, 116, 11, 255, 163, 115, 11, 255, 162, 114, 11, 255, 161, 113, 11, 255, 161, 112, 11, 255, 160, 111, 11, 255, 159, 110, 11, 255, 159, 109, 10, 255, 158, 108, 10, 255, 158, 107, 10, 255, 157, 106, 10, 255, 156, 104, 10, 255, 156, 103, 10, 255, 155, 102, 10, 255, 154, 101, 10, 255, 154, 100, 10, 255, 153, 99, 10, 255, 152, 98, 10, 255, 152, 97, 10, 255, 151, 96, 10, 255, 150, 95, 10, 255, 149, 94, 10, 255, 149, 93, 10, 255, 148, 92, 10, 255, 147, 91, 10, 255, 147, 90, 10, 255, 146, 89, 10, 255, 145, 88, 10, 255, 144, 87, 10, 255, 144, 86, 10, 255, 143, 85, 10, 255, 142, 84, 10, 255, 141, 83, 10, 255, 141, 82, 10, 255, 140, 81, 10, 255, 139, 80, 9, 255, 139, 80, 9, 255, 138, 80, 9, 255, 138, 79, 9, 255, 137, 79, 9, 255, 136, 79, 9, 255, 136, 78, 9, 255, 135, 78, 9, 255, 135, 78, 9, 255, 134, 77, 9, 255, 134, 77, 9, 255, 133, 77, 9, 255, 132, 76, 9, 255, 132, 76, 9, 255, 131, 76, 9, 255, 131, 75, 9, 255, 130, 75, 9, 255, 130, 75, 9, 255, 129, 74, 9, 255, 128, 74, 9, 255, 128, 74, 9, 255, 127, 73, 9, 255, 127, 73, 9, 255, 126, 73, 9, 255, 126, 72, 8, 255, 125, 72, 8, 255, 125, 72, 8, 255, 124, 71, 8, 255, 123, 71, 8, 255, 123, 71, 8, 255, 122, 70, 8, 255, 122, 70, 8, 255, 121, 70, 8, 255, 121, 69, 8, 255, 120, 69, 8, 255, 120, 69, 8, 255, 119, 68, 8, 255, 118, 68, 8, 255, 118, 68, 8, 255, 117, 68, 8, 255, 117, 67, 8, 255, 116, 67, 8, 255, 116, 67, 8, 255, 115, 66, 8, 255, 115, 66, 8, 255, 114, 66, 8, 255, 113, 65, 8, 255, 113, 65, 8, 255, 112, 65, 8, 255, 112, 64, 7, 255, 111, 64, 7, 255, 111, 64, 7, 255, 110, 63, 7, 255, 110, 63, 7, 255, 109, 63, 7, 255, 108, 62, 7, 255, 108, 62, 7, 255, 107, 62, 7, 255, 107, 61, 7, 255, 106, 61, 7, 255, 106, 61, 7, 255, 105, 60, 7, 255, 105, 60, 7, 255, 104, 60, 7, 255, 104, 59, 7, 255, 103, 59, 7, 255, 103, 59, 7, 255, 102, 58, 7, 255, 101, 58, 7, 255, 101, 58, 7, 255, 100, 58, 7, 255, 100, 57, 7, 255, 99, 57, 7, 255, 99, 57, 7, 255, 98, 56, 7, 255, 98, 56, 6, 255, 97, 56, 6, 255, 97, 55, 6, 255, 96, 55, 6, 255, 96, 55, 6, 255, 95, 54, 6, 255, 94, 54, 6, 255, 94, 54, 6, 255, 93, 53, 6, 255, 93, 53, 6, 255, 92, 53, 6, 255, 92, 52, 6, 255, 91, 52, 6, 255, 91, 52, 6, 255, 90, 52, 6, 255, 90, 51, 6, 255, 89, 51, 5, 255, 89, 51, 5, 255, 88, 50, 5, 255, 88, 50, 5, 255, 87, 50, 5, 255, 87, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 84, 48, 5, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_BrBG_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 0, 60, 47, 0, 0, 60, 48, 7, 0, 60, 48, 14, 0, 60, 48, 22, 0, 61, 49, 29, 0, 61, 49, 37, 0, 61, 49, 44, 0, 62, 50, 52, 0, 62, 50, 59, 0, 62, 50, 67, 0, 63, 51, 74, 0, 63, 51, 82, 0, 63, 51, 89, 0, 64, 52, 97, 0, 64, 52, 104, 0, 64, 52, 112, 0, 65, 53, 119, 0, 65, 53, 127, 0, 65, 53, 134, 0, 66, 54, 141, 0, 66, 54, 149, 0, 66, 54, 156, 0, 66, 55, 164, 0, 67, 55, 171, 0, 67, 55, 179, 0, 67, 56, 186, 0, 68, 56, 194, 0, 68, 57, 201, 0, 68, 57, 209, 0, 69, 57, 216, 0, 69, 58, 224, 0, 69, 58, 231, 0, 70, 58, 239, 0, 70, 59, 246, 0, 70, 59, 254, 0, 71, 59, 255, 0, 71, 60, 255, 0, 71, 60, 255, 0, 72, 60, 255, 0, 72, 61, 255, 0, 72, 61, 255, 0, 73, 61, 255, 0, 73, 62, 255, 0, 73, 62, 255, 0, 74, 62, 255, 0, 74, 63, 255, 0, 74, 63, 255, 0, 75, 64, 255, 0, 75, 64, 255, 0, 75, 64, 255, 0, 76, 65, 255, 0, 76, 65, 255, 0, 85, 75, 255, 0, 85, 75, 255, 0, 85, 75, 255, 0, 86, 76, 255, 0, 86, 76, 255, 0, 86, 76, 255, 0, 87, 77, 255, 0, 87, 77, 255, 1, 87, 77, 255, 1, 88, 78, 255, 1, 88, 78, 255, 1, 88, 79, 255, 1, 89, 79, 255, 1, 89, 79, 255, 1, 89, 80, 255, 1, 90, 80, 255, 1, 90, 80, 255, 1, 90, 81, 255, 1, 91, 81, 255, 1, 91, 81, 255, 1, 91, 82, 255, 1, 92, 82, 255, 1, 92, 83, 255, 1, 92, 83, 255, 1, 93, 83, 255, 1, 93, 84, 255, 1, 93, 84, 255, 1, 94, 84, 255, 1, 94, 85, 255, 1, 94, 85, 255, 1, 95, 86, 255, 1, 95, 86, 255, 1, 95, 86, 255, 1, 96, 87, 255, 1, 96, 87, 255, 1, 96, 88, 255, 1, 97, 88, 255, 1, 97, 88, 255, 1, 97, 89, 255, 1, 98, 89, 255, 1, 98, 89, 255, 1, 98, 90, 255, 1, 99, 90, 255, 1, 99, 91, 255, 1, 99, 91, 255, 1, 100, 91, 255, 1, 100, 92, 255, 1, 100, 92, 255, 1, 101, 93, 255, 1, 101, 93, 255, 1, 101, 93, 255, 1, 102, 94, 255, 1, 102, 94, 255, 2, 102, 94, 255, 2, 103, 95, 255, 3, 103, 95, 255, 3, 104, 96, 255, 4, 104, 96, 255, 4, 104, 96, 255, 5, 105, 97, 255, 6, 105, 97, 255, 6, 105, 97, 255, 7, 106, 98, 255, 7, 106, 98, 255, 8, 107, 99, 255, 9, 107, 99, 255, 9, 107, 99, 255, 10, 108, 100, 255, 10, 108, 100, 255, 11, 108, 100, 255, 11, 109, 101, 255, 12, 109, 101, 255, 12, 110, 101, 255, 13, 110, 102, 255, 13, 110, 102, 255, 14, 111, 103, 255, 14, 111, 103, 255, 15, 111, 103, 255, 15, 112, 104, 255, 15, 112, 104, 255, 16, 113, 104, 255, 16, 113, 105, 255, 17, 113, 105, 255, 17, 114, 106, 255, 18, 114, 106, 255, 18, 114, 106, 255, 18, 115, 107, 255, 19, 115, 107, 255, 19, 116, 108, 255, 20, 116, 108, 255, 20, 116, 108, 255, 20, 117, 109, 255, 21, 117, 109, 255, 21, 117, 109, 255, 22, 118, 110, 255, 22, 118, 110, 255, 22, 119, 111, 255, 23, 119, 111, 255, 23, 119, 111, 255, 23, 120, 112, 255, 24, 120, 112, 255, 24, 121, 112, 255, 35, 131, 123, 255, 35, 131, 123, 255, 36, 131, 123, 255, 36, 132, 124, 255, 36, 132, 124, 255, 37, 133, 125, 255, 37, 133, 125, 255, 38, 133, 125, 255, 38, 134, 126, 255, 38, 134, 126, 255, 39, 135, 126, 255, 39, 135, 127, 255, 39, 135, 127, 255, 40, 136, 128, 255, 40, 136, 128, 255, 40, 136, 128, 255, 41, 137, 129, 255, 41, 137, 129, 255, 41, 138, 130, 255, 42, 138, 130, 255, 42, 138, 130, 255, 43, 139, 131, 255, 43, 139, 131, 255, 43, 140, 132, 255, 44, 140, 132, 255, 44, 140, 132, 255, 44, 141, 133, 255, 45, 141, 133, 255, 45, 142, 133, 255, 45, 142, 134, 255, 46, 142, 134, 255, 46, 143, 135, 255, 46, 143, 135, 255, 47, 144, 135, 255, 47, 144, 136, 255, 47, 144, 136, 255, 48, 145, 137, 255, 48, 145, 137, 255, 48, 145, 137, 255, 49, 146, 138, 255, 49, 146, 138, 255, 49, 147, 139, 255, 50, 147, 139, 255, 50, 147, 139, 255, 50, 148, 140, 255, 51, 148, 140, 255, 51, 149, 141, 255, 51, 149, 141, 255, 52, 149, 141, 255, 52, 150, 142, 255, 52, 150, 142, 255, 53, 151, 143, 255, 53, 151, 143, 255, 54, 151, 143, 255, 55, 152, 144, 255, 55, 152, 144, 255, 56, 153, 144, 255, 57, 153, 145, 255, 57, 153, 145, 255, 58, 154, 146, 255, 59, 154, 146, 255, 59, 155, 146, 255, 60, 155, 147, 255, 61, 156, 147, 255, 61, 156, 147, 255, 62, 156, 148, 255, 63, 157, 148, 255, 63, 157, 149, 255, 64, 158, 149, 255, 64, 158, 149, 255, 65, 158, 150, 255, 66, 159, 150, 255, 66, 159, 151, 255, 67, 160, 151, 255, 68, 160, 151, 255, 68, 161, 152, 255, 69, 161, 152, 255, 69, 161, 152, 255, 70, 162, 153, 255, 71, 162, 153, 255, 71, 163, 154, 255, 72, 163, 154, 255, 72, 163, 154, 255, 73, 164, 155, 255, 74, 164, 155, 255, 74, 165, 156, 255, 75, 165, 156, 255, 75, 166, 156, 255, 76, 166, 157, 255, 77, 166, 157, 255, 77, 167, 157, 255, 78, 167, 158, 255, 78, 168, 158, 255, 79, 168, 159, 255, 80, 168, 159, 255, 80, 169, 159, 255, 81, 169, 160, 255, 81, 170, 160, 255, 82, 170, 161, 255, 82, 171, 161, 255, 83, 171, 161, 255, 84, 171, 162, 255, 99, 183, 172, 255, 100, 183, 173, 255, 100, 183, 173, 255, 101, 184, 173, 255, 101, 184, 174, 255, 102, 185, 174, 255, 103, 185, 174, 255, 103, 186, 175, 255, 104, 186, 175, 255, 104, 186, 176, 255, 105, 187, 176, 255, 105, 187, 176, 255, 106, 188, 177, 255, 106, 188, 177, 255, 107, 189, 178, 255, 108, 189, 178, 255, 108, 189, 178, 255, 109, 190, 179, 255, 109, 190, 179, 255, 110, 191, 180, 255, 110, 191, 180, 255, 111, 192, 180, 255, 111, 192, 181, 255, 112, 192, 181, 255, 113, 193, 182, 255, 113, 193, 182, 255, 114, 194, 182, 255, 114, 194, 183, 255, 115, 195, 183, 255, 115, 195, 184, 255, 116, 195, 184, 255, 116, 196, 184, 255, 117, 196, 185, 255, 118, 197, 185, 255, 118, 197, 186, 255, 119, 198, 186, 255, 119, 198, 186, 255, 120, 198, 187, 255, 120, 199, 187, 255, 121, 199, 188, 255, 121, 200, 188, 255, 122, 200, 188, 255, 122, 201, 189, 255, 123, 201, 189, 255, 124, 201, 190, 255, 124, 202, 190, 255, 125, 202, 190, 255, 125, 203, 191, 255, 126, 203, 191, 255, 126, 204, 192, 255, 127, 204, 192, 255, 127, 204, 192, 255, 128, 205, 193, 255, 129, 205, 193, 255, 129, 205, 193, 255, 130, 205, 194, 255, 130, 206, 194, 255, 131, 206, 194, 255, 131, 206, 194, 255, 132, 206, 195, 255, 133, 207, 195, 255, 133, 207, 195, 255, 134, 207, 196, 255, 134, 207, 196, 255, 135, 207, 196, 255, 135, 208, 196, 255, 136, 208, 197, 255, 137, 208, 197, 255, 137, 208, 197, 255, 138, 209, 198, 255, 138, 209, 198, 255, 139, 209, 198, 255, 139, 209, 198, 255, 140, 209, 199, 255, 141, 210, 199, 255, 141, 210, 199, 255, 142, 210, 200, 255, 142, 210, 200, 255, 143, 211, 200, 255, 143, 211, 200, 255, 144, 211, 201, 255, 145, 211, 201, 255, 145, 212, 201, 255, 146, 212, 202, 255, 146, 212, 202, 255, 147, 212, 202, 255, 147, 212, 202, 255, 148, 213, 203, 255, 148, 213, 203, 255, 149, 213, 203, 255, 150, 213, 204, 255, 150, 214, 204, 255, 151, 214, 204, 255, 151, 214, 204, 255, 152, 214, 205, 255, 152, 214, 205, 255, 153, 215, 205, 255, 153, 215, 206, 255, 154, 215, 206, 255, 155, 215, 206, 255, 155, 216, 206, 255, 156, 216, 207, 255, 156, 216, 207, 255, 171, 222, 214, 255, 172, 222, 215, 255, 172, 223, 215, 255, 173, 223, 215, 255, 173, 223, 216, 255, 174, 223, 216, 255, 174, 223, 216, 255, 175, 224, 216, 255, 175, 224, 217, 255, 176, 224, 217, 255, 176, 224, 217, 255, 177, 225, 218, 255, 178, 225, 218, 255, 178, 225, 218, 255, 179, 225, 218, 255, 179, 225, 219, 255, 180, 226, 219, 255, 180, 226, 219, 255, 181, 226, 219, 255, 181, 226, 220, 255, 182, 227, 220, 255, 182, 227, 220, 255, 183, 227, 221, 255, 184, 227, 221, 255, 184, 228, 221, 255, 185, 228, 221, 255, 185, 228, 222, 255, 186, 228, 222, 255, 186, 228, 222, 255, 187, 229, 223, 255, 187, 229, 223, 255, 188, 229, 223, 255, 188, 229, 223, 255, 189, 230, 224, 255, 190, 230, 224, 255, 190, 230, 224, 255, 191, 230, 224, 255, 191, 230, 225, 255, 192, 231, 225, 255, 192, 231, 225, 255, 193, 231, 226, 255, 193, 231, 226, 255, 194, 232, 226, 255, 194, 232, 226, 255, 195, 232, 227, 255, 195, 232, 227, 255, 196, 232, 227, 255, 197, 233, 228, 255, 197, 233, 228, 255, 198, 233, 228, 255, 198, 233, 228, 255, 240, 221, 227, 255, 240, 222, 228, 255, 239, 222, 229, 255, 239, 222, 229, 255, 239, 222, 230, 255, 238, 223, 231, 255, 238, 223, 231, 255, 238, 223, 232, 255, 237, 223, 232, 255, 237, 224, 233, 255, 237, 224, 234, 255, 236, 224, 234, 255, 236, 225, 235, 255, 235, 225, 235, 255, 235, 225, 236, 255, 235, 225, 236, 255, 234, 226, 237, 255, 234, 226, 237, 255, 233, 226, 238, 255, 233, 227, 238, 255, 233, 227, 238, 255, 232, 227, 239, 255, 232, 227, 239, 255, 231, 228, 240, 255, 231, 228, 240, 255, 231, 228, 240, 255, 230, 229, 240, 255, 230, 229, 241, 255, 230, 229, 241, 255, 229, 229, 241, 255, 229, 230, 242, 255, 228, 230, 242, 255, 228, 230, 242, 255, 228, 231, 242, 255, 227, 231, 242, 255, 227, 231, 243, 255, 227, 231, 243, 255, 227, 232, 243, 255, 226, 232, 243, 255, 226, 232, 243, 255, 226, 233, 243, 255, 226, 233, 243, 255, 225, 233, 243, 255, 225, 233, 243, 255, 225, 234, 243, 255, 225, 234, 243, 255, 225, 234, 243, 255, 224, 234, 243, 255, 224, 235, 243, 255, 224, 235, 243, 255, 224, 235, 243, 255, 233, 237, 247, 255, 233, 238, 247, 255, 233, 238, 247, 255, 233, 238, 247, 255, 233, 238, 246, 255, 233, 239, 246, 255, 233, 239, 246, 255, 233, 239, 246, 255, 233, 239, 246, 255, 233, 239, 246, 255, 233, 240, 246, 255, 233, 240, 246, 255, 233, 240, 246, 255, 233, 240, 246, 255, 233, 240, 246, 255, 234, 240, 245, 255, 234, 241, 245, 255, 234, 241, 245, 255, 234, 241, 245, 255, 234, 241, 245, 255, 234, 241, 245, 255, 235, 241, 245, 255, 235, 241, 245, 255, 235, 242, 245, 255, 235, 242, 245, 255, 236, 242, 244, 255, 236, 242, 244, 255, 236, 242, 244, 255, 236, 242, 244, 255, 237, 242, 244, 255, 237, 243, 244, 255, 237, 243, 244, 255, 238, 243, 244, 255, 238, 243, 244, 255, 238, 243, 244, 255, 239, 243, 244, 255, 239, 243, 244, 255, 239, 243, 244, 255, 240, 243, 244, 255, 240, 243, 244, 255, 241, 244, 244, 255, 241, 244, 244, 255, 241, 244, 244, 255, 242, 244, 244, 255, 242, 244, 244, 255, 242, 244, 244, 255, 243, 244, 244, 255, 243, 244, 244, 255, 243, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 245, 245, 255, 245, 244, 244, 255, 245, 244, 244, 255, 245, 244, 244, 255, 245, 244, 244, 255, 246, 244, 244, 255, 246, 243, 244, 255, 246, 243, 244, 255, 246, 243, 243, 255, 247, 243, 243, 255, 247, 243, 243, 255, 247, 242, 243, 255, 247, 242, 243, 255, 248, 242, 243, 255, 248, 242, 242, 255, 248, 242, 242, 255, 248, 241, 242, 255, 249, 241, 242, 255, 249, 241, 241, 255, 249, 241, 241, 255, 249, 241, 241, 255, 250, 240, 241, 255, 250, 240, 240, 255, 250, 240, 240, 255, 250, 240, 240, 255, 251, 240, 239, 255, 251, 240, 239, 255, 251, 239, 239, 255, 251, 239, 238, 255, 251, 239, 238, 255, 252, 239, 238, 255, 252, 239, 237, 255, 252, 239, 237, 255, 252, 238, 237, 255, 253, 238, 236, 255, 253, 238, 236, 255, 253, 238, 235, 255, 253, 238, 235, 255, 253, 238, 235, 255, 253, 237, 234, 255, 253, 237, 234, 255, 253, 237, 233, 255, 253, 237, 233, 255, 253, 237, 233, 255, 253, 237, 232, 255, 253, 237, 232, 255, 253, 236, 231, 255, 253, 236, 231, 255, 253, 236, 230, 255, 253, 236, 230, 255, 253, 236, 229, 255, 253, 236, 229, 255, 253, 233, 218, 255, 253, 233, 218, 255, 253, 233, 217, 255, 253, 233, 217, 255, 253, 233, 216, 255, 253, 232, 216, 255, 253, 232, 216, 255, 253, 232, 215, 255, 253, 232, 215, 255, 253, 232, 214, 255, 253, 232, 214, 255, 253, 232, 213, 255, 253, 232, 213, 255, 253, 232, 212, 255, 253, 232, 211, 255, 253, 232, 211, 255, 253, 232, 210, 255, 253, 232, 210, 255, 253, 231, 209, 255, 253, 231, 209, 255, 253, 231, 208, 255, 253, 231, 208, 255, 253, 231, 207, 255, 253, 231, 207, 255, 253, 231, 206, 255, 253, 231, 206, 255, 253, 231, 205, 255, 253, 231, 205, 255, 253, 231, 204, 255, 253, 231, 204, 255, 253, 231, 203, 255, 253, 231, 203, 255, 252, 231, 202, 255, 252, 231, 202, 255, 252, 231, 202, 255, 252, 231, 201, 255, 251, 231, 201, 255, 251, 231, 200, 255, 251, 231, 200, 255, 250, 231, 199, 255, 250, 231, 199, 255, 250, 231, 198, 255, 249, 231, 198, 255, 249, 231, 197, 255, 248, 231, 197, 255, 248, 231, 197, 255, 248, 231, 196, 255, 247, 231, 196, 255, 247, 231, 195, 255, 246, 231, 195, 255, 246, 231, 195, 255, 245, 231, 194, 255, 245, 231, 194, 255, 245, 231, 193, 255, 245, 230, 192, 255, 245, 230, 192, 255, 244, 230, 191, 255, 244, 230, 191, 255, 244, 229, 190, 255, 244, 229, 190, 255, 244, 229, 189, 255, 244, 228, 189, 255, 243, 228, 188, 255, 243, 228, 188, 255, 243, 227, 187, 255, 243, 227, 186, 255, 243, 227, 186, 255, 242, 227, 185, 255, 242, 226, 185, 255, 242, 226, 184, 255, 242, 226, 184, 255, 242, 225, 183, 255, 242, 225, 183, 255, 241, 225, 182, 255, 241, 225, 181, 255, 241, 224, 181, 255, 241, 224, 180, 255, 241, 224, 180, 255, 240, 223, 179, 255, 240, 223, 179, 255, 240, 223, 178, 255, 240, 222, 178, 255, 240, 222, 177, 255, 240, 222, 176, 255, 239, 222, 176, 255, 239, 221, 175, 255, 239, 221, 175, 255, 239, 221, 174, 255, 239, 220, 174, 255, 239, 220, 173, 255, 238, 220, 173, 255, 238, 219, 172, 255, 238, 219, 172, 255, 238, 219, 171, 255, 238, 219, 170, 255, 237, 218, 170, 255, 237, 218, 169, 255, 237, 218, 169, 255, 237, 217, 168, 255, 237, 217, 168, 255, 237, 217, 167, 255, 236, 217, 167, 255, 232, 209, 152, 255, 231, 208, 152, 255, 231, 208, 151, 255, 231, 208, 150, 255, 231, 207, 150, 255, 231, 207, 149, 255, 231, 207, 149, 255, 230, 207, 148, 255, 230, 206, 148, 255, 230, 206, 147, 255, 230, 206, 147, 255, 230, 205, 146, 255, 229, 205, 146, 255, 229, 205, 145, 255, 229, 204, 144, 255, 229, 204, 144, 255, 229, 204, 143, 255, 229, 204, 143, 255, 228, 203, 142, 255, 228, 203, 142, 255, 228, 203, 141, 255, 228, 202, 141, 255, 228, 202, 140, 255, 227, 202, 140, 255, 227, 201, 139, 255, 227, 201, 138, 255, 227, 201, 138, 255, 227, 201, 137, 255, 227, 200, 137, 255, 226, 200, 136, 255, 226, 200, 136, 255, 226, 199, 135, 255, 226, 199, 135, 255, 226, 199, 134, 255, 226, 199, 134, 255, 225, 198, 133, 255, 225, 198, 132, 255, 225, 198, 132, 255, 225, 197, 131, 255, 225, 197, 131, 255, 224, 197, 130, 255, 224, 196, 130, 255, 224, 196, 129, 255, 224, 196, 129, 255, 224, 196, 128, 255, 224, 195, 128, 255, 223, 195, 127, 255, 223, 195, 127, 255, 223, 194, 126, 255, 223, 194, 125, 255, 223, 194, 125, 255, 222, 193, 124, 255, 222, 193, 124, 255, 222, 193, 123, 255, 222, 193, 123, 255, 222, 193, 122, 255, 222, 193, 122, 255, 222, 193, 121, 255, 222, 193, 120, 255, 222, 193, 120, 255, 221, 193, 119, 255, 221, 193, 119, 255, 221, 193, 118, 255, 221, 193, 117, 255, 221, 193, 117, 255, 221, 193, 116, 255, 221, 193, 116, 255, 220, 193, 115, 255, 220, 193, 115, 255, 220, 193, 114, 255, 220, 193, 113, 255, 220, 193, 113, 255, 220, 193, 112, 255, 220, 193, 112, 255, 219, 193, 111, 255, 219, 193, 111, 255, 219, 193, 110, 255, 219, 193, 109, 255, 219, 193, 109, 255, 218, 193, 108, 255, 218, 193, 108, 255, 218, 193, 107, 255, 218, 193, 106, 255, 218, 193, 106, 255, 218, 193, 105, 255, 217, 193, 105, 255, 217, 193, 104, 255, 217, 193, 104, 255, 217, 193, 103, 255, 217, 193, 102, 255, 216, 193, 102, 255, 216, 193, 101, 255, 216, 193, 101, 255, 216, 193, 100, 255, 215, 193, 99, 255, 215, 193, 99, 255, 215, 193, 98, 255, 215, 193, 98, 255, 214, 193, 97, 255, 214, 193, 96, 255, 214, 193, 96, 255, 214, 193, 95, 255, 207, 193, 79, 255, 207, 193, 78, 255, 207, 193, 77, 255, 206, 193, 77, 255, 206, 193, 76, 255, 206, 193, 76, 255, 206, 193, 75, 255, 205, 193, 74, 255, 205, 193, 74, 255, 205, 193, 73, 255, 204, 193, 73, 255, 204, 193, 72, 255, 204, 193, 71, 255, 204, 193, 71, 255, 203, 193, 70, 255, 203, 193, 69, 255, 203, 193, 69, 255, 202, 193, 68, 255, 202, 193, 68, 255, 202, 193, 67, 255, 202, 193, 66, 255, 201, 193, 66, 255, 201, 193, 65, 255, 201, 193, 64, 255, 200, 193, 64, 255, 200, 193, 63, 255, 200, 193, 62, 255, 199, 193, 62, 255, 199, 193, 61, 255, 199, 193, 60, 255, 198, 193, 60, 255, 198, 193, 59, 255, 198, 193, 58, 255, 197, 193, 58, 255, 197, 193, 57, 255, 197, 193, 56, 255, 196, 193, 56, 255, 196, 193, 55, 255, 196, 193, 54, 255, 195, 193, 54, 255, 195, 193, 53, 255, 194, 193, 52, 255, 194, 193, 51, 255, 194, 193, 51, 255, 193, 193, 50, 255, 193, 193, 49, 255, 193, 193, 49, 255, 192, 193, 48, 255, 192, 193, 47, 255, 191, 193, 46, 255, 191, 193, 45, 255, 191, 193, 45, 255, 190, 193, 44, 255, 190, 192, 43, 255, 190, 191, 43, 255, 190, 190, 42, 255, 190, 189, 41, 255, 190, 188, 41, 255, 189, 187, 40, 255, 189, 186, 40, 255, 189, 185, 39, 255, 189, 184, 39, 255, 189, 183, 38, 255, 188, 182, 37, 255, 188, 181, 37, 255, 188, 180, 36, 255, 188, 179, 36, 255, 187, 178, 35, 255, 187, 178, 35, 255, 187, 177, 34, 255, 187, 176, 34, 255, 186, 175, 33, 255, 186, 174, 33, 255, 186, 173, 32, 255, 186, 172, 32, 255, 185, 171, 31, 255, 185, 170, 31, 255, 185, 169, 30, 255, 185, 168, 30, 255, 184, 167, 29, 255, 184, 166, 29, 255, 184, 165, 28, 255, 183, 164, 28, 255, 183, 164, 28, 255, 183, 163, 27, 255, 182, 162, 27, 255, 182, 161, 26, 255, 182, 160, 26, 255, 181, 159, 26, 255, 181, 158, 25, 255, 181, 157, 25, 255, 180, 156, 25, 255, 180, 155, 24, 255, 180, 154, 24, 255, 179, 154, 23, 255, 179, 153, 23, 255, 179, 152, 23, 255, 178, 151, 23, 255, 178, 150, 22, 255, 177, 149, 22, 255, 177, 148, 22, 255, 177, 147, 21, 255, 176, 146, 21, 255, 166, 123, 14, 255, 165, 122, 14, 255, 165, 121, 13, 255, 164, 120, 13, 255, 164, 119, 13, 255, 163, 119, 13, 255, 163, 118, 13, 255, 163, 117, 12, 255, 162, 116, 12, 255, 162, 115, 12, 255, 161, 114, 12, 255, 161, 113, 12, 255, 160, 112, 12, 255, 160, 112, 11, 255, 159, 111, 11, 255, 159, 110, 11, 255, 158, 109, 11, 255, 158, 108, 11, 255, 157, 107, 11, 255, 157, 106, 11, 255, 156, 106, 11, 255, 156, 105, 10, 255, 155, 104, 10, 255, 155, 103, 10, 255, 154, 102, 10, 255, 154, 101, 10, 255, 153, 101, 10, 255, 153, 100, 10, 255, 152, 99, 10, 255, 152, 98, 10, 255, 151, 97, 10, 255, 151, 96, 10, 255, 150, 96, 10, 255, 150, 95, 10, 255, 149, 94, 10, 255, 149, 93, 10, 255, 148, 92, 10, 255, 147, 91, 10, 255, 147, 91, 10, 255, 146, 90, 10, 255, 146, 89, 10, 255, 145, 88, 10, 255, 145, 87, 10, 255, 144, 87, 10, 255, 143, 86, 10, 255, 143, 85, 10, 255, 142, 84, 10, 255, 142, 83, 10, 255, 141, 83, 10, 255, 140, 82, 10, 255, 140, 81, 10, 255, 139, 80, 9, 255, 139, 80, 9, 255, 138, 80, 9, 255, 138, 80, 9, 255, 137, 79, 9, 255, 137, 79, 9, 255, 137, 79, 9, 255, 136, 79, 9, 255, 136, 78, 9, 255, 135, 78, 9, 255, 135, 78, 9, 255, 134, 77, 9, 255, 134, 77, 9, 255, 133, 77, 9, 255, 133, 77, 9, 255, 132, 76, 9, 255, 132, 76, 9, 255, 132, 76, 9, 255, 131, 76, 9, 255, 131, 75, 9, 255, 130, 75, 9, 255, 130, 75, 9, 255, 129, 75, 9, 255, 129, 74, 9, 255, 128, 74, 9, 255, 128, 74, 9, 255, 128, 74, 9, 255, 127, 73, 9, 255, 127, 73, 9, 255, 126, 73, 9, 255, 126, 72, 8, 255, 125, 72, 8, 255, 125, 72, 8, 255, 124, 72, 8, 255, 124, 71, 8, 255, 124, 71, 8, 255, 123, 71, 8, 255, 123, 71, 8, 255, 122, 70, 8, 255, 122, 70, 8, 255, 121, 70, 8, 255, 121, 70, 8, 255, 120, 69, 8, 255, 120, 69, 8, 255, 120, 69, 8, 255, 119, 69, 8, 255, 119, 68, 8, 255, 118, 68, 8, 255, 118, 68, 8, 255, 117, 68, 8, 255, 117, 67, 8, 255, 105, 60, 7, 255, 105, 60, 7, 255, 104, 60, 7, 255, 104, 60, 7, 255, 103, 59, 7, 255, 103, 59, 7, 255, 103, 59, 7, 255, 102, 59, 7, 255, 102, 58, 7, 255, 101, 58, 7, 255, 101, 58, 7, 255, 100, 58, 6, 255, 100, 57, 6, 255, 100, 57, 6, 255, 99, 57, 6, 255, 99, 57, 6, 255, 98, 56, 6, 255, 98, 56, 6, 255, 97, 56, 6, 255, 97, 56, 6, 255, 97, 55, 6, 255, 96, 55, 6, 255, 96, 55, 6, 255, 95, 55, 6, 255, 95, 54, 6, 255, 94, 54, 6, 255, 94, 54, 6, 255, 94, 54, 6, 255, 93, 53, 6, 255, 93, 53, 6, 255, 92, 53, 6, 255, 92, 52, 6, 255, 91, 52, 6, 255, 91, 52, 6, 255, 91, 52, 6, 255, 90, 51, 6, 255, 90, 51, 6, 255, 89, 51, 5, 255, 89, 51, 5, 255, 88, 50, 5, 255, 88, 50, 5, 255, 88, 50, 5, 255, 87, 50, 5, 255, 87, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_BrBG_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 0, 60, 47, 0, 0, 63, 51, 24, 0, 66, 54, 49, 0, 69, 57, 74, 0, 72, 61, 99, 0, 75, 64, 124, 0, 87, 77, 149, 1, 90, 80, 174, 1, 93, 84, 199, 1, 96, 87, 224, 1, 99, 91, 249, 2, 102, 94, 255, 7, 106, 98, 255, 12, 109, 101, 255, 16, 112, 104, 255, 19, 116, 108, 255, 23, 119, 111, 255, 36, 132, 124, 255, 40, 135, 127, 255, 42, 139, 131, 255, 45, 142, 134, 255, 48, 145, 137, 255, 51, 149, 141, 255, 55, 152, 144, 255, 60, 155, 147, 255, 65, 159, 150, 255, 70, 162, 153, 255, 75, 165, 156, 255, 79, 168, 159, 255, 84, 172, 162, 255, 103, 186, 175, 255, 108, 189, 178, 255, 112, 192, 181, 255, 116, 195, 184, 255, 120, 199, 187, 255, 124, 202, 190, 255, 128, 205, 193, 255, 132, 206, 195, 255, 136, 208, 197, 255, 140, 210, 199, 255, 144, 211, 201, 255, 148, 213, 203, 255, 152, 214, 205, 255, 156, 216, 207, 255, 174, 223, 216, 255, 177, 225, 218, 255, 181, 226, 220, 255, 185, 228, 221, 255, 188, 229, 223, 255, 192, 231, 225, 255, 195, 232, 227, 255, 240, 221, 227, 255, 238, 223, 231, 255, 236, 225, 235, 255, 233, 226, 238, 255, 231, 228, 240, 255, 229, 230, 242, 255, 227, 232, 243, 255, 225, 233, 243, 255, 224, 235, 243, 255, 233, 238, 246, 255, 233, 239, 246, 255, 233, 240, 246, 255, 235, 241, 245, 255, 236, 242, 244, 255, 238, 243, 244, 255, 239, 243, 244, 255, 241, 244, 244, 255, 243, 244, 244, 255, 245, 244, 244, 255, 246, 243, 244, 255, 248, 242, 243, 255, 249, 241, 241, 255, 250, 240, 240, 255, 251, 239, 238, 255, 252, 238, 236, 255, 253, 237, 234, 255, 253, 237, 232, 255, 253, 236, 230, 255, 253, 233, 218, 255, 253, 232, 215, 255, 253, 232, 213, 255, 253, 232, 211, 255, 253, 231, 208, 255, 253, 231, 206, 255, 253, 231, 204, 255, 252, 231, 202, 255, 250, 231, 199, 255, 249, 231, 197, 255, 247, 231, 196, 255, 245, 231, 194, 255, 244, 230, 191, 255, 244, 228, 189, 255, 243, 227, 186, 255, 242, 226, 184, 255, 241, 225, 182, 255, 241, 224, 180, 255, 240, 222, 177, 255, 239, 221, 175, 255, 238, 220, 173, 255, 238, 219, 171, 255, 237, 218, 169, 255, 236, 216, 166, 255, 231, 208, 150, 255, 230, 206, 148, 255, 230, 205, 146, 255, 229, 204, 144, 255, 228, 203, 142, 255, 228, 202, 140, 255, 227, 201, 138, 255, 226, 200, 136, 255, 226, 199, 134, 255, 225, 198, 132, 255, 224, 197, 130, 255, 224, 196, 128, 255, 223, 195, 127, 255, 223, 194, 125, 255, 222, 193, 123, 255, 222, 193, 121, 255, 221, 193, 119, 255, 221, 193, 117, 255, 221, 193, 115, 255, 220, 193, 113, 255, 220, 193, 112, 255, 219, 193, 110, 255, 218, 193, 108, 255, 218, 193, 106, 255, 217, 193, 104, 255, 217, 193, 103, 255, 216, 193, 101, 255, 215, 193, 99, 255, 215, 193, 97, 255, 214, 193, 96, 255, 207, 193, 78, 255, 206, 193, 76, 255, 205, 193, 74, 255, 205, 193, 73, 255, 204, 193, 71, 255, 203, 193, 69, 255, 202, 193, 68, 255, 201, 193, 66, 255, 201, 193, 64, 255, 200, 193, 62, 255, 199, 193, 61, 255, 198, 193, 59, 255, 197, 193, 57, 255, 196, 193, 56, 255, 195, 193, 54, 255, 194, 193, 52, 255, 193, 193, 50, 255, 193, 193, 49, 255, 192, 193, 47, 255, 191, 193, 45, 255, 190, 192, 43, 255, 190, 190, 42, 255, 189, 187, 41, 255, 189, 185, 39, 255, 189, 183, 38, 255, 188, 181, 37, 255, 188, 179, 35, 255, 187, 177, 34, 255, 187, 175, 33, 255, 186, 173, 32, 255, 185, 171, 31, 255, 185, 169, 30, 255, 184, 167, 29, 255, 184, 165, 28, 255, 183, 163, 27, 255, 182, 161, 27, 255, 182, 160, 26, 255, 181, 158, 25, 255, 180, 156, 24, 255, 180, 154, 24, 255, 179, 153, 23, 255, 178, 151, 23, 255, 177, 149, 22, 255, 177, 148, 22, 255, 166, 123, 14, 255, 165, 122, 14, 255, 164, 120, 13, 255, 164, 119, 13, 255, 163, 117, 12, 255, 162, 116, 12, 255, 161, 114, 12, 255, 160, 113, 12, 255, 160, 111, 11, 255, 159, 110, 11, 255, 158, 108, 11, 255, 157, 107, 11, 255, 157, 106, 11, 255, 156, 104, 10, 255, 155, 103, 10, 255, 154, 102, 10, 255, 153, 100, 10, 255, 153, 99, 10, 255, 152, 98, 10, 255, 151, 97, 10, 255, 150, 95, 10, 255, 149, 94, 10, 255, 149, 93, 10, 255, 148, 92, 10, 255, 147, 91, 10, 255, 146, 90, 10, 255, 145, 88, 10, 255, 145, 87, 10, 255, 144, 86, 10, 255, 143, 85, 10, 255, 142, 84, 10, 255, 142, 83, 10, 255, 141, 82, 10, 255, 140, 81, 10, 255, 139, 80, 9, 255, 139, 80, 9, 255, 138, 80, 9, 255, 138, 79, 9, 255, 137, 79, 9, 255, 136, 79, 9, 255, 136, 78, 9, 255, 135, 78, 9, 255, 135, 78, 9, 255, 134, 78, 9, 255, 134, 77, 9, 255, 133, 77, 9, 255, 133, 77, 9, 255, 132, 76, 9, 255, 132, 76, 9, 255, 131, 76, 9, 255, 131, 75, 9, 255, 130, 75, 9, 255, 130, 75, 9, 255, 130, 75, 9, 255, 129, 74, 9, 255, 129, 74, 9, 255, 128, 74, 9, 255, 128, 74, 9, 255, 127, 73, 9, 255, 127, 73, 9, 255, 126, 73, 9, 255, 126, 73, 9, 255, 126, 72, 8, 255, 125, 72, 8, 255, 125, 72, 8, 255, 124, 72, 8, 255, 124, 71, 8, 255, 124, 71, 8, 255, 123, 71, 8, 255, 123, 71, 8, 255, 123, 71, 8, 255, 122, 70, 8, 255, 122, 70, 8, 255, 121, 70, 8, 255, 121, 70, 8, 255, 121, 70, 8, 255, 120, 69, 8, 255, 120, 69, 8, 255, 120, 69, 8, 255, 119, 69, 8, 255, 119, 69, 8, 255, 119, 68, 8, 255, 118, 68, 8, 255, 118, 68, 8, 255, 118, 68, 8, 255, 117, 68, 8, 255, 117, 67, 8, 255, 117, 67, 8, 255, 117, 67, 8, 255, 105, 60, 7, 255, 105, 60, 7, 255, 104, 60, 7, 255, 104, 60, 7, 255, 104, 60, 7, 255, 104, 59, 7, 255, 103, 59, 7, 255, 103, 59, 7, 255, 103, 59, 7, 255, 103, 59, 7, 255, 102, 59, 7, 255, 102, 59, 7, 255, 102, 58, 7, 255, 102, 58, 7, 255, 101, 58, 7, 255, 101, 58, 7, 255, 101, 58, 7, 255, 101, 58, 7, 255, 100, 58, 6, 255, 100, 57, 6, 255, 100, 57, 6, 255, 100, 57, 6, 255, 99, 57, 6, 255, 99, 57, 6, 255, 99, 57, 6, 255, 99, 57, 6, 255, 99, 56, 6, 255, 98, 56, 6, 255, 98, 56, 6, 255, 98, 56, 6, 255, 98, 56, 6, 255, 98, 56, 6, 255, 97, 56, 6, 255, 97, 56, 6, 255, 97, 56, 6, 255, 97, 55, 6, 255, 97, 55, 6, 255, 96, 55, 6, 255, 96, 55, 6, 255, 96, 55, 6, 255, 96, 55, 6, 255, 96, 55, 6, 255, 96, 55, 6, 255, 95, 55, 6, 255, 95, 54, 6, 255, 95, 54, 6, 255, 95, 54, 6, 255, 95, 54, 6, 255, 95, 54, 6, 255, 94, 54, 6, 255, 94, 54, 6, 255, 94, 54, 6, 255, 94, 54, 6, 255, 94, 54, 6, 255, 94, 54, 6, 255, 93, 53, 6, 255, 93, 53, 6, 255, 93, 53, 6, 255, 93, 53, 6, 255, 93, 53, 6, 255, 93, 53, 6, 255, 93, 53, 6, 255, 93, 53, 6, 255, 92, 53, 6, 255, 92, 53, 6, 255, 92, 53, 6, 255, 92, 53, 6, 255, 92, 53, 6, 255, 92, 52, 6, 255, 92, 52, 6, 255, 92, 52, 6, 255, 91, 52, 6, 255, 91, 52, 6, 255, 91, 52, 6, 255, 91, 52, 6, 255, 91, 52, 6, 255, 91, 52, 6, 255, 91, 52, 6, 255, 91, 52, 6, 255, 91, 52, 6, 255, 90, 52, 6, 255, 90, 52, 6, 255, 90, 52, 6, 255, 90, 51, 6, 255, 90, 51, 6, 255, 90, 51, 6, 255, 90, 51, 6, 255, 90, 51, 6, 255, 90, 51, 5, 255, 90, 51, 5, 255, 89, 51, 5, 255, 89, 51, 5, 255, 89, 51, 5, 255, 89, 51, 5, 255, 89, 51, 5, 255, 89, 51, 5, 255, 89, 51, 5, 255, 89, 51, 5, 255, 89, 51, 5, 255, 89, 51, 5, 255, 89, 51, 5, 255, 89, 51, 5, 255, 88, 50, 5, 255, 88, 50, 5, 255, 88, 50, 5, 255, 88, 50, 5, 255, 88, 50, 5, 255, 88, 50, 5, 255, 88, 50, 5, 255, 88, 50, 5, 255, 88, 50, 5, 255, 88, 50, 5, 255, 88, 50, 5, 255, 88, 50, 5, 255, 88, 50, 5, 255, 88, 50, 5, 255, 87, 50, 5, 255, 87, 50, 5, 255, 87, 50, 5, 255, 87, 50, 5, 255, 87, 50, 5, 255, 87, 50, 5, 255, 87, 50, 5, 255, 87, 50, 5, 255, 87, 50, 5, 255, 87, 50, 5, 255, 87, 50, 5, 255, 87, 50, 5, 255, 87, 49, 5, 255, 87, 49, 5, 255, 87, 49, 5, 255, 87, 49, 5, 255, 87, 49, 5, 255, 87, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 86, 49, 5, 255, 85, 49, 5, 255, 85, 49, 5, 255, 85, 49, 5, 255, 85, 49, 5, 255, 85, 49, 5, 255, 85, 49, 5, 255, 85, 49, 5, 255, 85, 49, 5, 255, 85, 49, 5, 255, 85, 49, 5, 255, 85, 49, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 85, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 5, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 84, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255, 83, 48, 4, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_BrBG_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
