//                                               -*- C++ -*-
/**
 *  @brief The external header file of OpenTURNS for subdir Optim
 *
 *  Copyright 2005-2025 Airbus-EDF-IMACS-ONERA-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef OPENTURNS_OTOPTIM_HXX
#define OPENTURNS_OTOPTIM_HXX

#include "openturns/AbdoRackwitz.hxx"
#include "openturns/Bonmin.hxx"
#include "openturns/Ceres.hxx"
#include "openturns/CMinpack.hxx"
#include "openturns/Cobyla.hxx"
#include "openturns/Ipopt.hxx"
#include "openturns/MultiStart.hxx"
#include "openturns/NearestPointCheckerResult.hxx"
#include "openturns/NearestPointChecker.hxx"
#include "openturns/NLopt.hxx"
#include "openturns/Dlib.hxx"
#include "openturns/OptimizationProblem.hxx"
#include "openturns/OptimizationProblemImplementation.hxx"
#include "openturns/NearestPointProblem.hxx"
#include "openturns/LeastSquaresProblem.hxx"
#include "openturns/OptimizationProblemImplementation.hxx"
#include "openturns/OptimizationAlgorithm.hxx"
#include "openturns/OptimizationAlgorithmImplementation.hxx"
#include "openturns/OptimizationResult.hxx"
#include "openturns/Pagmo.hxx"
#include "openturns/SQP.hxx"
#include "openturns/TNC.hxx"

#endif /* OPENTURNS_OTOPTIM_HXX */
