"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const node_stream_1 = require("node:stream");
const msgpack = __importStar(require("@msgpack/msgpack"));
const expect_1 = __importDefault(require("expect"));
const attach_1 = require("../attach/attach");
const transport_1 = require("./transport");
describe('transport', () => {
    it('throws on invalid RPC message', done => {
        const invalidPayload = { bogus: 'nonsense' };
        const onTransportFail = transport_1.exportsForTesting.onTransportFail;
        onTransportFail.on('fail', (errMsg) => {
            (0, expect_1.default)(errMsg).toEqual("invalid msgpack-RPC message: expected array, got: { bogus: 'nonsense' }");
            done();
        });
        // Create fake reader/writer and send a (broken) message.
        const fakeReader = new node_stream_1.Readable({ read() { } });
        const fakeWriter = new node_stream_1.Writable({ write() { } });
        const nvim = (0, attach_1.attach)({ reader: fakeReader, writer: fakeWriter });
        void nvim; // eslint-disable-line no-void
        // Simulate an invalid message on the channel.
        const msg = msgpack.encode(invalidPayload);
        fakeReader.push(Buffer.from(msg.buffer, msg.byteOffset, msg.byteLength));
    });
    it('closes transport and cleans up pending requests', () => __awaiter(void 0, void 0, void 0, function* () {
        const socket = new node_stream_1.PassThrough();
        const nvim = (0, attach_1.attach)({ reader: socket, writer: socket });
        // Close the transport
        const closePromise = nvim.close();
        // Verify close promise resolves
        yield (0, expect_1.default)(closePromise).resolves.toBeUndefined();
    }));
});
