"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const jestMock = __importStar(require("jest-mock"));
const expect_1 = __importDefault(require("expect"));
const attach_1 = require("./attach");
const testUtil = __importStar(require("../testUtil"));
const client_1 = require("../api/client");
// global.expect = expect;
describe('Nvim API', () => {
    let proc;
    let nvim;
    /** Incoming requests (from Nvim). */
    const requests = [];
    /** Incoming notifications (from Nvim). */
    const notifications = [];
    before(() => __awaiter(void 0, void 0, void 0, function* () {
        [proc, nvim] = testUtil.startNvim();
        // Incoming requests (from Nvim).
        nvim.on('request', (method, args, resp) => {
            requests.push({ method, args });
            resp.send(`received ${method}(${args})`);
        });
        // Incoming notifications (from Nvim).
        nvim.on('notification', (method, args) => {
            notifications.push({ method, args });
        });
    }));
    after(() => {
        testUtil.stopNvim();
    });
    beforeEach(() => {
        requests.length = 0;
        notifications.length = 0;
    });
    it('failure modes', () => __awaiter(void 0, void 0, void 0, function* () {
        const c = new client_1.NeovimClient();
        yield (0, expect_1.default)(c.channelId).rejects.toThrow('channelId requested before _isReady');
    }));
    it('console.log is monkey-patched to logger.info #329', () => __awaiter(void 0, void 0, void 0, function* () {
        const spy = jestMock.spyOn(nvim.logger, 'info');
        // eslint-disable-next-line no-console
        console.log('log message');
        (0, expect_1.default)(spy).toHaveBeenCalledWith('log message');
        // Still alive?
        (0, expect_1.default)(yield nvim.eval('1+1')).toEqual(2);
    }));
    it('console.assert is monkey-patched', () => __awaiter(void 0, void 0, void 0, function* () {
        const spy = jestMock.spyOn(nvim.logger, 'error');
        // eslint-disable-next-line no-console
        console.assert(false, 'foo', 42, { x: [1, 2] });
        (0, expect_1.default)(spy).toHaveBeenCalledWith('assertion failed', 'foo', 42, {
            x: [1, 2],
        });
        // Still alive?
        (0, expect_1.default)(yield nvim.eval('1+1')).toEqual(2);
    }));
    it('console.log NOT monkey-patched if custom logger passed to attach()', () => __awaiter(void 0, void 0, void 0, function* () {
        const [proc2] = testUtil.startNvim(false);
        const logged = [];
        let logger2 = {};
        const fakeLog = (msg) => {
            logged.push(msg);
            return logger2;
        };
        logger2 = {
            info: fakeLog,
            warn: fakeLog,
            debug: fakeLog,
            error: fakeLog,
        };
        const nvim2 = (0, attach_1.attach)({
            proc: proc2,
            options: { logger: logger2 },
        });
        const spy = jestMock.spyOn(nvim2.logger, 'info');
        // eslint-disable-next-line no-console
        console.log('message 1');
        // console.log was NOT patched.
        (0, expect_1.default)(spy).toHaveBeenCalledTimes(0);
        // Custom logger did NOT get the message.
        (0, expect_1.default)(logged).toEqual([]);
        // Custom logger can be called explicitly.
        nvim2.logger.info('message 2');
        (0, expect_1.default)(logged).toEqual(['message 2']);
        // Still alive?
        (0, expect_1.default)(yield nvim2.eval('1+1')).toEqual(2);
        testUtil.stopNvim(nvim2);
    }));
    it('noisy RPC traffic', () => __awaiter(void 0, void 0, void 0, function* () {
        let requestCount = 0;
        const oldRequest = nvim.request;
        nvim.request = function (name, args = []) {
            requestCount = requestCount + 1;
            return oldRequest.call(this, name, args);
        };
        for (let i = 0; i < 99; i = i + 1) {
            nvim.command('noswapfile edit test-node-client.lua');
            nvim.command('bwipeout!');
        }
        (0, expect_1.default)(requestCount).toEqual(99 * 2);
        // Still alive?
        (0, expect_1.default)(yield nvim.eval('1+1')).toEqual(2);
        nvim.request = oldRequest;
    }));
    it('can send requests and receive response', () => __awaiter(void 0, void 0, void 0, function* () {
        const result = yield nvim.eval('{"k1": "v1", "k2": 2}');
        (0, expect_1.default)(result).toEqual({ k1: 'v1', k2: 2 });
    }));
    it('can receive requests and send responses', () => __awaiter(void 0, void 0, void 0, function* () {
        const res = yield nvim.eval('rpcrequest(1, "request", 1, 2, 3)');
        (0, expect_1.default)(res).toEqual('received request(1,2,3)');
        (0, expect_1.default)(requests).toEqual([{ method: 'request', args: [1, 2, 3] }]);
        (0, expect_1.default)(notifications).toEqual([]);
    }));
    it('can receive notifications', () => __awaiter(void 0, void 0, void 0, function* () {
        const res = yield nvim.eval('rpcnotify(1, "notify", 1, 2, 3)');
        (0, expect_1.default)(res).toEqual(1);
        (0, expect_1.default)(requests).toEqual([]);
        return new Promise(resolve => {
            setImmediate(() => {
                (0, expect_1.default)(notifications).toEqual([{ method: 'notify', args: [1, 2, 3] }]);
                resolve(undefined);
            });
        });
    }));
    it('can deal with custom types', () => __awaiter(void 0, void 0, void 0, function* () {
        yield nvim.command('vsp');
        yield nvim.command('vsp');
        yield nvim.command('vsp');
        const windows = yield nvim.windows;
        (0, expect_1.default)(windows.length).toEqual(4);
        (0, expect_1.default)(windows[0] instanceof nvim.Window).toEqual(true);
        (0, expect_1.default)(windows[1] instanceof nvim.Window).toEqual(true);
        yield nvim.setWindow(windows[2]);
        const win = yield nvim.window;
        (0, expect_1.default)(win.equals(windows[0])).toBe(false);
        (0, expect_1.default)(win.equals(windows[2])).toBe(true);
        const buf = yield nvim.buffer;
        (0, expect_1.default)(buf instanceof nvim.Buffer).toEqual(true);
        const lines = yield buf.getLines({
            start: 0,
            end: -1,
            strictIndexing: true,
        });
        (0, expect_1.default)(lines).toEqual(['']);
        buf.setLines(['line1', 'line2'], { start: 0, end: 1 });
        const newLines = yield buf.getLines({
            start: 0,
            end: -1,
            strictIndexing: true,
        });
        (0, expect_1.default)(newLines).toEqual(['line1', 'line2']);
    }));
    // skip for now. #419
    it.skip('emits "disconnect" after quit', done => {
        const disconnectMock = jestMock.fn();
        nvim.on('disconnect', disconnectMock);
        nvim.quit();
        // TODO: 'close' event sometimes does not emit. #414
        proc.on('exit', () => {
            (0, expect_1.default)(disconnectMock).toHaveBeenCalledTimes(1);
            done();
        });
        // Event doesn't actually emit when we quit nvim, but when the child process is killed
        if (proc && proc.connected) {
            proc.disconnect();
        }
    });
});
