"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const jestMock = __importStar(require("jest-mock"));
const expect_1 = __importDefault(require("expect"));
const testUtil = __importStar(require("../testUtil"));
describe('Tabpage API', () => {
    let nvim;
    before(() => __awaiter(void 0, void 0, void 0, function* () {
        [, nvim] = testUtil.startNvim();
    }));
    after(() => {
        testUtil.stopNvim();
    });
    it('gets the current Tabpage', () => __awaiter(void 0, void 0, void 0, function* () {
        const tabpage = yield nvim.tabpage;
        (0, expect_1.default)(tabpage).toBeInstanceOf(nvim.Tabpage);
    }));
    describe('Normal API calls', () => {
        let tabpage;
        beforeEach(() => __awaiter(void 0, void 0, void 0, function* () {
            tabpage = yield nvim.tabpage;
        }));
        after(() => nvim.command('tabclose'));
        it('gets the current tabpage number', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(yield tabpage.number).toBe(1);
        }));
        it('is a valid tabpage', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(yield tabpage.valid).toBe(true);
        }));
        it('adds a tabpage and switches to it', () => __awaiter(void 0, void 0, void 0, function* () {
            nvim.command('tabnew');
            // Switch to new tabpage
            const tabpages = yield nvim.tabpages;
            (0, expect_1.default)(tabpages.length).toBe(2);
            nvim.tabpage = tabpages[tabpages.length - 1];
            const newTabPage = yield nvim.tabpage;
            (0, expect_1.default)(yield newTabPage.number).toBe(2);
        }));
        it('gets current window in tabpage', () => __awaiter(void 0, void 0, void 0, function* () {
            const window = yield tabpage.window;
            (0, expect_1.default)(window).toBeInstanceOf(nvim.Window);
        }));
        it('gets list of windows in tabpage', () => __awaiter(void 0, void 0, void 0, function* () {
            const windows = yield tabpage.windows;
            (0, expect_1.default)(windows.length).toBe(1);
            // Add a new window
            yield nvim.command('vsplit');
            const newWindows = yield tabpage.windows;
            (0, expect_1.default)(newWindows.length).toBe(2);
        }));
        it('logs an error when calling `getOption`', () => {
            const spy = jestMock.spyOn(tabpage.logger, 'error');
            tabpage.getOption();
            (0, expect_1.default)(spy.mock.calls.length).toBe(1);
            tabpage.setOption();
            (0, expect_1.default)(spy.mock.calls.length).toBe(2);
            spy.mockClear();
        });
        it('returns null if variable is not found', () => __awaiter(void 0, void 0, void 0, function* () {
            const test = yield tabpage.getVar('test');
            (0, expect_1.default)(test).toBe(null);
        }));
        it('can set a t: variable', () => __awaiter(void 0, void 0, void 0, function* () {
            tabpage.setVar('test', 'testValue');
            (0, expect_1.default)(yield tabpage.getVar('test')).toBe('testValue');
            (0, expect_1.default)(yield nvim.eval('t:test')).toBe('testValue');
        }));
        it('can delete a t: variable', () => __awaiter(void 0, void 0, void 0, function* () {
            tabpage.deleteVar('test');
            (0, expect_1.default)(yield nvim.eval('exists("t:test")')).toBe(0);
            (0, expect_1.default)(yield tabpage.getVar('test')).toBe(null);
        }));
    });
    describe('Chainable API calls', () => {
        it('gets the current tabpage number', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(yield nvim.tabpage.number).toBe(1);
        }));
        it('is a valid tabpage', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(yield nvim.tabpage.valid).toBe(true);
        }));
        it('adds a tabpage and switches to it', () => __awaiter(void 0, void 0, void 0, function* () {
            nvim.command('tabnew');
            // Switch to new tabpage
            const tabpages = yield nvim.tabpages;
            // TODO
            (0, expect_1.default)((yield nvim.tabpages).length).toBe(2);
            nvim.tabpage = tabpages[tabpages.length - 1];
            (0, expect_1.default)(yield nvim.tabpage.number).toBe(2);
        }));
        it('gets current window in tabpage', () => __awaiter(void 0, void 0, void 0, function* () {
            const window = yield nvim.tabpage.window;
            (0, expect_1.default)(window).toBeInstanceOf(nvim.Window);
        }));
        it('gets list of windows in tabpage', () => __awaiter(void 0, void 0, void 0, function* () {
            const windows = yield nvim.tabpage.windows;
            (0, expect_1.default)(windows.length).toBe(1);
            // Add a new window
            nvim.command('vsplit');
            // TODO
            (0, expect_1.default)((yield nvim.tabpage.windows).length).toBe(2);
        }));
    });
});
