"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path = __importStar(require("node:path"));
const node_assert_1 = __importDefault(require("node:assert"));
const expect_1 = __importDefault(require("expect"));
const testUtil = __importStar(require("../testUtil"));
describe('Neovim API', () => {
    let nvim;
    before(() => __awaiter(void 0, void 0, void 0, function* () {
        [, nvim] = testUtil.startNvim();
    }));
    after(() => {
        testUtil.stopNvim();
    });
    describe('Normal API calls', () => {
        it('gets a list of buffers and switches buffers', () => __awaiter(void 0, void 0, void 0, function* () {
            const buffers = yield nvim.buffers;
            (0, expect_1.default)(buffers.length).toBe(1);
            buffers[0].name = 'hello.txt';
            nvim.command('noswapfile e! goodbye.txt');
            (0, expect_1.default)((yield nvim.buffers).length).toBe(2);
            (0, expect_1.default)(yield nvim.buffer.name).toMatch(/goodbye\.txt$/);
            // switch buffers
            [nvim.buffer] = buffers;
            (0, expect_1.default)(yield (yield nvim.buffer).name).toMatch(/hello\.txt$/);
        }));
        it('can list runtimepaths', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)((yield nvim.runtimePaths).length).toBeGreaterThan(0);
        }));
        it('can change current working directory', () => __awaiter(void 0, void 0, void 0, function* () {
            const initial = yield nvim.call('getcwd', []);
            const newCwd = path.dirname(initial);
            nvim.dir = newCwd;
            (0, expect_1.default)(yield nvim.call('getcwd', [])).toBe(newCwd);
        }));
        it.skip('can get current mode', () => __awaiter(void 0, void 0, void 0, function* () {
            const initial = yield nvim.mode;
            (0, expect_1.default)(initial).toEqual({ mode: 'n', blocking: false });
            yield nvim.command('startinsert');
        }));
        it('can get color map', () => __awaiter(void 0, void 0, void 0, function* () {
            const colorMap = yield nvim.colorMap;
            (0, expect_1.default)(Object.keys(colorMap).length).toBeGreaterThan(0);
        }));
        it('can get color by name', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(yield nvim.getColorByName('white')).toBe(16777215);
        }));
        it('can get highlight by name or id', () => __awaiter(void 0, void 0, void 0, function* () {
            const buffer = yield nvim.buffer;
            yield buffer.append('hello world');
            const srcId = yield buffer.addHighlight({
                hlGroup: 'test',
                line: 0,
                colStart: 0,
                colEnd: 3,
                srcId: 0,
            });
            (0, expect_1.default)(srcId).toBeGreaterThan(0);
            const highlightById = yield nvim.getHighlightById(srcId);
            (0, expect_1.default)(highlightById).toEqual(expect_1.default.objectContaining({
                foreground: expect_1.default.anything(),
            }));
            (0, expect_1.default)(yield nvim.getHighlight(srcId)).toEqual(highlightById);
            // Note this doesn't work as you would think because
            // addHighlight does not add a highlight group
            (0, expect_1.default)(yield nvim.getHighlightByName('test')).toEqual({});
            buffer.remove(0, -1, false);
        }));
        it('can run lua', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(yield nvim.lua('function test(a) return a end return test(...)', [1])).toBe(1);
            (0, expect_1.default)(yield nvim.lua('function test(a) return a end return test(...)', ['foo'])).toBe('foo');
            (0, expect_1.default)(yield nvim.executeLua('function test(a) return a end return test(...)', ['foo'])).toBe('foo');
        }));
        it('get/set/delete current line', () => __awaiter(void 0, void 0, void 0, function* () {
            const line = yield nvim.line;
            (0, expect_1.default)(line).toBe('');
            nvim.line = 'current line';
            (0, expect_1.default)(yield nvim.line).toBe('current line');
            nvim.deleteCurrentLine();
            (0, expect_1.default)(yield nvim.line).toBe('');
        }));
        it('gets v: vars', () => __awaiter(void 0, void 0, void 0, function* () {
            const initial = yield nvim.eval('v:ctype');
            (0, expect_1.default)(yield nvim.getVvar('ctype')).toBe(initial);
        }));
        it('sets v: vars', () => __awaiter(void 0, void 0, void 0, function* () {
            yield nvim.setVvar('mouse_winid', 2);
            (0, expect_1.default)(yield nvim.eval('v:mouse_winid')).toBe(2);
            (0, expect_1.default)(yield nvim.getVvar('mouse_winid')).toBe(2);
        }));
        it('gets string width', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(yield nvim.strWidth('string')).toBe(6);
        }));
        it('write to vim output buffer', () => __awaiter(void 0, void 0, void 0, function* () {
            // TODO how to test this?
            nvim.outWrite('test');
        }));
        it('write to vim error buffer', () => __awaiter(void 0, void 0, void 0, function* () {
            // TODO how to test this?
            nvim.errWrite('test');
            nvim.errWriteLine('test');
        }));
        it('parse expression', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(yield nvim.parseExpression('@', 'm', true)).toEqual(expect_1.default.objectContaining({}));
        }));
        it('gets api info', () => __awaiter(void 0, void 0, void 0, function* () {
            const [, apiInfo] = yield nvim.apiInfo;
            (0, expect_1.default)(apiInfo).toEqual(expect_1.default.objectContaining({
                version: expect_1.default.anything(),
                functions: expect_1.default.anything(),
                ui_events: expect_1.default.anything(),
                ui_options: expect_1.default.anything(),
                error_types: expect_1.default.anything(),
                types: expect_1.default.anything(),
            }));
        }));
        it('gets all channels', () => __awaiter(void 0, void 0, void 0, function* () {
            const chans = yield nvim.chans;
            (0, expect_1.default)(chans).toEqual(expect_1.default.arrayContaining([
                expect_1.default.objectContaining({
                    id: expect_1.default.anything(),
                    stream: expect_1.default.anything(),
                    mode: expect_1.default.anything(),
                }),
            ]));
        }));
        it('gets channel info', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(yield nvim.getChanInfo(1)).toEqual(expect_1.default.objectContaining({
                id: expect_1.default.anything(),
                stream: expect_1.default.anything(),
                mode: expect_1.default.anything(),
            }));
        }));
        it('gets commands', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(yield nvim.commands).toEqual({});
        }));
        it('gets proc', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(() => __awaiter(void 0, void 0, void 0, function* () { return nvim.getProc(1); })).not.toThrow();
        }));
        it('gets proc children', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(() => __awaiter(void 0, void 0, void 0, function* () { return nvim.getProcChildren(1); })).not.toThrow();
        }));
        it('gets uis', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(yield nvim.uis).toEqual([]);
        }));
        it('can subscribe to vim events', () => __awaiter(void 0, void 0, void 0, function* () {
            yield nvim.subscribe('test');
            yield nvim.unsubscribe('test');
        }));
        it('sets clientInfo', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(() => nvim.setClientInfo('test', {}, '', {}, {})).not.toThrow();
        }));
        it('selects popupmenu item', () => __awaiter(void 0, void 0, void 0, function* () {
            yield nvim.selectPopupmenuItem(0, true, true);
        }));
        it('creates and closes a floating window', () => __awaiter(void 0, void 0, void 0, function* () {
            const numBuffers = (yield nvim.buffers).length;
            const numWindows = (yield nvim.windows).length;
            const buffer = yield nvim.createBuffer(false, false);
            (0, expect_1.default)(yield nvim.buffers).toHaveLength(numBuffers + 1);
            (0, node_assert_1.default)(typeof buffer !== 'number');
            const floatingWindow = yield nvim.openWindow(buffer, true, {
                relative: 'editor',
                row: 5,
                col: 5,
                width: 50,
                height: 50,
            });
            (0, expect_1.default)(yield nvim.windows).toHaveLength(numWindows + 1);
            (0, node_assert_1.default)(typeof floatingWindow !== 'number');
            yield nvim.windowClose(floatingWindow, true);
            (0, expect_1.default)(yield nvim.windows).toHaveLength(numWindows);
        }));
        it('resizes a window', () => __awaiter(void 0, void 0, void 0, function* () {
            const numWindows = (yield nvim.windows).length;
            const buffer = yield nvim.createBuffer(false, false);
            (0, node_assert_1.default)(typeof buffer !== 'number');
            const floatingWindow = yield nvim.openWindow(buffer, true, {
                relative: 'editor',
                row: 5,
                col: 5,
                width: 10,
                height: 10,
            });
            (0, node_assert_1.default)(typeof floatingWindow !== 'number');
            (0, expect_1.default)(yield nvim.windows).toHaveLength(numWindows + 1);
            (0, expect_1.default)(yield floatingWindow.height).toBe(10);
            (0, expect_1.default)(yield floatingWindow.width).toBe(10);
            yield nvim.windowConfig(floatingWindow, { width: 20, height: 20 });
            (0, expect_1.default)(yield floatingWindow.height).toBe(20);
            (0, expect_1.default)(yield floatingWindow.width).toBe(20);
            yield nvim.windowClose(floatingWindow, true);
        }));
    });
    describe('Namespaces', () => {
        it('creates and gets anonymous namespaces', () => __awaiter(void 0, void 0, void 0, function* () {
            const id = yield nvim.createNamespace();
            (0, expect_1.default)(typeof id).toBe('number');
            (0, expect_1.default)(yield nvim.getNamespaces()).toEqual({});
        }));
        it('creates and gets named namespaces', () => __awaiter(void 0, void 0, void 0, function* () {
            const foo = yield nvim.createNamespace('foo');
            const bar = yield nvim.createNamespace('bar');
            (0, expect_1.default)(yield nvim.getNamespaces()).toEqual({ foo, bar });
        }));
    });
});
