; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -S -passes=globalopt < %s | FileCheck %s

; Test behavior of trying to fold access of global variables
; initialized one time through addrspacecast.

@as0_ptr = internal global ptr null
@as1_ptr = internal global ptr addrspace(1) null
@as2_ptr = internal global ptr addrspace(2) null
@as1_null_valid_ptr = internal global ptr addrspace(1) null
@as0_null_valid_ptr = internal global ptr null

@Actual.as0 = internal global i32 1234
@Actual.as1 = internal addrspace(1) global i32 5678
@Actual.as2 = internal addrspace(2) global i32 91011
@Actual.as1.null.valid = internal addrspace(1) global i32 91011
@Actual.as0.null.valid = internal global i32 9999

; Initialize each global once.
define void @init() {
; CHECK-LABEL: define void @init() local_unnamed_addr {
; CHECK-NEXT:    store ptr addrspace(1) @Actual.as1, ptr @as1_ptr, align 8
; CHECK-NEXT:    store ptr addrspace(2) @Actual.as2, ptr @as2_ptr, align 8
; CHECK-NEXT:    store ptr addrspace(1) @Actual.as1.null.valid, ptr @as1_null_valid_ptr, align 8
; CHECK-NEXT:    store ptr @Actual.as0.null.valid, ptr @as0_null_valid_ptr, align 8
; CHECK-NEXT:    ret void
;
  store ptr @Actual.as0, ptr @as0_ptr
  store ptr addrspace(1) @Actual.as1, ptr @as1_ptr
  store ptr addrspace(2) @Actual.as2, ptr @as2_ptr
  store ptr addrspace(1) @Actual.as1.null.valid, ptr @as1_null_valid_ptr
  store ptr @Actual.as0.null.valid, ptr @as0_null_valid_ptr
  ret void
}

; Access stored value is null in the default address space, which we
; can assume cannot alias a valid object in another address space.
define i32 @load_from_as0_ptr_in_as1() {
; CHECK-LABEL: define i32 @load_from_as0_ptr_in_as1() local_unnamed_addr {
; CHECK-NEXT:    ret i32 1234
;
  %ptr = load ptr, ptr @as0_ptr
  %cast = addrspacecast ptr %ptr to ptr addrspace(1)
  %load = load i32, ptr addrspace(1) %cast
  ret i32 %load
}

; Cast is to default address space and access is done through default
; address space in a function where null is valid.
define i32 @load_from_as0_ptr_in_as1_null_is_valid() null_pointer_is_valid {
; CHECK-LABEL: define i32 @load_from_as0_ptr_in_as1_null_is_valid
; CHECK-SAME: () local_unnamed_addr #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[PTR:%.*]] = load ptr addrspace(1), ptr @as1_null_valid_ptr, align 8
; CHECK-NEXT:    [[CAST:%.*]] = addrspacecast ptr addrspace(1) [[PTR]] to ptr
; CHECK-NEXT:    [[LOAD:%.*]] = load i32, ptr [[CAST]], align 4
; CHECK-NEXT:    ret i32 [[LOAD]]
;
  %ptr = load ptr addrspace(1), ptr @as1_null_valid_ptr
  %cast = addrspacecast ptr addrspace(1) %ptr to ptr
  %load = load i32, ptr %cast
  ret i32 %load
}

; Original addrspace(0) null was valid, and we also have to assume the
; access is valid in addrspace(1)
define i32 @load_from_as1_ptr_in_as0_null_is_valid() null_pointer_is_valid {
; CHECK-LABEL: define i32 @load_from_as1_ptr_in_as0_null_is_valid
; CHECK-SAME: () local_unnamed_addr #[[ATTR0]] {
; CHECK-NEXT:    [[PTR:%.*]] = load ptr, ptr @as0_null_valid_ptr, align 8
; CHECK-NEXT:    [[CAST:%.*]] = addrspacecast ptr [[PTR]] to ptr addrspace(1)
; CHECK-NEXT:    [[LOAD:%.*]] = load i32, ptr addrspace(1) [[CAST]], align 4
; CHECK-NEXT:    ret i32 [[LOAD]]
;
  %ptr = load ptr, ptr @as0_null_valid_ptr
  %cast = addrspacecast ptr %ptr to ptr addrspace(1)
  %load = load i32, ptr addrspace(1) %cast
  ret i32 %load
}

; Underlying pointer could be valid, can't fold this out.
define i32 @load_from_as1_ptr_in_as0() {
; CHECK-LABEL: define i32 @load_from_as1_ptr_in_as0() local_unnamed_addr {
; CHECK-NEXT:    [[PTR:%.*]] = load ptr addrspace(1), ptr @as1_ptr, align 8
; CHECK-NEXT:    [[CAST:%.*]] = addrspacecast ptr addrspace(1) [[PTR]] to ptr
; CHECK-NEXT:    [[LOAD:%.*]] = load i32, ptr [[CAST]], align 4
; CHECK-NEXT:    ret i32 [[LOAD]]
;
  %ptr = load ptr addrspace(1), ptr @as1_ptr
  %cast = addrspacecast ptr addrspace(1) %ptr to ptr
  %load = load i32, ptr %cast
  ret i32 %load
}

; Two non-default address spaces, can't fold.
define i32 @load_from_as2_ptr_in_as1() {
; CHECK-LABEL: define i32 @load_from_as2_ptr_in_as1() local_unnamed_addr {
; CHECK-NEXT:    [[PTR:%.*]] = load ptr addrspace(2), ptr @as2_ptr, align 8
; CHECK-NEXT:    [[CAST:%.*]] = addrspacecast ptr addrspace(2) [[PTR]] to ptr addrspace(1)
; CHECK-NEXT:    [[LOAD:%.*]] = load i32, ptr addrspace(1) [[CAST]], align 4
; CHECK-NEXT:    ret i32 [[LOAD]]
;
  %ptr = load ptr addrspace(2), ptr @as2_ptr
  %cast = addrspacecast ptr addrspace(2) %ptr to ptr addrspace(1)
  %load = load i32, ptr addrspace(1) %cast
  ret i32 %load
}
