;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; Regression test for a bug in TypeSSA. TypeSSA creates a new subtype, $t_1,
;; for use in the struct.new in the global initializer, but ran ReFinalize only
;; on function code, not on module-level code. As a result, the tuple.make
;; result type still used $t instead of $t_1 after TypeSSA. This stale type
;; caused Unsubtyping to incorrectly break the subtype relationship between $t
;; and $t_1, leading to a validation error. The fix was to refinalize
;; module-level code in TypeSSA and fix the validator so it would have caught
;; the stale type.

;; RUN: wasm-opt %s -all --type-ssa --unsubtyping --closed-world -S -o - | filecheck %s

(module
 ;; CHECK:      (rec
 ;; CHECK-NEXT:  (type $t (sub (struct)))
 (type $t (sub (struct)))

 ;; CHECK:       (type $t_1 (sub $t (struct)))

 ;; CHECK:      (global $g (tuple i32 (ref null $t)) (tuple.make 2
 ;; CHECK-NEXT:  (i32.const 0)
 ;; CHECK-NEXT:  (struct.new_default $t_1)
 ;; CHECK-NEXT: ))
 (global $g (tuple i32 (ref null $t))
  (tuple.make 2
   (i32.const 0)
   (struct.new $t)
  )
 )
)
