# 0.16.0 - A few release highlights

A quick tour through some `cargo msrv 0.16.0` highlights.

## The noticeable one - cargo msrv find

The tagline of `cargo-msrv` is "Find the minimum supported Rust version (MSRV) for your project".
Previously, one could achieve this by running `cargo msrv`. If you want to do the same in 0.16, you instead
should run `cargo msrv find`. The top level  `cargo msrv` action is no more.

There are two primary reasons to move this action to a subcommand instead of keeping it at the top level:

1. Consistency: `cargo msrv` can do more than that tagline, and placing all actions on the subcommand level signals that
   they're equals.
2. Unsupported CLI flags and options: When actions are placed on two layers, and one of these layers is below the other,
   then the bottom layer inherits its flags and options, even though they do not always overlap. For example, the set of
   CLI flags and options of `cargo msrv find` and `cargo msrv list` are not identical. `cargo msrv find` for example has
   an option called `--release-source` which should be present for `cargo msrv find` but not for `cargo msrv list`. If
   `cargo msrv find` would still be run as `cargo msrv`, you could also invoke this option for `cargo msrv list`, like
   so: `cargo msrv --release-source rust-dist list`. However, contextually, the `--release-source` option does not make
   sense for `cargo msrv list`, so previously it was ignored. By making `cargo msrv find` a subcommand like
   `cargo msrv list`, the flags and options which are not shared between all actions can be put solely below their own
   subcommand.

A consequence of (2) is that some unnecessary options and flags have been removed from the top level, and so this is a
breaking change, not just for `cargo msrv find` but also for `cargo msrv list`.

Minor reasons for this change include that I can now talk about `cargo msrv find` as "`cargo msrv find`" instead of
`cargo msrv (find)` or "the top level command". Plus, it addressed some difficulties around the code which does CLI
parsing.

## The UI part 1: output format options

The way the UI is rendered has been updated. Internally, it is now easier to add and maintain different output formats.

`cargo-msrv` now supports 3 output formats:

- human (the default one, intended for the human eye)
- json (intended for machine readability)
- minimal (\*new\*, it was requested for environments where people only care about success/failure, such as CI)

## The UI part 2: `cargo msrv find` and `verify` "human" output

As they say, "a picture is a thousand words":

**Previously...**

[![asciicast](https://asciinema.org/a/465459.svg)](https://asciinema.org/a/465459)

**New...**

[![asciicast](https://asciinema.org/a/JGyYmk7LNJvfDrc2oMQEt0SFF.svg)](https://asciinema.org/a/JGyYmk7LNJvfDrc2oMQEt0SFF)

I'll be iterating the UI further in the future. Constructive feedback is more than welcome!

## `cargo msrv find --write-msrv`

This option will write the MSRV to your Cargo manifest:

[![asciicast](https://asciinema.org/a/679863.svg)](https://asciinema.org/a/679863?t=47)

## `cargo msrv find --min` and `--max`

The `--min` and `--max` options would previously only take three component semver versions like "1.2.3" or editions. It
is common to specify the MSRV in a two component version like "1.2", so these are now also supported.

## `cargo msrv verify --rust-version`

`cargo msrv verify` can be used to check whether your project is compatible with its MSRV. The MSRV is usually read from
the Cargo manifest (`Cargo.toml`). Sometimes it can be useful to provide it manually instead. That's where this option
comes in handy.

It should be noted that `cargo-msrv` does, at present, not unset any value you may have specified in the
Cargo manifest. So if you have a Cargo manifest with `rust-version = "1.56.0"` and supply the `--rust-version` option
with the value `1.55.0`, the cargo project will (if the default options are used) fail to compile, and as a consequence
`cargo-msrv` will report that your crate is not compatible with the specified MSRV.

## Fetching the rust releases index

The rust releases index, the thing we use to figure out which Rust versions exist, are now only fetched when a
subcommand needs it (currently `cargo msrv find` and `cargo msrv verify`).

## The changelog

The complete changelog can be found [here](https://github.com/foresterre/cargo-msrv/blob/main/CHANGELOG.md).

## Thanks!

Thanks to all contributors, whether you submitted a [PR](https://github.com/foresterre/cargo-msrv/pulls) or reported
an [issue](https://github.com/foresterre/cargo-msrv/issues). Some reported issues and PR's really made my day! 💛