/* Unit testing for outcomes
(C) 2013-2025 Niall Douglas <http://www.nedproductions.biz/> (1 commit)


Boost Software License - Version 1.0 - August 17th, 2003

Permission is hereby granted, free of charge, to any person or organization
obtaining a copy of the software and accompanying documentation covered by
this license (the "Software") to use, reproduce, display, distribute,
execute, and transmit the Software, and to prepare derivative works of the
Software, and to permit third-parties to whom the Software is furnished to
do so, all subject to the following:

The copyright notices in the Software and this entire statement, including
the above license grant, this restriction and the following disclaimer,
must be included in all copies of the Software, in whole or in part, and
all derivative works of the Software, unless such copies or derivative
works are solely in the form of machine-executable object code generated by
a source language processor.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

#include <boost/outcome/outcome.hpp>
#include <boost/outcome/try.hpp>
#include <boost/test/unit_test.hpp>
#include <boost/test/unit_test_monitor.hpp>

namespace issues247
{
  namespace outcome = BOOST_OUTCOME_V2_NAMESPACE;

  outcome::result<int> foo1()
  {
    outcome::result<int> ret(boost::system::errc::invalid_argument);
    outcome::hooks::set_spare_storage(&ret, 43);
    return ret;
  }

  outcome::result<int> test1()
  {
    BOOST_OUTCOME_TRY(foo1());
    return 7;
  }

  outcome::result<int> foo2() { return outcome::success(5, 43); }

  outcome::result<int> test2() { return foo2(); }

  outcome::outcome<int> foo3()
  {
    outcome::outcome<int> ret(boost::copy_exception(std::runtime_error("foo")));
    outcome::hooks::set_spare_storage(&ret, 43);
    return ret;
  }

  outcome::outcome<int> test3()
  {
    BOOST_OUTCOME_TRY(foo3());
    return 7;
  }

}  // namespace issues247


BOOST_OUTCOME_AUTO_TEST_CASE(issues_0247_test, "TRY strips spare storage value")
{
  auto r1 = issues247::test1();
  BOOST_CHECK(issues247::outcome::hooks::spare_storage(&r1) == 43);
  auto r2 = issues247::test2();
  BOOST_CHECK(issues247::outcome::hooks::spare_storage(&r2) == 43);
  auto r3 = issues247::test3();
  BOOST_CHECK(issues247::outcome::hooks::spare_storage(&r3) == 43);
}
