
#ifndef VTKIOPOSTGRESQL_EXPORT_H
#define VTKIOPOSTGRESQL_EXPORT_H

#ifdef VTKIOPOSTGRESQL_STATIC_DEFINE
#  define VTKIOPOSTGRESQL_EXPORT
#  define VTKIOPOSTGRESQL_NO_EXPORT
#else
#  ifndef VTKIOPOSTGRESQL_EXPORT
#    ifdef IOPostgreSQL_EXPORTS
        /* We are building this library */
#      define VTKIOPOSTGRESQL_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define VTKIOPOSTGRESQL_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef VTKIOPOSTGRESQL_NO_EXPORT
#    define VTKIOPOSTGRESQL_NO_EXPORT 
#  endif
#endif

#ifndef VTKIOPOSTGRESQL_DEPRECATED
#  define VTKIOPOSTGRESQL_DEPRECATED __declspec(deprecated)
#endif

#ifndef VTKIOPOSTGRESQL_DEPRECATED_EXPORT
#  define VTKIOPOSTGRESQL_DEPRECATED_EXPORT VTKIOPOSTGRESQL_EXPORT VTKIOPOSTGRESQL_DEPRECATED
#endif

#ifndef VTKIOPOSTGRESQL_DEPRECATED_NO_EXPORT
#  define VTKIOPOSTGRESQL_DEPRECATED_NO_EXPORT VTKIOPOSTGRESQL_NO_EXPORT VTKIOPOSTGRESQL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef VTKIOPOSTGRESQL_NO_DEPRECATED
#    define VTKIOPOSTGRESQL_NO_DEPRECATED
#  endif
#endif

/* VTK-HeaderTest-Exclude: vtkIOPostgreSQLModule.h */

/* Include ABI Namespace */
#include "vtkABINamespace.h"
/* AutoInit dependencies. */
#include "vtkIOSQLModule.h"


/* AutoInit implementations. */
#ifdef vtkIOPostgreSQL_AUTOINIT_INCLUDE
#include vtkIOPostgreSQL_AUTOINIT_INCLUDE
#endif
#ifdef vtkIOPostgreSQL_AUTOINIT
#include "vtkAutoInit.h"
VTK_MODULE_AUTOINIT(vtkIOPostgreSQL)
#endif

#endif /* VTKIOPOSTGRESQL_EXPORT_H */
