








// This file contains the native implementations for JNI
// functions used in Liblktlang.java

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <jni.h>

#include "com_adacore_liblktlang_Liblktlang_JNI_LIB.h"
#include "liblktlang.h"

// ==========
// Global declarations
// ==========

char jvm_running = 0;

// ==========
// Type declaration
// ==========

// Structure to store the information for event handler
typedef struct {
    JNIEnv *env;
    jobject unit_requested_callback;
    jobject unit_parsed_callback;
} event_handler_data;

// ==========
// Function delcarations
// ==========

jclass main_class_ref = NULL;
jmethodID encodeUTF32_method_id = NULL;
jmethodID decodeUTF32_method_id = NULL;
jmethodID check_exception_method_id = NULL;

void * PointerWrapper_new_value();
jobject PointerWrapper_wrap(JNIEnv *, void *);
void * PointerWrapper_unwrap(JNIEnv *, jobject);

jclass PointerWrapper_class_ref = NULL;
jmethodID PointerWrapper_constructor_id = NULL;
jmethodID PointerWrapper_getter_id = NULL;

lkt_exception LangkitException_new_value();
jthrowable LangkitException_wrap(JNIEnv *, lkt_exception);

jclass LangkitStackTrace_class_ref = NULL;
jmethodID LangkitStackTrace_constructor_id = NULL;

jclass LangkitException_class_ref = NULL;
jmethodID LangkitException_constructor_id = NULL;

lkt_token_kind TokenKind_new_value();
jobject TokenKind_wrap(JNIEnv *, lkt_token_kind);
lkt_token_kind TokenKind_unwrap(JNIEnv *, jobject);

jclass TokenKind_class_ref = NULL;
jmethodID TokenKind_from_c_method_id = NULL;
jmethodID TokenKind_to_c_method_id = NULL;


    

lkt_analysis_unit_kind AnalysisUnitKind_new_value();
jobject AnalysisUnitKind_wrap(JNIEnv *, lkt_analysis_unit_kind);
lkt_analysis_unit_kind AnalysisUnitKind_unwrap(JNIEnv *, jobject);

jclass AnalysisUnitKind_class_ref = NULL;
jmethodID AnalysisUnitKind_from_c_method_id = NULL;
jmethodID AnalysisUnitKind_to_c_method_id = NULL;


    

lkt_completion_item_kind CompletionItemKind_new_value();
jobject CompletionItemKind_wrap(JNIEnv *, lkt_completion_item_kind);
lkt_completion_item_kind CompletionItemKind_unwrap(JNIEnv *, jobject);

jclass CompletionItemKind_class_ref = NULL;
jmethodID CompletionItemKind_from_c_method_id = NULL;
jmethodID CompletionItemKind_to_c_method_id = NULL;


    

lkt_designated_env_kind DesignatedEnvKind_new_value();
jobject DesignatedEnvKind_wrap(JNIEnv *, lkt_designated_env_kind);
lkt_designated_env_kind DesignatedEnvKind_unwrap(JNIEnv *, jobject);

jclass DesignatedEnvKind_class_ref = NULL;
jmethodID DesignatedEnvKind_from_c_method_id = NULL;
jmethodID DesignatedEnvKind_to_c_method_id = NULL;


    

lkt_grammar_rule GrammarRule_new_value();
jobject GrammarRule_wrap(JNIEnv *, lkt_grammar_rule);
lkt_grammar_rule GrammarRule_unwrap(JNIEnv *, jobject);

jclass GrammarRule_class_ref = NULL;
jmethodID GrammarRule_from_c_method_id = NULL;
jmethodID GrammarRule_to_c_method_id = NULL;


    

lkt_lookup_kind LookupKind_new_value();
jobject LookupKind_wrap(JNIEnv *, lkt_lookup_kind);
lkt_lookup_kind LookupKind_unwrap(JNIEnv *, jobject);

jclass LookupKind_class_ref = NULL;
jmethodID LookupKind_from_c_method_id = NULL;
jmethodID LookupKind_to_c_method_id = NULL;


uint32_t Char_new_value();
jobject Char_wrap(JNIEnv *, uint32_t);
uint32_t Char_unwrap(JNIEnv *, jobject);

jclass Char_class_ref = NULL;
jmethodID Char_constructor_id = NULL;
jfieldID Char_value_field_id = NULL;

lkt_big_integer BigIntegerWrapper_new_value();
jobject BigIntegerWrapper_wrap(JNIEnv *, lkt_big_integer);
lkt_big_integer BigIntegerWrapper_unwrap(JNIEnv *, jobject);
void BigIntegerWrapper_release(lkt_big_integer);

jclass BigInteger_class_ref = NULL;
jmethodID BigInteger_constructor_id = NULL;
jmethodID BigInteger_to_string_method_id = NULL;

lkt_symbol_type Symbol_new_value();
jobject Symbol_wrap(JNIEnv *, lkt_symbol_type);
lkt_symbol_type Symbol_unwrap(JNIEnv *, jobject, lkt_analysis_context);
jthrowable new_symbol_exception(JNIEnv *, jstring);

jclass Symbol_class_ref = NULL;
jmethodID Symbol_constructor_id = NULL;
jfieldID Symbol_text_field_id = NULL;
jclass SymbolException_class_ref = NULL;
jmethodID SymbolException_constructor_id = NULL;

lkt_string_type StringWrapper_new_value();
jobject StringWrapper_wrap(JNIEnv *, lkt_string_type);
lkt_string_type StringWrapper_unwrap(JNIEnv *, jobject);
void StringWrapper_release(lkt_string_type);

lkt_text Text_new_value();
jobject Text_wrap(JNIEnv *, lkt_text);
lkt_text Text_unwrap(JNIEnv *, jobject);
jstring get_text_content(JNIEnv *, jobject);
jobject text_from_content(JNIEnv *, jstring);

jclass Text_class_ref = NULL;
jmethodID Text_constructor_id = NULL;
jmethodID Text_extended_constructor_id = NULL;
jmethodID Text_create_method_id = NULL;
jmethodID Text_get_content_method_id = NULL;
jfieldID Text_chars_field_id = NULL;
jfieldID Text_length_field_id = NULL;
jfieldID Text_is_allocated_field_id = NULL;
jfieldID Text_is_owner_field_id = NULL;

lkt_source_location SourceLocation_new_value();
jobject SourceLocation_wrap(JNIEnv *, lkt_source_location);
lkt_source_location SourceLocation_unwrap(JNIEnv *, jobject);

jclass Support_SourceLocation_class_ref = NULL;
jfieldID Support_SourceLocation_line_field_id = NULL;
jfieldID Support_SourceLocation_column_field_id = NULL;

jclass SourceLocation_class_ref = NULL;
jmethodID SourceLocation_constructor_id = NULL;
jfieldID SourceLocation_line_field_id = NULL;
jfieldID SourceLocation_column_field_id = NULL;

lkt_source_location_range SourceLocationRange_new_value();
jobject SourceLocationRange_wrap(JNIEnv *, lkt_source_location_range);
lkt_source_location_range SourceLocationRange_unwrap(JNIEnv *, jobject);

jclass Support_SourceLocationRange_class_ref = NULL;
jfieldID Support_SourceLocationRange_start_field_id = NULL;
jfieldID Support_SourceLocationRange_end_field_id = NULL;

jclass SourceLocationRange_class_ref = NULL;
jmethodID SourceLocationRange_constructor_id = NULL;

lkt_diagnostic Diagnostic_new_value();
jobject Diagnostic_wrap(JNIEnv *, lkt_diagnostic);
lkt_diagnostic Diagnostic_unwrap(JNIEnv *, jobject);

jclass Diagnostic_class_ref = NULL;
jmethodID Diagnostic_constructor_id = NULL;
jfieldID Diagnostic_sloc_range_field_id = NULL;
jfieldID Diagnostic_text_field_id = NULL;

lkt_file_reader FileReader_new_value();
jobject FileReader_wrap(JNIEnv *, lkt_file_reader);
lkt_file_reader FileReader_unwrap(JNIEnv *, jobject);

jclass FileReader_class_ref = NULL;
jmethodID FileReader_constructor_id = NULL;
jfieldID FileReader_reference_field_id = NULL;

lkt_unit_provider UnitProvider_new_value();
jobject UnitProvider_wrap(JNIEnv *, lkt_unit_provider);
lkt_unit_provider UnitProvider_unwrap(JNIEnv *, jobject);

jclass UnitProvider_class_ref = NULL;
jmethodID UnitProvider_constructor_id = NULL;
jfieldID UnitProvider_reference_field_id = NULL;

lkt_event_handler EventHandler_new_value();
jobject EventHandler_wrap(JNIEnv *, lkt_event_handler);
lkt_event_handler EventHandler_unwrap(JNIEnv *, jobject);

jclass EventHandler_class_ref = NULL;
jmethodID EventHandler_from_reference_id = NULL;
jfieldID EventHandler_reference_field_id = NULL;
jclass UnitRequestedCallback_class_id = NULL;
jmethodID UnitRequestedCallback_invoke_id = NULL;
jclass UnitParsedCallback_class_id = NULL;
jmethodID UnitParsedCallback_invoke_id = NULL;

lkt_token Token_new_value();
jobject Token_wrap(JNIEnv *, lkt_token, jobject);
lkt_token Token_unwrap(JNIEnv *, jobject);
jobject Token_get_unit(JNIEnv *, jobject);
jobject NoToken_wrap(JNIEnv *, jobject);

jclass Token_class_ref = NULL;
jclass NoToken_class_ref = NULL;
jmethodID Token_constructor_id = NULL;
jmethodID Token_none_getter_method_id = NULL;
jfieldID Token_context_field_id = NULL;
jfieldID Token_tdh_field_id = NULL;
jfieldID Token_token_index_field_id = NULL;
jfieldID Token_trivia_index_field_id = NULL;
jfieldID Token_token_kind_field_id = NULL;
jfieldID Token_text_field_id = NULL;
jfieldID Token_sloc_range_field_id = NULL;
jfieldID Token_unit_field_id = NULL;

lkt_analysis_context AnalysisContext_new_value();
jobject AnalysisContext_wrap(JNIEnv *, lkt_analysis_context);
lkt_analysis_context AnalysisContext_unwrap(JNIEnv *, jobject);

jclass AnalysisContext_class_ref = NULL;
jmethodID AnalysisContext_from_reference_id = NULL;
jfieldID AnalysisContext_reference_field_id = NULL;

lkt_analysis_unit AnalysisUnit_new_value();
jobject AnalysisUnit_wrap(JNIEnv *, lkt_analysis_unit);
lkt_analysis_unit AnalysisUnit_unwrap(JNIEnv *, jobject);

jclass AnalysisUnit_class_ref = NULL;
jmethodID AnalysisUnit_constructor_id = NULL;
jfieldID AnalysisUnit_reference_field_id = NULL;

lkt_rewriting_apply_result RewritingApplyResult_new_value();
jobject RewritingApplyResult_wrap(JNIEnv *, lkt_rewriting_apply_result);
lkt_rewriting_apply_result RewritingApplyResult_unwrap(JNIEnv *, jobject);

jclass RewritingApplyResult_class_ref = NULL;
jmethodID RewritingApplyResult_contructor_id = NULL;
jmethodID RewritingApplyResult_success_id = NULL;
jfieldID RewritingApplyResult_success_field_id = NULL;
jfieldID RewritingApplyResult_unit_field_id = NULL;
jfieldID RewritingApplyResult_diagnostics_count_field_id = NULL;
jfieldID RewritingApplyResult_diagnostics_reference_field_id = NULL;

lkt_rewriting_handle RewritingContext_new_value();
jobject RewritingContext_wrap(JNIEnv *, lkt_rewriting_handle);
lkt_rewriting_handle RewritingContext_unwrap(JNIEnv *, jobject);

jclass RewritingContext_class_ref = NULL;
jmethodID RewritingContext_from_reference_id = NULL;
jfieldID RewritingContext_reference_field_id = NULL;

lkt_unit_rewriting_handle RewritingUnit_new_value();
jobject RewritingUnit_wrap(JNIEnv *, lkt_unit_rewriting_handle);
lkt_unit_rewriting_handle RewritingUnit_unwrap(JNIEnv *, jobject);

jclass RewritingUnit_class_ref = NULL;
jmethodID RewritingUnit_constructor_id = NULL;
jfieldID RewritingUnit_reference_field_id = NULL;

lkt_node_rewriting_handle RewritingNode_new_value();
jobject RewritingNode_wrap(JNIEnv *, lkt_node_rewriting_handle);
lkt_node_rewriting_handle RewritingNode_unwrap(JNIEnv *, jobject);

jclass RewritingNode_class_ref = NULL;
jmethodID RewritingNode_constructor_id = NULL;
jfieldID RewritingNode_reference_field_id = NULL;


    

lkt_internal_metadata Metadata_new_value();
jobject Metadata_wrap(JNIEnv *, lkt_internal_metadata);
jobject Metadata_wrap_bare_node(JNIEnv *, lkt_base_node);
lkt_internal_metadata Metadata_unwrap(JNIEnv *, jobject);


jclass Metadata_class_ref = NULL;


jfieldID Metadata_none_field_id = NULL;



    

lkt_internal_entity_info EntityInfo_new_value();
jobject EntityInfo_wrap(JNIEnv *, lkt_internal_entity_info);
jobject EntityInfo_wrap_bare_node(JNIEnv *, lkt_base_node);
lkt_internal_entity_info EntityInfo_unwrap(JNIEnv *, jobject);


jclass EntityInfo_class_ref = NULL;

jmethodID EntityInfo_constructor_id = NULL;

jfieldID EntityInfo_none_field_id = NULL;

jfieldID EntityInfo_md_field_id = NULL;
jfieldID EntityInfo_rebindings_field_id = NULL;
jfieldID EntityInfo_from_rebound_field_id = NULL;


    

lkt_node Entity_new_value();
jobject Entity_wrap(JNIEnv *, lkt_node);
jobject Entity_wrap_bare_node(JNIEnv *, lkt_base_node);
lkt_node Entity_unwrap(JNIEnv *, jobject);


jclass Entity_class_ref = NULL;

jmethodID Entity_constructor_id = NULL;

jfieldID Entity_none_field_id = NULL;

jfieldID Entity_node_field_id = NULL;
jfieldID Entity_info_field_id = NULL;


    

lkt_internal_complete_item CompleteItem_new_value();
jobject CompleteItem_wrap(JNIEnv *, lkt_internal_complete_item);
jobject CompleteItem_wrap_bare_node(JNIEnv *, lkt_base_node);
lkt_internal_complete_item CompleteItem_unwrap(JNIEnv *, jobject);


jclass CompleteItem_class_ref = NULL;

jmethodID CompleteItem_constructor_id = NULL;

jfieldID CompleteItem_none_field_id = NULL;

jfieldID CompleteItem_declaration_field_id = NULL;


    

lkt_internal_decoded_char_value DecodedCharValue_new_value();
jobject DecodedCharValue_wrap(JNIEnv *, lkt_internal_decoded_char_value);
jobject DecodedCharValue_wrap_bare_node(JNIEnv *, lkt_base_node);
lkt_internal_decoded_char_value DecodedCharValue_unwrap(JNIEnv *, jobject);

void DecodedCharValue_release(lkt_internal_decoded_char_value);

jclass DecodedCharValue_class_ref = NULL;

jmethodID DecodedCharValue_constructor_id = NULL;

jfieldID DecodedCharValue_none_field_id = NULL;

jfieldID DecodedCharValue_value_field_id = NULL;
jfieldID DecodedCharValue_has_error_field_id = NULL;
jfieldID DecodedCharValue_error_sloc_field_id = NULL;
jfieldID DecodedCharValue_error_message_field_id = NULL;


    

lkt_internal_decoded_string_value DecodedStringValue_new_value();
jobject DecodedStringValue_wrap(JNIEnv *, lkt_internal_decoded_string_value);
jobject DecodedStringValue_wrap_bare_node(JNIEnv *, lkt_base_node);
lkt_internal_decoded_string_value DecodedStringValue_unwrap(JNIEnv *, jobject);

void DecodedStringValue_release(lkt_internal_decoded_string_value);

jclass DecodedStringValue_class_ref = NULL;

jmethodID DecodedStringValue_constructor_id = NULL;

jfieldID DecodedStringValue_none_field_id = NULL;

jfieldID DecodedStringValue_value_field_id = NULL;
jfieldID DecodedStringValue_has_error_field_id = NULL;
jfieldID DecodedStringValue_error_sloc_field_id = NULL;
jfieldID DecodedStringValue_error_message_field_id = NULL;


    

lkt_internal_logic_context LogicContext_new_value();
jobject LogicContext_wrap(JNIEnv *, lkt_internal_logic_context);
jobject LogicContext_wrap_bare_node(JNIEnv *, lkt_base_node);
lkt_internal_logic_context LogicContext_unwrap(JNIEnv *, jobject);


jclass LogicContext_class_ref = NULL;

jmethodID LogicContext_constructor_id = NULL;

jfieldID LogicContext_none_field_id = NULL;

jfieldID LogicContext_ref_node_field_id = NULL;
jfieldID LogicContext_decl_node_field_id = NULL;


    

lkt_internal_ref_result RefResult_new_value();
jobject RefResult_wrap(JNIEnv *, lkt_internal_ref_result);
jobject RefResult_wrap_bare_node(JNIEnv *, lkt_base_node);
lkt_internal_ref_result RefResult_unwrap(JNIEnv *, jobject);


jclass RefResult_class_ref = NULL;

jmethodID RefResult_constructor_id = NULL;

jfieldID RefResult_none_field_id = NULL;

jfieldID RefResult_ref_field_id = NULL;


    

lkt_internal_solver_diagnostic SolverDiagnostic_new_value();
jobject SolverDiagnostic_wrap(JNIEnv *, lkt_internal_solver_diagnostic);
jobject SolverDiagnostic_wrap_bare_node(JNIEnv *, lkt_base_node);
lkt_internal_solver_diagnostic SolverDiagnostic_unwrap(JNIEnv *, jobject);

void SolverDiagnostic_release(lkt_internal_solver_diagnostic);

jclass SolverDiagnostic_class_ref = NULL;

jmethodID SolverDiagnostic_constructor_id = NULL;

jfieldID SolverDiagnostic_none_field_id = NULL;

jfieldID SolverDiagnostic_message_template_field_id = NULL;
jfieldID SolverDiagnostic_args_field_id = NULL;
jfieldID SolverDiagnostic_location_field_id = NULL;
jfieldID SolverDiagnostic_contexts_field_id = NULL;
jfieldID SolverDiagnostic_round_field_id = NULL;


    

lkt_internal_solver_result SolverResult_new_value();
jobject SolverResult_wrap(JNIEnv *, lkt_internal_solver_result);
jobject SolverResult_wrap_bare_node(JNIEnv *, lkt_base_node);
lkt_internal_solver_result SolverResult_unwrap(JNIEnv *, jobject);

void SolverResult_release(lkt_internal_solver_result);

jclass SolverResult_class_ref = NULL;

jmethodID SolverResult_constructor_id = NULL;

jfieldID SolverResult_none_field_id = NULL;

jfieldID SolverResult_success_field_id = NULL;
jfieldID SolverResult_diagnostics_field_id = NULL;



    

lkt_internal_complete_item_array CompleteItemArrayWrapper_new_value();
jobject CompleteItemArrayWrapper_wrap(JNIEnv *, lkt_internal_complete_item_array);
lkt_internal_complete_item_array CompleteItemArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void CompleteItemArrayWrapper_release(lkt_internal_complete_item_array);

jclass CompleteItemArrayWrapper_class_ref = NULL;
jmethodID CompleteItemArrayWrapper_wrap_method_id = NULL;
jmethodID CompleteItemArrayWrapper_unwrap_method_id = NULL;


    

lkt_node_array LktNodeArrayWrapper_new_value();
jobject LktNodeArrayWrapper_wrap(JNIEnv *, lkt_node_array);
lkt_node_array LktNodeArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void LktNodeArrayWrapper_release(lkt_node_array);

jclass LktNodeArrayWrapper_class_ref = NULL;
jmethodID LktNodeArrayWrapper_wrap_method_id = NULL;
jmethodID LktNodeArrayWrapper_unwrap_method_id = NULL;


    

lkt_node_array DefIdArrayWrapper_new_value();
jobject DefIdArrayWrapper_wrap(JNIEnv *, lkt_node_array);
lkt_node_array DefIdArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void DefIdArrayWrapper_release(lkt_node_array);

jclass DefIdArrayWrapper_class_ref = NULL;
jmethodID DefIdArrayWrapper_wrap_method_id = NULL;
jmethodID DefIdArrayWrapper_unwrap_method_id = NULL;


    

lkt_node_array FunDeclArrayWrapper_new_value();
jobject FunDeclArrayWrapper_wrap(JNIEnv *, lkt_node_array);
lkt_node_array FunDeclArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void FunDeclArrayWrapper_release(lkt_node_array);

jclass FunDeclArrayWrapper_class_ref = NULL;
jmethodID FunDeclArrayWrapper_wrap_method_id = NULL;
jmethodID FunDeclArrayWrapper_unwrap_method_id = NULL;


    

lkt_internal_logic_context_array LogicContextArrayWrapper_new_value();
jobject LogicContextArrayWrapper_wrap(JNIEnv *, lkt_internal_logic_context_array);
lkt_internal_logic_context_array LogicContextArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void LogicContextArrayWrapper_release(lkt_internal_logic_context_array);

jclass LogicContextArrayWrapper_class_ref = NULL;
jmethodID LogicContextArrayWrapper_wrap_method_id = NULL;
jmethodID LogicContextArrayWrapper_unwrap_method_id = NULL;


    

lkt_internal_ref_result_array RefResultArrayWrapper_new_value();
jobject RefResultArrayWrapper_wrap(JNIEnv *, lkt_internal_ref_result_array);
lkt_internal_ref_result_array RefResultArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void RefResultArrayWrapper_release(lkt_internal_ref_result_array);

jclass RefResultArrayWrapper_class_ref = NULL;
jmethodID RefResultArrayWrapper_wrap_method_id = NULL;
jmethodID RefResultArrayWrapper_unwrap_method_id = NULL;


    

lkt_internal_solver_diagnostic_array SolverDiagnosticArrayWrapper_new_value();
jobject SolverDiagnosticArrayWrapper_wrap(JNIEnv *, lkt_internal_solver_diagnostic_array);
lkt_internal_solver_diagnostic_array SolverDiagnosticArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void SolverDiagnosticArrayWrapper_release(lkt_internal_solver_diagnostic_array);

jclass SolverDiagnosticArrayWrapper_class_ref = NULL;
jmethodID SolverDiagnosticArrayWrapper_wrap_method_id = NULL;
jmethodID SolverDiagnosticArrayWrapper_unwrap_method_id = NULL;


    

lkt_analysis_unit_array AnalysisUnitArrayWrapper_new_value();
jobject AnalysisUnitArrayWrapper_wrap(JNIEnv *, lkt_analysis_unit_array);
lkt_analysis_unit_array AnalysisUnitArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void AnalysisUnitArrayWrapper_release(lkt_analysis_unit_array);

jclass AnalysisUnitArrayWrapper_class_ref = NULL;
jmethodID AnalysisUnitArrayWrapper_wrap_method_id = NULL;
jmethodID AnalysisUnitArrayWrapper_unwrap_method_id = NULL;



jclass LktNode_class_ref = NULL;
jmethodID LktNode_from_entity_id = NULL;
jfieldID LktNode_entity_field_id = NULL;

// ==========
// Lifecycle functions
// ==========

JNIEXPORT void Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1initialize(
    JNIEnv *env,
    jclass jni_lib
) {
    jvm_running = 1;

    main_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang")
    );

    encodeUTF32_method_id = (*env)->GetStaticMethodID(
        env,
        main_class_ref,
        "encodeUTF32",
        "(Ljava/lang/String;)[B"
    );

    decodeUTF32_method_id = (*env)->GetStaticMethodID(
        env,
        main_class_ref,
        "decodeUTF32",
        "([B)Ljava/lang/String;"
    );

    check_exception_method_id = (*env)->GetStaticMethodID(
        env,
        main_class_ref,
        "checkException",
        "()V"
    );

    PointerWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$PointerWrapper")
    );

    PointerWrapper_constructor_id = (*env)->GetMethodID(
        env,
        PointerWrapper_class_ref,
        "<init>",
        "(J)V"
    );

    PointerWrapper_getter_id = (*env)->GetMethodID(
        env,
        PointerWrapper_class_ref,
        "jni",
        "()J"
    );

    LangkitStackTrace_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$LangkitStackTrace")
    );

    LangkitStackTrace_constructor_id = (*env)->GetMethodID(
        env,
        LangkitStackTrace_class_ref,
        "<init>",
        "(Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;)V"
    );

    LangkitException_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$LangkitException")
    );

    LangkitException_constructor_id = (*env)->GetMethodID(
        env,
        LangkitException_class_ref,
        "<init>",
        "(ILjava/lang/String;Lcom/adacore/liblktlang/Liblktlang$LangkitStackTrace;)V"
    );

    Symbol_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$Symbol")
    );

    Symbol_constructor_id = (*env)->GetMethodID(
        env,
        Symbol_class_ref,
        "<init>",
        "(Ljava/lang/String;)V"
    );

    Symbol_text_field_id = (*env)->GetFieldID(
        env,
        Symbol_class_ref,
        "text",
        "Ljava/lang/String;"
    );

    SymbolException_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$SymbolException")
    );

    SymbolException_constructor_id = (*env)->GetMethodID(
        env,
        SymbolException_class_ref,
        "<init>",
        "(Ljava/lang/String;)V"
    );

    Text_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$Text")
    );

    Text_constructor_id = (*env)->GetMethodID(
        env,
        Text_class_ref,
        "<init>",
        "(Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;JZ[B)V"
    );

    Text_extended_constructor_id = (*env)->GetMethodID(
        env,
        Text_class_ref,
        "<init>",
        "(Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;JZZ[B)V"
    );

    Text_create_method_id = (*env)->GetStaticMethodID(
        env,
        Text_class_ref,
        "create",
        "(Ljava/lang/String;)Lcom/adacore/liblktlang/Liblktlang$Text;"
    );

    Text_get_content_method_id = (*env)->GetMethodID(
        env,
        Text_class_ref,
        "getContent",
        "()Ljava/lang/String;"
    );

    Text_chars_field_id = (*env)->GetFieldID(
        env,
        Text_class_ref,
        "charPointer",
        "Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;"
    );

    Text_length_field_id = (*env)->GetFieldID(
        env,
        Text_class_ref,
        "length",
        "J"
    );

    Text_is_allocated_field_id = (*env)->GetFieldID(
        env,
        Text_class_ref,
        "isAllocated",
        "Z"
    );

    Text_is_owner_field_id = (*env)->GetFieldID(
        env,
        Text_class_ref,
        "isOwner",
        "Z"
    );

    Support_SourceLocation_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/langkit_support/LangkitSupport$SourceLocation")
    );

    Support_SourceLocation_line_field_id = (*env)->GetFieldID(
        env,
        Support_SourceLocation_class_ref,
        "line",
        "I"
    );

    Support_SourceLocation_column_field_id = (*env)->GetFieldID(
        env,
        Support_SourceLocation_class_ref,
        "column",
        "S"
    );

    SourceLocation_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$SourceLocation")
    );

    SourceLocation_constructor_id = (*env)->GetMethodID(
        env,
        SourceLocation_class_ref,
        "<init>",
        "(IS)V"
    );

    TokenKind_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$TokenKind")
    );

    TokenKind_from_c_method_id = (*env)->GetStaticMethodID(
        env,
        TokenKind_class_ref,
        "fromC",
        "(I)Lcom/adacore/liblktlang/Liblktlang$TokenKind;"
    );

    TokenKind_to_c_method_id = (*env)->GetMethodID(
        env,
        TokenKind_class_ref,
        "toC",
        "()I"
    );

    Char_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$Char")
    );

    Char_constructor_id = (*env)->GetMethodID(
        env,
        Char_class_ref,
        "<init>",
        "(I)V"
    );

    Char_value_field_id = (*env)->GetFieldID(
        env,
        Char_class_ref,
        "value",
        "I"
    );

    BigInteger_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "java/math/BigInteger")
    );

    BigInteger_constructor_id = (*env)->GetMethodID(
        env,
        BigInteger_class_ref,
        "<init>",
        "(Ljava/lang/String;)V"
    );

    BigInteger_to_string_method_id = (*env)->GetMethodID(
        env,
        BigInteger_class_ref,
        "toString",
        "()Ljava/lang/String;"
    );

    Support_SourceLocationRange_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/langkit_support/LangkitSupport$SourceLocationRange"
        )
    );

    Support_SourceLocationRange_start_field_id = (*env)->GetFieldID(
        env,
        Support_SourceLocationRange_class_ref,
        "start",
        "Lcom/adacore/langkit_support/LangkitSupport$SourceLocation;"
    );

    Support_SourceLocationRange_end_field_id = (*env)->GetFieldID(
        env,
        Support_SourceLocationRange_class_ref,
        "end",
        "Lcom/adacore/langkit_support/LangkitSupport$SourceLocation;"
    );

    SourceLocationRange_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$SourceLocationRange")
    );

    SourceLocationRange_constructor_id = (*env)->GetMethodID(
        env,
        SourceLocationRange_class_ref,
        "<init>",
        "(Lcom/adacore/liblktlang/Liblktlang$SourceLocation;Lcom/adacore/liblktlang/Liblktlang$SourceLocation;)V"
    );

    Diagnostic_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$Diagnostic")
    );

    Diagnostic_constructor_id = (*env)->GetMethodID(
        env,
        Diagnostic_class_ref,
        "<init>",
        "(Lcom/adacore/liblktlang/Liblktlang$SourceLocationRange;Lcom/adacore/liblktlang/Liblktlang$Text;)V"
    );

    Diagnostic_sloc_range_field_id = (*env)->GetFieldID(
        env,
        Diagnostic_class_ref,
        "sourceLocationRange",
        "Lcom/adacore/liblktlang/Liblktlang$SourceLocationRange;"
    );

    Diagnostic_text_field_id = (*env)->GetFieldID(
        env,
        Diagnostic_class_ref,
        "message",
        "Lcom/adacore/liblktlang/Liblktlang$Text;"
    );

    FileReader_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$FileReader")
    );

    FileReader_constructor_id = (*env)->GetMethodID(
        env,
        FileReader_class_ref,
        "<init>",
        "(Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;)V"
    );

    FileReader_reference_field_id = (*env)->GetFieldID(
        env,
        FileReader_class_ref,
        "reference",
        "Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;"
    );

    UnitProvider_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$UnitProvider")
    );

    UnitProvider_constructor_id = (*env)->GetMethodID(
        env,
        UnitProvider_class_ref,
        "<init>",
        "(Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;)V"
    );

    UnitProvider_reference_field_id = (*env)->GetFieldID(
        env,
        UnitProvider_class_ref,
        "reference",
        "Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;"
    );

    EventHandler_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$EventHandler")
    );

    EventHandler_from_reference_id = (*env)->GetStaticMethodID(
        env,
        EventHandler_class_ref,
        "fromReference",
        "(Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;)Lcom/adacore/liblktlang/Liblktlang$EventHandler;"
    );

    EventHandler_reference_field_id = (*env)->GetFieldID(
        env,
        EventHandler_class_ref,
        "reference",
        "Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;"
    );

    UnitRequestedCallback_class_id = (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/liblktlang/Liblktlang$EventHandler$UnitRequestedCallback"
        )
    );

    UnitRequestedCallback_invoke_id = (*env)->GetMethodID(
        env,
        UnitRequestedCallback_class_id,
        "invoke",
        "(Lcom/adacore/liblktlang/Liblktlang$AnalysisContext;Ljava/lang/String;"
        "Lcom/adacore/liblktlang/Liblktlang$AnalysisUnit;ZZ)V"
    );

    UnitParsedCallback_class_id = (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/liblktlang/Liblktlang$EventHandler$UnitParsedCallback"
        )
    );

    UnitParsedCallback_invoke_id = (*env)->GetMethodID(
        env,
        UnitParsedCallback_class_id,
        "invoke",
        "(Lcom/adacore/liblktlang/Liblktlang$AnalysisContext;Lcom/adacore/liblktlang/Liblktlang$AnalysisUnit;Z)V"
    );

    Token_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$Token")
    );

    NoToken_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$Token$NoToken")
    );

    Token_constructor_id = (*env)->GetMethodID(
        env,
        Token_class_ref,
        "<init>",
        "(Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;Lcom/adacore/liblktlang/Liblktlang$AnalysisUnit;Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;"
        "IILcom/adacore/liblktlang/Liblktlang$TokenKind;Ljava/lang/String;"
        "Lcom/adacore/liblktlang/Liblktlang$SourceLocationRange;)V"
    );

    Token_none_getter_method_id = (*env)->GetStaticMethodID(
        env,
        Token_class_ref,
        "NONE",
        "(Lcom/adacore/liblktlang/Liblktlang$AnalysisUnit;)Lcom/adacore/liblktlang/Liblktlang$Token;"
    );

    Token_context_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "contextRef",
        "Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;"
    );

    Token_tdh_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "tokenDataHandler",
        "Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;"
    );

    Token_token_index_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "tokenIndex",
        "I"
    );

    Token_trivia_index_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "triviaIndex",
        "I"
    );

    Token_token_kind_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "kind",
        "Lcom/adacore/liblktlang/Liblktlang$TokenKind;"
    );

    Token_text_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "text",
        "Ljava/lang/String;"
    );

    Token_sloc_range_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "sourceLocationRange",
        "Lcom/adacore/liblktlang/Liblktlang$SourceLocationRange;"
    );

    Token_unit_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "unit",
        "Lcom/adacore/liblktlang/Liblktlang$AnalysisUnit;"
    );

    AnalysisContext_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$AnalysisContext")
    );

    AnalysisContext_from_reference_id = (*env)->GetStaticMethodID(
        env,
        AnalysisContext_class_ref,
        "fromReference",
        "(Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;)Lcom/adacore/liblktlang/Liblktlang$AnalysisContext;"
    );

    AnalysisContext_reference_field_id = (*env)->GetFieldID(
        env,
        AnalysisContext_class_ref,
        "reference",
        "Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;"
    );

    AnalysisUnit_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$AnalysisUnit")
    );

    AnalysisUnit_constructor_id = (*env)->GetMethodID(
        env,
        AnalysisUnit_class_ref,
        "<init>",
        "(Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;)V"
    );

    AnalysisUnit_reference_field_id = (*env)->GetFieldID(
        env,
        AnalysisUnit_class_ref,
        "reference",
        "Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;"
    );

    RewritingApplyResult_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$RewritingApplyResult")
    );

    RewritingApplyResult_contructor_id = (*env)->GetMethodID(
        env,
        RewritingApplyResult_class_ref,
        "<init>",
        "(ZLcom/adacore/liblktlang/Liblktlang$AnalysisUnit;ILcom/adacore/liblktlang/Liblktlang$PointerWrapper;)V"
    );

    RewritingApplyResult_success_id = (*env)->GetStaticMethodID(
        env,
        RewritingApplyResult_class_ref,
        "success",
        "()Lcom/adacore/liblktlang/Liblktlang$RewritingApplyResult;"
    );

    RewritingApplyResult_success_field_id = (*env)->GetFieldID(
        env,
        RewritingApplyResult_class_ref,
        "success",
        "Z"
    );

    RewritingApplyResult_unit_field_id = (*env)->GetFieldID(
        env,
        RewritingApplyResult_class_ref,
        "unit",
        "Lcom/adacore/liblktlang/Liblktlang$AnalysisUnit;"
    );

    RewritingApplyResult_diagnostics_count_field_id = (*env)->GetFieldID(
        env,
        RewritingApplyResult_class_ref,
        "diagnosticsCount",
        "I"
    );

    RewritingApplyResult_diagnostics_reference_field_id = (*env)->GetFieldID(
        env,
        RewritingApplyResult_class_ref,
        "diagnosticsReference",
        "Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;"
    );

    RewritingContext_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$RewritingContext")
    );

    RewritingContext_from_reference_id = (*env)->GetStaticMethodID(
        env,
        RewritingContext_class_ref,
        "fromReference",
        "(Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;)Lcom/adacore/liblktlang/Liblktlang$RewritingContext;"
    );

    RewritingContext_reference_field_id = (*env)->GetFieldID(
        env,
        RewritingContext_class_ref,
        "reference",
        "Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;"
    );

    RewritingUnit_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$RewritingUnit")
    );

    RewritingUnit_constructor_id = (*env)->GetMethodID(
        env,
        RewritingUnit_class_ref,
        "<init>",
        "(Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;)V"
    );

    RewritingUnit_reference_field_id = (*env)->GetFieldID(
        env,
        RewritingUnit_class_ref,
        "reference",
        "Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;"
    );

    RewritingNode_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$RewritingNode")
    );

    RewritingNode_constructor_id = (*env)->GetMethodID(
        env,
        RewritingNode_class_ref,
        "<init>",
        "(Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;)V"
    );

    RewritingNode_reference_field_id = (*env)->GetFieldID(
        env,
        RewritingNode_class_ref,
        "reference",
        "Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;"
    );


    

    Metadata_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/liblktlang/Liblktlang$Metadata"
        )
    );


    Metadata_none_field_id = (*env)->GetStaticFieldID(
        env,
        Metadata_class_ref,
        "NONE",
        "Lcom/adacore/liblktlang/Liblktlang$Metadata;"
    );



    

    EntityInfo_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/liblktlang/Liblktlang$EntityInfo"
        )
    );

    EntityInfo_constructor_id = (*env)->GetMethodID(
        env,
        EntityInfo_class_ref,
        "<init>",
        "(Lcom/adacore/liblktlang/Liblktlang$Metadata;Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;Z)V"
    );

    EntityInfo_none_field_id = (*env)->GetStaticFieldID(
        env,
        EntityInfo_class_ref,
        "NONE",
        "Lcom/adacore/liblktlang/Liblktlang$EntityInfo;"
    );

    EntityInfo_md_field_id = (*env)->GetFieldID(
        env,
        EntityInfo_class_ref,
        "md",
        "Lcom/adacore/liblktlang/Liblktlang$Metadata;"
    );
    EntityInfo_rebindings_field_id = (*env)->GetFieldID(
        env,
        EntityInfo_class_ref,
        "rebindings",
        "Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;"
    );
    EntityInfo_from_rebound_field_id = (*env)->GetFieldID(
        env,
        EntityInfo_class_ref,
        "fromRebound",
        "Z"
    );


    

    Entity_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/liblktlang/Liblktlang$Entity"
        )
    );

    Entity_constructor_id = (*env)->GetMethodID(
        env,
        Entity_class_ref,
        "<init>",
        "(Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;Lcom/adacore/liblktlang/Liblktlang$EntityInfo;)V"
    );

    Entity_none_field_id = (*env)->GetStaticFieldID(
        env,
        Entity_class_ref,
        "NONE",
        "Lcom/adacore/liblktlang/Liblktlang$Entity;"
    );

    Entity_node_field_id = (*env)->GetFieldID(
        env,
        Entity_class_ref,
        "node",
        "Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;"
    );
    Entity_info_field_id = (*env)->GetFieldID(
        env,
        Entity_class_ref,
        "info",
        "Lcom/adacore/liblktlang/Liblktlang$EntityInfo;"
    );


    

    CompleteItem_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/liblktlang/Liblktlang$CompleteItem"
        )
    );

    CompleteItem_constructor_id = (*env)->GetMethodID(
        env,
        CompleteItem_class_ref,
        "<init>",
        "(Lcom/adacore/liblktlang/Liblktlang$Decl;)V"
    );

    CompleteItem_none_field_id = (*env)->GetStaticFieldID(
        env,
        CompleteItem_class_ref,
        "NONE",
        "Lcom/adacore/liblktlang/Liblktlang$CompleteItem;"
    );

    CompleteItem_declaration_field_id = (*env)->GetFieldID(
        env,
        CompleteItem_class_ref,
        "declaration",
        "Lcom/adacore/liblktlang/Liblktlang$Decl;"
    );


    

    DecodedCharValue_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/liblktlang/Liblktlang$DecodedCharValue"
        )
    );

    DecodedCharValue_constructor_id = (*env)->GetMethodID(
        env,
        DecodedCharValue_class_ref,
        "<init>",
        "(Lcom/adacore/liblktlang/Liblktlang$Char;ZLcom/adacore/liblktlang/Liblktlang$SourceLocation;Ljava/lang/String;)V"
    );

    DecodedCharValue_none_field_id = (*env)->GetStaticFieldID(
        env,
        DecodedCharValue_class_ref,
        "NONE",
        "Lcom/adacore/liblktlang/Liblktlang$DecodedCharValue;"
    );

    DecodedCharValue_value_field_id = (*env)->GetFieldID(
        env,
        DecodedCharValue_class_ref,
        "value",
        "Lcom/adacore/liblktlang/Liblktlang$Char;"
    );
    DecodedCharValue_has_error_field_id = (*env)->GetFieldID(
        env,
        DecodedCharValue_class_ref,
        "hasError",
        "Z"
    );
    DecodedCharValue_error_sloc_field_id = (*env)->GetFieldID(
        env,
        DecodedCharValue_class_ref,
        "errorSloc",
        "Lcom/adacore/liblktlang/Liblktlang$SourceLocation;"
    );
    DecodedCharValue_error_message_field_id = (*env)->GetFieldID(
        env,
        DecodedCharValue_class_ref,
        "errorMessage",
        "Ljava/lang/String;"
    );


    

    DecodedStringValue_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/liblktlang/Liblktlang$DecodedStringValue"
        )
    );

    DecodedStringValue_constructor_id = (*env)->GetMethodID(
        env,
        DecodedStringValue_class_ref,
        "<init>",
        "(Ljava/lang/String;ZLcom/adacore/liblktlang/Liblktlang$SourceLocation;Ljava/lang/String;)V"
    );

    DecodedStringValue_none_field_id = (*env)->GetStaticFieldID(
        env,
        DecodedStringValue_class_ref,
        "NONE",
        "Lcom/adacore/liblktlang/Liblktlang$DecodedStringValue;"
    );

    DecodedStringValue_value_field_id = (*env)->GetFieldID(
        env,
        DecodedStringValue_class_ref,
        "value",
        "Ljava/lang/String;"
    );
    DecodedStringValue_has_error_field_id = (*env)->GetFieldID(
        env,
        DecodedStringValue_class_ref,
        "hasError",
        "Z"
    );
    DecodedStringValue_error_sloc_field_id = (*env)->GetFieldID(
        env,
        DecodedStringValue_class_ref,
        "errorSloc",
        "Lcom/adacore/liblktlang/Liblktlang$SourceLocation;"
    );
    DecodedStringValue_error_message_field_id = (*env)->GetFieldID(
        env,
        DecodedStringValue_class_ref,
        "errorMessage",
        "Ljava/lang/String;"
    );


    

    LogicContext_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/liblktlang/Liblktlang$LogicContext"
        )
    );

    LogicContext_constructor_id = (*env)->GetMethodID(
        env,
        LogicContext_class_ref,
        "<init>",
        "(Lcom/adacore/liblktlang/Liblktlang$LktNode;Lcom/adacore/liblktlang/Liblktlang$LktNode;)V"
    );

    LogicContext_none_field_id = (*env)->GetStaticFieldID(
        env,
        LogicContext_class_ref,
        "NONE",
        "Lcom/adacore/liblktlang/Liblktlang$LogicContext;"
    );

    LogicContext_ref_node_field_id = (*env)->GetFieldID(
        env,
        LogicContext_class_ref,
        "refNode",
        "Lcom/adacore/liblktlang/Liblktlang$LktNode;"
    );
    LogicContext_decl_node_field_id = (*env)->GetFieldID(
        env,
        LogicContext_class_ref,
        "declNode",
        "Lcom/adacore/liblktlang/Liblktlang$LktNode;"
    );


    

    RefResult_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/liblktlang/Liblktlang$RefResult"
        )
    );

    RefResult_constructor_id = (*env)->GetMethodID(
        env,
        RefResult_class_ref,
        "<init>",
        "(Lcom/adacore/liblktlang/Liblktlang$RefId;)V"
    );

    RefResult_none_field_id = (*env)->GetStaticFieldID(
        env,
        RefResult_class_ref,
        "NONE",
        "Lcom/adacore/liblktlang/Liblktlang$RefResult;"
    );

    RefResult_ref_field_id = (*env)->GetFieldID(
        env,
        RefResult_class_ref,
        "ref",
        "Lcom/adacore/liblktlang/Liblktlang$RefId;"
    );


    

    SolverDiagnostic_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/liblktlang/Liblktlang$SolverDiagnostic"
        )
    );

    SolverDiagnostic_constructor_id = (*env)->GetMethodID(
        env,
        SolverDiagnostic_class_ref,
        "<init>",
        "(Ljava/lang/String;[Lcom/adacore/liblktlang/Liblktlang$LktNode;Lcom/adacore/liblktlang/Liblktlang$LktNode;[Lcom/adacore/liblktlang/Liblktlang$LogicContext;I)V"
    );

    SolverDiagnostic_none_field_id = (*env)->GetStaticFieldID(
        env,
        SolverDiagnostic_class_ref,
        "NONE",
        "Lcom/adacore/liblktlang/Liblktlang$SolverDiagnostic;"
    );

    SolverDiagnostic_message_template_field_id = (*env)->GetFieldID(
        env,
        SolverDiagnostic_class_ref,
        "messageTemplate",
        "Ljava/lang/String;"
    );
    SolverDiagnostic_args_field_id = (*env)->GetFieldID(
        env,
        SolverDiagnostic_class_ref,
        "args",
        "[Lcom/adacore/liblktlang/Liblktlang$LktNode;"
    );
    SolverDiagnostic_location_field_id = (*env)->GetFieldID(
        env,
        SolverDiagnostic_class_ref,
        "location",
        "Lcom/adacore/liblktlang/Liblktlang$LktNode;"
    );
    SolverDiagnostic_contexts_field_id = (*env)->GetFieldID(
        env,
        SolverDiagnostic_class_ref,
        "contexts",
        "[Lcom/adacore/liblktlang/Liblktlang$LogicContext;"
    );
    SolverDiagnostic_round_field_id = (*env)->GetFieldID(
        env,
        SolverDiagnostic_class_ref,
        "round",
        "I"
    );


    

    SolverResult_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/liblktlang/Liblktlang$SolverResult"
        )
    );

    SolverResult_constructor_id = (*env)->GetMethodID(
        env,
        SolverResult_class_ref,
        "<init>",
        "(Z[Lcom/adacore/liblktlang/Liblktlang$SolverDiagnostic;)V"
    );

    SolverResult_none_field_id = (*env)->GetStaticFieldID(
        env,
        SolverResult_class_ref,
        "NONE",
        "Lcom/adacore/liblktlang/Liblktlang$SolverResult;"
    );

    SolverResult_success_field_id = (*env)->GetFieldID(
        env,
        SolverResult_class_ref,
        "success",
        "Z"
    );
    SolverResult_diagnostics_field_id = (*env)->GetFieldID(
        env,
        SolverResult_class_ref,
        "diagnostics",
        "[Lcom/adacore/liblktlang/Liblktlang$SolverDiagnostic;"
    );



    

    AnalysisUnitKind_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$AnalysisUnitKind")
    );

    AnalysisUnitKind_from_c_method_id = (*env)->GetStaticMethodID(
        env,
        AnalysisUnitKind_class_ref,
        "fromC",
        "(I)Lcom/adacore/liblktlang/Liblktlang$AnalysisUnitKind;"
    );

    AnalysisUnitKind_to_c_method_id = (*env)->GetMethodID(
        env,
        AnalysisUnitKind_class_ref,
        "toC",
        "()I"
    );


    

    CompletionItemKind_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$CompletionItemKind")
    );

    CompletionItemKind_from_c_method_id = (*env)->GetStaticMethodID(
        env,
        CompletionItemKind_class_ref,
        "fromC",
        "(I)Lcom/adacore/liblktlang/Liblktlang$CompletionItemKind;"
    );

    CompletionItemKind_to_c_method_id = (*env)->GetMethodID(
        env,
        CompletionItemKind_class_ref,
        "toC",
        "()I"
    );


    

    DesignatedEnvKind_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$DesignatedEnvKind")
    );

    DesignatedEnvKind_from_c_method_id = (*env)->GetStaticMethodID(
        env,
        DesignatedEnvKind_class_ref,
        "fromC",
        "(I)Lcom/adacore/liblktlang/Liblktlang$DesignatedEnvKind;"
    );

    DesignatedEnvKind_to_c_method_id = (*env)->GetMethodID(
        env,
        DesignatedEnvKind_class_ref,
        "toC",
        "()I"
    );


    

    GrammarRule_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$GrammarRule")
    );

    GrammarRule_from_c_method_id = (*env)->GetStaticMethodID(
        env,
        GrammarRule_class_ref,
        "fromC",
        "(I)Lcom/adacore/liblktlang/Liblktlang$GrammarRule;"
    );

    GrammarRule_to_c_method_id = (*env)->GetMethodID(
        env,
        GrammarRule_class_ref,
        "toC",
        "()I"
    );


    

    LookupKind_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$LookupKind")
    );

    LookupKind_from_c_method_id = (*env)->GetStaticMethodID(
        env,
        LookupKind_class_ref,
        "fromC",
        "(I)Lcom/adacore/liblktlang/Liblktlang$LookupKind;"
    );

    LookupKind_to_c_method_id = (*env)->GetMethodID(
        env,
        LookupKind_class_ref,
        "toC",
        "()I"
    );



    

    CompleteItemArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/liblktlang/Liblktlang$CompleteItemArrayWrapper;")
    );

    CompleteItemArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        CompleteItemArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/liblktlang/Liblktlang$CompleteItem;)[Lcom/adacore/liblktlang/Liblktlang$CompleteItem;"
    );

    CompleteItemArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        CompleteItemArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/liblktlang/Liblktlang$CompleteItem;)[Lcom/adacore/liblktlang/Liblktlang$CompleteItem;"
    );


    

    LktNodeArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/liblktlang/Liblktlang$LktNodeArrayWrapper;")
    );

    LktNodeArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        LktNodeArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/liblktlang/Liblktlang$Entity;)[Lcom/adacore/liblktlang/Liblktlang$LktNode;"
    );

    LktNodeArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        LktNodeArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/liblktlang/Liblktlang$LktNode;)[Lcom/adacore/liblktlang/Liblktlang$Entity;"
    );


    

    DefIdArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/liblktlang/Liblktlang$DefIdArrayWrapper;")
    );

    DefIdArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        DefIdArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/liblktlang/Liblktlang$Entity;)[Lcom/adacore/liblktlang/Liblktlang$DefId;"
    );

    DefIdArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        DefIdArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/liblktlang/Liblktlang$DefId;)[Lcom/adacore/liblktlang/Liblktlang$Entity;"
    );


    

    FunDeclArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/liblktlang/Liblktlang$FunDeclArrayWrapper;")
    );

    FunDeclArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        FunDeclArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/liblktlang/Liblktlang$Entity;)[Lcom/adacore/liblktlang/Liblktlang$FunDecl;"
    );

    FunDeclArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        FunDeclArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/liblktlang/Liblktlang$FunDecl;)[Lcom/adacore/liblktlang/Liblktlang$Entity;"
    );


    

    LogicContextArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/liblktlang/Liblktlang$LogicContextArrayWrapper;")
    );

    LogicContextArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        LogicContextArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/liblktlang/Liblktlang$LogicContext;)[Lcom/adacore/liblktlang/Liblktlang$LogicContext;"
    );

    LogicContextArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        LogicContextArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/liblktlang/Liblktlang$LogicContext;)[Lcom/adacore/liblktlang/Liblktlang$LogicContext;"
    );


    

    RefResultArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/liblktlang/Liblktlang$RefResultArrayWrapper;")
    );

    RefResultArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        RefResultArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/liblktlang/Liblktlang$RefResult;)[Lcom/adacore/liblktlang/Liblktlang$RefResult;"
    );

    RefResultArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        RefResultArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/liblktlang/Liblktlang$RefResult;)[Lcom/adacore/liblktlang/Liblktlang$RefResult;"
    );


    

    SolverDiagnosticArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/liblktlang/Liblktlang$SolverDiagnosticArrayWrapper;")
    );

    SolverDiagnosticArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        SolverDiagnosticArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/liblktlang/Liblktlang$SolverDiagnostic;)[Lcom/adacore/liblktlang/Liblktlang$SolverDiagnostic;"
    );

    SolverDiagnosticArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        SolverDiagnosticArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/liblktlang/Liblktlang$SolverDiagnostic;)[Lcom/adacore/liblktlang/Liblktlang$SolverDiagnostic;"
    );


    

    AnalysisUnitArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/liblktlang/Liblktlang$AnalysisUnitArrayWrapper;")
    );

    AnalysisUnitArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        AnalysisUnitArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/liblktlang/Liblktlang$AnalysisUnit;)[Lcom/adacore/liblktlang/Liblktlang$AnalysisUnit;"
    );

    AnalysisUnitArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        AnalysisUnitArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/liblktlang/Liblktlang$AnalysisUnit;)[Lcom/adacore/liblktlang/Liblktlang$AnalysisUnit;"
    );



    LktNode_class_ref = (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/liblktlang/Liblktlang$LktNode")
    );

    LktNode_from_entity_id = (*env)->GetStaticMethodID(
        env,
        LktNode_class_ref,
        "fromEntity",
        "(Lcom/adacore/liblktlang/Liblktlang$Entity;)Lcom/adacore/liblktlang/Liblktlang$LktNode;"
    );

    LktNode_entity_field_id = (*env)->GetFieldID(
        env,
        LktNode_class_ref,
        "entity",
        "Lcom/adacore/liblktlang/Liblktlang$Entity;"
    );
}

// Function to finalize the JNI library
JNIEXPORT void Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1finalize(
    JNIEnv *env,
    jclass jni_lib
) {
    jvm_running = 0;
}

// ==========
// Util functions
// ==========

// Get the native reference in a Java object
void * get_reference(
    JNIEnv *env,
    jobject object
) {
    // Get the object class
    jclass clazz = (*env)->GetObjectClass(env, object);

    // Get the reference field
    jfieldID reference_field = (*env)->GetFieldID(
        env,
        clazz,
        "reference",
        "Lcom/adacore/liblktlang/Liblktlang$PointerWrapper;"
    );
    jobject reference = (*env)->GetObjectField(env, object, reference_field);

    // Unwrap the reference field to get pointer
    return PointerWrapper_unwrap(env, reference);
}

// Translate a Java string to a C char pointer with the UTF-8 encoding
const char * to_c_string(
    JNIEnv *env,
    jstring j_string
) {
    return (*env)->GetStringUTFChars(env, j_string, NULL);
}

// Release the given C string associated with the given Java string
void release_c_string(
    JNIEnv *env,
    jstring j_string,
    const char *c_string
) {
    (*env)->ReleaseStringUTFChars(env, j_string, c_string);
}

// Create a Java string from a C char pointer
jstring to_j_string(
    JNIEnv *env,
    const char *c_string
) {
    if (c_string == NULL) {
        return NULL;
    }
    return (*env)->NewStringUTF(env, c_string);
}

// Decode an UTF 32 buffer in a Java string
jstring decode_utf_32(
    JNIEnv *env,
    size_t length,
    uint32_t *to_decode
) {
    // Create a byte array from the buffer to decode
    const jbyte *byte_buffer = (jbyte *) to_decode;
    jsize byte_length = (jsize) (length * 4);
    jbyteArray byte_array = (*env)->NewByteArray(
        env,
        byte_length
    );
    (*env)->SetByteArrayRegion(
        env,
        byte_array,
        0,
        byte_length,
        byte_buffer
    );

    // Call the Java method and return the result
    return (jstring) (*env)->CallStaticObjectMethod(
        env,
        main_class_ref,
        decodeUTF32_method_id,
        byte_array
    );
}

// Encode a Java string in a native buffer
void encode_utf_32(
    JNIEnv *env,
    jstring string,
    size_t *length_ref,
    uint32_t **buffer_ref
) {
    // Call the Java method to get the byte array
    jbyteArray byte_array = (jbyteArray) (*env)->CallStaticObjectMethod(
        env,
        main_class_ref,
        encodeUTF32_method_id,
        string
    );
    size_t byte_length = (size_t) (*env)->GetArrayLength(
        env,
        byte_array
    );

    // Allocate the memory for the native buffer
    *buffer_ref = (uint32_t *) malloc(byte_length);

    // Write the native buffer and the length
    *length_ref = byte_length / 4;
    (*env)->GetByteArrayRegion(
        env,
        byte_array,
        0,
        byte_length,
        (jbyte *) *buffer_ref
    );
}

void check_exception(JNIEnv *env) {
    // Call the Java checking exception function
    (*env)->CallStaticVoidMethod(
        env,
        main_class_ref,
        check_exception_method_id
    );
}

// Util function to wrap a native entity into a Java node class
jobject node_from_entity(JNIEnv *env, jobject entity) {
    return (*env)->CallStaticObjectMethod(
        env,
        LktNode_class_ref,
        LktNode_from_entity_id,
        entity
    );
}

// Util function to get the entity Java object from a wrapped node
jobject get_node_entity(JNIEnv *env, jobject node) {
    return (*env)->GetObjectField(
        env,
        node,
        LktNode_entity_field_id
    );
}

// Function to get a rewriting node array from a Java one
lkt_node_rewriting_handle *rewriting_nodes_to_native(
    JNIEnv *env,
    jobjectArray rewriting_nodes
) {
    int size = (*env)->GetArrayLength(env, rewriting_nodes);
    lkt_node_rewriting_handle *res =
        (lkt_node_rewriting_handle *) malloc(
            size * sizeof(lkt_node_rewriting_handle)
        );
    for(int i = 0; i < size; i++) {
        res[i] = RewritingNode_unwrap(
            env,
            (*env)->GetObjectArrayElement(
                env,
                rewriting_nodes,
                (jsize) i
            )
        );
    }
    return res;
}

// ==========
// Language specific extensions
// ==========




// ==========
// Custom pointer functions
// ==========

// Create a new value for a custom pointer
void * PointerWrapper_new_value() {
    return NULL;
}

// Wrap a C pointer in a Java custom pointer
jobject PointerWrapper_wrap(
    JNIEnv *env,
    void *pointer
) {
    // Create the new custom pointer
    return (*env)->NewObject(
        env,
        PointerWrapper_class_ref,
        PointerWrapper_constructor_id,
        (jlong) pointer
    );
}

// Get the C pointer from the Java custom pointer
void * PointerWrapper_unwrap(
    JNIEnv *env,
    jobject custom_pointer
) {
    // Return the C pointer
    return (void *) (*env)->CallLongMethod(
        env,
        custom_pointer,
        PointerWrapper_getter_id
    );
}


// ==========
// Stack trace functions
// ==========

JNIEXPORT jint Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1stack_1trace_1size (
    JNIEnv *env,
    jclass jni_lib,
    jlong trace
) {
    const lkt_stack_trace t = (lkt_stack_trace) trace;
    const int size = lkt_stack_trace_size (t);
    return size;
}

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1stack_1trace_1element (
    JNIEnv *env,
    jclass jni_lib,
    jlong trace,
    jint index
) {
    const lkt_stack_trace t = (lkt_stack_trace) trace;
    void * element = lkt_stack_trace_element (t, index);
    return PointerWrapper_wrap (env, element);
}

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1create_1stack_1trace (
    JNIEnv *env,
    jclass jni_lib,
    jobjectArray elements
) {
    const int size = (int) (*env)->GetArrayLength(env, elements);
    void *elts[size];

    for (int i = 0; i < size; ++i)
    {
      jobject ptr = (*env)->GetObjectArrayElement(env, elements, (jsize) i);
      elts[i] = PointerWrapper_unwrap (env, ptr);
    }

    const lkt_stack_trace t = lkt_create_stack_trace (size, elts);
    return PointerWrapper_wrap (env, t);
}

JNIEXPORT void Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1destroy_1stack_1trace (
    JNIEnv *env,
    jclass jni_lib,
    jlong trace
) {
    const lkt_stack_trace t = (lkt_stack_trace) trace;
    lkt_destroy_stack_trace (t);
}

JNIEXPORT jthrowable Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1symbolize_1stack_1trace (
    JNIEnv *env,
    jclass jni_lib,
    jlong trace
) {
    const lkt_stack_trace t = (lkt_stack_trace) trace;
    char *c_result = lkt_symbolize_stack_trace (t);
    jstring java_result = to_j_string (env, c_result);
    free (c_result);
    return java_result;
}

// Wrap a native Langkit stack trace in a Java stack trace
jthrowable LangkitStackTrace_wrap(
    JNIEnv *env,
    lkt_stack_trace stack_trace
) {
    jthrowable ptr = PointerWrapper_wrap (env, stack_trace);
    jthrowable result = (jthrowable) (*env)->NewObject(
        env,
        LangkitStackTrace_class_ref,
        LangkitStackTrace_constructor_id,
        ptr
    );
    return result;
}

// ==========
// Exception functions
// ==========

// Create a new value for an exception
lkt_exception LangkitException_new_value() {
    lkt_exception res = {
        0,
        NULL
    };
    return res;
}

// Wrap a native langkit exception in a Java exception
jthrowable LangkitException_wrap(
    JNIEnv *env,
    lkt_exception exception
) {
    jthrowable stack_trace
        = LangkitStackTrace_wrap (env, exception.stack_trace);

    // Return the new exception instance
    return (jthrowable) (*env)->NewObject(
        env,
        LangkitException_class_ref,
        LangkitException_constructor_id,
        (jint) exception.kind,
        to_j_string(env, exception.information),
        stack_trace
    );
}

JNIEXPORT jthrowable Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1get_1last_1exception(
    JNIEnv *env,
    jclass jni_lib
) {
    // Call the native function
    const lkt_exception *last_exception = lkt_get_last_exception();

    // If last exception is null, return a null value, else wrap it
    if(last_exception == NULL) {
        return NULL;
    }
    return LangkitException_wrap(env, *last_exception);
}

// ==========
// Token kind functions
// ==========

// Create a new value for a token kind
lkt_token_kind TokenKind_new_value() {
    return 0;
}

// Wrap a native token kind in a Java class
jobject TokenKind_wrap(
    JNIEnv *env,
    lkt_token_kind enum_value_native
) {
    // Call the static method
    return (*env)->CallStaticObjectMethod(
        env,
        TokenKind_class_ref,
        TokenKind_from_c_method_id,
        (jint) enum_value_native
    );
}

// Unwrap a Java token kind as a native one
lkt_token_kind TokenKind_unwrap(
    JNIEnv *env,
    jobject enum_value
) {
    // Call the Java method
    return (lkt_token_kind) (*env)->CallIntMethod(
        env,
        enum_value,
        TokenKind_to_c_method_id
    );
}

// ==========
// Enumeration generated functions
// ==========


    

// Get a new value for the enumeration
lkt_analysis_unit_kind AnalysisUnitKind_new_value() {
    return 0;
}

// Wrap the native enum value in a Java class
jobject AnalysisUnitKind_wrap(
    JNIEnv *env,
    lkt_analysis_unit_kind enum_value_native
) {
    // Call the static method
    return (*env)->CallStaticObjectMethod(
        env,
        AnalysisUnitKind_class_ref,
        AnalysisUnitKind_from_c_method_id,
        (jint) enum_value_native
    );
}

// Unwrap a Java enum object in a native enum value
lkt_analysis_unit_kind AnalysisUnitKind_unwrap(
    JNIEnv *env,
    jobject enum_value
) {
    // Call the Java method
    return (lkt_analysis_unit_kind) (*env)->CallIntMethod(
        env,
        enum_value,
        AnalysisUnitKind_to_c_method_id
    );
}


    

// Get a new value for the enumeration
lkt_completion_item_kind CompletionItemKind_new_value() {
    return 0;
}

// Wrap the native enum value in a Java class
jobject CompletionItemKind_wrap(
    JNIEnv *env,
    lkt_completion_item_kind enum_value_native
) {
    // Call the static method
    return (*env)->CallStaticObjectMethod(
        env,
        CompletionItemKind_class_ref,
        CompletionItemKind_from_c_method_id,
        (jint) enum_value_native
    );
}

// Unwrap a Java enum object in a native enum value
lkt_completion_item_kind CompletionItemKind_unwrap(
    JNIEnv *env,
    jobject enum_value
) {
    // Call the Java method
    return (lkt_completion_item_kind) (*env)->CallIntMethod(
        env,
        enum_value,
        CompletionItemKind_to_c_method_id
    );
}


    

// Get a new value for the enumeration
lkt_designated_env_kind DesignatedEnvKind_new_value() {
    return 0;
}

// Wrap the native enum value in a Java class
jobject DesignatedEnvKind_wrap(
    JNIEnv *env,
    lkt_designated_env_kind enum_value_native
) {
    // Call the static method
    return (*env)->CallStaticObjectMethod(
        env,
        DesignatedEnvKind_class_ref,
        DesignatedEnvKind_from_c_method_id,
        (jint) enum_value_native
    );
}

// Unwrap a Java enum object in a native enum value
lkt_designated_env_kind DesignatedEnvKind_unwrap(
    JNIEnv *env,
    jobject enum_value
) {
    // Call the Java method
    return (lkt_designated_env_kind) (*env)->CallIntMethod(
        env,
        enum_value,
        DesignatedEnvKind_to_c_method_id
    );
}


    

// Get a new value for the enumeration
lkt_grammar_rule GrammarRule_new_value() {
    return 0;
}

// Wrap the native enum value in a Java class
jobject GrammarRule_wrap(
    JNIEnv *env,
    lkt_grammar_rule enum_value_native
) {
    // Call the static method
    return (*env)->CallStaticObjectMethod(
        env,
        GrammarRule_class_ref,
        GrammarRule_from_c_method_id,
        (jint) enum_value_native
    );
}

// Unwrap a Java enum object in a native enum value
lkt_grammar_rule GrammarRule_unwrap(
    JNIEnv *env,
    jobject enum_value
) {
    // Call the Java method
    return (lkt_grammar_rule) (*env)->CallIntMethod(
        env,
        enum_value,
        GrammarRule_to_c_method_id
    );
}


    

// Get a new value for the enumeration
lkt_lookup_kind LookupKind_new_value() {
    return 0;
}

// Wrap the native enum value in a Java class
jobject LookupKind_wrap(
    JNIEnv *env,
    lkt_lookup_kind enum_value_native
) {
    // Call the static method
    return (*env)->CallStaticObjectMethod(
        env,
        LookupKind_class_ref,
        LookupKind_from_c_method_id,
        (jint) enum_value_native
    );
}

// Unwrap a Java enum object in a native enum value
lkt_lookup_kind LookupKind_unwrap(
    JNIEnv *env,
    jobject enum_value
) {
    // Call the Java method
    return (lkt_lookup_kind) (*env)->CallIntMethod(
        env,
        enum_value,
        LookupKind_to_c_method_id
    );
}


// ==========
// Character functions
// ==========

// Create a new value for a character
uint32_t Char_new_value() {
    return 0;
}

// Wrap a native character in the Java wrapping class
jobject Char_wrap(
    JNIEnv *env,
    uint32_t char_native
) {
    // Return the new object
    return (*env)->NewObject(
        env,
        Char_class_ref,
        Char_constructor_id,
        char_native
    );
}

// Get a native character from a Java wrapping instance
uint32_t Char_unwrap(
    JNIEnv *env,
    jobject character
) {
    // Return the result field
    return (uint32_t) (*env)->GetIntField(
        env,
        character,
        Char_value_field_id
    );
}

// ==========
// Big integer functions
// ==========

// Create a new value for a big integer
lkt_big_integer BigIntegerWrapper_new_value() {
    return NULL;
}

// Wrap a native big integer in the Java class
jobject BigIntegerWrapper_wrap(
    JNIEnv *env,
    lkt_big_integer big_int_native
) {
    // Get the representation of the big integer
    lkt_text representation_native = Text_new_value();
    lkt_big_integer_text(
        big_int_native,
        &representation_native
    );
    jobject representation_text = Text_wrap(env, representation_native);
    jstring representation = get_text_content(env, representation_text);

    // Destroy the representation text
    lkt_destroy_text(
        &representation_native
    );

    // Return the new big integer
    return (*env)->NewObject(
        env,
        BigInteger_class_ref,
        BigInteger_constructor_id,
        representation
    );
}

// Get the native big integer from the Java wrapping instance
lkt_big_integer BigIntegerWrapper_unwrap(
    JNIEnv *env,
    jobject big_integer
) {
    // Get the representation of the big integer
    jstring representation = (*env)->CallObjectMethod(
        env,
        big_integer,
        BigInteger_to_string_method_id
    );

    // Create a text from the representations
    jobject representation_text = (*env)->CallStaticObjectMethod(
        env,
        Text_class_ref,
        Text_create_method_id,
        representation
    );
    lkt_text representation_native = Text_unwrap(env, representation_text);

    // Create a bit integer from the text
    lkt_big_integer res = lkt_create_big_integer(
        &representation_native
    );

    // Destroy the text
    free(representation_native.chars);

    // Return the result
    return res;
}

// Release the given native big integer
void BigIntegerWrapper_release(
    lkt_big_integer big_int_native
) {
    lkt_big_integer_decref(big_int_native);
}

// ==========
// Symbol functions
// ==========

// Create a new value for a symbol
lkt_symbol_type Symbol_new_value() {
    lkt_symbol_type res = {
        0,
        NULL
    };
    return res;
}

// Wrap a native symbol in the Java class
jobject Symbol_wrap(
    JNIEnv *env,
    lkt_symbol_type symbol_native
) {
    // Get the text of the symbol
    lkt_text text_native = Text_new_value();
    lkt_symbol_text(
        &symbol_native,
        &text_native
    );
    jobject text = Text_wrap(env, text_native);
    jstring symbol_text = get_text_content(env, text);

    // Destroy the text
    lkt_destroy_text(
        &text_native
    );

    // Return the new symbol
    return (*env)->NewObject(
        env,
        Symbol_class_ref,
        Symbol_constructor_id,
        symbol_text
    );
}

// Get the native symbol from the Java wrapping instance
lkt_symbol_type Symbol_unwrap(
    JNIEnv *env,
    jobject symbol,
    lkt_analysis_context context_native
) {
    // Create the result structure
    lkt_symbol_type res = Symbol_new_value();

    // Get the fields value
    jstring str = (jstring) (*env)->GetObjectField(
        env,
        symbol,
        Symbol_text_field_id
    );

    // Create a text from the symbol content
    jobject text = text_from_content(env, str);
    lkt_text text_native = Text_unwrap(env, text);

    // Call the symbol creation
    int ret_code = lkt_context_symbol(
        context_native,
        &text_native,
        &res
    );

    if(ret_code == 0) {
        // Throw a new exception
        jthrowable exception = new_symbol_exception(env, str);
        (*env)->Throw(env, exception);
    }

    // Return the result
    return res;
}

// Create a new symbol exception
jthrowable new_symbol_exception(
    JNIEnv *env,
    jstring symbol_str
) {
    // Return the exception
    return (*env)->NewObject(
        env,
        SymbolException_class_ref,
        SymbolException_constructor_id,
        symbol_str
    );
}

// ==========
// String functions
// ==========

// Create a new value for a langkit string
lkt_string_type StringWrapper_new_value() {
    return NULL;
}

// Wrap a native langkit string in the Java class
jstring StringWrapper_wrap(
    JNIEnv *env,
    lkt_string_type string_native
) {
    return decode_utf_32(
        env,
        (size_t) string_native->length,
        string_native->content
    );
}

// Get the native langkit string from a Java wrapping instance
lkt_string_type StringWrapper_unwrap(
    JNIEnv *env,
    jstring string
) {
    // Encode the Java string
    size_t length;
    uint32_t *buffer;
    encode_utf_32(
        env,
        string,
        &length,
        &buffer
    );

    // Create a new native string
    lkt_string_type res = lkt_create_string(
        buffer,
        (int) length
    );

    // Free the buffer
    free(buffer);

    // Return the result
    return res;
}

// Release the given native string
void StringWrapper_release(
    lkt_string_type string_native
) {
    lkt_string_dec_ref(string_native);
}

// ==========
// Text functions
// ==========

// Create a new value for a langkit text
lkt_text Text_new_value() {
    lkt_text res = {
        NULL,
        0,
        0
    };
    return res;
}

// Wrap a langkit text in the Java wrapping class
jobject Text_wrap(
    JNIEnv *env,
    lkt_text text_native
) {
    // Get the int array from the structure and translate it into Java array
    jbyteArray content = (*env)->NewByteArray(
        env,
        (jsize) text_native.length * 4
    );
    (*env)->SetByteArrayRegion(
        env,
        content,
        0,
        (jsize) text_native.length * 4,
        (jbyte *) text_native.chars
    );

    // Return the new text
    return (*env)->NewObject(
        env,
        Text_class_ref,
        Text_constructor_id,
        PointerWrapper_wrap(env, text_native.chars),
        (jlong) text_native.length,
        (jboolean) text_native.is_allocated,
        content
    );
}

// Unwrap a langit text from a Java wrapping instance
lkt_text Text_unwrap(
    JNIEnv *env,
    jobject text
) {
    // Create the result structure
    lkt_text res = Text_new_value();

    // Get the values
    jobject chars = (*env)->GetObjectField(
        env,
        text,
        Text_chars_field_id
    );
    jlong length = (*env)->GetLongField(
        env,
        text,
        Text_length_field_id
    );
    jboolean is_allocated = (*env)->GetBooleanField(
        env,
        text,
        Text_is_allocated_field_id
    );

    // Fill the structure with the object fields
    res.chars = (uint32_t *) PointerWrapper_unwrap(env, chars);
    res.length = (size_t) length;
    res.is_allocated = (int) is_allocated;

    // Return the result
    return res;
}

// Get the string from a text object
jstring get_text_content(
    JNIEnv *env,
    jobject text
) {
    return (jstring) (*env)->CallObjectMethod(
        env,
        text,
        Text_get_content_method_id
    );
}

// Create a text object from its string content
jobject text_from_content(
    JNIEnv *env,
    jstring content
) {
    // Call the creating method
    return (*env)->CallStaticObjectMethod(
        env,
        Text_class_ref,
        Text_create_method_id,
        content
    );
}

// Create a text Java object from its content
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1create_1text (
    JNIEnv *env,
    jclass jni_lib,
    jbyteArray content_utf32
) {
    // Get the content in a memory buffer
    size_t length = ((size_t) (*env)->GetArrayLength(env, content_utf32)) / 4;
    uint32_t *content_native = (uint32_t *) malloc(length * sizeof(uint32_t));
    (*env)->GetByteArrayRegion(
        env,
        content_utf32,
        0,
        length * 4,
        (jbyte *) content_native
    );

    // Return the new text
    return (*env)->NewObject(
        env,
        Text_class_ref,
        Text_extended_constructor_id,
        PointerWrapper_wrap(env, content_native),
        (jlong) length,
        (jboolean) 0,
        (jboolean) 1,
        content_utf32
    );
}

// Destroy a text object
JNIEXPORT void Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1destroy_1text (
    JNIEnv *env,
    jclass jni_lib,
    jobject text
) {
    // Get if the text is the owner of its buffer
    jboolean is_owner = (*env)->GetBooleanField(
        env,
        text,
        Text_is_owner_field_id
    );

    // Unwrap the text
    lkt_text text_native = Text_unwrap(env, text);

    // If the object is the buffer owner just free the chars
    if(is_owner) {
        free((void *) text_native.chars);
    } else {
        lkt_destroy_text(&text_native);
    }
}

// ==========
// Source location functions
// ==========

// Create a new value for a source location
lkt_source_location SourceLocation_new_value() {
    lkt_source_location res = {
        0,
        0
    };
    return res;
}

// Wrap a native source location in the Java wrapping class
jobject SourceLocation_wrap(
    JNIEnv *env,
    lkt_source_location sloc_native
) {
    // Return the new source location
    return (*env)->NewObject(
        env,
        SourceLocation_class_ref,
        SourceLocation_constructor_id,
        (jint) sloc_native.line,
        (jshort) sloc_native.column
    );
}

// Get a native source location from a Java wrapping instance
lkt_source_location SourceLocation_unwrap(
    JNIEnv *env,
    jobject sloc
) {
    // Create the result structure
    lkt_source_location res = SourceLocation_new_value();

    // Get the fields value
    jint line = (*env)->GetIntField(
        env,
        sloc,
        Support_SourceLocation_line_field_id
    );
    jshort column = (*env)->GetShortField(
        env,
        sloc,
        Support_SourceLocation_column_field_id
    );

    // Fill the result structure
    res.line = (uint32_t) line;
    res.column = (uint16_t) column;

    // Return the result
    return res;
}

// ==========
// Source location range functions
// ==========

// Create a new value for a source location range
lkt_source_location_range SourceLocationRange_new_value() {
    lkt_source_location_range res = {
        SourceLocation_new_value(),
        SourceLocation_new_value()
    };
    return res;
}

// Wrap a native source location range in the Java wrapping class
jobject SourceLocationRange_wrap(
    JNIEnv *env,
    lkt_source_location_range slocr_native
) {
    // Return the new source location range
    return (*env)->NewObject(
        env,
        SourceLocationRange_class_ref,
        SourceLocationRange_constructor_id,
        SourceLocation_wrap(env, slocr_native.start),
        SourceLocation_wrap(env, slocr_native.end)
    );
}

// Get a native source location range from a Java wrapping instance
lkt_source_location_range SourceLocationRange_unwrap(
    JNIEnv *env,
    jobject slocr
) {
    // Create the result structure
    lkt_source_location_range res = SourceLocationRange_new_value();

    // Get the fields value
    jobject start = (*env)->GetObjectField(
        env,
        slocr,
        Support_SourceLocationRange_start_field_id
    );
    jobject end = (*env)->GetObjectField(
        env,
        slocr,
        Support_SourceLocationRange_end_field_id
    );

    // Fill the result structure
    res.start = SourceLocation_unwrap(env, start);
    res.end = SourceLocation_unwrap(env, end);

    // Return the result
    return res;
}

// ==========
// Diagnostic functions
// ==========

// Create a new value for a diagnostic
lkt_diagnostic Diagnostic_new_value() {
    lkt_diagnostic res = {
        SourceLocationRange_new_value(),
        Text_new_value()
    };
    return res;
}

// Wrap a native diagnostic in the Java wrapping class
jobject Diagnostic_wrap(
    JNIEnv *env,
    lkt_diagnostic diag_native
) {
    // Return the new diagnostic
    return (*env)->NewObject(
        env,
        Diagnostic_class_ref,
        Diagnostic_constructor_id,
        SourceLocationRange_wrap(env, diag_native.sloc_range),
        Text_wrap(env, diag_native.message)
    );
}

// Get a native diagnostic from a Java wrapping instance
lkt_diagnostic Diagnostic_unwrap(
    JNIEnv *env,
    jobject diagnostic
) {
    // Create the result structure
    lkt_diagnostic res = Diagnostic_new_value();

    // Get the fields value
    jobject slocr = (*env)->GetObjectField(
        env,
        diagnostic,
        Diagnostic_sloc_range_field_id
    );
    jobject text = (*env)->GetObjectField(
        env,
        diagnostic,
        Diagnostic_text_field_id
    );

    // Fill the result structure
    res.sloc_range = SourceLocationRange_unwrap(env, slocr);
    res.message = Text_unwrap(env, text);

    // Return the result
    return res;
}

// ==========
// Rewriting apply result functions
// ==========

// Create a new vakye for an apply result
lkt_rewriting_apply_result RewritingApplyResult_new_value() {
    lkt_rewriting_apply_result res = {
        0,
        NULL,
        0,
        NULL
    };
    return res;
}

// Wrap a native rewriting apply result
jobject RewritingApplyResult_wrap(
    JNIEnv *env,
    lkt_rewriting_apply_result result_native
) {
    if(result_native.success > 0) {
        return (*env)->CallStaticObjectMethod(
            env,
            RewritingApplyResult_class_ref,
            RewritingApplyResult_success_id
        );
    }
    return (*env)->NewObject(
        env,
        RewritingApplyResult_class_ref,
        RewritingApplyResult_contructor_id,
        (jboolean) 0,
        AnalysisUnit_wrap(env, result_native.unit),
        result_native.diagnostics_count,
        PointerWrapper_wrap(env, (void *) result_native.diagnostics)
    );
}

lkt_rewriting_apply_result RewritingApplyResult_unwrap(
    JNIEnv *env,
    jobject rewriting_apply_result
) {
    lkt_rewriting_apply_result res = RewritingApplyResult_new_value();
    res.success = (int) (*env)->GetBooleanField(
        env,
        rewriting_apply_result,
        RewritingApplyResult_success_field_id
    );
    res.unit = AnalysisUnit_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            rewriting_apply_result,
            RewritingApplyResult_unit_field_id
        )
    );
    res.diagnostics_count = (int) (*env)->GetIntField(
        env,
        rewriting_apply_result,
        RewritingApplyResult_diagnostics_count_field_id
    );
    res.diagnostics = (lkt_diagnostic *) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            rewriting_apply_result,
            RewritingApplyResult_diagnostics_reference_field_id
        )
    );
    return res;
}

// Function to get the wrapped diagnostics inside a rewriting apply result
JNIEXPORT jobjectArray Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1get_1result_1diagnostics(
    JNIEnv *env,
    jclass jni_lib,
    jint diagnostics_count,
    jlong diagnostics_reference
) {
    // Create the result array
    jobjectArray res = (*env)->NewObjectArray(
        env,
        (jsize) diagnostics_count,
        Diagnostic_class_ref,
        NULL
    );

    // Fill the result array by wrapping all diagnostics
    lkt_diagnostic *diagnostics_native =
        (lkt_diagnostic *) diagnostics_reference;
    for(int i = 0; i < (int) diagnostics_count; i++) {
        (*env)->SetObjectArrayElement(
            env,
            res,
            (jsize) i,
            Diagnostic_wrap(env, diagnostics_native[i])
        );
    }

    // Return the filled array
    return res;
}

// Function to free the rewriting apply result
JNIEXPORT void Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1free_1apply_1result(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_apply_result
) {
    lkt_rewriting_apply_result result_native =
        RewritingApplyResult_unwrap(
            env,
            rewriting_apply_result
        );
    lkt_rewriting_free_apply_result(&result_native);
}

// ==========
// File reader functions
// ==========

// Create a new value for a file reader
lkt_file_reader FileReader_new_value() {
    return NULL;
}

// Wrap a native file reader in the Java wrapping class
jobject FileReader_wrap(
    JNIEnv *env,
    lkt_file_reader file_reader_native
) {
    // Return the new file reader
    return (*env)->NewObject(
        env,
        FileReader_class_ref,
        FileReader_constructor_id,
        PointerWrapper_wrap(env, (void *) file_reader_native)
    );
}

// Get a native file reader from a Java wrapping instance
lkt_file_reader FileReader_unwrap(
    JNIEnv *env,
    jobject file_reader
) {
    return (lkt_file_reader) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            file_reader,
            FileReader_reference_field_id
        )
    );
}

// Decrease the reference counter of the given file reader
JNIEXPORT void Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1dec_1ref_1file_1reader(
    JNIEnv *env,
    jclass jni_lib,
    jobject file_reader
) {
    lkt_dec_ref_file_reader(FileReader_unwrap(env, file_reader));
}

// ==========
// Unit provider functions
// ==========

// Create a new value for a unit provider
lkt_unit_provider UnitProvider_new_value() {
    return NULL;
}

// Wrap a native unit provider in the Java wrapping class
jobject UnitProvider_wrap(
    JNIEnv *env,
    lkt_unit_provider unit_prov_native
) {
    // Return the new unit provider
    return (*env)->NewObject(
        env,
        UnitProvider_class_ref,
        UnitProvider_constructor_id,
        PointerWrapper_wrap(env, (void *) unit_prov_native)
    );
}

// Get a native unit provider from a Java wrapping instance
lkt_unit_provider UnitProvider_unwrap(
    JNIEnv *env,
    jobject unit_provider
) {
    return (lkt_unit_provider) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            unit_provider,
            UnitProvider_reference_field_id
        )
    );
}

JNIEXPORT void Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1dec_1ref_1unit_1provider(
    JNIEnv *env,
    jclass jni_lib,
    jobject unit_provider
) {
    lkt_dec_ref_unit_provider(UnitProvider_unwrap(env, unit_provider));
}

// ==========
// Event handler functions
// ==========

// Create a new value for a event handler
lkt_event_handler EventHandler_new_value() {
    return NULL;
}

// Wrap a native event handler in the Java wrapping class
jobject EventHandler_wrap(
    JNIEnv *env,
    lkt_event_handler event_handler_native
) {
    // Return the new event handler
    return (*env)->CallStaticObjectMethod(
        env,
        EventHandler_class_ref,
        EventHandler_from_reference_id,
        PointerWrapper_wrap(env, (void *) event_handler_native)
    );
}

// Get the native event handler from a Java wrapping instance
lkt_event_handler EventHandler_unwrap(
    JNIEnv *env,
    jobject event_handler
) {
    return (lkt_event_handler) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            event_handler,
            EventHandler_reference_field_id
        )
    );
}

// Util function to destroy the native event handler
void event_handler_destroy(
    void *data
) {
    event_handler_data *eh_data = (event_handler_data *) data;
    JNIEnv *env = eh_data->env;
    if(jvm_running) {
        (*env)->DeleteGlobalRef(env, eh_data->unit_requested_callback);
        (*env)->DeleteGlobalRef(env, eh_data->unit_parsed_callback);
    }
    free(data);
}

// Util function called when a unit is requested
void event_handler_unit_requested(
    void *data,
    lkt_analysis_context context,
    lkt_text *name,
    lkt_analysis_unit from,
    lkt_bool found,
    lkt_bool is_not_found_error
) {
    // Get the event handler data
    event_handler_data *eh_data = (event_handler_data *) data;
    JNIEnv *env = eh_data->env;

    // Verify that the callback is not null
    if(eh_data->unit_requested_callback != NULL) {
        // Wrap the callback arguments
        jobject analysis_context = AnalysisContext_wrap(env, context);
        jobject text = Text_wrap(env, *name);
        jobject analysis_unit = AnalysisUnit_wrap(env, from);

        // Call the unit requested callback
        (*env)->CallVoidMethod(
            env,
            eh_data->unit_requested_callback,
            UnitRequestedCallback_invoke_id,
            analysis_context,
            get_text_content(env, text),
            analysis_unit,
            (jboolean) found,
            (jboolean) is_not_found_error
        );

        // Remove the intermediary values
        lkt_context_decref(context);
        lkt_destroy_text(name);
    }
}

// Util function called when a unit is parsed
void event_handler_unit_parsed(
    void *data,
    lkt_analysis_context context,
    lkt_analysis_unit unit,
    lkt_bool reparsed
) {
    // Get the event handler data
    event_handler_data *eh_data = (event_handler_data *) data;
    JNIEnv *env = eh_data->env;

    // Verify that the callback is not null
    if(eh_data->unit_parsed_callback != NULL) {
        // Wrap the callback arguments
        jobject analysis_context = AnalysisContext_wrap(env, context);
        jobject analysis_unit = AnalysisUnit_wrap(env, unit);

        // Call the unit parsed callback
        (*env)->CallVoidMethod(
            env,
            eh_data->unit_parsed_callback,
            UnitParsedCallback_invoke_id,
            analysis_context,
            analysis_unit,
            (jboolean) reparsed
        );

        // Remove the intermediary values
        lkt_context_decref(context);
    }
}

// Create a new event handler
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1create_1event_1handler(
    JNIEnv *env,
    jclass jni_lib,
    jobject unit_requested_callback,
    jobject unit_parsed_callback
) {
    // Create the structure to store the event handler information
    event_handler_data *data = (event_handler_data *) malloc(
        sizeof(event_handler_data)
    );
    data->env = env;
    data->unit_requested_callback = (*env)->NewGlobalRef(
        env,
        unit_requested_callback
    );
    data->unit_parsed_callback = (*env)->NewGlobalRef(
        env,
        unit_parsed_callback
    );

    // Call the native function
    lkt_event_handler res_native = lkt_create_event_handler(
        (void *) data,
        &event_handler_destroy,
        &event_handler_unit_requested,
        &event_handler_unit_parsed
    );

    // Return the wrapped pointer
    return PointerWrapper_wrap(env, (void *) res_native);
}

// Decrease the reference counter of an event handler
JNIEXPORT void Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1dec_1ref_1event_1handler(
    JNIEnv *env,
    jclass jni_lib,
    jobject event_handler
) {
    lkt_dec_ref_event_handler(EventHandler_unwrap(env, event_handler));
}

// ==========
// Token functions
// ==========

// Create a new value for a token
lkt_token Token_new_value() {
    lkt_token res = {
        NULL,
        NULL,
        0,
        0
    };
    return res;
}

// Wrap a native token in the Java wrapping class
jobject Token_wrap(
    JNIEnv *env,
    lkt_token token_native,
    jobject analysis_unit
) {
    lkt_token_kind tok_kind;
    lkt_text tok_text;
    lkt_source_location_range tok_sloc_range;
    jobject text;
    jstring text_string;

    // Handle the no tokens
    if(token_native.token_data == NULL) {
        return NoToken_wrap(env, analysis_unit);
    }

    // Fetch extra token data requires to build a Token instance, but not
    // present in the C-level token data type: kind, text and sloc_range.
    tok_kind = lkt_token_get_kind (&token_native);
    lkt_token_sloc_range (&token_native, &tok_sloc_range);

    lkt_token_range_text (&token_native, &token_native, &tok_text);
    text = Text_wrap(env, tok_text);
    text_string = get_text_content(env, text);
    lkt_destroy_text (&tok_text);

    return (*env)->NewObject(
        env,
        Token_class_ref,
        Token_constructor_id,
        PointerWrapper_wrap(env, token_native.context),
        analysis_unit,
        PointerWrapper_wrap(env, token_native.token_data),
        (jint) token_native.token_index,
        (jint) token_native.trivia_index,
        TokenKind_wrap(env, tok_kind),
        text_string,
        SourceLocationRange_wrap(env, tok_sloc_range)
    );
}

// Get a native token from the Java wrapping instance
lkt_token Token_unwrap(
    JNIEnv *env,
    jobject token
) {
    // Prepare the result structure
    lkt_token res = Token_new_value();

    // Check if the token is instance of no token
    if((*env)->IsInstanceOf(env, token, NoToken_class_ref)) {
        // Get the value from the object
        jobject context_value = (*env)->GetObjectField(
            env,
            token,
            Token_context_field_id
        );
        jobject tdh_value = (*env)->GetObjectField(
            env,
            token,
            Token_tdh_field_id
        );

        // Fill the result structure
        res.context = (lkt_analysis_context) PointerWrapper_unwrap(
            env,
            context_value
        );
        res.token_data = (lkt_token_data_handler) PointerWrapper_unwrap(
            env,
            tdh_value
        );
        res.token_index = 0;
        res.trivia_index = 0;

        // Return the result
        return res;

    } else {
        // Get the value from the object
        jobject context_value = (*env)->GetObjectField(
            env,
            token,
            Token_context_field_id
        );
        jobject tdh_value = (*env)->GetObjectField(
            env,
            token,
            Token_tdh_field_id
        );
        jint token_index_value = (*env)->GetIntField(
            env,
            token,
            Token_token_index_field_id
        );
        jint trivia_index_value = (*env)->GetIntField(
            env,
            token,
            Token_trivia_index_field_id
        );

        // Fill the result structure
        res.context = (lkt_analysis_context) PointerWrapper_unwrap(
            env,
            context_value
        );
        res.token_data = (lkt_token_data_handler) PointerWrapper_unwrap(
            env,
            tdh_value
        );
        res.token_index = (int) token_index_value;
        res.trivia_index = (int) trivia_index_value;

        // Return the result
        return res;

    }
}

// Get the analysis unit from a token
jobject Token_get_unit(
    JNIEnv *env,
    jobject token
) {
    // Return the field
    return (*env)->GetObjectField(
        env,
        token,
        Token_unit_field_id
    );
}

// Get the no token instance for the given analysis unit
jobject NoToken_wrap(
    JNIEnv *env,
    jobject analysis_unit
) {
    // Call the instance getter and return the result
    return (*env)->CallStaticObjectMethod(
        env,
        Token_class_ref,
        Token_none_getter_method_id,
        analysis_unit
    );
}

// Get the next token from the given token
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1token_1next(
    JNIEnv *env,
    jclass jni_lib,
    jobject token
) {
    // Get the token native value
    lkt_token token_native = Token_unwrap(env, token);

    // Prepare the result
    lkt_token res = Token_new_value();

    // Call the native function
    lkt_token_next(
        &token_native,
        &res
    );

    // Return the result token
    return Token_wrap(env, res, Token_get_unit(env, token));
}

// Get the previous token from the given token
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1token_1previous(
    JNIEnv *env,
    jclass jni_lib,
    jobject token
) {
    // Get the token native value
    lkt_token token_native = Token_unwrap(env, token);

    // Prepare the result
    lkt_token res = Token_new_value();

    // Call the native function
    lkt_token_previous(
        &token_native,
        &res
    );

    // Return the result token
    return Token_wrap(env, res, Token_get_unit(env, token));
}

// Get if the given token are equivalents
JNIEXPORT jboolean Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1token_1is_1equivalent(
    JNIEnv *env,
    jclass jni_lib,
    jobject left,
    jobject right
) {
    // Get the token native values
    lkt_token left_native = Token_unwrap(env, left);
    lkt_token right_native = Token_unwrap(env, right);

    // Return the result of the native call
    return (jboolean) lkt_token_is_equivalent(
        &left_native,
        &right_native
    );
}

// Get the text in the token interval
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1token_1range_1text(
    JNIEnv *env,
    jclass jni_lib,
    jobject start,
    jobject end
) {
    // Get the token native values
    lkt_token start_native = Token_unwrap(env, start);
    lkt_token end_native = Token_unwrap(env, end);

    // Prepare the result
    lkt_text res = Text_new_value();

    // Call the native function
    lkt_token_range_text(
        &start_native,
        &end_native,
        &res
    );

    // Return the result text
    return Text_wrap(env, res);
}

// ==========
// Analysis context functions
// ==========

// Create a new value for an analysis context
lkt_analysis_context AnalysisContext_new_value() {
    return NULL;
}

// Wrap a native analysis context in the Java wrapping class
jobject AnalysisContext_wrap(
    JNIEnv *env,
    lkt_analysis_context context_native
) {
    // Return the new analysis context
    return (*env)->CallStaticObjectMethod(
        env,
        AnalysisContext_class_ref,
        AnalysisContext_from_reference_id,
        PointerWrapper_wrap(env, (void *) context_native)
    );
}

// Get a native analysis context from a Java wrapping instance
lkt_analysis_context AnalysisContext_unwrap(
    JNIEnv *env,
    jobject analysis_context
) {
    return (lkt_analysis_context) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            analysis_context,
            AnalysisContext_reference_field_id
        )
    );
}

// Create a new analysis context
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1create_1analysis_1context(
    JNIEnv *env,
    jclass jni_lib,
    jstring charset,
    jobject file_reader,
    jobject unit_provider,
    jobject event_handler,
    jboolean with_trivia,
    jint tab_stop
) {
    // Translate the charset string
    const char* charset_native = NULL;
    if(charset != NULL) charset_native = to_c_string(env, charset);

    // Allocate the analysis context
    lkt_analysis_context res = lkt_allocate_analysis_context();

    // Call the native function
    lkt_initialize_analysis_context(
        res,
        charset_native,
        FileReader_unwrap(env, file_reader),
        UnitProvider_unwrap(env, unit_provider),
        EventHandler_unwrap(env, event_handler),
        (int) with_trivia,
        (int) tab_stop
    );

    // Release the allocated string
    if(charset != NULL)
        release_c_string(env, charset, charset_native);

    // Return the new custom pointer to the analysis context
    return PointerWrapper_wrap(env, res);
}

// Increase the reference counter of an analysis context
JNIEXPORT void Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1context_1incref(
    JNIEnv *env,
    jclass jni_lib,
    jlong analysis_context
) {
    // Call the native function
    lkt_context_incref(
        (lkt_analysis_context) analysis_context
    );
}

// Decrease the reference counter of an analysis context
JNIEXPORT void Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1context_1decref(
    JNIEnv *env,
    jclass jni_lib,
    jlong analysis_context
) {
    // Call the native funtion
    lkt_context_decref(
        (lkt_analysis_context) analysis_context
    );
}

// ==========
// Analysis unit functions
// ==========

// Create a new value for an analysis unit
lkt_analysis_unit AnalysisUnit_new_value() {
    return NULL;
}

// Wrap a native analysis unit in the Java wrapping class
jobject AnalysisUnit_wrap(
    JNIEnv *env,
    lkt_analysis_unit unit_native
) {
    // Return the new analysis unit
    return (*env)->NewObject(
        env,
        AnalysisUnit_class_ref,
        AnalysisUnit_constructor_id,
        PointerWrapper_wrap(env, (void *) unit_native)
    );
}

// Get a native analysis unit from a Java wrapping instance
lkt_analysis_unit AnalysisUnit_unwrap(
    JNIEnv *env,
    jobject analysis_unit
) {
    return (lkt_analysis_unit) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            analysis_unit,
            AnalysisUnit_reference_field_id
        )
    );
}

// Create an analysis unit from a file
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1get_1analysis_1unit_1from_1file(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_context,
    jstring filename,
    jstring charset,
    jboolean reparse,
    jint grammar_rule
) {
    // Translate the Java strings
    const char *filename_native = to_c_string(env, filename);
    const char *charset_native = NULL;
    if(charset != NULL) charset_native = to_c_string(env, charset);

    // Call the native function
    lkt_analysis_unit res = lkt_get_analysis_unit_from_file(
        AnalysisContext_unwrap(env, analysis_context),
        filename_native,
        charset_native,
        (int) reparse,
        (int) grammar_rule
    );

    // Release the strings
    release_c_string(env, filename, filename_native);
    if(charset != NULL)
        release_c_string(env, charset, charset_native);

    // Return the new Analysis unit
    return AnalysisUnit_wrap(env, res);
}

// Create an analysis unit from a buffer
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1get_1analysis_1unit_1from_1buffer(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_context,
    jstring filename,
    jstring charset,
    jstring buffer,
    jlong buffer_size,
    jint grammar_rule
) {
    // Translate the Java strings
    const char *filename_native = to_c_string(env, filename);
    const char *buffer_native = to_c_string(env, buffer);
    const char *charset_native = NULL;
    if(charset != NULL) charset_native = to_c_string(env, charset);

    // Call the native function
    lkt_analysis_unit res = lkt_get_analysis_unit_from_buffer(
        AnalysisContext_unwrap(env, analysis_context),
        filename_native,
        charset_native,
        buffer_native,
        (long) buffer_size,
        (int) grammar_rule
    );

    // Release the strings
    release_c_string(env, filename, filename_native);
    release_c_string(env, buffer, buffer_native);
    if(charset != NULL)
        release_c_string(env, charset, charset_native);

    // Return the new analysis unit
    return AnalysisUnit_wrap(env, res);
}

// Create an analysis unit from the unit provider.
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1get_1analysis_1unit_1from_1provider(
    JNIEnv *env,
    jclass jni_lib,
    jobject context,
    jobject name,
    jint kind,
    jstring charset,
    jboolean reparse
) {
    lkt_text name_c = Text_unwrap (env, name);
    const char *charset_c
      = (charset == NULL) ? NULL : to_c_string (env, charset);

    lkt_analysis_unit result = lkt_get_analysis_unit_from_provider(
        AnalysisContext_unwrap(env, context),
        &name_c,
        kind,
        charset_c,
        reparse
    );

    if (charset != NULL)
      release_c_string (env, charset, charset_c);
    lkt_destroy_text (&name_c);

    return AnalysisUnit_wrap(env, result);
}

// Get the root entity from an analysis unit
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1unit_1root(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    // Prepare the result
    lkt_node res = Entity_new_value();

    // Call the native function
    lkt_unit_root(
        AnalysisUnit_unwrap(env, analysis_unit),
        &res
    );

    // Return the new entity
    return Entity_wrap(env, res);
}

// Get the name of the file related to the analysis unit
JNIEXPORT jstring Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1unit_1filename(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    // Call the native function
    char *res_native = lkt_unit_filename(
        AnalysisUnit_unwrap(env, analysis_unit)
    );

    // Return the new java string
    jstring res = to_j_string(env, res_native);

    // Free the native allocated string
    lkt_free((void *) res_native);

    // Return the result
    return res;
}

// Get the token count of the analysis unit
JNIEXPORT jint Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1unit_1token_1count(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    return (jint) lkt_unit_token_count(
        AnalysisUnit_unwrap(env, analysis_unit)
    );
}

JNIEXPORT jint Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1unit_1trivia_1count(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    return (jint) lkt_unit_trivia_count(
        AnalysisUnit_unwrap(env, analysis_unit)
    );
}

// Get the first token of the analysis unit
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1unit_1first_1token(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    // Prepare the result
    lkt_token res = Token_new_value();

    // Call the native function
    lkt_unit_first_token(
        AnalysisUnit_unwrap(env, analysis_unit),
        &res
    );

    // Return the result token
    return Token_wrap(env, res, analysis_unit);
}

// Get the last token of the analysis unit
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1unit_1last_1token(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    // Prepare the result
    lkt_token res = Token_new_value();

    // Call the native function
    lkt_unit_last_token(
        AnalysisUnit_unwrap(env, analysis_unit),
        &res
    );

    // Return the result token
    return Token_wrap(env, res, analysis_unit);
}

// Get the analysis context for an analysis unit
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1unit_1context(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    // Call the native result
    lkt_analysis_context res = lkt_unit_context(
        AnalysisUnit_unwrap(env, analysis_unit)
    );

    // Return the result context
    return AnalysisContext_wrap(env, res);
}

// Get the count of the diagnostic in the analysis unit
JNIEXPORT jint Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1unit_1diagnostic_1count(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    // Return the casted native call
    return (jint) lkt_unit_diagnostic_count(
        AnalysisUnit_unwrap(env, analysis_unit)
    );
}

// Get the nth diagnostic in the analysis unit
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1unit_1diagnostic(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit,
    jint n
) {
    // Prepare the result
    lkt_diagnostic res = Diagnostic_new_value();

    // Call the native function
    lkt_unit_diagnostic(
        AnalysisUnit_unwrap(env, analysis_unit),
        (unsigned) n,
        &res
    );

    // Return the diagnostic
    return Diagnostic_wrap(env, res);
}

// ==========
// Rewriting context functions
// ==========

// Create a new value for a rewriting context
lkt_rewriting_handle RewritingContext_new_value() {
    return NULL;
}

// Wrap a native rewriting context in its Java class
jobject RewritingContext_wrap(
    JNIEnv *env,
    lkt_rewriting_handle rewriting_context_native
) {
    return (*env)->CallStaticObjectMethod(
        env,
        RewritingContext_class_ref,
        RewritingContext_from_reference_id,
        PointerWrapper_wrap(env, (void *) rewriting_context_native)
    );
}

// Unwrap a Java rewriting context to its native value
lkt_rewriting_handle RewritingContext_unwrap(
    JNIEnv *env,
    jobject rewriting_context
) {
    return (lkt_rewriting_handle) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            rewriting_context,
            RewritingContext_reference_field_id
        )
    );
}

// Start a rewriting session on the given analysis context
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1start_1rewriting(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_context
) {
    // Call the native function to create a rewriting context and return the
    // wrapped result.
    return RewritingContext_wrap(
        env,
        lkt_rewriting_start_rewriting(AnalysisContext_unwrap(
            env,
            analysis_context
        ))
    );
}

// Get the analysis context
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1handle_1to_1context(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_context
) {
    return AnalysisContext_wrap(
        env,
        lkt_rewriting_handle_to_context(
            RewritingContext_unwrap(env, rewriting_context)
        )
    );
}

// Get the rewriting units of the context
JNIEXPORT jobjectArray Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1unit_1handles(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_context
) {
    // Call the native function to get the native rewriting units
    lkt_unit_rewriting_handle *unit_array_native =
        lkt_rewriting_unit_handles(
            RewritingContext_unwrap(env, rewriting_context)
        );

    // Count the number of units in the result
    unsigned int unit_count = 0;
    lkt_unit_rewriting_handle *cursor = unit_array_native;
    while(*cursor != NULL) {
        cursor = &cursor[1];
        unit_count++;
    }

    // Create the result array and fill it
    jobjectArray res = (*env)->NewObjectArray(
        env,
        (jsize) unit_count,
        RewritingUnit_class_ref,
        NULL
    );
    for(unsigned int i = 0; i < unit_count; i++) {
        (*env)->SetObjectArrayElement(
            env,
            res,
            (jsize) i,
            RewritingUnit_wrap(env, unit_array_native[i])
        );
    }
    free(unit_array_native);
    return res;
}

// Create a new rewriting node in the given context
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1create_1node(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_context,
    jint node_kind
) {
    return RewritingNode_wrap(
        env,
        lkt_rewriting_create_node(
            RewritingContext_unwrap(env, rewriting_context),
            (lkt_node_kind_enum) node_kind
        )
    );
}

// Create a new rewriting node with its children
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1create_1regular_1node(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_context,
    jint node_kind,
    jobjectArray children
) {
    // Unwrap the children
    lkt_node_rewriting_handle *children_native =
        rewriting_nodes_to_native(env, children);

    // Call the native function and wrap the result
    jobject res = RewritingNode_wrap(
        env,
        lkt_rewriting_create_regular_node(
            RewritingContext_unwrap(env, rewriting_context),
            (lkt_node_kind_enum) node_kind,
            children_native,
            (*env)->GetArrayLength(env, children)
        )
    );

    // Free the native children array then return the result
    free(children_native);
    return res;
}

// Create a new rewriting token node in the given context
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1create_1token_1node(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_context,
    jint node_kind,
    jobject node_text
) {
    lkt_text node_text_native = Text_unwrap(env, node_text);
    return RewritingNode_wrap(
        env,
        lkt_rewriting_create_token_node(
            RewritingContext_unwrap(env, rewriting_context),
            (lkt_node_kind_enum) node_kind,
            &node_text_native
        )
    );
}

// Create a new node tree from a template
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1create_1from_1template(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_context,
    jobject template_text,
    jobjectArray arguments,
    jint rule
) {
    // Unwrap the arguments and template text
    int count = (*env)->GetArrayLength(env, arguments);
    lkt_node_rewriting_handle *arguments_native =
        rewriting_nodes_to_native(env, arguments);
    lkt_text template_text_native = Text_unwrap(env, template_text);

    // Call the native function
    jobject res = RewritingNode_wrap(
        env,
        lkt_rewriting_create_from_template(
            RewritingContext_unwrap(env, rewriting_context),
            &template_text_native,
            arguments_native,
            count,
            (lkt_grammar_rule) rule
        )
    );

    // Free the arguments native array the return the result
    free(arguments_native);
    return res;
}

// Apply the rewriting session and close it if success
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1apply(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_context
) {
    lkt_rewriting_apply_result res_native =
        RewritingApplyResult_new_value();
    lkt_rewriting_apply(
        RewritingContext_unwrap(env, rewriting_context),
        &res_native
    );
    return RewritingApplyResult_wrap(env, res_native);
}

// Abort the rewriting session
JNIEXPORT void Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1abort_1rewriting(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_context
) {
    // Just call the native function
    lkt_rewriting_abort_rewriting(
        RewritingContext_unwrap(env, rewriting_context)
    );
}

// ==========
// Rewriting unit functions
// ==========

// Create a new value for a native rewriting unit
lkt_unit_rewriting_handle RewritingUnit_new_value() {
    return NULL;
}

// Wrap the native rewrite unit inside the Java class
jobject RewritingUnit_wrap(
    JNIEnv *env,
    lkt_unit_rewriting_handle rewriting_unit_native
) {
    return (*env)->NewObject(
        env,
        RewritingUnit_class_ref,
        RewritingUnit_constructor_id,
        PointerWrapper_wrap(env, (void *) rewriting_unit_native)
    );
}

// Unwrap the Java rewrite unit into a native value
lkt_unit_rewriting_handle RewritingUnit_unwrap(
    JNIEnv *env,
    jobject rewriting_unit
) {
    return (lkt_unit_rewriting_handle) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            rewriting_unit,
            RewritingUnit_reference_field_id
        )
    );
}

// Get or create the rewriting unit from an analysis unit
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1unit_1to_1handle(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    return RewritingUnit_wrap(
        env,
        lkt_rewriting_unit_to_handle(
            AnalysisUnit_unwrap(env, analysis_unit)
        )
    );
}

// Get the analysis unit from the rewriting unit
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1handle_1to_1unit(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_unit
) {
    return AnalysisUnit_wrap(
        env,
        lkt_rewriting_handle_to_unit(
            RewritingUnit_unwrap(env, rewriting_unit)
        )
    );
}

// Get the root rewriting node of the rewriting unit
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1unit_1root(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_unit
) {
    return RewritingNode_wrap(
        env,
        lkt_rewriting_unit_root(
            RewritingUnit_unwrap(env, rewriting_unit)
        )
    );
}

// Set the root rewriting node of the rewriting unit
JNIEXPORT void Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1unit_1set_1root(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_unit,
    jobject rewriting_node
) {
    lkt_rewriting_unit_set_root(
        RewritingUnit_unwrap(env, rewriting_unit),
        RewritingNode_unwrap(env, rewriting_node)
    );
}

// Unparse the given rewriting unit
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1unit_1unparse(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_unit
) {
    lkt_text res_native = Text_new_value();
    lkt_rewriting_unit_unparse(
        RewritingUnit_unwrap(env, rewriting_unit),
        &res_native
    );
    return Text_wrap(env, res_native);
}

// ==========
// Rewriting node functions
// ==========

// Create a new rewriting node native value
lkt_node_rewriting_handle RewritingNode_new_value() {
    return NULL;
}

// Wrap the native rewriting node
jobject RewritingNode_wrap(
    JNIEnv *env,
    lkt_node_rewriting_handle rewriting_node_native
) {
    return (*env)->NewObject(
        env,
        RewritingNode_class_ref,
        RewritingNode_constructor_id,
        PointerWrapper_wrap(env, (void *) rewriting_node_native)
    );
}

// Unwrap the Java rewriting node
lkt_node_rewriting_handle RewritingNode_unwrap(
    JNIEnv *env,
    jobject rewriting_node
) {
    return (lkt_node_rewriting_handle) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            rewriting_node,
            RewritingNode_reference_field_id
        )
    );
}

// Get the rewriting node from the parsed node
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1node_1to_1handle(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
 ) {
    return RewritingNode_wrap(
        env,
        lkt_rewriting_node_to_handle(
            Entity_unwrap(env, entity).node
        )
    );
}

// Get the parsed node from the given rewriting node
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1handle_1to_1node(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    lkt_base_node bare_node = lkt_rewriting_handle_to_node(
        RewritingNode_unwrap(
            env,
            rewriting_node
        )
    );
    lkt_node res_native = Entity_new_value();
    lkt_create_bare_entity(
        bare_node,
        &res_native
    );
    return Entity_wrap(env, res_native);
}

// Get the rewriting context of the given node
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1node_1to_1context(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    return RewritingContext_wrap(
        env,
        lkt_rewriting_node_to_context(
            RewritingNode_unwrap(env, rewriting_node)
        )
    );
}

// Clone the given rewriting node and return the result
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1clone(
    JNIEnv *env,
    jclass jni_lib,
    jobject to_clone
) {
    return RewritingNode_wrap(
        env,
        lkt_rewriting_clone(
            RewritingNode_unwrap(env, to_clone)
        )
    );
}

// Unparse the given rewriting node
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1node_1unparse(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    lkt_text res_native = Text_new_value();
    lkt_rewriting_node_unparse(
        RewritingNode_unwrap(env, rewriting_node),
        &res_native
    );
    return Text_wrap(
        env,
        res_native
    );
}

// Get the kind index of the rewriting node
JNIEXPORT jint Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1kind(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    return (jint) lkt_rewriting_kind(
        RewritingNode_unwrap(env, rewriting_node)
    );
}

// Get the image of the rewriting node
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1node_1image(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    lkt_text res_native = Text_new_value();
    lkt_rewriting_node_image(
        RewritingNode_unwrap(env, rewriting_node),
        &res_native
    );
    return Text_wrap(env, res_native);
}

// Get whether the node is tied
JNIEXPORT jboolean Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1tied(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    return (jboolean) lkt_rewriting_tied(
        RewritingNode_unwrap(env, rewriting_node)
    );
}

// Get the parent of the rewriting node
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1parent(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    return RewritingNode_wrap(
        env,
        lkt_rewriting_parent(
            RewritingNode_unwrap(env, rewriting_node)
        )
    );
}

// Get the rewriting node children
JNIEXPORT jobjectArray Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1children(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    // Call the native method
    lkt_node_rewriting_handle *children = NULL;
    int count = 0;
    lkt_rewriting_children(
        RewritingNode_unwrap(env, rewriting_node),
        &children,
        &count
    );

    // Create the new java array adn fill it
    jobjectArray res = (*env)->NewObjectArray(
        env,
        (jsize) count,
        RewritingNode_class_ref,
        NULL
    );
    for(int i = 0; i < count; i++) {
        (*env)->SetObjectArrayElement(
            env,
            res,
            (jsize) i,
            RewritingNode_wrap(env, children[i])
        );
    }

    // Free the native children
    free(children);

    // Return the result
    return res;
}

// Get the child of the rewriting node by its member reference
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1child(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_parent,
    jint child_member_reference
) {
    return RewritingNode_wrap(
        env,
        lkt_rewriting_child(
            RewritingNode_unwrap(env, rewriting_parent),
            (lkt_introspection_member_ref) child_member_reference
        )
    );
}

// Set the given child at the given member reference
JNIEXPORT void Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1set_1child(
    JNIEnv *env,
    jclass jni_lib,
    jobject parent,
    jint child_member_reference,
    jobject new_child
) {
    lkt_rewriting_set_child(
        RewritingNode_unwrap(env, parent),
        (lkt_introspection_member_ref) child_member_reference,
        RewritingNode_unwrap(env, new_child)
    );
}

// Replace the rewriting node with the new one.
JNIEXPORT void Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1replace(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node,
    jobject new_node
) {
    lkt_rewriting_replace(
        RewritingNode_unwrap(env, rewriting_node),
        RewritingNode_unwrap(env, new_node)
    );
}

// Get the first child of the given parent
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1first_1child(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_parent
) {
    return RewritingNode_wrap(
        env,
        lkt_rewriting_first_child(
            RewritingNode_unwrap(env, rewriting_parent)
        )
    );
}

// Get the last child of the given parent
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1last_1child(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_parent
) {
    return RewritingNode_wrap(
        env,
        lkt_rewriting_last_child(
            RewritingNode_unwrap(env, rewriting_parent)
        )
    );
}

// Get the next child from the given rewriting node
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1next_1child(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    return RewritingNode_wrap(
        env,
        lkt_rewriting_next_child(
            RewritingNode_unwrap(env, rewriting_node)
        )
    );
}

// Get the previous child from the given rewriting node
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1previous_1child(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    return RewritingNode_wrap(
        env,
        lkt_rewriting_previous_child(
            RewritingNode_unwrap(env, rewriting_node)
        )
    );
}

// Insert the rewriting node before the other
JNIEXPORT void Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1insert_1before(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node,
    jobject to_insert
) {
    lkt_rewriting_insert_before(
        RewritingNode_unwrap(env, rewriting_node),
        RewritingNode_unwrap(env, to_insert)
    );
}

// Insert the rewriting node after the other
JNIEXPORT void Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1insert_1after(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node,
    jobject to_insert
) {
    lkt_rewriting_insert_after(
        RewritingNode_unwrap(env, rewriting_node),
        RewritingNode_unwrap(env, to_insert)
    );
}

// Insert the rewriting node at the beginning of children
JNIEXPORT void Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1insert_1first(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node,
    jobject to_insert
) {
    lkt_rewriting_insert_first(
        RewritingNode_unwrap(env, rewriting_node),
        RewritingNode_unwrap(env, to_insert)
    );
}

// Insert the rewriting node at the end of children
JNIEXPORT void Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1insert_1last(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node,
    jobject to_insert
) {
    lkt_rewriting_insert_last(
        RewritingNode_unwrap(env, rewriting_node),
        RewritingNode_unwrap(env, to_insert)
    );
}

// Remove the given node from its list parent
JNIEXPORT void Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1remove_1child(
    JNIEnv *env,
    jclass jni_lib,
    jobject to_remove
) {
    lkt_rewriting_remove_child(
        RewritingNode_unwrap(env, to_remove)
    );
}

// Get the text of the given rewriting token node
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1text(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    lkt_text res_native = Text_new_value();
    lkt_rewriting_text(
        RewritingNode_unwrap(env, rewriting_node),
        &res_native
    );
    return Text_wrap(env, res_native);
}

// Set the text of the given rewriting token node
JNIEXPORT void Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1rewriting_1set_1text(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node,
    jobject text
) {
    lkt_text text_native = Text_unwrap(env, text);
    lkt_rewriting_set_text(
        RewritingNode_unwrap(env, rewriting_node),
        &text_native
    );
}

// ==========
// Generated structure functions
// ==========


    

// Create a new value for a langkit lkt_internal_metadata
lkt_internal_metadata Metadata_new_value() {
    lkt_internal_metadata res = {
        0,
    };
    return res;
}

// Wrap a native lkt_internal_metadata in the Java wrapping class
jobject Metadata_wrap(
    JNIEnv *env,
    lkt_internal_metadata native_struct
) {
    // Return the None instance because there is no need of new one
    return (*env)->GetStaticObjectField(
        env,
        Metadata_class_ref,
        Metadata_none_field_id
    );
}


// Get a native lkt_internal_metadata from a Java wrapping instance
lkt_internal_metadata Metadata_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    lkt_internal_metadata res = Metadata_new_value();

    // Get the field values

    // Fill the result structure

    // Return the native result
    return res;
}



    

// Create a new value for a langkit lkt_internal_entity_info
lkt_internal_entity_info EntityInfo_new_value() {
    lkt_internal_entity_info res = {
        Metadata_new_value(),
        PointerWrapper_new_value(),
        0,
    };
    return res;
}

// Wrap a native lkt_internal_entity_info in the Java wrapping class
jobject EntityInfo_wrap(
    JNIEnv *env,
    lkt_internal_entity_info native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        EntityInfo_class_ref,
        EntityInfo_constructor_id,
        Metadata_wrap(env, native_struct.md),PointerWrapper_wrap(env, native_struct.rebindings),(jboolean) native_struct.from_rebound
    );
}


// Get a native lkt_internal_entity_info from a Java wrapping instance
lkt_internal_entity_info EntityInfo_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    lkt_internal_entity_info res = EntityInfo_new_value();

    // Get the field values
    jobject md_value =
        (*env)->GetObjectField(
            env,
            object,
            EntityInfo_md_field_id
        );
    jobject rebindings_value =
        (*env)->GetObjectField(
            env,
            object,
            EntityInfo_rebindings_field_id
        );
    jboolean from_rebound_value =
        (*env)->GetBooleanField(
            env,
            object,
            EntityInfo_from_rebound_field_id
        );

    // Fill the result structure
    lkt_internal_metadata md_native = Metadata_unwrap(env, md_value);
    res.md = md_native;
    lkt_env_rebindings_type rebindings_native = PointerWrapper_unwrap(env, rebindings_value);
    res.rebindings = rebindings_native;
    lkt_bool from_rebound_native = (lkt_bool) from_rebound_value;
    res.from_rebound = from_rebound_native;

    // Return the native result
    return res;
}



    

// Create a new value for a langkit lkt_node
lkt_node Entity_new_value() {
    lkt_node res = {
        PointerWrapper_new_value(),
        EntityInfo_new_value(),
    };
    return res;
}

// Wrap a native lkt_node in the Java wrapping class
jobject Entity_wrap(
    JNIEnv *env,
    lkt_node native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        Entity_class_ref,
        Entity_constructor_id,
        PointerWrapper_wrap(env, (void*) native_struct.node),EntityInfo_wrap(env, native_struct.info)
    );
}

jobject Entity_wrap_bare_node(
    JNIEnv *env,
    lkt_base_node bare_node
) {
    lkt_node struct_native = Entity_new_value();
    struct_native.node = bare_node;
    return Entity_wrap(env, struct_native);
}

// Get a native lkt_node from a Java wrapping instance
lkt_node Entity_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    lkt_node res = Entity_new_value();

    // Get the field values
    jobject node_value =
        (*env)->GetObjectField(
            env,
            object,
            Entity_node_field_id
        );
    jobject info_value =
        (*env)->GetObjectField(
            env,
            object,
            Entity_info_field_id
        );

    // Fill the result structure
    lkt_base_node node_native = (lkt_base_node) PointerWrapper_unwrap(env, node_value);
    res.node = node_native;
    lkt_internal_entity_info info_native = EntityInfo_unwrap(env, info_value);
    res.info = info_native;

    // Return the native result
    return res;
}



    

// Create a new value for a langkit lkt_internal_complete_item
lkt_internal_complete_item CompleteItem_new_value() {
    lkt_internal_complete_item res = {
        Entity_new_value(),
    };
    return res;
}

// Wrap a native lkt_internal_complete_item in the Java wrapping class
jobject CompleteItem_wrap(
    JNIEnv *env,
    lkt_internal_complete_item native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        CompleteItem_class_ref,
        CompleteItem_constructor_id,
        node_from_entity(env, Entity_wrap(env, native_struct.declaration))
    );
}


// Get a native lkt_internal_complete_item from a Java wrapping instance
lkt_internal_complete_item CompleteItem_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    lkt_internal_complete_item res = CompleteItem_new_value();

    // Get the field values
    jobject declaration_value =
        (*env)->GetObjectField(
            env,
            object,
            CompleteItem_declaration_field_id
        );

    // Fill the result structure
    lkt_node declaration_native = Entity_unwrap(env, get_node_entity(env, declaration_value));
    res.declaration = declaration_native;

    // Return the native result
    return res;
}



    

// Create a new value for a langkit lkt_internal_decoded_char_value
lkt_internal_decoded_char_value DecodedCharValue_new_value() {
    lkt_internal_decoded_char_value res = {
        Char_new_value(),
        0,
        SourceLocation_new_value(),
        StringWrapper_new_value(),
    };
    return res;
}

// Wrap a native lkt_internal_decoded_char_value in the Java wrapping class
jobject DecodedCharValue_wrap(
    JNIEnv *env,
    lkt_internal_decoded_char_value native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        DecodedCharValue_class_ref,
        DecodedCharValue_constructor_id,
        Char_wrap(env, native_struct.value),(jboolean) native_struct.has_error,SourceLocation_wrap(env, native_struct.error_sloc),StringWrapper_wrap(env, native_struct.error_message)
    );
}


// Get a native lkt_internal_decoded_char_value from a Java wrapping instance
lkt_internal_decoded_char_value DecodedCharValue_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    lkt_internal_decoded_char_value res = DecodedCharValue_new_value();

    // Get the field values
    jobject value_value =
        (*env)->GetObjectField(
            env,
            object,
            DecodedCharValue_value_field_id
        );
    jboolean has_error_value =
        (*env)->GetBooleanField(
            env,
            object,
            DecodedCharValue_has_error_field_id
        );
    jobject error_sloc_value =
        (*env)->GetObjectField(
            env,
            object,
            DecodedCharValue_error_sloc_field_id
        );
    jobject error_message_value =
        (*env)->GetObjectField(
            env,
            object,
            DecodedCharValue_error_message_field_id
        );

    // Fill the result structure
    uint32_t value_native = Char_unwrap(env, value_value);
    res.value = value_native;
    lkt_bool has_error_native = (lkt_bool) has_error_value;
    res.has_error = has_error_native;
    lkt_source_location error_sloc_native = SourceLocation_unwrap(env, error_sloc_value);
    res.error_sloc = error_sloc_native;
    lkt_string_type error_message_native = StringWrapper_unwrap(env, error_message_value);
    res.error_message = error_message_native;

    // Return the native result
    return res;
}

// Decrease the reference counter of the given structure
void DecodedCharValue_release(
    lkt_internal_decoded_char_value struct_native
) {
    lkt_internal_decoded_char_value_dec_ref(&struct_native);
}


    

// Create a new value for a langkit lkt_internal_decoded_string_value
lkt_internal_decoded_string_value DecodedStringValue_new_value() {
    lkt_internal_decoded_string_value res = {
        StringWrapper_new_value(),
        0,
        SourceLocation_new_value(),
        StringWrapper_new_value(),
    };
    return res;
}

// Wrap a native lkt_internal_decoded_string_value in the Java wrapping class
jobject DecodedStringValue_wrap(
    JNIEnv *env,
    lkt_internal_decoded_string_value native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        DecodedStringValue_class_ref,
        DecodedStringValue_constructor_id,
        StringWrapper_wrap(env, native_struct.value),(jboolean) native_struct.has_error,SourceLocation_wrap(env, native_struct.error_sloc),StringWrapper_wrap(env, native_struct.error_message)
    );
}


// Get a native lkt_internal_decoded_string_value from a Java wrapping instance
lkt_internal_decoded_string_value DecodedStringValue_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    lkt_internal_decoded_string_value res = DecodedStringValue_new_value();

    // Get the field values
    jobject value_value =
        (*env)->GetObjectField(
            env,
            object,
            DecodedStringValue_value_field_id
        );
    jboolean has_error_value =
        (*env)->GetBooleanField(
            env,
            object,
            DecodedStringValue_has_error_field_id
        );
    jobject error_sloc_value =
        (*env)->GetObjectField(
            env,
            object,
            DecodedStringValue_error_sloc_field_id
        );
    jobject error_message_value =
        (*env)->GetObjectField(
            env,
            object,
            DecodedStringValue_error_message_field_id
        );

    // Fill the result structure
    lkt_string_type value_native = StringWrapper_unwrap(env, value_value);
    res.value = value_native;
    lkt_bool has_error_native = (lkt_bool) has_error_value;
    res.has_error = has_error_native;
    lkt_source_location error_sloc_native = SourceLocation_unwrap(env, error_sloc_value);
    res.error_sloc = error_sloc_native;
    lkt_string_type error_message_native = StringWrapper_unwrap(env, error_message_value);
    res.error_message = error_message_native;

    // Return the native result
    return res;
}

// Decrease the reference counter of the given structure
void DecodedStringValue_release(
    lkt_internal_decoded_string_value struct_native
) {
    lkt_internal_decoded_string_value_dec_ref(&struct_native);
}


    

// Create a new value for a langkit lkt_internal_logic_context
lkt_internal_logic_context LogicContext_new_value() {
    lkt_internal_logic_context res = {
        Entity_new_value(),
        Entity_new_value(),
    };
    return res;
}

// Wrap a native lkt_internal_logic_context in the Java wrapping class
jobject LogicContext_wrap(
    JNIEnv *env,
    lkt_internal_logic_context native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        LogicContext_class_ref,
        LogicContext_constructor_id,
        node_from_entity(env, Entity_wrap(env, native_struct.ref_node)),node_from_entity(env, Entity_wrap(env, native_struct.decl_node))
    );
}


// Get a native lkt_internal_logic_context from a Java wrapping instance
lkt_internal_logic_context LogicContext_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    lkt_internal_logic_context res = LogicContext_new_value();

    // Get the field values
    jobject ref_node_value =
        (*env)->GetObjectField(
            env,
            object,
            LogicContext_ref_node_field_id
        );
    jobject decl_node_value =
        (*env)->GetObjectField(
            env,
            object,
            LogicContext_decl_node_field_id
        );

    // Fill the result structure
    lkt_node ref_node_native = Entity_unwrap(env, get_node_entity(env, ref_node_value));
    res.ref_node = ref_node_native;
    lkt_node decl_node_native = Entity_unwrap(env, get_node_entity(env, decl_node_value));
    res.decl_node = decl_node_native;

    // Return the native result
    return res;
}



    

// Create a new value for a langkit lkt_internal_ref_result
lkt_internal_ref_result RefResult_new_value() {
    lkt_internal_ref_result res = {
        Entity_new_value(),
    };
    return res;
}

// Wrap a native lkt_internal_ref_result in the Java wrapping class
jobject RefResult_wrap(
    JNIEnv *env,
    lkt_internal_ref_result native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        RefResult_class_ref,
        RefResult_constructor_id,
        node_from_entity(env, Entity_wrap(env, native_struct.ref))
    );
}


// Get a native lkt_internal_ref_result from a Java wrapping instance
lkt_internal_ref_result RefResult_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    lkt_internal_ref_result res = RefResult_new_value();

    // Get the field values
    jobject ref_value =
        (*env)->GetObjectField(
            env,
            object,
            RefResult_ref_field_id
        );

    // Fill the result structure
    lkt_node ref_native = Entity_unwrap(env, get_node_entity(env, ref_value));
    res.ref = ref_native;

    // Return the native result
    return res;
}



    

// Create a new value for a langkit lkt_internal_solver_diagnostic
lkt_internal_solver_diagnostic SolverDiagnostic_new_value() {
    lkt_internal_solver_diagnostic res = {
        StringWrapper_new_value(),
        LktNodeArrayWrapper_new_value(),
        PointerWrapper_new_value(),
        LogicContextArrayWrapper_new_value(),
        0,
    };
    return res;
}

// Wrap a native lkt_internal_solver_diagnostic in the Java wrapping class
jobject SolverDiagnostic_wrap(
    JNIEnv *env,
    lkt_internal_solver_diagnostic native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        SolverDiagnostic_class_ref,
        SolverDiagnostic_constructor_id,
        StringWrapper_wrap(env, native_struct.message_template),LktNodeArrayWrapper_wrap(env, native_struct.args),node_from_entity(env, Entity_wrap_bare_node(env, native_struct.location)),LogicContextArrayWrapper_wrap(env, native_struct.contexts),(jint) native_struct.round
    );
}


// Get a native lkt_internal_solver_diagnostic from a Java wrapping instance
lkt_internal_solver_diagnostic SolverDiagnostic_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    lkt_internal_solver_diagnostic res = SolverDiagnostic_new_value();

    // Get the field values
    jobject message_template_value =
        (*env)->GetObjectField(
            env,
            object,
            SolverDiagnostic_message_template_field_id
        );
    jobject args_value =
        (*env)->GetObjectField(
            env,
            object,
            SolverDiagnostic_args_field_id
        );
    jobject location_value =
        (*env)->GetObjectField(
            env,
            object,
            SolverDiagnostic_location_field_id
        );
    jobject contexts_value =
        (*env)->GetObjectField(
            env,
            object,
            SolverDiagnostic_contexts_field_id
        );
    jint round_value =
        (*env)->GetIntField(
            env,
            object,
            SolverDiagnostic_round_field_id
        );

    // Fill the result structure
    lkt_string_type message_template_native = StringWrapper_unwrap(env, message_template_value);
    res.message_template = message_template_native;
    lkt_node_array args_native = LktNodeArrayWrapper_unwrap(env, args_value);
    res.args = args_native;
    lkt_base_node location_native = Entity_unwrap(env, get_node_entity(env, location_value)).node;
    res.location = location_native;
    lkt_internal_logic_context_array contexts_native = LogicContextArrayWrapper_unwrap(env, contexts_value);
    res.contexts = contexts_native;
    int round_native = (int) round_value;
    res.round = round_native;

    // Return the native result
    return res;
}

// Decrease the reference counter of the given structure
void SolverDiagnostic_release(
    lkt_internal_solver_diagnostic struct_native
) {
    lkt_internal_solver_diagnostic_dec_ref(&struct_native);
}


    

// Create a new value for a langkit lkt_internal_solver_result
lkt_internal_solver_result SolverResult_new_value() {
    lkt_internal_solver_result res = {
        0,
        SolverDiagnosticArrayWrapper_new_value(),
    };
    return res;
}

// Wrap a native lkt_internal_solver_result in the Java wrapping class
jobject SolverResult_wrap(
    JNIEnv *env,
    lkt_internal_solver_result native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        SolverResult_class_ref,
        SolverResult_constructor_id,
        (jboolean) native_struct.success,SolverDiagnosticArrayWrapper_wrap(env, native_struct.diagnostics)
    );
}


// Get a native lkt_internal_solver_result from a Java wrapping instance
lkt_internal_solver_result SolverResult_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    lkt_internal_solver_result res = SolverResult_new_value();

    // Get the field values
    jboolean success_value =
        (*env)->GetBooleanField(
            env,
            object,
            SolverResult_success_field_id
        );
    jobject diagnostics_value =
        (*env)->GetObjectField(
            env,
            object,
            SolverResult_diagnostics_field_id
        );

    // Fill the result structure
    lkt_bool success_native = (lkt_bool) success_value;
    res.success = success_native;
    lkt_internal_solver_diagnostic_array diagnostics_native = SolverDiagnosticArrayWrapper_unwrap(env, diagnostics_value);
    res.diagnostics = diagnostics_native;

    // Return the native result
    return res;
}

// Decrease the reference counter of the given structure
void SolverResult_release(
    lkt_internal_solver_result struct_native
) {
    lkt_internal_solver_result_dec_ref(&struct_native);
}


// ==========
// Generated array functions
// ==========


    

// Create a new value for a lkt_internal_complete_item_array
lkt_internal_complete_item_array CompleteItemArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native lkt_internal_complete_item_array in the Java wrapping class
jobject CompleteItemArrayWrapper_wrap(
    JNIEnv *env,
    lkt_internal_complete_item_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        CompleteItem_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        lkt_internal_complete_item elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            CompleteItem_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        CompleteItemArrayWrapper_class_ref,
        CompleteItemArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native lkt_internal_complete_item_array from a Java wrapping instance
lkt_internal_complete_item_array CompleteItemArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        CompleteItemArrayWrapper_class_ref,
        CompleteItemArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    lkt_internal_complete_item_array res = lkt_internal_complete_item_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        lkt_internal_complete_item elem_native = CompleteItem_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void CompleteItemArrayWrapper_release(
    lkt_internal_complete_item_array array_native
) {
    lkt_internal_complete_item_array_dec_ref(array_native);
}


    

// Create a new value for a lkt_node_array
lkt_node_array LktNodeArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native lkt_node_array in the Java wrapping class
jobject LktNodeArrayWrapper_wrap(
    JNIEnv *env,
    lkt_node_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        Entity_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        lkt_node elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            Entity_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        LktNodeArrayWrapper_class_ref,
        LktNodeArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native lkt_node_array from a Java wrapping instance
lkt_node_array LktNodeArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        LktNodeArrayWrapper_class_ref,
        LktNodeArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    lkt_node_array res = lkt_node_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        lkt_node elem_native = Entity_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void LktNodeArrayWrapper_release(
    lkt_node_array array_native
) {
    lkt_node_array_dec_ref(array_native);
}


    

// Create a new value for a lkt_node_array
lkt_node_array DefIdArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native lkt_node_array in the Java wrapping class
jobject DefIdArrayWrapper_wrap(
    JNIEnv *env,
    lkt_node_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        Entity_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        lkt_node elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            Entity_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        DefIdArrayWrapper_class_ref,
        DefIdArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native lkt_node_array from a Java wrapping instance
lkt_node_array DefIdArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        DefIdArrayWrapper_class_ref,
        DefIdArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    lkt_node_array res = lkt_node_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        lkt_node elem_native = Entity_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void DefIdArrayWrapper_release(
    lkt_node_array array_native
) {
    lkt_node_array_dec_ref(array_native);
}


    

// Create a new value for a lkt_node_array
lkt_node_array FunDeclArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native lkt_node_array in the Java wrapping class
jobject FunDeclArrayWrapper_wrap(
    JNIEnv *env,
    lkt_node_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        Entity_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        lkt_node elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            Entity_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        FunDeclArrayWrapper_class_ref,
        FunDeclArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native lkt_node_array from a Java wrapping instance
lkt_node_array FunDeclArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        FunDeclArrayWrapper_class_ref,
        FunDeclArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    lkt_node_array res = lkt_node_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        lkt_node elem_native = Entity_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void FunDeclArrayWrapper_release(
    lkt_node_array array_native
) {
    lkt_node_array_dec_ref(array_native);
}


    

// Create a new value for a lkt_internal_logic_context_array
lkt_internal_logic_context_array LogicContextArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native lkt_internal_logic_context_array in the Java wrapping class
jobject LogicContextArrayWrapper_wrap(
    JNIEnv *env,
    lkt_internal_logic_context_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        LogicContext_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        lkt_internal_logic_context elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            LogicContext_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        LogicContextArrayWrapper_class_ref,
        LogicContextArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native lkt_internal_logic_context_array from a Java wrapping instance
lkt_internal_logic_context_array LogicContextArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        LogicContextArrayWrapper_class_ref,
        LogicContextArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    lkt_internal_logic_context_array res = lkt_internal_logic_context_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        lkt_internal_logic_context elem_native = LogicContext_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void LogicContextArrayWrapper_release(
    lkt_internal_logic_context_array array_native
) {
    lkt_internal_logic_context_array_dec_ref(array_native);
}


    

// Create a new value for a lkt_internal_ref_result_array
lkt_internal_ref_result_array RefResultArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native lkt_internal_ref_result_array in the Java wrapping class
jobject RefResultArrayWrapper_wrap(
    JNIEnv *env,
    lkt_internal_ref_result_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        RefResult_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        lkt_internal_ref_result elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            RefResult_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        RefResultArrayWrapper_class_ref,
        RefResultArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native lkt_internal_ref_result_array from a Java wrapping instance
lkt_internal_ref_result_array RefResultArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        RefResultArrayWrapper_class_ref,
        RefResultArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    lkt_internal_ref_result_array res = lkt_internal_ref_result_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        lkt_internal_ref_result elem_native = RefResult_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void RefResultArrayWrapper_release(
    lkt_internal_ref_result_array array_native
) {
    lkt_internal_ref_result_array_dec_ref(array_native);
}


    

// Create a new value for a lkt_internal_solver_diagnostic_array
lkt_internal_solver_diagnostic_array SolverDiagnosticArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native lkt_internal_solver_diagnostic_array in the Java wrapping class
jobject SolverDiagnosticArrayWrapper_wrap(
    JNIEnv *env,
    lkt_internal_solver_diagnostic_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        SolverDiagnostic_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        lkt_internal_solver_diagnostic elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            SolverDiagnostic_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        SolverDiagnosticArrayWrapper_class_ref,
        SolverDiagnosticArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native lkt_internal_solver_diagnostic_array from a Java wrapping instance
lkt_internal_solver_diagnostic_array SolverDiagnosticArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        SolverDiagnosticArrayWrapper_class_ref,
        SolverDiagnosticArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    lkt_internal_solver_diagnostic_array res = lkt_internal_solver_diagnostic_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        lkt_internal_solver_diagnostic elem_native = SolverDiagnostic_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void SolverDiagnosticArrayWrapper_release(
    lkt_internal_solver_diagnostic_array array_native
) {
    lkt_internal_solver_diagnostic_array_dec_ref(array_native);
}


    

// Create a new value for a lkt_analysis_unit_array
lkt_analysis_unit_array AnalysisUnitArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native lkt_analysis_unit_array in the Java wrapping class
jobject AnalysisUnitArrayWrapper_wrap(
    JNIEnv *env,
    lkt_analysis_unit_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        AnalysisUnit_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        lkt_analysis_unit elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            AnalysisUnit_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        AnalysisUnitArrayWrapper_class_ref,
        AnalysisUnitArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native lkt_analysis_unit_array from a Java wrapping instance
lkt_analysis_unit_array AnalysisUnitArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        AnalysisUnitArrayWrapper_class_ref,
        AnalysisUnitArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    lkt_analysis_unit_array res = lkt_analysis_unit_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        lkt_analysis_unit elem_native = AnalysisUnit_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void AnalysisUnitArrayWrapper_release(
    lkt_analysis_unit_array array_native
) {
    lkt_analysis_unit_array_dec_ref(array_native);
}


// ==========
// Generated iterator functions
// ==========


// ==========
// Node functions
// ==========

// Return whether the two given entities are equal
JNIEXPORT jint Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1node_1is_1equivalent(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity_left,
    jobject entity_right
) {
    // Unwrap the nodes
    lkt_node entity_left_native = Entity_unwrap(env, entity_left);
    lkt_node entity_right_native = Entity_unwrap(env, entity_right);

    // Call the native function
    return (jint) lkt_node_is_equivalent(
        &entity_left_native,
        &entity_right_native
    );
}

// Get the hash of a node
JNIEXPORT jint Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1node_1hash(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);

    // Call the native function
    return (jint) lkt_node_hash(
        &entity_native
    );
}

// Get the kind of a node
JNIEXPORT jint Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1node_1kind(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);

    // Call the native function
    return (jint) lkt_node_kind(
        &entity_native
    );
}

// Get the text of a node
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1node_1text(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);

    // Prepare the result
    lkt_text res = Text_new_value();

    // Call the native function
    lkt_node_text(
        &entity_native,
        &res
    );

    // Return the node text
    return Text_wrap(env, res);
}

// Get the source location range of a node
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1node_1sloc_1range(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);

    // Prepare the result
    lkt_source_location_range res = SourceLocationRange_new_value();

    // Call the native function
    lkt_node_sloc_range(
        &entity_native,
        &res
    );

    // Return the source location range
    return SourceLocationRange_wrap(env, res);
}

// Get the children count of a node
JNIEXPORT jint Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1node_1children_1count(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);

    // Call the native function
    return (jint) lkt_node_children_count(
        &entity_native
    );
}

// Get the nth child of a node
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1node_1child(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity,
    jint n
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);

    // Preapre the result
    lkt_node res = Entity_new_value();

    // Call the native function
    lkt_node_child(
        &entity_native,
        (unsigned) n,
        &res
    );

    // Return the child entity
    return Entity_wrap(env, res);
}

// Get if a node is a token node
JNIEXPORT jboolean Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1node_1is_1token_1node(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);

    // Call the native function
    return (jboolean) lkt_node_is_token_node(
        &entity_native
    );
}

// Get the text image of a node
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1node_1unit(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);

    // Call the native function
    lkt_analysis_unit res_native = lkt_node_unit(
        &entity_native
    );

    // Return the result
    return AnalysisUnit_wrap(env, res_native);
}

// Get the text image of a node
JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1node_1image(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);

    // Prepare the result
    lkt_text res = Text_new_value();

    // Call the native function
    lkt_node_image(
        &entity_native,
        &res
    );

    // Return the image text
    return Text_wrap(env, res);
}

// ==========
// Node field accessors
// ==========


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1parent(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_parent(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1parents(
    JNIEnv *env,
    jclass jni_lib,
    jboolean with_self_java,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    lkt_bool with_self_native = (lkt_bool) with_self_java;

    // Prepare the result structure
    lkt_node_array res_native = LktNodeArrayWrapper_new_value();

    // Call the native function
    lkt_lkt_node_parents(
        &entity_native,
        with_self_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = LktNodeArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        LktNodeArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1children(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node_array res_native = LktNodeArrayWrapper_new_value();

    // Call the native function
    lkt_lkt_node_children(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = LktNodeArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        LktNodeArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1token_1start(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    lkt_analysis_unit unit_native = lkt_node_unit(&entity_native);


    // Unwrap the arguments

    // Prepare the result structure
    lkt_token res_native = Token_new_value();

    // Call the native function
    lkt_lkt_node_token_start(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Token_wrap(env, res_native, AnalysisUnit_wrap(env, unit_native));

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1token_1end(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    lkt_analysis_unit unit_native = lkt_node_unit(&entity_native);


    // Unwrap the arguments

    // Prepare the result structure
    lkt_token res_native = Token_new_value();

    // Call the native function
    lkt_lkt_node_token_end(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Token_wrap(env, res_native, AnalysisUnit_wrap(env, unit_native));

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jint Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1child_1index(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    int res_native = 0;

    // Call the native function
    lkt_lkt_node_child_index(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jint res = 0;
    if (exc_c == NULL)
      {
        res = (jint) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1previous_1sibling(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_previous_sibling(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1next_1sibling(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_next_sibling(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1unit(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_analysis_unit res_native = AnalysisUnit_new_value();

    // Call the native function
    lkt_lkt_node_unit(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = AnalysisUnit_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1is_1ghost(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_bool res_native = 0;

    // Call the native function
    lkt_lkt_node_is_ghost(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1full_1sloc_1image(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_string_type res_native = StringWrapper_new_value();

    // Call the native function
    lkt_lkt_node_full_sloc_image(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = StringWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        StringWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jint Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1completion_1item_1kind_1to_1int(
    JNIEnv *env,
    jclass jni_lib,
    jobject kind_java,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    lkt_completion_item_kind kind_native = CompletionItemKind_unwrap(env, kind_java);

    // Prepare the result structure
    int res_native = 0;

    // Call the native function
    lkt_lkt_node_completion_item_kind_to_int(
        &entity_native,
        kind_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jint res = 0;
    if (exc_c == NULL)
      {
        res = (jint) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1set_1solver_1debug_1mode(
    JNIEnv *env,
    jclass jni_lib,
    jboolean enable_java,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    lkt_bool enable_native = (lkt_bool) enable_java;

    // Prepare the result structure
    lkt_bool res_native = 0;

    // Call the native function
    lkt_lkt_node_p_set_solver_debug_mode(
        &entity_native,
        enable_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1basic_1trait_1gen(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_basic_trait_gen(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1basic_1trait(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_basic_trait(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1node_1gen_1trait(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_node_gen_trait(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1node_1trait(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_node_trait(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1indexable_1gen_1trait(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_indexable_gen_trait(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1indexable_1trait(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_indexable_trait(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1token_1node_1trait(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_token_node_trait(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1error_1node_1trait(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_error_node_trait(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1char_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_char_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1int_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_int_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1bool_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_bool_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1bigint_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_bigint_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1string_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_string_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1symbol_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_symbol_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1property_1error_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_property_error_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1regexp_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_regexp_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1entity_1gen_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_entity_gen_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1entity_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_entity_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1logicvar_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_logicvar_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1equation_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_equation_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1array_1gen_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_array_gen_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1array_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_array_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1astlist_1gen_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_astlist_gen_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1astlist_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_astlist_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1node_1builder_1gen_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_node_builder_gen_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1node_1builder_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_node_builder_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1iterator_1gen_1trait(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_iterator_gen_trait(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1iterator_1trait(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_iterator_trait(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1analysis_1unit_1gen_1trait(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_analysis_unit_gen_trait(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1analysis_1unit_1trait(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_analysis_unit_trait(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1topmost_1invalid_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lkt_node_p_topmost_invalid_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1nameres_1diagnostics(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_internal_solver_diagnostic_array res_native = SolverDiagnosticArrayWrapper_new_value();

    // Call the native function
    lkt_lkt_node_p_nameres_diagnostics(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = SolverDiagnosticArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        SolverDiagnosticArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1solve_1enclosing_1context(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_internal_solver_result res_native = SolverResult_new_value();

    // Call the native function
    lkt_lkt_node_p_solve_enclosing_context(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = SolverResult_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        SolverResult_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1xref_1entry_1point(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_bool res_native = 0;

    // Call the native function
    lkt_lkt_node_p_xref_entry_point(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lkt_1node_1p_1complete(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_internal_complete_item_array res_native = CompleteItemArrayWrapper_new_value();

    // Call the native function
    lkt_lkt_node_p_complete(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = CompleteItemArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        CompleteItemArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1argument_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_argument_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1argument_1f_1value(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_argument_f_value(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1base_1lexer_1case_1rule_1alt_1f_1send(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_base_lexer_case_rule_alt_f_send(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lexer_1case_1rule_1cond_1alt_1f_1cond_1exprs(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lexer_case_rule_cond_alt_f_cond_exprs(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1base_1match_1branch_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_base_match_branch_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1base_1match_1branch_1p_1match_1part(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_base_match_branch_p_match_part(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1match_1branch_1f_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_match_branch_f_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1pattern_1match_1branch_1f_1pattern(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_pattern_match_branch_f_pattern(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1block_1expr_1clause_1f_1clause(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_block_expr_clause_f_clause(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1class_1qualifier_1p_1as_1bool(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_bool res_native = 0;

    // Call the native function
    lkt_class_qualifier_p_as_bool(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1decl_1f_1syn_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_decl_f_syn_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1decl_1p_1custom_1image(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_string_type res_native = StringWrapper_new_value();

    // Call the native function
    lkt_decl_p_custom_image(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = StringWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        StringWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1decl_1p_1decl_1type_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_string_type res_native = StringWrapper_new_value();

    // Call the native function
    lkt_decl_p_decl_type_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = StringWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        StringWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1decl_1p_1def_1ids(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node_array res_native = DefIdArrayWrapper_new_value();

    // Call the native function
    lkt_decl_p_def_ids(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = DefIdArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        DefIdArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1decl_1p_1as_1bare_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_decl_p_as_bare_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1decl_1p_1get_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_decl_p_get_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1decl_1p_1get_1cast_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject cast_to_java,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    lkt_node cast_to_native = Entity_unwrap(env, cast_to_java);

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_decl_p_get_cast_type(
        &entity_native,
        &cast_to_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1decl_1p_1get_1keep_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject keep_type_java,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    lkt_node keep_type_native = Entity_unwrap(env, keep_type_java);

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_decl_p_get_keep_type(
        &entity_native,
        &keep_type_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1decl_1p_1get_1suffix_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject prefix_type_java,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    lkt_node prefix_type_native = Entity_unwrap(env, prefix_type_java);

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_decl_p_get_suffix_type(
        &entity_native,
        &prefix_type_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1decl_1p_1is_1generic(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_bool res_native = 0;

    // Call the native function
    lkt_decl_p_is_generic(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1decl_1p_1return_1type_1is_1instantiated(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_bool res_native = 0;

    // Call the native function
    lkt_decl_p_return_type_is_instantiated(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1decl_1p_1is_1instantiated(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_bool res_native = 0;

    // Call the native function
    lkt_decl_p_is_instantiated(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1decl_1p_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_symbol_type res_native = Symbol_new_value();

    // Call the native function
    lkt_decl_p_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Symbol_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1decl_1p_1full_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_string_type res_native = StringWrapper_new_value();

    // Call the native function
    lkt_decl_p_full_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = StringWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        StringWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1base_1grammar_1rule_1decl_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_base_grammar_rule_decl_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1explicitly_1typed_1decl_1f_1decl_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_explicitly_typed_decl_f_decl_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1component_1decl_1f_1default_1val(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_component_decl_f_default_val(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1field_1decl_1f_1trait_1ref(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_field_decl_f_trait_ref(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1fun_1param_1decl_1f_1decl_1annotations(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_fun_param_decl_f_decl_annotations(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1val_1decl_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_val_decl_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1fun_1decl_1f_1params(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_fun_decl_f_params(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1fun_1decl_1f_1return_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_fun_decl_f_return_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1fun_1decl_1f_1trait_1ref(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_fun_decl_f_trait_ref(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1fun_1decl_1f_1body(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_fun_decl_f_body(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1fun_1decl_1p_1is_1dynamic_1combiner(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_bool res_native = 0;

    // Call the native function
    lkt_fun_decl_p_is_dynamic_combiner(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1fun_1decl_1p_1find_1all_1overrides(
    JNIEnv *env,
    jclass jni_lib,
    jobject units_java,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    lkt_analysis_unit_array units_native = AnalysisUnitArrayWrapper_unwrap(env, units_java);

    // Prepare the result structure
    lkt_node_array res_native = FunDeclArrayWrapper_new_value();

    // Call the native function
    lkt_fun_decl_p_find_all_overrides(
        &entity_native,
        units_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = FunDeclArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        FunDeclArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */
    AnalysisUnitArrayWrapper_release(
        units_native
    );

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1env_1spec_1decl_1f_1actions(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_env_spec_decl_f_actions(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1generic_1decl_1f_1generic_1param_1decls(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_generic_decl_f_generic_param_decls(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1generic_1decl_1f_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_generic_decl_f_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1decl_1f_1rules(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_decl_f_rules(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lexer_1decl_1f_1rules(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lexer_decl_f_rules(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lexer_1family_1decl_1f_1rules(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lexer_family_decl_f_rules(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1type_1decl_1f_1traits(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_type_decl_f_traits(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1type_1decl_1f_1syn_1base_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_type_decl_f_syn_base_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1type_1decl_1p_1def_1id(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_type_decl_p_def_id(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1type_1decl_1p_1base_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_type_decl_p_base_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1type_1decl_1p_1base_1type_1if_1entity(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_type_decl_p_base_type_if_entity(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1generic_1param_1type_1decl_1f_1has_1class(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_generic_param_type_decl_f_has_class(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1named_1type_1decl_1f_1decls(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_named_type_decl_f_decls(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1enum_1class_1decl_1f_1branches(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_enum_class_decl_f_branches(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1enum_1type_1decl_1f_1literals(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_enum_type_decl_f_literals(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1decl_1annotation_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_decl_annotation_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1decl_1annotation_1f_1args(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_decl_annotation_f_args(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1decl_1annotation_1args_1f_1args(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_decl_annotation_args_f_args(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1elsif_1branch_1f_1cond_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_elsif_branch_f_cond_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1elsif_1branch_1f_1then_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_elsif_branch_f_then_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1enum_1class_1case_1f_1decls(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_enum_class_case_f_decls(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1excludes_1null_1p_1as_1bool(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_bool res_native = 0;

    // Call the native function
    lkt_excludes_null_p_as_bool(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1expr_1p_1get_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_expr_p_get_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1expr_1p_1get_1generic_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_expr_p_get_generic_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1expr_1p_1get_1expected_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_expr_p_get_expected_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1expr_1p_1referenced_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_expr_p_referenced_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1any_1of_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_any_of_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1any_1of_1f_1values(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_any_of_f_values(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1array_1literal_1f_1exprs(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_array_literal_f_exprs(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1array_1literal_1f_1element_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_array_literal_f_element_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1base_1call_1expr_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_base_call_expr_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1base_1call_1expr_1f_1args(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_base_call_expr_f_args(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1bin_1op_1f_1left(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_bin_op_f_left(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1bin_1op_1f_1op(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_bin_op_f_op(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1bin_1op_1f_1right(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_bin_op_f_right(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1block_1expr_1f_1clauses(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_block_expr_f_clauses(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1cast_1expr_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_cast_expr_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1cast_1expr_1f_1null_1cond(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_cast_expr_f_null_cond(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1cast_1expr_1f_1excludes_1null(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_cast_expr_f_excludes_null(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1cast_1expr_1f_1dest_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_cast_expr_f_dest_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1dot_1expr_1f_1prefix(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_dot_expr_f_prefix(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1dot_1expr_1f_1null_1cond(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_dot_expr_f_null_cond(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1dot_1expr_1f_1suffix(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_dot_expr_f_suffix(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1error_1on_1null_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_error_on_null_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1generic_1instantiation_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_generic_instantiation_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1generic_1instantiation_1f_1args(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_generic_instantiation_f_args(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1discard_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_discard_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1dont_1skip_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_dont_skip_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1dont_1skip_1f_1dont_1skip(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_dont_skip_f_dont_skip(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1list_1f_1list_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_list_f_list_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1list_1f_1kind(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_list_f_kind(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1list_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_list_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1list_1f_1sep(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_list_f_sep(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1null_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_null_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1opt_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_opt_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1opt_1error_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_opt_error_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1opt_1error_1group_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_opt_error_group_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1opt_1group_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_opt_group_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1or_1expr_1f_1sub_1exprs(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_or_expr_f_sub_exprs(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1pick_1f_1exprs(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_pick_f_exprs(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1predicate_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_predicate_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1predicate_1f_1prop_1ref(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_predicate_f_prop_ref(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1rule_1ref_1f_1node_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_rule_ref_f_node_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1skip_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_skip_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1stop_1cut_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_stop_cut_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1parse_1node_1expr_1f_1node_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_parse_node_expr_f_node_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1parse_1node_1expr_1f_1sub_1exprs(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_parse_node_expr_f_sub_exprs(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1token_1lit_1p_1denoted_1value(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_internal_decoded_string_value res_native = DecodedStringValue_new_value();

    // Call the native function
    lkt_token_lit_p_denoted_value(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = DecodedStringValue_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        DecodedStringValue_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1token_1no_1case_1lit_1f_1lit(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_token_no_case_lit_f_lit(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1token_1pattern_1concat_1f_1left(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_token_pattern_concat_f_left(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1token_1pattern_1concat_1f_1right(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_token_pattern_concat_f_right(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1token_1pattern_1lit_1p_1denoted_1value(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_internal_decoded_string_value res_native = DecodedStringValue_new_value();

    // Call the native function
    lkt_token_pattern_lit_p_denoted_value(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = DecodedStringValue_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        DecodedStringValue_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1token_1ref_1f_1token_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_token_ref_f_token_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1token_1ref_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_token_ref_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1id_1p_1custom_1image(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_string_type res_native = StringWrapper_new_value();

    // Call the native function
    lkt_id_p_custom_image(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = StringWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        StringWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1def_1id_1p_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_string_type res_native = StringWrapper_new_value();

    // Call the native function
    lkt_def_id_p_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = StringWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        StringWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1def_1id_1p_1get_1implementatinons(
    JNIEnv *env,
    jclass jni_lib,
    jobject units_java,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    lkt_analysis_unit_array units_native = AnalysisUnitArrayWrapper_unwrap(env, units_java);

    // Prepare the result structure
    lkt_node_array res_native = DefIdArrayWrapper_new_value();

    // Call the native function
    lkt_def_id_p_get_implementatinons(
        &entity_native,
        units_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = DefIdArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        DefIdArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */
    AnalysisUnitArrayWrapper_release(
        units_native
    );

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1def_1id_1p_1decl_1detail(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_string_type res_native = StringWrapper_new_value();

    // Call the native function
    lkt_def_id_p_decl_detail(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = StringWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        StringWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jint Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1def_1id_1p_1completion_1item_1kind(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    int res_native = 0;

    // Call the native function
    lkt_def_id_p_completion_item_kind(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jint res = 0;
    if (exc_c == NULL)
      {
        res = (jint) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1def_1id_1p_1doc(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_string_type res_native = StringWrapper_new_value();

    // Call the native function
    lkt_def_id_p_doc(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = StringWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        StringWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1def_1id_1p_1find_1all_1references(
    JNIEnv *env,
    jclass jni_lib,
    jobject units_java,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    lkt_analysis_unit_array units_native = AnalysisUnitArrayWrapper_unwrap(env, units_java);

    // Prepare the result structure
    lkt_internal_ref_result_array res_native = RefResultArrayWrapper_new_value();

    // Call the native function
    lkt_def_id_p_find_all_references(
        &entity_native,
        units_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = RefResultArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        RefResultArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */
    AnalysisUnitArrayWrapper_release(
        units_native
    );

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1ref_1id_1p_1referenced_1defining_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_ref_id_p_referenced_defining_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1if_1expr_1f_1cond_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_if_expr_f_cond_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1if_1expr_1f_1then_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_if_expr_f_then_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1if_1expr_1f_1alternatives(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_if_expr_f_alternatives(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1if_1expr_1f_1else_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_if_expr_f_else_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1isa_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_isa_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1isa_1f_1pattern(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_isa_f_pattern(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1keep_1expr_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_keep_expr_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1keep_1expr_1f_1null_1cond(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_keep_expr_f_null_cond(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1keep_1expr_1f_1keep_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_keep_expr_f_keep_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lambda_1expr_1f_1params(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lambda_expr_f_params(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lambda_1expr_1f_1return_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lambda_expr_f_return_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lambda_1expr_1f_1body(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lambda_expr_f_body(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1char_1lit_1p_1denoted_1value(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_internal_decoded_char_value res_native = DecodedCharValue_new_value();

    // Call the native function
    lkt_char_lit_p_denoted_value(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = DecodedCharValue_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        DecodedCharValue_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1null_1lit_1f_1dest_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_null_lit_f_dest_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1string_1lit_1p_1denoted_1value(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_internal_decoded_string_value res_native = DecodedStringValue_new_value();

    // Call the native function
    lkt_string_lit_p_denoted_value(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = DecodedStringValue_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        DecodedStringValue_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1string_1lit_1p_1is_1prefixed_1string(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_bool res_native = 0;

    // Call the native function
    lkt_string_lit_p_is_prefixed_string(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1string_1lit_1p_1prefix(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    uint32_t res_native = Char_new_value();

    // Call the native function
    lkt_string_lit_p_prefix(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Char_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1string_1lit_1p_1is_1regexp_1literal(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_bool res_native = 0;

    // Call the native function
    lkt_string_lit_p_is_regexp_literal(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1block_1string_1lit_1f_1lines(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_block_string_lit_f_lines(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1logic_1assign_1f_1dest_1var(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_logic_assign_f_dest_var(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1logic_1assign_1f_1value(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_logic_assign_f_value(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1logic_1expr_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_logic_expr_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1logic_1propagate_1f_1dest_1var(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_logic_propagate_f_dest_var(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1logic_1propagate_1f_1call(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_logic_propagate_f_call(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1logic_1unify_1f_1lhs(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_logic_unify_f_lhs(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1logic_1unify_1f_1rhs(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_logic_unify_f_rhs(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1match_1expr_1f_1match_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_match_expr_f_match_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1match_1expr_1f_1branches(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_match_expr_f_branches(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1not_1expr_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_not_expr_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1paren_1expr_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_paren_expr_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1raise_1expr_1f_1dest_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_raise_expr_f_dest_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1raise_1expr_1f_1except_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_raise_expr_f_except_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1subscript_1expr_1f_1prefix(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_subscript_expr_f_prefix(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1subscript_1expr_1f_1null_1cond(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_subscript_expr_f_null_cond(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1subscript_1expr_1f_1index(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_subscript_expr_f_index(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1try_1expr_1f_1try_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_try_expr_f_try_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1try_1expr_1f_1or_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_try_expr_f_or_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1un_1op_1f_1op(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_un_op_f_op(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1un_1op_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_un_op_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1full_1decl_1f_1doc(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_full_decl_f_doc(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1full_1decl_1f_1decl_1annotations(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_full_decl_f_decl_annotations(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1full_1decl_1f_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_full_decl_f_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1full_1decl_1p_1has_1annotation(
    JNIEnv *env,
    jclass jni_lib,
    jobject name_java,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    lkt_analysis_unit unit_native = lkt_node_unit(&entity_native);

    // Get the node context
    lkt_analysis_context context_native =
        lkt_unit_context(unit_native);

    // Unwrap the arguments
    lkt_symbol_type name_native = Symbol_unwrap(env, name_java, context_native);

    // Prepare the result structure
    lkt_bool res_native = 0;

    // Call the native function
    lkt_full_decl_p_has_annotation(
        &entity_native,
        &name_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1list_1sep_1f_1token(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_list_sep_f_token(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1grammar_1list_1sep_1f_1extra(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_grammar_list_sep_f_extra(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1import_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_import_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1import_1p_1referenced_1unit(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_analysis_unit res_native = AnalysisUnit_new_value();

    // Call the native function
    lkt_import_p_referenced_unit(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = AnalysisUnit_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1langkit_1root_1f_1imports(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_langkit_root_f_imports(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1langkit_1root_1f_1decls(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_langkit_root_f_decls(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1langkit_1root_1p_1fetch_1prelude(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_analysis_unit res_native = AnalysisUnit_new_value();

    // Call the native function
    lkt_langkit_root_p_fetch_prelude(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = AnalysisUnit_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lexer_1case_1rule_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lexer_case_rule_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lexer_1case_1rule_1f_1alts(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lexer_case_rule_f_alts(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lexer_1case_1rule_1send_1f_1sent(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lexer_case_rule_send_f_sent(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1lexer_1case_1rule_1send_1f_1match_1size(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_lexer_case_rule_send_f_match_size(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1null_1cond_1qualifier_1p_1as_1bool(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_bool res_native = 0;

    // Call the native function
    lkt_null_cond_qualifier_p_as_bool(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1binding_1pattern_1f_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_binding_pattern_f_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1binding_1pattern_1f_1sub_1pattern(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_binding_pattern_f_sub_pattern(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1ellipsis_1pattern_1f_1binding(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_ellipsis_pattern_f_binding(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1extended_1pattern_1f_1sub_1pattern(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_extended_pattern_f_sub_pattern(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1extended_1pattern_1f_1details(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_extended_pattern_f_details(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1filtered_1pattern_1f_1sub_1pattern(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_filtered_pattern_f_sub_pattern(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1filtered_1pattern_1f_1predicate(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_filtered_pattern_f_predicate(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1list_1pattern_1f_1sub_1patterns(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_list_pattern_f_sub_patterns(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1not_1pattern_1f_1sub_1pattern(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_not_pattern_f_sub_pattern(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1or_1pattern_1f_1left_1sub_1pattern(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_or_pattern_f_left_sub_pattern(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1or_1pattern_1f_1right_1sub_1pattern(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_or_pattern_f_right_sub_pattern(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1paren_1pattern_1f_1sub_1pattern(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_paren_pattern_f_sub_pattern(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1tuple_1pattern_1f_1sub_1patterns(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_tuple_pattern_f_sub_patterns(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1type_1pattern_1f_1type_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_type_pattern_f_type_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1field_1pattern_1detail_1f_1id(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_field_pattern_detail_f_id(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1field_1pattern_1detail_1f_1expected_1value(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_field_pattern_detail_f_expected_value(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1property_1pattern_1detail_1f_1call(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_property_pattern_detail_f_call(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1property_1pattern_1detail_1f_1expected_1value(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_property_pattern_detail_f_expected_value(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1selector_1pattern_1detail_1f_1call(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_selector_pattern_detail_f_call(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1selector_1pattern_1detail_1f_1sub_1pattern(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_selector_pattern_detail_f_sub_pattern(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1selector_1call_1f_1quantifier(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_selector_call_f_quantifier(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1selector_1call_1f_1binding(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_selector_call_f_binding(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1selector_1call_1f_1selector_1call(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_selector_call_f_selector_call(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1type_1ref_1p_1referenced_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_type_ref_p_referenced_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1function_1type_1ref_1f_1param_1types(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_function_type_ref_f_param_types(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1function_1type_1ref_1f_1return_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_function_type_ref_f_return_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1generic_1type_1ref_1f_1type_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_generic_type_ref_f_type_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1generic_1type_1ref_1f_1args(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_generic_type_ref_f_args(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1simple_1type_1ref_1f_1type_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_simple_type_ref_f_type_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1var_1bind_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_var_bind_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_liblktlang_Liblktlang_00024JNI_1LIB_lkt_1var_1bind_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    lkt_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    lkt_node res_native = Entity_new_value();

    // Call the native function
    lkt_var_bind_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const lkt_exception *exc_c = lkt_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}

