# The PEP 484 type hints stub file for the krita module.
#
# Generated by SIP 6.15.0


import collections, re, typing

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt5.sip

from PyQt5 import QtCore
from PyQt5 import QtGui
from PyQt5 import QtXml
from PyQt5 import QtWidgets

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., Any], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        PyQt5.sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], PyQt5.sip.Buffer, int, None]


class Shape(QtCore.QObject):

    def parentShape(self) -> 'Shape|None': ...
    def isSelected(self) -> bool: ...
    def deselect(self) -> None: ...
    def select(self) -> None: ...
    def toSvg(self, prependStyles: bool = ..., stripTextMode: bool = ...) -> str: ...
    def updateAbsolute(self, box: QtCore.QRectF) -> None: ...
    def update(self) -> None: ...
    def remove(self) -> bool: ...
    def absoluteTransformation(self) -> QtGui.QTransform: ...
    def setTransformation(self, matrix: QtGui.QTransform) -> None: ...
    def transformation(self) -> QtGui.QTransform: ...
    def setPosition(self, point: QtCore.QPointF|QtCore.QPoint) -> None: ...
    def position(self) -> QtCore.QPointF: ...
    def boundingBox(self) -> QtCore.QRectF: ...
    def setGeometryProtected(self, protect: bool) -> None: ...
    def geometryProtected(self) -> bool: ...
    def setSelectable(self, selectable: bool) -> None: ...
    def selectable(self) -> bool: ...
    def setVisible(self, visible: bool) -> None: ...
    def visible(self) -> bool: ...
    def setZIndex(self, zindex: int) -> None: ...
    def zIndex(self) -> int: ...
    def setName(self, name: str|None) -> None: ...
    def name(self) -> str: ...
    def type(self) -> str: ...


class GroupShape(Shape):

    def children(self) -> list[Shape]: ...


class Canvas(QtCore.QObject):

    def view(self) -> 'View|None': ...
    def levelOfDetailMode(self) -> bool: ...
    def setLevelOfDetailMode(self, enable: bool) -> None: ...
    def wrapAroundMode(self) -> bool: ...
    def setWrapAroundMode(self, enable: bool) -> None: ...
    def setMirror(self, value: bool) -> None: ...
    def mirror(self) -> bool: ...
    def setRotation(self, angle: float) -> None: ...
    def rotation(self) -> float: ...
    def resetRotation(self) -> None: ...
    def resetZoom(self) -> None: ...
    def setZoomLevel(self, value: float) -> None: ...
    def zoomLevel(self) -> float: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Channel(QtCore.QObject):

    def setPixelData(self, value: QtCore.QByteArray|bytes|bytearray, rect: QtCore.QRect) -> None: ...
    def pixelData(self, rect: QtCore.QRect) -> QtCore.QByteArray: ...
    def bounds(self) -> QtCore.QRect: ...
    def channelSize(self) -> int: ...
    def position(self) -> int: ...
    def name(self) -> str: ...
    def setVisible(self, value: bool) -> None: ...
    def visible(self) -> bool: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class DockWidgetFactoryBase(PyQt5.sip.wrapper):

    class DockPosition(int):
        DockTornOff = ... # type: DockWidgetFactoryBase.DockPosition
        DockTop = ... # type: DockWidgetFactoryBase.DockPosition
        DockBottom = ... # type: DockWidgetFactoryBase.DockPosition
        DockRight = ... # type: DockWidgetFactoryBase.DockPosition
        DockLeft = ... # type: DockWidgetFactoryBase.DockPosition
        DockMinimized = ... # type: DockWidgetFactoryBase.DockPosition

    @typing.overload
    def __init__(self, _id: str|None, _dockPosition: 'DockWidgetFactoryBase.DockPosition') -> None: ...
    @typing.overload
    def __init__(self, a0: 'DockWidgetFactoryBase') -> None: ...

    def id(self) -> str: ...
    def createDockWidget(self) -> QtWidgets.QDockWidget|None: ...


class DockWidget(QtWidgets.QDockWidget):

    def __init__(self) -> None: ...

    def canvasChanged(self, canvas: Canvas|None) -> None: ...
    def canvas(self) -> Canvas|None: ...


class Document(QtCore.QObject):

    def removeAnnotation(self, type: str|None) -> None: ...
    def setAnnotation(self, type: str|None, description: str|None, annotation: QtCore.QByteArray|bytes|bytearray) -> None: ...
    def annotation(self, type: str|None) -> QtCore.QByteArray: ...
    def annotationDescription(self, type: str|None) -> str: ...
    def annotationTypes(self) -> list[str]: ...
    def setCurrentTime(self, time: int) -> None: ...
    def currentTime(self) -> int: ...
    def playBackEndTime(self) -> int: ...
    def playBackStartTime(self) -> int: ...
    def setPlayBackRange(self, start: int, stop: int) -> None: ...
    def animationLength(self) -> int: ...
    def fullClipRangeEndTime(self) -> int: ...
    def setFullClipRangeEndTime(self, endTime: int) -> None: ...
    def fullClipRangeStartTime(self) -> int: ...
    def setFullClipRangeStartTime(self, startTime: int) -> None: ...
    def setFramesPerSecond(self, fps: int) -> None: ...
    def framesPerSecond(self) -> int: ...
    def importAnimation(self, files: collections.abc.Iterable[str|None], firstFrame: int, step: int) -> bool: ...
    def bounds(self) -> QtCore.QRect: ...
    def setModified(self, modified: bool) -> None: ...
    def modified(self) -> bool: ...
    def setGuidesLocked(self, locked: bool) -> None: ...
    def setGuidesVisible(self, visible: bool) -> None: ...
    def setVerticalGuides(self, lines: collections.abc.Iterable[float]) -> None: ...
    def setHorizontalGuides(self, lines: collections.abc.Iterable[float]) -> None: ...
    def refreshProjection(self) -> None: ...
    def tryBarrierLock(self) -> bool: ...
    def waitForDone(self) -> None: ...
    def unlock(self) -> None: ...
    def lock(self) -> None: ...
    def thumbnail(self, w: int, h: int) -> QtGui.QImage: ...
    def projection(self, x: int = ..., y: int = ..., w: int = ..., h: int = ...) -> QtGui.QImage: ...
    def createColorizeMask(self, name: str|None) -> 'ColorizeMask|None': ...
    def createTransformMask(self, name: str|None) -> 'TransformMask|None': ...
    def createTransparencyMask(self, name: str|None) -> 'TransparencyMask|None': ...
    def createSelectionMask(self, name: str|None) -> 'SelectionMask|None': ...
    @typing.overload
    def createFilterMask(self, name: str|None, filter: 'Filter', selection: 'Selection') -> 'FilterMask|None': ...
    @typing.overload
    def createFilterMask(self, name: str|None, filter: 'Filter', selection_source: 'Node|None') -> 'FilterMask|None': ...
    def createFileLayer(self, name: str|None, fileName: str|None, scalingMethod: str|None, scalingFilter: str|None = ...) -> 'FileLayer|None': ...
    def createVectorLayer(self, name: str|None) -> 'VectorLayer|None': ...
    def createFillLayer(self, name: str|None, filterName: str|None, configuration: 'InfoObject', selection: 'Selection') -> 'FillLayer|None': ...
    def createFilterLayer(self, name: str|None, filter: 'Filter', selection: 'Selection') -> 'FilterLayer|None': ...
    def createCloneLayer(self, name: str|None, source: 'Node|None') -> 'CloneLayer|None': ...
    def createGroupLayer(self, name: str|None) -> 'GroupLayer|None': ...
    def createNode(self, name: str|None, nodeType: str|None) -> 'Node|None': ...
    def saveAs(self, filename: str|None) -> bool: ...
    def save(self) -> bool: ...
    def shearImage(self, angleX: float, angleY: float) -> None: ...
    def rotateImage(self, radians: float) -> None: ...
    def scaleImage(self, w: int, h: int, xres: int, yres: int, strategy: str|None) -> None: ...
    def resizeImage(self, x: int, y: int, w: int, h: int) -> None: ...
    def flatten(self) -> None: ...
    def exportImage(self, filename: str|None, exportConfiguration: 'InfoObject') -> bool: ...
    def crop(self, x: int, y: int, w: int, h: int) -> None: ...
    def close(self) -> bool: ...
    def pixelData(self, x: int, y: int, w: int, h: int) -> QtCore.QByteArray: ...
    def setYRes(self, yRes: float) -> None: ...
    def yRes(self) -> float: ...
    def setXRes(self, xRes: float) -> None: ...
    def xRes(self) -> float: ...
    def setYOffset(self, y: int) -> None: ...
    def yOffset(self) -> int: ...
    def setXOffset(self, x: int) -> None: ...
    def xOffset(self) -> int: ...
    def setWidth(self, value: int) -> None: ...
    def width(self) -> int: ...
    def setSelection(self, value: 'Selection|None') -> None: ...
    def selection(self) -> 'Selection|None': ...
    def rootNode(self) -> 'Node|None': ...
    def setResolution(self, value: int) -> None: ...
    def resolution(self) -> int: ...
    def setName(self, value: str|None) -> None: ...
    def name(self) -> str: ...
    def setHeight(self, value: int) -> None: ...
    def height(self) -> int: ...
    def setFileName(self, value: str|None) -> None: ...
    def fileName(self) -> str: ...
    def setDocumentInfo(self, document: str|None) -> None: ...
    def documentInfo(self) -> str: ...
    def setBackgroundColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor) -> bool: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def setColorSpace(self, value: str|None, colorDepth: str|None, colorProfile: str|None) -> bool: ...
    def setColorProfile(self, colorProfile: str|None) -> bool: ...
    def colorProfile(self) -> str: ...
    def colorModel(self) -> str: ...
    def colorDepth(self) -> str: ...
    def setBatchmode(self, value: bool) -> None: ...
    def batchmode(self) -> bool: ...
    def nodeByUniqueID(self, id: QtCore.QUuid) -> 'Node|None': ...
    def nodeByName(self, node: str|None) -> 'Node|None': ...
    def topLevelNodes(self) -> list['Node']: ...
    def setActiveNode(self, value: 'Node|None') -> None: ...
    def activeNode(self) -> 'Node|None': ...
    def clone(self) -> 'Document|None': ...
    def guidesLocked(self) -> bool: ...
    def guidesVisible(self) -> bool: ...
    def verticalGuides(self) -> list[float]: ...
    def horizontalGuides(self) -> list[float]: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Filter(QtCore.QObject):

    def __init__(self) -> None: ...

    def startFilter(self, node: 'Node|None', x: int, y: int, w: int, h: int) -> bool: ...
    def apply(self, node: 'Node|None', x: int, y: int, w: int, h: int) -> None: ...
    def setConfiguration(self, value: 'InfoObject|None') -> None: ...
    def configuration(self) -> 'InfoObject|None': ...
    def setName(self, a0: str|None) -> None: ...
    def name(self) -> str: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class InfoObject(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def property(self, key: str|None) -> typing.Any: ...
    def setProperty(self, key: str|None, value: typing.Any) -> None: ...
    def setProperties(self, value: dict[str|None, typing.Any]) -> None: ...
    def properties(self) -> dict[str, typing.Any]: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Extension(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def createActions(self, window: 'Window|None') -> None: ...
    def setup(self) -> None: ...


class View(QtCore.QObject):

    def flakeToImageTransform(self) -> QtGui.QTransform: ...
    def flakeToCanvasTransform(self) -> QtGui.QTransform: ...
    def flakeToDocumentTransform(self) -> QtGui.QTransform: ...
    def selectedNodes(self) -> list['Node']: ...
    def showFloatingMessage(self, message: str|None, icon: QtGui.QIcon, timeout: int, priority: int) -> None: ...
    def setPaintingFlow(self, flow: float) -> None: ...
    def paintingFlow(self) -> float: ...
    def setBrushRotation(self, brushRotation: float) -> None: ...
    def brushRotation(self) -> float: ...
    def setBrushSize(self, brushSize: float) -> None: ...
    def brushSize(self) -> float: ...
    def setPaintingOpacity(self, opacity: float) -> None: ...
    def paintingOpacity(self) -> float: ...
    def setHDRGamma(self, gamma: float) -> None: ...
    def HDRGamma(self) -> float: ...
    def setHDRExposure(self, exposure: float) -> None: ...
    def HDRExposure(self) -> float: ...
    def setCurrentBlendingMode(self, blendingMode: str|None) -> None: ...
    def currentBlendingMode(self) -> str: ...
    def setCurrentGradient(self, resource: 'Resource|None') -> None: ...
    def currentGradient(self) -> 'Resource|None': ...
    def setCurrentPattern(self, resource: 'Resource|None') -> None: ...
    def currentPattern(self) -> 'Resource|None': ...
    def setCurrentBrushPreset(self, resource: 'Resource|None') -> None: ...
    def currentBrushPreset(self) -> 'Resource|None': ...
    def setBackGroundColor(self, color: 'ManagedColor|None') -> None: ...
    def backgroundColor(self) -> 'ManagedColor|None': ...
    def setForeGroundColor(self, color: 'ManagedColor|None') -> None: ...
    def foregroundColor(self) -> 'ManagedColor|None': ...
    def activateResource(self, resource: 'Resource|None') -> None: ...
    def canvas(self) -> Canvas|None: ...
    def setVisible(self) -> None: ...
    def visible(self) -> bool: ...
    def setDocument(self, document: Document|None) -> None: ...
    def document(self) -> Document|None: ...
    def window(self) -> 'Window|None': ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Window(QtCore.QObject):

    activeViewChanged: typing.ClassVar[QtCore.pyqtSignal]
    themeChanged: typing.ClassVar[QtCore.pyqtSignal]
    windowClosed: typing.ClassVar[QtCore.pyqtSignal]
    def createAction(self, id: str|None, text: str|None = ..., menuLocation: str|None = ...) -> QtWidgets.QAction|None: ...
    def close(self) -> None: ...
    def activate(self) -> None: ...
    def activeView(self) -> View|None: ...
    def showView(self, view: View|None) -> None: ...
    def addView(self, document: Document|None) -> View|None: ...
    def views(self) -> list[View]: ...
    def dockers(self) -> list[QtWidgets.QDockWidget]: ...
    def qwindow(self) -> QtWidgets.QMainWindow|None: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Krita(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    @staticmethod
    def getAppDataLocation() -> str: ...
    @staticmethod
    def krita_i18nc(context: str|None, text: str|None) -> str: ...
    @staticmethod
    def krita_i18n(text: str|None) -> str: ...
    @staticmethod
    def fromVariant(v: typing.Any) -> QtCore.QObject|None: ...
    @staticmethod
    def instance() -> 'Krita|None': ...
    def readSetting(self, group: str|None, name: str|None, defaultValue: str|None) -> str: ...
    def writeSetting(self, group: str|None, name: str|None, value: str|None) -> None: ...
    def addDockWidgetFactory(self, _factory: DockWidgetFactoryBase|None) -> None: ...
    def addExtension(self, _extension: Extension|None) -> None: ...
    def icon(self, iconName: str|None) -> QtGui.QIcon: ...
    def openWindow(self) -> Window|None: ...
    def openDocument(self, filename: str|None) -> Document|None: ...
    def extensions(self) -> list[Extension]: ...
    def createDocument(self, width: int, height: int, name: str|None, colorModel: str|None, colorDepth: str|None, profile: str|None, resolution: float) -> Document|None: ...
    def recentDocuments(self) -> list[str]: ...
    def resources(self, type: str|None) -> typing.Any: ...
    def windows(self) -> list[Window]: ...
    def activeWindow(self) -> Window|None: ...
    def views(self) -> list[View]: ...
    def version(self) -> str: ...
    def notifier(self) -> 'Notifier|None': ...
    def addProfile(self, profilePath: str|None) -> bool: ...
    def profiles(self, colorModel: str|None, ColorDepth: str|None) -> list[str]: ...
    def filterStrategies(self) -> list[str]: ...
    def colorDepths(self, colorModel: str|None) -> list[str]: ...
    def colorModels(self) -> list[str]: ...
    def filter(self, name: str|None) -> Filter|None: ...
    def filters(self) -> list[str]: ...
    def dockers(self) -> list[QtWidgets.QDockWidget]: ...
    def documents(self) -> list[Document]: ...
    def action(self, name: str|None) -> QtWidgets.QAction|None: ...
    def actions(self) -> list[QtWidgets.QAction]: ...
    def setBatchmode(self, value: bool) -> None: ...
    def batchmode(self) -> bool: ...
    def setActiveDocument(self, value: Document|None) -> None: ...
    def activeDocument(self) -> Document|None: ...


class Node(QtCore.QObject):

    def uniqueId(self) -> QtCore.QUuid: ...
    def index(self) -> int: ...
    def setLayerStyleFromAsl(self, asl: str|None) -> None: ...
    def layerStyleToAsl(self) -> str: ...
    def thumbnail(self, w: int, h: int) -> QtGui.QImage: ...
    def shearNode(self, angleX: float, angleY: float) -> None: ...
    def cropNode(self, x: int, y: int, w: int, h: int) -> None: ...
    def rotateNode(self, radians: float) -> None: ...
    def scaleNode(self, origin: QtCore.QPointF|QtCore.QPoint, width: int, height: int, strategy: str|None) -> None: ...
    def mergeDown(self) -> 'Node|None': ...
    def save(self, filename: str|None, xRes: float, yRes: float, exportConfiguration: InfoObject, exportRect: QtCore.QRect = ...) -> None: ...
    def duplicate(self) -> 'Node|None': ...
    def remove(self) -> bool: ...
    def position(self) -> QtCore.QPoint: ...
    def move(self, x: int, y: int) -> None: ...
    def bounds(self) -> QtCore.QRect: ...
    def setPixelData(self, value: QtCore.QByteArray|bytes|bytearray, x: int, y: int, w: int, h: int) -> None: ...
    def projectionPixelData(self, x: int, y: int, w: int, h: int) -> QtCore.QByteArray: ...
    def pixelDataAtTime(self, x: int, y: int, w: int, h: int, time: int) -> QtCore.QByteArray: ...
    def pixelData(self, x: int, y: int, w: int, h: int) -> QtCore.QByteArray: ...
    def setVisible(self, value: bool) -> None: ...
    def hasKeyframeAtTime(self, frameNumber: int) -> bool: ...
    def visible(self) -> bool: ...
    def icon(self) -> QtGui.QIcon: ...
    def type(self) -> str: ...
    def parentNode(self) -> 'Node|None': ...
    def setOpacity(self, value: int) -> None: ...
    def opacity(self) -> int: ...
    def setName(self, value: str|None) -> None: ...
    def name(self) -> str: ...
    def hasExtents(self) -> bool: ...
    def setLocked(self, value: bool) -> None: ...
    def locked(self) -> bool: ...
    def setInheritAlpha(self, value: bool) -> None: ...
    def inheritAlpha(self) -> bool: ...
    def setColorSpace(self, colorModel: str|None, colorDepth: str|None, colorProfile: str|None) -> bool: ...
    def setColorProfile(self, colorProfile: str|None) -> bool: ...
    def colorProfile(self) -> str: ...
    def colorModel(self) -> str: ...
    def setColorLabel(self, value: int) -> None: ...
    def colorLabel(self) -> int: ...
    def collapsed(self) -> bool: ...
    def setCollapsed(self, collapsed: bool) -> None: ...
    def enableAnimation(self) -> None: ...
    def animated(self) -> bool: ...
    def colorDepth(self) -> str: ...
    def setChildNodes(self, nodes: collections.abc.Iterable['Node']) -> None: ...
    def removeChildNode(self, child: 'Node|None') -> bool: ...
    def addChildNode(self, child: 'Node|None', above: 'Node|None') -> bool: ...
    def findChildNodes(self, name: str|None = ..., recursive: bool = ..., partialMatch: bool = ..., type: str|None = ..., colorLabelIndex: int = ...) -> list['Node']: ...
    def childNodes(self) -> list['Node']: ...
    def channels(self) -> list[Channel]: ...
    def setBlendingMode(self, value: str|None) -> None: ...
    def blendingMode(self) -> str: ...
    def setAlphaLocked(self, value: bool) -> None: ...
    def alphaLocked(self) -> bool: ...
    def clone(self) -> 'Node|None': ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class GroupLayer(Node):

    def passThroughMode(self) -> bool: ...
    def setPassThroughMode(self, passthrough: bool) -> None: ...
    def type(self) -> str: ...


class CloneLayer(Node):

    def setSourceNode(self, node: Node|None) -> None: ...
    def sourceNode(self) -> Node|None: ...
    def type(self) -> str: ...


class FilterLayer(Node):

    def filter(self) -> Filter|None: ...
    def setFilter(self, filter: Filter) -> None: ...
    def type(self) -> str: ...


class FileLayer(Node):

    def path(self) -> str: ...
    def scalingFilter(self) -> str: ...
    def scalingMethod(self) -> str: ...
    def resetCache(self) -> None: ...
    def setProperties(self, FileName: str|None, ScalingMethod: str|None, scalingFilter: str|None) -> None: ...
    def type(self) -> str: ...


class FillLayer(Node):

    def filterConfig(self) -> InfoObject|None: ...
    def generatorName(self) -> str: ...
    def setGenerator(self, filterName: str|None, filterConfig: InfoObject|None) -> bool: ...
    def type(self) -> str: ...


class VectorLayer(Node):

    def createGroupShape(self, name: str|None, shapes: collections.abc.Iterable[Shape]) -> Shape|None: ...
    def shapesInRect(self, rect: QtCore.QRectF, omitHiddenShapes: bool = ..., containedMode: bool = ...) -> list[Shape]: ...
    def shapeAtPosition(self, point: QtCore.QPointF|QtCore.QPoint) -> Shape|None: ...
    def addShapesFromSvg(self, svg: str|None) -> list[Shape]: ...
    def toSvg(self) -> str: ...
    def shapes(self) -> list[Shape]: ...
    def type(self) -> str: ...


class FilterMask(Node):

    def filter(self) -> Filter|None: ...
    def setFilter(self, filter: Filter) -> None: ...
    def type(self) -> str: ...


class SelectionMask(Node):

    def setSelection(self, selection: 'Selection|None') -> None: ...
    def selection(self) -> 'Selection|None': ...
    def type(self) -> str: ...


class TransparencyMask(Node):

    def setSelection(self, selection: 'Selection|None') -> None: ...
    def selection(self) -> 'Selection|None': ...
    def type(self) -> str: ...


class TransformMask(Node):

    def fromXML(self, xml: str|None) -> bool: ...
    def toXML(self) -> str: ...
    def finalAffineTransform(self) -> QtGui.QTransform: ...
    def type(self) -> str: ...


class ColorizeMask(Node):

    def setEditKeyStrokes(self, enabled: bool) -> None: ...
    def editKeyStrokes(self) -> bool: ...
    def setShowOutput(self, enabled: bool) -> None: ...
    def showOutput(self) -> bool: ...
    def resetCache(self) -> None: ...
    def updateMask(self, force: bool = ...) -> None: ...
    def limitToDeviceBounds(self) -> bool: ...
    def setLimitToDeviceBounds(self, value: bool) -> None: ...
    def cleanUpAmount(self) -> float: ...
    def setCleanUpAmount(self, value: float) -> None: ...
    def edgeDetectionSize(self) -> float: ...
    def setEdgeDetectionSize(self, value: float) -> None: ...
    def useEdgeDetection(self) -> bool: ...
    def setUseEdgeDetection(self, value: bool) -> None: ...
    def setKeyStrokePixelData(self, value: QtCore.QByteArray|bytes|bytearray, color: 'ManagedColor|None', x: int, y: int, w: int, h: int) -> bool: ...
    def keyStrokePixelData(self, color: 'ManagedColor|None', x: int, y: int, w: int, h: int) -> QtCore.QByteArray: ...
    def transparencyIndex(self) -> int: ...
    def removeKeyStroke(self, color: 'ManagedColor|None') -> None: ...
    def initializeKeyStrokeColors(self, colors: collections.abc.Iterable['ManagedColor'], transparentIndex: int = ...) -> None: ...
    def keyStrokesColors(self) -> list['ManagedColor']: ...
    def type(self) -> str: ...


class Notifier(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    configurationChanged: typing.ClassVar[QtCore.pyqtSignal]
    windowCreated: typing.ClassVar[QtCore.pyqtSignal]
    windowIsBeingCreated: typing.ClassVar[QtCore.pyqtSignal]
    viewClosed: typing.ClassVar[QtCore.pyqtSignal]
    viewCreated: typing.ClassVar[QtCore.pyqtSignal]
    imageClosed: typing.ClassVar[QtCore.pyqtSignal]
    imageSaved: typing.ClassVar[QtCore.pyqtSignal]
    imageCreated: typing.ClassVar[QtCore.pyqtSignal]
    applicationClosing: typing.ClassVar[QtCore.pyqtSignal]
    def setActive(self, value: bool) -> None: ...
    def active(self) -> bool: ...


class Resource(QtCore.QObject):

    def setImage(self, image: QtGui.QImage) -> None: ...
    def image(self) -> QtGui.QImage: ...
    def filename(self) -> str: ...
    def setName(self, value: str|None) -> None: ...
    def name(self) -> str: ...
    def type(self) -> str: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Selection(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def setPixelData(self, value: QtCore.QByteArray|bytes|bytearray, x: int, y: int, w: int, h: int) -> None: ...
    def pixelData(self, x: int, y: int, w: int, h: int) -> QtCore.QByteArray: ...
    def symmetricdifference(self, selection: 'Selection|None') -> None: ...
    def intersect(self, selection: 'Selection|None') -> None: ...
    def subtract(self, selection: 'Selection|None') -> None: ...
    def add(self, selection: 'Selection|None') -> None: ...
    def replace(self, selection: 'Selection|None') -> None: ...
    def selectAll(self, node: Node|None, value: int) -> None: ...
    def select(self, x: int, y: int, w: int, h: int, value: int) -> None: ...
    def resize(self, w: int, h: int) -> None: ...
    def invert(self) -> None: ...
    def smooth(self) -> None: ...
    def shrink(self, xRadius: int, yRadius: int, edgeLock: bool) -> None: ...
    def grow(self, xradius: int, yradius: int) -> None: ...
    def feather(self, radius: int) -> None: ...
    def border(self, xRadius: int, yRadius: int) -> None: ...
    def dilate(self) -> None: ...
    def erode(self) -> None: ...
    def paste(self, destination: Node|None, x: int, y: int) -> None: ...
    def cut(self, node: Node|None) -> None: ...
    def copy(self, node: Node|None) -> None: ...
    def contract(self, value: int) -> None: ...
    def clear(self) -> None: ...
    def move(self, x: int, y: int) -> None: ...
    def y(self) -> int: ...
    def x(self) -> int: ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    def duplicate(self) -> 'Selection|None': ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Preset(QtCore.QObject):

    def __init__(self, resource: Resource|None) -> None: ...

    def fromXML(self, xml: str|None) -> None: ...
    def toXML(self) -> str: ...


class PresetChooser(QtWidgets.QWidget):

    def __init__(self, parent: QtWidgets.QWidget|None = ...) -> None: ...

    presetClicked: typing.ClassVar[QtCore.pyqtSignal]
    presetSelected: typing.ClassVar[QtCore.pyqtSignal]
    def currentPreset(self) -> Resource|None: ...
    def setCurrentPreset(self, resource: Resource|None) -> None: ...


class Scratchpad(QtWidgets.QWidget):

    def __init__(self, view: View|None, defaultColor: QtGui.QColor|QtCore.Qt.GlobalColor, parent: QtWidgets.QWidget|None = ...) -> None: ...

    def copyScratchpadImageData(self) -> QtGui.QImage: ...
    def loadScratchpadImage(self, image: QtGui.QImage) -> None: ...
    def setFillColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor) -> None: ...
    def setMode(self, modeName: str|None) -> None: ...
    def linkCanvasZoom(self, value: bool) -> None: ...
    def setModeManually(self, value: bool) -> None: ...
    def clear(self) -> None: ...


class Palette(QtCore.QObject):

    def __init__(self, resource: Resource|None) -> None: ...

    def save(self) -> bool: ...
    def moveGroup(self, groupName: str|None, groupNameInsertBefore: str|None) -> None: ...
    def changeGroupName(self, oldGroupName: str|None, newGroupName: str|None) -> None: ...
    def removeEntry(self, index: int, groupName: str|None) -> None: ...
    def addEntry(self, entry: 'Swatch', groupName: str|None) -> None: ...
    def colorSetEntryFromGroup(self, index: int, groupName: str|None) -> 'Swatch|None': ...
    def colorSetEntryByIndex(self, index: int) -> 'Swatch|None': ...
    def colorsCountTotal(self) -> int: ...
    def removeGroup(self, name: str|None, keepColors: bool) -> None: ...
    def addGroup(self, name: str|None) -> None: ...
    def groupNames(self) -> list[str]: ...
    def setComment(self, comment: str|None) -> None: ...
    def comment(self) -> str: ...
    def setColumnCount(self, columns: int) -> None: ...
    def columnCount(self) -> int: ...
    def numberOfEntries(self) -> int: ...


class PaletteView(QtWidgets.QWidget):

    def __init__(self, parent: QtWidgets.QWidget|None = ...) -> None: ...

    entrySelectedBackGround: typing.ClassVar[QtCore.pyqtSignal]
    entrySelectedForeGround: typing.ClassVar[QtCore.pyqtSignal]
    def trySelectClosestColor(self, color: 'ManagedColor|None') -> None: ...
    def removeSelectedEntryWithDialog(self) -> bool: ...
    def addGroupWithDialog(self) -> bool: ...
    def addEntryWithDialog(self, color: 'ManagedColor|None') -> bool: ...
    def setPalette(self, palette: Palette|None) -> None: ...


class ManagedColor(QtCore.QObject):

    def __init__(self, colorModel: str|None, colorDepth: str|None, colorProfile: str|None, parent: QtCore.QObject|None = ...) -> None: ...

    def __ne__(self, other: object): ...
    def toQString(self) -> str: ...
    def fromXML(self, xml: str|None) -> None: ...
    def toXML(self) -> str: ...
    def setComponents(self, values: collections.abc.Iterable[float]) -> None: ...
    def componentsOrdered(self) -> list[float]: ...
    def components(self) -> list[float]: ...
    def setColorSpace(self, colorModel: str|None, colorDepth: str|None, colorProfile: str|None) -> bool: ...
    def setColorProfile(self, colorProfile: str|None) -> bool: ...
    def colorProfile(self) -> str: ...
    def colorModel(self) -> str: ...
    def colorDepth(self) -> str: ...
    @staticmethod
    def fromQColor(qcolor: QtGui.QColor|QtCore.Qt.GlobalColor, canvas: Canvas|None = ...) -> 'ManagedColor|None': ...
    def colorForCanvas(self, canvas: Canvas|None) -> QtGui.QColor: ...
    def __eq__(self, other: object): ...


class Swatch(PyQt5.sip.wrapper):

    def __init__(self) -> None: ...

    def isValid(self) -> bool: ...
    def setSpotColor(self, spotColor: bool) -> None: ...
    def spotColor(self) -> bool: ...
    def setColor(self, color: ManagedColor|None) -> None: ...
    def color(self) -> ManagedColor|None: ...
    def setId(self, id: str|None) -> None: ...
    def id(self) -> str: ...
    def setName(self, name: str|None) -> None: ...
    def name(self) -> str: ...


class KisCubicCurve(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'KisCubicCurve') -> None: ...

    def fromString(self, a0: str|None) -> None: ...
    def toString(self) -> str: ...
    def name(self) -> str: ...
    def setName(self, name: str|None) -> None: ...
    def isConstant(self, x: float) -> bool: ...
    def isIdentity(self) -> bool: ...
    def removePoint(self, idx: int) -> None: ...
    def addPoint(self, point: QtCore.QPointF|QtCore.QPoint) -> int: ...
    def setPoint(self, idx: int, point: QtCore.QPointF|QtCore.QPoint) -> None: ...
    def setPoints(self, points: collections.abc.Iterable[QtCore.QPointF|QtCore.QPoint]) -> None: ...
    def points(self) -> list[QtCore.QPointF]: ...
    def value(self, x: float) -> float: ...


from typing import Type


class DockWidgetFactory(DockWidgetFactoryBase):

    def __init__(self, _id: str, _dockPosition: DockWidgetFactoryBase.DockPosition, _klass: Type[DockWidget]): ...


def qDebug(text: str): ...

