%feature("docstring") OT::MarginalDistribution
"Marginal distribution.

Allows one to extract marginals of a distribution when it does not natively
support it.

Parameters
----------
distribution : :class:`~openturns.Distribution`
    The underlying distribution.
indices : sequence of int
    Marginal indices.
"

// ---------------------------------------------------------------------

%feature("docstring") OT::MarginalDistribution::setDistribution
"Accessor to the distribution.

Parameters
----------
distribution : :class:`~openturns.Distribution`
    The underlying distribution."

// ---------------------------------------------------------------------

%feature("docstring") OT::MarginalDistribution::getDistribution
"Accessor to the distribution.

Returns
-------
distribution : :class:`~openturns.Distribution`
    The underlying distribution."

// ---------------------------------------------------------------------

%feature("docstring") OT::MarginalDistribution::setIndices
"Accessor to the marginal indices.

Parameters
----------
indices : sequence of int
    Marginal indices."

// ---------------------------------------------------------------------

%feature("docstring") OT::MarginalDistribution::getIndices
"Accessor to the marginal indices.

Returns
-------
indices : :class:`~openturns.Indices`
    Marginal indices."

// ---------------------------------------------------------------------

%feature("docstring") OT::MarginalDistribution::setIntegrationAlgorithm
"Accessor to the integration algorithm used to compute the PDF.

Parameters
----------
algo : :class:`~openturns.IntegrationAlgorithm`
    The integration algorithm used to marginalize the unwanted
    components of the PDF."

// ---------------------------------------------------------------------

%feature("docstring") OT::MarginalDistribution::getIntegrationAlgorithm
"Accessor to the integration algorithm used to compute the PDF.

Returns
-------
algo : :class:`~openturns.IntegrationAlgorithm`
    The integration algorithm used to marginalize the unwanted
    components of the PDF."

// ---------------------------------------------------------------------

%feature("docstring") OT::MarginalDistribution::setUsePDF
"Accessor to the flag telling how the PDF is computed.

Parameters
----------
flag : bool
    Flag telling if the marginal PDF is computed using an integration
    of the PDF of the underlying distribution or if it is computed
    using finite differences of the underlying CDF."

// ---------------------------------------------------------------------

%feature("docstring") OT::MarginalDistribution::getUsePDF
"Accessor to the flag telling how the PDF is computed.

Returns
-------
flag : bool
    Flag telling if the marginal PDF is computed using an integration
    of the PDF of the underlying distribution or if it is computed
    using finite differences of the underlying CDF."

