%feature("docstring") OT::LinearFunction
"Linear numerical math function.

Parameters
----------
center : sequence of float
    Vector :math:`\\vect{b}`.
constant : sequence of float
    Vector :math:`\\vect{c}`.
linear : :class:`~openturns.Matrix`
    Matrix :math:`\\mat{A}`.

See also
--------
Function

Notes
-----
This implements a linear :class:`~openturns.Function` :math:`f` 
defined as :

.. math::

    f : & \\Rset^n \\rightarrow \\Rset^p  \\\\
        & \\vect{X} \\mapsto \\mat{A} ( \\vect{X} - \\vect{b} ) + \\vect{c}

where:

- :math:`\\mat{A}` is the :math:`\\Rset^p \\times \\Rset^n` matrix defined by the
  input *linear*,
- :math:`\\vect{b}` is the :math:`\\Rset^n` vector defined by the object *center*,

- :math:`\\vect{c}` is the :math:`\\Rset^p` vector defined by the object *constant*.

Examples
--------
In the next example, we create the linear function :math:`f(x) = 2x + 3` 
for any :math:`x \\in \\Rset`.

>>> import openturns as ot
>>> center = [0.0]
>>> constant = [3.0]
>>> linear = ot.Matrix([[2.0]])
>>> f = ot.LinearFunction(center, constant, linear)
>>> print(f([1.0]))
[5]

In the next example, we create the linear function :math:`f(x, y) = 2x - y + 3` 
for any :math:`x \\in \\Rset`.

>>> centerCoefficient = [0.0, 0.0]
>>> constantCoefficient = [3.0]
>>> linearCoefficient = ot.Matrix([[2.0, -1.0]])
>>> f = ot.LinearFunction(centerCoefficient, constantCoefficient, linearCoefficient)
>>> print(f([1.0, 2.0]))
[3]"
