// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BinMDF_ADriverTable_HeaderFile
#define _BinMDF_ADriverTable_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_BinMDF_ADriverTable.hxx>

#include <BinMDF_TypeADriverMap.hxx>
#include <BinMDF_TypeIdMap.hxx>
#include <MMgt_TShared.hxx>
#include <Handle_BinMDF_ADriver.hxx>
#include <Handle_Standard_Type.hxx>
#include <Standard_Integer.hxx>
class BinMDF_ADriver;
class Standard_Type;
class TColStd_IndexedMapOfTransient;
class TColStd_SequenceOfAsciiString;


//! A driver table is an object building links between
//! object types and object drivers. In the
//! translation process, a driver table is asked to
//! give a translation driver for each current object
//! to be translated.
class BinMDF_ADriverTable : public MMgt_TShared
{

public:

  
  //! Constructor
  Standard_EXPORT BinMDF_ADriverTable();
  
  //! Adds a translation driver <theDriver>.
  Standard_EXPORT   void AddDriver (const Handle(BinMDF_ADriver)& theDriver) ;
  
  //! Assigns the IDs to the drivers of the given Types.
  //! It uses indices in the map as IDs.
  //! Useful in storage procedure.
  Standard_EXPORT   void AssignIds (const TColStd_IndexedMapOfTransient& theTypes) ;
  
  //! Assigns the IDs to the drivers of the given Type Names;
  //! It uses indices in the sequence as IDs.
  //! Useful in retrieval procedure.
  Standard_EXPORT   void AssignIds (const TColStd_SequenceOfAsciiString& theTypeNames) ;
  
  //! Gets a driver <theDriver> according to <theType>.
  //! Returns Type ID if the driver was assigned an ID; 0 otherwise.
      Standard_Integer GetDriver (const Handle(Standard_Type)& theType, Handle(BinMDF_ADriver)& theDriver)  const;
  
  //! Returns a driver according to <theTypeId>.
  //! Returns null handle if a driver is not found
      Handle(BinMDF_ADriver) GetDriver (const Standard_Integer theTypeId)  const;




  DEFINE_STANDARD_RTTI(BinMDF_ADriverTable)

protected:




private: 

  
  //! Assigns the ID to the driver of the Type
      void AssignId (const Handle(Standard_Type)& theType, const Standard_Integer theId) ;

  BinMDF_TypeADriverMap myMap;
  BinMDF_TypeIdMap myMapId;


};


#include <BinMDF_ADriverTable.lxx>





#endif // _BinMDF_ADriverTable_HeaderFile
