/*
** ###################################################################
**     Processors:          RW610ETA2I
**                          RW610HNA2I
**                          RW610UKA2I
**                          RW612ETA2I
**                          RW612HNA2I
**                          RW612UKA2I
**
**     Version:             rev. 1.0, 2021-03-16
**     Build:               b240715
**
**     Abstract:
**         CMSIS Peripheral Access Layer for INPUTMUX
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2024 NXP
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2021-03-16)
**         Initial version.
**
** ###################################################################
*/

/*!
 * @file INPUTMUX.h
 * @version 1.0
 * @date 2021-03-16
 * @brief CMSIS Peripheral Access Layer for INPUTMUX
 *
 * CMSIS Peripheral Access Layer for INPUTMUX
 */

#if !defined(INPUTMUX_H_)
#define INPUTMUX_H_                              /**< Symbol preventing repeated inclusion */

#if (defined(CPU_RW610ETA2I) || defined(CPU_RW610HNA2I) || defined(CPU_RW610UKA2I))
#include "RW610_COMMON.h"
#elif (defined(CPU_RW612ETA2I) || defined(CPU_RW612HNA2I) || defined(CPU_RW612UKA2I))
#include "RW612_COMMON.h"
#else
  #error "No valid CPU defined!"
#endif

/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic push
  #else
    #pragma push
    #pragma anon_unions
  #endif
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- INPUTMUX Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup INPUTMUX_Peripheral_Access_Layer INPUTMUX Peripheral Access Layer
 * @{
 */

/** INPUTMUX - Size of Registers Arrays */
#define INPUTMUX_SCT0_IN_SEL_COUNT                7u
#define INPUTMUX_PINT_SEL_COUNT                   8u
#define INPUTMUX_DMAC0_ITRIG_SEL_COUNT            33u
#define INPUTMUX_DMAC0_OTRIG_SEL_COUNT            4u
#define INPUTMUX_DMAC1_ITRIG_SEL_COUNT            33u
#define INPUTMUX_DMAC1_OTRIG_SEL_COUNT            4u
#define INPUTMUX_CT32BIT_CAP_SEL_COUNT            4u
#define INPUTMUX_CT32BIT_CAP_SEL_CT32BITN_CAPM_SEL_COUNT 4u
#define INPUTMUX_FMEASURE_CH_SEL_COUNT            2u

/** INPUTMUX - Register Layout Typedef */
typedef struct {
  __IO uint32_t SCT0_IN_SEL[INPUTMUX_SCT0_IN_SEL_COUNT]; /**< SCT Peripheral Input Multiplexers N, array offset: 0x0, array step: 0x4 */
       uint8_t RESERVED_0[228];
  __IO uint32_t PINT_SEL[INPUTMUX_PINT_SEL_COUNT]; /**< GPIO Pin Input Multiplexer N, array offset: 0x100, array step: 0x4 */
       uint8_t RESERVED_1[224];
  __IO uint32_t DMAC0_ITRIG_SEL[INPUTMUX_DMAC0_ITRIG_SEL_COUNT]; /**< DMAC0 Input Trigger Multiplexers N, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_2[124];
  __IO uint32_t DMAC0_OTRIG_SEL[INPUTMUX_DMAC0_OTRIG_SEL_COUNT]; /**< DMAC0 Output Trigger Multiplexers N, array offset: 0x300, array step: 0x4 */
       uint8_t RESERVED_3[240];
  __IO uint32_t DMAC1_ITRIG_SEL[INPUTMUX_DMAC1_ITRIG_SEL_COUNT]; /**< DMAC1 Input Trigger Multiplexers N, array offset: 0x400, array step: 0x4 */
       uint8_t RESERVED_4[124];
  __IO uint32_t DMAC1_OTRIG_SEL[INPUTMUX_DMAC1_OTRIG_SEL_COUNT]; /**< DMAC1 Output Trigger Multiplexers N, array offset: 0x500, array step: 0x4 */
       uint8_t RESERVED_5[240];
  __IO uint32_t CT32BIT_CAP_SEL[INPUTMUX_CT32BIT_CAP_SEL_COUNT][INPUTMUX_CT32BIT_CAP_SEL_CT32BITN_CAPM_SEL_COUNT]; /**< CT32BIT N Counter Timer Capture Trigger Multiplexers M, array offset: 0x600, array step: index*0x10, index2*0x4 */
       uint8_t RESERVED_6[192];
  __IO uint32_t FMEASURE_CH_SEL[INPUTMUX_FMEASURE_CH_SEL_COUNT]; /**< Frequency Measurement Input Channel Multiplexers, array offset: 0x700, array step: 0x4 */
       uint8_t RESERVED_7[56];
  __IO uint32_t DMAC0_REQ_ENA0;                    /**< DMAC0 request enable 0, offset: 0x740 */
       uint8_t RESERVED_8[4];
  __O  uint32_t DMAC0_REQ_ENA0_SET;                /**< DMAC0 request enable set 0, offset: 0x748 */
       uint8_t RESERVED_9[4];
  __O  uint32_t DMAC0_REQ_ENA0_CLR;                /**< DMAC0 request enable clear 0, offset: 0x750 */
       uint8_t RESERVED_10[12];
  __IO uint32_t DMAC1_REQ_ENA0;                    /**< DMAC1 request enable 0, offset: 0x760 */
       uint8_t RESERVED_11[4];
  __O  uint32_t DMAC1_REQ_ENA0_SET;                /**< DMAC1 request enable set 0, offset: 0x768 */
       uint8_t RESERVED_12[4];
  __O  uint32_t DMAC1_REQ_ENA0_CLR;                /**< DMAC1 request enable clear 0, offset: 0x770 */
       uint8_t RESERVED_13[12];
  __IO uint32_t DMAC0_ITRIG_ENA0;                  /**< DMAC0 input trigger enable 0, offset: 0x780 */
  __IO uint32_t DMAC0_ITRIG_ENA1;                  /**< DMAC0 input trigger enable 1, offset: 0x784 */
  __O  uint32_t DMAC0_ITRIG_ENA0_SET;              /**< DMAC0 input trigger enable set 0, offset: 0x788 */
  __O  uint32_t DMAC0_ITRIG_ENA1_SET;              /**< DMAC0 input trigger enable set 1, offset: 0x78C */
  __O  uint32_t DMAC0_ITRIG_ENA0_CLR;              /**< DMAC0 input trigger enable clear 0, offset: 0x790 */
  __O  uint32_t DMAC0_ITRIG_ENA1_CLR;              /**< DMAC0 input trigger enable clear 1, offset: 0x794 */
       uint8_t RESERVED_14[8];
  __IO uint32_t DMAC1_ITRIG_ENA0;                  /**< DMAC1 input trigger enable 0, offset: 0x7A0 */
  __IO uint32_t DMAC1_ITRIG_ENA1;                  /**< DMAC1 input trigger enable 1, offset: 0x7A4 */
  __O  uint32_t DMAC1_ITRIG_ENA0_SET;              /**< DMAC1 input trigger enable set 0, offset: 0x7A8 */
  __O  uint32_t DMAC1_ITRIG_ENA1_SET;              /**< DMAC1 input trigger enable set 1, offset: 0x7AC */
  __O  uint32_t DMAC1_ITRIG_ENA0_CLR;              /**< DMAC1 input trigger enable clear 0, offset: 0x7B0 */
  __O  uint32_t DMAC1_ITRIG_ENA1_CLR;              /**< DMAC1 input trigger enable clear 1, offset: 0x7B4 */
} INPUTMUX_Type;

/* ----------------------------------------------------------------------------
   -- INPUTMUX Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup INPUTMUX_Register_Masks INPUTMUX Register Masks
 * @{
 */

/*! @name SCT0_IN_SEL - SCT Peripheral Input Multiplexers N */
/*! @{ */

#define INPUTMUX_SCT0_IN_SEL_SCT_IN_SEL_MASK     (0x1FU)
#define INPUTMUX_SCT0_IN_SEL_SCT_IN_SEL_SHIFT    (0U)
/*! SCT_IN_SEL - SCT0 Input(n) Selection. 24:1 Selection for each. . .
 *  0b00000..SCT0_PIN_INP0
 *  0b00001..SCT0_PIN_INP1
 *  0b00010..SCT0_PIN_INP2
 *  0b00011..SCT0_PIN_INP3
 *  0b00100..SCT0_PIN_INP4
 *  0b00101..SCT0_PIN_INP5
 *  0b00110..SCT0_PIN_INP6
 *  0b00111..SCT0_PIN_INP7
 *  0b01000..CT32BIT0_MAT0
 *  0b01001..CT32BIT1_MAT0
 *  0b01010..CT32BIT2_MAT0
 *  0b01011..CT32BIT3_MAT0
 *  0b01100..RESERVED
 *  0b01101..RESERVED
 *  0b01110..GPIOINT_BMATCH
 *  0b01111..NOT_CONNECTED
 *  0b10000..NOT_CONNECTED
 *  0b10001..SHARED I2S0_SCLK
 *  0b10010..SHARED I2S1_SCLK
 *  0b10011..SHARED I2S0_WS
 *  0b10100..SHARED I2S1_WS
 *  0b10101..MCLK
 *  0b10110..ARM_TXEV
 *  0b10111..DEBUG_HALTED
 *  0b11000..RESERVED
 *  0b11001..RESERVED
 *  0b11010..RESERVED
 *  0b11011..RESERVED
 *  0b11100..RESERVED
 *  0b11101..RESERVED
 *  0b11110..RESERVED
 *  0b11111..RESERVED
 */
#define INPUTMUX_SCT0_IN_SEL_SCT_IN_SEL(x)       (((uint32_t)(((uint32_t)(x)) << INPUTMUX_SCT0_IN_SEL_SCT_IN_SEL_SHIFT)) & INPUTMUX_SCT0_IN_SEL_SCT_IN_SEL_MASK)
/*! @} */

/*! @name PINT_SEL - GPIO Pin Input Multiplexer N */
/*! @{ */

#define INPUTMUX_PINT_SEL_PINT_SEL_MASK          (0xFFU)
#define INPUTMUX_PINT_SEL_PINT_SEL_SHIFT         (0U)
/*! PINT_SEL - Port Input (PIOx.y) 64 to 8 Mux Select. . . Pin number select for pin interrupt or
 *    pattern match engine input. (For PIOx_y: INTPIN = (x * 32) + y. PIO0_0 to PIO1_31 correspond to
 *    numbers 0 to 63.
 */
#define INPUTMUX_PINT_SEL_PINT_SEL(x)            (((uint32_t)(((uint32_t)(x)) << INPUTMUX_PINT_SEL_PINT_SEL_SHIFT)) & INPUTMUX_PINT_SEL_PINT_SEL_MASK)
/*! @} */

/*! @name DMAC0_ITRIG_SEL - DMAC0 Input Trigger Multiplexers N */
/*! @{ */

#define INPUTMUX_DMAC0_ITRIG_SEL_DMA0_ITRIG_SEL_MASK (0x3FU)
#define INPUTMUX_DMAC0_ITRIG_SEL_DMA0_ITRIG_SEL_SHIFT (0U)
/*! DMA0_ITRIG_SEL - DMA Input Triggers(n) Selection. 22:1 Selection for each. . .
 *  0b000000..NSGPIOPINT0_INT0
 *  0b000001..NSGPIOPINT0_INT1
 *  0b000010..NSGPIOPINT0_INT2
 *  0b000011..NSGPIOPINT0_INT3
 *  0b000100..CT32BIT0_DMAREQ_M0
 *  0b000101..CT32BIT0_DMAREQ_M1
 *  0b000110..CT32BIT1_DMAREQ_M0
 *  0b000111..CT32BIT1_DMAREQ_M1
 *  0b001000..CT32BIT2_DMAREQ_M0
 *  0b001001..CT32BIT2_DMAREQ_M1
 *  0b001010..CT32BIT3_DMAREQ_M0
 *  0b001011..CT32BIT3_DMAREQ_M1
 *  0b001100..RESERVED
 *  0b001101..RESERVED
 *  0b001110..DMAC0_TRIGOUT_A
 *  0b001111..DMAC0_TRIGOUT_B
 *  0b010000..DMAC0_TRIGOUT_C
 *  0b010001..DMAC0_TRIGOUT_D
 *  0b010010..SCT0_DMA0
 *  0b010011..SCT0_DMA1
 *  0b010100..ENET_MAC0_DMA_REQ0
 *  0b010101..ENET_MAC0_DMA_REQ1
 *  0b010110..USIM_DMA_RX_SINGLE
 *  0b010111..USIM_DMA_TX_SINGLE
 *  0b011000..GAU_GPADC0_DMA_SINGLE
 *  0b011001..GAU_GPADC1_DMA_SINGLE
 *  0b011010..GAU_GPADCA_DMA_REQ
 *  0b011011..GAU_GPADCB_DMA_REQ
 *  0b011100..FLEXSPI_RX
 *  0b011101..FLEXSPI_TX
 *  0b011110..RESERVED
 *  0b011111..RESERVED
 *  0b100000..LCD_RX_REQ_TO_DMA_SINGLE
 *  0b100001..LCD_TX_REQ_TO_DMA_SINGLE
 *  0b100010..RESERVED
 *  0b100011..RESERVED
 *  0b100100..RESERVED
 *  0b100101..RESERVED
 *  0b100110..RESERVED
 *  0b100111..RESERVED
 *  0b101000..RESERVED
 *  0b101001..RESERVED
 *  0b101010..RESERVED
 *  0b101011..RESERVED
 *  0b101100..RESERVED
 *  0b101101..RESERVED
 *  0b101110..RESERVED
 *  0b101111..RESERVED
 *  0b110000..RESERVED
 *  0b110001..RESERVED
 *  0b110010..RESERVED
 *  0b110011..RESERVED
 *  0b110100..RESERVED
 *  0b110101..RESERVED
 *  0b110110..RESERVED
 *  0b110111..RESERVED
 *  0b111000..RESERVED
 *  0b111001..RESERVED
 *  0b111010..RESERVED
 *  0b111011..RESERVED
 *  0b111100..RESERVED
 *  0b111101..RESERVED
 *  0b111110..RESERVED
 *  0b111111..RESERVED
 */
#define INPUTMUX_DMAC0_ITRIG_SEL_DMA0_ITRIG_SEL(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_SEL_DMA0_ITRIG_SEL_SHIFT)) & INPUTMUX_DMAC0_ITRIG_SEL_DMA0_ITRIG_SEL_MASK)
/*! @} */

/*! @name DMAC0_OTRIG_SEL - DMAC0 Output Trigger Multiplexers N */
/*! @{ */

#define INPUTMUX_DMAC0_OTRIG_SEL_DMAC0_OTRIG_SEL_MASK (0x3FU)
#define INPUTMUX_DMAC0_OTRIG_SEL_DMAC0_OTRIG_SEL_SHIFT (0U)
/*! DMAC0_OTRIG_SEL - DMAC0 Output Triggers Select for A, B, C, D IE.,DMAC0_OTRIG_A, DMAC0_OTRIG_B,
 *    DMAC0_OTRIG_C, DMAC0_OTRIG_D DMA0 Output Triggers(n) Selection. 32:1 Selection for each. . .
 *  0b000000..DMAC0_OTRIG_CH0
 *  0b000001..DMAC0_OTRIG_CH1
 *  0b000010..DMAC0_OTRIG_CH2
 *  0b000011..DMAC0_OTRIG_CH3
 *  0b000100..DMAC0_OTRIG_CH4
 *  0b000101..DMAC0_OTRIG_CH5
 *  0b000110..DMAC0_OTRIG_CH6
 *  0b000111..DMAC0_OTRIG_CH7
 *  0b001000..DMAC0_OTRIG_CH8
 *  0b001001..DMAC0_OTRIG_CH9
 *  0b001010..DMAC0_OTRIG_CH10
 *  0b001011..DMAC0_OTRIG_CH11
 *  0b001100..DMAC0_OTRIG_CH12
 *  0b001101..DMAC0_OTRIG_CH13
 *  0b001110..DMAC0_OTRIG_CH14
 *  0b001111..DMAC0_OTRIG_CH15
 *  0b010000..DMAC0_OTRIG_CH16
 *  0b010001..DMAC0_OTRIG_CH17
 *  0b010010..DMAC0_OTRIG_CH18
 *  0b010011..DMAC0_OTRIG_CH19
 *  0b010100..DMAC0_OTRIG_CH20
 *  0b010101..DMAC0_OTRIG_CH21
 *  0b010110..DMAC0_OTRIG_CH22
 *  0b010111..DMAC0_OTRIG_CH23
 *  0b011000..DMAC0_OTRIG_CH24
 *  0b011001..DMAC0_OTRIG_CH25
 *  0b011010..DMAC0_OTRIG_CH26
 *  0b011011..DMAC0_OTRIG_CH27
 *  0b011100..DMAC0_OTRIG_CH28
 *  0b011101..DMAC0_OTRIG_CH29
 *  0b011110..DMAC0_OTRIG_CH30
 *  0b011111..DMAC0_OTRIG_CH31
 *  0b100000..DMAC0_OTRIG_CH32
 */
#define INPUTMUX_DMAC0_OTRIG_SEL_DMAC0_OTRIG_SEL(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_OTRIG_SEL_DMAC0_OTRIG_SEL_SHIFT)) & INPUTMUX_DMAC0_OTRIG_SEL_DMAC0_OTRIG_SEL_MASK)
/*! @} */

/*! @name DMAC1_ITRIG_SEL - DMAC1 Input Trigger Multiplexers N */
/*! @{ */

#define INPUTMUX_DMAC1_ITRIG_SEL_DMA1_ITRIG_SEL_MASK (0x3FU)
#define INPUTMUX_DMAC1_ITRIG_SEL_DMA1_ITRIG_SEL_SHIFT (0U)
/*! DMA1_ITRIG_SEL - DMA Input Triggers(n) Selection. 18:1 Selection for each. . .
 *  0b000000..NSGPIOPINT0_INT0
 *  0b000001..NSGPIOPINT0_INT1
 *  0b000010..NSGPIOPINT0_INT2
 *  0b000011..NSGPIOPINT0_INT3
 *  0b000100..CT32BIT0_DMAREQ_M0
 *  0b000101..CT32BIT0_DMAREQ_M1
 *  0b000110..CT32BIT1_DMAREQ_M0
 *  0b000111..CT32BIT1_DMAREQ_M1
 *  0b001000..CT32BIT2_DMAREQ_M0
 *  0b001001..CT32BIT2_DMAREQ_M1
 *  0b001010..CT32BIT3_DMAREQ_M0
 *  0b001011..CT32BIT3_DMAREQ_M1
 *  0b001100..RESERVED
 *  0b001101..RESERVED
 *  0b001110..DMAC1_TRIGOUT_A
 *  0b001111..DMAC1_TRIGOUT_B
 *  0b010000..DMAC1_TRIGOUT_C
 *  0b010001..DMAC1_TRIGOUT_D
 *  0b010010..SCT0_DMAC0
 *  0b010011..SCT0_DMAC1
 *  0b010100..ENET_MAC0_DMA_REQ0
 *  0b010101..ENET_MAC0_DMA_REQ1
 *  0b010110..USIM_DMA_RX_SINGLE
 *  0b010111..USIM_DMA_TX_SINGLE
 *  0b011000..GAU_GPADC0_DMA_SINGLE
 *  0b011001..GAU_GPADC1_DMA_SINGLE
 *  0b011010..RESERVED
 *  0b011011..RESERVED
 *  0b011100..FLEXSPI_RX
 *  0b011101..FLEXSPI_TX
 *  0b011110..RESERVED
 *  0b011111..RESERVED
 *  0b100000..LCD_RX_REQ_TO_DMA_SINGLE
 *  0b100001..LCD_TX_REQ_TO_DMA_SINGLE
 *  0b100010..RESERVED
 *  0b100011..RESERVED
 *  0b100100..RESERVED
 *  0b100101..RESERVED
 *  0b100110..RESERVED
 *  0b100111..RESERVED
 *  0b101000..RESERVED
 *  0b101001..RESERVED
 *  0b101010..RESERVED
 *  0b101011..RESERVED
 *  0b101100..RESERVED
 *  0b101101..RESERVED
 *  0b101110..RESERVED
 *  0b101111..RESERVED
 *  0b110000..RESERVED
 *  0b110001..RESERVED
 *  0b110010..RESERVED
 *  0b110011..RESERVED
 *  0b110100..RESERVED
 *  0b110101..RESERVED
 *  0b110110..RESERVED
 *  0b110111..RESERVED
 *  0b111000..RESERVED
 *  0b111001..RESERVED
 *  0b111010..RESERVED
 *  0b111011..RESERVED
 *  0b111100..RESERVED
 *  0b111101..RESERVED
 *  0b111110..RESERVED
 *  0b111111..RESERVED
 */
#define INPUTMUX_DMAC1_ITRIG_SEL_DMA1_ITRIG_SEL(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_SEL_DMA1_ITRIG_SEL_SHIFT)) & INPUTMUX_DMAC1_ITRIG_SEL_DMA1_ITRIG_SEL_MASK)
/*! @} */

/*! @name DMAC1_OTRIG_SEL - DMAC1 Output Trigger Multiplexers N */
/*! @{ */

#define INPUTMUX_DMAC1_OTRIG_SEL_DMA1_OTRIG_SEL_MASK (0x3FU)
#define INPUTMUX_DMAC1_OTRIG_SEL_DMA1_OTRIG_SEL_SHIFT (0U)
/*! DMA1_OTRIG_SEL - DMA1 Output Triggers Select for A, B, C, D IE., DMA1_OTRIG_A, DMA1_OTRIG_B,
 *    DM1_OTRIG_C, DMA1_OTRIG_D DMA0 Output Triggers(n) Selection. 32:1 Selection for each. . .
 *  0b000000..DMAC1_OTRIG_CH0
 *  0b000001..DMAC1_OTRIG_CH1
 *  0b000010..DMAC1_OTRIG_CH2
 *  0b000011..DMAC1_OTRIG_CH3
 *  0b000100..DMAC1_OTRIG_CH4
 *  0b000101..DMAC1_OTRIG_CH5
 *  0b000110..DMAC1_OTRIG_CH6
 *  0b000111..DMAC1_OTRIG_CH7
 *  0b001000..DMAC1_OTRIG_CH8
 *  0b001001..DMAC1_OTRIG_CH9
 *  0b001010..DMAC1_OTRIG_CH10
 *  0b001011..DMAC1_OTRIG_CH11
 *  0b001100..DMAC1_OTRIG_CH12
 *  0b001101..DMAC1_OTRIG_CH13
 *  0b001110..DMAC1_OTRIG_CH14
 *  0b001111..DMAC1_OTRIG_CH15
 *  0b010000..DMAC1_OTRIG_CH16
 *  0b010001..DMAC1_OTRIG_CH17
 *  0b010010..DMAC1_OTRIG_CH18
 *  0b010011..DMAC1_OTRIG_CH19
 *  0b010100..DMAC1_OTRIG_CH20
 *  0b010101..DMAC1_OTRIG_CH21
 *  0b010110..DMAC1_OTRIG_CH22
 *  0b010111..DMAC1_OTRIG_CH23
 *  0b011000..DMAC1_OTRIG_CH24
 *  0b011001..DMAC1_OTRIG_CH25
 *  0b011010..DMAC1_OTRIG_CH26
 *  0b011011..DMAC1_OTRIG_CH27
 *  0b011100..DMAC1_OTRIG_CH28
 *  0b011101..DMAC1_OTRIG_CH29
 *  0b011110..DMAC1_OTRIG_CH30
 *  0b011111..DMAC1_OTRIG_CH31
 *  0b100000..DMAC1_OTRIG_CH32
 */
#define INPUTMUX_DMAC1_OTRIG_SEL_DMA1_OTRIG_SEL(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_OTRIG_SEL_DMA1_OTRIG_SEL_SHIFT)) & INPUTMUX_DMAC1_OTRIG_SEL_DMA1_OTRIG_SEL_MASK)
/*! @} */

/*! @name CT32BIT_CAP_SEL - CT32BIT N Counter Timer Capture Trigger Multiplexers M */
/*! @{ */

#define INPUTMUX_CT32BIT_CAP_SEL_CAPN_SEL_MASK   (0x1FU)
#define INPUTMUX_CT32BIT_CAP_SEL_CAPN_SEL_SHIFT  (0U)
/*! CAPN_SEL - Counter Timer m, Capture Port Input n 19:1 Mux Select. . .
 *  0b00000..CT_INP0
 *  0b00001..CT_INP1
 *  0b00010..CT_INP2
 *  0b00011..CT_INP3
 *  0b00100..CT_INP4
 *  0b00101..CT_INP5
 *  0b00110..CT_INP6
 *  0b00111..CT_INP7
 *  0b01000..CT_INP8
 *  0b01001..CT_INP9
 *  0b01010..CT_INP10
 *  0b01011..CT_INP11
 *  0b01100..CT_INP12
 *  0b01101..CT_INP13
 *  0b01110..CT_INP14
 *  0b01111..RESERVED
 *  0b10000..SHARED I2S0_WS
 *  0b10001..SHARED I2S1_WS
 *  0b10010..ENET(only for timer1)
 *  0b10011..BTU_HOST_TRIGGER_0
 *  0b10100..BTU_HOST_TRIGGER_1
 *  0b10101..BTU_HOST_TRIGGER_2
 *  0b10110..FLEXCOMM_DMA_DONE0(only for timer0 and timer2)
 *  0b10111..FLEXCOMM_DMA_DONE1(only for timer0 and timer2)
 *  0b11000..FLEXCOMM_DMA_CMPLT_DONE0(only for timer0 and timer2)
 *  0b11001..FLEXCOMM_DMA_CMPLT_DONE1(only for timer0 and timer2)
 *  0b11010..RESERVED
 *  0b11011..RESERVED
 *  0b11100..RESERVED
 *  0b11101..RESERVED
 *  0b11110..RESERVED
 *  0b11111..RESERVED
 */
#define INPUTMUX_CT32BIT_CAP_SEL_CAPN_SEL(x)     (((uint32_t)(((uint32_t)(x)) << INPUTMUX_CT32BIT_CAP_SEL_CAPN_SEL_SHIFT)) & INPUTMUX_CT32BIT_CAP_SEL_CAPN_SEL_MASK)
/*! @} */

/* The count of INPUTMUX_CT32BIT_CAP_SEL */
#define INPUTMUX_CT32BIT_CAP_SEL_COUNT2          (4U)

/*! @name FMEASURE_CH_SEL - Frequency Measurement Input Channel Multiplexers */
/*! @{ */

#define INPUTMUX_FMEASURE_CH_SEL_FMEASURE_SEL_MASK (0x1FU)
#define INPUTMUX_FMEASURE_CH_SEL_FMEASURE_SEL_SHIFT (0U)
/*! FMEASURE_SEL - Frequency Measure Channel n Selection 7:1 Mux Select. . .
 *  0b00000..SYSOSC Clock
 *  0b00001..SFRO
 *  0b00010..FFRO
 *  0b00011..Low Power Oscillator Clock (LPOSC)
 *  0b00100..XTAL32K
 *  0b00101..c0_fr_hclk
 *  0b00110..FREQME_GPIO_CLK_IN
 *  0b00111..T3PLL_MCU_FLEXSPI_CLK
 *  0b01000..TDDR_MCU_FLEXSPI_CLK
 *  0b01001..TDDR_MCU_ENET_CLK
 *  0b01010..TCPU_MCU_FLEXSPI_CLK
 *  0b10010..NCO_32K
 *  0b10011..PMU_FCLK
 *  0b10100..OSC32K_CLK_1HZ
 *  0b10101..OSC32K_CLK_1KHZ
 *  0b10110..LCD_FCLK
 *  0b10111..FLEXCOMM0_FCLK
 *  0b11000..DMIC_FCLK
 *  0b11001..FLEXSPI0_FCLK
 *  0b11010..TCPU_MCU_CLK
 *  0b11011..AVPLL_CH2_CLKOUT(64M)
 *  0b11100..RESERVED
 *  0b11101..RESERVED
 *  0b11110..RESERVED
 *  0b11111..RESERVED
 */
#define INPUTMUX_FMEASURE_CH_SEL_FMEASURE_SEL(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FMEASURE_CH_SEL_FMEASURE_SEL_SHIFT)) & INPUTMUX_FMEASURE_CH_SEL_FMEASURE_SEL_MASK)
/*! @} */

/*! @name DMAC0_REQ_ENA0 - DMAC0 request enable 0 */
/*! @{ */

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_RX_MASK (0x1U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_RX_SHIFT (0U)
/*! FLEXCOMM0_RX - FLEXCOMM0 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_TX_MASK (0x2U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_TX_SHIFT (1U)
/*! FLEXCOMM0_TX - FLEXCOMM0 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_RX_MASK (0x4U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_RX_SHIFT (2U)
/*! FLEXCOMM1_RX - FLEXCOMM1 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_TX_MASK (0x8U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_TX_SHIFT (3U)
/*! FLEXCOMM1_TX - FLEXCOMM1 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_RX_MASK (0x10U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_RX_SHIFT (4U)
/*! FLEXCOMM2_RX - FLEXCOMM2 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_TX_MASK (0x20U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_TX_SHIFT (5U)
/*! FLEXCOMM2_TX - FLEXCOMM2 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_RX_MASK (0x40U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_RX_SHIFT (6U)
/*! FLEXCOMM3_RX - FLEXCOMM3 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_TX_MASK (0x80U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_TX_SHIFT (7U)
/*! FLEXCOMM3_TX - FLEXCOMM3 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH0_MASK    (0x10000U)
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH0_SHIFT   (16U)
/*! DMIC0CH0 - DMIC0 channel 0 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH0(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH0_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH0_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH1_MASK    (0x20000U)
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH1_SHIFT   (17U)
/*! DMIC0CH1 - DMIC0 channel 1 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH1(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH1_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH1_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH2_MASK    (0x40000U)
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH2_SHIFT   (18U)
/*! DMIC0CH2 - DMIC0 channel 2 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH2(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH2_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH2_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH3_MASK    (0x80000U)
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH3_SHIFT   (19U)
/*! DMIC0CH3 - DMIC0 channel 3 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH3(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH3_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH3_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_RX_MASK (0x4000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_RX_SHIFT (26U)
/*! FLEXCOMM14_RX - FLEXCOMM14 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_TX_MASK (0x8000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_TX_SHIFT (27U)
/*! FLEXCOMM14_TX - FLEXCOMM14 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_TX_MASK)
/*! @} */

/*! @name DMAC0_REQ_ENA0_SET - DMAC0 request enable set 0 */
/*! @{ */

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_RX_MASK (0x1U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_RX_SHIFT (0U)
/*! FLEXCOMM0_RX - FLEXCOMM0 RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_TX_MASK (0x2U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_TX_SHIFT (1U)
/*! FLEXCOMM0_TX - FLEXCOMM0 TX enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_RX_MASK (0x4U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_RX_SHIFT (2U)
/*! FLEXCOMM1_RX - FLEXCOMM1 RX enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_TX_MASK (0x8U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_TX_SHIFT (3U)
/*! FLEXCOMM1_TX - FLEXCOMM1 TX enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_RX_MASK (0x10U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_RX_SHIFT (4U)
/*! FLEXCOMM2_RX - FLEXCOMM2 RX enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_TX_MASK (0x20U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_TX_SHIFT (5U)
/*! FLEXCOMM2_TX - FLEXCOMM2 TX enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_RX_MASK (0x40U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_RX_SHIFT (6U)
/*! FLEXCOMM3_RX - FLEXCOMM3 RX enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_TX_MASK (0x80U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_TX_SHIFT (7U)
/*! FLEXCOMM3_TX - FLEXCOMM3 TX enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH0_MASK (0x10000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH0_SHIFT (16U)
/*! DMIC0CH0 - DMIC0 channel 0 enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH0(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH0_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH0_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH1_MASK (0x20000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH1_SHIFT (17U)
/*! DMIC0CH1 - DMIC0 channel 1 enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH1(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH1_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH1_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH2_MASK (0x40000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH2_SHIFT (18U)
/*! DMIC0CH2 - DMIC0 channel 2 enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH2(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH2_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH2_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH3_MASK (0x80000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH3_SHIFT (19U)
/*! DMIC0CH3 - DMIC0 channel 3 enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH3(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH3_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH3_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_RX_MASK (0x4000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_RX_SHIFT (26U)
/*! FLEXCOMM14_RX - FLEXCOMM14 RX enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_TX_MASK (0x8000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_TX_SHIFT (27U)
/*! FLEXCOMM14_TX - FLEXCOMM14 TX enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_TX_MASK)
/*! @} */

/*! @name DMAC0_REQ_ENA0_CLR - DMAC0 request enable clear 0 */
/*! @{ */

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_RX_MASK (0x1U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_RX_SHIFT (0U)
/*! FLEXCOMM0_RX - FLEXCOMM0 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_TX_MASK (0x2U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_TX_SHIFT (1U)
/*! FLEXCOMM0_TX - FLEXCOMM0 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_RX_MASK (0x4U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_RX_SHIFT (2U)
/*! FLEXCOMM1_RX - FLEXCOMM1 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_TX_MASK (0x8U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_TX_SHIFT (3U)
/*! FLEXCOMM1_TX - FLEXCOMM1 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_RX_MASK (0x10U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_RX_SHIFT (4U)
/*! FLEXCOMM2_RX - FLEXCOMM2 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_TX_MASK (0x20U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_TX_SHIFT (5U)
/*! FLEXCOMM2_TX - FLEXCOMM2 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_RX_MASK (0x40U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_RX_SHIFT (6U)
/*! FLEXCOMM3_RX - FLEXCOMM3 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_TX_MASK (0x80U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_TX_SHIFT (7U)
/*! FLEXCOMM3_TX - FLEXCOMM3 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH0_MASK (0x10000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH0_SHIFT (16U)
/*! DMIC0CH0 - DMIC0 channel 0 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH0(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH0_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH0_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH1_MASK (0x20000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH1_SHIFT (17U)
/*! DMIC0CH1 - DMIC0 channel 1 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH1(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH1_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH1_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH2_MASK (0x40000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH2_SHIFT (18U)
/*! DMIC0CH2 - DMIC0 channel 2 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH2(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH2_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH2_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH3_MASK (0x80000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH3_SHIFT (19U)
/*! DMIC0CH3 - DMIC0 channel 3 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH3(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH3_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH3_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_RX_MASK (0x4000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_RX_SHIFT (26U)
/*! FLEXCOMM14_RX - FLEXCOMM14 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_TX_MASK (0x8000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_TX_SHIFT (27U)
/*! FLEXCOMM14_TX - FLEXCOMM14 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_TX_MASK)
/*! @} */

/*! @name DMAC1_REQ_ENA0 - DMAC1 request enable 0 */
/*! @{ */

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_RX_MASK (0x1U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_RX_SHIFT (0U)
/*! FLEXCOMM0_RX - FLEXCOMM0 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_TX_MASK (0x2U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_TX_SHIFT (1U)
/*! FLEXCOMM0_TX - FLEXCOMM0 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_RX_MASK (0x4U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_RX_SHIFT (2U)
/*! FLEXCOMM1_RX - FLEXCOMM1 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_TX_MASK (0x8U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_TX_SHIFT (3U)
/*! FLEXCOMM1_TX - FLEXCOMM1 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_RX_MASK (0x10U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_RX_SHIFT (4U)
/*! FLEXCOMM2_RX - FLEXCOMM2 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_TX_MASK (0x20U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_TX_SHIFT (5U)
/*! FLEXCOMM2_TX - FLEXCOMM2 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_RX_MASK (0x40U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_RX_SHIFT (6U)
/*! FLEXCOMM3_RX - FLEXCOMM3 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_TX_MASK (0x80U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_TX_SHIFT (7U)
/*! FLEXCOMM3_TX - FLEXCOMM3 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH0_MASK    (0x10000U)
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH0_SHIFT   (16U)
/*! DMIC0CH0 - DMIC0 channel 0 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH0(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH0_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH0_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH1_MASK    (0x20000U)
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH1_SHIFT   (17U)
/*! DMIC0CH1 - DMIC0 channel 1 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH1(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH1_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH1_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH2_MASK    (0x40000U)
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH2_SHIFT   (18U)
/*! DMIC0CH2 - DMIC0 channel 2 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH2(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH2_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH2_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH3_MASK    (0x80000U)
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH3_SHIFT   (19U)
/*! DMIC0CH3 - DMIC0 channel 3 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH3(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH3_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH3_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_RX_MASK (0x4000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_RX_SHIFT (26U)
/*! FLEXCOMM14_RX - FLEXCOMM14 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_TX_MASK (0x8000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_TX_SHIFT (27U)
/*! FLEXCOMM14_TX - FLEXCOMM14 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_TX_MASK)
/*! @} */

/*! @name DMAC1_REQ_ENA0_SET - DMAC1 request enable set 0 */
/*! @{ */

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_RX_MASK (0x1U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_RX_SHIFT (0U)
/*! FLEXCOMM0_RX - FLEXCOMM0 RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_TX_MASK (0x2U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_TX_SHIFT (1U)
/*! FLEXCOMM0_TX - FLEXCOMM0 TX enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_RX_MASK (0x4U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_RX_SHIFT (2U)
/*! FLEXCOMM1_RX - FLEXCOMM1 RX enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_TX_MASK (0x8U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_TX_SHIFT (3U)
/*! FLEXCOMM1_TX - FLEXCOMM1 TX enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_RX_MASK (0x10U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_RX_SHIFT (4U)
/*! FLEXCOMM2_RX - FLEXCOMM2 RX enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_TX_MASK (0x20U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_TX_SHIFT (5U)
/*! FLEXCOMM2_TX - FLEXCOMM2 TX enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_RX_MASK (0x40U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_RX_SHIFT (6U)
/*! FLEXCOMM3_RX - FLEXCOMM3 RX enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_TX_MASK (0x80U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_TX_SHIFT (7U)
/*! FLEXCOMM3_TX - FLEXCOMM3 TX enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH0_MASK (0x10000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH0_SHIFT (16U)
/*! DMIC0CH0 - DMIC0 channel 0 enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH0(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH0_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH0_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH1_MASK (0x20000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH1_SHIFT (17U)
/*! DMIC0CH1 - DMIC0 channel 1 enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH1(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH1_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH1_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH2_MASK (0x40000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH2_SHIFT (18U)
/*! DMIC0CH2 - DMIC0 channel 2 enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH2(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH2_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH2_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH3_MASK (0x80000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH3_SHIFT (19U)
/*! DMIC0CH3 - DMIC0 channel 3 enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH3(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH3_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH3_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_RX_MASK (0x4000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_RX_SHIFT (26U)
/*! FLEXCOMM14_RX - FLEXCOMM14 RX enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_TX_MASK (0x8000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_TX_SHIFT (27U)
/*! FLEXCOMM14_TX - FLEXCOMM14 TX enable
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_TX_MASK)
/*! @} */

/*! @name DMAC1_REQ_ENA0_CLR - DMAC1 request enable clear 0 */
/*! @{ */

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_RX_MASK (0x1U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_RX_SHIFT (0U)
/*! FLEXCOMM0_RX - FLEXCOMM0 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_TX_MASK (0x2U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_TX_SHIFT (1U)
/*! FLEXCOMM0_TX - FLEXCOMM0 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_RX_MASK (0x4U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_RX_SHIFT (2U)
/*! FLEXCOMM1_RX - FLEXCOMM1 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_TX_MASK (0x8U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_TX_SHIFT (3U)
/*! FLEXCOMM1_TX - FLEXCOMM1 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_RX_MASK (0x10U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_RX_SHIFT (4U)
/*! FLEXCOMM2_RX - FLEXCOMM2 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_TX_MASK (0x20U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_TX_SHIFT (5U)
/*! FLEXCOMM2_TX - FLEXCOMM2 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_RX_MASK (0x40U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_RX_SHIFT (6U)
/*! FLEXCOMM3_RX - FLEXCOMM3 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_TX_MASK (0x80U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_TX_SHIFT (7U)
/*! FLEXCOMM3_TX - FLEXCOMM3 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH0_MASK (0x10000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH0_SHIFT (16U)
/*! DMIC0CH0 - DMIC0 channel 0 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH0(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH0_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH0_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH1_MASK (0x20000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH1_SHIFT (17U)
/*! DMIC0CH1 - DMIC0 channel 1 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH1(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH1_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH1_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH2_MASK (0x40000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH2_SHIFT (18U)
/*! DMIC0CH2 - DMIC0 channel 2 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH2(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH2_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH2_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH3_MASK (0x80000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH3_SHIFT (19U)
/*! DMIC0CH3 - DMIC0 channel 3 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH3(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH3_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH3_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_RX_MASK (0x4000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_RX_SHIFT (26U)
/*! FLEXCOMM14_RX - FLEXCOMM14 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_TX_MASK (0x8000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_TX_SHIFT (27U)
/*! FLEXCOMM14_TX - FLEXCOMM14 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_TX_MASK)
/*! @} */

/*! @name DMAC0_ITRIG_ENA0 - DMAC0 input trigger enable 0 */
/*! @{ */

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX0_MASK (0x1U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX0_SHIFT (0U)
/*! DMAC0_ITRIG_INMUX0 - DMAC0 input trigger inmux 0 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX1_MASK (0x2U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX1_SHIFT (1U)
/*! DMAC0_ITRIG_INMUX1 - DMAC0 input trigger inmux 1 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX2_MASK (0x4U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX2_SHIFT (2U)
/*! DMAC0_ITRIG_INMUX2 - DMAC0 input trigger inmux 2 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX2(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX2_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX2_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX3_MASK (0x8U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX3_SHIFT (3U)
/*! DMAC0_ITRIG_INMUX3 - DMAC0 input trigger inmux 3 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX3(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX3_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX3_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX4_MASK (0x10U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX4_SHIFT (4U)
/*! DMAC0_ITRIG_INMUX4 - DMAC0 input trigger inmux 4 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX4(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX4_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX4_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX5_MASK (0x20U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX5_SHIFT (5U)
/*! DMAC0_ITRIG_INMUX5 - DMAC0 input trigger inmux 5 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX5(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX5_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX5_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX6_MASK (0x40U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX6_SHIFT (6U)
/*! DMAC0_ITRIG_INMUX6 - DMAC0 input trigger inmux 6 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX6(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX6_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX6_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX7_MASK (0x80U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX7_SHIFT (7U)
/*! DMAC0_ITRIG_INMUX7 - DMAC0 input trigger inmux 7 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX7(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX7_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX7_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX8_MASK (0x100U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX8_SHIFT (8U)
/*! DMAC0_ITRIG_INMUX8 - DMAC0 input trigger inmux 8 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX8(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX8_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX8_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX9_MASK (0x200U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX9_SHIFT (9U)
/*! DMAC0_ITRIG_INMUX9 - DMAC0 input trigger inmux 9 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX9(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX9_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX9_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX10_MASK (0x400U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX10_SHIFT (10U)
/*! DMAC0_ITRIG_INMUX10 - DMAC0 input trigger inmux 10 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX10(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX10_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX10_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX11_MASK (0x800U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX11_SHIFT (11U)
/*! DMAC0_ITRIG_INMUX11 - DMAC0 input trigger inmux 11 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX11(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX11_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX11_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX12_MASK (0x1000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX12_SHIFT (12U)
/*! DMAC0_ITRIG_INMUX12 - DMAC0 input trigger inmux 12 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX12(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX12_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX12_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX13_MASK (0x2000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX13_SHIFT (13U)
/*! DMAC0_ITRIG_INMUX13 - DMAC0 input trigger inmux 13 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX13(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX13_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX13_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX14_MASK (0x4000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX14_SHIFT (14U)
/*! DMAC0_ITRIG_INMUX14 - DMAC0 input trigger inmux 14 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX14(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX14_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX14_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX15_MASK (0x8000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX15_SHIFT (15U)
/*! DMAC0_ITRIG_INMUX15 - DMAC0 input trigger inmux 15 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX15(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX15_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX15_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX16_MASK (0x10000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX16_SHIFT (16U)
/*! DMAC0_ITRIG_INMUX16 - DMAC0 input trigger inmux 16 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX16(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX16_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX16_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX17_MASK (0x20000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX17_SHIFT (17U)
/*! DMAC0_ITRIG_INMUX17 - DMAC0 input trigger inmux 17 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX17(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX17_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX17_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX18_MASK (0x40000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX18_SHIFT (18U)
/*! DMAC0_ITRIG_INMUX18 - DMAC0 input trigger inmux 18 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX18(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX18_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX18_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX19_MASK (0x80000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX19_SHIFT (19U)
/*! DMAC0_ITRIG_INMUX19 - DMAC0 input trigger inmux 19 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX19(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX19_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX19_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX20_MASK (0x100000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX20_SHIFT (20U)
/*! DMAC0_ITRIG_INMUX20 - DMAC0 input trigger inmux 20 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX20(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX20_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX20_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX21_MASK (0x200000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX21_SHIFT (21U)
/*! DMAC0_ITRIG_INMUX21 - DMAC0 input trigger inmux 21 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX21(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX21_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX21_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX22_MASK (0x400000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX22_SHIFT (22U)
/*! DMAC0_ITRIG_INMUX22 - DMAC0 input trigger inmux 22 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX22(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX22_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX22_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX23_MASK (0x800000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX23_SHIFT (23U)
/*! DMAC0_ITRIG_INMUX23 - DMAC0 input trigger inmux 23 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX23(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX23_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX23_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX24_MASK (0x1000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX24_SHIFT (24U)
/*! DMAC0_ITRIG_INMUX24 - DMAC0 input trigger inmux 24 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX24(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX24_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX24_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX25_MASK (0x2000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX25_SHIFT (25U)
/*! DMAC0_ITRIG_INMUX25 - DMAC0 input trigger inmux 25 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX25(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX25_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX25_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX26_MASK (0x4000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX26_SHIFT (26U)
/*! DMAC0_ITRIG_INMUX26 - DMAC0 input trigger inmux 26 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX26(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX26_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX26_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX27_MASK (0x8000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX27_SHIFT (27U)
/*! DMAC0_ITRIG_INMUX27 - DMAC0 input trigger inmux 27 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX27(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX27_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX27_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX28_MASK (0x10000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX28_SHIFT (28U)
/*! DMAC0_ITRIG_INMUX28 - DMAC0 input trigger inmux 28 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX28(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX28_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX28_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX29_MASK (0x20000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX29_SHIFT (29U)
/*! DMAC0_ITRIG_INMUX29 - DMAC0 input trigger inmux 29 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX29(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX29_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX29_MASK)
/*! @} */

/*! @name DMAC0_ITRIG_ENA1 - DMAC0 input trigger enable 1 */
/*! @{ */

#define INPUTMUX_DMAC0_ITRIG_ENA1_DMAC0_ITRIG_INMUX0_MASK (0x1U)
#define INPUTMUX_DMAC0_ITRIG_ENA1_DMAC0_ITRIG_INMUX0_SHIFT (0U)
/*! DMAC0_ITRIG_INMUX0 - DMAC0 input trigger inmux 0 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA1_DMAC0_ITRIG_INMUX0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA1_DMAC0_ITRIG_INMUX0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA1_DMAC0_ITRIG_INMUX0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA1_DMAC0_ITRIG_INMUX1_MASK (0x2U)
#define INPUTMUX_DMAC0_ITRIG_ENA1_DMAC0_ITRIG_INMUX1_SHIFT (1U)
/*! DMAC0_ITRIG_INMUX1 - DMAC0 input trigger inmux 1 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA1_DMAC0_ITRIG_INMUX1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA1_DMAC0_ITRIG_INMUX1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA1_DMAC0_ITRIG_INMUX1_MASK)
/*! @} */

/*! @name DMAC0_ITRIG_ENA0_SET - DMAC0 input trigger enable set 0 */
/*! @{ */

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX0_MASK (0x1U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX0_SHIFT (0U)
/*! DMAC0_ITRIG_INMUX0 - DMAC0 input trigger inmux 0 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX1_MASK (0x2U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX1_SHIFT (1U)
/*! DMAC0_ITRIG_INMUX1 - DMAC0 input trigger inmux 1 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX2_MASK (0x4U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX2_SHIFT (2U)
/*! DMAC0_ITRIG_INMUX2 - DMAC0 input trigger inmux 2 enable set */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX2(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX2_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX2_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX3_MASK (0x8U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX3_SHIFT (3U)
/*! DMAC0_ITRIG_INMUX3 - DMAC0 input trigger inmux 3 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX3(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX3_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX3_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX4_MASK (0x10U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX4_SHIFT (4U)
/*! DMAC0_ITRIG_INMUX4 - DMAC0 input trigger inmux 4 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX4(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX4_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX4_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX5_MASK (0x20U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX5_SHIFT (5U)
/*! DMAC0_ITRIG_INMUX5 - DMAC0 input trigger inmux 5 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX5(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX5_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX5_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX6_MASK (0x40U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX6_SHIFT (6U)
/*! DMAC0_ITRIG_INMUX6 - DMAC0 input trigger inmux 6 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX6(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX6_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX6_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX7_MASK (0x80U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX7_SHIFT (7U)
/*! DMAC0_ITRIG_INMUX7 - DMAC0 input trigger inmux 7 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX7(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX7_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX7_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX8_MASK (0x100U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX8_SHIFT (8U)
/*! DMAC0_ITRIG_INMUX8 - DMAC0 input trigger inmux 8 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX8(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX8_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX8_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX9_MASK (0x200U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX9_SHIFT (9U)
/*! DMAC0_ITRIG_INMUX9 - DMAC0 input trigger inmux 9 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX9(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX9_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX9_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX10_MASK (0x400U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX10_SHIFT (10U)
/*! DMAC0_ITRIG_INMUX10 - DMAC0 input trigger inmux 10 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX10(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX10_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX10_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX11_MASK (0x800U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX11_SHIFT (11U)
/*! DMAC0_ITRIG_INMUX11 - DMAC0 input trigger inmux 11 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX11(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX11_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX11_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX12_MASK (0x1000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX12_SHIFT (12U)
/*! DMAC0_ITRIG_INMUX12 - DMAC0 input trigger inmux 12 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX12(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX12_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX12_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX13_MASK (0x2000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX13_SHIFT (13U)
/*! DMAC0_ITRIG_INMUX13 - DMAC0 input trigger inmux 13 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX13(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX13_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX13_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX14_MASK (0x4000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX14_SHIFT (14U)
/*! DMAC0_ITRIG_INMUX14 - DMAC0 input trigger inmux 14 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX14(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX14_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX14_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX15_MASK (0x8000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX15_SHIFT (15U)
/*! DMAC0_ITRIG_INMUX15 - DMAC0 input trigger inmux 15 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX15(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX15_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX15_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX16_MASK (0x10000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX16_SHIFT (16U)
/*! DMAC0_ITRIG_INMUX16 - DMAC0 input trigger inmux 16 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX16(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX16_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX16_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX17_MASK (0x20000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX17_SHIFT (17U)
/*! DMAC0_ITRIG_INMUX17 - DMAC0 input trigger inmux 17 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX17(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX17_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX17_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX18_MASK (0x40000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX18_SHIFT (18U)
/*! DMAC0_ITRIG_INMUX18 - DMAC0 input trigger inmux 18 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX18(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX18_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX18_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX19_MASK (0x80000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX19_SHIFT (19U)
/*! DMAC0_ITRIG_INMUX19 - DMAC0 input trigger inmux 19 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX19(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX19_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX19_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX20_MASK (0x100000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX20_SHIFT (20U)
/*! DMAC0_ITRIG_INMUX20 - DMAC0 input trigger inmux 20 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX20(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX20_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX20_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX21_MASK (0x200000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX21_SHIFT (21U)
/*! DMAC0_ITRIG_INMUX21 - DMAC0 input trigger inmux 21 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX21(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX21_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX21_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX22_MASK (0x400000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX22_SHIFT (22U)
/*! DMAC0_ITRIG_INMUX22 - DMAC0 input trigger inmux 22 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX22(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX22_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX22_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX23_MASK (0x800000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX23_SHIFT (23U)
/*! DMAC0_ITRIG_INMUX23 - DMAC0 input trigger inmux 23 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX23(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX23_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX23_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX24_MASK (0x1000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX24_SHIFT (24U)
/*! DMAC0_ITRIG_INMUX24 - DMAC0 input trigger inmux 24 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX24(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX24_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX24_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX25_MASK (0x2000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX25_SHIFT (25U)
/*! DMAC0_ITRIG_INMUX25 - DMAC0 input trigger inmux 25 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX25(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX25_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX25_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX26_MASK (0x4000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX26_SHIFT (26U)
/*! DMAC0_ITRIG_INMUX26 - DMAC0 input trigger inmux 26 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX26(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX26_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX26_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX27_MASK (0x8000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX27_SHIFT (27U)
/*! DMAC0_ITRIG_INMUX27 - DMAC0 input trigger inmux 27 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX27(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX27_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX27_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX28_MASK (0x10000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX28_SHIFT (28U)
/*! DMAC0_ITRIG_INMUX28 - DMAC0 input trigger inmux 28 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX28(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX28_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX28_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX29_MASK (0x20000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX29_SHIFT (29U)
/*! DMAC0_ITRIG_INMUX29 - DMAC0 input trigger inmux 29 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX29(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX29_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX29_MASK)
/*! @} */

/*! @name DMAC0_ITRIG_ENA1_SET - DMAC0 input trigger enable set 1 */
/*! @{ */

#define INPUTMUX_DMAC0_ITRIG_ENA1_SET_DMAC0_ITRIG_INMUX0_MASK (0x1U)
#define INPUTMUX_DMAC0_ITRIG_ENA1_SET_DMAC0_ITRIG_INMUX0_SHIFT (0U)
/*! DMAC0_ITRIG_INMUX0 - DMAC0 input trigger inmux 0 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA1_SET_DMAC0_ITRIG_INMUX0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA1_SET_DMAC0_ITRIG_INMUX0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA1_SET_DMAC0_ITRIG_INMUX0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA1_SET_DMAC0_ITRIG_INMUX1_MASK (0x2U)
#define INPUTMUX_DMAC0_ITRIG_ENA1_SET_DMAC0_ITRIG_INMUX1_SHIFT (1U)
/*! DMAC0_ITRIG_INMUX1 - DMAC0 input trigger inmux 1 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA1_SET_DMAC0_ITRIG_INMUX1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA1_SET_DMAC0_ITRIG_INMUX1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA1_SET_DMAC0_ITRIG_INMUX1_MASK)
/*! @} */

/*! @name DMAC0_ITRIG_ENA0_CLR - DMAC0 input trigger enable clear 0 */
/*! @{ */

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX0_MASK (0x1U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX0_SHIFT (0U)
/*! DMAC0_ITRIG_INMUX0 - DMAC0 input trigger inmux 0 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX1_MASK (0x2U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX1_SHIFT (1U)
/*! DMAC0_ITRIG_INMUX1 - DMAC0 input trigger inmux 1 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX2_MASK (0x4U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX2_SHIFT (2U)
/*! DMAC0_ITRIG_INMUX2 - DMAC0 input trigger inmux 2 enable clear */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX2(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX2_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX2_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX3_MASK (0x8U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX3_SHIFT (3U)
/*! DMAC0_ITRIG_INMUX3 - DMAC0 input trigger inmux 3 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX3(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX3_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX3_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX4_MASK (0x10U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX4_SHIFT (4U)
/*! DMAC0_ITRIG_INMUX4 - DMAC0 input trigger inmux 4 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX4(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX4_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX4_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX5_MASK (0x20U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX5_SHIFT (5U)
/*! DMAC0_ITRIG_INMUX5 - DMAC0 input trigger inmux 5 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX5(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX5_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX5_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX6_MASK (0x40U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX6_SHIFT (6U)
/*! DMAC0_ITRIG_INMUX6 - DMAC0 input trigger inmux 6 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX6(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX6_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX6_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX7_MASK (0x80U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX7_SHIFT (7U)
/*! DMAC0_ITRIG_INMUX7 - DMAC0 input trigger inmux 7 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX7(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX7_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX7_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX8_MASK (0x100U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX8_SHIFT (8U)
/*! DMAC0_ITRIG_INMUX8 - DMAC0 input trigger inmux 8 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX8(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX8_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX8_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX9_MASK (0x200U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX9_SHIFT (9U)
/*! DMAC0_ITRIG_INMUX9 - DMAC0 input trigger inmux 9 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX9(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX9_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX9_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX10_MASK (0x400U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX10_SHIFT (10U)
/*! DMAC0_ITRIG_INMUX10 - DMAC0 input trigger inmux 10 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX10(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX10_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX10_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX11_MASK (0x800U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX11_SHIFT (11U)
/*! DMAC0_ITRIG_INMUX11 - DMAC0 input trigger inmux 11 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX11(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX11_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX11_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX12_MASK (0x1000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX12_SHIFT (12U)
/*! DMAC0_ITRIG_INMUX12 - DMAC0 input trigger inmux 12 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX12(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX12_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX12_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX13_MASK (0x2000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX13_SHIFT (13U)
/*! DMAC0_ITRIG_INMUX13 - DMAC0 input trigger inmux 13 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX13(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX13_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX13_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX14_MASK (0x4000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX14_SHIFT (14U)
/*! DMAC0_ITRIG_INMUX14 - DMAC0 input trigger inmux 14 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX14(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX14_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX14_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX15_MASK (0x8000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX15_SHIFT (15U)
/*! DMAC0_ITRIG_INMUX15 - DMAC0 input trigger inmux 15 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX15(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX15_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX15_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX16_MASK (0x10000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX16_SHIFT (16U)
/*! DMAC0_ITRIG_INMUX16 - DMAC0 input trigger inmux 16 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX16(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX16_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX16_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX17_MASK (0x20000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX17_SHIFT (17U)
/*! DMAC0_ITRIG_INMUX17 - DMAC0 input trigger inmux 17 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX17(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX17_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX17_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX18_MASK (0x40000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX18_SHIFT (18U)
/*! DMAC0_ITRIG_INMUX18 - DMAC0 input trigger inmux 18 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX18(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX18_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX18_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX19_MASK (0x80000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX19_SHIFT (19U)
/*! DMAC0_ITRIG_INMUX19 - DMAC0 input trigger inmux 19 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX19(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX19_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX19_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX20_MASK (0x100000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX20_SHIFT (20U)
/*! DMAC0_ITRIG_INMUX20 - DMAC0 input trigger inmux 20 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX20(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX20_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX20_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX21_MASK (0x200000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX21_SHIFT (21U)
/*! DMAC0_ITRIG_INMUX21 - DMAC0 input trigger inmux 21 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX21(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX21_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX21_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX22_MASK (0x400000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX22_SHIFT (22U)
/*! DMAC0_ITRIG_INMUX22 - DMAC0 input trigger inmux 22 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX22(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX22_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX22_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX23_MASK (0x800000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX23_SHIFT (23U)
/*! DMAC0_ITRIG_INMUX23 - DMAC0 input trigger inmux 23 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX23(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX23_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX23_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX24_MASK (0x1000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX24_SHIFT (24U)
/*! DMAC0_ITRIG_INMUX24 - DMAC0 input trigger inmux 24 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX24(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX24_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX24_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX25_MASK (0x2000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX25_SHIFT (25U)
/*! DMAC0_ITRIG_INMUX25 - DMAC0 input trigger inmux 25 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX25(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX25_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX25_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX26_MASK (0x4000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX26_SHIFT (26U)
/*! DMAC0_ITRIG_INMUX26 - DMAC0 input trigger inmux 26 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX26(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX26_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX26_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX27_MASK (0x8000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX27_SHIFT (27U)
/*! DMAC0_ITRIG_INMUX27 - DMAC0 input trigger inmux 27 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX27(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX27_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX27_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX28_MASK (0x10000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX28_SHIFT (28U)
/*! DMAC0_ITRIG_INMUX28 - DMAC0 input trigger inmux 28 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX28(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX28_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX28_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX29_MASK (0x20000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX29_SHIFT (29U)
/*! DMAC0_ITRIG_INMUX29 - DMAC0 input trigger inmux 29 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX29(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX29_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX29_MASK)
/*! @} */

/*! @name DMAC0_ITRIG_ENA1_CLR - DMAC0 input trigger enable clear 1 */
/*! @{ */

#define INPUTMUX_DMAC0_ITRIG_ENA1_CLR_DMAC0_ITRIG_INMUX0_MASK (0x1U)
#define INPUTMUX_DMAC0_ITRIG_ENA1_CLR_DMAC0_ITRIG_INMUX0_SHIFT (0U)
/*! DMAC0_ITRIG_INMUX0 - DMAC0 input trigger inmux 0 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA1_CLR_DMAC0_ITRIG_INMUX0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA1_CLR_DMAC0_ITRIG_INMUX0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA1_CLR_DMAC0_ITRIG_INMUX0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA1_CLR_DMAC0_ITRIG_INMUX1_MASK (0x2U)
#define INPUTMUX_DMAC0_ITRIG_ENA1_CLR_DMAC0_ITRIG_INMUX1_SHIFT (1U)
/*! DMAC0_ITRIG_INMUX1 - DMAC0 input trigger inmux 1 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA1_CLR_DMAC0_ITRIG_INMUX1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA1_CLR_DMAC0_ITRIG_INMUX1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA1_CLR_DMAC0_ITRIG_INMUX1_MASK)
/*! @} */

/*! @name DMAC1_ITRIG_ENA0 - DMAC1 input trigger enable 0 */
/*! @{ */

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX0_MASK (0x1U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX0_SHIFT (0U)
/*! DMAC1_ITRIG_INMUX0 - DMAC1 input trigger inmux 0 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX1_MASK (0x2U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX1_SHIFT (1U)
/*! DMAC1_ITRIG_INMUX1 - DMAC1 input trigger inmux 1 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX2_MASK (0x4U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX2_SHIFT (2U)
/*! DMAC1_ITRIG_INMUX2 - DMAC1 input trigger inmux 2 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX2(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX2_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX2_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX3_MASK (0x8U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX3_SHIFT (3U)
/*! DMAC1_ITRIG_INMUX3 - DMAC1 input trigger inmux 3 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX3(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX3_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX3_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX4_MASK (0x10U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX4_SHIFT (4U)
/*! DMAC1_ITRIG_INMUX4 - DMAC1 input trigger inmux 4 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX4(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX4_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX4_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX5_MASK (0x20U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX5_SHIFT (5U)
/*! DMAC1_ITRIG_INMUX5 - DMAC1 input trigger inmux 5 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX5(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX5_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX5_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX6_MASK (0x40U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX6_SHIFT (6U)
/*! DMAC1_ITRIG_INMUX6 - DMAC1 input trigger inmux 6 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX6(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX6_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX6_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX7_MASK (0x80U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX7_SHIFT (7U)
/*! DMAC1_ITRIG_INMUX7 - DMAC1 input trigger inmux 7 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX7(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX7_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX7_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX8_MASK (0x100U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX8_SHIFT (8U)
/*! DMAC1_ITRIG_INMUX8 - DMAC1 input trigger inmux 8 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX8(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX8_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX8_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX9_MASK (0x200U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX9_SHIFT (9U)
/*! DMAC1_ITRIG_INMUX9 - DMAC1 input trigger inmux 9 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX9(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX9_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX9_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX10_MASK (0x400U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX10_SHIFT (10U)
/*! DMAC1_ITRIG_INMUX10 - DMAC1 input trigger inmux 10 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX10(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX10_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX10_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX11_MASK (0x800U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX11_SHIFT (11U)
/*! DMAC1_ITRIG_INMUX11 - DMAC1 input trigger inmux 11 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX11(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX11_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX11_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX12_MASK (0x1000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX12_SHIFT (12U)
/*! DMAC1_ITRIG_INMUX12 - DMAC1 input trigger inmux 12 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX12(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX12_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX12_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX13_MASK (0x2000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX13_SHIFT (13U)
/*! DMAC1_ITRIG_INMUX13 - DMAC1 input trigger inmux 13 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX13(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX13_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX13_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX14_MASK (0x4000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX14_SHIFT (14U)
/*! DMAC1_ITRIG_INMUX14 - DMAC1 input trigger inmux 14 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX14(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX14_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX14_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX15_MASK (0x8000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX15_SHIFT (15U)
/*! DMAC1_ITRIG_INMUX15 - DMAC1 input trigger inmux 15 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX15(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX15_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX15_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX16_MASK (0x10000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX16_SHIFT (16U)
/*! DMAC1_ITRIG_INMUX16 - DMAC1 input trigger inmux 16 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX16(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX16_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX16_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX17_MASK (0x20000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX17_SHIFT (17U)
/*! DMAC1_ITRIG_INMUX17 - DMAC1 input trigger inmux 17 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX17(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX17_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX17_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX18_MASK (0x40000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX18_SHIFT (18U)
/*! DMAC1_ITRIG_INMUX18 - DMAC1 input trigger inmux 18 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX18(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX18_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX18_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX19_MASK (0x80000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX19_SHIFT (19U)
/*! DMAC1_ITRIG_INMUX19 - DMAC1 input trigger inmux 19 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX19(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX19_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX19_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX20_MASK (0x100000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX20_SHIFT (20U)
/*! DMAC1_ITRIG_INMUX20 - DMAC1 input trigger inmux 20 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX20(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX20_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX20_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX21_MASK (0x200000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX21_SHIFT (21U)
/*! DMAC1_ITRIG_INMUX21 - DMAC1 input trigger inmux 21 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX21(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX21_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX21_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX22_MASK (0x400000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX22_SHIFT (22U)
/*! DMAC1_ITRIG_INMUX22 - DMAC1 input trigger inmux 22 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX22(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX22_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX22_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX23_MASK (0x800000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX23_SHIFT (23U)
/*! DMAC1_ITRIG_INMUX23 - DMAC1 input trigger inmux 23 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX23(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX23_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX23_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX24_MASK (0x1000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX24_SHIFT (24U)
/*! DMAC1_ITRIG_INMUX24 - DMAC1 input trigger inmux 24 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX24(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX24_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX24_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX25_MASK (0x2000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX25_SHIFT (25U)
/*! DMAC1_ITRIG_INMUX25 - DMAC1 input trigger inmux 25 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX25(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX25_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX25_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX26_MASK (0x4000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX26_SHIFT (26U)
/*! DMAC1_ITRIG_INMUX26 - DMAC1 input trigger inmux 25 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX26(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX26_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX26_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX27_MASK (0x8000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX27_SHIFT (27U)
/*! DMAC1_ITRIG_INMUX27 - DMAC1 input trigger inmux 25 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX27(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX27_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX27_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX28_MASK (0x10000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX28_SHIFT (28U)
/*! DMAC1_ITRIG_INMUX28 - DMAC1 input trigger inmux 25 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX28(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX28_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX28_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX29_MASK (0x20000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX29_SHIFT (29U)
/*! DMAC1_ITRIG_INMUX29 - DMAC1 input trigger inmux 25 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX29(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX29_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX29_MASK)
/*! @} */

/*! @name DMAC1_ITRIG_ENA1 - DMAC1 input trigger enable 1 */
/*! @{ */

#define INPUTMUX_DMAC1_ITRIG_ENA1_DMAC1_ITRIG_INMUX0_MASK (0x1U)
#define INPUTMUX_DMAC1_ITRIG_ENA1_DMAC1_ITRIG_INMUX0_SHIFT (0U)
/*! DMAC1_ITRIG_INMUX0 - DMAC1 input trigger inmux 0 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA1_DMAC1_ITRIG_INMUX0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA1_DMAC1_ITRIG_INMUX0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA1_DMAC1_ITRIG_INMUX0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA1_DMAC1_ITRIG_INMUX1_MASK (0x2U)
#define INPUTMUX_DMAC1_ITRIG_ENA1_DMAC1_ITRIG_INMUX1_SHIFT (1U)
/*! DMAC1_ITRIG_INMUX1 - DMAC1 input trigger inmux 1 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA1_DMAC1_ITRIG_INMUX1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA1_DMAC1_ITRIG_INMUX1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA1_DMAC1_ITRIG_INMUX1_MASK)
/*! @} */

/*! @name DMAC1_ITRIG_ENA0_SET - DMAC1 input trigger enable set 0 */
/*! @{ */

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX0_MASK (0x1U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX0_SHIFT (0U)
/*! DMAC1_ITRIG_INMUX0 - DMAC1 input trigger inmux 0 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX1_MASK (0x2U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX1_SHIFT (1U)
/*! DMAC1_ITRIG_INMUX1 - DMAC1 input trigger inmux 1 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX2_MASK (0x4U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX2_SHIFT (2U)
/*! DMAC1_ITRIG_INMUX2 - DMAC1 input trigger inmux 2 enable set */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX2(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX2_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX2_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX3_MASK (0x8U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX3_SHIFT (3U)
/*! DMAC1_ITRIG_INMUX3 - DMAC1 input trigger inmux 3 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX3(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX3_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX3_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX4_MASK (0x10U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX4_SHIFT (4U)
/*! DMAC1_ITRIG_INMUX4 - DMAC1 input trigger inmux 4 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX4(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX4_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX4_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX5_MASK (0x20U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX5_SHIFT (5U)
/*! DMAC1_ITRIG_INMUX5 - DMAC1 input trigger inmux 5 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX5(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX5_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX5_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX6_MASK (0x40U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX6_SHIFT (6U)
/*! DMAC1_ITRIG_INMUX6 - DMAC1 input trigger inmux 6 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX6(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX6_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX6_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX7_MASK (0x80U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX7_SHIFT (7U)
/*! DMAC1_ITRIG_INMUX7 - DMAC1 input trigger inmux 7 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX7(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX7_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX7_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX8_MASK (0x100U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX8_SHIFT (8U)
/*! DMAC1_ITRIG_INMUX8 - DMAC1 input trigger inmux 8 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX8(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX8_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX8_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX9_MASK (0x200U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX9_SHIFT (9U)
/*! DMAC1_ITRIG_INMUX9 - DMAC1 input trigger inmux 9 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX9(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX9_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX9_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX10_MASK (0x400U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX10_SHIFT (10U)
/*! DMAC1_ITRIG_INMUX10 - DMAC1 input trigger inmux 10 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX10(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX10_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX10_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX11_MASK (0x800U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX11_SHIFT (11U)
/*! DMAC1_ITRIG_INMUX11 - DMAC1 input trigger inmux 11 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX11(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX11_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX11_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX12_MASK (0x1000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX12_SHIFT (12U)
/*! DMAC1_ITRIG_INMUX12 - DMAC1 input trigger inmux 12 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX12(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX12_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX12_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX13_MASK (0x2000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX13_SHIFT (13U)
/*! DMAC1_ITRIG_INMUX13 - DMAC1 input trigger inmux 13 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX13(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX13_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX13_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX14_MASK (0x4000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX14_SHIFT (14U)
/*! DMAC1_ITRIG_INMUX14 - DMAC1 input trigger inmux 14 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX14(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX14_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX14_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX15_MASK (0x8000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX15_SHIFT (15U)
/*! DMAC1_ITRIG_INMUX15 - DMAC1 input trigger inmux 15 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX15(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX15_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX15_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX16_MASK (0x10000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX16_SHIFT (16U)
/*! DMAC1_ITRIG_INMUX16 - DMAC1 input trigger inmux 16 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX16(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX16_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX16_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX17_MASK (0x20000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX17_SHIFT (17U)
/*! DMAC1_ITRIG_INMUX17 - DMAC1 input trigger inmux 17 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX17(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX17_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX17_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX18_MASK (0x40000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX18_SHIFT (18U)
/*! DMAC1_ITRIG_INMUX18 - DMAC1 input trigger inmux 18 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX18(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX18_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX18_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX19_MASK (0x80000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX19_SHIFT (19U)
/*! DMAC1_ITRIG_INMUX19 - DMAC1 input trigger inmux 19 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX19(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX19_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX19_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX20_MASK (0x100000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX20_SHIFT (20U)
/*! DMAC1_ITRIG_INMUX20 - DMAC1 input trigger inmux 20 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX20(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX20_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX20_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX21_MASK (0x200000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX21_SHIFT (21U)
/*! DMAC1_ITRIG_INMUX21 - DMAC1 input trigger inmux 21 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX21(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX21_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX21_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX22_MASK (0x400000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX22_SHIFT (22U)
/*! DMAC1_ITRIG_INMUX22 - DMAC1 input trigger inmux 22 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX22(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX22_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX22_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX23_MASK (0x800000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX23_SHIFT (23U)
/*! DMAC1_ITRIG_INMUX23 - DMAC1 input trigger inmux 23 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX23(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX23_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX23_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX24_MASK (0x1000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX24_SHIFT (24U)
/*! DMAC1_ITRIG_INMUX24 - DMAC1 input trigger inmux 24 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX24(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX24_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX24_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX25_MASK (0x2000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX25_SHIFT (25U)
/*! DMAC1_ITRIG_INMUX25 - DMAC1 input trigger inmux 25 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX25(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX25_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX25_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX26_MASK (0x4000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX26_SHIFT (26U)
/*! DMAC1_ITRIG_INMUX26 - DMAC1 input trigger inmux 25 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX26(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX26_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX26_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX27_MASK (0x8000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX27_SHIFT (27U)
/*! DMAC1_ITRIG_INMUX27 - DMAC1 input trigger inmux 25 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX27(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX27_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX27_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX28_MASK (0x10000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX28_SHIFT (28U)
/*! DMAC1_ITRIG_INMUX28 - DMAC1 input trigger inmux 25 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX28(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX28_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX28_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX29_MASK (0x20000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX29_SHIFT (29U)
/*! DMAC1_ITRIG_INMUX29 - DMAC1 input trigger inmux 25 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX29(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX29_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX29_MASK)
/*! @} */

/*! @name DMAC1_ITRIG_ENA1_SET - DMAC1 input trigger enable set 1 */
/*! @{ */

#define INPUTMUX_DMAC1_ITRIG_ENA1_SET_DMAC1_ITRIG_INMUX0_MASK (0x1U)
#define INPUTMUX_DMAC1_ITRIG_ENA1_SET_DMAC1_ITRIG_INMUX0_SHIFT (0U)
/*! DMAC1_ITRIG_INMUX0 - DMAC1 input trigger inmux 0 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA1_SET_DMAC1_ITRIG_INMUX0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA1_SET_DMAC1_ITRIG_INMUX0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA1_SET_DMAC1_ITRIG_INMUX0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA1_SET_DMAC1_ITRIG_INMUX1_MASK (0x2U)
#define INPUTMUX_DMAC1_ITRIG_ENA1_SET_DMAC1_ITRIG_INMUX1_SHIFT (1U)
/*! DMAC1_ITRIG_INMUX1 - DMAC1 input trigger inmux 1 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA1_SET_DMAC1_ITRIG_INMUX1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA1_SET_DMAC1_ITRIG_INMUX1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA1_SET_DMAC1_ITRIG_INMUX1_MASK)
/*! @} */

/*! @name DMAC1_ITRIG_ENA0_CLR - DMAC1 input trigger enable clear 0 */
/*! @{ */

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX0_MASK (0x1U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX0_SHIFT (0U)
/*! DMAC1_ITRIG_INMUX0 - DMAC1 input trigger inmux 0 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX1_MASK (0x2U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX1_SHIFT (1U)
/*! DMAC1_ITRIG_INMUX1 - DMAC1 input trigger inmux 1 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX2_MASK (0x4U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX2_SHIFT (2U)
/*! DMAC1_ITRIG_INMUX2 - DMAC1 input trigger inmux 2 enable clear */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX2(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX2_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX2_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX3_MASK (0x8U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX3_SHIFT (3U)
/*! DMAC1_ITRIG_INMUX3 - DMAC1 input trigger inmux 3 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX3(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX3_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX3_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX4_MASK (0x10U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX4_SHIFT (4U)
/*! DMAC1_ITRIG_INMUX4 - DMAC1 input trigger inmux 4 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX4(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX4_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX4_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX5_MASK (0x20U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX5_SHIFT (5U)
/*! DMAC1_ITRIG_INMUX5 - DMAC1 input trigger inmux 5 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX5(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX5_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX5_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX6_MASK (0x40U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX6_SHIFT (6U)
/*! DMAC1_ITRIG_INMUX6 - DMAC1 input trigger inmux 6 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX6(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX6_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX6_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX7_MASK (0x80U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX7_SHIFT (7U)
/*! DMAC1_ITRIG_INMUX7 - DMAC1 input trigger inmux 7 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX7(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX7_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX7_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX8_MASK (0x100U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX8_SHIFT (8U)
/*! DMAC1_ITRIG_INMUX8 - DMAC1 input trigger inmux 8 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX8(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX8_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX8_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX9_MASK (0x200U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX9_SHIFT (9U)
/*! DMAC1_ITRIG_INMUX9 - DMAC1 input trigger inmux 9 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX9(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX9_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX9_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX10_MASK (0x400U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX10_SHIFT (10U)
/*! DMAC1_ITRIG_INMUX10 - DMAC1 input trigger inmux 10 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX10(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX10_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX10_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX11_MASK (0x800U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX11_SHIFT (11U)
/*! DMAC1_ITRIG_INMUX11 - DMAC1 input trigger inmux 11 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX11(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX11_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX11_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX12_MASK (0x1000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX12_SHIFT (12U)
/*! DMAC1_ITRIG_INMUX12 - DMAC1 input trigger inmux 12 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX12(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX12_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX12_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX13_MASK (0x2000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX13_SHIFT (13U)
/*! DMAC1_ITRIG_INMUX13 - DMAC1 input trigger inmux 13 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX13(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX13_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX13_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX14_MASK (0x4000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX14_SHIFT (14U)
/*! DMAC1_ITRIG_INMUX14 - DMAC1 input trigger inmux 14 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX14(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX14_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX14_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX15_MASK (0x8000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX15_SHIFT (15U)
/*! DMAC1_ITRIG_INMUX15 - DMAC1 input trigger inmux 15 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX15(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX15_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX15_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX16_MASK (0x10000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX16_SHIFT (16U)
/*! DMAC1_ITRIG_INMUX16 - DMAC1 input trigger inmux 16 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX16(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX16_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX16_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX17_MASK (0x20000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX17_SHIFT (17U)
/*! DMAC1_ITRIG_INMUX17 - DMAC1 input trigger inmux 17 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX17(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX17_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX17_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX18_MASK (0x40000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX18_SHIFT (18U)
/*! DMAC1_ITRIG_INMUX18 - DMAC1 input trigger inmux 18 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX18(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX18_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX18_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX19_MASK (0x80000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX19_SHIFT (19U)
/*! DMAC1_ITRIG_INMUX19 - DMAC1 input trigger inmux 19 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX19(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX19_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX19_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX20_MASK (0x100000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX20_SHIFT (20U)
/*! DMAC1_ITRIG_INMUX20 - DMAC1 input trigger inmux 20 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX20(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX20_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX20_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX21_MASK (0x200000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX21_SHIFT (21U)
/*! DMAC1_ITRIG_INMUX21 - DMAC1 input trigger inmux 21 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX21(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX21_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX21_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX22_MASK (0x400000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX22_SHIFT (22U)
/*! DMAC1_ITRIG_INMUX22 - DMAC1 input trigger inmux 22 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX22(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX22_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX22_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX23_MASK (0x800000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX23_SHIFT (23U)
/*! DMAC1_ITRIG_INMUX23 - DMAC1 input trigger inmux 23 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX23(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX23_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX23_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX24_MASK (0x1000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX24_SHIFT (24U)
/*! DMAC1_ITRIG_INMUX24 - DMAC1 input trigger inmux 24 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX24(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX24_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX24_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX25_MASK (0x2000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX25_SHIFT (25U)
/*! DMAC1_ITRIG_INMUX25 - DMAC1 input trigger inmux 25 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX25(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX25_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX25_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX26_MASK (0x4000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX26_SHIFT (26U)
/*! DMAC1_ITRIG_INMUX26 - DMAC1 input trigger inmux 25 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX26(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX26_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX26_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX27_MASK (0x8000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX27_SHIFT (27U)
/*! DMAC1_ITRIG_INMUX27 - DMAC1 input trigger inmux 25 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX27(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX27_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX27_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX28_MASK (0x10000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX28_SHIFT (28U)
/*! DMAC1_ITRIG_INMUX28 - DMAC1 input trigger inmux 25 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX28(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX28_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX28_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX29_MASK (0x20000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX29_SHIFT (29U)
/*! DMAC1_ITRIG_INMUX29 - DMAC1 input trigger inmux 25 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX29(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX29_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX29_MASK)
/*! @} */

/*! @name DMAC1_ITRIG_ENA1_CLR - DMAC1 input trigger enable clear 1 */
/*! @{ */

#define INPUTMUX_DMAC1_ITRIG_ENA1_CLR_DMAC1_ITRIG_INMUX0_MASK (0x1U)
#define INPUTMUX_DMAC1_ITRIG_ENA1_CLR_DMAC1_ITRIG_INMUX0_SHIFT (0U)
/*! DMAC1_ITRIG_INMUX0 - DMAC1 input trigger inmux 0 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA1_CLR_DMAC1_ITRIG_INMUX0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA1_CLR_DMAC1_ITRIG_INMUX0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA1_CLR_DMAC1_ITRIG_INMUX0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA1_CLR_DMAC1_ITRIG_INMUX1_MASK (0x2U)
#define INPUTMUX_DMAC1_ITRIG_ENA1_CLR_DMAC1_ITRIG_INMUX1_SHIFT (1U)
/*! DMAC1_ITRIG_INMUX1 - DMAC1 input trigger inmux 1 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA1_CLR_DMAC1_ITRIG_INMUX1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA1_CLR_DMAC1_ITRIG_INMUX1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA1_CLR_DMAC1_ITRIG_INMUX1_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group INPUTMUX_Register_Masks */


/*!
 * @}
 */ /* end of group INPUTMUX_Peripheral_Access_Layer */


/*
** End of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic pop
  #else
    #pragma pop
  #endif
#elif defined(__GNUC__)
  /* leave anonymous unions enabled */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=default
#else
  #error Not supported compiler type
#endif

/*!
 * @}
 */ /* end of group Peripheral_access_layer */


#endif  /* INPUTMUX_H_ */

