/*--------------------------------------------------------------------------*/
/* Copyright 2021-2023 NXP                                                  */
/*                                                                          */
/* NXP Proprietary. This software is owned or controlled by NXP and may     */
/* only be used strictly in accordance with the applicable license terms.   */
/* By expressly accepting such terms or by downloading, installing,         */
/* activating and/or otherwise using the software, you are agreeing that    */
/* you have read, and that you agree to comply with and are bound by, such  */
/* license terms.  If you do not agree to be bound by the applicable        */
/* license terms, then you may not retain, install, activate or otherwise   */
/* use the software.                                                        */
/*--------------------------------------------------------------------------*/

/**
 * @file  mcuxCsslMemory_Types.h
 * @brief Type definitions for the mcuxCsslMemory component
 */

#ifndef MCUXCSSLMEMORY_TYPES_H
#define MCUXCSSLMEMORY_TYPES_H

#include <stdint.h>

/**
 * @defgroup mcuxCsslMemory_Types mcuxCsslMemory_Types
 * @brief Defines common macros and types of @ref mcuxCsslMemory
 * @ingroup mcuxCsslMemory
 * @{
 */

/**********************************************
 * TYPEDEFS
 **********************************************/

/**
 * @defgroup mcuxCsslMemory_Types_Types mcuxCsslMemory_Types_Types
 * @brief Defines all types of @ref mcuxCsslMemory_Types
 * @ingroup mcuxCsslMemory_Types
 * @{
 */

/**
 * @brief Type for CSSL Memory status codes.
 */
typedef uint32_t mcuxCsslMemory_Status_t;
/**
 * @}
 *
 * @}
 */

#endif /* MCUXCSSLMEMORY_TYPES_H */
