/*  Copyright 2023-2024 NXP
 *
 *  SPDX-License-Identifier: BSD-3-Clause
 *
 */
/*!\file nxp_wifi.h
 *\brief This file provides macros mapping between zephyr Kconfig and Wi-Fi driver.
 */

#ifndef __NXP_WIFI_H__
#define __NXP_WIFI_H__

#include <stdint.h>
#include <stdbool.h>

#ifdef __cplusplus
extern "C" {
#endif

#if CONFIG_NXP_WIFI_SHELL
#define CONFIG_WIFI_SHELL CONFIG_NXP_WIFI_SHELL
#endif

#if CONFIG_NXP_WIFI_MAX_AP_ENTRIES
#define CONFIG_MAX_AP_ENTRIES CONFIG_NXP_WIFI_MAX_AP_ENTRIES
#endif

#if CONFIG_NXP_WIFI_WLAN_KNOWN_NETWORKS
#define CONFIG_WLAN_KNOWN_NETWORKS CONFIG_NXP_WIFI_WLAN_KNOWN_NETWORKS
#endif

#if CONFIG_NXP_WIFI_SDIO_MULTI_PORT_RX_AGGR
#define CONFIG_SDIO_MULTI_PORT_RX_AGGR CONFIG_NXP_WIFI_SDIO_MULTI_PORT_RX_AGGR
#endif

#if CONFIG_NXP_WIFI_SDIO_MULTI_PORT_TX_AGGR
#define CONFIG_SDIO_MULTI_PORT_TX_AGGR CONFIG_NXP_WIFI_SDIO_MULTI_PORT_TX_AGGR
#endif

#if CONFIG_NXP_WIFI_AUTO_POWER_SAVE
#define CONFIG_WIFI_AUTO_POWER_SAVE CONFIG_NXP_WIFI_AUTO_POWER_SAVE
#endif

#if CONFIG_NXP_WIFI_TX_RX_ZERO_COPY
#define CONFIG_TX_RX_ZERO_COPY CONFIG_NXP_WIFI_TX_RX_ZERO_COPY
#endif

#if CONFIG_NXP_WIFI_RF_TEST_MODE
#define CONFIG_WIFI_RF_TEST_MODE CONFIG_NXP_WIFI_RF_TEST_MODE
#endif

#if CONFIG_NXP_WIFI_OFFLOAD
#define CONFIG_OFFLOAD CONFIG_NXP_WIFI_OFFLOAD
#endif

#if CONFIG_NXP_WIFI_STA_AUTO_DHCPV4
#define CONFIG_STA_AUTO_DHCPV4 CONFIG_NXP_WIFI_STA_AUTO_DHCPV4
#endif

#if CONFIG_NXP_WIFI_STA_RECONNECT
#define CONFIG_WIFI_STA_RECONNECT CONFIG_NXP_WIFI_STA_RECONNECT
#endif

#if CONFIG_NXP_WIFI_MON_THREAD_STACK_SIZE
#define CONFIG_MON_THREAD_STACK_SIZE CONFIG_NXP_WIFI_MON_THREAD_STACK_SIZE
#endif

#if CONFIG_NXP_WIFI_WLCMGR_STACK_SIZE
#define CONFIG_WLCMGR_STACK_SIZE CONFIG_NXP_WIFI_WLCMGR_STACK_SIZE
#endif

#if CONFIG_NXP_WIFI_WPS_STACK_SIZE
#define CONFIG_WPS_STACK_SIZE CONFIG_NXP_WIFI_WPS_STACK_SIZE
#endif

#if CONFIG_NXP_WIFI_POWERSAVE_STACK_SIZE
#define CONFIG_POWERSAVE_STACK_SIZE CONFIG_NXP_WIFI_POWERSAVE_STACK_SIZE
#endif

#if CONFIG_NXP_WIFI_TX_STACK_SIZE
#define CONFIG_TX_STACK_SIZE CONFIG_NXP_WIFI_TX_STACK_SIZE
#endif

#if CONFIG_NXP_WIFI_DRIVER_STACK_SIZE
#define CONFIG_DRIVER_STACK_SIZE CONFIG_NXP_WIFI_DRIVER_STACK_SIZE
#endif

#if CONFIG_NXP_WIFI_DHCP_SERVER_STACK_SIZE
#define CONFIG_DHCP_SERVER_STACK_SIZE CONFIG_NXP_WIFI_DHCP_SERVER_STACK_SIZE
#endif

#if CONFIG_NXP_WIFI_11AX
#define CONFIG_11AX CONFIG_NXP_WIFI_11AX
#endif

#if CONFIG_NXP_WIFI_11AC
#define CONFIG_11AC CONFIG_NXP_WIFI_11AC
#endif

#if CONFIG_NXP_WIFI_ENABLE_HTTPSERVER
#define CONFIG_ENABLE_HTTPSERVER CONFIG_NXP_WIFI_ENABLE_HTTPSERVER
#endif

#if CONFIG_NXP_WIFI_TX_RX_ZERO_COPY
#define CONFIG_TX_RX_ZERO_COPY CONFIG_NXP_WIFI_TX_RX_ZERO_COPY
#endif

#if CONFIG_NXP_WIFI_CAPA
#define CONFIG_WIFI_CAPA CONFIG_NXP_WIFI_CAPA
#endif

#if CONFIG_NXP_WIFI_WMM_UAPSD
#define CONFIG_WMM_UAPSD CONFIG_NXP_WIFI_WMM_UAPSD
#endif

#if CONFIG_NXP_WIFI_GET_LOG
#define CONFIG_WIFI_GET_LOG CONFIG_NXP_WIFI_GET_LOG
#endif

#if CONFIG_NXP_WIFI_TX_PER_TRACK
#define CONFIG_WIFI_TX_PER_TRACK CONFIG_NXP_WIFI_TX_PER_TRACK
#endif

#if CONFIG_NXP_WIFI_CSI
#define CONFIG_CSI CONFIG_NXP_WIFI_CSI
#endif

#if CONFIG_NXP_WIFI_RESET
#define CONFIG_WIFI_RESET CONFIG_NXP_WIFI_RESET
#endif

#if CONFIG_NXP_WIFI_NET_MONITOR
#define CONFIG_NET_MONITOR CONFIG_NXP_WIFI_NET_MONITOR
#endif

#if CONFIG_NXP_WIFI_ECSA
#define CONFIG_ECSA CONFIG_NXP_WIFI_ECSA
#endif

#if CONFIG_NXP_WIFI_UNII4_BAND_SUPPORT
#define CONFIG_UNII4_BAND_SUPPORT CONFIG_NXP_WIFI_UNII4_BAND_SUPPORT
#endif

#if CONFIG_NXP_WIFI_TSP
#define CONFIG_TSP CONFIG_NXP_WIFI_TSP
#endif

#if CONFIG_NXP_WIFI_11AX_TWT
#define CONFIG_11AX_TWT CONFIG_NXP_WIFI_11AX_TWT
#endif

#if CONFIG_NXP_WIFI_COMPRESS_TX_PWTBL
#define CONFIG_COMPRESS_TX_PWTBL CONFIG_NXP_WIFI_COMPRESS_TX_PWTBL
#endif

#if CONFIG_NXP_WIFI_COMPRESS_RU_TX_PWTBL
#define CONFIG_COMPRESS_RU_TX_PWTBL CONFIG_NXP_WIFI_COMPRESS_RU_TX_PWTBL
#endif

#if CONFIG_NXP_WIFI_MAX_PRIO
#define CONFIG_WIFI_MAX_PRIO CONFIG_NXP_WIFI_MAX_PRIO
#endif

#if CONFIG_NXP_WIFI_IPS
#define CONFIG_IPS CONFIG_NXP_WIFI_IPS
#endif

#if CONFIG_NXP_WIFI_EXT_SCAN_SUPPORT
#define CONFIG_EXT_SCAN_SUPPORT CONFIG_NXP_WIFI_EXT_SCAN_SUPPORT
#endif

#if CONFIG_NXP_WIFI_SCAN_WITH_RSSIFILTER
#define CONFIG_SCAN_WITH_RSSIFILTER CONFIG_NXP_WIFI_SCAN_WITH_RSSIFILTER
#endif

#if CONFIG_NXP_WIFI_DTIM_PERIOD
#define CONFIG_WIFI_DTIM_PERIOD CONFIG_NXP_WIFI_DTIM_PERIOD
#endif

#if CONFIG_NXP_WIFI_RX_ABORT_CFG
#define CONFIG_RX_ABORT_CFG CONFIG_NXP_WIFI_RX_ABORT_CFG
#endif

#if CONFIG_NXP_WIFI_RX_ABORT_CFG_EXT
#define CONFIG_RX_ABORT_CFG_EXT CONFIG_NXP_WIFI_RX_ABORT_CFG_EXT
#endif

#if CONFIG_NXP_WIFI_CCK_DESENSE_CFG
#define CONFIG_CCK_DESENSE_CFG CONFIG_NXP_WIFI_CCK_DESENSE_CFG
#endif

#if CONFIG_NXP_WIFI_MEM_ACCESS
#define CONFIG_WIFI_MEM_ACCESS CONFIG_NXP_WIFI_MEM_ACCESS
#endif

#if CONFIG_NXP_WIFI_REG_ACCESS
#define CONFIG_WIFI_REG_ACCESS CONFIG_NXP_WIFI_REG_ACCESS
#endif

#if CONFIG_NXP_WIFI_SUBSCRIBE_EVENT_SUPPORT
#define CONFIG_SUBSCRIBE_EVENT_SUPPORT CONFIG_NXP_WIFI_SUBSCRIBE_EVENT_SUPPORT
#endif

#if CONFIG_NXP_WIFI_TX_RX_HISTOGRAM
#define CONFIG_TX_RX_HISTOGRAM CONFIG_NXP_WIFI_TX_RX_HISTOGRAM
#endif

#if CONFIG_NXP_WIFI_COEX_DUTY_CYCLE
#define CONFIG_COEX_DUTY_CYCLE CONFIG_NXP_WIFI_COEX_DUTY_CYCLE
#endif

#if CONFIG_NXP_WIFI_MMSF
#define CONFIG_MMSF CONFIG_NXP_WIFI_MMSF
#endif

#if CONFIG_NXP_WIFI_USB_FILE_ACCESS
#define CONFIG_USB_FILE_ACCESS CONFIG_NXP_WIFI_USB_FILE_ACCESS
#endif

#if CONFIG_NXP_WIFI_SCAN_CHANNEL_GAP_TIME
#define CONFIG_SCAN_CHANNEL_GAP_TIME CONFIG_NXP_WIFI_SCAN_CHANNEL_GAP_TIME
#endif

#if CONFIG_NXP_WIFI_INACTIVITY_TIMEOUT_EXT
#define CONFIG_INACTIVITY_TIMEOUT_EXT CONFIG_NXP_WIFI_INACTIVITY_TIMEOUT_EXT
#endif

#if CONFIG_NXP_WIFI_RF_TEST_MODE
#define CONFIG_RF_TEST_MODE CONFIG_NXP_WIFI_RF_TEST_MODE
#endif

#if CONFIG_NXP_WIFI_IMD3_CFG
#define CONFIG_IMD3_CFG CONFIG_NXP_WIFI_IMD3_CFG
#endif

#if CONFIG_NXP_WIFI_ANT_DETECT
#define CONFIG_ANT_DETECT CONFIG_NXP_WIFI_ANT_DETECT
#endif

#if CONFIG_NXP_WIFI_WLAN_CALDATA_1ANT
#define CONFIG_WLAN_CALDATA_1ANT CONFIG_NXP_WIFI_WLAN_CALDATA_1ANT
#endif

#if CONFIG_NXP_WIFI_WLAN_CALDATA_1ANT_WITH_DIVERSITY
#define CONFIG_WLAN_CALDATA_1ANT_WITH_DIVERSITY CONFIG_NXP_WIFI_WLAN_CALDATA_1ANT_WITH_DIVERSITY
#endif

#if CONFIG_NXP_WIFI_WLAN_CALDATA_3ANT_DIVERSITY
#define CONFIG_WLAN_CALDATA_3ANT_DIVERSITY CONFIG_NXP_WIFI_WLAN_CALDATA_3ANT_DIVERSITY
#endif

#if CONFIG_NXP_WIFI_CLOCKSYNC
#define CONFIG_CLOCKSYNC CONFIG_NXP_WIFI_CLOCKSYNC
#endif

#if CONFIG_NXP_WIFI_WMM
#define CONFIG_WMM CONFIG_NXP_WIFI_WMM
#endif

#if CONFIG_NXP_WIFI_IPV6
#define CONFIG_IPV6 CONFIG_NXP_WIFI_IPV6
#endif

#if CONFIG_NET_IF_UNICAST_IPV6_ADDR_COUNT
#define CONFIG_MAX_IPV6_ADDRESSES CONFIG_NET_IF_UNICAST_IPV6_ADDR_COUNT
#endif

#if CONFIG_NXP_WIFI_5GHz_SUPPORT
#define CONFIG_5GHz_SUPPORT CONFIG_NXP_WIFI_5GHz_SUPPORT
#endif

#if CONFIG_NXP_WIFI_HOST_SLEEP
#define CONFIG_HOST_SLEEP CONFIG_NXP_WIFI_HOST_SLEEP
#endif

#if CONFIG_PM
#define CONFIG_POWER_MANAGER CONFIG_PM
#endif

#if CONFIG_NXP_WIFI_ROAMING
#define CONFIG_ROAMING CONFIG_NXP_WIFI_ROAMING
#endif

#if CONFIG_NXP_WIFI_CLOUD_KEEP_ALIVE
#define CONFIG_CLOUD_KEEP_ALIVE CONFIG_NXP_WIFI_CLOUD_KEEP_ALIVE
#endif

#if CONFIG_NXP_WIFI_MEF_CFG
#define CONFIG_MEF_CFG CONFIG_NXP_WIFI_MEF_CFG
#endif

#if CONFIG_NXP_WIFI_TURBO_MODE
#define CONFIG_TURBO_MODE CONFIG_NXP_WIFI_TURBO_MODE
#endif

#if CONFIG_NXP_WIFI_EU_CRYPTO
#define CONFIG_EU_CRYPTO CONFIG_NXP_WIFI_EU_CRYPTO
#endif

#if CONFIG_NXP_WIFI_FIPS
#define CONFIG_FIPS CONFIG_NXP_WIFI_FIPS
#endif

#if CONFIG_NXP_WIFI_OWE
#define CONFIG_OWE CONFIG_NXP_WIFI_OWE
#endif

#if CONFIG_NXP_WIFI_11K
#define CONFIG_11K CONFIG_NXP_WIFI_11K
#endif

#if CONFIG_NXP_WIFI_11V
#define CONFIG_11V CONFIG_NXP_WIFI_11V
#endif

#if CONFIG_NXP_WIFI_11R
#define CONFIG_11R CONFIG_NXP_WIFI_11R
#endif

#if CONFIG_NXP_WIFI_EU_CRYPTO
#define CONFIG_WIFI_EU_CRYPTO CONFIG_NXP_WIFI_EU_CRYPTO
#endif

#if CONFIG_NXP_WIFI_CLOCKSYNC
#define CONFIG_WIFI_CLOCKSYNC CONFIG_NXP_WIFI_CLOCKSYNC
#endif

#if CONFIG_NXP_WIFI_RTS_THRESHOLD
#define CONFIG_WIFI_RTS_THRESHOLD 1
#endif

#if CONFIG_NXP_WIFI_UAP_WORKAROUND_STICKY_TIM
#define CONFIG_UAP_WORKAROUND_STICKY_TIM CONFIG_NXP_WIFI_UAP_WORKAROUND_STICKY_TIM
#endif

#if CONFIG_NXP_WIFI_AUTO_NULL_TX
#define CONFIG_AUTO_NULL_TX CONFIG_NXP_WIFI_AUTO_NULL_TX
#endif

#if CONFIG_NXP_WIFI_ENABLE_ERROR_LOGS
#define CONFIG_ENABLE_ERROR_LOGS CONFIG_NXP_WIFI_ENABLE_ERROR_LOGS
#endif

#if CONFIG_NXP_WIFI_ENABLE_WARNING_LOGS
#define CONFIG_ENABLE_WARNING_LOGS CONFIG_NXP_WIFI_ENABLE_WARNING_LOGS
#endif

#if CONFIG_NXP_WIFI_DEBUG_BUILD
#define CONFIG_DEBUG_BUILD CONFIG_NXP_WIFI_DEBUG_BUILD
#endif

#if CONFIG_NXP_WIFI_OS_DEBUG
#define CONFIG_OS_DEBUG CONFIG_NXP_WIFI_OS_DEBUG
#endif

#if CONFIG_NXP_WIFI_NET_DEBUG
#define CONFIG_NET_DEBUG CONFIG_NXP_WIFI_NET_DEBUG
#endif

#if CONFIG_NXP_WIFI_WLCMGR_DEBUG
#define CONFIG_WLCMGR_DEBUG CONFIG_NXP_WIFI_WLCMGR_DEBUG
#endif

#if CONFIG_NXP_WIFI_EXTRA_DEBUG
#define CONFIG_WIFI_EXTRA_DEBUG CONFIG_NXP_WIFI_EXTRA_DEBUG
#endif

#if CONFIG_NXP_WIFI_UAP_DEBUG
#define CONFIG_WIFI_UAP_DEBUG CONFIG_NXP_WIFI_UAP_DEBUG
#endif

#if CONFIG_NXP_WIFI_EVENTS_DEBUG
#define CONFIG_WIFI_EVENTS_DEBUG CONFIG_NXP_WIFI_EVENTS_DEBUG
#endif

#if CONFIG_NXP_WIFI_CMD_RESP_DEBUG
#define CONFIG_WIFI_CMD_RESP_DEBUG CONFIG_NXP_WIFI_CMD_RESP_DEBUG
#endif

#if CONFIG_NXP_WIFI_PS_DEBUG
#define CONFIG_WIFI_PS_DEBUG CONFIG_NXP_WIFI_PS_DEBUG
#endif

#if CONFIG_NXP_WIFI_SCAN_DEBUG
#define CONFIG_WIFI_SCAN_DEBUG CONFIG_NXP_WIFI_SCAN_DEBUG
#endif

#if CONFIG_NXP_WIFI_PKT_DEBUG
#define CONFIG_WIFI_PKT_DEBUG CONFIG_NXP_WIFI_PKT_DEBUG
#endif

#if CONFIG_NXP_WIFI_IO_INFO_DUMP
#define CONFIG_WIFI_IO_INFO_DUMP CONFIG_NXP_WIFI_IO_INFO_DUMP
#endif

#if CONFIG_NXP_WIFI_IO_DEBUG
#define CONFIG_WIFI_IO_DEBUG CONFIG_NXP_WIFI_IO_DEBUG
#endif

#if CONFIG_NXP_WIFI_IO_DUMP
#define CONFIG_WIFI_IO_DUMP CONFIG_NXP_WIFI_IO_DUMP
#endif

#if CONFIG_NXP_WIFI_MEM_DEBUG
#define CONFIG_WIFI_MEM_DEBUG CONFIG_NXP_WIFI_MEM_DEBUG
#endif

#if CONFIG_NXP_WIFI_AMPDU_DEBUG
#define CONFIG_WIFI_AMPDU_DEBUG CONFIG_NXP_WIFI_AMPDU_DEBUG
#endif

#if CONFIG_NXP_WIFI_TIMER_DEBUG
#define CONFIG_WIFI_TIMER_DEBUG CONFIG_NXP_WIFI_TIMER_DEBUG
#endif

#if CONFIG_NXP_WIFI_SDIO_DEBUG
#define CONFIG_WIFI_SDIO_DEBUG CONFIG_NXP_WIFI_SDIO_DEBUG
#endif

#if CONFIG_NXP_WIFI_SDIO_IO_DEBUG
#define CONFIG_SDIO_IO_DEBUG CONFIG_NXP_WIFI_SDIO_IO_DEBUG
#endif

#if CONFIG_NXP_WIFI_FWDNLD_IO_DEBUG
#define CONFIG_FWDNLD_IO_DEBUG CONFIG_NXP_WIFI_FWDNLD_IO_DEBUG
#endif

#if CONFIG_NXP_WIFI_FW_DEBUG
#define CONFIG_WIFI_FW_DEBUG CONFIG_NXP_WIFI_FW_DEBUG
#endif

#if CONFIG_NXP_WIFI_FW_VDLL_DEBUG
#define CONFIG_FW_VDLL_DEBUG CONFIG_NXP_WIFI_FW_VDLL_DEBUG
#endif

#if CONFIG_NXP_WIFI_DHCP_SERVER_DEBUG
#define CONFIG_DHCP_SERVER_DEBUG CONFIG_NXP_WIFI_DHCP_SERVER_DEBUG
#endif

#if CONFIG_NXP_WIFI_SMOKE_TESTS
#define CONFIG_WIFI_SMOKE_TESTS CONFIG_NXP_WIFI_SMOKE_TESTS
#endif

#if CONFIG_NXP_WIFI_SM_IP_DHCP
#define IP_USE_DHCP CONFIG_NXP_WIFI_SM_IP_DHCP
#endif

#if CONFIG_NXP_WIFI_SIGMA_AGENT
#define CONFIG_SIGMA_AGENT CONFIG_NXP_WIFI_SIGMA_AGENT
#endif

#if CONFIG_NXP_WIFI_CUSTOM_CALDATA
#define CONFIG_CUSTOM_CALDATA CONFIG_NXP_WIFI_CUSTOM_CALDATA
#endif

#if (CONFIG_NXP_WIFI_8978) || (CONFIG_NXP_WIFI_8987) || (CONFIG_NXP_WIFI_9177)

#define CONFIG_GTK_REKEY_OFFLOAD 0

#define CONFIG_FW_VDLL 1

#endif

#if (CONFIG_NXP_WIFI_9177)
#define CONFIG_TCP_ACK_ENH 1
#endif

#if CONFIG_11AX

#if !CONFIG_11K
#define CONFIG_11K 1
#endif

#if !CONFIG_11V
#define CONFIG_11V 1
#endif

#if !CONFIG_WPA_SUPP
#define CONFIG_DRIVER_MBO 1
#endif

#endif

#ifdef __cplusplus
}
#endif

#endif /* __NXP_WIFI_H__ */
