#-----------------------------------------------------------------------------
#
# ITKConfig.cmake - ITK CMake configuration file for external projects.
#
# This file is configured by ITK and used by the UseITK.cmake module
# to load ITK's settings for an external project.
#
# ITK components can be specified when using the CMake function `find_package()`
# E.g. find_package(ITK COMPONENTS ITKCommon ITKIOImageBase OPTIONAL_COMPONENTS ITKIONRRD )
#
# The components listed in this call must be ITK module names or factories
# (e.g. ITKImageIO, ITKTransformIO). Factories allow the user to load all the
# modules of a specific type (e.g. ImageIO, TransformIO) without having to
# specify them individually.
# See `itk_module_config()` documentation for more information about factory modules.


# Compute the installation prefix from this ITKConfig.cmake file location.
get_filename_component(ITK_INSTALL_PREFIX "${CMAKE_CURRENT_LIST_FILE}" PATH)
get_filename_component(ITK_INSTALL_PREFIX "${ITK_INSTALL_PREFIX}" PATH)
get_filename_component(ITK_INSTALL_PREFIX "${ITK_INSTALL_PREFIX}" PATH)
get_filename_component(ITK_INSTALL_PREFIX "${ITK_INSTALL_PREFIX}" PATH)
set(ITK_MODULES_DIR "${ITK_INSTALL_PREFIX}/lib/cmake/ITK/Modules")

# The C and C++ flags added by ITK to the cmake-configured flags.
set(ITK_REQUIRED_C_FLAGS " -mthreads")
set(ITK_REQUIRED_CXX_FLAGS " -mthreads")
set(ITK_REQUIRED_LINK_FLAGS " -mthreads")

# The ITK version number
set(ITK_VERSION_MAJOR "5")
set(ITK_VERSION_MINOR "4")
set(ITK_VERSION_PATCH "4")

# If ITK was built with version 4 compatibility features.
set(ITKV4_COMPATIBILITY "OFF")

# Remove all legacy code completely.
set(ITK_LEGACY_REMOVE "ON")

# Silence all legacy code messages.
set(ITK_LEGACY_SILENT "OFF")

# Remove code that will become legacy in future releases completely.
set(ITK_FUTURE_LEGACY_REMOVE "ON")

# ITK's CMake directory with modules ITK uses.
set(ITK_CMAKE_DIR "${ITK_INSTALL_PREFIX}/lib/cmake/ITK")

# The location of the UseITK.cmake file.
set(ITK_USE_FILE "${ITK_INSTALL_PREFIX}/lib/cmake/ITK/UseITK.cmake")

# Whether ITK was built with shared libraries.
set(ITK_BUILD_SHARED "ON")

# Export the library build type (SHARED or STATIC) for external builds
set(ITK_LIBRARY_BUILD_TYPE "SHARED")

# Whether ITK links to MSVC's static CRT (/MT and /MTd).
set(ITK_MSVC_STATIC_CRT "")

# Whether ITK examples were built.
set(ITK_BUILD_EXAMPLES "OFF")

# Whether ITK documentation was built.
set(ITK_BUILD_DOCUMENTATION "")

# List of available ITK modules.
set(ITK_MODULES_ENABLED "ITKDoubleConversion;ITKEigen3;ITKKWSys;ITKVNL;ITKVNLInstantiation;ITKCommon;ITKFiniteDifference;ITKImageFilterBase;ITKCurvatureFlow;ITKImageAdaptors;ITKNetlib;ITKStatistics;ITKTransform;ITKImageFunction;ITKImageGrid;ITKAnisotropicSmoothing;ITKImageCompose;ITKMesh;ITKZLIB;ITKMetaIO;ITKSpatialObjects;ITKImageStatistics;ITKPath;ITKImageIntensity;ITKImageLabel;ITKLabelMap;ITKThresholding;ITKConnectedComponents;ITKMathematicalMorphology;ITKBinaryMathematicalMorphology;ITKNarrowBand;ITKDistanceMap;ITKQuadEdgeMesh;ITKFastMarching;ITKIOImageBase;ITKImageCompare;ITKFFT;ITKConvolution;ITKImageSources;ITKSmoothing;ITKImageGradient;ITKImageFeature;ITKOptimizers;ITKSignedDistanceFunction;ITKLevelSets;ITKAntiAlias;ITKPolynomials;ITKBiasCorrection;ITKClassifiers;ITKColormap;ITKDICOMParser;ITKDeconvolution;ITKDeformableMesh;ITKDenoising;ITKDiffusionTensorImage;ITKDisplacementField;ITKEigen;ITKExpat;ITKGDCM;ITKNIFTI;ITKGIFTI;ITKGPUCommon;ITKGPUFiniteDifference;ITKGPUAnisotropicSmoothing;ITKGPUImageFilterBase;ITKGPURegistrationCommon;ITKRegistrationCommon;ITKPDEDeformableRegistration;ITKGPUPDEDeformableRegistration;ITKGPUSmoothing;ITKGPUThresholding;ITKGoogleTest;ITKHDF5;ITKIOBMP;ITKIOGDCM;ITKIOGIPL;ITKJPEG;ITKIOJPEG;ITKVoronoi;ITKIOMeshBase;ITKIOMeshBYU;ITKIOMeshFreeSurfer;ITKIOMeshGifti;ITKIOMeshOBJ;ITKIOMeshOFF;ITKIOMeshVTK;ITKIOMeta;ITKIONIFTI;ITKNrrdIO;ITKIONRRD;ITKPNG;ITKIOPNG;ITKTIFF;ITKIOTIFF;ITKIOVTK;ITKImageFrequency;ITKImageFusion;ITKImageNoise;ITKKLMRegionGrowing;ITKLIBLBFGS;ITKLabelVoting;ITKLevelSetsv4;ITKMarkovRandomFieldsClassifiers;ITKOptimizersv4;ITKMetricsv4;ITKQuadEdgeMeshFiltering;ITKRegionGrowing;ITKRegistrationMethodsv4;ITKSpatialFunction;ITKSuperPixel;ITKTestKernel;ITKVTK;ITKVideoCore;ITKVideoIO;ITKVideoBridgeOpenCV;ITKVideoFiltering;ITKVtkGlue;ITKWatersheds")

# Import ITK targets.
set(ITK_CONFIG_TARGETS_FILE "${ITK_INSTALL_PREFIX}/lib/cmake/ITK/ITKTargets.cmake")
if(NOT ITK_TARGETS_IMPORTED)
  set(ITK_TARGETS_IMPORTED 1)
  include("${ITK_CONFIG_TARGETS_FILE}")
endif()

# Load module interface macros.
include("${ITK_INSTALL_PREFIX}/lib/cmake/ITK/ITKModuleAPI.cmake")
# Load requested modules and their dependencies into variables:
#  ITK_LIBRARIES       = Libraries to link
#  ITK_INCLUDE_DIRS    = Header file search path
#  ITK_LIBRARY_DIRS    = Library search path (for outside dependencies)
#  ITK_RUNTIME_LIBRARY_DIRS = Runtime linker search path
#  ITK_FACTORY_NAMES = List of <module>::<factory>::<format>
#  ITK_FACTORY_LIST  = List of factories set
#  ITK_<factory_name> = List of formats for each factory
itk_module_config(ITK ${ITK_MODULES_ENABLED})

# Compute set of requested modules.
if(ITK_FIND_COMPONENTS)
  # Specific modules required by find_package(ITK) or optional and available.
  set(ITK_MODULES_REQUESTED "")
  foreach(M ${ITK_FIND_COMPONENTS})
    if(ITK_FIND_REQUIRED_${M} OR M IN_LIST ITK_MODULES_ENABLED)
      LIST(APPEND ITK_MODULES_REQUESTED "${M}")
    endif()
  endforeach()
  itk_module_config(ITK ${ITK_MODULES_REQUESTED})
else()
  set(ITK_MODULES_REQUESTED ${ITK_MODULES_ENABLED})
endif()

# Load factory registration manager functions
include( "${ITK_CMAKE_DIR}/ITKFactoryRegistration.cmake" )

# Add configuration with FFTW
set(ITK_USE_FFTWD "ON")
set(ITK_USE_FFTWF "ON")
set(ITK_USE_SYSTEM_FFTW "ON")
set(ITK_FFTW_INCLUDE_PATH "${ITK_INSTALL_PREFIX}/include")
set(ITK_FFTW_LIBDIR "${ITK_INSTALL_PREFIX}/lib")

# Add FFTW include and library directories
if (ITK_USE_FFTWF OR ITK_USE_FFTWD)
  set(ITK_INCLUDE_DIRS ${ITK_INCLUDE_DIRS} "${ITK_FFTW_INCLUDE_PATH}")
  set(ITK_LIBRARY_DIRS ${ITK_LIBRARY_DIRS} "${ITK_FFTW_LIBDIR}")
endif()

# Add configuration with GPU
set(ITK_USE_GPU "OFF")

# Wrapping
set(ITK_WRAPPING "OFF")
# ITK_WRAP_DOC is disabled by default.

if( NOT DEFINED ITK_WRAP_PYTHON)
  set(ITK_WRAP_PYTHON "OFF")
endif()

# Set up the rest of the variables that WrapITK was built with.
set(ITK_WRAP_unsigned_char OFF)
set(ITK_WRAP_unsigned_short OFF)
set(ITK_WRAP_unsigned_long OFF)
set(ITK_WRAP_unsigned_long_long OFF)
set(ITK_WRAP_signed_char OFF)
set(ITK_WRAP_signed_short OFF)
set(ITK_WRAP_signed_long OFF)
set(ITK_WRAP_signed_long_long OFF)
set(ITK_WRAP_float OFF)
set(ITK_WRAP_double OFF)
set(ITK_WRAP_vector_float OFF)
set(ITK_WRAP_vector_double OFF)
set(ITK_WRAP_covariant_vector_float OFF)
set(ITK_WRAP_covariant_vector_double OFF)
set(ITK_WRAP_rgb_unsigned_char OFF)
set(ITK_WRAP_rgb_unsigned_short OFF)
set(ITK_WRAP_rgba_unsigned_char OFF)
set(ITK_WRAP_rgba_unsigned_short OFF)
set(ITK_WRAP_complex_float OFF)
set(ITK_WRAP_complex_double OFF)
set(ITK_WRAP_IMAGE_DIMS "")
set(ITK_WRAP_VECTOR_COMPONENTS "")

set(ITK_WRAP_PYTHON_VERSION "")
