from typing import Literal

from pymeeus.Angle import Angle
from pymeeus.Epoch import Epoch

class Sun:
    def __init__(self) -> None: ...
    @staticmethod
    def true_longitude_coarse(epoch: Epoch) -> tuple[Angle, float]: ...
    @staticmethod
    def apparent_longitude_coarse(epoch: Epoch) -> tuple[Angle, float]: ...
    @staticmethod
    def apparent_rightascension_declination_coarse(epoch: Epoch) -> tuple[Angle, Angle, float]: ...
    @staticmethod
    def geometric_geocentric_position(epoch: Epoch, tofk5: bool = True) -> tuple[Angle, Angle, float]: ...
    @staticmethod
    def apparent_geocentric_position(epoch: Epoch, nutation: bool = True) -> tuple[Angle, Angle, float]: ...
    @staticmethod
    def rectangular_coordinates_mean_equinox(epoch: Epoch) -> tuple[float, float, float]: ...
    @staticmethod
    def rectangular_coordinates_j2000(epoch: Epoch) -> tuple[float, float, float]: ...
    @staticmethod
    def rectangular_coordinates_b1950(epoch: Epoch) -> tuple[float, float, float]: ...
    @staticmethod
    def rectangular_coordinates_equinox(epoch: Epoch, equinox_epoch: Epoch) -> tuple[float, float, float]: ...
    @staticmethod
    def get_equinox_solstice(year: int, target: Literal["spring", "summer", "autumn", "winter"] = "spring") -> Epoch: ...
    @staticmethod
    def equation_of_time(epoch: Epoch) -> tuple[int, float]: ...
    @staticmethod
    def ephemeris_physical_observations(epoch: Epoch) -> tuple[Angle, Angle, Angle]: ...
    @staticmethod
    def beginning_synodic_rotation(number: int) -> Epoch: ...

def main() -> None: ...
