/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.xades;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.signature.BaseSignatureOptions;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.signature.SignatureGenerator;
import it.actalis.ellips.capi.signature.SignatureOptions;
import it.actalis.ellips.capi.xades.XadesDocument;
import it.actalis.ellips.capi.xades.XadesSignatureOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.X509Certificate;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class XadesSignatureGenerator
extends SignatureGenerator<XadesSignatureOptions, BaseSignatureOptions> {
    protected void innerSign(XadesSignatureOptions options) throws CapiException {
        XadesDocument doc = null;
        X509Certificate x509Cert = this.retrieveCert(options);
        PrivateKey privateKey = this.retrieveKey(options);
        Provider prov = this.retrieveProvider(options);
        OutputStream os = null;
        try {
            doc = new XadesDocument(options.getInput());
            Document xml_doc = doc.createXadesSignature(options, x509Cert, privateKey, prov);
            os = options.getOutput().getAsOutputStream();
            this.toStream(xml_doc, os);
            os.flush();
        }
        catch (IOException ex) {
            throw new CapiException("Unable to sign XML document IOException", 1003, (Throwable)ex);
        }
        catch (TransformerException ex) {
            throw new CapiException("Unable to sign XML document TransformerException", 1003, (Throwable)ex);
        }
    }

    protected void innerAddSign(XadesSignatureOptions options) throws CapiException {
        this.innerSign(options);
    }

    protected void innerUpdateSign(BaseSignatureOptions option) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void toStream(Document docDest, OutputStream os) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(docDest), new StreamResult(os));
    }

    protected void parameterValidation(XadesSignatureOptions option) throws CapiException {
        super.parameterValidation((SignatureOptions)option);
        if (option.getDigestAlgorithm() == DigestAlgorithm.SHA3_224 || option.getDigestAlgorithm() == DigestAlgorithm.SHA3_256 || option.getDigestAlgorithm() == DigestAlgorithm.SHA3_384 || option.getDigestAlgorithm() == DigestAlgorithm.SHA3_512) {
            throw new CapiException("Unsupported Digest Algorithm", 3011);
        }
    }
}

