/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.xades;

import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.xades.XadesStepSignatureCanonicalizationMethodCheck;
import esecurity.validator.steps.xades.XadesStepSignatureCorrectTransformationCheck;
import esecurity.validator.steps.xades.XadesStepSignatureDPCM45HashAlgoCheck;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import java.util.LinkedList;

public class XadesStepSignatureDPCM45Compliance
extends SingleValidationSubStepImpl {
    public XadesStepSignatureDPCM45Compliance() {
        super(ValidationType.SIGNATURE);
        this.subSteps.add(new XadesStepSignatureDPCM45HashAlgoCheck());
        this.subSteps.add(new XadesStepSignatureCanonicalizationMethodCheck());
        this.subSteps.add(new XadesStepSignatureCorrectTransformationCheck());
    }

    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        Date validationDate;
        if ((param.getProfile() == ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE || param.getProfile() == ValidationProfile.GRAPHOMETRIC_SIGNATURE_PROFILE) && (validationDate = param.getCalculatedValidationDate().getDate()).after(Constants.DPCM_CNIPA_45_2009) && validationDate.before(Constants.DPCM_AGID_121_2019)) {
            MessageLevel level = StepsUtils.retrieveWorstLevel(subMessage);
            if (level.equals((Object)MessageLevel.ERROR)) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), level, (EsecurityMessage)ValidatorMessageEnum.ES0005_NOCNIPA45, new Object[0]);
            }
            if (level.equals((Object)MessageLevel.WARNING)) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), level, (EsecurityMessage)ValidatorMessageEnum.WS0001_NOCNIPA45VALID, new Object[0]);
            }
        }
        return null;
    }
}

