/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pkcs7;

import esecurity.dts.Client;
import esecurity.dts.DTSClient;
import esecurity.dts.TimeStampToken;
import esecurity.dts.util.IllegalParamException;
import it.actalis.ellips.capi.cms.CadesSignedDataProxy;
import it.actalis.ellips.capi.core.Base64OutputStream;
import it.actalis.ellips.capi.core.CapiError;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.HttpsClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.net.HTTP_URLConnection;
import it.actalis.ellips.capi.pkcs7.CapiSignerInformation;
import it.actalis.ellips.capi.pkcs7.CounterSignedEnvelope;
import it.actalis.ellips.capi.pkcs7.RFC5652.VerificationResult;
import it.actalis.ellips.capi.pkcs7.SignedEnvelope;
import it.actalis.ellips.capi.pkcs7.VerRsContentSignerBuilder;
import it.actalis.ellips.capi.pkcs7.VerRsSignerInfoGenerator;
import it.actalis.ellips.capi.pkcs7.VerifyInfo;
import it.actalis.ellips.capi.provider.Token;
import it.actalis.ellips.util.File;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.utils.Constants;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX500NameUtil;
import org.bouncycastle.cms.CMSAbsentContent;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSProcessableFile;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.Streams;
import org.slf4j.Logger;

public class StreamSignedEnvelope {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final int IMPLICIT = 1;
    public static final int EXPLICIT = 2;
    public static final String SHA1 = SignedEnvelope.SHA1;
    public static final String SHA256 = SignedEnvelope.SHA256;
    private CMSSignedDataParser pkcs7SignedData = null;
    private MessageDigest msgDigest = null;
    private MessageDigest msgDigest256 = null;
    private String msgDigestToBeUsed = SHA256;
    private List<String> signerDnVector = new LinkedList<String>();
    private List<Certificate> signerCertVector = new LinkedList<Certificate>();
    private List<VerifyInfo> signerVerifyVector = new LinkedList<VerifyInfo>();
    protected List<X509Certificate> certsVector = new LinkedList<X509Certificate>();
    private java.io.File fileContent = null;
    private int status = -1;
    private static final int ST_CREATE_NEW = 0;
    private static final int ST_CERT_ADDED = 1;
    private static final int ST_SIGN_ADDED = 2;
    private static final int ST_PARSED = 3;
    private String TSA = null;
    private String TSAhashAlgorithm = null;
    private String TSApolicy = null;
    private boolean TSAcertReq = true;
    private HttpsClient TSAhttps = null;
    private String TSABasicAuthUser = null;
    private String TSABasicAuthPassword = null;
    private DTSClient TSAClient = null;
    private int mode = 1;
    private boolean includeSigningTime = true;

    public StreamSignedEnvelope(InputStream der_encoded, OutputStream save_internal_doc) throws CapiException {
        try {
            if (der_encoded == null) {
                throw new CapiException("Null data", 1001);
            }
            this.mode = 1;
            this.checkRange("mode", this.mode, 1, 1);
            this.instanceDigest();
            this.parseImplicit(der_encoded, save_internal_doc);
            this.setCertificatesAndSigners();
            logger.debug("getting signers DN OK");
            this.status = 3;
        }
        catch (CapiException e) {
            throw e;
        }
        finally {
            try {
                der_encoded.close();
            }
            catch (Exception exception) {}
            try {
                if (save_internal_doc != null) {
                    save_internal_doc.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public StreamSignedEnvelope(InputStream der_encoded, InputStream original_doc) throws CapiException {
        try {
            if (der_encoded == null) {
                throw new CapiException("Null data", 1001);
            }
            if (original_doc == null) {
                throw new CapiException("Null data", 1001);
            }
            this.mode = 2;
            this.checkRange("mode", this.mode, 2, 2);
            this.instanceDigest();
            this.parseExplicit(der_encoded, original_doc);
            this.setCertificatesAndSigners();
            logger.debug("decode > Getting signers DN OK");
            this.status = 3;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Exception " + e.getMessage(), 50050);
        }
        finally {
            try {
                der_encoded.close();
            }
            catch (Exception exception) {}
            try {
                original_doc.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDERSignedData(InputStream derEncoded) {
        ASN1SequenceParser asn1seq = null;
        try {
            logger.debug("[isSignedData] Checking if content is a DER Signed Data ...");
            ASN1StreamParser in = new ASN1StreamParser(derEncoded);
            asn1seq = (ASN1SequenceParser)in.readObject();
            ASN1Encodable obj = asn1seq.readObject();
            if (obj == null || !(obj instanceof ASN1ObjectIdentifier)) {
                throw new CapiException("Invalid ContentInfo", 50040);
            }
            ASN1ObjectIdentifier contentType = (ASN1ObjectIdentifier)obj;
            if (contentType.getId().compareToIgnoreCase(CMSObjectIdentifiers.signedData.getId()) != 0) {
                throw new CapiException(contentType.getId() + "  is not SignedData OID", 50040);
            }
            logger.debug("[isSignedData] Found SignedData OID Content Type.");
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (CapiException e) {
            logger.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                derEncoded.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPEMSignedData(InputStream pemEncoded) {
        boolean bl;
        boolean bl2;
        ByteArrayInputStream bIn = null;
        BufferedReader bufReader = null;
        Object fis = null;
        try {
            String line;
            byte[] buf = new byte[256];
            int bytesRead = pemEncoded.read(buf, 0, 256);
            String tmp = new String(buf);
            bIn = new ByteArrayInputStream(buf);
            bufReader = new BufferedReader(new InputStreamReader(bIn));
            if (tmp.startsWith("-----BEGIN PKCS7-----")) {
                bufReader.readLine();
            }
            if ((line = bufReader.readLine()) == null || line.length() <= 40) {
                boolean bl3 = false;
                return bl3;
            }
            byte[] data = Base64.decode((String)line.substring(0, 39));
            bl2 = StreamSignedEnvelope.isDERSignedData(new ByteArrayInputStream(data));
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            bl = false;
            return bl;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            bl = false;
            return bl;
        }
        finally {
            try {
                pemEncoded.close();
            }
            catch (IOException iOException) {}
            try {
                if (bIn != null) {
                    bIn.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (bufReader != null) {
                    bufReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return bl2;
    }

    private void setCertificatesAndSigners() throws CapiException {
        logger.debug("getting certificates...");
        Store certsStore = null;
        try {
            certsStore = this.pkcs7SignedData.getCertificates();
        }
        catch (CMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("CMSException", 50050);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Exception " + e.getMessage(), 50050);
        }
        try {
            if (certsStore == null) {
                logger.debug("no certificates found!");
            }
            X509Certificate[] certsArray = Certificate.getX509CertificatesFromStore((Store)certsStore);
            this.certsVector = new Vector<X509Certificate>(Arrays.asList(certsArray));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("StoreException", 50050);
        }
        logger.debug(this.certsVector.size() + " certificates found");
        logger.debug("getting signers DN...");
        try {
            CMSAbsentContent typedData;
            SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
            ArrayList<CapiSignerInformation> signerColl = new ArrayList<CapiSignerInformation>();
            if (this.mode == 2) {
                typedData = new CMSAbsentContent();
            } else {
                byte[] data = null;
                try {
                    data = IOUtils.toByteArray((InputStream)this.pkcs7SignedData.getSignedContent().getContentStream());
                }
                catch (IOException ioe) {
                    logger.error(ioe.getMessage(), (Throwable)ioe);
                }
                typedData = new CMSProcessableByteArray(data);
            }
            for (SignerInformation information : sig_infos.getSigners()) {
                signerColl.add(new CapiSignerInformation(information, (CMSTypedData)typedData));
            }
            Vector<SignerInformation> signerInformVector = new Vector<SignerInformation>(signerColl);
            logger.debug("signerInformVector size = " + signerInformVector.size());
            this.signerDnVector = new Vector<String>();
            this.signerCertVector = new Vector<Certificate>();
            this.signerVerifyVector = new Vector<VerifyInfo>();
            SignedEnvelope.verifySigners(certsStore, signerInformVector, this.signerDnVector, this.signerCertVector, this.signerVerifyVector, this.getSignedDataProxy());
        }
        catch (CMSException e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
            throw new CapiException(e1.getMessage(), 50050);
        }
    }

    public boolean hasRFC5652_SignedAttrDER(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerVerifyVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        VerifyInfo vi = this.signerVerifyVector.get(signerInfoIndex);
        return vi.hasRFC5652_SignedAttrDER();
    }

    public String[] listSigners() {
        String[] res = new String[this.signerDnVector.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.signerDnVector.get(i);
        }
        return res;
    }

    public List<Certificate> listCertificates() throws CapiException {
        try {
            LinkedList<Certificate> res = new LinkedList<Certificate>();
            for (int i = 0; i < this.certsVector.size(); ++i) {
                X509Certificate cert = this.certsVector.get(i);
                Certificate capicert = new Certificate(cert);
                res.add(capicert);
            }
            return res;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
    }

    public Certificate verify(int signerInfoIndex) throws CapiException {
        Boolean v;
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerCertVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerVerifyVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.status == 1) {
            this.setCerts();
        }
        if ((v = this.signerVerifyVector.get(signerInfoIndex).isValid()).booleanValue()) {
            return this.signerCertVector.get(signerInfoIndex);
        }
        throw new CapiException("Invalid signature", 3010, this.signerVerifyVector.get(signerInfoIndex).getReason().value());
    }

    public Certificate getSignerCertificate(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerCertVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerVerifyVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.signerCertVector.get(signerInfoIndex);
    }

    public byte[] getSignature(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector signerInformVector = new Vector(signerColl);
            if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(signerInfoIndex);
            return sigInfo.getSignature();
        }
        catch (CapiException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Cannot get signature value", 50023);
        }
    }

    public boolean hasSigningCertificateV2(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerCertVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerVerifyVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        VerifyInfo vi = this.signerVerifyVector.get(signerInfoIndex);
        return vi.hasSigningCertificateV2();
    }

    public boolean hasSigningCertificate(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerCertVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerVerifyVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        VerifyInfo vi = this.signerVerifyVector.get(signerInfoIndex);
        return vi.hasSigningCertificate();
    }

    public boolean hasNoSignerAttribute(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerCertVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerVerifyVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector signerInformVector = new Vector(signerColl);
            if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(signerInfoIndex);
            boolean has = SignedEnvelope.hasNoSignedAttribute(sigInfo);
            return has;
        }
        catch (CapiException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public int getSignatureInvalidityReason(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerCertVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerVerifyVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.signerVerifyVector.get(signerInfoIndex).getReason().value();
    }

    public VerificationResult getSignatureVerificationResult(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerCertVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerVerifyVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.signerVerifyVector.get(signerInfoIndex).getVerificationResult();
    }

    public String getSigningCertificateV2HashAlg(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.hasSigningCertificateV2(signerInfoIndex)) {
            return null;
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerCertVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerVerifyVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        Certificate signerCert = this.signerCertVector.get(signerInfoIndex);
        try {
            SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector signerInformVector = new Vector(signerColl);
            if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(signerInfoIndex);
            X509Certificate X509Cert = signerCert.getInternalCert();
            String has = SignedEnvelope.getSigningCertificateV2HashAlg(sigInfo, X509Cert);
            return has;
        }
        catch (CapiException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getSignerDigestAlg(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector signerInformVector = new Vector(signerColl);
            if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(signerInfoIndex);
            logger.debug("[getSignerDigestAlg] " + sigInfo.getDigestAlgOID());
            if (sigInfo.getDigestAlgOID().equalsIgnoreCase(SHA256)) {
                return Constants.SHA256;
            }
            if (sigInfo.getDigestAlgOID().equalsIgnoreCase(SHA1)) {
                return Constants.SHA1;
            }
            return sigInfo.getDigestAlgOID();
        }
        catch (CapiException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Cannot get signer digest algorithm oid " + e.getMessage(), 50023);
        }
    }

    public String getSignerDigestAlgOid(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector signerInformVector = new Vector(signerColl);
            if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(signerInfoIndex);
            logger.debug("[getSignerDigestAlg] " + sigInfo.getDigestAlgOID());
            return sigInfo.getDigestAlgOID();
        }
        catch (CapiException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Cannot get signer digest algorithm oid " + e.getMessage(), 50023);
        }
    }

    public String getSignerEncryptionAlg(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector signerInformVector = new Vector(signerColl);
            if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(signerInfoIndex);
            if (sigInfo.getEncryptionAlgOID().equalsIgnoreCase(CMSSignedDataGenerator.ENCRYPTION_RSA)) {
                logger.debug("[getEncryptionAlgOID] is ENCRYPTION_RSA");
                return "RSA";
            }
            logger.debug("[getEncryptionAlgOID] " + sigInfo.getEncryptionAlgOID());
            return sigInfo.getEncryptionAlgOID();
        }
        catch (CapiException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Cannot get signer encryption algorithm oid " + e.getMessage(), 50023);
        }
    }

    public String getSigningTime(int signerInfoIndex, String format) throws CapiException {
        return this.getSigningTime(signerInfoIndex, format, TimeZone.getDefault().getID());
    }

    public String getSigningTime(int signerInfoIndex, String format, String timeZone) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector signerInformVector = new Vector(signerColl);
            if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(signerInfoIndex);
            Date signTime = this.getSignatureTime(sigInfo);
            if (signTime == null) {
                return null;
            }
            return Util.formatDate((Date)signTime, (String)format, (String)timeZone);
        }
        catch (CapiException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Wrong signingTime format", 50023);
        }
    }

    public byte[] getMessageDigest(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector signerInformVector = new Vector(signerColl);
            if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(signerInfoIndex);
            return this.getMessageDigest(sigInfo);
        }
        catch (CapiException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Wrong signingTime format", 50023);
        }
    }

    private byte[] getMessageDigest(SignerInformation signer) {
        Attribute attr;
        AttributeTable atab = signer.getSignedAttributes();
        byte[] result = null;
        if (atab != null && (attr = atab.get(CMSAttributes.messageDigest)) != null) {
            ASN1OctetString t = (ASN1OctetString)attr.getAttrValues().getObjectAt(0).toASN1Primitive();
            result = t.getOctets();
        }
        return result;
    }

    private Date getSignatureTime(SignerInformation signer) {
        Attribute attr;
        AttributeTable atab = signer.getSignedAttributes();
        Date result = null;
        if (atab != null && (attr = atab.get(CMSAttributes.signingTime)) != null) {
            Time t = Time.getInstance((Object)attr.getAttrValues().getObjectAt(0).toASN1Primitive());
            result = t.getDate();
        }
        return result;
    }

    public StreamSignedEnvelope(int mode) throws CapiException {
        this.checkRange("mode", mode, 1, 2);
        this.mode = mode;
        this.status = 0;
        this.pkcs7SignedData = null;
        this.instanceDigest();
    }

    private void instanceDigest() throws CapiException {
        try {
            this.msgDigest = MessageDigest.getInstance(Constants.SHA1, ProvUtils.bcProvider);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("SHA1 Digest Algorithm not available", 50050);
        }
        try {
            this.msgDigest256 = MessageDigest.getInstance(Constants.SHA256, ProvUtils.bcProvider);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("SHA256 Digest Algorithm not available", 50050);
        }
    }

    public void addCertificate(byte[] certificate) throws CapiException {
        if (this.status != 0 && this.status != 1 && this.status != 2 && this.status != 3) {
            throw new CapiException("Certificate cannot be set", 50040);
        }
        X509Certificate cert = new Certificate(certificate).getInternalCert();
        if (!this.certsVector.contains(cert)) {
            this.certsVector.add(cert);
        }
    }

    public void setSignatureTimeStampParams(String TSAserver, String hashAlgorithm, String policy, boolean certReq, HttpsClient https) throws CapiException {
        if (hashAlgorithm != null && hashAlgorithm.compareToIgnoreCase("SHA-1") != 0 && hashAlgorithm.compareToIgnoreCase("SHA-256") != 0 && hashAlgorithm.compareToIgnoreCase("MD5") != 0) {
            throw new CapiException("Invalid hash Algorithm", 1002);
        }
        this.TSA = TSAserver;
        this.TSAhashAlgorithm = hashAlgorithm;
        this.TSApolicy = policy;
        this.TSAcertReq = certReq;
        this.TSAhttps = https;
        logger.debug("[setSignatureTimeStampParams] done.");
    }

    public void setSignatureTimeStampParams(String TSAserver, String hashAlgorithm, String policy, boolean certReq, String basicAuthUser, String basicAuthPassword) throws CapiException {
        if (TSAserver == null || hashAlgorithm == null) {
            throw new CapiException("Null data", 1001);
        }
        if (hashAlgorithm.compareToIgnoreCase("SHA-1") != 0 && hashAlgorithm.compareToIgnoreCase("SHA-256") != 0 && hashAlgorithm.compareToIgnoreCase("MD5") != 0) {
            throw new CapiException("Invalid hash Algorithm", 1002);
        }
        this.TSA = TSAserver;
        this.TSAhashAlgorithm = hashAlgorithm;
        this.TSApolicy = policy;
        this.TSAcertReq = certReq;
        this.TSABasicAuthUser = basicAuthUser;
        this.TSABasicAuthPassword = basicAuthPassword;
        this.TSAhttps = null;
        logger.debug("[setSignatureTimeStampParams] done.");
    }

    public void setSignatureTimeStampParams(String hashAlgorithm, String policy, boolean certReq, DTSClient client) throws CapiException {
        if (client == null) {
            throw new CapiException("Null DTSClient", 1001);
        }
        this.TSAhashAlgorithm = hashAlgorithm;
        this.TSApolicy = policy;
        this.TSAcertReq = certReq;
        this.TSAClient = client;
        this.TSA = "TSCLIENT";
        logger.debug("[setSignatureTimeStampParams DTSClient] done.");
    }

    public void addSigner(String alias, boolean withSigningTime, InputStream message, OutputStream der_stream) throws CapiException {
        this.addSigner(alias, null, message, der_stream);
    }

    private byte[] getTimeStamp(byte[] message) throws CapiException {
        BigInteger nonce = new BigInteger(64, Util.secureRandom);
        ByteArrayInputStream TSReq = null;
        String tsr = null;
        try {
            if (this.TSAClient != null) {
                return this.TSAClient.timeStamp(this.TSApolicy, this.TSAhashAlgorithm, message, nonce, this.TSAcertReq).toByteArray(false, true);
            }
            Client cli = new Client();
            tsr = cli.getRequest(this.TSApolicy, this.TSAhashAlgorithm, message, false, nonce, this.TSAcertReq);
            logger.debug("[getTimeStamp] generated TSReq");
            TSReq = new ByteArrayInputStream(Util.base64DecodeStr((String)tsr));
        }
        catch (IllegalParamException e) {
            logger.debug("[getTimeStamp] Error generating TSReq: " + e.getMessage(), (Throwable)e);
            throw new CapiException("Error generating TSReq", 50040);
        }
        catch (CapiException e) {
            logger.error("[getTimeStamp] Error generating TSReq: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            logger.debug("[getTimeStamp] Error sending TSReq: " + e.getMessage(), (Throwable)e);
            if (e.getMessage() != null) {
                throw new CapiException("Error sending TSReq: " + e.getMessage(), 50040);
            }
            throw new CapiException("Error sending TSReq", 50040);
        }
        byte[] signatureTS = null;
        logger.debug("[getTimeStamp] trying send TSA Request ...");
        try {
            if (this.TSAhttps != null) {
                signatureTS = this.TSAhttps.doPost(this.TSA, "application/timestamp-query", (InputStream)TSReq, null);
            } else {
                HTTP_URLConnection u = new HTTP_URLConnection();
                signatureTS = u.doPost(this.TSA, "application/timestamp-query", Util.base64DecodeStr((String)tsr), this.TSABasicAuthUser, this.TSABasicAuthPassword);
            }
        }
        catch (CapiException c) {
            logger.error("[getTimeStamp] Error sending TSReq: " + c.getMessage(), (Throwable)c);
            throw c;
        }
        catch (Exception c) {
            logger.error("[getTimeStamp] Exception posting TSReq using HTTP_URLConnection: " + c.getMessage(), (Throwable)c);
            throw new CapiException("Exception posting TSReq using HTTP_URLConnection: " + c.getMessage(), 91007);
        }
        if (signatureTS == null || signatureTS.length == 0) {
            throw new CapiException("Null response from TSA", 50040);
        }
        logger.debug("[getTimeStamp] received Time Stamp Token form TSA.");
        return signatureTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSigner(String alias, Date date, InputStream message, OutputStream der_stream) throws CapiException {
        try {
            if (alias == null) {
                throw new CapiException("Null data", 1001);
            }
            if (message == null) {
                throw new CapiException("Null data", 1001);
            }
            if (this.status != 0 && this.status != 1 && this.status != 2 && this.status != 3) {
                throw new CapiException("Signer cannot be added", 50040);
            }
            TokenSpi tk = ProvUtils.retrieveTokenByAlias((String)alias);
            this.addSigner(tk, alias, date, message, der_stream);
        }
        finally {
            try {
                der_stream.close();
            }
            catch (Exception exception) {}
            try {
                message.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSigner(TokenSpi tk, String alias, Date date, InputStream message, OutputStream der_stream) throws CapiException {
        FileInputStream bkMessage = null;
        try {
            X509Certificate cert = null;
            PrivateKey privKey = null;
            try {
                logger.debug("[addSigner] getting credential from token...");
                String base64Cert = tk.getCert(alias);
                byte[] c = base64Cert.getBytes("ISO8859_1");
                ByteArrayInputStream bais = new ByteArrayInputStream(c);
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                try {
                    cert = (X509Certificate)certificateFactory.generateCertificate(bais);
                }
                catch (CertificateException ce) {
                    String pemCert = this.stringHeader("CERTIFICATE") + base64Cert + this.stringFooter("CERTIFICATE");
                    c = pemCert.getBytes("ISO8859_1");
                    bais = new ByteArrayInputStream(c);
                    certificateFactory = CertificateFactory.getInstance("X.509");
                    cert = (X509Certificate)certificateFactory.generateCertificate(bais);
                    logger.debug("alias cert Subject: " + cert.getSubjectDN().getName());
                }
                logger.debug("...cert ok");
                privKey = tk.getPrivateKey(alias);
                logger.debug("[addSigner] getting credential from token ok");
            }
            catch (CapiException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new CapiException("Internal error", 50050);
            }
            try {
                this.addSigner(cert, privKey, date, message);
                this.status = 2;
                bkMessage = new FileInputStream(this.fileContent);
                this.getEncoded(bkMessage, der_stream, false, true);
                logger.debug("Signer added.");
            }
            catch (CapiError e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw e.getCapiException();
            }
            catch (CapiException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new CapiException("Internal error", 50050);
            }
        }
        finally {
            try {
                bkMessage.close();
            }
            catch (Exception exception) {}
        }
    }

    private void addSigner(X509Certificate x509Cert, PrivateKey privateKey, Date signTime, InputStream data) throws CapiException {
        CMSSignedDataGenerator pkcs7SignedDataGen = new CMSSignedDataGenerator();
        FileInputStream fis = null;
        ASN1EncodableVector hashTabAtt = new ASN1EncodableVector();
        Attribute attr = null;
        this.addSigner((CMSSignedGenerator)pkcs7SignedDataGen, hashTabAtt, x509Cert, signTime, data);
        try {
            logger.debug("Pkcs7addSigner ...");
            String sigAlg = "SHA256WithRSAEncryption";
            if (this.msgDigestToBeUsed.compareToIgnoreCase(SHA256) != 0) {
                sigAlg = "SHA1WithRSAEncryption";
            }
            Certificate cert = new Certificate(x509Cert);
            ContentSigner contentSigner = null;
            contentSigner = cert.isRsVerified() ? new VerRsContentSignerBuilder(sigAlg).setProvider(ProvUtils.retrieveBestProviderForKey((PrivateKey)privateKey)).build(privateKey) : new JcaContentSignerBuilder(sigAlg).setProvider(ProvUtils.retrieveBestProviderForKey((PrivateKey)privateKey)).build(privateKey);
            DigestCalculatorProvider dcp = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
            JcaSignerInfoGeneratorBuilder jtemp = new JcaSignerInfoGeneratorBuilder(dcp);
            JcaSignerInfoGeneratorBuilder j = jtemp.setSignedAttributeGenerator((CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(new AttributeTable(hashTabAtt)));
            SignerInfoGenerator sigenerator = j.build(contentSigner, x509Cert);
            if (cert.isRsVerified()) {
                pkcs7SignedDataGen.addSignerInfoGenerator((SignerInfoGenerator)new VerRsSignerInfoGenerator(sigenerator));
            } else {
                pkcs7SignedDataGen.addSignerInfoGenerator(sigenerator);
            }
            logger.debug("Pkcs7 generating ...");
            CMSSignedData signedData = pkcs7SignedDataGen.generate((CMSTypedData)new CMSAbsentContent(), false);
            SignerInformation currentSi = (SignerInformation)signedData.getSignerInfos().getSigners().iterator().next();
            byte[] currentSignature = currentSi.getSignature();
            if (this.TSA != null) {
                logger.debug("Signature TimeStampToken adding..");
                SignerInformationStore sig_infos = signedData.getSignerInfos();
                Collection signerColl = sig_infos.getSigners();
                Vector<SignerInformation> signerInformVector = new Vector<SignerInformation>(signerColl);
                for (int i = 0; i < signerInformVector.size(); ++i) {
                    SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(i);
                    byte[] signature = sigInfo.getSignature();
                    if (signature == null || !Arrays.equals(currentSignature, signature)) continue;
                    logger.debug("Found same signature, Signature TimeStampToken adding..");
                    byte[] ts = this.getTimeStamp(sigInfo.getSignature());
                    TimeStampToken tsk = new TimeStampToken(ts);
                    byte[] tstByteArray = tsk.toByteArray(false, true);
                    attr = this.getTSUnsignedAttribute(tstByteArray);
                    sigInfo = this.setSignatuteTS(attr, sigInfo);
                    signerInformVector.set(i, sigInfo);
                    break;
                }
                signedData = CMSSignedData.replaceSigners((CMSSignedData)signedData, (SignerInformationStore)new SignerInformationStore(signerInformVector));
            }
            logger.debug("new Pkcs7 parsing ...");
            fis = new FileInputStream(this.fileContent);
            dcp = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
            this.pkcs7SignedData = new CMSSignedDataParser(dcp, new CMSTypedStream((InputStream)new BufferedInputStream(fis)), signedData.getEncoded());
            this.pkcs7SignedData.getSignedContent().drain();
            this.setCertificatesAndSigners();
            logger.debug("Signer added.");
        }
        catch (CapiException ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (CMSException ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new CapiException(ex.getMessage(), 50040, (Throwable)ex);
        }
        catch (IOException ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new CapiException(ex.getMessage(), 50040, (Throwable)ex);
        }
        catch (OperatorCreationException ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new CapiException(ex.getMessage(), 50040, (Throwable)ex);
        }
        catch (CertificateEncodingException ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new CapiException(ex.getMessage(), 50040, (Throwable)ex);
        }
        catch (Error er) {
            logger.debug(er.getMessage(), (Throwable)er);
            throw new CapiException(er.getMessage(), 50040, (Throwable)er);
        }
        finally {
            try {
                data.close();
            }
            catch (Exception exception) {}
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
    }

    private void addSigner(CMSSignedGenerator sd, ASN1EncodableVector hashTabAtt, X509Certificate x509Cert, Date signTime, InputStream data) throws CapiException {
        FileOutputStream dataBk = null;
        try {
            if (!(sd instanceof CMSSignedDataGenerator) && !(sd instanceof CMSSignedDataStreamGenerator)) {
                throw new CapiException("CMSSignedData", 50040);
            }
            if (x509Cert == null) {
                logger.debug("x509Cert is null");
                throw new CapiException("x509Cert is null", 50040);
            }
            logger.debug("Adding signer ...");
            MessageDigest selectedMessageDigest = this.msgDigest;
            Attribute attr = null;
            IssuerSerial issSerial = new IssuerSerial(new GeneralNames(new GeneralName(JcaX500NameUtil.getIssuer((X509Certificate)x509Cert))), new ASN1Integer(x509Cert.getSerialNumber()));
            if (this.msgDigestToBeUsed.compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA1) == 0) {
                logger.debug("using SHA1 digest ...");
                this.msgDigest.reset();
                ESSCertID essCertid = new ESSCertID(this.msgDigest.digest(x509Cert.getEncoded()), issSerial);
                attr = new Attribute(SignedData.id_aa_signingCertificate, (ASN1Set)new DERSet((ASN1Encodable)new SigningCertificate(essCertid)));
                hashTabAtt.add((ASN1Encodable)attr);
            } else if (this.msgDigestToBeUsed.compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA256) == 0) {
                logger.debug("using SHA256 digest ...");
                selectedMessageDigest = this.msgDigest256;
                this.msgDigest256.reset();
                ESSCertIDv2 essCertidv2 = new ESSCertIDv2(new AlgorithmIdentifier(new ASN1ObjectIdentifier(CMSSignedDataGenerator.DIGEST_SHA256)), this.msgDigest256.digest(x509Cert.getEncoded()), issSerial);
                ESSCertIDv2[] essCertArray = new ESSCertIDv2[]{essCertidv2};
                attr = new Attribute(SignedData.id_aa_signingCertificateV2, (ASN1Set)new DERSet((ASN1Encodable)new SigningCertificateV2(essCertArray)));
                hashTabAtt.add((ASN1Encodable)attr);
            } else {
                throw new CapiException("Invalid digest algorithm", 1002);
            }
            if (this.pkcs7SignedData != null && this.pkcs7SignedData.getSignerInfos().size() > 0) {
                if (sd instanceof CMSSignedDataGenerator) {
                    ((CMSSignedDataGenerator)sd).addSigners(this.pkcs7SignedData.getSignerInfos());
                } else {
                    ((CMSSignedDataStreamGenerator)sd).addSigners(this.pkcs7SignedData.getSignerInfos());
                }
                if (!this.certsVector.contains(x509Cert)) {
                    this.certsVector.add(x509Cert);
                }
                JcaCertStore cStore = new JcaCertStore(this.certsVector);
                if (sd instanceof CMSSignedDataGenerator) {
                    ((CMSSignedDataGenerator)sd).addCertificates((Store)cStore);
                } else {
                    ((CMSSignedDataStreamGenerator)sd).addCertificates((Store)cStore);
                }
            } else {
                Vector<X509Certificate> v = new Vector<X509Certificate>();
                v.addElement(x509Cert);
                JcaCertStore cStore = new JcaCertStore(v);
                if (sd instanceof CMSSignedDataGenerator) {
                    ((CMSSignedDataGenerator)sd).addCertificates((Store)cStore);
                } else {
                    ((CMSSignedDataStreamGenerator)sd).addCertificates((Store)cStore);
                }
            }
            attr = new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.7.1")));
            hashTabAtt.add((ASN1Encodable)attr);
            if (this.includeSigningTime) {
                logger.debug("time is always true, including SigningTime!!");
                if (signTime != null) {
                    attr = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(signTime)));
                    hashTabAtt.add((ASN1Encodable)attr);
                } else {
                    Date d = new Date();
                    attr = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(d)));
                    hashTabAtt.add((ASN1Encodable)attr);
                }
            }
            byte[] dataBytes = new byte[4096];
            logger.debug("backing up content and digesting...");
            try {
                if (this.fileContent.exists()) {
                    this.fileContent.delete();
                }
            }
            catch (Exception cStore) {
                // empty catch block
            }
            this.fileContent = TmpFileUtils.createTempFile((String)"dataToSign", null);
            dataBk = new FileOutputStream(this.fileContent);
            int nread = data.read(dataBytes);
            while (nread > 0) {
                dataBk.write(dataBytes, 0, nread);
                selectedMessageDigest.update(dataBytes, 0, nread);
                nread = data.read(dataBytes);
            }
            dataBk.close();
            dataBk = null;
            logger.debug("end of back up ...");
            byte[] mdbytes = selectedMessageDigest.digest();
            logger.debug("end of digest ...");
            attr = new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString(mdbytes)));
            hashTabAtt.add((ASN1Encodable)attr);
            return;
        }
        catch (CapiException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception x) {
            logger.error(x.getMessage(), (Throwable)x);
            throw new CapiException("Internal error. Previous signers lost", 50040);
        }
        finally {
            try {
                data.close();
            }
            catch (Exception exception) {}
            if (dataBk != null) {
                try {
                    dataBk.close();
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    private String stringHeader(String type) throws IOException {
        return "-----BEGIN " + type + "-----" + System.getProperty("line.separator");
    }

    private String stringFooter(String type) throws IOException {
        return System.getProperty("line.separator") + "-----END " + type + "-----";
    }

    public String[] addSigner(TokenSpi tk, String alias, Date signingTime, InputStream message) throws CapiException {
        X509Certificate cert = null;
        PrivateKey privKey = null;
        try {
            logger.debug("[addSigner] getting credential from token...");
            String base64Cert = tk.getCert(alias);
            byte[] c = base64Cert.getBytes("ISO8859_1");
            ByteArrayInputStream bais = new ByteArrayInputStream(c);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            try {
                cert = (X509Certificate)certificateFactory.generateCertificate(bais);
                if (cert == null) {
                    logger.debug("Probably this is an IMB JRE, cert is null, retry as base64");
                    throw new CertificateException("IBM problem");
                }
            }
            catch (CertificateException ce) {
                byte[] derCer = Util.base64Decode((byte[])c);
                try {
                    cert = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(derCer));
                    logger.debug("certificate factory is " + certificateFactory.getClass().getName());
                    if (cert == null) {
                        logger.debug("cert is null");
                        throw new CertificateException("Null certificate");
                    }
                }
                catch (CertificateException e) {
                    String pemCert = this.stringHeader("CERTIFICATE") + base64Cert + this.stringFooter("CERTIFICATE");
                    c = pemCert.getBytes("ISO8859_1");
                    bais = new ByteArrayInputStream(c);
                    certificateFactory = CertificateFactory.getInstance("X.509");
                    cert = (X509Certificate)certificateFactory.generateCertificate(bais);
                    if (cert == null) {
                        logger.debug("Cannot instantiate Certificate");
                        throw new CapiException("Certificate format unknown or not implemented", 30002);
                    }
                    logger.debug("alias cert Subject: " + cert.getSubjectDN().getName());
                }
            }
            logger.debug("...cert ok");
            privKey = tk.getPrivateKey(alias);
            logger.debug("[addSigner] getting credential from token ok");
        }
        catch (CapiException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
        catch (CertificateException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
        try {
            this.addSigner(cert, privKey, signingTime, message);
            logger.debug("Signer added.");
            this.status = 2;
        }
        catch (CapiError e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e.getCapiException();
        }
        catch (CapiException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
        return this.listSigners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] addSigner(String alias, Date signingTime, InputStream message) throws CapiException {
        try {
            if (alias == null) {
                throw new CapiException("Null data", 1001);
            }
            if (message == null) {
                throw new CapiException("Null data", 1001);
            }
            if (this.status != 0 && this.status != 1 && this.status != 2 && this.status != 3) {
                throw new CapiException("Signer cannot be added", 50040);
            }
            TokenSpi tk = ProvUtils.retrieveTokenByAlias((String)alias);
            this.addSigner(tk, alias, signingTime, message);
        }
        finally {
            try {
                message.close();
            }
            catch (Exception exception) {}
        }
        return this.listSigners();
    }

    public void setDigestAlg(String digestAlg) throws CapiException {
        logger.debug("Setting digest algorithm ...");
        if (digestAlg == null) {
            throw new CapiException("Null data", 1001);
        }
        if (digestAlg.compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA1) == 0) {
            logger.debug("set SHA1 digest");
            this.msgDigestToBeUsed = CMSSignedDataGenerator.DIGEST_SHA1;
        } else if (digestAlg.compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA256) == 0) {
            logger.debug("set SHA256 digest ");
            this.msgDigestToBeUsed = CMSSignedDataGenerator.DIGEST_SHA256;
        } else {
            throw new CapiException("Invalid digest algorithm", 1002);
        }
    }

    public void includeSigningTime(boolean include) {
        logger.debug("includeSigningTime called ... omit is " + include);
        this.includeSigningTime = include;
    }

    public String toString() {
        try {
            switch (this.status) {
                case 0: {
                    return "Envelope not signed yet";
                }
                case 1: {
                    if (this.pkcs7SignedData == null) {
                        return "Envelope not signed yet";
                    }
                    this.setCerts();
                    break;
                }
                case 2: 
                case 3: {
                    return this.pkcs7SignedData.toString();
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return this.getClass().getName();
    }

    private void setCerts() throws CapiException {
        logger.debug("setting certificates ...");
        if (this.certsVector.size() <= 0) {
            return;
        }
        CMSSignedDataGenerator pkcs7SignedDataGen = null;
        try {
            pkcs7SignedDataGen = new CMSSignedDataGenerator();
            if (this.pkcs7SignedData != null) {
                if (this.pkcs7SignedData.getSignerInfos().size() > 0) {
                    pkcs7SignedDataGen.addSigners(this.pkcs7SignedData.getSignerInfos());
                }
            } else {
                throw new CapiException("Error parsing envelope: no signers", 50022);
            }
            JcaCertStore cStore = new JcaCertStore(this.certsVector);
            pkcs7SignedDataGen.addCertificates((Store)cStore);
            CMSSignedData signedData = pkcs7SignedDataGen.generate((CMSTypedData)new CMSAbsentContent(), false);
            DigestCalculatorProvider dcp = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
            this.pkcs7SignedData = new CMSSignedDataParser(dcp, signedData.getEncoded());
            this.setCertificatesAndSigners();
        }
        catch (CertificateEncodingException x) {
            logger.error(x.getMessage(), (Throwable)x);
            throw new CapiException("Error setting certificates", 50040);
        }
        catch (CMSException x) {
            logger.error(x.getMessage(), (Throwable)x);
            throw new CapiException("Error setting certificates", 50040);
        }
        catch (IOException x) {
            logger.error(x.getMessage(), (Throwable)x);
            throw new CapiException("Error setting certificates", 50040);
        }
        catch (OperatorCreationException x) {
            logger.error(x.getMessage(), (Throwable)x);
            throw new CapiException("Error setting certificates", 50040);
        }
    }

    public static void getPKCS7Content(InputStream der_encoded, OutputStream osdoc) throws CapiException {
        if (der_encoded == null || osdoc == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            DigestCalculatorProvider dcp = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
            CMSSignedDataParser p = new CMSSignedDataParser(dcp, der_encoded);
            CMSTypedStream cmsTypedS = p.getSignedContent();
            if (cmsTypedS == null) {
                throw new CapiException("Envelope is detached", 50000);
            }
            InputStream is = cmsTypedS.getContentStream();
            if (is == null) {
                throw new CapiException("Envelope is detached", 50000);
            }
            Streams.pipeAll((InputStream)is, (OutputStream)osdoc);
        }
        catch (CapiException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Envelope format unknown or not implemented", 50023);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Error writing envelope content", 50025);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
    }

    private void parseImplicit(InputStream der_encoded, OutputStream osdoc) throws CapiException {
        try {
            DigestCalculatorProvider dcp = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
            this.pkcs7SignedData = new CMSSignedDataParser(dcp, der_encoded);
            logger.debug("parsed implicit signed data ok");
            CMSTypedStream cmsTypedS = this.pkcs7SignedData.getSignedContent();
            if (cmsTypedS == null) {
                logger.debug("no content found into envelope... is detached...");
                throw new CapiException("Envelope is detached", 50000);
            }
            InputStream is = cmsTypedS.getContentStream();
            if (is == null) {
                logger.debug("no content found into envelope... is detached...");
                throw new CapiException("Envelope is detached", 50000);
            }
            if (osdoc != null) {
                logger.debug("parsed implicit: copying data...");
                StreamSignedEnvelope.pipeAll(is, osdoc, 8192);
            } else {
                cmsTypedS.drain();
                logger.debug("parsed implicit: skipping data...");
            }
            logger.debug("parsed implicit: data ok");
        }
        catch (CapiException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CMSException e) {
            logger.error("Formato busta non valido {}", (Object)e.getMessage());
            throw new CapiException("Envelope format unknown or not implemented", 50023);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Error writing envelope content", 50025);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
    }

    private static boolean pipeAll(InputStream inStr, OutputStream outStr, int BufferSize) throws IOException {
        int numRead;
        if (inStr == null || outStr == null || BufferSize <= 0) {
            return false;
        }
        if (BufferSize % 8 != 0) {
            return false;
        }
        byte[] bs = new byte[BufferSize];
        while ((numRead = inStr.read(bs, 0, bs.length)) >= 0) {
            outStr.write(bs, 0, numRead);
        }
        return true;
    }

    private void parseExplicit(InputStream der_encoded, InputStream data_is) throws CapiException {
        try {
            DigestCalculatorProvider dcp = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
            this.pkcs7SignedData = new CMSSignedDataParser(dcp, new CMSTypedStream(data_is), der_encoded);
            this.pkcs7SignedData.getSignedContent().drain();
            logger.debug("parsed explicit signed data ok");
        }
        catch (CMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Envelope format unknown or not implemented", 50023, (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050, (Throwable)e);
        }
    }

    private void checkRange(String param_name, int val, int fromval, int toval) throws CapiException {
        if (val < fromval || val > toval) {
            throw new CapiException("Parameter " + param_name + " value ( " + val + " ) is out of the range allowed [" + fromval + " : " + toval + "]", 1002);
        }
    }

    public StreamSignedEnvelope(InputStream der_encoded, InputStream der_encoded1, OutputStream save_internal_doc, OutputStream save_internal_doc1) throws CapiException {
        this(1);
        if (der_encoded == null || der_encoded1 == null || save_internal_doc == null || save_internal_doc1 == null) {
            throw new CapiException("Null data", 1001);
        }
        FileInputStream inData = null;
        StreamSignedEnvelope se1 = null;
        StreamSignedEnvelope se = null;
        File temp = null;
        try {
            int i;
            Store cStore;
            temp = TmpFileUtils.createTempFile((String)"doc", (String)".tmp");
            se1 = new StreamSignedEnvelope(der_encoded1, new FileOutputStream((java.io.File)temp));
            se = new StreamSignedEnvelope(der_encoded, save_internal_doc1);
            CMSSignedDataStreamGenerator pkcs7SignedDataGen = new CMSSignedDataStreamGenerator();
            if (se1.pkcs7SignedData.getSignerInfos().size() > 0) {
                pkcs7SignedDataGen.addSigners(se1.pkcs7SignedData.getSignerInfos());
                cStore = se1.pkcs7SignedData.getCertificates();
                pkcs7SignedDataGen.addCertificates(cStore);
            }
            if (se.pkcs7SignedData.getSignerInfos().size() > 0) {
                pkcs7SignedDataGen.addSigners(se.pkcs7SignedData.getSignerInfos());
                cStore = se.pkcs7SignedData.getCertificates();
                pkcs7SignedDataGen.addCertificates(cStore);
            }
            for (i = 0; i < se1.certsVector.size(); ++i) {
                if (this.certsVector.contains(se1.certsVector.get(i))) continue;
                this.certsVector.add(se1.certsVector.get(i));
            }
            for (i = 0; i < se1.signerDnVector.size(); ++i) {
                if (this.signerDnVector.contains(se1.signerDnVector.get(i))) continue;
                this.signerDnVector.add(se1.signerDnVector.get(i));
            }
            for (i = 0; i < se.certsVector.size(); ++i) {
                if (this.certsVector.contains(se.certsVector.get(i))) continue;
                this.certsVector.add(se.certsVector.get(i));
            }
            for (i = 0; i < se.signerDnVector.size(); ++i) {
                if (this.signerDnVector.contains(se.signerDnVector.get(i))) continue;
                this.signerDnVector.add(se.signerDnVector.get(i));
            }
            inData = new FileInputStream((java.io.File)temp);
            OutputStream copyData = null;
            copyData = this.mode == 2 ? pkcs7SignedDataGen.open(save_internal_doc, false) : pkcs7SignedDataGen.open(save_internal_doc, true);
            byte[] dataBytes = new byte[4096];
            int nread = inData.read(dataBytes);
            while (nread > 0) {
                copyData.write(dataBytes, 0, nread);
                nread = inData.read(dataBytes);
            }
            copyData.close();
            logger.debug("Signer added and envelope saved.");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Error encoding signed envelope", 50022);
        }
        catch (CMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Error encoding signed envelope", 50022);
        }
        finally {
            try {
                save_internal_doc.close();
            }
            catch (Exception exception) {}
            try {
                save_internal_doc1.close();
            }
            catch (Exception exception) {}
            try {
                der_encoded.close();
            }
            catch (Exception exception) {}
            try {
                der_encoded1.close();
            }
            catch (Exception exception) {}
            if (inData != null) {
                try {
                    inData.close();
                }
                catch (IOException iOException) {}
            }
            if (se1 != null) {
                se1.close();
            }
            if (se != null) {
                se.close();
            }
        }
    }

    public StreamSignedEnvelope(InputStream der_encoded, InputStream der_encoded1, OutputStream save_internal_doc, InputStream save_internal_doc1) throws CapiException {
        this(2);
        if (der_encoded == null || der_encoded1 == null || save_internal_doc == null || save_internal_doc1 == null) {
            throw new CapiException("Null data", 1001);
        }
        StreamSignedEnvelope se1 = null;
        StreamSignedEnvelope se = null;
        try {
            int i;
            Store cStore;
            se1 = new StreamSignedEnvelope(der_encoded1, save_internal_doc1);
            Object save_internal_null = null;
            se = new StreamSignedEnvelope(der_encoded, (OutputStream)null);
            CMSSignedDataGenerator pkcs7SignedDataGen = new CMSSignedDataGenerator();
            if (se1.pkcs7SignedData.getSignerInfos().size() > 0) {
                pkcs7SignedDataGen.addSigners(se1.pkcs7SignedData.getSignerInfos());
                cStore = se1.pkcs7SignedData.getCertificates();
                pkcs7SignedDataGen.addCertificates(cStore);
            }
            if (se.pkcs7SignedData.getSignerInfos().size() > 0) {
                pkcs7SignedDataGen.addSigners(se.pkcs7SignedData.getSignerInfos());
                cStore = se.pkcs7SignedData.getCertificates();
                pkcs7SignedDataGen.addCertificates(cStore);
            }
            for (i = 0; i < se1.certsVector.size(); ++i) {
                if (this.certsVector.contains(se1.certsVector.get(i))) continue;
                this.certsVector.add(se1.certsVector.get(i));
            }
            for (i = 0; i < se1.signerDnVector.size(); ++i) {
                if (this.signerDnVector.contains(se1.signerDnVector.get(i))) continue;
                this.signerDnVector.add(se1.signerDnVector.get(i));
            }
            for (i = 0; i < se.certsVector.size(); ++i) {
                if (this.certsVector.contains(se.certsVector.get(i))) continue;
                this.certsVector.add(se.certsVector.get(i));
            }
            for (i = 0; i < se.signerDnVector.size(); ++i) {
                if (this.signerDnVector.contains(se.signerDnVector.get(i))) continue;
                this.signerDnVector.add(se.signerDnVector.get(i));
            }
            CMSSignedData sd = pkcs7SignedDataGen.generate((CMSTypedData)new CMSProcessableFile(new java.io.File("prova")), false);
            byte[] env = sd.getEncoded();
            save_internal_doc.write(env);
            logger.debug("Signer added and envelope saved.");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Error encoding signed envelope", 50022);
        }
        catch (CMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Error encoding signed envelope", 50022);
        }
        finally {
            try {
                save_internal_doc.close();
            }
            catch (IOException iOException) {}
            try {
                save_internal_doc1.close();
            }
            catch (IOException iOException) {}
            try {
                der_encoded.close();
            }
            catch (IOException iOException) {}
            try {
                der_encoded1.close();
            }
            catch (IOException iOException) {}
            if (se1 != null) {
                se1.close();
            }
            if (se != null) {
                se.close();
            }
        }
    }

    public CounterSignedEnvelope getCounterSignature(int signerInfoIndex) throws CapiException {
        SignerInformationStore sig_infos;
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            sig_infos = this.pkcs7SignedData.getSignerInfos();
        }
        catch (CMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
        Collection signerColl = sig_infos.getSigners();
        Vector signerInformVector = new Vector(signerColl);
        if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            SignerInformation sInfo = (SignerInformation)signerInformVector.elementAt(signerInfoIndex);
            SignerInformationStore csStore = sInfo.getCounterSignatures();
            CounterSignedEnvelope ret = new CounterSignedEnvelope();
            ret.certsVector = this.certsVector;
            ret.setData(sInfo.getSignature());
            ret.parseCounterSigners(csStore, signerInfoIndex);
            return ret;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
    }

    public String[] setCounterSignature(int signerInfoIndex, CounterSignedEnvelope counterSig, InputStream message) throws CapiException {
        FileInputStream fis = null;
        FileOutputStream dataBk = null;
        if (this.pkcs7SignedData == null) {
            try {
                message.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            try {
                message.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new CapiException("Wrong signer index", 50010);
        }
        if (counterSig == null) {
            try {
                message.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new CapiException("CounterSignedEnvelope must be valid and signed", 1001);
        }
        SignerInformationStore sig_infos = null;
        Collection signerColl = null;
        try {
            sig_infos = this.pkcs7SignedData.getSignerInfos();
            signerColl = sig_infos.getSigners();
        }
        catch (CMSException e1) {
            try {
                message.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= signerColl.size()) {
            try {
                message.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            CMSSignedDataGenerator pkcs7SignedDataGen = new CMSSignedDataGenerator();
            Collection signedCertColl = this.pkcs7SignedData.getCertificates().getMatches(null);
            Collection countersignedCertColl = counterSig.pkcs7SignedData.getCertificates().getMatches(null);
            Vector cscertVector = new Vector(countersignedCertColl);
            for (int i = 0; i < cscertVector.size(); ++i) {
                if (signedCertColl.contains(cscertVector.elementAt(i))) continue;
                signedCertColl.add(cscertVector.elementAt(i));
            }
            JcaCertStore newStore = new JcaCertStore(signedCertColl);
            pkcs7SignedDataGen.addCertificates((Store)newStore);
            SignerInformationStore cSigners = counterSig.getSignersInfos();
            logger.debug("adding " + cSigners.size() + " countersignatures to signer " + signerInfoIndex);
            Vector<SignerInformation> signerInformVector = new Vector<SignerInformation>(signerColl);
            SignerInformation currSI = (SignerInformation)signerInformVector.get(signerInfoIndex);
            AttributeTable unsignedAttr = currSI.getUnsignedAttributes();
            if (unsignedAttr != null) {
                SignerInformation tmpSI;
                logger.debug("replacing CS attribute ... ");
                Hashtable ht = unsignedAttr.toHashtable();
                ht.remove(CMSAttributes.counterSignature);
                AttributeTable newUA = new AttributeTable(ht);
                currSI = tmpSI = SignerInformation.replaceUnsignedAttributes((SignerInformation)currSI, (AttributeTable)newUA);
            }
            SignerInformation newSI = SignerInformation.addCounterSigners((SignerInformation)currSI, (SignerInformationStore)cSigners);
            signerInformVector.set(signerInfoIndex, newSI);
            pkcs7SignedDataGen.addSigners(new SignerInformationStore(signerInformVector));
            CMSSignedData signedData = pkcs7SignedDataGen.generate((CMSTypedData)new CMSAbsentContent(), false);
            logger.debug("backing up content...");
            try {
                if (this.fileContent.exists()) {
                    this.fileContent.delete();
                }
            }
            catch (Exception tmpSI) {
                // empty catch block
            }
            this.fileContent = TmpFileUtils.createTempFile((String)"dataToSign", null);
            dataBk = new FileOutputStream(this.fileContent);
            byte[] dataBytes = new byte[4096];
            int nread = message.read(dataBytes);
            while (nread > 0) {
                dataBk.write(dataBytes, 0, nread);
                nread = message.read(dataBytes);
            }
            dataBk.close();
            dataBk = null;
            logger.debug("end of back up ...");
            fis = new FileInputStream(this.fileContent);
            DigestCalculatorProvider dcp = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
            this.pkcs7SignedData = new CMSSignedDataParser(dcp, new CMSTypedStream((InputStream)new BufferedInputStream(fis)), signedData.getEncoded());
            this.pkcs7SignedData.getSignedContent().drain();
            this.setCertificatesAndSigners();
            String[] stringArray = this.listSigners();
            return stringArray;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("CounterSignature internal error", 50050);
        }
        catch (CMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("CounterSignature internal error", 50050);
        }
        catch (CertificateEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("CounterSignature internal error", 50050);
        }
        catch (OperatorCreationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("CounterSignature internal error", 50050);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
            try {
                message.close();
            }
            catch (IOException iOException) {}
            try {
                if (dataBk != null) {
                    dataBk.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void setCounterSignature(int signerInfoIndex, CounterSignedEnvelope counterSig, InputStream message, OutputStream envelope) throws CapiException {
        if (this.pkcs7SignedData == null) {
            try {
                message.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            try {
                message.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new CapiException("Wrong signer index", 50010);
        }
        if (counterSig == null) {
            try {
                message.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new CapiException("CounterSignedEnvelope must be valid and signed", 1001);
        }
        SignerInformationStore sig_infos = null;
        Collection signerColl = null;
        try {
            sig_infos = this.pkcs7SignedData.getSignerInfos();
            signerColl = sig_infos.getSigners();
        }
        catch (CMSException e1) {
            try {
                message.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= signerColl.size()) {
            try {
                message.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            CMSSignedDataStreamGenerator pkcs7SignedDataGen = new CMSSignedDataStreamGenerator();
            Collection certColl = this.pkcs7SignedData.getCertificates().getMatches(null);
            List countercerts = counterSig.certsVector;
            for (int i = 0; i < countercerts.size(); ++i) {
                if (certColl.contains(countercerts.get(i))) continue;
                certColl.add(countercerts.get(i));
            }
            JcaCertStore cStore = new JcaCertStore(certColl);
            pkcs7SignedDataGen.addCertificates((Store)cStore);
            SignerInformationStore cSigners = counterSig.getSignersInfos();
            logger.debug("adding " + cSigners.size() + " countersignatures to signer " + signerInfoIndex);
            Vector<SignerInformation> signerInformVector = new Vector<SignerInformation>(signerColl);
            SignerInformation currSI = (SignerInformation)signerInformVector.get(signerInfoIndex);
            AttributeTable unsignedAttr = currSI.getUnsignedAttributes();
            if (unsignedAttr != null) {
                SignerInformation tmpSI;
                logger.debug("replacing CS attribute ... ");
                Hashtable ht = unsignedAttr.toHashtable();
                ht.remove(CMSAttributes.counterSignature);
                AttributeTable newUA = new AttributeTable(ht);
                currSI = tmpSI = SignerInformation.replaceUnsignedAttributes((SignerInformation)currSI, (AttributeTable)newUA);
            }
            SignerInformation newSI = SignerInformation.addCounterSigners((SignerInformation)currSI, (SignerInformationStore)cSigners);
            signerInformVector.set(signerInfoIndex, newSI);
            pkcs7SignedDataGen.addSigners(new SignerInformationStore(signerInformVector));
            logger.debug("saving Pkcs7 envelope ...");
            OutputStream copyData = null;
            byte[] dataBytes = new byte[4096];
            copyData = this.mode == 1 ? pkcs7SignedDataGen.open(envelope, true) : pkcs7SignedDataGen.open(envelope, false);
            if (this.mode == 1) {
                int nread = message.read(dataBytes);
                while (nread > 0) {
                    copyData.write(dataBytes, 0, nread);
                    nread = message.read(dataBytes);
                }
            }
            copyData.close();
            logger.debug("Envelope saved.");
        }
        catch (IOException x) {
            logger.error(x.getMessage(), (Throwable)x);
            throw new CapiException("Error encoding CounterSigned envelope", 50040);
        }
        catch (CMSException x) {
            logger.error(x.getMessage(), (Throwable)x);
            throw new CapiException("Error encoding CounterSigned envelope", 50040);
        }
        catch (CertificateEncodingException x) {
            logger.error(x.getMessage(), (Throwable)x);
            throw new CapiException("Error encoding CounterSigned envelope", 50040);
        }
        finally {
            try {
                message.close();
            }
            catch (Exception exception) {}
            try {
                envelope.close();
            }
            catch (Exception exception) {}
            try {
                this.status = 0;
                if (this.fileContent.exists()) {
                    this.fileContent.delete();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean hasCounterSignature(int signerInfoIndex) throws CapiException {
        Collection coll;
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            coll = this.pkcs7SignedData.getSignerInfos().getSigners();
        }
        catch (CMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("CMSException getting signers", 50050);
        }
        Vector v = new Vector(coll);
        SignerInformation sInfo = (SignerInformation)v.elementAt(signerInfoIndex);
        SignerInformationStore sStore = sInfo.getCounterSignatures();
        return sStore != null && sStore.size() > 0;
    }

    public void getEncoded(InputStream message, OutputStream der_stream, boolean b64, boolean finalize) throws CapiException {
        if (this.status < 2) {
            throw new CapiException("Data must be signed before", 50001);
        }
        logger.debug("saving envelope ...");
        CMSSignedDataStreamGenerator pkcs7SignedDataGen = null;
        OutputStream b64Stream = null;
        try {
            pkcs7SignedDataGen = new CMSSignedDataStreamGenerator();
            if (this.pkcs7SignedData == null || this.pkcs7SignedData.getSignerInfos().size() <= 0) {
                throw new CapiException("Error parsing envelope: no signers", 50022);
            }
            pkcs7SignedDataGen.addSigners(this.pkcs7SignedData.getSignerInfos());
            pkcs7SignedDataGen.addCertificates(this.pkcs7SignedData.getCertificates());
        }
        catch (CMSException x) {
            logger.error(x.getMessage(), (Throwable)x);
            throw new CapiException("Error parsing signed envelope", 50040);
        }
        try {
            OutputStream copyData = null;
            if (b64) {
                b64Stream = new Base64OutputStream(der_stream, true);
            }
            copyData = this.mode == 1 ? pkcs7SignedDataGen.open(b64 ? b64Stream : der_stream, true) : pkcs7SignedDataGen.open(b64 ? b64Stream : der_stream, false);
            byte[] dataBytes = new byte[4096];
            if (this.mode == 1) {
                int nread = message.read(dataBytes);
                while (nread > 0) {
                    copyData.write(dataBytes, 0, nread);
                    nread = message.read(dataBytes);
                }
            }
            copyData.close();
            logger.debug("Envelope saved.");
        }
        catch (Exception x) {
            logger.error(x.getMessage(), (Throwable)x);
            throw new CapiException("Error encoding signed envelope", 50040);
        }
        finally {
            try {
                if (b64Stream != null) {
                    b64Stream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                der_stream.close();
            }
            catch (Exception exception) {}
            try {
                message.close();
            }
            catch (Exception exception) {}
            try {
                if (finalize) {
                    this.status = 0;
                    if (this.fileContent.exists()) {
                        this.fileContent.delete();
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    public void getEncoded(InputStream message, OutputStream der_stream) throws CapiException {
        this.getEncoded(message, der_stream, false, true);
    }

    private Attribute getTSUnsignedAttribute(byte[] tstByteArray) throws CapiException {
        try {
            ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(tstByteArray));
            ContentInfo ci = ContentInfo.getInstance((Object)extIn.readObject());
            Attribute attr = new Attribute(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken, (ASN1Set)new DERSet((ASN1Encodable)ci));
            return attr;
        }
        catch (Exception x) {
            logger.error(x.getMessage(), (Throwable)x);
            throw new CapiException("Error adding signature Time Stamp Token", 50040);
        }
    }

    public String[] setSignatureTimeStampToken(int signerInfoIndex, TimeStampToken tst, InputStream message) throws CapiException, IOException {
        if (tst == null) {
            try {
                message.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new CapiException("Time Stamp Token is null", 1001);
        }
        byte[] tstByteArray = tst.toByteArray(false, true);
        return this.setSignatureTimeStampToken(signerInfoIndex, tstByteArray, message);
    }

    private SignerInformation setSignatuteTS(Attribute attr, SignerInformation currSI) {
        ASN1EncodableVector hashTabAtt;
        AttributeTable unsignedAttr = currSI.getUnsignedAttributes();
        if (unsignedAttr != null) {
            logger.debug("removing existing TimeStampToken unsignedAttributes ... ");
            Hashtable ht = unsignedAttr.toHashtable();
            ht.remove(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
            logger.debug("adding TS attribute to existing unsignedAttributes ... ");
            hashTabAtt = new AttributeTable(ht).toASN1EncodableVector();
        } else {
            hashTabAtt = new ASN1EncodableVector();
        }
        hashTabAtt.add((ASN1Encodable)attr);
        SignerInformation tmpSI = SignerInformation.replaceUnsignedAttributes((SignerInformation)currSI, (AttributeTable)new AttributeTable(hashTabAtt));
        return tmpSI;
    }

    public String[] setSignatureTimeStampToken(int signerInfoIndex, byte[] tst, InputStream message) throws CapiException {
        FileOutputStream dataBk = null;
        if (tst == null) {
            try {
                message.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new CapiException("Time Stamp Token is null", 1001);
        }
        Attribute attr = this.getTSUnsignedAttribute(tst);
        FileInputStream fis = null;
        if (this.pkcs7SignedData == null) {
            try {
                message.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            try {
                message.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new CapiException("Wrong signer index", 50010);
        }
        SignerInformationStore sig_infos = null;
        Collection signerColl = null;
        try {
            sig_infos = this.pkcs7SignedData.getSignerInfos();
            signerColl = sig_infos.getSigners();
        }
        catch (CMSException e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
            try {
                message.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= signerColl.size()) {
            try {
                message.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            CMSSignedDataGenerator pkcs7SignedDataGen = new CMSSignedDataGenerator();
            Store cStore = this.pkcs7SignedData.getCertificates();
            pkcs7SignedDataGen.addCertificates(cStore);
            Vector<SignerInformation> signerInformVector = new Vector<SignerInformation>(signerColl);
            SignerInformation currSI = (SignerInformation)signerInformVector.get(signerInfoIndex);
            currSI = this.setSignatuteTS(attr, currSI);
            signerInformVector.set(signerInfoIndex, currSI);
            pkcs7SignedDataGen.addSigners(new SignerInformationStore(signerInformVector));
            CMSSignedData signedData = pkcs7SignedDataGen.generate((CMSTypedData)new CMSAbsentContent(), false);
            logger.debug("backing up content...");
            try {
                if (this.fileContent.exists()) {
                    this.fileContent.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fileContent = TmpFileUtils.createTempFile((String)"dataToSign", null);
            dataBk = new FileOutputStream(this.fileContent);
            byte[] dataBytes = new byte[4096];
            int nread = message.read(dataBytes);
            while (nread > 0) {
                dataBk.write(dataBytes, 0, nread);
                nread = message.read(dataBytes);
            }
            dataBk.close();
            dataBk = null;
            logger.debug("end of back up ...");
            fis = new FileInputStream(this.fileContent);
            DigestCalculatorProvider dcp = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
            this.pkcs7SignedData = new CMSSignedDataParser(dcp, new CMSTypedStream((InputStream)new BufferedInputStream(fis)), signedData.getEncoded());
            this.pkcs7SignedData.getSignedContent().drain();
            this.setCertificatesAndSigners();
            String[] stringArray = this.listSigners();
            return stringArray;
        }
        catch (IOException x) {
            logger.error(x.getMessage(), (Throwable)x);
            throw new CapiException("Error encoding CounterSigned envelope", 50040);
        }
        catch (CMSException x) {
            logger.error(x.getMessage(), (Throwable)x);
            throw new CapiException("Error encoding CounterSigned envelope", 50040);
        }
        catch (OperatorCreationException x) {
            logger.error(x.getMessage(), (Throwable)x);
            throw new CapiException("Error encoding CounterSigned envelope", 50040);
        }
        finally {
            try {
                message.close();
            }
            catch (Exception exception) {}
            try {
                fis.close();
            }
            catch (Exception exception) {}
            try {
                this.status = 0;
                if (this.fileContent.exists()) {
                    this.fileContent.delete();
                }
            }
            catch (Exception exception) {}
            if (dataBk != null) {
                try {
                    dataBk.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public byte[] getSignatureTimeStampToken(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            Attribute attr;
            SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector signerInformVector = new Vector(signerColl);
            if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(signerInfoIndex);
            AttributeTable atab = sigInfo.getUnsignedAttributes();
            byte[] result = null;
            if (atab != null && (attr = atab.get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) != null) {
                ContentInfo t = ContentInfo.getInstance((Object)attr.getAttrValues().getObjectAt(0).toASN1Primitive());
                result = t.getEncoded("DER");
            }
            return result;
        }
        catch (CapiException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Wrong timeStampToken format", 50023);
        }
    }

    public void close() {
        if (this.fileContent != null && this.fileContent.exists()) {
            this.fileContent.delete();
        }
    }

    public CadesSignedDataProxy getSignedDataProxy() {
        return new CadesSignedDataProxy(this.pkcs7SignedData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] addSignerByApplet(String alias, Date signingTime, InputStream message) throws CapiException {
        try {
            TokenSpi tk;
            if (alias == null) {
                throw new CapiException("Null data", 1001);
            }
            if (message == null) {
                throw new CapiException("Null data", 1001);
            }
            if (this.status != 0 && this.status != 1 && this.status != 2 && this.status != 3) {
                throw new CapiException("Signer cannot be added", 50040);
            }
            TokenSpi tokenSpi = tk = Token.getTokenSpi((String)alias);
            synchronized (tokenSpi) {
                X509Certificate cert = null;
                PrivateKey privKey = null;
                try {
                    logger.info("[addSigner] getting credential from token...");
                    String base64Cert = tk.getCert(alias);
                    byte[] c = base64Cert.getBytes("ISO8859_1");
                    ByteArrayInputStream bais = new ByteArrayInputStream(c);
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    try {
                        cert = (X509Certificate)certificateFactory.generateCertificate(bais);
                        if (cert == null) {
                            logger.info("Probably this is an IMB JRE, cert is null, retry as base64");
                            throw new CertificateException("IBM problem");
                        }
                    }
                    catch (CertificateException ce) {
                        byte[] derCer = Util.base64Decode((byte[])c);
                        try {
                            cert = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(derCer));
                            logger.info("certificate factory is " + certificateFactory.getClass().getName());
                            if (cert == null) {
                                logger.info("cert is null");
                                throw new CertificateException("Null certificate");
                            }
                        }
                        catch (CertificateException e) {
                            String pemCert = this.stringHeader("CERTIFICATE") + base64Cert + this.stringFooter("CERTIFICATE");
                            c = pemCert.getBytes("ISO8859_1");
                            bais = new ByteArrayInputStream(c);
                            certificateFactory = CertificateFactory.getInstance("X.509");
                            cert = (X509Certificate)certificateFactory.generateCertificate(bais);
                            if (cert == null) {
                                logger.info("Cannot instantiate Certificate");
                                throw new CapiException("Certificate format unknown or not implemented", 30002);
                            }
                            logger.info("alias cert Subject: " + cert.getSubjectDN().getName());
                        }
                    }
                    logger.info("...cert ok");
                    privKey = tk.getPrivateKey(alias);
                    logger.info("[addSigner] getting credential from token ok");
                }
                catch (CapiException e) {
                    logger.error(e.getMessage());
                    throw e;
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                    throw new CapiException("Internal error", 50050);
                }
                try {
                    this.addSignerByApplet(cert, privKey, signingTime, message);
                    logger.info("Signer added.");
                    this.status = 2;
                }
                catch (CapiError e) {
                    logger.error(e.getMessage());
                    throw e.getCapiException();
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                    throw new CapiException("Internal error " + e.getMessage(), 50050);
                }
            }
        }
        finally {
            try {
                message.close();
            }
            catch (Exception exception) {}
        }
        return this.listSigners();
    }

    private void addSignerByApplet(X509Certificate x509Cert, PrivateKey privateKey, Date signTime, InputStream data) throws CapiException {
        CMSSignedDataGenerator pkcs7SignedDataGen = new CMSSignedDataGenerator();
        FileInputStream fis = null;
        ASN1EncodableVector hashTabAtt = new ASN1EncodableVector();
        Attribute attr = null;
        String savedDate = this.addSignerByApplet((CMSSignedGenerator)pkcs7SignedDataGen, hashTabAtt, x509Cert, signTime, data);
        try {
            String sigAlg = "SHA256WithRSAEncryption";
            if (this.msgDigestToBeUsed.compareToIgnoreCase(SHA256) != 0) {
                sigAlg = "SHA1WithRSAEncryption";
            }
            ContentSigner contentSigner = null;
            DigestCalculatorProvider dcp = null;
            JcaSignerInfoGeneratorBuilder jtemp = null;
            try {
                contentSigner = new JcaContentSignerBuilder(sigAlg).setProvider(ProvUtils.actalisProvider).build(privateKey);
                dcp = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
                jtemp = new JcaSignerInfoGeneratorBuilder(dcp);
            }
            catch (Exception ex) {
                throw new CapiException("1 " + ex.getMessage(), 1003);
            }
            JcaSignerInfoGeneratorBuilder j = null;
            try {
                j = jtemp.setSignedAttributeGenerator((CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(new AttributeTable(hashTabAtt)));
            }
            catch (Exception ex) {
                throw new CapiException("2 " + ex.getMessage(), 1003);
            }
            SignerInfoGenerator sigenerator = null;
            try {
                sigenerator = j.build(contentSigner, x509Cert);
            }
            catch (Exception ex) {
                throw new CapiException("3 " + ex.getMessage(), 1003);
            }
            try {
                pkcs7SignedDataGen.addSignerInfoGenerator(sigenerator);
            }
            catch (Exception ex) {
                throw new CapiException("4 " + ex.getMessage(), 1003);
            }
            CMSSignedData signedData = null;
            try {
                signedData = pkcs7SignedDataGen.generate((CMSTypedData)new CMSAbsentContent(), false);
            }
            catch (Exception ex) {
                throw new CapiException("5 " + ex.getMessage(), 1003);
            }
            try {
                if (this.TSA != null) {
                    SignerInformationStore sig_infos = signedData.getSignerInfos();
                    Collection signerColl = sig_infos.getSigners();
                    Vector<SignerInformation> signerInformVector = new Vector<SignerInformation>(signerColl);
                    for (int i = 0; i < signerInformVector.size(); ++i) {
                        SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(i);
                        Date date = this.getSignatureTime(sigInfo);
                        if (date == null || date.toString().compareToIgnoreCase(savedDate) != 0) continue;
                        byte[] ts = this.getTimeStamp(sigInfo.getSignature());
                        TimeStampToken tsk = new TimeStampToken(ts);
                        byte[] tstByteArray = tsk.toByteArray(false, true);
                        attr = this.getTSUnsignedAttribute(tstByteArray);
                        sigInfo = this.setSignatuteTS(attr, sigInfo);
                        signerInformVector.set(i, sigInfo);
                        break;
                    }
                    signedData = CMSSignedData.replaceSigners((CMSSignedData)signedData, (SignerInformationStore)new SignerInformationStore(signerInformVector));
                }
            }
            catch (Exception ex) {
                throw new CapiException("6 " + ex.getMessage(), 1003);
            }
            try {
                fis = new FileInputStream(this.fileContent);
                dcp = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
            }
            catch (Exception ex) {
                throw new CapiException("7 " + ex.getMessage(), 1003);
            }
            try {
                this.pkcs7SignedData = new CMSSignedDataParser(dcp, new CMSTypedStream((InputStream)new BufferedInputStream(fis, 4096)), signedData.getEncoded());
                this.pkcs7SignedData.getSignedContent().drain();
                this.setCertificatesAndSigners();
            }
            catch (Exception ex) {
                throw new CapiException("8 " + ex.getMessage(), 1003);
            }
        }
        catch (CapiException e) {
            throw e;
        }
        catch (Exception x) {
            throw new CapiException(x.getMessage(), 50040);
        }
        finally {
            try {
                data.close();
            }
            catch (Exception exception) {}
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
    }

    private String addSignerByApplet(CMSSignedGenerator sd, ASN1EncodableVector hashTabAtt, X509Certificate x509Cert, Date signTime, InputStream data) throws CapiException {
        try {
            if (!(sd instanceof CMSSignedDataGenerator) && !(sd instanceof CMSSignedDataStreamGenerator)) {
                throw new CapiException("CMSSignedData", 50040);
            }
            if (x509Cert == null) {
                throw new CapiException("x509Cert is null", 50040);
            }
            MessageDigest selectedMessageDigest = this.msgDigest;
            Attribute attr = null;
            IssuerSerial issSerial = null;
            try {
                issSerial = new IssuerSerial(new GeneralNames(new GeneralName(JcaX500NameUtil.getIssuer((X509Certificate)x509Cert))), new ASN1Integer(x509Cert.getSerialNumber()));
            }
            catch (Exception e1) {
                throw new CapiException("Exception creating IssuerSerial", 50040);
            }
            if (this.msgDigestToBeUsed.compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA1) == 0) {
                try {
                    this.msgDigest.reset();
                    ESSCertID essCertid = new ESSCertID(this.msgDigest.digest(x509Cert.getEncoded()), issSerial);
                    attr = new Attribute(SignedData.id_aa_signingCertificate, (ASN1Set)new DERSet((ASN1Encodable)new SigningCertificate(essCertid)));
                    hashTabAtt.add((ASN1Encodable)attr);
                }
                catch (Exception e) {
                    throw new CapiException("Exception creating id_aa_signingCertificate.", 50040);
                }
            } else if (this.msgDigestToBeUsed.compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA256) == 0) {
                selectedMessageDigest = this.msgDigest256;
                try {
                    this.msgDigest256.reset();
                    ESSCertIDv2 essCertidv2 = new ESSCertIDv2(new AlgorithmIdentifier(new ASN1ObjectIdentifier(CMSSignedDataGenerator.DIGEST_SHA256)), this.msgDigest256.digest(x509Cert.getEncoded()), issSerial);
                    ESSCertIDv2[] essCertArray = new ESSCertIDv2[]{essCertidv2};
                    attr = new Attribute(SignedData.id_aa_signingCertificateV2, (ASN1Set)new DERSet((ASN1Encodable)new SigningCertificateV2(essCertArray)));
                    hashTabAtt.add((ASN1Encodable)attr);
                }
                catch (Exception e) {
                    throw new CapiException("Exception creating id_aa_signingCertificate.", 50040);
                }
            } else {
                throw new CapiException("Invalid digest algorithm", 1002);
            }
            if (this.pkcs7SignedData != null && this.pkcs7SignedData.getSignerInfos().size() > 0) {
                try {
                    if (sd instanceof CMSSignedDataGenerator) {
                        ((CMSSignedDataGenerator)sd).addSigners(this.pkcs7SignedData.getSignerInfos());
                    } else {
                        ((CMSSignedDataStreamGenerator)sd).addSigners(this.pkcs7SignedData.getSignerInfos());
                    }
                    if (!this.certsVector.contains(x509Cert)) {
                        this.certsVector.add(x509Cert);
                    }
                    JcaCertStore cStore = new JcaCertStore(this.certsVector);
                    if (sd instanceof CMSSignedDataGenerator) {
                        ((CMSSignedDataGenerator)sd).addCertificates((Store)cStore);
                    }
                    ((CMSSignedDataStreamGenerator)sd).addCertificates((Store)cStore);
                }
                catch (Exception ex) {
                    throw new CapiException("busta gi\u00e0 firmata da aggiornare: " + ex.getMessage(), 1003);
                }
            } else {
                try {
                    Vector<X509Certificate> v = new Vector<X509Certificate>();
                    v.addElement(x509Cert);
                    JcaCertStore cStore = new JcaCertStore(v);
                    if (sd instanceof CMSSignedDataGenerator) {
                        ((CMSSignedDataGenerator)sd).addCertificates((Store)cStore);
                    } else {
                        ((CMSSignedDataStreamGenerator)sd).addCertificates((Store)cStore);
                    }
                }
                catch (Exception ex) {
                    throw new CapiException("busta nuova: " + ex.getMessage(), 1003);
                }
            }
            try {
                attr = new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((ASN1Encodable)new DERObjectIdentifier("1.2.840.113549.1.7.1")));
                hashTabAtt.add((ASN1Encodable)attr);
            }
            catch (Exception ex) {
                throw new CapiException("aggiunta attributi contentType: " + ex.getMessage(), 1003);
            }
            String savedDate = null;
            try {
                if (signTime != null) {
                    savedDate = signTime.toString();
                    attr = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(signTime)));
                    hashTabAtt.add((ASN1Encodable)attr);
                } else {
                    Date d = new Date();
                    savedDate = d.toString();
                    attr = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(d)));
                    hashTabAtt.add((ASN1Encodable)attr);
                }
            }
            catch (Exception ex) {
                throw new CapiException("aggiunta attributi signingTime: " + ex.getMessage(), 1003);
            }
            byte[] dataBytes = new byte[4096];
            try {
                if (this.fileContent.exists()) {
                    this.fileContent.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fileContent = TmpFileUtils.createTempFile((String)"dataToSign", null);
            FileOutputStream dataBk = new FileOutputStream(this.fileContent);
            int nread = data.read(dataBytes);
            while (nread > 0) {
                dataBk.write(dataBytes, 0, nread);
                selectedMessageDigest.update(dataBytes, 0, nread);
                nread = data.read(dataBytes);
            }
            dataBk.close();
            byte[] mdbytes = selectedMessageDigest.digest();
            try {
                attr = new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString(mdbytes)));
                hashTabAtt.add((ASN1Encodable)attr);
            }
            catch (Exception ex) {
                throw new CapiException("aggiunta attributi messageDigest: " + ex.getMessage(), 1003);
            }
            String string = savedDate;
            return string;
        }
        catch (CapiException e) {
            throw e;
        }
        catch (Exception x) {
            throw new CapiException(x.getMessage(), 50040);
        }
        finally {
            try {
                data.close();
            }
            catch (Exception exception) {}
        }
    }
}

