/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.xml;

import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.xml.DOMSubTreeData;
import it.actalis.vol.utils.Constants;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.Data;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMURIReference;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InternalKeySelector
extends KeySelector {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private Document document;

    public InternalKeySelector(Document document) {
        this.document = document;
    }

    @Override
    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xmlCryptoContext) throws KeySelectorException {
        if (keyInfo == null) {
            throw new KeySelectorException("Null KeyInfo object!");
        }
        List<XMLStructure> keyInfoList = keyInfo.getContent();
        for (int i = 0; i < keyInfoList.size(); ++i) {
            XMLStructure xmlStructure = keyInfoList.get(i);
            if (!(xmlStructure instanceof X509Data)) continue;
            ArrayList<X509Certificate> x509List = new ArrayList<X509Certificate>();
            List<?> x509DataList = ((X509Data)xmlStructure).getContent();
            for (Object obj : x509DataList) {
                if (!(obj instanceof X509Certificate)) continue;
                X509Certificate cert = (X509Certificate)obj;
                x509List.add(cert);
            }
            if (x509List.size() == 1) {
                return new InternalKeySelectorResult(x509List);
            }
            X509Certificate signingCert = this.getSigningCertificate(x509List, xmlCryptoContext);
            if (signingCert == null) {
                if (x509List.isEmpty()) {
                    throw new KeySelectorException("No KeyValue element found!");
                }
                signingCert = (X509Certificate)x509List.get(0);
            }
            return new InternalKeySelectorResult(x509List, signingCert);
        }
        throw new KeySelectorException("No KeyValue element found!");
    }

    static boolean algEquals(String algURI, String algName) {
        if (algName.equalsIgnoreCase("DSA") && algURI.equalsIgnoreCase("http://www.w3.org/2009/xmldsig11#dsa-sha256")) {
            return true;
        }
        return algName.equalsIgnoreCase("RSA") && algURI.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
    }

    private X509Certificate getSigningCertificate(List<X509Certificate> x509List, XMLCryptoContext xmlCryptoContext) {
        NodeList signedInfoList = this.document.getElementsByTagName("ds:SignedInfo");
        if (signedInfoList.getLength() == 0) {
            signedInfoList = this.document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignedInfo");
        }
        X509Certificate certificate = null;
        if (signedInfoList.getLength() > 1) {
            for (int si = 0; certificate == null && si < signedInfoList.getLength(); ++si) {
                certificate = this.getSigningCertificateRelativeToSignedInfo((Element)signedInfoList.item(si), x509List, xmlCryptoContext);
            }
        } else if (signedInfoList.getLength() == 1) {
            Element signedInfo = (Element)signedInfoList.item(0);
            certificate = this.getSigningCertificateRelativeToSignedInfo(signedInfo, x509List, xmlCryptoContext);
        }
        return certificate;
    }

    private X509Certificate getSigningCertificateRelativeToSignedInfo(Element signedInfo, List<X509Certificate> x509List, XMLCryptoContext xmlCryptoContext) {
        NodeList referenceList = signedInfo.getElementsByTagName("ds:Reference");
        if (referenceList.getLength() == 0) {
            referenceList = signedInfo.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Reference");
        }
        for (int i = 0; i < referenceList.getLength(); ++i) {
            final Element reference = (Element)referenceList.item(i);
            if (!"http://uri.etsi.org/01903#SignedProperties".equals(reference.getAttribute("Type"))) continue;
            final String uri = reference.getAttribute("URI");
            try {
                Data signedPropertiesData = xmlCryptoContext.getURIDereferencer().dereference(new DOMURIReference(){

                    @Override
                    public Node getHere() {
                        return reference.getAttributeNode("URI");
                    }

                    @Override
                    public String getURI() {
                        return uri;
                    }

                    @Override
                    public String getType() {
                        return "http://uri.etsi.org/01903#SignedProperties";
                    }
                }, xmlCryptoContext);
                Element signedProperties = (Element)((DOMSubTreeData)signedPropertiesData).getRoot();
                Element certDigest = this.getCertDigestElement(signedProperties);
                if (certDigest == null) {
                    return x509List.get(0);
                }
                String digestMethod = this.getDigestMethod(certDigest);
                String digestValue = this.getDigestValue(certDigest);
                for (X509Certificate cert : x509List) {
                    try {
                        MessageDigest md = MessageDigest.getInstance(digestMethod.substring(digestMethod.lastIndexOf("#") + 1), ProvUtils.bcProvider);
                        byte[] digest = md.digest(cert.getEncoded());
                        String calcDigest = Base64.toBase64String((byte[])digest);
                        if (!calcDigest.equals(digestValue)) continue;
                        return cert;
                    }
                    catch (NoSuchAlgorithmException | CertificateEncodingException ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                    }
                }
                continue;
            }
            catch (URIReferenceException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    private Element getCertDigestElement(Element signedProperties) {
        Element signingCertificate;
        NodeList certList;
        NodeList signingCertificateList = signedProperties.getElementsByTagName("xades:SigningCertificateV2");
        if (signingCertificateList.getLength() == 0) {
            signingCertificateList = signedProperties.getElementsByTagName("xades:SigningCertificate");
        }
        if ((certList = (signingCertificate = (Element)signingCertificateList.item(0)).getElementsByTagName("xades:Cert")).getLength() == 0) {
            return null;
        }
        NodeList certDigestList = ((Element)certList.item(0)).getElementsByTagName("xades:CertDigest");
        if (certDigestList.getLength() == 0) {
            return null;
        }
        return (Element)certDigestList.item(0);
    }

    private String getDigestMethod(Element certDigest) {
        NodeList digestMethodList = certDigest.getElementsByTagName("ds:DigestMethod");
        if (digestMethodList.getLength() == 0) {
            digestMethodList = certDigest.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
        }
        if (digestMethodList.getLength() == 0) {
            return null;
        }
        Element digestMethod = (Element)digestMethodList.item(0);
        return digestMethod.getAttribute("Algorithm");
    }

    private String getDigestValue(Element certDigest) {
        NodeList digestValueList = certDigest.getElementsByTagName("ds:DigestValue");
        if (digestValueList.getLength() == 0) {
            digestValueList = certDigest.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DigestValue");
        }
        if (digestValueList.getLength() == 0) {
            return null;
        }
        Element digestValue = (Element)digestValueList.item(0);
        return digestValue.getTextContent();
    }

    public static class InternalKeySelectorResult
    implements KeySelectorResult {
        private X509Certificate cert;
        private List<X509Certificate> certList;

        InternalKeySelectorResult(X509Certificate cert) {
            this.cert = cert;
        }

        InternalKeySelectorResult(List<X509Certificate> certList) {
            this.certList = certList;
            this.cert = certList.get(0);
        }

        InternalKeySelectorResult(List<X509Certificate> certList, X509Certificate signingCert) {
            this.certList = certList;
            this.cert = signingCert;
        }

        @Override
        public Key getKey() {
            return this.cert.getPublicKey();
        }

        public X509Certificate getX509() {
            return this.cert;
        }

        public List<X509Certificate> getX509List() {
            return this.certList;
        }
    }
}

