/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util;

import it.actalis.ellips.capi.util.ShiftingBuffer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class ZipCommentOutputStream
extends OutputStream {
    private static final byte[] MAGIC_DIR_END = new byte[]{80, 75, 5, 6};
    private static final int COMMENT_SIZE_AFTER_MAGIC_INDEX = 20;
    private static final int COMMENT_START_AFTER_MAGIC_INDEX = 22;
    private final ByteArrayOutputStream commentBuff = new ByteArrayOutputStream();
    private final ShiftingBuffer<Byte> magicDirEndBuff = new ShiftingBuffer(MAGIC_DIR_END.length);
    private boolean isMagicEndFound = false;
    private int bytesReadAfterMagicDirEnd = 0;
    private int commLengthInZip = 0;

    public byte[] getCommentBuffer() throws IOException {
        if (this.commentBuff.size() != this.commLengthInZip) {
            throw new IOException("ZIP comment real length is different from the one specified in footer table.");
        }
        return this.commentBuff.toByteArray();
    }

    @Override
    public void write(int b) throws IOException {
        block4: {
            block2: {
                block5: {
                    block3: {
                        if (!this.isMagicEndFound) break block2;
                        ++this.bytesReadAfterMagicDirEnd;
                        if (this.bytesReadAfterMagicDirEnd != 21 - MAGIC_DIR_END.length) break block3;
                        this.commLengthInZip += (byte)b;
                        break block4;
                    }
                    if (this.bytesReadAfterMagicDirEnd != 22 - MAGIC_DIR_END.length) break block5;
                    this.commLengthInZip += (byte)b * 256;
                    break block4;
                }
                if (this.bytesReadAfterMagicDirEnd < 22 - MAGIC_DIR_END.length) break block4;
                this.commentBuff.write(b);
                break block4;
            }
            this.magicDirEndBuff.update((byte)b);
            if (this.magicDirEndBuff.getActualSize() < MAGIC_DIR_END.length) {
                return;
            }
            List<Byte> buff = this.magicDirEndBuff.getValue();
            this.isMagicEndFound = true;
            for (int k = 0; k < MAGIC_DIR_END.length; ++k) {
                if (buff.get(k) == MAGIC_DIR_END[k]) continue;
                this.isMagicEndFound = false;
                break;
            }
        }
    }
}

