/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util;

import it.actalis.ellips.capi.signature.DigestAlgorithm;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLCommonUtils {
    public static String getXMLEncDigestType(DigestAlgorithm digestType) {
        if (digestType == null) {
            return null;
        }
        switch (digestType) {
            case SHA1: {
                return "sha1";
            }
            case SHA256: {
                return "sha256";
            }
        }
        return null;
    }

    public static void completeXMLDigestMethod(XMLStreamWriter xsw, DigestAlgorithm method) throws XMLStreamException {
        xsw.writeStartElement("DigestMethod");
        xsw.writeNamespace("", "http://www.w3.org/2000/09/xmldsig#");
        xsw.writeAttribute("Algorithm", "http://www.w3.org/2001/04/xmlenc#" + XMLCommonUtils.getXMLEncDigestType(method));
        xsw.writeEndElement();
    }

    public static void completeXMLDigestValue(XMLStreamWriter xsw, String value) throws XMLStreamException {
        xsw.writeStartElement("DigestValue");
        xsw.writeNamespace("", "http://www.w3.org/2000/09/xmldsig#");
        xsw.writeCharacters(value);
        xsw.writeEndElement();
    }

    public static void completeXMLDigestCouple(XMLStreamWriter xsw, DigestAlgorithm method, String value) throws XMLStreamException {
        XMLCommonUtils.completeXMLDigestMethod(xsw, method);
        XMLCommonUtils.completeXMLDigestValue(xsw, value);
    }
}

