/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class ObjectUtils {
    public static <T> T clone(T obj) {
        Object clone = ObjectUtils.cloneObject(obj);
        if (clone == null) {
            return null;
        }
        return (T)clone;
    }

    public static Object cloneObject(Object obj) {
        try {
            Object clone = obj.getClass().newInstance();
            for (Field field : obj.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                if (field.get(obj) == null || Modifier.isFinal(field.getModifiers())) continue;
                if (field.getType().isPrimitive() || field.getType().equals(String.class) || field.getType().getSuperclass().equals(Number.class) || field.getType().equals(Boolean.class)) {
                    field.set(clone, field.get(obj));
                    continue;
                }
                Object childObj = field.get(obj);
                if (childObj == obj) {
                    field.set(clone, clone);
                    continue;
                }
                field.set(clone, ObjectUtils.clone(field.get(obj)));
            }
            return clone;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] objectToBytes(Object o) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(bos);
            out.writeObject(o);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object bytesToObject(byte[] bites) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bites);
        ObjectInputStream out = null;
        try {
            out = new ObjectInputStream(bis);
            Object object = out.readObject();
            return object;
        }
        catch (IOException ex) {
            Object var4_8 = null;
            return var4_8;
        }
        catch (ClassNotFoundException ex) {
            Object var4_9 = null;
            return var4_9;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
            try {
                bis.close();
            }
            catch (IOException iOException) {}
        }
    }
}

