/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util;

import it.actalis.ellips.capi.provider.PureSWKey;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import sun.security.rsa.RSAPrivateCrtKeyImpl;

public class KeyUtils {
    public static PublicKey rebuildPublicKeyFromPrivate(PrivateKey priv) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        if (priv.getAlgorithm().equalsIgnoreCase("RSA")) {
            PrivateKey priv2 = priv;
            if (priv instanceof PureSWKey) {
                priv2 = ((PureSWKey)priv).getPrivateKeySpi();
            }
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", (Provider)new BouncyCastleProvider());
            RSAPrivateCrtKey rsa = (RSAPrivateCrtKey)RSAPrivateCrtKeyImpl.newKey((byte[])priv2.getEncoded());
            RSAPublicKeySpec pubSpec = new RSAPublicKeySpec(rsa.getModulus(), rsa.getPublicExponent());
            return (RSAPublicKey)keyFactory.generatePublic(pubSpec);
        }
        if (priv.getAlgorithm().equalsIgnoreCase("EC") || priv.getAlgorithm().equalsIgnoreCase("ECDSA")) {
            PrivateKey priv2 = priv;
            ECPoint Q = null;
            ECParameterSpec ecSpec = null;
            KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", (Provider)new BouncyCastleProvider());
            if (priv instanceof PureSWKey) {
                priv2 = ((PureSWKey)priv).getPrivateKeySpi();
            }
            if (priv2 instanceof java.security.interfaces.ECPrivateKey) {
                PrivateKeyInfo info = PrivateKeyInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])priv2.getEncoded()));
                String curveName = ECNamedCurveTable.getName((ASN1ObjectIdentifier)((ASN1ObjectIdentifier)info.getPrivateKeyAlgorithm().getParameters().toASN1Primitive()));
                ecSpec = org.bouncycastle.jce.ECNamedCurveTable.getParameterSpec((String)curveName);
                Q = ecSpec.getG().multiply(((java.security.interfaces.ECPrivateKey)priv2).getS());
            }
            if (priv2 instanceof ECPrivateKey) {
                ecSpec = ((ECPrivateKey)priv2).getParameters();
                Q = ecSpec.getG().multiply(((ECPrivateKey)priv2).getD());
            }
            byte[] publicDerBytes = Q.getEncoded(false);
            ECPoint point = ecSpec.getCurve().decodePoint(publicDerBytes);
            ECPublicKeySpec pubSpec = new ECPublicKeySpec(point, ecSpec);
            return (ECPublicKey)keyFactory.generatePublic((KeySpec)pubSpec);
        }
        throw new InvalidKeyException("Unsupported Key Type");
    }
}

