/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsl;

import it.actalis.ellips.capi.certdb.CertDBItem;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class TSPService {
    private String name;
    private String status;
    private String type;
    private LinkedList<X509Certificate> certificates;
    private LinkedList<String> additionalServiceInfo;
    private String tslId;

    public TSPService(String name) {
        this.name = name;
        this.status = "";
        this.type = "";
        this.tslId = "";
        this.certificates = new LinkedList();
        this.additionalServiceInfo = new LinkedList();
    }

    public String getName() {
        return this.name;
    }

    protected void setCertificates(LinkedList<X509Certificate> certs) {
        this.certificates = certs;
    }

    public LinkedList<X509Certificate> getCertificates() {
        return this.certificates;
    }

    protected void setStatus(String name) {
        this.status = name;
    }

    public String getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public LinkedList<String> getAdditionalServiceInfo() {
        return this.additionalServiceInfo;
    }

    public void setAdditionalServiceInfo(LinkedList<String> additionalServiceInfo) {
        this.additionalServiceInfo = additionalServiceInfo;
    }

    public String getTslId() {
        return this.tslId;
    }

    public void setTslId(String tslId) {
        this.tslId = tslId;
    }

    public List<CertDBItem.EllipsUsage> getEllipsUsagesForService() {
        ArrayList<CertDBItem.EllipsUsage> ellipsUsages = new ArrayList<CertDBItem.EllipsUsage>();
        switch (this.getType()) {
            case "http://uri.etsi.org/TrstSvc/Svctype/CA/QC": {
                LinkedList<String> addSrvInfo = this.getAdditionalServiceInfo();
                if (addSrvInfo.isEmpty()) {
                    ellipsUsages.add(CertDBItem.EllipsUsage.QUALIFIED_SIGNATURE);
                } else if (addSrvInfo.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSignatures") && addSrvInfo.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSeals")) {
                    ellipsUsages.add(CertDBItem.EllipsUsage.QUALIFIED_SIGNATURE);
                } else if (addSrvInfo.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSignatures")) {
                    ellipsUsages.add(CertDBItem.EllipsUsage.QUALIFIED_SIGNATURE_ONLY);
                } else if (addSrvInfo.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSeals")) {
                    ellipsUsages.add(CertDBItem.EllipsUsage.SEAL_SIGNATURE);
                } else {
                    ellipsUsages.add(CertDBItem.EllipsUsage.GENERIC_TRUSTED_ROOT);
                }
                ellipsUsages.add(CertDBItem.EllipsUsage.FEA_SIGNATURE);
                break;
            }
            case "http://uri.etsi.org/TrstSvc/Svctype/TSA/TSS-QC": 
            case "http://uri.etsi.org/TrstSvc/Svctype/TSA/QTST": {
                ellipsUsages.add(CertDBItem.EllipsUsage.QUALIFIED_TIME_STAMP);
                ellipsUsages.add(CertDBItem.EllipsUsage.FEA_SIGNATURE);
                break;
            }
            case "http://uri.etsi.org/TrstSvc/Svctype/IdV": {
                ellipsUsages.add(CertDBItem.EllipsUsage.CNS_AUTHENTICATION);
                break;
            }
        }
        return ellipsUsages;
    }
}

