/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.DateSource;
import esecurity.validator.ValidationDate;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class StepX509ValidationTime
extends MultipleValidationSubStepImpl {
    public StepX509ValidationTime() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
        format.setTimeZone(param.getTimeZone());
        LinkedList<ValidatorMessage> objReturn = new LinkedList<ValidatorMessage>();
        if (param != null) {
            if (param.getSignerCertificate() != null) {
                if (param.getCalculatedValidationDate() == null) {
                    if (param.getValidationDate() == null) {
                        ValidationDate vDate = new ValidationDate(new Date(), DateSource.SYSTEM);
                        param.setCalculatedValidationDate(vDate);
                        objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0011_CERT_VALIDATION_SYSTEM_DATE, param.getCalculatedValidationDate().getDate()));
                    } else {
                        ValidationDate vDate = new ValidationDate(param.getValidationDate().getDate(), DateSource.CUSTOM);
                        param.setCalculatedValidationDate(vDate);
                        objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0012_CERT_VALIDATION_CUSTOM_DATE, param.getCalculatedValidationDate().getDate()));
                    }
                } else {
                    if (param.getCalculatedValidationDate().getDateSource() == DateSource.SYSTEM) {
                        objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0011_CERT_VALIDATION_SYSTEM_DATE, param.getCalculatedValidationDate().getDate()));
                        objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0016_CERT_VALIDATION, param.getSignature().getSignatureDate()));
                    }
                    if (param.getCalculatedValidationDate().getDateSource() == DateSource.CUSTOM) {
                        objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0012_CERT_VALIDATION_CUSTOM_DATE, param.getCalculatedValidationDate().getDate()));
                    }
                    if (param.getCalculatedValidationDate().getDateSource() == DateSource.TIMESTAMP) {
                        objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0013_CERT_VALIDATION_TIMESTAMP_DATE, param.getCalculatedValidationDate().getDate()));
                    }
                }
            } else {
                objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0008_NOSIGNERCERTIFICATE, new Object[0]));
            }
        } else {
            objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
        }
        return objReturn;
    }
}

