/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.ValidationDate;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class StepX509TimeValidity
extends MultipleValidationSubStepImpl {
    public StepX509TimeValidity() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
        format.setTimeZone(param.getTimeZone());
        LinkedList<ValidatorMessage> objReturn = new LinkedList<ValidatorMessage>();
        if (param != null) {
            if (param.getSignerCertificate() != null) {
                ValidationDate vDate = param.getCalculatedValidationDate();
                try {
                    param.getSignerCertificate().setCertTimeValid(true);
                    Date validationDate = vDate.getDate();
                    if (validationDate.before(param.getSignerCertificate().getCert().getInternalCert().getNotBefore()) || validationDate.after(param.getSignerCertificate().getCert().getInternalCert().getNotAfter())) {
                        param.getSignerCertificate().setCertTimeValid(false);
                        objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0005_CERT_NOT_TIME_VALID, new Object[0]));
                        objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0014_CERT_VALIDATION_TO_DATE, new Object[0]));
                    }
                }
                catch (Exception ex) {
                    objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
                }
            } else {
                objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
            }
        } else {
            objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
        }
        return objReturn;
    }
}

