/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

public class StepX509SubjectDNCheck
extends MultipleValidationSubStepImpl {
    public StepX509SubjectDNCheck() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        LinkedList<ValidatorMessage> msg = new LinkedList<ValidatorMessage>();
        if (param != null && param.getSignerCertificate() != null && param.getSignature() == null || param.getSignature().getFormat() != null && !param.getSignature().getFormat().equals((Object)SignatureFormat.TST)) {
            if (param.getSignerCertificate().getCert().getInternalCert().getNotBefore().before(Constants.DPCM_AGID_189_2017_DEADLINE)) {
                return msg;
            }
            if (param.getSignerCertificate().getCert().getQcStatementSemanticIdentifier() != null && param.getSignerCertificate().getCert().getQcStatementSemanticIdentifier().equals("0.4.0.194121.1.2")) {
                List<String> nra = param.getSignerCertificate().getCert().getQcStatementNameRegistrationAuthorities();
                boolean valid = false;
                try {
                    String[] c = param.getSignerCertificate().getCert().getIssuerDNAttribute(X509ObjectIdentifiers.countryName.getId());
                    String[] o = param.getSignerCertificate().getCert().getIssuerDNAttribute(X509ObjectIdentifiers.organization.getId());
                    String[] cn = param.getSignerCertificate().getCert().getIssuerDNAttribute(X509ObjectIdentifiers.commonName.getId());
                    String[] organizationIdentifier = param.getSignerCertificate().getCert().getIssuerDNAttribute("2.5.4.97");
                    if (c != null && c.length == 1 && o != null && o.length == 1 && cn != null && cn.length == 1 && organizationIdentifier != null && organizationIdentifier.length == 1) {
                        String orgId = organizationIdentifier[0];
                        valid = orgId != null && orgId.length() > 6 && orgId.charAt(5) == '-' && (orgId.toUpperCase().startsWith("VAT") || orgId.toUpperCase().startsWith("NTR") || orgId.charAt(2) == ':' && nra != null && nra.size() > 0 && nra.get(0) != null);
                    }
                }
                catch (CapiException e) {
                    valid = false;
                }
                if (!valid) {
                    msg.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0020_INVALID_CERT_LEGAL_SEMANTIC, new Object[0]));
                }
            } else if (param.getSignerCertificate().getCert().getQcStatementSemanticIdentifier() != null && param.getSignerCertificate().getIssuer().getCert().getQcStatementSemanticIdentifier().equals("0.4.0.194121.1.1")) {
                List<String> nra = param.getSignerCertificate().getCert().getQcStatementNameRegistrationAuthorities();
                boolean valid = false;
                try {
                    String[] c = param.getSignerCertificate().getCert().getSubjectDNAttribute(X509ObjectIdentifiers.countryName.getId());
                    String[] serialNumbers = param.getSignerCertificate().getCert().getSubjectDNAttribute("2.5.4.5");
                    String[] cn = param.getSignerCertificate().getCert().getSubjectDNAttribute(X509ObjectIdentifiers.commonName.getId());
                    String[] givenName = null;
                    try {
                        givenName = param.getSignerCertificate().getCert().getSubjectDNAttribute("2.5.4.42");
                    }
                    catch (CapiException orgId) {
                        // empty catch block
                    }
                    String[] surname = null;
                    try {
                        surname = param.getSignerCertificate().getCert().getSubjectDNAttribute("2.5.4.4");
                    }
                    catch (CapiException capiException) {
                        // empty catch block
                    }
                    String[] pseudonym = null;
                    try {
                        pseudonym = param.getSignerCertificate().getCert().getSubjectDNAttribute("2.5.4.65");
                    }
                    catch (CapiException capiException) {
                        // empty catch block
                    }
                    if (c != null && c.length == 1 && serialNumbers != null && serialNumbers.length == 1 && cn != null && cn.length == 1 && (givenName != null && givenName.length == 1 && surname != null && surname.length == 1 || pseudonym != null && pseudonym.length == 1)) {
                        String serialNumber = serialNumbers[0];
                        valid = serialNumber != null && serialNumber.length() > 6 && serialNumber.charAt(5) == '-' && (serialNumber.toUpperCase().startsWith("PAS") || serialNumber.toUpperCase().startsWith("IDC") || serialNumber.toUpperCase().startsWith("PNO") || serialNumber.toUpperCase().startsWith("VAT") || serialNumber.toUpperCase().startsWith("TIN") || serialNumber.charAt(2) == ':' && nra != null && nra.size() > 0 && nra.get(0) != null);
                    }
                }
                catch (CapiException e) {
                    valid = false;
                }
                if (!valid) {
                    msg.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0019_INVALID_CERT_NATURAL_SEMANTIC, new Object[0]));
                }
            } else if (param.getSignerCertificate().getCert().getQcStatementSemanticIdentifier() == null && param.getSignerCertificate().getCert().getInternalCert().getNotBefore().before(Constants.DPCM_AGID_121_2019)) {
                boolean snValid = true;
                boolean orgValid = true;
                try {
                    String[] serialNumbers = param.getSignerCertificate().getCert().getSubjectDNAttribute("2.5.4.5");
                    if (serialNumbers != null && serialNumbers.length == 1) {
                        snValid = false;
                        String serialNumber = serialNumbers[0];
                        if (serialNumber != null && serialNumber.length() > 6 && serialNumber.charAt(5) == '-' && (serialNumber.toUpperCase().startsWith("PAS") || serialNumber.toUpperCase().startsWith("IDC") || serialNumber.toUpperCase().startsWith("PNO") || serialNumber.toUpperCase().startsWith("TIN") || serialNumber.charAt(2) == ':')) {
                            snValid = true;
                        }
                    }
                }
                catch (CapiException e) {
                    snValid = false;
                }
                try {
                    String[] organizationIdentifier = param.getSignerCertificate().getCert().getIssuerDNAttribute("2.5.4.97");
                    if (organizationIdentifier != null && organizationIdentifier.length == 1) {
                        orgValid = false;
                        String orgId = organizationIdentifier[0];
                        if (orgId != null && orgId.length() > 6 && orgId.charAt(5) == '-' && (orgId.toUpperCase().startsWith("VAT") || orgId.toUpperCase().startsWith("NTR") || orgId.charAt(2) == ':')) {
                            orgValid = true;
                        }
                    }
                }
                catch (CapiException e) {
                    orgValid = false;
                }
                if (!orgValid || !snValid) {
                    msg.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0006_SERIALNUMBER_NOT_COMPLIANT, new Object[0]));
                }
            }
            boolean dnQualifierCheck = false;
            try {
                if (param.getSignerCertificate().getCert().getSubjectDNAttribute("2.5.4.46") != null && param.getSignerCertificate().getCert().getSubjectDNAttribute("2.5.4.46").length > 0) {
                    dnQualifierCheck = true;
                }
            }
            catch (CapiException capiException) {
                // empty catch block
            }
            if (!dnQualifierCheck) {
                msg.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0009_DNQUALIFIER_NOT_PRESENT, new Object[0]));
            }
        }
        return msg;
    }
}

