/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import java.util.LinkedList;

public class StepX509DPCM189KeyLengthCompliance
extends SingleValidationSubStepImpl {
    public StepX509DPCM189KeyLengthCompliance() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        String encAlg;
        Date notBefore;
        if (param != null && param.getSignerCertificate() != null && (notBefore = param.getSignerCertificate().getCert().getInternalCert().getNotBefore()).after(Constants.DPCM_AGID_189_2017_DEADLINE) && notBefore.before(Constants.DPCM_AGID_121_2019) && (encAlg = param.getSignerCertificate().getCert().getPublicKey().getAlgorithm()) != null) {
            int minKeyLength = 2048;
            if (encAlg.equalsIgnoreCase("EC")) {
                minKeyLength = 0;
            }
            if (param.getSignerCertificate().getCert().getKeyLength() < minKeyLength) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.EC0016_INVALID_CERT_KEY_LENGTH, new Object[0]);
            }
        }
        return null;
    }
}

