/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.parser.tsa;

import esecurity.validator.parser.SignatureParserBuilder;
import esecurity.validator.parser.annotations.ParserBuilderOrder;
import esecurity.validator.parser.tsa.TSRParser;
import esecurity.validator.parser.utils.DerParserUtils;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import org.slf4j.Logger;

@ParserBuilderOrder(order=2)
public class TSRParserBuilder
extends SignatureParserBuilder {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    @Override
    public TSRParser build(InputHandler input) {
        try {
            String object_id = DerParserUtils.retrieveDerID(input, true);
            if (object_id == null || !object_id.equals("1.2.840.113549.1.9.16.1.4")) {
                return null;
            }
            return new TSRParser(this);
        }
        catch (CapiException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }
}

