/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.parser.tsa;

import esecurity.dts.TimeStampToken;
import esecurity.validator.bean.ParsedTransientDocument;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.parser.SignatureParser;
import esecurity.validator.parser.SignatureParserBuilder;
import esecurity.validator.parser.utils.EventHandlerSelector;
import esecurity.validator.parser.utils.EventHandlerSelectorWithMatcher;
import esecurity.validator.parser.utils.FileSignatureMatcher;
import esecurity.validator.parser.utils.ParserUtils;
import esecurity.validator.parser.utils.TSTUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.exception.ParsingException;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.slf4j.Logger;

public class TSRParser
extends SignatureParser {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private DateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");

    public TSRParser(SignatureParserBuilder builder) {
        super(builder);
        this.df.setTimeZone(Constants.DEFAULT_TIMEZONE);
    }

    @Override
    public ParsedTransientDocument parse(InputHandler source, EventHandlerSelector handlerSelector, NetworkConfig config, TimeZone timeZone, File tmpFolder) throws ParsingException {
        ParsedTransientDocument doc = new ParsedTransientDocument(source);
        InputHandler handler = null;
        try {
            if (!(handlerSelector instanceof EventHandlerSelectorWithMatcher)) {
                handler = handlerSelector.selectHandler();
            } else {
                final InputHandler sourceFinal = source;
                final TimeStampToken tstToken = new TimeStampToken(Util.getBytesFromInputStream(sourceFinal.getInputAsNewStream()));
                final byte[] tstDigest = tstToken.getHashedMessage();
                handler = ((EventHandlerSelectorWithMatcher)handlerSelector).selectHandler(new FileSignatureMatcher(){

                    @Override
                    public boolean match(InputHandler inputHandler) {
                        try {
                            return tstToken.compare(inputHandler.getInputAsNewStream());
                        }
                        catch (Throwable t) {
                            logger.error(t.getMessage(), t);
                            return false;
                        }
                    }

                    @Override
                    public InputHandler getCurrentHandler() {
                        return sourceFinal;
                    }

                    @Override
                    public byte[] getCurrentHash() {
                        return tstDigest;
                    }
                }, source.getName());
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        if (timeZone != null) {
            this.df.setTimeZone(timeZone);
        }
        TransientDocument subDoc = null;
        String subDocId = null;
        try {
            subDoc = ParserUtils.parseDoc(handler, handlerSelector, config, this.df.getTimeZone(), tmpFolder);
            doc.setSigned(true);
            doc.addRefDoc(subDoc);
            subDocId = subDoc.getId();
        }
        catch (Exception tstDigest) {
            // empty catch block
        }
        try {
            SignatureInformation si = TSTUtils.tstToVol(doc, Util.getBytesFromInputStream(source.getInputAsNewStream()), handler, subDocId, this.df);
            doc.addSignerInfo(si);
        }
        catch (Exception ex) {
            throw new ParsingException("Unable to parse file", ex);
        }
        return doc;
    }
}

