/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.http.arubautils.provider;

import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.NullTrustManager;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.ellips.capi.http.arubautils.provider.DownloadProgressNotifier;
import it.actalis.ellips.capi.http.arubautils.provider.MultipartWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.HashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HTTPProvider {
    public static final String CRLF = "\r\n";
    protected NetworkConfig conf;
    protected static Logger logger;
    protected static final NullTrustManager nullManager;
    protected static final TrustManager[] nullTrustManager;
    private static final Logger logger2;
    protected SSLSocketFactory defaultSocketFactory = null;
    protected boolean sslHallHostVerified = false;
    protected boolean sslTrustAllRoot = false;
    protected TrustManager[] tm = null;
    protected static HashMap<TrustManager[], SSLSocketFactory> sfactorymap;
    protected static HashMap<KeyStore, TrustManager[]> trustmanagermap;

    public HTTPProvider(NetworkConfig conf, Logger logger) {
        this.conf = conf;
        HTTPProvider.logger = logger == null ? logger2 : logger;
    }

    public boolean isSslHallHostVerified() {
        return this.sslHallHostVerified;
    }

    public void setSslHallHostVerified(boolean sslHallHostVerified) {
        this.sslHallHostVerified = sslHallHostVerified;
    }

    public boolean isSslTrustAllRoot() {
        return this.sslTrustAllRoot;
    }

    public void setSslTrustAllRoot(boolean sslTrustAllRoot) {
        this.defaultSocketFactory = null;
        this.sslTrustAllRoot = sslTrustAllRoot;
    }

    protected SSLSocketFactory getDefaultSF() {
        SSLContext sc;
        if (this.defaultSocketFactory == null && (sc = this.getDefaultSSLContext()) != null) {
            this.defaultSocketFactory = sc.getSocketFactory();
        }
        return this.defaultSocketFactory;
    }

    protected SSLContext getDefaultSSLContext() {
        try {
            SSLContext sc = null;
            sc = System.getProperty("java.vm.vendor").contains("IBM") ? SSLContext.getInstance("TLSv1") : SSLContext.getInstance("SSL");
            if (this.sslTrustAllRoot) {
                this.tm = nullTrustManager;
                sc.init(null, this.tm, null);
            } else {
                sc.init(null, this.tm, null);
            }
            return sc;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public void setTrustStore(KeyStore store) {
        boolean createTM = false;
        if (trustmanagermap.get(store) != null) {
            this.tm = trustmanagermap.get(store);
            return;
        }
        TrustManagerFactory tmf = null;
        this.defaultSocketFactory = null;
        try {
            tmf = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
            tmf.init(store);
            this.tm = tmf.getTrustManagers();
            createTM = true;
        }
        catch (Exception ex) {
            try {
                logger.debug("Impossibile istanziare il provider ORACLE provo a instaziare il provider IBM");
                tmf = TrustManagerFactory.getInstance("IbmX509");
                tmf.init(store);
                this.tm = tmf.getTrustManagers();
                createTM = true;
            }
            catch (Exception ex2) {
                logger.error(ex2.getMessage(), (Throwable)ex2);
            }
        }
        if (createTM) {
            trustmanagermap.put(store, this.tm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UrlReturn downloadHttp(URL url, RequestData rdate, URLCredentials credentials) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        ByteArrayOutputStream objOut = null;
        UrlReturn objReturn = new UrlReturn();
        objReturn.setStatus("KO");
        try {
            objOut = new ByteArrayOutputStream();
            objReturn = this.downloadHttp(url, rdate, credentials, objOut, null);
            objOut.close();
            if (objReturn.getStatus().equals("OK")) {
                objReturn.setData(objOut.toByteArray());
            }
        }
        finally {
            objOut.close();
        }
        return objReturn;
    }

    protected void setProxyConfiguration(String connectionType, String host, String port, String proxyType) {
        if (connectionType.equalsIgnoreCase("http")) {
            this.conf.setProxy(host);
            this.conf.setProxyPort(port);
            this.conf.setProxyType(proxyType);
        } else if (connectionType.equalsIgnoreCase("ldap")) {
            this.conf.setLdapProxy(host);
            this.conf.setLdapProxyPort(port);
            this.conf.setLdapProxyType(proxyType);
        }
    }

    public void setNetworkConfig(NetworkConfig config) {
        this.conf = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UrlReturn urlRequest(URL url, String method, RequestData rdate, URLCredentials credentials) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        ByteArrayOutputStream objOut = null;
        UrlReturn objReturn = new UrlReturn();
        objReturn.setStatus("KO");
        try {
            objOut = new ByteArrayOutputStream();
            objReturn = this.urlRequest(url, method, rdate, credentials, objOut, null);
            objOut.close();
            if (objReturn.getStatus().equals("OK")) {
                objReturn.setData(objOut.toByteArray());
            }
        }
        finally {
            objOut.close();
        }
        return objReturn;
    }

    public UrlReturn downloadHttp(URL url, RequestData rdate, URLCredentials credentials, OutputStream os, DownloadProgressNotifier notifier) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        return this.urlRequest(url, null, rdate, credentials, os, notifier);
    }

    public abstract UrlReturn urlRequest(URL var1, String var2, RequestData var3, URLCredentials var4, OutputStream var5, DownloadProgressNotifier var6) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException, UnrecoverableKeyException, KeyManagementException, URISyntaxException;

    public abstract Date getLastModifiedDate(URL var1, URLCredentials var2) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException;

    public abstract Date getLastModifiedDate(String var1, URLCredentials var2) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException;

    public abstract Long getContentLengthLong(URL var1, URLCredentials var2) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException;

    public abstract Long getContentLengthLong(String var1, URLCredentials var2) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException;

    public abstract Proxy fech_proxy(URL var1);

    public abstract InputStream getInputStream(URL var1, URLCredentials var2) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException;

    public abstract MultipartWrapper getMultipartWrapper(URL var1, URLCredentials var2) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException;

    public abstract HttpURLConnection getHttpURLConnection(URL var1, URLCredentials var2) throws IOException, KeyManagementException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, URISyntaxException;

    protected SSLSocketFactory getSocketFactory(TrustManager[] tm) {
        return sfactorymap.get(tm);
    }

    protected void setSocketFactory(TrustManager[] tm, SSLSocketFactory sf) {
        sfactorymap.put(tm, sf);
    }

    static {
        nullManager = new NullTrustManager();
        nullTrustManager = new TrustManager[]{nullManager};
        logger2 = LoggerFactory.getLogger(HTTPProvider.class);
        sfactorymap = new HashMap();
        trustmanagermap = new HashMap();
    }
}

