/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.asic.parser;

import esecurity.validator.bean.ParsedTransientDocument;
import esecurity.validator.bean.RefCRL;
import esecurity.validator.bean.RefCertificate;
import esecurity.validator.bean.RefOcsp;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.constants.ContainerFormat;
import esecurity.validator.parser.SignatureParser;
import esecurity.validator.parser.SignatureParserBuilder;
import esecurity.validator.parser.utils.EventHandlerSelector;
import esecurity.validator.parser.utils.ParserUtils;
import it.actalis.ellips.capi.asic.ASiCFormat;
import it.actalis.ellips.capi.asic.ASiCSignatureType;
import it.actalis.ellips.capi.asic.envelope.ASiCContainer;
import it.actalis.ellips.capi.asic.envelope.ASiCEContainer;
import it.actalis.ellips.capi.asic.envelope.ASiCSContainer;
import it.actalis.ellips.capi.asic.parser.ASiCInternalParser;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.exception.ParsingException;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.naming.OperationNotSupportedException;
import org.slf4j.Logger;

public class ASiCParser
extends SignatureParser {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private DateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
    private ASiCContainer container;

    public ASiCParser(SignatureParserBuilder builder) {
        super(builder);
        this.df.setTimeZone(Constants.DEFAULT_TIMEZONE);
        this.container = null;
    }

    public ParsedTransientDocument parse(InputHandler source, EventHandlerSelector fileSelector, NetworkConfig config, TimeZone timeZone, File tmpFolder) throws ParsingException {
        ASiCInternalParser parser = new ASiCInternalParser(config, timeZone);
        ParsedTransientDocument doc = new ParsedTransientDocument(source);
        if (timeZone != null) {
            this.df.setTimeZone(timeZone);
        }
        try {
            this.container = parser.parse(source);
        }
        catch (CapiException ex) {
            doc.setSigned(false);
        }
        if (this.container != null) {
            switch (this.container.getOpts().getFormat()) {
                case SIMPLE: {
                    this.parseASicS(doc, (ASiCSContainer)this.container, fileSelector, config, timeZone, tmpFolder);
                    break;
                }
                case EXTENDED: {
                    this.parseASicE(doc, (ASiCEContainer)this.container, fileSelector, config, timeZone, tmpFolder);
                    break;
                }
                default: {
                    doc.setSigned(false);
                }
            }
        }
        for (int iSig = 0; iSig < doc.getSignerInfo().size(); ++iSig) {
            ((SignatureInformation)doc.getSignerInfo().get(iSig)).setContainerFormat(ContainerFormat.ASIC);
        }
        return doc;
    }

    private void parseASicS(ParsedTransientDocument doc, ASiCSContainer asics, EventHandlerSelector fileSelector, NetworkConfig config, TimeZone timeZone, File tmpFolder) {
        ASiCSignatureType type = asics.getOpts().getSignatureType();
        try {
            switch (type) {
                case CADES: {
                    this.parseCadesEntry(doc, asics.getFilename(), asics.getCadesTransientDocument(), asics.getContentStream(), true, fileSelector, config, tmpFolder);
                    break;
                }
                case TIMESTAMP: {
                    this.parseTstEntry(doc, asics.getFilename(), asics.getTimestampTransientDocument(), asics.getContentStream(), true, fileSelector, config, tmpFolder);
                    break;
                }
                case XADES: {
                    this.parseXmlEntry(doc, asics.getFilename(), asics.getXadesTransientDocument(), asics.getContentStream(), true, fileSelector, config, timeZone, tmpFolder);
                    break;
                }
                default: {
                    logger.error("Unrecognized sign type: [" + (Object)((Object)type) + "]");
                    doc.setSigned(false);
                    break;
                }
            }
        }
        catch (OperationNotSupportedException ex) {
            doc.setSigned(false);
        }
        catch (IOException ex) {
            doc.setSigned(false);
        }
    }

    private void parseASicE(ParsedTransientDocument doc, ASiCEContainer asice, EventHandlerSelector fileSelector, NetworkConfig config, TimeZone timeZone, File tmpFolder) {
        ASiCSignatureType type = asice.getOpts().getSignatureType();
        try {
            switch (type) {
                case CADES: {
                    for (String name : asice.getCadesTransientDocuments().keySet()) {
                        this.parseCadesEntry(doc, name, asice.getCadesTransientDocuments().get(name), asice.getContentStream(name), asice.getHashVerified(name), fileSelector, config, tmpFolder);
                    }
                    break;
                }
                case TIMESTAMP: {
                    for (String name : asice.getTimestampTransientDocuments().keySet()) {
                        this.parseTstEntry(doc, name, asice.getTimestampTransientDocuments().get(name), asice.getContentStream(name), asice.getHashVerified(name), fileSelector, config, tmpFolder);
                    }
                    break;
                }
                case XADES: {
                    for (String name : asice.getXadesTransientDocuments().keySet()) {
                        this.parseXmlEntry(doc, name, asice.getXadesTransientDocuments().get(name), asice.getContentStream(name), asice.getHashVerified(name), fileSelector, config, timeZone, tmpFolder);
                    }
                    break;
                }
                default: {
                    logger.error("Unrecognized sign type: [" + (Object)((Object)type) + "]");
                    doc.setSigned(false);
                }
            }
            for (String name : asice.getUnsignedDocs()) {
                this.checkSubContent(doc, name, asice.getContentStream(name), fileSelector, config, tmpFolder);
            }
            for (String name : asice.getSignedDocs()) {
                this.checkSubContent(doc, name, asice.getContentStream(name), fileSelector, config, tmpFolder);
            }
        }
        catch (OperationNotSupportedException ex) {
            doc.setSigned(false);
        }
        catch (IOException ex) {
            doc.setSigned(false);
        }
    }

    private void parseCadesEntry(ParsedTransientDocument doc, String name, ParsedTransientDocument env, InputStream is, boolean hashValid, EventHandlerSelector fileSelector, NetworkConfig config, File tmpFolder) {
        if (this.container.getOpts().getFormat() == ASiCFormat.SIMPLE) {
            this.checkSubContent(doc, name, is, fileSelector, config, tmpFolder);
        }
        try {
            for (RefCertificate cert : env.getCerts()) {
                doc.addCert(cert);
            }
            if (env.isSigned()) {
                doc.setSigned(true);
                for (SignatureInformation si : env.getSignerInfo()) {
                    doc.addSignerInfo(si);
                }
                for (RefCRL crl : env.getCrls()) {
                    doc.addCrl(crl);
                }
                for (RefOcsp ocsp : env.getOcspresps()) {
                    doc.addOcspresp(ocsp);
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void parseTstEntry(ParsedTransientDocument doc, String name, ParsedTransientDocument env, InputStream is, boolean hashValid, EventHandlerSelector fileSelector, NetworkConfig config, File tmpFolder) {
        if (this.container.getOpts().getFormat() == ASiCFormat.SIMPLE) {
            this.checkSubContent(doc, name, is, fileSelector, config, tmpFolder);
        }
        try {
            for (RefCertificate cert : env.getCerts()) {
                doc.addCert(cert);
            }
            if (env.isSigned()) {
                doc.setSigned(true);
                for (SignatureInformation si : env.getSignerInfo()) {
                    doc.addSignerInfo(si);
                }
                for (RefCRL crl : env.getCrls()) {
                    doc.addCrl(crl);
                }
                for (RefOcsp ocsp : env.getOcspresps()) {
                    doc.addOcspresp(ocsp);
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private TransientDocument parseXmlEntry(ParsedTransientDocument doc, String name, ParsedTransientDocument xmlTransientDocument, InputStream is, boolean hashValid, EventHandlerSelector fileSelector, NetworkConfig config, TimeZone timeZone, File tmpFolder) {
        TransientDocument subDoc = this.checkSubContent(doc, name, is, fileSelector, config, tmpFolder);
        try {
            if (xmlTransientDocument.isSigned()) {
                doc.setSigned(true);
                for (TransientDocument xmlRefDoc : xmlTransientDocument.getRefsDocs()) {
                    boolean found = false;
                    for (TransientDocument refDoc : doc.getRefsDocs()) {
                        if (!refDoc.getId().equals(xmlRefDoc.getId())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    doc.addRefDoc(xmlRefDoc);
                }
                for (RefCertificate cert : xmlTransientDocument.getCerts()) {
                    doc.addCert(cert);
                }
                for (SignatureInformation si : xmlTransientDocument.getSignerInfo()) {
                    doc.addSignerInfo(si);
                }
                for (RefCRL crl : xmlTransientDocument.getCrls()) {
                    doc.addCrl(crl);
                }
                for (RefOcsp ocsp : xmlTransientDocument.getOcspresps()) {
                    doc.addOcspresp(ocsp);
                }
            }
            return subDoc;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private TransientDocument checkSubContent(ParsedTransientDocument doc, String name, InputStream is, EventHandlerSelector fileSelector, NetworkConfig config, File tmpFolder) {
        TransientDocument subDoc;
        try {
            InputHandler ih = DataHandlerBuilder.get().setInputStream(is).setName(name).buildInput();
            subDoc = ParserUtils.parseDoc((InputHandler)ih, (EventHandlerSelector)fileSelector, (NetworkConfig)config, (TimeZone)this.df.getTimeZone(), (File)tmpFolder);
            boolean found = false;
            for (TransientDocument refDoc : doc.getRefsDocs()) {
                if (!refDoc.getId().equals(subDoc.getId())) continue;
                found = true;
                break;
            }
            if (!found) {
                doc.addRefDoc(subDoc);
            }
        }
        catch (Exception ex) {
            logger.error("Errore parsing entry {}", (Object)name);
            subDoc = new TransientDocument();
            subDoc.setShortName(name);
            subDoc.setId(name);
            doc.addRefDoc(subDoc);
        }
        return subDoc;
    }

    public ASiCContainer getASiCContainer() {
        return this.container;
    }
}

